-- MySQL dump 10.13  Distrib 5.7.44, for Linux (x86_64)
--
-- Host: localhost    Database: erp_cliente_77861264K
-- ------------------------------------------------------
-- Server version	5.7.44

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `tbl_activofijo`
--

DROP TABLE IF EXISTS `tbl_activofijo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_activofijo` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `marca` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `modelo` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `estanque` int(10) NOT NULL DEFAULT '0',
  `vida_util` int(3) NOT NULL DEFAULT '0',
  `valor_r` int(10) NOT NULL DEFAULT '0',
  `valor_hora` int(10) NOT NULL COMMENT 'valor hora de la maquina',
  `tipo_depreciacion` int(1) NOT NULL DEFAULT '0',
  `id_proyecto` int(10) NOT NULL,
  `sw_impuesto_especifico` int(1) NOT NULL,
  `unidad_medida` char(2) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `id_proyecto` (`id_proyecto`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_activofijo`
--

LOCK TABLES `tbl_activofijo` WRITE;
/*!40000 ALTER TABLE `tbl_activofijo` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_activofijo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_afp`
--

DROP TABLE IF EXISTS `tbl_afp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_afp` (
  `id_afp` int(10) NOT NULL AUTO_INCREMENT,
  `afp` varchar(25) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `tasa_normal` decimal(10,2) NOT NULL DEFAULT '0.00',
  `tasa_jubilado` decimal(10,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id_afp`),
  UNIQUE KEY `id_afp` (`id_afp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_afp`
--

LOCK TABLES `tbl_afp` WRITE;
/*!40000 ALTER TABLE `tbl_afp` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_afp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_alertas`
--

DROP TABLE IF EXISTS `tbl_alertas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_alertas` (
  `id_registro` int(10) NOT NULL AUTO_INCREMENT,
  `id_alerta` int(10) NOT NULL DEFAULT '0',
  `id_remitente` int(10) NOT NULL DEFAULT '0',
  `id_destinatario` int(10) NOT NULL DEFAULT '0',
  `estado` varchar(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'PE=pendiente PO=postergado EJ=ejecutado RE=rechazado',
  `id_alarma` int(10) NOT NULL DEFAULT '0' COMMENT 'hora y fecha de activacion de la alarma',
  `documento` varchar(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'Documento que generó el alerta',
  `folio` int(10) NOT NULL DEFAULT '0' COMMENT 'Folio del documento que generó el alerta',
  `asunto` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `comentarios` text COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'accion solicitada',
  `url_destino` text COLLATE utf8_spanish_ci NOT NULL,
  `ejecutar` int(11) NOT NULL DEFAULT '0' COMMENT 'accion que realizara el usuario 1-Ejecutar o 2-Postergar',
  `postergar` int(10) NOT NULL DEFAULT '0' COMMENT 'segundos que postergo el alerta',
  UNIQUE KEY `id_registro` (`id_registro`),
  KEY `id_remitente` (`id_remitente`),
  KEY `id_destinatario` (`id_destinatario`),
  KEY `estado` (`estado`),
  KEY `id_alarma` (`id_alarma`),
  KEY `asunto` (`asunto`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_alertas`
--

LOCK TABLES `tbl_alertas` WRITE;
/*!40000 ALTER TABLE `tbl_alertas` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_alertas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_aportecesantia`
--

DROP TABLE IF EXISTS `tbl_aportecesantia`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_aportecesantia` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `tipo_contrato` int(1) NOT NULL COMMENT '1,2,3 ( menu de lista)',
  `porc_empleador` decimal(5,3) NOT NULL,
  `porc_trabajador` decimal(5,3) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_aportecesantia`
--

LOCK TABLES `tbl_aportecesantia` WRITE;
/*!40000 ALTER TABLE `tbl_aportecesantia` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_aportecesantia` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_apv`
--

DROP TABLE IF EXISTS `tbl_apv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_apv` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `tope_uf_mensual` decimal(13,3) NOT NULL,
  `tope_uf_anual` decimal(13,3) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_apv`
--

LOCK TABLES `tbl_apv` WRITE;
/*!40000 ALTER TABLE `tbl_apv` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_apv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_asignacionfam`
--

DROP TABLE IF EXISTS `tbl_asignacionfam`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_asignacionfam` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `tramo` int(1) NOT NULL COMMENT '1,2,3,4',
  `desde` int(10) NOT NULL,
  `hasta` int(10) NOT NULL,
  `monto` int(10) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_asignacionfam`
--

LOCK TABLES `tbl_asignacionfam` WRITE;
/*!40000 ALTER TABLE `tbl_asignacionfam` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_asignacionfam` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_asignar_salas`
--

DROP TABLE IF EXISTS `tbl_asignar_salas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_asignar_salas` (
  `id_sala` int(10) NOT NULL,
  `id_curso` int(10) NOT NULL,
  KEY `id_sala` (`id_sala`),
  KEY `id_curso` (`id_curso`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_asignar_salas`
--

LOCK TABLES `tbl_asignar_salas` WRITE;
/*!40000 ALTER TABLE `tbl_asignar_salas` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_asignar_salas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_asistencia_detalle`
--

DROP TABLE IF EXISTS `tbl_asistencia_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_asistencia_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `id_usuario` int(10) NOT NULL COMMENT 'id del usuario creador de la linea 1=Sistema',
  `time_creacion_registro` int(10) NOT NULL,
  `id_item` int(10) NOT NULL,
  `codigo_asistencia` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'Indica al boucher si la linea ha sido finalizada 1=Si 0=No',
  `periodo` varchar(7) COLLATE utf8_spanish_ci NOT NULL,
  `id_empleado` int(10) NOT NULL,
  `id_tipo_permiso` int(1) NOT NULL COMMENT '1=vacacion 2=licencia 3=permiso',
  `sw_inasistencia` int(1) NOT NULL COMMENT 'trabajador inasistente amanecio con la caña',
  `sw_feriado` int(1) NOT NULL COMMENT 'indica si es feriado',
  `tiempo_permiso` varchar(8) COLLATE utf8_spanish_ci NOT NULL DEFAULT '00:00:00' COMMENT 'HH:MM:SS',
  `fecha` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `cantidad_fichajes` int(2) NOT NULL COMMENT 'cantidad de fichajes realizados por dia',
  `dia_semana` int(1) NOT NULL COMMENT 'dia de la semana de 1 a 7 comenzando por San Lunes',
  `time` int(10) NOT NULL,
  `entrada_laboral` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `entro_antes` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `entro_despues` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `sw_entrada` int(1) NOT NULL DEFAULT '0' COMMENT 'validar entrada 1=aprobado 0=rechazado',
  `salida_colacion` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `entrada_colacion` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `salida_laboral` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `salio_antes` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `salio_despues` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `sw_salida` int(1) NOT NULL DEFAULT '0' COMMENT 'validar salida 1=aprobado 0=rechazado',
  `tiempo_colacion` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `tiempo_colacion_sobrante` varchar(8) COLLATE utf8_spanish_ci NOT NULL COMMENT 'tiempo sobrante cuando se tomo menos colacion o no se la tomo',
  `sw_colacionsobrante` int(1) NOT NULL,
  `sw_salioantes` int(1) NOT NULL COMMENT '1=si',
  `sw_saliodespues` int(1) NOT NULL COMMENT '1=si',
  `sw_entroantes` int(1) NOT NULL,
  `sw_entrodespues` int(1) NOT NULL,
  `tiempo_trabajado` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `tiempo_debetrabajar` varchar(8) COLLATE utf8_spanish_ci NOT NULL DEFAULT '00:00:00' COMMENT 'tiempo diario que debe trabajar',
  `tiempo_aprobado` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `colacion_aprobada` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `tiempo_resta` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `tiempo_extra` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `signo_tiempoextra` char(1) COLLATE utf8_spanish_ci NOT NULL COMMENT '-=resta +=suma',
  `jornada_entrada` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `jornada_salida` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `jornada_colacion` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `total_semanal` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT 'hh:mm:ss',
  `total_extra_semanal` varchar(12) COLLATE utf8_spanish_ci NOT NULL DEFAULT '00:00:00' COMMENT 'total diario extra acumulado',
  `total_resta_semanal` varchar(12) COLLATE utf8_spanish_ci NOT NULL DEFAULT '00:00:00',
  `tiempo_trabajado_semanal` varchar(12) COLLATE utf8_spanish_ci NOT NULL DEFAULT '00:00:00' COMMENT 'total acumulado trabajado semanalmente',
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `detalle_fichajes` varchar(255) COLLATE utf8_spanish_ci NOT NULL COMMENT 'detalle de todos los fichajes realizados en el dia',
  KEY `tiempo_colacion` (`tiempo_colacion`),
  KEY `jornada_entrada` (`jornada_entrada`),
  KEY `jornada_salida` (`jornada_salida`),
  KEY `jornada_colacion` (`jornada_colacion`),
  KEY `entro_antes` (`entro_antes`),
  KEY `entro_despues` (`entro_despues`),
  KEY `tiempo_aprobado` (`tiempo_aprobado`),
  KEY `sw_entrada` (`sw_entrada`),
  KEY `sw_salida` (`sw_salida`),
  KEY `signo_tiempoextra` (`signo_tiempoextra`),
  KEY `id` (`id`),
  KEY `colacion_aprobada` (`colacion_aprobada`),
  KEY `tiempo_resta` (`tiempo_resta`),
  KEY `id_tipo_permiso` (`id_tipo_permiso`),
  KEY `sw_inasistencia` (`sw_inasistencia`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_asistencia_detalle`
--

LOCK TABLES `tbl_asistencia_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_asistencia_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_asistencia_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_asistencia_extraautorizado`
--

DROP TABLE IF EXISTS `tbl_asistencia_extraautorizado`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_asistencia_extraautorizado` (
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL DEFAULT '1',
  `usuario_creacion` int(10) NOT NULL,
  `time_creacion` int(10) NOT NULL,
  `id_empleado` int(10) NOT NULL,
  `codigo_asistencia` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `nombre_empleado` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_tipoextra` int(1) NOT NULL COMMENT '0=ambos 1=entrada 2=salida',
  `fecha_desde` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `hora_desde` varchar(8) COLLATE utf8_spanish_ci NOT NULL COMMENT 'HH:MM:SS',
  `hora_hasta` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `tiempo_permiso` varchar(8) COLLATE utf8_spanish_ci NOT NULL COMMENT 'HH:MM:SS',
  `fecha_hasta` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `cantidad_horas` int(10) NOT NULL COMMENT 'cantidad maxima de horas por dia',
  `time_desde` int(10) NOT NULL,
  `time_hasta` int(10) NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_autorizador` int(10) NOT NULL,
  UNIQUE KEY `folio` (`folio`),
  KEY `id_empleado` (`id_empleado`),
  KEY `fecha_hasta` (`fecha_hasta`),
  KEY `observaciones` (`observaciones`),
  KEY `id_autorizador` (`id_autorizador`),
  KEY `time_desde` (`time_desde`),
  KEY `time_hasta` (`time_hasta`),
  KEY `fecha_desde` (`fecha_desde`),
  KEY `nombre_empleado` (`nombre_empleado`),
  KEY `estado` (`estado`),
  KEY `codigo_asistencia` (`codigo_asistencia`),
  KEY `cantidad_horas` (`cantidad_horas`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci COMMENT='Nivel 5';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_asistencia_extraautorizado`
--

LOCK TABLES `tbl_asistencia_extraautorizado` WRITE;
/*!40000 ALTER TABLE `tbl_asistencia_extraautorizado` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_asistencia_extraautorizado` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_asistencia_fichajes`
--

DROP TABLE IF EXISTS `tbl_asistencia_fichajes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_asistencia_fichajes` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_equipo` int(10) NOT NULL,
  `sw_manual` int(1) NOT NULL COMMENT 'fichajes ingresados manualmente',
  `time` int(10) NOT NULL,
  `codigo` varchar(5) COLLATE utf8_spanish_ci NOT NULL,
  `fecha` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `hora` varchar(6) COLLATE utf8_spanish_ci NOT NULL,
  `sw_nulo` int(1) NOT NULL COMMENT '1=si',
  UNIQUE KEY `id` (`id`),
  KEY `codigo` (`codigo`),
  KEY `fecha` (`fecha`),
  KEY `hora` (`hora`),
  KEY `time` (`time`),
  KEY `sw_manual` (`sw_manual`),
  KEY `id_equipo` (`id_equipo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_asistencia_fichajes`
--

LOCK TABLES `tbl_asistencia_fichajes` WRITE;
/*!40000 ALTER TABLE `tbl_asistencia_fichajes` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_asistencia_fichajes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_asistencia_jornadas`
--

DROP TABLE IF EXISTS `tbl_asistencia_jornadas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_asistencia_jornadas` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_turno` int(10) NOT NULL,
  `codigo_turno` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `dia_semana` int(11) NOT NULL,
  `entrada_laboral` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `salida_colacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `entrada_colacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `salida_laboral` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `id_turno` (`id_turno`),
  KEY `dia_semana` (`dia_semana`),
  KEY `codigo_turno` (`codigo_turno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_asistencia_jornadas`
--

LOCK TABLES `tbl_asistencia_jornadas` WRITE;
/*!40000 ALTER TABLE `tbl_asistencia_jornadas` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_asistencia_jornadas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_asistencia_permisos`
--

DROP TABLE IF EXISTS `tbl_asistencia_permisos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_asistencia_permisos` (
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL DEFAULT '1',
  `usuario_creacion` int(10) NOT NULL,
  `time_creacion` int(10) NOT NULL,
  `id_empleado` int(10) NOT NULL,
  `codigo_asistencia` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `nombre_empleado` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `motivo_permiso` int(10) NOT NULL,
  `fecha_desde` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `hora_desde` varchar(8) COLLATE utf8_spanish_ci NOT NULL COMMENT 'HH:MM:SS',
  `hora_hasta` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `tiempo_permiso` varchar(8) COLLATE utf8_spanish_ci NOT NULL COMMENT 'HH:MM:SS',
  `fecha_hasta` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `cantidad_dias` int(10) NOT NULL,
  `time_desde` int(10) NOT NULL,
  `time_hasta` int(10) NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_autorizador` int(10) NOT NULL,
  UNIQUE KEY `folio` (`folio`),
  KEY `id_empleado` (`id_empleado`),
  KEY `motivo_permiso` (`motivo_permiso`),
  KEY `fecha_hasta` (`fecha_hasta`),
  KEY `observaciones` (`observaciones`),
  KEY `id_autorizador` (`id_autorizador`),
  KEY `time_desde` (`time_desde`),
  KEY `time_hasta` (`time_hasta`),
  KEY `fecha_desde` (`fecha_desde`),
  KEY `cantidad_dias` (`cantidad_dias`),
  KEY `nombre_empleado` (`nombre_empleado`),
  KEY `estado` (`estado`),
  KEY `codigo_asistencia` (`codigo_asistencia`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci COMMENT='Nivel 5';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_asistencia_permisos`
--

LOCK TABLES `tbl_asistencia_permisos` WRITE;
/*!40000 ALTER TABLE `tbl_asistencia_permisos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_asistencia_permisos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_asistencia_resumen`
--

DROP TABLE IF EXISTS `tbl_asistencia_resumen`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_asistencia_resumen` (
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `periodo` varchar(7) COLLATE utf8_spanish_ci NOT NULL,
  `dias_periodo` int(2) NOT NULL DEFAULT '0' COMMENT 'cantidad de dias del periodo laboral',
  `dias_habiles` int(2) NOT NULL,
  `dias_feriados` int(2) NOT NULL,
  `dias_trabajados` int(2) NOT NULL,
  `id_empleado` int(10) NOT NULL,
  `codigo_asistencia` varchar(5) COLLATE utf8_spanish_ci NOT NULL,
  `rut_empleado` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `nombre_empleado` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `nombre_seccion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `suma_entrada_antes` varchar(8) COLLATE utf8_spanish_ci NOT NULL COMMENT 'formato hh:mm:ss',
  `suma_entrada_despues` varchar(8) COLLATE utf8_spanish_ci NOT NULL COMMENT 'formato hh:mm:ss',
  `suma_salida_antes` varchar(8) COLLATE utf8_spanish_ci NOT NULL COMMENT 'formato hh:mm:ss',
  `suma_salida_despues` varchar(8) COLLATE utf8_spanish_ci NOT NULL COMMENT 'formato hh:mm:ss',
  `dias_inasistencia` int(2) NOT NULL,
  `dias_licencia` int(2) NOT NULL,
  `dias_vacaciones` int(2) NOT NULL,
  `dias_permiso` int(2) NOT NULL,
  `signo_extra` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `total_extra` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `total_resta` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `total_final` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '' COMMENT 'total final',
  `estado` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `tiempo_trabajado` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '00:00:00' COMMENT 'tiempo total trabajado periodo',
  `hrs_sem_1` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `hrs_sem_2` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `hrs_sem_3` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `hrs_sem_4` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `hrs_sem_5` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `hrs_mes` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `folio` (`folio`),
  KEY `estado` (`estado`),
  KEY `periodo` (`periodo`),
  KEY `codigo_asistencia` (`codigo_asistencia`),
  KEY `signo_extra` (`signo_extra`),
  KEY `id_empleado` (`id_empleado`),
  KEY `nombre_empleado` (`nombre_empleado`),
  KEY `rut_empleado` (`rut_empleado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_asistencia_resumen`
--

LOCK TABLES `tbl_asistencia_resumen` WRITE;
/*!40000 ALTER TABLE `tbl_asistencia_resumen` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_asistencia_resumen` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_asistencia_sobrantecolacion`
--

DROP TABLE IF EXISTS `tbl_asistencia_sobrantecolacion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_asistencia_sobrantecolacion` (
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL DEFAULT '1',
  `usuario_creacion` int(10) NOT NULL,
  `time_creacion` int(10) NOT NULL,
  `id_empleado` int(10) NOT NULL,
  `codigo_asistencia` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `nombre_empleado` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `motivo_permiso` int(10) NOT NULL,
  `fecha_desde` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `hora_desde` varchar(8) COLLATE utf8_spanish_ci NOT NULL COMMENT 'HH:MM:SS',
  `hora_hasta` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `tiempo_permiso` varchar(8) COLLATE utf8_spanish_ci NOT NULL COMMENT 'HH:MM:SS',
  `fecha_hasta` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `cantidad_dias` int(10) NOT NULL,
  `time_desde` int(10) NOT NULL,
  `time_hasta` int(10) NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_autorizador` int(10) NOT NULL,
  UNIQUE KEY `folio` (`folio`),
  KEY `id_empleado` (`id_empleado`),
  KEY `motivo_permiso` (`motivo_permiso`),
  KEY `fecha_hasta` (`fecha_hasta`),
  KEY `observaciones` (`observaciones`),
  KEY `id_autorizador` (`id_autorizador`),
  KEY `time_desde` (`time_desde`),
  KEY `time_hasta` (`time_hasta`),
  KEY `fecha_desde` (`fecha_desde`),
  KEY `cantidad_dias` (`cantidad_dias`),
  KEY `nombre_empleado` (`nombre_empleado`),
  KEY `estado` (`estado`),
  KEY `codigo_asistencia` (`codigo_asistencia`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci COMMENT='Nivel 5';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_asistencia_sobrantecolacion`
--

LOCK TABLES `tbl_asistencia_sobrantecolacion` WRITE;
/*!40000 ALTER TABLE `tbl_asistencia_sobrantecolacion` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_asistencia_sobrantecolacion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_bancos`
--

DROP TABLE IF EXISTS `tbl_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_bancos` (
  `codigo_banco` int(10) NOT NULL DEFAULT '0' COMMENT 'codigo de cuenta contable correspondiente al banco',
  `estado` int(1) NOT NULL DEFAULT '0' COMMENT '1=activo 0=inactivo',
  `numero_cuenta` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'numero de la cuenta corriente',
  `nombre_banco` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_auxiliar` int(10) NOT NULL AUTO_INCREMENT,
  `id_creador` int(10) NOT NULL DEFAULT '0',
  `time_creacion` int(10) NOT NULL DEFAULT '0',
  `rut` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `codigo_auxiliar` (`codigo_auxiliar`),
  KEY `rut` (`rut`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_bancos`
--

LOCK TABLES `tbl_bancos` WRITE;
/*!40000 ALTER TABLE `tbl_bancos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_bancos_chequeras`
--

DROP TABLE IF EXISTS `tbl_bancos_chequeras`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_bancos_chequeras` (
  `id_chequera` int(10) NOT NULL AUTO_INCREMENT,
  `usuario_creador` int(10) NOT NULL DEFAULT '0',
  `time_creacion` int(10) NOT NULL DEFAULT '0',
  `codigo_banco` int(10) NOT NULL DEFAULT '0',
  `numero_chequera` int(10) NOT NULL DEFAULT '0',
  `desde` int(10) NOT NULL DEFAULT '0',
  `hasta` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `id_chequera` (`id_chequera`),
  KEY `codigo_banco` (`codigo_banco`),
  KEY `numero_chequera` (`numero_chequera`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_bancos_chequeras`
--

LOCK TABLES `tbl_bancos_chequeras` WRITE;
/*!40000 ALTER TABLE `tbl_bancos_chequeras` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_bancos_chequeras` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_bancos_cheques`
--

DROP TABLE IF EXISTS `tbl_bancos_cheques`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_bancos_cheques` (
  `id_cheque` int(10) NOT NULL AUTO_INCREMENT,
  `usuario_creador` int(10) NOT NULL DEFAULT '0',
  `time_creacion` int(10) NOT NULL DEFAULT '0',
  `codigo_banco` int(10) NOT NULL DEFAULT '0',
  `numero_chequera` int(10) NOT NULL DEFAULT '0',
  `numero_cheque` int(10) NOT NULL DEFAULT '0',
  `estado` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'D=disponible E=Emitido N=nulo',
  `monto` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `id_cheque` (`id_cheque`),
  KEY `codigo_banco` (`codigo_banco`,`numero_chequera`,`numero_cheque`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_bancos_cheques`
--

LOCK TABLES `tbl_bancos_cheques` WRITE;
/*!40000 ALTER TABLE `tbl_bancos_cheques` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_bancos_cheques` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_bitacora`
--

DROP TABLE IF EXISTS `tbl_bitacora`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_bitacora` (
  `bita_fecha` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `bita_usuario` varchar(100) NOT NULL,
  `bita_detalle` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_bitacora`
--

LOCK TABLES `tbl_bitacora` WRITE;
/*!40000 ALTER TABLE `tbl_bitacora` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_bitacora` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_bodegas`
--

DROP TABLE IF EXISTS `tbl_bodegas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_bodegas` (
  `id_bodega` int(10) NOT NULL AUTO_INCREMENT,
  `sw_default` int(1) NOT NULL,
  `orden` int(10) NOT NULL,
  `estado` int(1) NOT NULL DEFAULT '0' COMMENT '1=activa 0=inactiva',
  `nombre` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `sw_disponible` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no ( Indica si las mercaderias de la bodega estaran en el stock disponible )',
  `sw_despacho` int(1) NOT NULL DEFAULT '0' COMMENT 'Indica si la bodega debe aparecer en la pantalla de despacho de pedidos 1=si 0=no',
  `sw_externa` int(1) NOT NULL,
  `id_encargado` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'RUT DEL TRABAJADOR ENCARGADO DE LA BODEGA',
  `id_creador` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario que creo la bodega',
  `time_creacion` int(10) NOT NULL DEFAULT '0' COMMENT 'timestamp de creacion de la bodega',
  `sw_predeterminada` int(1) NOT NULL,
  UNIQUE KEY `id_bodega` (`id_bodega`),
  KEY `orden` (`orden`),
  KEY `sw_externa` (`sw_externa`),
  KEY `sw_default` (`sw_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_bodegas`
--

LOCK TABLES `tbl_bodegas` WRITE;
/*!40000 ALTER TABLE `tbl_bodegas` DISABLE KEYS */;
INSERT INTO `tbl_bodegas` VALUES (1,0,0,1,'BODEGA CENTRAL','DIRECCION BODEGA',1,1,0,'',0,0,0);
/*!40000 ALTER TABLE `tbl_bodegas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_bodegas_detalle`
--

DROP TABLE IF EXISTS `tbl_bodegas_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_bodegas_detalle` (
  `id_registro` int(10) NOT NULL AUTO_INCREMENT,
  `id_sucursal` int(10) NOT NULL,
  `id_bodega` int(10) NOT NULL,
  `id_linea` int(10) NOT NULL COMMENT 'id correlativo del movimiento solo del producto',
  `time_creacion` int(10) NOT NULL,
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `fecha` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `hora` varchar(8) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_producto` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `tipo_comprobante` varchar(3) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'FV=FacturaVenta AFV=AnulacionFacturaVenta FC=Factura Compra GV=Guia venta GC=Guia compra SI=Saldo Inicial AJ=ajuste ',
  `numero_comprobante` int(10) NOT NULL DEFAULT '0',
  `rut` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_comprobante` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_comprobante` int(10) NOT NULL,
  `unidades_entrada` decimal(12,2) NOT NULL DEFAULT '0.00',
  `unidades_salida` decimal(12,2) NOT NULL DEFAULT '0.00',
  `unidades_saldo` decimal(12,2) NOT NULL DEFAULT '0.00',
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'campo para almacenar principalmente los ajustes',
  `time_revision` int(10) NOT NULL,
  `usuario_revision` int(10) NOT NULL,
  UNIQUE KEY `id_registro` (`id_registro`),
  KEY `id_sucursal` (`id_sucursal`,`id_bodega`),
  KEY `id_bodega` (`id_bodega`),
  KEY `id_linea` (`id_linea`),
  KEY `id_usuario` (`id_usuario`),
  KEY `fecha` (`fecha`),
  KEY `hora` (`hora`),
  KEY `codigo_producto` (`codigo_producto`),
  KEY `tipo_comprobante` (`tipo_comprobante`),
  KEY `numero_comprobante` (`numero_comprobante`),
  KEY `time_revision` (`time_revision`),
  KEY `usuario_revision` (`usuario_revision`),
  KEY `time_creacion` (`time_creacion`),
  KEY `fecha_comprobante` (`fecha_comprobante`),
  KEY `time_comprobante` (`time_comprobante`),
  KEY `rut` (`rut`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci COMMENT='Bodega Central';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_bodegas_detalle`
--

LOCK TABLES `tbl_bodegas_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_bodegas_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_bodegas_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_bodegas_inventario`
--

DROP TABLE IF EXISTS `tbl_bodegas_inventario`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_bodegas_inventario` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_sucursal` int(10) NOT NULL,
  `id_bodega` int(10) NOT NULL,
  `time_creacion` int(10) NOT NULL,
  `usuario_creador` int(10) NOT NULL,
  `time_modificacion` int(10) NOT NULL,
  `usuario_modificador` int(10) NOT NULL,
  `codigo_producto` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `cantidad` decimal(12,2) NOT NULL DEFAULT '0.00',
  `cantidad_sistema` decimal(12,2) NOT NULL,
  `cantidad_inventariada` decimal(12,2) NOT NULL,
  `ubicacion` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'id de la zona',
  `sw_audito` int(1) NOT NULL DEFAULT '0',
  `time_audito` int(10) NOT NULL DEFAULT '0',
  `id_usuario_audito` int(10) NOT NULL DEFAULT '0',
  `time_ingreso` int(10) NOT NULL,
  `id_usuario_ingreso` int(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `id_bodega` (`id_bodega`),
  KEY `codigo_producto` (`codigo_producto`),
  KEY `cantidad` (`cantidad`),
  KEY `ubicacion` (`ubicacion`),
  KEY `id_usuario_audito` (`id_usuario_audito`),
  KEY `time_ingreso` (`time_ingreso`),
  KEY `id_usuario_ingreso` (`id_usuario_ingreso`),
  KEY `time_creacion` (`time_creacion`),
  KEY `usuario_creador` (`usuario_creador`),
  KEY `time_modificacion` (`time_modificacion`),
  KEY `usuario_modificador` (`usuario_modificador`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_bodegas_inventario`
--

LOCK TABLES `tbl_bodegas_inventario` WRITE;
/*!40000 ALTER TABLE `tbl_bodegas_inventario` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_bodegas_inventario` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_bodegas_zonas`
--

DROP TABLE IF EXISTS `tbl_bodegas_zonas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_bodegas_zonas` (
  `id_zona` int(10) NOT NULL AUTO_INCREMENT,
  `id_bodega` int(10) NOT NULL DEFAULT '0',
  `estado_inventario` int(1) NOT NULL,
  `usuario_creacion` int(10) NOT NULL DEFAULT '0',
  `time_creacion` int(10) NOT NULL DEFAULT '0',
  `id_modificacion` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario que modifico los datos de la zona',
  `time_modificacion` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de modificacion de la zona',
  `codigo_zona` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `time_ingreso` int(10) NOT NULL DEFAULT '0',
  `id_usuario_ingreso` int(10) NOT NULL DEFAULT '0',
  `sw_audito` int(1) NOT NULL,
  `time_audito` int(10) NOT NULL,
  `id_usuario_audito` int(10) NOT NULL,
  `descripcion` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `id_zona` (`id_zona`),
  KEY `id_bodega` (`id_bodega`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_bodegas_zonas`
--

LOCK TABLES `tbl_bodegas_zonas` WRITE;
/*!40000 ALTER TABLE `tbl_bodegas_zonas` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_bodegas_zonas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_boletashonorarios`
--

DROP TABLE IF EXISTS `tbl_boletashonorarios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_boletashonorarios` (
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `sw_bloquear` int(1) NOT NULL DEFAULT '0' COMMENT '1=bloqueado 0=no bloqueado',
  `folio_boleta` int(10) NOT NULL,
  `tipo_voucher` int(1) NOT NULL DEFAULT '0',
  `folio_ordenproduccion` int(10) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'EP=EnProceso AN=Anulado GR=Guardado TR=Transferido',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `ano_control` int(4) NOT NULL,
  `numero_control` int(10) NOT NULL,
  `fecha` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time` int(10) NOT NULL,
  `time_ingreso` int(10) NOT NULL,
  `usuario_ingreso` int(10) NOT NULL,
  `fecha_vencimiento` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_vencimiento` int(10) NOT NULL,
  `origen` int(1) NOT NULL DEFAULT '2' COMMENT '1 = recibida 2 = emitida',
  `retencion` int(1) NOT NULL DEFAULT '1' COMMENT '1 = con retencio 2 = Sin retencion',
  `electronica` int(1) NOT NULL DEFAULT '0',
  `id_proyecto` int(10) NOT NULL,
  `id_centrocosto` int(10) NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `razon_social` varchar(250) COLLATE utf8_spanish_ci NOT NULL,
  `direccion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `fono` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `neto` int(10) NOT NULL,
  `iva` int(10) NOT NULL,
  `bruto` int(10) NOT NULL,
  `observaciones` text COLLATE utf8_spanish_ci NOT NULL,
  `cargo` varchar(50) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `folio` (`folio`),
  KEY `id_proyecto` (`id_proyecto`),
  KEY `electronica` (`electronica`),
  KEY `origen` (`origen`,`retencion`),
  KEY `folio_boleta` (`folio_boleta`),
  KEY `fecha_vencimiento` (`fecha_vencimiento`,`time_vencimiento`),
  KEY `id_centrocosto` (`id_centrocosto`,`id_sucursal`),
  KEY `sw_bloquear` (`sw_bloquear`),
  KEY `mes_control` (`mes_control`,`ano_control`,`numero_control`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`),
  KEY `tipo_voucher` (`tipo_voucher`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_boletashonorarios`
--

LOCK TABLES `tbl_boletashonorarios` WRITE;
/*!40000 ALTER TABLE `tbl_boletashonorarios` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_boletashonorarios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_boletashonorarios_certificados`
--

DROP TABLE IF EXISTS `tbl_boletashonorarios_certificados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_boletashonorarios_certificados` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `ano` varchar(4) COLLATE utf8_spanish_ci NOT NULL,
  `rut` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `fecha` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `fecha` (`fecha`),
  KEY `folio` (`folio`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_boletashonorarios_certificados`
--

LOCK TABLES `tbl_boletashonorarios_certificados` WRITE;
/*!40000 ALTER TABLE `tbl_boletashonorarios_certificados` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_boletashonorarios_certificados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_boletashonorarios_detalle`
--

DROP TABLE IF EXISTS `tbl_boletashonorarios_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_boletashonorarios_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio_boleta` int(10) NOT NULL,
  `sw_bloquear` int(1) NOT NULL DEFAULT '0',
  `folio` int(10) NOT NULL,
  `rut` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `ano_control` int(4) NOT NULL,
  `numero_control` int(10) NOT NULL,
  `id_item` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '' COMMENT 'P=Producto M=MateriaPrima I=Insumo C=Cuenta',
  `codigo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_final` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` text COLLATE utf8_spanish_ci NOT NULL,
  `cantidad` decimal(12,2) NOT NULL,
  `unitario` decimal(12,2) NOT NULL,
  `subtotal` int(10) NOT NULL,
  `observaciones` text COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `id_centrocosto` int(10) NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `id_centronegocio` int(10) NOT NULL,
  `id_bodega` int(10) NOT NULL DEFAULT '0',
  `folio_ordenproduccion` int(10) NOT NULL,
  `folio_guiacompra` int(10) NOT NULL COMMENT 'folio de la guia de compra del proveedor',
  `id_item_guia` int(10) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `folio` (`folio`),
  KEY `estado` (`estado`),
  KEY `codigo` (`codigo`),
  KEY `tipo_item` (`tipo_item`),
  KEY `sw_bloquear` (`sw_bloquear`),
  KEY `id_proyecto` (`id_proyecto`,`id_centrocosto`,`id_sucursal`),
  KEY `mes_control` (`mes_control`,`ano_control`,`numero_control`),
  KEY `id_centronegocio` (`id_centronegocio`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`),
  KEY `codigo_final` (`codigo_final`),
  KEY `folio_guiacompra` (`folio_guiacompra`),
  KEY `rut` (`rut`),
  KEY `id_bodega` (`id_bodega`),
  KEY `id_item_guia` (`id_item_guia`),
  KEY `folio_boleta` (`folio_boleta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_boletashonorarios_detalle`
--

LOCK TABLES `tbl_boletashonorarios_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_boletashonorarios_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_boletashonorarios_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_boletasventa`
--

DROP TABLE IF EXISTS `tbl_boletasventa`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_boletasventa` (
  `id_registro` int(10) NOT NULL,
  `id_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'almacena el timestamp unix del momento cuando se puso listo al pedido',
  `id_sucursal_venta` int(10) NOT NULL,
  `id_bodega` int(10) NOT NULL DEFAULT '0' COMMENT 'id de la bodega de donde se rebajara el inventario',
  `asiento_apertura` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `facturada` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `contabilizada` int(1) NOT NULL DEFAULT '0' COMMENT 'indica si la emision de la factura ya fue contabilizada 1=si 0=no',
  `cancelada` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'VA=venta anticipada CC=cuenta corriente',
  `folio_final` int(10) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `tipo_facturacion` int(1) NOT NULL DEFAULT '0' COMMENT '0=facturacion desde notas de venta 1=FACTURACION DESDE GUIAS DE DESPACHO 2=facturacion manual',
  `anulada` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `fecha_anulacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_cotizacion` int(10) NOT NULL DEFAULT '0',
  `folio_notaventa` int(10) NOT NULL DEFAULT '0',
  `folio_despacho` int(10) NOT NULL DEFAULT '0',
  `folio_ruta` int(10) NOT NULL DEFAULT '0',
  `folio_guiadespacho` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_ordencompra` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `rut_vendedor` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `id_vendedor` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `exenta` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `electronica` int(1) NOT NULL DEFAULT '0',
  `id_relacion` int(10) NOT NULL DEFAULT '0',
  `tipo_cliente` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'E=Empresa U=Universidad',
  `proyecto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT '0=Sin proyecto',
  `id_empresa` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL DEFAULT '0',
  `id_laboratorio` int(10) NOT NULL DEFAULT '0',
  `id_investigador` int(10) NOT NULL DEFAULT '0',
  `id_contacto` int(10) NOT NULL DEFAULT '0',
  `id_despacho` int(10) NOT NULL DEFAULT '0',
  `id_region` int(10) NOT NULL DEFAULT '0',
  `id_ciudad` int(10) NOT NULL DEFAULT '0',
  `id_comuna` int(10) NOT NULL DEFAULT '0',
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `razon_social` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_fantasia` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `giro` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefonos` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `region` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `ciudad` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `comuna` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_contacto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_investigador` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `atencion_facturacion` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_contacto` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_investigador` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_facturacion` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_proyecto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `tipo_factura` int(1) NOT NULL DEFAULT '0' COMMENT '0=normal 1=facturacion acticipada (VA)',
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_facturacion` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp con fecha y hora de emision de la factura',
  `fecha_vencimiento` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_vencimiento` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp con fecha y hora de vencimiento',
  `via_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion_despacho` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_despacho` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `atencion_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `cancela_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `subtotal` int(10) NOT NULL DEFAULT '0',
  `descuento_porc` int(2) NOT NULL DEFAULT '0' COMMENT 'D',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0',
  `neto` int(10) NOT NULL DEFAULT '0',
  `iva` int(10) NOT NULL DEFAULT '0',
  `bruto` int(10) NOT NULL DEFAULT '0',
  `cancelo` int(10) NOT NULL,
  `saldo_pendiente` int(10) NOT NULL DEFAULT '0',
  `saldo_va` int(10) NOT NULL DEFAULT '0' COMMENT 'indica el saldo disponible de las facturas va',
  `bruto_palabras` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'Total bruto escrito en palabras',
  `id_condiciones_venta` int(10) NOT NULL DEFAULT '0',
  `condiciones_venta` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT '1=Efectivo 2=Documentado 3=10 Dias 4=15 Dias 5=30 Dias 6=45 Dias 7=60 Dias 8=30/60 Dias 9=30/60/90 Dias',
  `observaciones` text COLLATE utf8_spanish_ci NOT NULL,
  `id_usuario_anulacion` int(10) NOT NULL DEFAULT '0',
  `id_anulacion` int(10) NOT NULL DEFAULT '0',
  `motivo_anulacion` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_usuario_modifico` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario que realizo la ultima modificacion',
  `id_modificacion` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp de la ultima modificacion',
  UNIQUE KEY `folio_factura` (`folio_factura`),
  KEY `fecha_facturacion` (`fecha_facturacion`),
  KEY `id_factura` (`id_factura`),
  KEY `rut` (`rut`),
  KEY `id_relacion` (`id_relacion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_boletasventa`
--

LOCK TABLES `tbl_boletasventa` WRITE;
/*!40000 ALTER TABLE `tbl_boletasventa` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_boletasventa` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_boletasventa_detalle`
--

DROP TABLE IF EXISTS `tbl_boletasventa_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_boletasventa_detalle` (
  `folio_factura` int(10) NOT NULL DEFAULT '0',
  `id_sucursal_venta` int(10) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `folio_guiadespacho` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `anulada` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT '0=no 1=si',
  `id_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'id de la factura indica cuando se puso listo al pedido en bodega',
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `tipo_factura` int(1) NOT NULL DEFAULT '0' COMMENT '0=factura normal 1=facturacion anticipada',
  `id_facturacion` int(10) NOT NULL DEFAULT '0' COMMENT 'Solo para ordenamientos de fecha',
  `id_item` int(10) NOT NULL DEFAULT '0',
  `rut_vendedor` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_relacion` int(10) NOT NULL DEFAULT '0',
  `rut_cliente` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_producto` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'P=producto S=servicio C=cuenta',
  `sw_facturable` int(1) NOT NULL DEFAULT '1',
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `pmp` int(10) NOT NULL DEFAULT '0',
  `precio_referencial` int(10) NOT NULL DEFAULT '0' COMMENT 'Precio referencial al momento de pegar el item',
  `precio_venta` int(10) NOT NULL DEFAULT '0' COMMENT 'precio de venta',
  `precio_final_venta` int(10) NOT NULL DEFAULT '0' COMMENT 'precio de venta unitario con descuento lineal y global aplicado',
  `cantidad` int(10) NOT NULL DEFAULT '0',
  `cantidad_devuelta` int(10) NOT NULL DEFAULT '0' COMMENT 'cantidad de unidades devueltas por medio de una nota de credito',
  `subtotal` int(10) NOT NULL DEFAULT '0' COMMENT 'precio de venta x cantidad',
  `descuento_porc` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT 'porcentaje de descuento',
  `descuento_porc_global` decimal(5,2) NOT NULL DEFAULT '0.00',
  `subtotal_neto` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal con descuento lineal aplicado',
  `subtotal_final` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal con descuento lineal y global aplicado',
  `subtotal_costo` int(10) NOT NULL COMMENT 'pmp x cantidad',
  `comision_porcentaje` decimal(5,2) NOT NULL DEFAULT '0.00',
  `comision_pesos` int(10) NOT NULL DEFAULT '0',
  `comision_porcentaje_extra` decimal(5,2) NOT NULL DEFAULT '0.00',
  `comision_pesos_extra` int(10) NOT NULL DEFAULT '0',
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  KEY `folio_factura` (`folio_factura`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_boletasventa_detalle`
--

LOCK TABLES `tbl_boletasventa_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_boletasventa_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_boletasventa_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_boletasventa_mensuales`
--

DROP TABLE IF EXISTS `tbl_boletasventa_mensuales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_boletasventa_mensuales` (
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'EP=EnProceso AN=Anulado GR=Guardado TR=Transferido',
  `fecha` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time` int(10) NOT NULL,
  `time_ingreso` int(10) NOT NULL,
  `usuario_ingreso` int(10) NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `id_centrocosto` int(10) NOT NULL,
  `tipo_boleta` int(10) NOT NULL,
  `periodo` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `neto` int(10) NOT NULL,
  `iva` int(10) NOT NULL,
  `bruto` int(10) NOT NULL,
  `observaciones` text COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `folio` (`folio`),
  KEY `tipo_notacredito` (`tipo_boleta`),
  KEY `id_vendedor` (`id_sucursal`),
  KEY `id_centrocosto` (`id_centrocosto`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_boletasventa_mensuales`
--

LOCK TABLES `tbl_boletasventa_mensuales` WRITE;
/*!40000 ALTER TABLE `tbl_boletasventa_mensuales` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_boletasventa_mensuales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_boletasventa_mensuales_detalle`
--

DROP TABLE IF EXISTS `tbl_boletasventa_mensuales_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_boletasventa_mensuales_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `tipo_boleta` int(1) NOT NULL,
  `periodo` varchar(8) COLLATE utf8_spanish_ci NOT NULL COMMENT 'mm/aaaa',
  `id_sucursal` int(10) NOT NULL,
  `id_item` int(10) NOT NULL,
  `dia` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `folio_desde` int(10) NOT NULL,
  `folio_hasta` int(10) NOT NULL,
  `total_bruto` int(10) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `folio` (`folio`),
  KEY `estado` (`estado`),
  KEY `id_item` (`id_item`),
  KEY `dia` (`dia`),
  KEY `folio_desde` (`folio_desde`),
  KEY `folio_hasta` (`folio_hasta`),
  KEY `total_bruto` (`total_bruto`),
  KEY `periodo` (`periodo`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `tipo_boleta` (`tipo_boleta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_boletasventa_mensuales_detalle`
--

LOCK TABLES `tbl_boletasventa_mensuales_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_boletasventa_mensuales_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_boletasventa_mensuales_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_boletos_transporte`
--

DROP TABLE IF EXISTS `tbl_boletos_transporte`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_boletos_transporte` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `folio` int(11) NOT NULL,
  `nombre_pasajero` varchar(50) NOT NULL,
  `time_salida` int(10) NOT NULL,
  `time_llegada` int(10) NOT NULL,
  `local_venta` varchar(1) NOT NULL,
  `origen` varchar(70) NOT NULL,
  `destino` varchar(70) NOT NULL,
  `precio` float(15,2) NOT NULL,
  `descuento` float NOT NULL,
  `cantidad` int(10) NOT NULL,
  `id_cliente` int(5) NOT NULL,
  `id_vendedor` int(11) NOT NULL,
  `id_servicio` varchar(10) NOT NULL,
  `id_chofer` int(5) NOT NULL,
  `id_vehiculo` int(5) NOT NULL,
  `numero_habitacion` varchar(11) NOT NULL,
  `estado` varchar(2) NOT NULL COMMENT 'S=solicitado, A=asignado, R=realizado, F=facturado, X=rechazado, P=en procesp',
  `observaciones` text NOT NULL,
  `id_formapago` varchar(11) NOT NULL,
  `numero_vuelo` varchar(20) NOT NULL,
  `solicitante` varchar(1) NOT NULL COMMENT 'A, H, T',
  `comprobante_pago` int(15) NOT NULL,
  `folio_factura` int(11) NOT NULL,
  `kilometraje_inicio` int(25) NOT NULL,
  `kilometraje_final` int(25) NOT NULL,
  `id_documento_venta` int(11) NOT NULL,
  `tipo_documento_venta` varchar(2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_boletos_transporte`
--

LOCK TABLES `tbl_boletos_transporte` WRITE;
/*!40000 ALTER TABLE `tbl_boletos_transporte` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_boletos_transporte` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_caja_movimientos`
--

DROP TABLE IF EXISTS `tbl_caja_movimientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_caja_movimientos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_caja` int(11) NOT NULL,
  `id_empleado` int(11) NOT NULL,
  `id_banco` int(11) DEFAULT NULL,
  `id_caja_recaudo` int(11) DEFAULT NULL,
  `comentario` varchar(50) NOT NULL,
  `monto` int(11) NOT NULL,
  `saldo_caja` int(11) NOT NULL,
  `timestamp` int(10) NOT NULL,
  `tipo_documento` varchar(3) NOT NULL,
  `folio_documento` int(15) NOT NULL,
  `sw_correccion` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_caja_movimientos`
--

LOCK TABLES `tbl_caja_movimientos` WRITE;
/*!40000 ALTER TABLE `tbl_caja_movimientos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_caja_movimientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cajadiaria`
--

DROP TABLE IF EXISTS `tbl_cajadiaria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_cajadiaria` (
  `id_cajadiaria` int(10) NOT NULL AUTO_INCREMENT,
  `time_operacion` int(10) NOT NULL DEFAULT '0',
  `tipo_caja` int(1) NOT NULL DEFAULT '0' COMMENT '1=apertura 2=cierre',
  `id_operador` int(10) NOT NULL DEFAULT '0',
  `id_terminal` int(10) NOT NULL DEFAULT '0',
  `id_caja` int(10) NOT NULL,
  `monto` int(10) NOT NULL DEFAULT '0',
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id_cajadiaria` (`id_cajadiaria`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci COMMENT='Control de las cajas';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cajadiaria`
--

LOCK TABLES `tbl_cajadiaria` WRITE;
/*!40000 ALTER TABLE `tbl_cajadiaria` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cajadiaria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cajas`
--

DROP TABLE IF EXISTS `tbl_cajas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_cajas` (
  `id_caja` int(10) NOT NULL AUTO_INCREMENT,
  `sw_recaudos` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `codigo_cuenta` char(10) COLLATE utf8_spanish_ci NOT NULL,
  `nombre` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `time_creacion` int(10) NOT NULL,
  `usuario_creacion` int(10) NOT NULL,
  `time_recaudo` int(10) NOT NULL,
  `jefe_caja` int(10) NOT NULL,
  `saldo_actual` int(11) NOT NULL,
  `time_ultimo_movimiento` int(10) NOT NULL,
  UNIQUE KEY `id_caja` (`id_caja`),
  KEY `codigo_cuenta` (`codigo_cuenta`),
  KEY `sw_recaudos` (`sw_recaudos`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cajas`
--

LOCK TABLES `tbl_cajas` WRITE;
/*!40000 ALTER TABLE `tbl_cajas` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cajas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_capturainventario`
--

DROP TABLE IF EXISTS `tbl_capturainventario`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_capturainventario` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_bodega` int(10) NOT NULL,
  `id_zona` int(10) NOT NULL,
  `rpx` int(10) NOT NULL,
  `ean` char(13) COLLATE utf8_spanish_ci NOT NULL,
  `cantidad` decimal(15,5) NOT NULL,
  `id_usuario` int(10) NOT NULL,
  `usuario` char(32) COLLATE utf8_spanish_ci NOT NULL,
  `time_captura` int(10) NOT NULL,
  `fecha_captura` char(10) COLLATE utf8_spanish_ci NOT NULL,
  `hora_captura` char(10) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `id_bodega` (`id_bodega`),
  KEY `id_zona` (`id_zona`),
  KEY `id_usuario` (`id_usuario`),
  KEY `time_captura` (`time_captura`),
  KEY `fecha_captura` (`fecha_captura`),
  KEY `hora_captura` (`hora_captura`),
  KEY `rpx` (`rpx`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_capturainventario`
--

LOCK TABLES `tbl_capturainventario` WRITE;
/*!40000 ALTER TABLE `tbl_capturainventario` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_capturainventario` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cartolas`
--

DROP TABLE IF EXISTS `tbl_cartolas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_cartolas` (
  `id_cartola` int(10) NOT NULL DEFAULT '0',
  `id_banco` int(10) NOT NULL DEFAULT '0',
  `mes` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `ano` char(4) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cartolas`
--

LOCK TABLES `tbl_cartolas` WRITE;
/*!40000 ALTER TABLE `tbl_cartolas` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cartolas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cartolas_detalle`
--

DROP TABLE IF EXISTS `tbl_cartolas_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_cartolas_detalle` (
  `id_cartola` int(10) NOT NULL DEFAULT '0',
  `id_banco` int(10) NOT NULL DEFAULT '0',
  `mes` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `ano` int(4) NOT NULL DEFAULT '0',
  `dia` varchar(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `numero` int(20) NOT NULL DEFAULT '0',
  `tipo` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `descripcion` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `monto` int(10) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cartolas_detalle`
--

LOCK TABLES `tbl_cartolas_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_cartolas_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cartolas_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_centrosdecosto`
--

DROP TABLE IF EXISTS `tbl_centrosdecosto`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_centrosdecosto` (
  `id_centrocosto` int(10) NOT NULL AUTO_INCREMENT,
  `codigo_centrocosto` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `nombre` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `estado` int(1) NOT NULL DEFAULT '0',
  UNIQUE KEY `id_centrocosto` (`id_centrocosto`),
  KEY `codigo_centrocosto` (`codigo_centrocosto`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_centrosdecosto`
--

LOCK TABLES `tbl_centrosdecosto` WRITE;
/*!40000 ALTER TABLE `tbl_centrosdecosto` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_centrosdecosto` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_centrosdeingreso`
--

DROP TABLE IF EXISTS `tbl_centrosdeingreso`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_centrosdeingreso` (
  `id_centroingreso` int(10) NOT NULL AUTO_INCREMENT COMMENT 'identificador del centro de ingreso',
  `id_subclase` int(10) NOT NULL DEFAULT '0' COMMENT 'id de la sub clase de producto',
  `estado` int(1) NOT NULL DEFAULT '1',
  `usuario_creacion` int(10) NOT NULL DEFAULT '0',
  `time_creacion` int(10) NOT NULL DEFAULT '0',
  `codigo` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'codigo de la sub clase',
  `origen` char(3) COLLATE utf8_spanish_ci NOT NULL,
  `cuenta_mercaderia` int(10) NOT NULL DEFAULT '0' COMMENT 'codigo del plan de cuentas asociado a la mercaderia ',
  `cuenta_costo` int(10) NOT NULL DEFAULT '0' COMMENT 'codigo del plan de cuentas asociado al costo',
  `cuenta_venta` int(10) NOT NULL DEFAULT '0' COMMENT 'codigo del plan de cuentas asociado a la venta',
  `nombre` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'nombre del centro de ingreso',
  `nombre_corto` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `contador` int(10) NOT NULL COMMENT 'va almacenando el numero de item del grupo',
  UNIQUE KEY `id_centroingreso` (`id_centroingreso`),
  KEY `cuenta_mercaderia` (`cuenta_mercaderia`),
  KEY `cuenta_costo` (`cuenta_costo`),
  KEY `cuenta_venta` (`cuenta_venta`),
  KEY `contador` (`contador`),
  KEY `origen` (`origen`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_centrosdeingreso`
--

LOCK TABLES `tbl_centrosdeingreso` WRITE;
/*!40000 ALTER TABLE `tbl_centrosdeingreso` DISABLE KEYS */;
INSERT INTO `tbl_centrosdeingreso` VALUES (1,0,1,0,0,'','',101060101,301010101,401010101,'GENERICO','',0);
/*!40000 ALTER TABLE `tbl_centrosdeingreso` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_centrosdeingreso_clases`
--

DROP TABLE IF EXISTS `tbl_centrosdeingreso_clases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_centrosdeingreso_clases` (
  `id_grupo` int(10) NOT NULL AUTO_INCREMENT,
  `id_padre` int(10) NOT NULL DEFAULT '0',
  `sw_centroingreso` int(1) NOT NULL DEFAULT '0' COMMENT 'Indica si la clase es un centro de ingreso 1=SI 0=NO',
  `sw_bloquear` int(1) NOT NULL DEFAULT '0',
  `nivel_subclase` int(10) NOT NULL DEFAULT '0',
  `usuario_creacion` int(10) NOT NULL DEFAULT '0',
  `time_creacion` int(10) NOT NULL DEFAULT '0',
  `codigo` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_completo` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'maximo 16 sub clases',
  `nombre` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_completo` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_grupocuenta` int(10) NOT NULL,
  `id_padrecuenta` int(10) NOT NULL,
  `grupo_ventas` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `grupo_costos` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `grupo_existencias` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id_grupo` (`id_grupo`),
  KEY `codigo` (`codigo`),
  KEY `codigo_completo` (`codigo_completo`),
  KEY `grupo_ventas` (`grupo_ventas`,`grupo_costos`,`grupo_existencias`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_centrosdeingreso_clases`
--

LOCK TABLES `tbl_centrosdeingreso_clases` WRITE;
/*!40000 ALTER TABLE `tbl_centrosdeingreso_clases` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_centrosdeingreso_clases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cierres`
--

DROP TABLE IF EXISTS `tbl_cierres`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_cierres` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `periodo` varchar(7) NOT NULL,
  `ventas` int(1) NOT NULL DEFAULT '1',
  `compras` int(1) NOT NULL DEFAULT '1',
  `contabilidad` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='1 : abierto, 0 : cerrado';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cierres`
--

LOCK TABLES `tbl_cierres` WRITE;
/*!40000 ALTER TABLE `tbl_cierres` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cierres` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cierres_log`
--

DROP TABLE IF EXISTS `tbl_cierres_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_cierres_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_cierre` int(11) NOT NULL,
  `fecha` int(10) NOT NULL,
  `id_usuario` int(11) NOT NULL,
  `descripcion` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cierres_log`
--

LOCK TABLES `tbl_cierres_log` WRITE;
/*!40000 ALTER TABLE `tbl_cierres_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cierres_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_clase`
--

DROP TABLE IF EXISTS `tbl_clase`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_clase` (
  `id_clase` varchar(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `descripcion` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  KEY `id_clase` (`id_clase`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci COMMENT='Define el movimiento de productos a alto movimiento';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_clase`
--

LOCK TABLES `tbl_clase` WRITE;
/*!40000 ALTER TABLE `tbl_clase` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_clase` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_clicks`
--

DROP TABLE IF EXISTS `tbl_clicks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_clicks` (
  `id_click` int(10) NOT NULL DEFAULT '9',
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  KEY `id_click` (`id_click`),
  KEY `id_usuario` (`id_usuario`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_clicks`
--

LOCK TABLES `tbl_clicks` WRITE;
/*!40000 ALTER TABLE `tbl_clicks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_clicks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_clientes_clases`
--

DROP TABLE IF EXISTS `tbl_clientes_clases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_clientes_clases` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `codigo` char(32) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `etiqueta` varchar(255) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `codigo` (`codigo`),
  KEY `etiqueta` (`etiqueta`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_clientes_clases`
--

LOCK TABLES `tbl_clientes_clases` WRITE;
/*!40000 ALTER TABLE `tbl_clientes_clases` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_clientes_clases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_clientes_cobranza`
--

DROP TABLE IF EXISTS `tbl_clientes_cobranza`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_clientes_cobranza` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sw_cobrar` int(1) NOT NULL COMMENT '1=si cobrar 0=no cobrar',
  `folio_documento` int(10) NOT NULL,
  `tipo_documento` char(3) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_cobranza` char(10) COLLATE utf8_spanish_ci NOT NULL,
  `hora_cobranza` char(8) COLLATE utf8_spanish_ci NOT NULL,
  `time_cobranza` int(10) NOT NULL,
  `id_usuario_cobranza` int(10) NOT NULL,
  `comentarios` text COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `sw_cobrar` (`sw_cobrar`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_clientes_cobranza`
--

LOCK TABLES `tbl_clientes_cobranza` WRITE;
/*!40000 ALTER TABLE `tbl_clientes_cobranza` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_clientes_cobranza` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_clientes_contactos`
--

DROP TABLE IF EXISTS `tbl_clientes_contactos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_clientes_contactos` (
  `id_contacto` int(10) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT '1=activo 0=inactivo',
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_empresa` int(10) NOT NULL,
  `codigo_sucursal` int(10) NOT NULL,
  `codigo_contacto` int(10) NOT NULL,
  `usuario_creacion` int(10) NOT NULL DEFAULT '0',
  `id_usuario` int(10) NOT NULL,
  `time_creacion` int(10) NOT NULL DEFAULT '0',
  `nombre` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_completo` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombres` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `apellidos` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefonos` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `fax` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `email` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `id_contacto` (`id_contacto`),
  KEY `id_usuario` (`id_usuario`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_clientes_contactos`
--

LOCK TABLES `tbl_clientes_contactos` WRITE;
/*!40000 ALTER TABLE `tbl_clientes_contactos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_clientes_contactos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_clientes_contactos_despacho`
--

DROP TABLE IF EXISTS `tbl_clientes_contactos_despacho`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_clientes_contactos_despacho` (
  `id_contacto_despacho` int(10) NOT NULL AUTO_INCREMENT,
  `id_creador_contacto` int(10) NOT NULL DEFAULT '0',
  `id_relacion` int(10) NOT NULL DEFAULT '0',
  `estado` int(1) NOT NULL DEFAULT '0',
  `tipo_cliente` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombres` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `apellidos` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `fono` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `email` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `id_contacto_despacho` (`id_contacto_despacho`),
  KEY `id_relacion` (`id_relacion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_clientes_contactos_despacho`
--

LOCK TABLES `tbl_clientes_contactos_despacho` WRITE;
/*!40000 ALTER TABLE `tbl_clientes_contactos_despacho` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_clientes_contactos_despacho` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_clientes_despachos`
--

DROP TABLE IF EXISTS `tbl_clientes_despachos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_clientes_despachos` (
  `id_despacho` int(10) NOT NULL AUTO_INCREMENT,
  `id_usuario` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario creador del despacho',
  `tipo_cliente` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_relacion` int(10) NOT NULL DEFAULT '0',
  `atencion_despacho` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'despacho con atencion  a:',
  `horario_despacho` varchar(80) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `via_despacho` varchar(80) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `por_cuenta` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'T=tcl C=Cliente',
  `telefonos` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_region` int(10) NOT NULL DEFAULT '0',
  `id_comuna` int(10) NOT NULL DEFAULT '0',
  `id_ciudad` int(10) NOT NULL DEFAULT '0',
  KEY `id_despacho` (`id_despacho`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_clientes_despachos`
--

LOCK TABLES `tbl_clientes_despachos` WRITE;
/*!40000 ALTER TABLE `tbl_clientes_despachos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_clientes_despachos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_clientes_empresas`
--

DROP TABLE IF EXISTS `tbl_clientes_empresas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_clientes_empresas` (
  `id_empresa` int(10) NOT NULL AUTO_INCREMENT COMMENT 'ID unico de identificacion de la empresa',
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `id_vendedor` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'id del o los vendedores asignados a la empresa',
  `id_proyecto` int(10) NOT NULL,
  `id_contrato` int(10) NOT NULL,
  `codigo_empresa` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `clase_cliente` int(10) NOT NULL,
  `time_creacion` int(10) NOT NULL DEFAULT '0',
  `tipo_cliente` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'E=empresa N=personaNatural U=universidad',
  `id_clasecliente` int(10) NOT NULL,
  `id_categoriacliente` int(10) NOT NULL COMMENT 'aqui va el id de la categoria del cliente (giro u rubro)',
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT '1=activo 0=inactivo',
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `razon_social` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_fantasia` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `giro` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `fax` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `email` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `sitio_web` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_region` int(10) NOT NULL DEFAULT '0',
  `id_ciudad` int(10) NOT NULL DEFAULT '0',
  `id_comuna` int(10) NOT NULL DEFAULT '0',
  `comuna` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `ciudad` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `region` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `contacto` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `tel_contacto` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `exento` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT 'NO' COMMENT 'SI NO AM=ambos',
  `id_condiciones_venta` int(10) NOT NULL DEFAULT '1' COMMENT '1=Efectivo 2=Documentado 3=Linea de Credito 4=Vencimientofacturacion',
  `id_descuento` int(10) NOT NULL,
  `estado_lineacredito` int(1) NOT NULL DEFAULT '1' COMMENT '1activo 0 inactivo',
  `linea_credito` int(10) NOT NULL DEFAULT '500000',
  `monto_utilizado` int(10) NOT NULL DEFAULT '0',
  `monto_disponible` int(10) NOT NULL DEFAULT '500000',
  `adjuntar_oc` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no ( indica que al despachar productos se debe adjuntar orden de compra enviada por el cliente )',
  `tipo_facturacion` int(1) NOT NULL DEFAULT '0' COMMENT '1=afecto 2=exento 3=afecto y Exento',
  `forma_pago` int(1) NOT NULL COMMENT '1=Efectivo 2=Documentado 3=Linea de Credito 4=Vencimientofacturacion',
  `documentado` text COLLATE utf8_spanish_ci NOT NULL,
  `vencimiento_facturacion` int(10) NOT NULL,
  `contacto_cobranza` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `mail_cobranza` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `fono_cobranza` varchar(50) COLLATE utf8_spanish_ci NOT NULL,
  `id_productos_lista_precios` int(10) NOT NULL,
  `tipo_linea_credito` varchar(20) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_producto_cliente` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `monto_lineacredito` int(10) NOT NULL,
  `sw_servicios` int(1) NOT NULL,
  `id_lista_de_precios` int(10) DEFAULT NULL,
  `pais` varchar(50) COLLATE utf8_spanish_ci DEFAULT NULL,
  `fecha_creacion` varchar(10) COLLATE utf8_spanish_ci DEFAULT NULL,
  `id_creacion` int(11) DEFAULT NULL,
  UNIQUE KEY `id_empresa` (`id_empresa`),
  UNIQUE KEY `rut` (`rut`),
  KEY `id_vendedor` (`id_vendedor`),
  KEY `codigo_empresa` (`codigo_empresa`),
  KEY `estado` (`estado`),
  KEY `razon_social` (`razon_social`),
  KEY `nombre_fantasia` (`nombre_fantasia`),
  KEY `id_categoriacliente` (`id_categoriacliente`),
  KEY `id_clasecliente` (`id_clasecliente`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_clientes_empresas`
--

LOCK TABLES `tbl_clientes_empresas` WRITE;
/*!40000 ALTER TABLE `tbl_clientes_empresas` DISABLE KEYS */;
INSERT INTO `tbl_clientes_empresas` VALUES (1,965,'1',0,0,'1',0,0,'E',0,0,1,'11111111-1','PUBLICO GENERAL','PUBLICO GENERAL','GENERICO','2222','','.','','GENERICO',0,0,274,'0','0','0','GENERICO','0','NO',1,0,1,0,0,0,0,0,1,'',0,'','','',0,'','',0,0,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `tbl_clientes_empresas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_clientes_investigadores`
--

DROP TABLE IF EXISTS `tbl_clientes_investigadores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_clientes_investigadores` (
  `id_investigador` int(10) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT '1=activo 0=inactivo',
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_completo` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombres` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `apellidos` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefonos` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `fax` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `email` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  KEY `id_investigador` (`id_investigador`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_clientes_investigadores`
--

LOCK TABLES `tbl_clientes_investigadores` WRITE;
/*!40000 ALTER TABLE `tbl_clientes_investigadores` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_clientes_investigadores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_clientes_laboratorios`
--

DROP TABLE IF EXISTS `tbl_clientes_laboratorios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_clientes_laboratorios` (
  `id_empresa` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL DEFAULT '0',
  `id_laboratorio` int(10) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL DEFAULT '0' COMMENT '1=activo 0=inactivo',
  `facultad` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `laboratorio` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefonos` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `fax` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `email` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `id_laboratorio` (`id_laboratorio`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_clientes_laboratorios`
--

LOCK TABLES `tbl_clientes_laboratorios` WRITE;
/*!40000 ALTER TABLE `tbl_clientes_laboratorios` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_clientes_laboratorios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_clientes_relacion`
--

DROP TABLE IF EXISTS `tbl_clientes_relacion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_clientes_relacion` (
  `id_relacion` int(10) NOT NULL AUTO_INCREMENT,
  `id_creador_relacion` int(10) NOT NULL DEFAULT '0',
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT '1=activo 0=inactivo',
  `id_empresa` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL DEFAULT '0',
  `id_laboratorio` int(10) NOT NULL DEFAULT '0' COMMENT 'Solo Universidades',
  `id_investigador` int(10) NOT NULL DEFAULT '0' COMMENT 'Solo Universidades',
  `id_contacto` int(10) NOT NULL DEFAULT '0' COMMENT 'Solo Empresas',
  `id_vendedor` int(10) NOT NULL DEFAULT '0' COMMENT 'Solo Empresas',
  `estado_lineacredito` int(1) NOT NULL DEFAULT '0' COMMENT '0=inactiva 1=activa Solo Universidades',
  `linea_credito` int(10) NOT NULL DEFAULT '0' COMMENT 'Solo Universidades',
  `monto_utilizado` int(10) NOT NULL DEFAULT '0' COMMENT 'Solo Universidades',
  `monto_disponible` int(10) NOT NULL DEFAULT '0' COMMENT 'Solo Universidades',
  `id_condiciones_venta` int(10) NOT NULL DEFAULT '0' COMMENT 'Solo Universidades',
  `time_creacion` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `id_relacion` (`id_relacion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci COMMENT='relacion entre laboratorio  e investigador';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_clientes_relacion`
--

LOCK TABLES `tbl_clientes_relacion` WRITE;
/*!40000 ALTER TABLE `tbl_clientes_relacion` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_clientes_relacion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_clientes_relacion_contactos`
--

DROP TABLE IF EXISTS `tbl_clientes_relacion_contactos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_clientes_relacion_contactos` (
  `id_relacion` int(10) NOT NULL AUTO_INCREMENT,
  `id_creador_relacion` int(10) NOT NULL DEFAULT '0',
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT '1=activo 0=inactivo',
  `id_relacion_investigador` int(10) NOT NULL DEFAULT '0',
  `id_contacto` int(10) NOT NULL DEFAULT '0',
  `id_vendedor` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `id_relacion` (`id_relacion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci COMMENT='Contactos relacionados con un investigador de universidad';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_clientes_relacion_contactos`
--

LOCK TABLES `tbl_clientes_relacion_contactos` WRITE;
/*!40000 ALTER TABLE `tbl_clientes_relacion_contactos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_clientes_relacion_contactos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_clientes_siku`
--

DROP TABLE IF EXISTS `tbl_clientes_siku`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_clientes_siku` (
  `id_empresa` int(10) NOT NULL AUTO_INCREMENT COMMENT 'ID unico de identificacion de la empresa',
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `id_vendedor` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'id del o los vendedores asignados a la empresa',
  `id_proyecto` int(10) NOT NULL,
  `codigo_empresa` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `clase_cliente` int(10) NOT NULL,
  `time_creacion` int(10) NOT NULL DEFAULT '0',
  `tipo_cliente` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'E=empresa N=personaNatural U=universidad',
  `id_clasecliente` int(10) NOT NULL,
  `id_categoriacliente` int(10) NOT NULL COMMENT 'aqui va el id de la categoria del cliente (giro u rubro)',
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT '1=activo 0=inactivo',
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `razon_social` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_fantasia` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `giro` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `fax` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `email` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `sitio_web` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_region` int(10) NOT NULL DEFAULT '0',
  `id_ciudad` int(10) NOT NULL DEFAULT '0',
  `id_comuna` int(10) NOT NULL DEFAULT '0',
  `comuna` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `ciudad` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `region` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `contacto` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `tel_contacto` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `exento` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT 'NO' COMMENT 'SI NO AM=ambos',
  `id_condiciones_venta` int(10) NOT NULL DEFAULT '1' COMMENT '1=Efectivo 2=Documentado 3=Linea de Credito 4=Vencimientofacturacion',
  `id_descuento` int(10) NOT NULL,
  `estado_lineacredito` int(1) NOT NULL DEFAULT '1' COMMENT '1activo 0 inactivo',
  `linea_credito` int(10) NOT NULL DEFAULT '500000',
  `monto_utilizado` int(10) NOT NULL DEFAULT '0',
  `monto_disponible` int(10) NOT NULL DEFAULT '500000',
  `adjuntar_oc` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no ( indica que al despachar productos se debe adjuntar orden de compra enviada por el cliente )',
  `tipo_facturacion` int(1) NOT NULL DEFAULT '0' COMMENT '1=afecto 2=exento 3=afecto y Exento',
  `forma_pago` int(1) NOT NULL COMMENT '1=Efectivo 2=Documentado 3=Linea de Credito 4=Vencimientofacturacion',
  `documentado` text COLLATE utf8_spanish_ci NOT NULL,
  `vencimiento_facturacion` int(10) NOT NULL,
  `contacto_cobranza` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `mail_cobranza` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `fono_cobranza` varchar(50) COLLATE utf8_spanish_ci NOT NULL,
  `id_productos_lista_precios` int(10) NOT NULL,
  `tipo_linea_credito` varchar(20) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_producto_cliente` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id_empresa` (`id_empresa`),
  UNIQUE KEY `rut` (`rut`),
  KEY `id_vendedor` (`id_vendedor`),
  KEY `codigo_empresa` (`codigo_empresa`),
  KEY `estado` (`estado`),
  KEY `razon_social` (`razon_social`),
  KEY `nombre_fantasia` (`nombre_fantasia`),
  KEY `id_categoriacliente` (`id_categoriacliente`),
  KEY `id_clasecliente` (`id_clasecliente`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_clientes_siku`
--

LOCK TABLES `tbl_clientes_siku` WRITE;
/*!40000 ALTER TABLE `tbl_clientes_siku` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_clientes_siku` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_clientes_sucursales`
--

DROP TABLE IF EXISTS `tbl_clientes_sucursales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_clientes_sucursales` (
  `id_empresa` int(10) NOT NULL DEFAULT '0',
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL AUTO_INCREMENT,
  `giro` varchar(250) COLLATE utf8_spanish_ci NOT NULL,
  `clase` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT 'D' COMMENT 'a=mejor  b c d=peor',
  `orden` int(10) NOT NULL,
  `usuario_creacion` int(10) NOT NULL,
  `time_creacion` int(10) NOT NULL,
  `rut_empresa` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT '1=activo 0=inactivo',
  `codigo_empresa` int(10) NOT NULL DEFAULT '0' COMMENT 'Codigo del sistema antiguo de tcl',
  `codigo_sucursal` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'Codigo del sistema antiguo de tcl',
  `nombre_sucursal` varchar(50) COLLATE utf8_spanish_ci NOT NULL,
  `direccion` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefonos` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `fax` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `email` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_region` int(10) NOT NULL DEFAULT '0',
  `id_ciudad` int(10) NOT NULL DEFAULT '0',
  `id_comuna` int(10) NOT NULL DEFAULT '0',
  `region` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `ciudad` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `comuna` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `contacto` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id_sucursal` (`id_sucursal`),
  KEY `rut_empresa` (`rut_empresa`),
  KEY `codigo_sucursal` (`codigo_sucursal`),
  KEY `orden` (`orden`),
  KEY `clase` (`clase`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_clientes_sucursales`
--

LOCK TABLES `tbl_clientes_sucursales` WRITE;
/*!40000 ALTER TABLE `tbl_clientes_sucursales` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_clientes_sucursales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_clientes_tipos`
--

DROP TABLE IF EXISTS `tbl_clientes_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_clientes_tipos` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `codigo` char(32) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `etiqueta` varchar(255) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `codigo` (`codigo`),
  KEY `etiqueta` (`etiqueta`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_clientes_tipos`
--

LOCK TABLES `tbl_clientes_tipos` WRITE;
/*!40000 ALTER TABLE `tbl_clientes_tipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_clientes_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_clientes_vendedores`
--

DROP TABLE IF EXISTS `tbl_clientes_vendedores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_clientes_vendedores` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_solicitante` int(10) NOT NULL DEFAULT '0',
  `time_solicitud` int(10) NOT NULL DEFAULT '0',
  `id_vendedor` int(10) NOT NULL DEFAULT '0',
  `id_relacion` int(10) NOT NULL DEFAULT '0',
  `tipo_cliente` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `estado_solicitud` int(1) NOT NULL DEFAULT '0' COMMENT '1=aprobo 0=rechazo',
  `id_respondedor` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario que respondio',
  `time_respuesta` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_clientes_vendedores`
--

LOCK TABLES `tbl_clientes_vendedores` WRITE;
/*!40000 ALTER TABLE `tbl_clientes_vendedores` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_clientes_vendedores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_compra_productos`
--

DROP TABLE IF EXISTS `tbl_compra_productos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_compra_productos` (
  `id_compra` int(10) NOT NULL DEFAULT '0',
  `folio_compra` int(10) NOT NULL DEFAULT '0',
  `folio_notaventa` int(10) NOT NULL DEFAULT '0',
  `folio_ruta` int(10) NOT NULL DEFAULT '0',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'PE=pendiente EM=embalado DE=despachado RE=recibido',
  KEY `id_reserva` (`folio_compra`),
  KEY `folio_notaventa` (`folio_notaventa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_compra_productos`
--

LOCK TABLES `tbl_compra_productos` WRITE;
/*!40000 ALTER TABLE `tbl_compra_productos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_compra_productos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_compra_productos_detalle`
--

DROP TABLE IF EXISTS `tbl_compra_productos_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_compra_productos_detalle` (
  `id_compra` int(10) NOT NULL DEFAULT '0',
  `folio_compra` int(10) NOT NULL DEFAULT '0',
  `folio_notaventa` int(10) NOT NULL DEFAULT '0',
  `codigo_producto` varchar(12) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_proveedor` int(10) NOT NULL DEFAULT '0',
  `prioridad` int(10) NOT NULL DEFAULT '0',
  `cantidad` int(10) NOT NULL DEFAULT '0',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'PE=pendiente EM=embalado DE=despachado RE=recibido',
  KEY `id_reserva` (`id_compra`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_compra_productos_detalle`
--

LOCK TABLES `tbl_compra_productos_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_compra_productos_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_compra_productos_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_compras`
--

DROP TABLE IF EXISTS `tbl_compras`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_compras` (
  `id_compra` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion de la factura',
  `id_bodega` int(10) NOT NULL,
  `rut_folio` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'concatenar rut prov y folio fc para campo unico',
  `numero_compra` int(10) NOT NULL AUTO_INCREMENT COMMENT 'numero unico de cada factura',
  `id_usuario` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario creador de la factura',
  `id_proveedor` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `id_centrocosto` int(10) NOT NULL,
  `rut` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `razon_social` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `nombre_fantasia` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `contacto` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `giro` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `comuna` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `fono` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `factura_importacion` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `costeo_importacion` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no ( Indica cuando la factura ya ha sido costeada)',
  `factura_activofijo` int(1) NOT NULL DEFAULT '0',
  `factura_gasto` int(10) NOT NULL DEFAULT '0',
  `tipo_factura` int(1) NOT NULL DEFAULT '0' COMMENT '1=normal 2=exenta 3=electronica 4=exenta electronica',
  `tipo_contabilizacion` int(1) NOT NULL DEFAULT '0' COMMENT '1=Factura Cuentas 2=Factura por Recibir 3=Factura por ingresar',
  `tipo_documento` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `clase_factura` int(1) NOT NULL DEFAULT '0' COMMENT '0=indefinido 1=Solo cuentas 2=Solo Productos 3=Productos y Cuentas',
  `folio_factura` bigint(15) NOT NULL DEFAULT '0',
  `sw_bloqueo` int(1) NOT NULL DEFAULT '0' COMMENT '0=no bloqueada 1=si bloqueada  ( bloquea la factura cuando esta ya ha sido cerrado el periodo contable )',
  `documento_recepcion` char(3) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'FC=FacturaCompra GD=GuiaDespacho  OC=OrdenCompra',
  `folio_documento_recepcion` int(10) NOT NULL DEFAULT '0' COMMENT 'folio del documento con el cual se recepciono la mercaderia en bodega',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'EP=EnProceso  IN=ingresada  indica si la factura ha sido ingresada al libro de compras',
  `apertura` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `anulada` int(1) NOT NULL DEFAULT '0' COMMENT '0=no 1=si',
  `folio_guiadespacho` varchar(255) COLLATE utf8_spanish_ci NOT NULL COMMENT 'folio-folio-...',
  `folio_ordencompra` varchar(64) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `folio_ordenproduccion` varchar(64) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `time_facturacion` int(10) NOT NULL DEFAULT '0' COMMENT 'timestamp con fecha de emision de la factura',
  `fecha_contable` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT 'fecha libro compras dd/mm/aaaa',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'mes control libro de compras',
  `ano_control` int(4) NOT NULL DEFAULT '0' COMMENT 'ano control libro de compras',
  `numero_control` int(10) NOT NULL DEFAULT '0' COMMENT 'numero de control del periodo del libro de compras',
  `numero_transaccion` int(10) NOT NULL DEFAULT '0' COMMENT 'numero del boucher del ingreso de la factura de compra',
  `contabilizada` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no indica si la factura ha sido contabilizada en el libro diario',
  `fecha_vencimiento` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `time_vencimiento` int(10) NOT NULL,
  `condiciones_pago` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `subtotal` int(10) NOT NULL DEFAULT '0',
  `descuento_porc` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0',
  `neto` int(10) NOT NULL DEFAULT '0',
  `neto_exento` int(10) NOT NULL,
  `iva` int(10) NOT NULL DEFAULT '0',
  `codigo_otrosimpuestos` int(10) NOT NULL,
  `otros_impuestos` int(10) NOT NULL,
  `sw_iva` int(1) NOT NULL,
  `ajustar_iva` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT '+ sube - baja pesos del iva',
  `bruto` int(10) NOT NULL DEFAULT '0',
  `sw_ivausocomun` int(1) NOT NULL,
  `codigo_ivanorecuperable` int(2) NOT NULL,
  `gastos_importacion` int(10) NOT NULL,
  `saldo_pendiente` int(10) NOT NULL DEFAULT '0',
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `numero_importacion` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `numero_despacho` int(10) NOT NULL DEFAULT '0',
  `estado_sii` int(1) NOT NULL,
  `id_recepcion` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `sw_fueraplazo` int(1) NOT NULL,
  `cod_imp_adicional` int(10) NOT NULL,
  `tasa_imp_adicional` decimal(12,2) NOT NULL,
  `monto_imp_adicional` int(10) NOT NULL,
  `origen_documento` int(1) NOT NULL,
  `descuento` int(11) NOT NULL COMMENT 'Porcentaje de descuento',
  `aplica_productos` tinyint(1) NOT NULL COMMENT 'Aplica al Producto',
  UNIQUE KEY `numero_compra` (`numero_compra`),
  KEY `folio_factura` (`folio_factura`),
  KEY `id_proveedor` (`id_proveedor`),
  KEY `mes_control` (`mes_control`),
  KEY `ano_control` (`ano_control`),
  KEY `sw_iva` (`sw_iva`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `direccion` (`direccion`),
  KEY `contacto` (`contacto`),
  KEY `otros_impuestos` (`otros_impuestos`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`),
  KEY `id_bodega` (`id_bodega`),
  KEY `rut` (`rut`),
  KEY `razon_social` (`razon_social`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_compras`
--

LOCK TABLES `tbl_compras` WRITE;
/*!40000 ALTER TABLE `tbl_compras` DISABLE KEYS */;
INSERT INTO `tbl_compras` VALUES (0,0,'0',1,0,0,0,0,0,'78706540-6','AUTOMOTORA MIGUEL JACOB HELO Y CÍA. LTDA.','0','','','','','','',0,0,0,0,0,0,'33',0,190837,0,'0',0,'PR',0,0,'','','','14/12/2023',0,'01/12/2023','0',0,0,0,0,'14/12/2023',0,'0',0,0.0000,0,11190000,2126100,0,0,0,0,'',13316100,0,0,0,0,'','0',0,0,'',0,0,0.00,0,5,0,0),(0,0,'0',2,0,0,0,0,0,'76620108-3','REPARACIN ELCTRICA, COMPRA Y VENTA DE PARTES, PIEZAS Y ACCESORIOS DE','0','','','','','','',0,0,0,0,0,0,'33',0,3138,0,'0',0,'PR',0,0,'','','','22/12/2023',0,'01/12/2023','0',0,0,0,0,'22/12/2023',0,'0',0,0.0000,0,163781,31118,0,0,0,0,'',194899,0,0,0,0,'','0',0,0,'',0,0,0.00,0,5,0,0);
/*!40000 ALTER TABLE `tbl_compras` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_compras_credito`
--

DROP TABLE IF EXISTS `tbl_compras_credito`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_compras_credito` (
  `id_compra` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion de la factura',
  `id_bodega` int(10) NOT NULL,
  `rut_folio` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'concatenar rut prov y folio fc para campo unico',
  `numero_compra` int(10) NOT NULL AUTO_INCREMENT COMMENT 'numero unico de cada factura',
  `id_usuario` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario creador de la factura',
  `id_proveedor` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `id_centrocosto` int(10) NOT NULL,
  `rut` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `razon_social` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `nombre_fantasia` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `contacto` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `giro` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `comuna` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `fono` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `factura_importacion` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `costeo_importacion` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no ( Indica cuando la factura ya ha sido costeada)',
  `factura_activofijo` int(1) NOT NULL DEFAULT '0',
  `factura_gasto` int(10) NOT NULL DEFAULT '0',
  `tipo_factura` int(1) NOT NULL DEFAULT '0' COMMENT '1=normal 2=exenta 3=electronica 4=exenta electronica',
  `tipo_contabilizacion` int(1) NOT NULL DEFAULT '0' COMMENT '1=Factura Cuentas 2=Factura por Recibir 3=Factura por ingresar',
  `tipo_documento` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `clase_factura` int(1) NOT NULL DEFAULT '0' COMMENT '0=indefinido 1=Solo cuentas 2=Solo Productos 3=Productos y Cuentas',
  `folio_factura` int(10) NOT NULL DEFAULT '0',
  `sw_bloqueo` int(1) NOT NULL DEFAULT '0' COMMENT '0=no bloqueada 1=si bloqueada  ( bloquea la factura cuando esta ya ha sido cerrado el periodo contable )',
  `documento_recepcion` char(3) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'FC=FacturaCompra GD=GuiaDespacho  OC=OrdenCompra',
  `folio_documento_recepcion` int(10) NOT NULL DEFAULT '0' COMMENT 'folio del documento con el cual se recepciono la mercaderia en bodega',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'EP=EnProceso  IN=ingresada  indica si la factura ha sido ingresada al libro de compras',
  `apertura` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `anulada` int(1) NOT NULL DEFAULT '0' COMMENT '0=no 1=si',
  `folio_guiadespacho` varchar(255) COLLATE utf8_spanish_ci NOT NULL COMMENT 'folio-folio-...',
  `folio_ordencompra` varchar(64) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `folio_ordenproduccion` varchar(64) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `time_facturacion` int(10) NOT NULL DEFAULT '0' COMMENT 'timestamp con fecha de emision de la factura',
  `fecha_contable` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT 'fecha libro compras dd/mm/aaaa',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'mes control libro de compras',
  `ano_control` int(4) NOT NULL DEFAULT '0' COMMENT 'ano control libro de compras',
  `numero_control` int(10) NOT NULL DEFAULT '0' COMMENT 'numero de control del periodo del libro de compras',
  `numero_transaccion` int(10) NOT NULL DEFAULT '0' COMMENT 'numero del boucher del ingreso de la factura de compra',
  `contabilizada` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no indica si la factura ha sido contabilizada en el libro diario',
  `fecha_vencimiento` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `time_vencimiento` int(10) NOT NULL,
  `condiciones_pago` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `subtotal` int(10) NOT NULL DEFAULT '0',
  `descuento_porc` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0',
  `neto` int(10) NOT NULL DEFAULT '0',
  `neto_exento` int(10) NOT NULL,
  `iva` int(10) NOT NULL DEFAULT '0',
  `otros_impuestos` int(10) NOT NULL,
  `sw_iva` int(1) NOT NULL,
  `ajustar_iva` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT '+ sube - baja pesos del iva',
  `bruto` int(10) NOT NULL DEFAULT '0',
  `gastos_importacion` int(10) NOT NULL,
  `saldo_pendiente` int(10) NOT NULL DEFAULT '0',
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `numero_importacion` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `numero_despacho` int(10) NOT NULL DEFAULT '0',
  `referencia_folio` int(11) DEFAULT NULL,
  `referencia_tipo_doc` int(11) DEFAULT NULL,
  `origen_documento` int(1) NOT NULL,
  UNIQUE KEY `numero_compra` (`numero_compra`),
  KEY `folio_factura` (`folio_factura`),
  KEY `id_proveedor` (`id_proveedor`),
  KEY `mes_control` (`mes_control`),
  KEY `ano_control` (`ano_control`),
  KEY `sw_iva` (`sw_iva`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `direccion` (`direccion`),
  KEY `contacto` (`contacto`),
  KEY `otros_impuestos` (`otros_impuestos`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`),
  KEY `id_bodega` (`id_bodega`),
  KEY `rut` (`rut`),
  KEY `razon_social` (`razon_social`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_compras_credito`
--

LOCK TABLES `tbl_compras_credito` WRITE;
/*!40000 ALTER TABLE `tbl_compras_credito` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_compras_credito` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_compras_debito`
--

DROP TABLE IF EXISTS `tbl_compras_debito`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_compras_debito` (
  `id_compra` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion de la factura',
  `id_bodega` int(10) NOT NULL,
  `rut_folio` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'concatenar rut prov y folio fc para campo unico',
  `numero_compra` int(10) NOT NULL AUTO_INCREMENT COMMENT 'numero unico de cada factura',
  `id_usuario` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario creador de la factura',
  `id_proveedor` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `id_centrocosto` int(10) NOT NULL,
  `rut` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `razon_social` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `nombre_fantasia` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `contacto` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `giro` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `comuna` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `fono` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `factura_importacion` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `costeo_importacion` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no ( Indica cuando la factura ya ha sido costeada)',
  `factura_activofijo` int(1) NOT NULL DEFAULT '0',
  `factura_gasto` int(10) NOT NULL DEFAULT '0',
  `tipo_factura` int(1) NOT NULL DEFAULT '0' COMMENT '1=normal 2=exenta 3=electronica 4=exenta electronica',
  `tipo_contabilizacion` int(1) NOT NULL DEFAULT '0' COMMENT '1=Factura Cuentas 2=Factura por Recibir 3=Factura por ingresar',
  `tipo_documento` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `clase_factura` int(1) NOT NULL DEFAULT '0' COMMENT '0=indefinido 1=Solo cuentas 2=Solo Productos 3=Productos y Cuentas',
  `folio_factura` int(10) NOT NULL DEFAULT '0',
  `sw_bloqueo` int(1) NOT NULL DEFAULT '0' COMMENT '0=no bloqueada 1=si bloqueada  ( bloquea la factura cuando esta ya ha sido cerrado el periodo contable )',
  `documento_recepcion` char(3) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'FC=FacturaCompra GD=GuiaDespacho  OC=OrdenCompra',
  `folio_documento_recepcion` int(10) NOT NULL DEFAULT '0' COMMENT 'folio del documento con el cual se recepciono la mercaderia en bodega',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'EP=EnProceso  IN=ingresada  indica si la factura ha sido ingresada al libro de compras',
  `apertura` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `anulada` int(1) NOT NULL DEFAULT '0' COMMENT '0=no 1=si',
  `folio_guiadespacho` varchar(255) COLLATE utf8_spanish_ci NOT NULL COMMENT 'folio-folio-...',
  `folio_ordencompra` varchar(64) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `folio_ordenproduccion` varchar(64) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `time_facturacion` int(10) NOT NULL DEFAULT '0' COMMENT 'timestamp con fecha de emision de la factura',
  `fecha_contable` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT 'fecha libro compras dd/mm/aaaa',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'mes control libro de compras',
  `ano_control` int(4) NOT NULL DEFAULT '0' COMMENT 'ano control libro de compras',
  `numero_control` int(10) NOT NULL DEFAULT '0' COMMENT 'numero de control del periodo del libro de compras',
  `numero_transaccion` int(10) NOT NULL DEFAULT '0' COMMENT 'numero del boucher del ingreso de la factura de compra',
  `contabilizada` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no indica si la factura ha sido contabilizada en el libro diario',
  `fecha_vencimiento` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `time_vencimiento` int(10) NOT NULL,
  `condiciones_pago` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `subtotal` int(10) NOT NULL DEFAULT '0',
  `descuento_porc` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0',
  `neto` int(10) NOT NULL DEFAULT '0',
  `neto_exento` int(10) NOT NULL,
  `iva` int(10) NOT NULL DEFAULT '0',
  `otros_impuestos` int(10) NOT NULL,
  `sw_iva` int(1) NOT NULL,
  `ajustar_iva` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT '+ sube - baja pesos del iva',
  `bruto` int(10) NOT NULL DEFAULT '0',
  `gastos_importacion` int(10) NOT NULL,
  `saldo_pendiente` int(10) NOT NULL DEFAULT '0',
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `numero_importacion` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `numero_despacho` int(10) NOT NULL DEFAULT '0',
  `origen_documento` int(1) NOT NULL,
  `referencia_tipo_doc` int(11) NOT NULL,
  `referencia_folio` int(11) NOT NULL,
  UNIQUE KEY `numero_compra` (`numero_compra`),
  KEY `folio_factura` (`folio_factura`),
  KEY `id_proveedor` (`id_proveedor`),
  KEY `mes_control` (`mes_control`),
  KEY `ano_control` (`ano_control`),
  KEY `sw_iva` (`sw_iva`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `direccion` (`direccion`),
  KEY `contacto` (`contacto`),
  KEY `otros_impuestos` (`otros_impuestos`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`),
  KEY `id_bodega` (`id_bodega`),
  KEY `rut` (`rut`),
  KEY `razon_social` (`razon_social`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_compras_debito`
--

LOCK TABLES `tbl_compras_debito` WRITE;
/*!40000 ALTER TABLE `tbl_compras_debito` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_compras_debito` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_comprasdetalle`
--

DROP TABLE IF EXISTS `tbl_comprasdetalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_comprasdetalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `id_compra` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de recepcion de la compra',
  `numero_compra` int(10) NOT NULL DEFAULT '0',
  `id_proveedor` int(10) NOT NULL DEFAULT '0',
  `id_item` int(10) NOT NULL DEFAULT '0',
  `id_centrocosto` int(2) NOT NULL DEFAULT '0',
  `id_centronegocio` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT 'Id del proyecto al cual esta asociado este gasto',
  `id_activofijo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_bodega` int(10) NOT NULL DEFAULT '0',
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'C=cuenta P=producto S=servicio',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `rut` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_factura` int(10) NOT NULL DEFAULT '0',
  `folio_guiadespacho` varchar(100) COLLATE utf8_spanish_ci NOT NULL COMMENT 'folios de guias de despacho asociadas a la factura, se separan por guiones',
  `folio_ordencompra` int(10) NOT NULL DEFAULT '0',
  `folio_notaventa` int(10) NOT NULL DEFAULT '0',
  `folio_importacion` int(10) NOT NULL DEFAULT '0',
  `folio_ordenproduccion` int(10) NOT NULL,
  `id_item_ordenproduccion` int(10) NOT NULL,
  `fecha_compra` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `time_compra` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp de fecha de emision de la factura',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'mes de contabilizacion',
  `ano_control` int(4) NOT NULL DEFAULT '0' COMMENT 'año de contabilizacion',
  `numero_control` int(10) NOT NULL DEFAULT '0' COMMENT 'numero de contabilizacion',
  `codigo_producto` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `sw_exento` int(1) NOT NULL,
  `codigo_final` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `impuesto` int(1) NOT NULL DEFAULT '0' COMMENT '1=SI 0=NO (Indica si el item esta afecto a iva)',
  `cod_imp_adicional` int(3) NOT NULL,
  `tasa_imp_adicional` decimal(10,3) NOT NULL,
  `monto_imp_adicional` int(10) NOT NULL,
  `precio_lista` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'Precio de lista del proveedor',
  `descuento_porc` int(2) NOT NULL DEFAULT '0' COMMENT 'Porcentaje de descuento lineal',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0' COMMENT 'Descuento lineal en pesos',
  `precio_compra` decimal(15,5) NOT NULL DEFAULT '0.00000' COMMENT 'Precio de compra con descuento lineal aplicado',
  `precio_final` decimal(12,2) NOT NULL,
  `cantidad` decimal(15,5) NOT NULL,
  `cantidad_devuelta` int(10) NOT NULL DEFAULT '0' COMMENT 'cantidad devuelta con notas de credito',
  `bultos` int(10) NOT NULL,
  `lote` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `serie` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `subtotal` decimal(12,2) NOT NULL DEFAULT '0.00',
  `descuento_global` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT '% de descuento global aplicado a la factura',
  `subtotal_final` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal neto con el descuento global aplicado',
  `descuento` int(11) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `id_compra` (`id_compra`),
  KEY `id_proveedor` (`id_proveedor`),
  KEY `folio_ordencompra` (`folio_ordencompra`),
  KEY `codigo_producto` (`codigo_producto`),
  KEY `folio_guiadespacho` (`folio_guiadespacho`),
  KEY `estado` (`estado`),
  KEY `id_centronegocio` (`id_centronegocio`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`),
  KEY `id_item_ordenproduccion` (`id_item_ordenproduccion`),
  KEY `codigo_final` (`codigo_final`),
  KEY `id_bodega` (`id_bodega`),
  KEY `folio` (`folio`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_comprasdetalle`
--

LOCK TABLES `tbl_comprasdetalle` WRITE;
/*!40000 ALTER TABLE `tbl_comprasdetalle` DISABLE KEYS */;
INSERT INTO `tbl_comprasdetalle` VALUES (1,1,0,0,0,1,0,0,0,'',0,'C','PR','0',190837,'',0,0,0,0,0,'0',0,'0',0,0,'102010301',0,'','CUENTA CONTABLE #102010301','',0,0,0.000,0,0.00,0,0,0.00000,0.00,1.00000,0,0,'','',11190000.00,0.00,11190000,0),(2,1,0,0,0,1,0,0,0,'',0,'C','PR','0',190837,'',0,0,0,0,0,'0',0,'0',0,0,'102010301',1,'','CUENTA CONTABLE #102010301','',0,0,0.000,0,0.00,0,0,0.00000,0.00,1.00000,0,0,'','',2126100.00,0.00,2126100,0),(3,2,0,0,0,1,0,0,0,'',0,'C','PR','0',3138,'',0,0,0,0,0,'0',0,'0',0,0,'301020905',0,'','CUENTA CONTABLE #301020905','',0,0,0.000,0,0.00,0,0,0.00000,0.00,1.00000,0,0,'','',163781.00,0.00,163781,0),(4,2,0,0,0,1,0,0,0,'',0,'C','PR','0',3138,'',0,0,0,0,0,'0',0,'0',0,0,'301020905',1,'','CUENTA CONTABLE #301020905','',0,0,0.000,0,0.00,0,0,0.00000,0.00,1.00000,0,0,'','',31118.00,0.00,31118,0);
/*!40000 ALTER TABLE `tbl_comprasdetalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_comprasdetalle_credito`
--

DROP TABLE IF EXISTS `tbl_comprasdetalle_credito`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_comprasdetalle_credito` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `id_compra` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de recepcion de la compra',
  `numero_compra` int(10) NOT NULL DEFAULT '0',
  `id_proveedor` int(10) NOT NULL DEFAULT '0',
  `id_item` int(10) NOT NULL DEFAULT '0',
  `id_centrocosto` int(2) NOT NULL DEFAULT '0',
  `id_centronegocio` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT 'Id del proyecto al cual esta asociado este gasto',
  `id_activofijo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_bodega` int(10) NOT NULL DEFAULT '0',
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'C=cuenta P=producto S=servicio',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `rut` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_factura` int(10) NOT NULL DEFAULT '0',
  `folio_guiadespacho` varchar(100) COLLATE utf8_spanish_ci NOT NULL COMMENT 'folios de guias de despacho asociadas a la factura, se separan por guiones',
  `folio_ordencompra` int(10) NOT NULL DEFAULT '0',
  `folio_notaventa` int(10) NOT NULL DEFAULT '0',
  `folio_importacion` int(10) NOT NULL DEFAULT '0',
  `folio_ordenproduccion` int(10) NOT NULL,
  `id_item_ordenproduccion` int(10) NOT NULL,
  `fecha_compra` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `time_compra` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp de fecha de emision de la factura',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'mes de contabilizacion',
  `ano_control` int(4) NOT NULL DEFAULT '0' COMMENT 'año de contabilizacion',
  `numero_control` int(10) NOT NULL DEFAULT '0' COMMENT 'numero de contabilizacion',
  `codigo_producto` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_final` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `impuesto` int(1) NOT NULL DEFAULT '0' COMMENT '1=SI 0=NO (Indica si el item esta afecto a iva)',
  `cod_imp_adicional` int(3) NOT NULL,
  `tasa_imp_adicional` decimal(10,3) NOT NULL,
  `monto_imp_adicional` int(10) NOT NULL,
  `precio_lista` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'Precio de lista del proveedor',
  `descuento_porc` int(2) NOT NULL DEFAULT '0' COMMENT 'Porcentaje de descuento lineal',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0' COMMENT 'Descuento lineal en pesos',
  `precio_compra` decimal(15,5) NOT NULL DEFAULT '0.00000' COMMENT 'Precio de compra con descuento lineal aplicado',
  `precio_final` decimal(12,2) NOT NULL,
  `cantidad` decimal(15,5) NOT NULL,
  `cantidad_devuelta` int(10) NOT NULL DEFAULT '0' COMMENT 'cantidad devuelta con notas de credito',
  `bultos` int(10) NOT NULL,
  `lote` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `serie` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `subtotal` decimal(12,2) NOT NULL DEFAULT '0.00',
  `descuento_global` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT '% de descuento global aplicado a la factura',
  `subtotal_final` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal neto con el descuento global aplicado',
  `sw_exento` int(1) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `id_compra` (`id_compra`),
  KEY `id_proveedor` (`id_proveedor`),
  KEY `folio_ordencompra` (`folio_ordencompra`),
  KEY `codigo_producto` (`codigo_producto`),
  KEY `folio_guiadespacho` (`folio_guiadespacho`),
  KEY `estado` (`estado`),
  KEY `id_centronegocio` (`id_centronegocio`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`),
  KEY `id_item_ordenproduccion` (`id_item_ordenproduccion`),
  KEY `codigo_final` (`codigo_final`),
  KEY `id_bodega` (`id_bodega`),
  KEY `folio` (`folio`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_comprasdetalle_credito`
--

LOCK TABLES `tbl_comprasdetalle_credito` WRITE;
/*!40000 ALTER TABLE `tbl_comprasdetalle_credito` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_comprasdetalle_credito` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_comprasdetalle_debito`
--

DROP TABLE IF EXISTS `tbl_comprasdetalle_debito`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_comprasdetalle_debito` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `id_compra` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de recepcion de la compra',
  `numero_compra` int(10) NOT NULL DEFAULT '0',
  `id_proveedor` int(10) NOT NULL DEFAULT '0',
  `id_item` int(10) NOT NULL DEFAULT '0',
  `id_centrocosto` int(2) NOT NULL DEFAULT '0',
  `id_centronegocio` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT 'Id del proyecto al cual esta asociado este gasto',
  `id_activofijo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_bodega` int(10) NOT NULL DEFAULT '0',
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'C=cuenta P=producto S=servicio',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `rut` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_factura` int(10) NOT NULL DEFAULT '0',
  `folio_guiadespacho` varchar(100) COLLATE utf8_spanish_ci NOT NULL COMMENT 'folios de guias de despacho asociadas a la factura, se separan por guiones',
  `folio_ordencompra` int(10) NOT NULL DEFAULT '0',
  `folio_notaventa` int(10) NOT NULL DEFAULT '0',
  `folio_importacion` int(10) NOT NULL DEFAULT '0',
  `folio_ordenproduccion` int(10) NOT NULL,
  `id_item_ordenproduccion` int(10) NOT NULL,
  `fecha_compra` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `time_compra` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp de fecha de emision de la factura',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'mes de contabilizacion',
  `ano_control` int(4) NOT NULL DEFAULT '0' COMMENT 'año de contabilizacion',
  `numero_control` int(10) NOT NULL DEFAULT '0' COMMENT 'numero de contabilizacion',
  `codigo_producto` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_final` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `impuesto` int(1) NOT NULL DEFAULT '0' COMMENT '1=SI 0=NO (Indica si el item esta afecto a iva)',
  `cod_imp_adicional` int(3) NOT NULL,
  `tasa_imp_adicional` decimal(10,3) NOT NULL,
  `monto_imp_adicional` int(10) NOT NULL,
  `precio_lista` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'Precio de lista del proveedor',
  `descuento_porc` int(2) NOT NULL DEFAULT '0' COMMENT 'Porcentaje de descuento lineal',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0' COMMENT 'Descuento lineal en pesos',
  `precio_compra` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'Precio de compra con descuento lineal aplicado',
  `precio_final` decimal(12,2) NOT NULL,
  `cantidad` decimal(12,2) NOT NULL,
  `cantidad_devuelta` int(10) NOT NULL DEFAULT '0' COMMENT 'cantidad devuelta con notas de credito',
  `bultos` int(10) NOT NULL,
  `lote` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `serie` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `subtotal` decimal(12,2) NOT NULL DEFAULT '0.00',
  `descuento_global` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT '% de descuento global aplicado a la factura',
  `subtotal_final` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal neto con el descuento global aplicado',
  `sw_exento` int(1) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `id_compra` (`id_compra`),
  KEY `id_proveedor` (`id_proveedor`),
  KEY `folio_ordencompra` (`folio_ordencompra`),
  KEY `codigo_producto` (`codigo_producto`),
  KEY `folio_guiadespacho` (`folio_guiadespacho`),
  KEY `estado` (`estado`),
  KEY `id_centronegocio` (`id_centronegocio`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`),
  KEY `id_item_ordenproduccion` (`id_item_ordenproduccion`),
  KEY `codigo_final` (`codigo_final`),
  KEY `id_bodega` (`id_bodega`),
  KEY `folio` (`folio`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_comprasdetalle_debito`
--

LOCK TABLES `tbl_comprasdetalle_debito` WRITE;
/*!40000 ALTER TABLE `tbl_comprasdetalle_debito` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_comprasdetalle_debito` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_comunas`
--

DROP TABLE IF EXISTS `tbl_comunas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_comunas` (
  `id_comuna` int(10) NOT NULL AUTO_INCREMENT,
  `id_provincia` decimal(10,0) NOT NULL DEFAULT '0',
  `id_region` decimal(10,0) NOT NULL DEFAULT '0',
  `numero` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `id_comuna` (`id_comuna`)
) ENGINE=InnoDB AUTO_INCREMENT=346 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_comunas`
--

LOCK TABLES `tbl_comunas` WRITE;
/*!40000 ALTER TABLE `tbl_comunas` DISABLE KEYS */;
INSERT INTO `tbl_comunas` VALUES (1,1,1,'01101','ARICA'),(2,1,1,'01106','CAMARONES'),(3,2,1,'01301','PUTRE'),(4,2,1,'01302','GENERAL LAGOS'),(5,3,2,'01201','IQUIQUE'),(6,3,2,'01211','ALTO HOSPICIO'),(7,4,2,'01204','POZO ALMONTE'),(8,4,2,'01208','CAMIÑA'),(9,4,2,'01210','COLCHANE'),(10,4,2,'01206','HUARA'),(11,4,2,'01203','PICA'),(12,5,3,'02201','ANTOFAGASTA'),(13,5,3,'02203','MEJILLONES'),(14,5,3,'02206','SIERRA GORDA'),(15,5,3,'02202','TALTAL'),(16,6,3,'02301','CALAMA'),(17,6,3,'02302','OLLAGUE'),(18,6,3,'02302','SAN PEDRO DE ATACAMA'),(19,7,3,'02101','TOCOPILLA'),(20,7,3,'02103','MARÍA ELENA'),(21,8,4,'03201','COPIAPÓ'),(22,8,4,'03202','CALDERA'),(23,8,4,'03203','TIERRA AMARILLA'),(24,9,4,'03101','CHAÑARAL'),(25,9,4,'03102','DIEGO DE ALMAGRO'),(26,10,4,'03301','VALLENAR'),(27,10,4,'03304','ALTO DEL CARMEN'),(28,10,4,'03302','FREIRINA'),(29,10,4,'03303','HUASCO'),(30,11,5,'04101','LA SERENA'),(31,11,5,'04103','COQUIMBO'),(32,11,5,'04104','ANDACOLLO'),(33,11,5,'04102','LA HIGUERA'),(34,12,5,'04301','ILLAPEL'),(35,12,5,'04304','CANELA'),(36,12,5,'04303','LOS VILOS'),(37,12,5,'04302','SALAMANCA'),(38,13,5,'04202','OVALLE'),(39,13,5,'04205','COMBARBALÁ'),(40,13,5,'04203','MONTE PATRIA'),(41,13,5,'04204','PUNITAQUI'),(42,13,5,'04206','RÍO HURTADO'),(43,14,6,'05301','VALPARAÍSO'),(44,14,6,'05305','CASABLANCA'),(45,14,6,'05309','CONCÓN'),(46,14,6,'05308','JUAN FENÁNDEZ'),(47,14,6,'05307','PUCHUNCAVÍ'),(48,14,6,'05306','QUINTERO'),(49,14,6,'05302','VIÑA DEL MAR'),(50,11,5,'04105','VICUÑA'),(51,11,5,'04106','PAIHUANO'),(52,16,6,'05701','LOS ANDES'),(53,16,6,'05702','CALLE LARGA'),(54,16,6,'05704','RINCONADA'),(55,16,6,'05703','SAN ESTEBAN'),(56,17,6,'05201','LA LIGUA'),(57,17,6,'05203','CABILDO'),(58,17,6,'05205','PAPUDO'),(59,17,6,'05202','PETORCA'),(60,17,6,'05204','ZAPALLAR'),(61,18,6,'05501','QUILLOTA'),(62,18,6,'05504','CALERA'),(63,18,6,'05503','HIJUALAS'),(64,18,6,'05505','LA CRUZ'),(65,18,6,'05502','NOGALES'),(66,19,6,'05401','SAN ANTONIO'),(67,19,6,'05406','ALGARROBO'),(68,19,6,'05403','CARTAGENA'),(69,19,6,'05405','EL QUISCO'),(70,19,6,'05404','EL TABO'),(71,19,6,'05402','SANTO DOMINGO'),(72,20,6,'05601','SAN FELIPE'),(73,20,6,'05603','CATEMU'),(74,20,6,'05606','LLAILLAY'),(75,20,6,'05602','PANQUEHUE'),(76,20,6,'05604','PUTAENDO'),(77,20,6,'05605','SANTA MARÍA'),(78,21,6,'05506','LIMACHE'),(79,21,6,'05304','QUILPUÉ'),(80,21,6,'05303','VILLA ALEMANA'),(81,21,6,'05507','OLMUÉ'),(82,22,7,'06101','RANCAGUA'),(83,22,7,'06107','CODEGUA'),(84,22,7,'06116','COINCO'),(85,22,7,'06106','COLTAUCO'),(86,22,7,'06105','DOÑIHUE'),(87,22,7,'06103','GRANEROS'),(88,22,7,'06109','LAS CABRAS'),(89,22,7,'06102','MACHALÍ'),(90,22,7,'06115','MALLOA'),(91,22,7,'06114','OLIVAR'),(92,22,7,'06104','SAN FRANCISCO DE MOSTAZAL'),(93,22,7,'06108','PEUMO'),(94,22,7,'06111','PICHIDEGUA'),(95,22,7,'06117','QUINTA DE TILCOCO'),(96,22,7,'06112','RENGO'),(97,22,7,'06113','REQUÍNOA'),(98,22,7,'06110','SAN VICENTE'),(99,23,7,'06301','PICHILEMU'),(100,23,7,'06304','LA ESTRELLA'),(101,23,7,'06303','LITUECHE'),(102,23,7,'06305','MARICHIGUE'),(103,23,7,'06302','NAVIDAD'),(104,23,7,'06306','PAREDONES'),(105,24,7,'06201','SAN FERNANDO'),(106,24,7,'06202','CHIMBARONGO'),(107,24,7,'06203','NANCAGUA'),(108,24,7,'06205','SANTA CRUZ'),(109,24,7,'06209','CHEPICA'),(110,24,7,'06206','LOLOL'),(111,24,7,'06207','PALMILLA'),(112,24,7,'06208','PERALILLO'),(113,24,7,'06214','PUMANQUE'),(114,25,8,'07201','TALCA'),(115,25,8,'07208','CONSTITUCION'),(116,25,8,'07207','CUREPTO'),(117,25,8,'07209','EMPEDRADO'),(118,25,8,'07205','PENCAHUE'),(119,25,8,'07204','RÍO CLARO'),(120,25,8,'07202','SAN CLEMENTE'),(121,25,8,'07210','SAN RAFAEL'),(122,25,8,'07206','MAULE'),(123,25,8,'07203','PELARCO'),(124,26,8,'07401','CAUQUENES'),(125,26,8,'07403','CHANCO'),(126,26,8,'07402','PELLUHUE'),(127,27,8,'07101','CURICÓ'),(128,27,8,'07102','TENO'),(129,27,8,'07103','ROMERAL'),(130,27,8,'07104','RAUCO'),(131,27,8,'07105','LICANTEN'),(132,27,8,'07106','VICHUQUEN'),(133,27,8,'07107','HUALANE'),(134,27,8,'07108','MOLINA'),(135,27,8,'07109','SAGRADA FAMILIA'),(136,28,8,'07301','LINARES'),(137,28,8,'07302','YERBAS BUENAS'),(138,28,8,'07303','COLBUN'),(139,28,8,'07304','LONGAVI'),(140,28,8,'07305','PARRAL'),(141,28,8,'07306','RETIRO'),(142,28,8,'07309','VILLA ALEGRE'),(143,28,8,'07310','SAN JAVIER'),(144,29,9,'08201','CONCEPCIÓN'),(145,29,9,'08207','CORONEL'),(146,29,9,'08204','FLORIDA'),(147,29,9,'08203','HUALQUI'),(148,29,9,'08208','LOTA'),(149,29,9,'08202','PENCO'),(150,29,9,'08205','TOMÉ'),(151,29,9,'08206','TALCAHUANO'),(152,29,9,'08209','SANTA JUANA'),(153,29,9,'08210','SAN PEDRO DE LA PAZ'),(154,29,9,'08212','HUALPÉN'),(155,29,9,'08211','CHIGUAYANTE'),(156,30,9,'08303','LEBU'),(157,30,9,'08301','ARAUCO'),(158,30,9,'08305','CAÑETE'),(159,30,9,'08306','CONTULMO'),(160,30,9,'08302','CURANILAHUE'),(161,30,9,'08304','LOS ALOMOS'),(162,30,9,'08307','TIRÚA'),(163,31,9,'08401','LOS ANGELES'),(164,31,9,'08413','ARTUCO'),(165,31,9,'08410','CABRERO'),(166,31,9,'08403','LAJA'),(167,31,9,'08407','MULCHÉN'),(168,31,9,'08405','NACIMIENTO'),(169,31,9,'08406','NEGRETE'),(171,31,9,'08404','QUILLECO'),(172,31,9,'08408','QUILACO'),(173,31,9,'08411','SAN ROSENDO'),(174,31,9,'08402','SANTA BÁRBARA'),(175,31,9,'08412','TUCAPEL'),(176,31,9,'08409','YUMBEL'),(177,31,9,'08414','ALTO BIOBÍO'),(178,32,9,'08101','CHILLÁN'),(179,32,9,'08113','BULNES'),(180,32,9,'08107','COBQUECURA'),(181,32,9,'08120','COELEMU'),(182,32,9,'08103','COIHUECO'),(184,32,9,'08121','CHILLÁN VIEJO'),(185,32,9,'08118','EL CARMEN'),(186,32,9,'08105','NINHUE'),(187,32,9,'08110','ÑIQUÉN'),(188,32,9,'08117','PEMUCO'),(189,32,9,'08102','PINTO'),(190,32,9,'08106','PORTEZUELO'),(191,32,9,'08115','QUILLÓN'),(192,32,9,'08104','QUIRIHUE'),(193,32,9,'08119','RÁNQUIL'),(194,32,9,'08109','SAN CARLOS '),(195,32,9,'08111','SAN FABIÁN'),(196,32,9,'08114','SAN IGNACIO'),(197,32,9,'08112','SAN NICOLÁS'),(198,32,9,'08108','TREGUACO'),(199,32,9,'08116','YUNGAY'),(200,33,10,'09201','TEMUCO'),(201,33,10,'09204','CUNCO'),(202,33,10,'09218','CURARREHUE'),(203,33,10,'09203','FREIRE'),(204,33,10,'09207','GALVARINO'),(205,33,10,'09212','GORBEA'),(206,33,10,'09205','LAUTARO'),(207,33,10,'09214','LONCOCHE'),(208,33,10,'09217','MELIPEUCO'),(209,33,10,'09208','NUEVA IMPERIAL'),(210,33,10,'09220','PADRE LAS CASAS'),(211,33,10,'09206','PERQUENCO'),(212,33,10,'09211','PITRUFQUÉN'),(213,33,10,'09216','PUCÓN'),(214,33,10,'09210','SAAVEDRA'),(215,33,10,'09219','TEODORO SCHMIDT'),(216,33,10,'09213','TOLTÉN'),(217,33,10,'09202','VILCÚN'),(218,33,10,'09221','CHOLCHOL'),(219,33,10,'09215','VILLARICA'),(220,34,10,'09101','ANGOL'),(221,34,10,'09105','COLLIPULLI'),(222,34,10,'09110','CURACAUTÍN'),(223,34,10,'09106','ERCILLA'),(224,34,10,'09111','LONQUIMAY'),(225,34,10,'09103','LOS SAUCES'),(226,34,10,'09108','LUMACO'),(227,34,10,'09102','PURÉN'),(228,34,10,'09107','TRAIGUÉN'),(229,34,10,'09104','RENAICO'),(230,34,10,'09109','VICTORIA'),(231,35,11,'10101','VALDIVIA'),(232,35,11,'10106','CORRAL'),(233,35,11,'10103','LANCO'),(234,35,11,'10104','LOS LAGOS'),(235,35,11,'10107','MÁFIL'),(236,35,11,'10102','MARIQUINA'),(237,35,11,'10108','PANGUIPULLI'),(238,36,11,'10109','LA UNIÓN'),(239,36,11,'10105','FUTRONO'),(240,36,11,'10112','LAGO RANCO'),(241,36,11,'10111','RÍO BUENO'),(242,37,12,'10301','PUERTO MONTT'),(243,37,12,'10309','CALBUCO'),(244,37,12,'10302','COCHAMÓ'),(245,37,12,'10304','FRESIA'),(246,37,12,'10305','FRUTILLAR'),(247,37,12,'10308','LOS MUERMOS'),(248,37,12,'10307','MAULLÍN'),(249,37,12,'10303','PUERTO VARAS'),(250,37,12,'10306','LLANQUIHUE'),(251,38,12,'10401','CASTRO'),(252,38,12,'10406','ANCUD'),(253,38,12,'10402','CHONCHI'),(254,38,12,'10410','CURACO DE VÉLEZ'),(255,38,12,'10408','DALCAHUE'),(256,38,12,'10405','PUQUELDÓN'),(257,38,12,'10403','QUEILÉN'),(258,38,12,'10404','QUELLÓN'),(259,38,12,'10407','QUEMCHI'),(260,38,12,'10415','QUINCHAO'),(261,39,12,'10201','OSORNO'),(262,39,12,'10203','PUERTO OCTAY'),(263,39,12,'10206','PURRANQUE'),(264,39,12,'10205','RÍO NEGRO'),(265,39,12,'10207','SAN JUAN DE LA COSTA'),(266,39,12,'10202','SAN PABLO'),(267,39,12,'10204','PUYEHUE'),(268,40,12,'10501','CHAITÉN'),(269,40,12,'10503','FUTALEUFÚ'),(270,40,12,'10502','HUALAIHUÉ'),(271,40,12,'10504','PALENA'),(272,41,13,'11401','COIHAIQUE'),(273,41,13,'11402','LAGO VERDE'),(274,45,13,'11101','AISÉN'),(275,45,13,'11102','CISNES'),(276,45,13,'11104','GUAITECAS'),(277,44,13,'11301','COCHRANE'),(278,0,0,'11303','TORTEL'),(279,44,13,'11303','TORTEL'),(280,46,13,'11201','CHILE CHICO'),(282,46,13,'11203','RÍO IBÁÑEZ'),(283,47,14,'12205','PUNTA ARENAS'),(284,47,14,'12206','LAGUNA BLANCA'),(285,47,14,'12202','RÍO VERDE'),(286,47,14,'12204','SAN GREGORIO'),(287,48,14,'12401','CABO DE HORNOS (EX-NAVARINO)'),(288,49,14,'12301','PORVENIR '),(289,49,14,'12302','PRIMAVERA'),(290,49,14,'12304','TIMAUKEL'),(291,50,14,'12101','NATALES'),(292,50,14,'12103','TORRES DEL PAINE'),(293,51,15,'13101','SANTIAGO'),(294,51,15,'14166','CERRILLOS'),(295,51,15,'14156','CERRO NAVIA'),(296,51,15,'14127','CONCHALÍ'),(297,51,15,'16165','EL BOSQUE'),(298,51,15,'14157','ESTACIÓN CENTRAL'),(299,51,15,'14158','HUECHURABA'),(300,51,15,'13167','INDEPENDENCIA'),(301,51,15,'16110','LA CISTERNA'),(302,51,15,'15128','LA FLORIDA'),(303,51,15,'16131','LA GRANJA'),(304,51,15,'16154','LA PINTANA'),(305,51,15,'15132','LA REINA'),(306,51,15,'15161','LO BARNECHEA'),(307,51,15,'16164','LO ESPEJO'),(308,51,15,'14155','LO PRADO'),(309,51,15,'15151','MACUL'),(310,51,15,'14109','MAIPÚ'),(311,51,15,'15105','ÑUÑOA'),(312,51,15,'16162','PEDRO AGUIRRE CERDA'),(313,51,15,'15152','PEÑALOLEN'),(314,51,15,'15103','PROVIDENCIA'),(315,51,15,'14111','PUDAHUEL'),(316,51,15,'14114','QUILICURA'),(317,51,15,'14107','QUINTA NORMAL'),(318,51,15,'13159','RECOLETA'),(319,51,15,'14113','RENCA'),(320,51,15,'16163','SAN JOAQUÍN'),(321,51,15,'16106','SAN MIGUEL'),(322,51,15,'16153','SAN RAMÓN'),(323,51,15,'15160','VITACURA'),(324,51,15,'15108','LAS CONDES'),(325,52,15,'16301','PUENTE ALTO'),(326,52,15,'16302','PIRQUE'),(328,53,15,'14201','COLINA'),(329,53,15,'14202','LAMPA'),(330,53,15,'14203','TILTIL'),(331,54,15,'16401','SAN BERNARDO'),(332,54,15,'16403','BUIN'),(333,54,15,'16402','CALERA DE TANGO'),(334,54,15,'16404','PAINE'),(335,55,15,'14601','MELIPILLA'),(336,55,15,'14605','ALHUÉ'),(337,55,15,'14603','CURACAVÍ'),(338,55,15,'14602','MARÍA PINTO'),(339,55,15,'14604','SAN PEDRO'),(340,56,15,'14501','TALAGANTE'),(341,56,15,'14503','EL MONTE'),(342,56,15,'14502','ISLA DE MAIPO'),(343,56,15,'14505','PADRE HURTADO'),(344,56,15,'14504','PEÑAFLOR'),(345,52,15,'16303','SAN JOSÉ DE MAIPÚ');
/*!40000 ALTER TABLE `tbl_comunas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_conciliacionbancaria`
--

DROP TABLE IF EXISTS `tbl_conciliacionbancaria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_conciliacionbancaria` (
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `id_banco` int(10) NOT NULL,
  `codigo_cuenta` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `saldo_inicial` int(11) NOT NULL,
  `fecha_inicio` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `fecha_fin` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_cartola` int(10) NOT NULL,
  `estado` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(1000) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_usuario` int(10) NOT NULL,
  UNIQUE KEY `folio` (`folio`),
  KEY `id_banco` (`id_banco`),
  KEY `fecha_inicio` (`fecha_inicio`),
  KEY `fecha_fin` (`fecha_fin`),
  KEY `folio_cartola` (`folio_cartola`),
  KEY `estado` (`estado`),
  KEY `observaciones` (`observaciones`(255)),
  KEY `codigo_cuenta` (`codigo_cuenta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_conciliacionbancaria`
--

LOCK TABLES `tbl_conciliacionbancaria` WRITE;
/*!40000 ALTER TABLE `tbl_conciliacionbancaria` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_conciliacionbancaria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_conciliacionbancaria_cruce`
--

DROP TABLE IF EXISTS `tbl_conciliacionbancaria_cruce`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_conciliacionbancaria_cruce` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `identificador` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_conciliacionbancaria_cruce`
--

LOCK TABLES `tbl_conciliacionbancaria_cruce` WRITE;
/*!40000 ALTER TABLE `tbl_conciliacionbancaria_cruce` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_conciliacionbancaria_cruce` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_conciliacionbancaria_detalle`
--

DROP TABLE IF EXISTS `tbl_conciliacionbancaria_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_conciliacionbancaria_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `sw_auditado` int(1) NOT NULL COMMENT 'indica que el movimiento si se encuentra en el libro diario',
  `codigo_cuenta` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_usuario` int(10) NOT NULL COMMENT 'id del usuario creador de la linea 1=Sistema',
  `time_creacion_registro` int(10) NOT NULL,
  `id_item` int(10) NOT NULL,
  `fecha` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_operacion` int(10) NOT NULL COMMENT 'timestamp de fecha bancaria de operacion',
  `clave` char(3) COLLATE utf8_spanish_ci NOT NULL,
  `folio_documento` int(10) NOT NULL,
  `debe` int(10) NOT NULL,
  `haber` int(10) NOT NULL,
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `id` (`id`),
  KEY `folio` (`folio`),
  KEY `id_item` (`id_item`),
  KEY `time_creacion_registro` (`time_creacion_registro`),
  KEY `clave` (`clave`),
  KEY `fecha` (`fecha`),
  KEY `codigo_cuenta` (`codigo_cuenta`),
  KEY `estado` (`estado`),
  KEY `sw_auditado` (`sw_auditado`),
  KEY `time_operacion` (`time_operacion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_conciliacionbancaria_detalle`
--

LOCK TABLES `tbl_conciliacionbancaria_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_conciliacionbancaria_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_conciliacionbancaria_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_condicionespago`
--

DROP TABLE IF EXISTS `tbl_condicionespago`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_condicionespago` (
  `id_formapago` int(10) NOT NULL AUTO_INCREMENT,
  `sw_default` int(1) NOT NULL,
  `estado` int(1) NOT NULL DEFAULT '0',
  `tipo_documento` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `orden` int(10) NOT NULL DEFAULT '0',
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `segundos_vencimiento` int(10) NOT NULL DEFAULT '0' COMMENT 'indica la cantidad de segundos de vencimiento de la factura',
  `codigo_cuenta` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT 'codigo de cuenta contable',
  `cuenta_contable` int(10) NOT NULL,
  `nombre_cuenta` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `sw_modulo_pago` tinyint(1) NOT NULL,
  UNIQUE KEY `id_formapago` (`id_formapago`),
  KEY `tipo_documento` (`tipo_documento`),
  KEY `sw_default` (`sw_default`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_condicionespago`
--

LOCK TABLES `tbl_condicionespago` WRITE;
/*!40000 ALTER TABLE `tbl_condicionespago` DISABLE KEYS */;
INSERT INTO `tbl_condicionespago` VALUES (1,1,0,'',0,'EFECTIVO',0,'101030101',0,'',0),(2,0,0,'',0,'CHEQUE',0,'101030101',0,'',0),(3,0,0,'',0,'TRANSFERENCIA',0,'101030101',0,'',0),(4,0,0,'',0,'CREDITO',0,'101030101',0,'',0),(5,0,0,'',0,'TRANSBANK',0,'101010401',0,'',0);
/*!40000 ALTER TABLE `tbl_condicionespago` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_condicionesventa`
--

DROP TABLE IF EXISTS `tbl_condicionesventa`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_condicionesventa` (
  `id_formapago` int(10) NOT NULL AUTO_INCREMENT,
  `sw_default` int(1) NOT NULL,
  `estado` int(1) NOT NULL DEFAULT '0',
  `tipo_documento` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `orden` int(10) NOT NULL DEFAULT '0',
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `segundos_vencimiento` int(10) NOT NULL DEFAULT '0' COMMENT 'indica la cantidad de segundos de vencimiento de la factura',
  `cuenta_contable` int(10) NOT NULL,
  `nombre_cuenta` char(32) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id_formapago` (`id_formapago`),
  KEY `tipo_documento` (`tipo_documento`),
  KEY `sw_default` (`sw_default`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_condicionesventa`
--

LOCK TABLES `tbl_condicionesventa` WRITE;
/*!40000 ALTER TABLE `tbl_condicionesventa` DISABLE KEYS */;
INSERT INTO `tbl_condicionesventa` VALUES (1,1,0,'',0,'CONTADO',0,0,''),(2,0,0,'',0,'30 DIAS',30,0,''),(3,0,0,'',0,'60 DIAS',60,0,'');
/*!40000 ALTER TABLE `tbl_condicionesventa` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_configuracion`
--

DROP TABLE IF EXISTS `tbl_configuracion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_configuracion` (
  `refrescar` int(10) NOT NULL DEFAULT '0',
  `venta_minima` int(10) NOT NULL DEFAULT '0',
  `porcentaje_utilidad` int(10) NOT NULL DEFAULT '0',
  `sw_control_rutas` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `sw_actualizar_referencial` int(1) NOT NULL DEFAULT '0',
  `sw_valores` int(1) NOT NULL DEFAULT '0' COMMENT '0=neto 1=bruto',
  `sw_sitioweb` int(1) NOT NULL,
  `sw_codificacion` int(1) NOT NULL DEFAULT '0' COMMENT 'sw_codificacion de productos y servicios',
  `tpv_espera` int(10) NOT NULL DEFAULT '0' COMMENT 'indica la cantidad de segundos que el punto de venta se mantendra activo, transcurrido ese lapso el tpv vuelve a la pantalla de control de vendedor',
  `sw_caja` int(1) NOT NULL DEFAULT '0' COMMENT 'caja de tpv esta separada del punto de vta 1=si 0=no',
  `sw_vta_sinstock` int(1) NOT NULL DEFAULT '0',
  `contabilizar_boleta_venta` int(1) NOT NULL,
  `cierre_remuneraciones` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'dia del cierre de las remuneraciones',
  `mail_informar_oc` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '' COMMENT 'si existe mail enviar cuando se guarde, para varios mails separar con coma',
  `codigo_zk` varchar(5) COLLATE utf8_spanish_ci NOT NULL COMMENT 'codigo empresa zk asistencia',
  `formato_asistencia` int(1) NOT NULL,
  `descontar_atrasos_desde` varchar(8) COLLATE utf8_spanish_ci NOT NULL DEFAULT '00:00:00',
  `sw_compensarsalidadespues` int(1) NOT NULL,
  `sw_entradaantes` int(1) NOT NULL,
  `sw_entradadespues` int(1) NOT NULL,
  `sw_salidaantes` int(1) NOT NULL,
  `sw_salidadespues` int(1) NOT NULL,
  `sw_colacionsobrante` int(1) NOT NULL,
  `sw_colacionexceso` int(1) NOT NULL,
  `sw_extraautorizado` int(1) NOT NULL DEFAULT '0',
  `id_tipoguia` int(1) NOT NULL COMMENT 'tipo guia default',
  `id_tipodespacho` int(1) NOT NULL COMMENT 'tipo despacho con guia default',
  KEY `sw_codificacion` (`sw_codificacion`),
  KEY `codigo_zk` (`codigo_zk`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_configuracion`
--

LOCK TABLES `tbl_configuracion` WRITE;
/*!40000 ALTER TABLE `tbl_configuracion` DISABLE KEYS */;
INSERT INTO `tbl_configuracion` VALUES (1,0,0,0,0,0,0,0,0,0,0,0,'27','','',0,'00:05:00',0,1,1,1,1,1,1,1,0,0);
/*!40000 ALTER TABLE `tbl_configuracion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_configuracion_cuentas`
--

DROP TABLE IF EXISTS `tbl_configuracion_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_configuracion_cuentas` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `tipo_documento` char(3) COLLATE utf8_spanish_ci NOT NULL,
  `clave_documento` varchar(3) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_cuenta` int(10) NOT NULL,
  `codigo_funcion` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `clave` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `clave_documento` (`clave_documento`),
  KEY `clave` (`clave`),
  KEY `codigo_funcion` (`codigo_funcion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_configuracion_cuentas`
--

LOCK TABLES `tbl_configuracion_cuentas` WRITE;
/*!40000 ALTER TABLE `tbl_configuracion_cuentas` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_configuracion_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_configuraciones`
--

DROP TABLE IF EXISTS `tbl_configuraciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_configuraciones` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `atributo` varchar(50) COLLATE utf8_spanish_ci NOT NULL,
  `valor` text CHARACTER SET latin1 NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `atributo` (`atributo`)
) ENGINE=InnoDB AUTO_INCREMENT=134 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_configuraciones`
--

LOCK TABLES `tbl_configuraciones` WRITE;
/*!40000 ALTER TABLE `tbl_configuraciones` DISABLE KEYS */;
INSERT INTO `tbl_configuraciones` VALUES (1,'rut','77861264-K'),(2,'razon_social','TRANSPORTES FAST LOGISTCS  COMPANY SPA'),(3,'direccion','k'),(4,'giro','k'),(5,'ciudad','k'),(6,'comuna','k'),(7,'rut_rep_legal',''),(8,'nombre_rep_legal',''),(9,'nombre_fantasia','TRANSPORTES FAST LOGISTCS  COMPANY SPA'),(10,'fono','k'),(11,'fax',''),(12,'email','k'),(13,'email_intercambio',''),(14,'pass_intercambio',''),(15,'sitio_web','k'),(16,'fecha_resolucion','--/-//'),(17,'num_resolucion','0'),(18,'fecha_resolucion_certificacion','--/-//'),(19,'num_resolucion_certificacion','0'),(20,'codigo_actividad',''),(21,'codigo_sucursal_sii','12312'),(22,'nombre_sucursal_sii',''),(23,'direccion_regional',''),(24,'rut_enviador',''),(25,'rut_firmador',''),(26,'aviso_folio',''),(27,'sw_enviar_sii','0'),(28,'sw_pyme_pdf','1'),(29,'pdf_decimales_valores',''),(30,'pdf_decimales_cantidad',''),(31,'sw_produccionfacturas','0'),(32,'pass_intercambio_sii',''),(33,'email_intercambio_sii',''),(34,'sw_valoresbrutos','0'),(35,'sw_produccionnotascredito','0'),(36,'sw_produccionnotasdebito','0'),(37,'sw_validar_stock','0'),(38,'sw_enviar_emisor','0'),(39,'sw_logocentral',''),(40,'sw_logosuperior',''),(41,'sw_enviar_receptor','0'),(42,'sw_enviar_intercambio','0'),(43,'sw_emisor_receptor','0'),(44,'url_webservice_servidor',''),(45,'servidor_intercambio',''),(46,'sw_enviarsiiguias','1'),(47,'id_motivo_salida_op','0'),(48,'tipo_codigo_facturas','RPX'),(49,'contabilidad_cuenta_iva','201020401'),(50,'contabilidad_cuenta_iva_credito','101070205'),(51,'puntoventa_documentos','[]'),(52,'contabilidad_cuenta_resultado_ejercicio','0'),(53,'email_cobranza_empresa','k'),(54,'cuenta_redondeo_pesos','0'),(81,'aviso_folio_vfac','0'),(82,'aviso_folio_vnc','0'),(83,'aviso_folio_vnd','0'),(106,'tipo_codigo_notas','RPX'),(113,'documento_venta_boleta_default','0'),(114,'documento_venta_factura_default','0'),(115,'documento_venta_guia_default','0'),(116,'documento_venta_puntoventa_default','0'),(117,'documento_venta_notapedido_default',''),(118,'certificacion_setbasico_empresa',''),(119,'certificacion_setbasico_fecha',''),(120,'certificacion_facturaexenta_empresa',''),(121,'certificacion_facturaexenta_fecha',''),(122,'certificacion_setboleta_empresa',''),(123,'certificacion_setboleta_fecha',''),(124,'certificacion_setguia_empresa',''),(125,'certificacion_setguia_fecha',''),(126,'certificacion_testeo',''),(127,'punto_venta_ticket_empaque','0'),(128,'punto_venta_caja_unica',''),(129,'sw_sublogo',''),(130,'alertas_folios_dias_anticipacion','10'),(131,'alertas_certificado_dias_anticipacion','15'),(132,'nivel_default_cierre_periodo','0'),(133,'nivel_default_fecha_compras','0');
/*!40000 ALTER TABLE `tbl_configuraciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_contratos`
--

DROP TABLE IF EXISTS `tbl_contratos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_contratos` (
  `id` int(7) NOT NULL AUTO_INCREMENT,
  `id_seccion` int(2) NOT NULL,
  `etiqueta` char(32) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `fecha` char(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `time` int(10) NOT NULL,
  `titulo` text CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `contenido` text CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `sueldo_base` int(11) NOT NULL,
  `sueldo_bruto` int(11) NOT NULL,
  `rut_trabajador` varchar(10) NOT NULL,
  `nombre_trabajador` varchar(255) NOT NULL,
  `id_trabajador` int(11) NOT NULL,
  `indefinido` int(1) NOT NULL,
  `uf` decimal(12,2) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_contratos`
--

LOCK TABLES `tbl_contratos` WRITE;
/*!40000 ALTER TABLE `tbl_contratos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_contratos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_correos`
--

DROP TABLE IF EXISTS `tbl_correos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_correos` (
  `id_correo` int(10) NOT NULL DEFAULT '0',
  `fecha_envio` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `hora_envio` varchar(8) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_remitente` int(10) NOT NULL DEFAULT '0',
  `asunto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `mensaje` text COLLATE utf8_spanish_ci NOT NULL,
  KEY `id_correo` (`id_correo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_correos`
--

LOCK TABLES `tbl_correos` WRITE;
/*!40000 ALTER TABLE `tbl_correos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_correos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cotizaciones`
--

DROP TABLE IF EXISTS `tbl_cotizaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_cotizaciones` (
  `id_transaccion` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion del comprobante contable',
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `id_cliente` int(10) NOT NULL,
  `tipo_documento` int(1) NOT NULL DEFAULT '0',
  `sw_rutear` int(1) NOT NULL DEFAULT '0' COMMENT 'indica si el pedido se debe rutear',
  `folio_ruta` int(10) NOT NULL,
  `rut` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `razon_social` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `direccion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `fono_fax` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `comuna` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `id_sucursal` int(10) NOT NULL,
  `clase_sucursal` char(1) COLLATE utf8_spanish_ci NOT NULL COMMENT 'clase de la sucursal del cliente al momento de procesar el pedido',
  `orden_sucursal` int(10) NOT NULL,
  `prioridad_despacho` int(10) NOT NULL,
  `nombre_sucursal` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `contacto` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `email_emisor` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_contacto` int(10) NOT NULL,
  `sw_periodo` int(1) NOT NULL COMMENT '0=abierto 1=cerrado ( corresponde al periodo abierto o cerrado)',
  `sw_multiop` int(1) NOT NULL,
  `fecha_solicitud` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_solicitud` int(10) NOT NULL,
  `fecha_ejecucion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_ejecucion` int(10) NOT NULL,
  `fecha_proceso` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_proceso` int(10) NOT NULL,
  `despacho_desde` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_desde` int(10) NOT NULL,
  `despacho_hasta` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_hasta` int(10) NOT NULL,
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `id_usuario_proceso` int(10) NOT NULL,
  `id_bodega` int(10) NOT NULL COMMENT 'id bodega de destino',
  `id_centrocosto` int(10) NOT NULL,
  `id_centronegocio` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `id_solicita` int(10) NOT NULL,
  `id_autoriza` int(10) NOT NULL,
  `id_ejecuta` int(10) NOT NULL,
  `id_formapago` int(10) NOT NULL,
  `id_condicionpago` int(2) NOT NULL,
  `id_vendedor` int(10) NOT NULL,
  `id_tipopedido` int(1) NOT NULL,
  `id_formaentrega` int(1) NOT NULL COMMENT '0=parcial 1=total',
  `id_origen_cotizacion` int(11) NOT NULL,
  `cuenta_origen` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'contracuenta de la contabilizacion ej. merc. nac v/s cuenta_origen',
  `orden_compra` varchar(64) COLLATE utf8_spanish_ci NOT NULL COMMENT '64 bytes para el cod o folio de la oc asociada al pedido',
  `cotizacion` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_sucursal` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `total` int(10) NOT NULL,
  `descuento_porc` decimal(12,2) NOT NULL,
  `descuento_pesos` int(10) NOT NULL,
  `neto` int(10) NOT NULL,
  `iva` int(10) NOT NULL,
  `bruto` int(10) NOT NULL,
  `estado` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(1000) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion_despacho` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_comuna` int(11) NOT NULL,
  `giro` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `neto_exento` int(11) NOT NULL,
  `validez` int(11) NOT NULL,
  UNIQUE KEY `folio` (`folio`),
  KEY `estado` (`estado`),
  KEY `fecha_ejecucion` (`fecha_ejecucion`),
  KEY `time_ejecucion` (`time_ejecucion`),
  KEY `cuenta_origen` (`cuenta_origen`),
  KEY `id_bodega` (`id_bodega`),
  KEY `sw_periodo` (`sw_periodo`),
  KEY `time_proceso` (`time_proceso`),
  KEY `id_usuario_proceso` (`id_usuario_proceso`),
  KEY `orden_compra` (`orden_compra`),
  KEY `sw_multiop` (`sw_multiop`),
  KEY `codigo_sucursal` (`codigo_sucursal`),
  KEY `rut` (`rut`),
  KEY `razon_social` (`razon_social`),
  KEY `direccion` (`direccion`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `contacto` (`contacto`),
  KEY `id_contacto` (`id_contacto`),
  KEY `id_formapago` (`id_formapago`),
  KEY `id_vendedor` (`id_vendedor`),
  KEY `fecha_solicitud` (`fecha_solicitud`),
  KEY `time_solicitud` (`time_solicitud`),
  KEY `id_tipopedido` (`id_tipopedido`),
  KEY `id_formaentrega` (`id_formaentrega`),
  KEY `cotizacion` (`cotizacion`),
  KEY `despacho_desde` (`despacho_desde`),
  KEY `time_desde` (`time_desde`),
  KEY `despacho_hasta` (`despacho_hasta`),
  KEY `time_hasta` (`time_hasta`),
  KEY `id_cliente` (`id_cliente`),
  KEY `fecha_proceso` (`fecha_proceso`),
  KEY `orden_sucursal` (`orden_sucursal`),
  KEY `prioridad_despacho` (`prioridad_despacho`),
  KEY `clase_sucursal` (`clase_sucursal`),
  KEY `tipo_documento` (`tipo_documento`),
  KEY `sw_rutear` (`sw_rutear`),
  KEY `folio_ruta` (`folio_ruta`),
  KEY `email_emisor` (`email_emisor`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cotizaciones`
--

LOCK TABLES `tbl_cotizaciones` WRITE;
/*!40000 ALTER TABLE `tbl_cotizaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cotizaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cotizaciones_calcprecioventa`
--

DROP TABLE IF EXISTS `tbl_cotizaciones_calcprecioventa`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_cotizaciones_calcprecioventa` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cotizaciones_calcprecioventa`
--

LOCK TABLES `tbl_cotizaciones_calcprecioventa` WRITE;
/*!40000 ALTER TABLE `tbl_cotizaciones_calcprecioventa` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cotizaciones_calcprecioventa` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cotizaciones_config`
--

DROP TABLE IF EXISTS `tbl_cotizaciones_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_cotizaciones_config` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_calcprecioventa` int(10) NOT NULL COMMENT 'permite definir el id del tipo de calculo que se debe aplicar para el precio de venta en tbl_cotizaciones_calcprecioventa',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cotizaciones_config`
--

LOCK TABLES `tbl_cotizaciones_config` WRITE;
/*!40000 ALTER TABLE `tbl_cotizaciones_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cotizaciones_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cotizaciones_detalle`
--

DROP TABLE IF EXISTS `tbl_cotizaciones_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_cotizaciones_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `rut` char(10) COLLATE utf8_spanish_ci NOT NULL,
  `fecha` char(10) COLLATE utf8_spanish_ci NOT NULL,
  `sw_periodo` int(1) NOT NULL,
  `id_usuario` int(10) NOT NULL COMMENT 'id del usuario creador de la linea 1=Sistema',
  `id_usuario_proceso` int(10) NOT NULL,
  `time_creacion_registro` int(10) NOT NULL,
  `time_proceso` int(10) NOT NULL,
  `id_item` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `codigo` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_sku` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `prioridad_despacho` int(10) NOT NULL COMMENT 'orden de prioridad de despachos por nota de pedido',
  `clase_sucursal` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'Indica al boucher si la linea ha sido finalizada 1=Si 0=No',
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT 'ID del proyecto asociado a la linea contable que genero el cargo u/o abono',
  `id_vendedor` int(10) NOT NULL,
  `id_formaentrega` int(10) NOT NULL,
  `bultos` int(10) NOT NULL,
  `numero_lote` varchar(128) COLLATE utf8_spanish_ci NOT NULL,
  `numero_serie` varchar(128) COLLATE utf8_spanish_ci NOT NULL,
  `cantidad` decimal(12,2) NOT NULL,
  `reserva` decimal(12,2) NOT NULL,
  `embalado` decimal(12,2) NOT NULL,
  `facturado` decimal(12,2) NOT NULL,
  `pendiente` decimal(12,2) NOT NULL,
  `pendiente_historico` int(10) NOT NULL COMMENT 'aqui se almacena la cantidad pendiente que se origino al momento procesar el pedido',
  `unitario` decimal(12,2) NOT NULL,
  `descuento` decimal(12,2) NOT NULL COMMENT 'porc de descuento aplicado al subtotal',
  `descuento_pesos` int(10) NOT NULL COMMENT 'descuento en pesos aplicado al subtotal',
  `subtotal` int(10) NOT NULL,
  `monto_impuesto_adicional` int(10) NOT NULL,
  `monto_impuesto_especifico` int(10) NOT NULL,
  `codigo_impuesto_adicional` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `tasa_impuesto_adicional` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `orden_compra` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `sw_exento` int(11) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `folio` (`folio`),
  KEY `id_item` (`id_item`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `time_creacion_registro` (`time_creacion_registro`),
  KEY `tipo_item` (`tipo_item`),
  KEY `codigo` (`codigo`),
  KEY `sw_periodo` (`sw_periodo`),
  KEY `numero_lote` (`numero_lote`),
  KEY `numero_serie` (`numero_serie`),
  KEY `reserva` (`reserva`),
  KEY `time_proceso` (`time_proceso`),
  KEY `id_usuario_proceso` (`id_usuario_proceso`),
  KEY `orden_compra` (`orden_compra`),
  KEY `id_vendedor` (`id_vendedor`),
  KEY `id_formaentrega` (`id_formaentrega`),
  KEY `embalado` (`embalado`),
  KEY `facturado` (`facturado`),
  KEY `prioridad_despacho` (`prioridad_despacho`),
  KEY `codigo_sku` (`codigo_sku`),
  KEY `clase_sucursal` (`clase_sucursal`),
  KEY `rut` (`rut`),
  KEY `fecha` (`fecha`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cotizaciones_detalle`
--

LOCK TABLES `tbl_cotizaciones_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_cotizaciones_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cotizaciones_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cotizaciones_origen`
--

DROP TABLE IF EXISTS `tbl_cotizaciones_origen`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_cotizaciones_origen` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT '1=activo 0=inactivo',
  `orden` int(10) NOT NULL,
  `codigo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `orden` (`orden`),
  KEY `codigo` (`codigo`),
  KEY `estado` (`estado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cotizaciones_origen`
--

LOCK TABLES `tbl_cotizaciones_origen` WRITE;
/*!40000 ALTER TABLE `tbl_cotizaciones_origen` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cotizaciones_origen` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_crmprospectos`
--

DROP TABLE IF EXISTS `tbl_crmprospectos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_crmprospectos` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_digitador` int(10) NOT NULL,
  `id_origen` int(7) NOT NULL,
  `id_usuario` int(7) NOT NULL COMMENT 'id asignado al usuario registrado',
  `nombre` varchar(255) NOT NULL,
  `correo` varchar(255) NOT NULL,
  `telefono` varchar(255) NOT NULL,
  `codigo_referido` int(7) NOT NULL,
  `direccion` varchar(255) NOT NULL,
  `id_comuna` int(7) NOT NULL,
  `rut` varchar(12) NOT NULL,
  `razon_social` varchar(255) NOT NULL,
  `comentarios` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `id_comuna` (`id_comuna`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_crmprospectos`
--

LOCK TABLES `tbl_crmprospectos` WRITE;
/*!40000 ALTER TABLE `tbl_crmprospectos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_crmprospectos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_crmprospectosorigen`
--

DROP TABLE IF EXISTS `tbl_crmprospectosorigen`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_crmprospectosorigen` (
  `id` int(7) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL,
  `etiqueta` varchar(255) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `estado` (`estado`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_crmprospectosorigen`
--

LOCK TABLES `tbl_crmprospectosorigen` WRITE;
/*!40000 ALTER TABLE `tbl_crmprospectosorigen` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_crmprospectosorigen` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cursos`
--

DROP TABLE IF EXISTS `tbl_cursos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_cursos` (
  `id_curso` int(10) NOT NULL AUTO_INCREMENT,
  `id_centronegocio` int(10) NOT NULL,
  `rut_profesor` varchar(12) COLLATE utf8_spanish_ci NOT NULL,
  `codigo` varchar(3) COLLATE utf8_spanish_ci NOT NULL,
  `dias_clases` int(7) NOT NULL,
  `hora_desde` varchar(5) COLLATE utf8_spanish_ci NOT NULL,
  `hora_hasta` varchar(5) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_inicio` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `sw_matriculas` int(1) NOT NULL,
  `precio` int(10) NOT NULL,
  UNIQUE KEY `id_curso` (`id_curso`),
  KEY `id_centronegocio` (`id_centronegocio`),
  KEY `sw_matriculas` (`sw_matriculas`),
  KEY `precio` (`precio`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cursos`
--

LOCK TABLES `tbl_cursos` WRITE;
/*!40000 ALTER TABLE `tbl_cursos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cursos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_dashboard`
--

DROP TABLE IF EXISTS `tbl_dashboard`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_dashboard` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) NOT NULL,
  `descripcion` varchar(255) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_dashboard`
--

LOCK TABLES `tbl_dashboard` WRITE;
/*!40000 ALTER TABLE `tbl_dashboard` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_dashboard` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_dashboard_privilegios`
--

DROP TABLE IF EXISTS `tbl_dashboard_privilegios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_dashboard_privilegios` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_dashboard` int(10) NOT NULL,
  `id_nivel` int(10) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `id_dashboard` (`id_dashboard`),
  KEY `id_usuario` (`id_nivel`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_dashboard_privilegios`
--

LOCK TABLES `tbl_dashboard_privilegios` WRITE;
/*!40000 ALTER TABLE `tbl_dashboard_privilegios` DISABLE KEYS */;
INSERT INTO `tbl_dashboard_privilegios` VALUES (1,1,1),(2,2,1),(3,3,1),(4,4,1),(8,5,1),(9,6,1),(10,7,1),(11,8,1);
/*!40000 ALTER TABLE `tbl_dashboard_privilegios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_departamentos`
--

DROP TABLE IF EXISTS `tbl_departamentos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_departamentos` (
  `id_departamento` decimal(10,0) NOT NULL DEFAULT '0',
  `nombre` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `descripcion` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `id_categoria` (`id_departamento`),
  KEY `nombre` (`nombre`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_departamentos`
--

LOCK TABLES `tbl_departamentos` WRITE;
/*!40000 ALTER TABLE `tbl_departamentos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_departamentos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_descuentos`
--

DROP TABLE IF EXISTS `tbl_descuentos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_descuentos` (
  `id_descuento` int(10) NOT NULL AUTO_INCREMENT,
  `codigo_descuento` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `estado` int(1) NOT NULL,
  `descripcion` varchar(200) COLLATE utf8_spanish_ci NOT NULL,
  `descuento` decimal(12,2) NOT NULL,
  UNIQUE KEY `id_descuento` (`id_descuento`),
  KEY `codigo_descuento` (`codigo_descuento`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_descuentos`
--

LOCK TABLES `tbl_descuentos` WRITE;
/*!40000 ALTER TABLE `tbl_descuentos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_descuentos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_destinatarios`
--

DROP TABLE IF EXISTS `tbl_destinatarios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_destinatarios` (
  `id_correo` int(10) NOT NULL DEFAULT '0',
  `nombre_destinatario` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `mail_destinatario` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  KEY `id_correo` (`id_correo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_destinatarios`
--

LOCK TABLES `tbl_destinatarios` WRITE;
/*!40000 ALTER TABLE `tbl_destinatarios` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_destinatarios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_documentos`
--

DROP TABLE IF EXISTS `tbl_documentos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_documentos` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT '1=activo 0=inactivo 2=activobloqueado',
  `sw_bloqueo` int(1) NOT NULL COMMENT 'bloqueado de modificacion y eliminacion ',
  `orden` int(10) NOT NULL,
  `codigo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_cuenta` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_sii` varchar(3) COLLATE utf8_spanish_ci NOT NULL,
  `cargo` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'D=Debe H=Haber',
  `cuenta_impuesto` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `cargo_impuesto` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `sw_electronico` int(1) NOT NULL DEFAULT '0',
  `sw_logistica_recepcion` int(1) NOT NULL,
  `sw_logistica_origen` int(1) NOT NULL,
  `sw_produccion` int(1) NOT NULL COMMENT 'indica si el tipo de documento se debe mostrar en producción',
  `sw_autofolio` int(1) NOT NULL,
  `sw_banco` int(1) NOT NULL,
  `sw_conciliar` int(1) NOT NULL,
  `sw_tesoreria` int(1) NOT NULL,
  `descripcion` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `sw_modulo_pago` int(1) NOT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `codigo` (`codigo`),
  KEY `orden` (`orden`),
  KEY `estado` (`estado`),
  KEY `codigo_cuenta` (`codigo_cuenta`),
  KEY `sw_logistica_recepcion` (`sw_logistica_recepcion`),
  KEY `sw_logistica_origen` (`sw_logistica_origen`),
  KEY `cuenta_impuesto` (`cuenta_impuesto`),
  KEY `cargo_impuesto` (`cargo_impuesto`),
  KEY `sw_produccion` (`sw_produccion`),
  KEY `sw_bloqueo` (`sw_bloqueo`),
  KEY `sw_autofolio` (`sw_autofolio`),
  KEY `sw_banco` (`sw_banco`),
  KEY `sw_conciliar` (`sw_conciliar`),
  KEY `codigo_sii` (`codigo_sii`),
  KEY `sw_electronico` (`sw_electronico`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_documentos`
--

LOCK TABLES `tbl_documentos` WRITE;
/*!40000 ALTER TABLE `tbl_documentos` DISABLE KEYS */;
INSERT INTO `tbl_documentos` VALUES (10,1,0,0,'CR','','','CR','','',0,0,0,0,0,0,0,0,'CREDITO',0),(12,1,0,0,'CF','201020204','','CR','','',0,0,0,0,0,1,0,0,'CHEQUE A FECHA',0),(13,1,0,0,'TR','101010202','','DB','','',0,0,0,0,0,1,1,0,'TRANSFERENCIA',0),(14,1,0,0,'DP','101010202','','DB','','',0,0,0,0,1,1,1,0,'DEPOSITO BANCARIO',0),(15,1,0,0,'LC','101040102','','DB','','',0,0,0,0,0,0,0,0,'LETRAS POR COBRAR',0),(16,1,0,0,'AH','101080301','','DB','','',0,0,0,0,1,0,0,0,'ANTICIPO DE HONORARIO',0),(17,1,0,0,'ID','201020401','','CR','','',0,0,0,0,0,0,0,0,'IVA DEBITO FISCAL',0),(21,1,0,0,'BH','201020201','','CR','','',0,1,0,1,0,0,0,0,'BOLETA DE HONORARIOS',0),(22,1,0,0,'CA','101010202','','CR','','',0,0,0,0,1,1,1,0,'CARGO BANCARIO',0),(24,1,0,0,'AB','101010202','','DB','','',0,0,0,0,1,1,1,0,'ABONO BANCARIO',0),(31,1,0,0,'AP','101050202','','DB','','',0,0,0,0,1,0,0,0,'ANTICIPO DE PROVEEDORES',0),(32,1,0,0,'IC','101070205','','DB','','',0,0,0,0,0,0,0,0,'IVA CREDITO FISCAL',0),(39,1,0,0,'AC','201040302','','CR','','',0,0,0,0,1,0,0,0,'ANTICIPO DE CLIENTES',0),(43,1,0,0,'HC','101010301','','CR','','',0,0,0,0,0,0,1,1,'CHEQUES EN CARTERA',0),(44,1,0,0,'EF','101010101','','DB','','',0,0,0,0,0,0,0,0,'EFECTIVO',0),(47,1,0,0,'VV','101010404','','DB','','',0,0,0,0,0,1,0,0,'VALE VISTA',0),(52,1,0,0,'910','201020102','','DB','','',0,0,0,0,0,0,0,0,'IMPORTACIONES',0),(53,1,0,0,'DB','','','DB','','',0,0,0,0,0,0,0,0,'DEBITO',0),(54,1,0,0,'CH','101010202','','CR','','',0,0,0,0,0,1,0,0,'CHEQUE',0),(55,1,0,0,'TK','101010401','','DB','','',0,0,0,0,0,0,0,0,'TRANSBANK',0),(56,1,0,0,'TC','101010202','','CR','','',0,0,0,0,0,1,0,0,'TARJETA CREDITO',0);
/*!40000 ALTER TABLE `tbl_documentos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_documentos_sii`
--

DROP TABLE IF EXISTS `tbl_documentos_sii`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_documentos_sii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tipo` char(1) COLLATE utf8_spanish_ci NOT NULL COMMENT 'C=Compra V=Venta',
  `codigo` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `nombre` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `cod_sii` int(4) NOT NULL,
  `cod_cuenta` varchar(15) COLLATE utf8_spanish_ci NOT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `tipo` (`tipo`),
  KEY `cod_sii` (`cod_sii`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_documentos_sii`
--

LOCK TABLES `tbl_documentos_sii` WRITE;
/*!40000 ALTER TABLE `tbl_documentos_sii` DISABLE KEYS */;
INSERT INTO `tbl_documentos_sii` VALUES (1,'V','FV','FACTURA ELECTRONICA',33,'101030101',1),(2,'C','FC','FACTURA ELECTRONICA',33,'201020101',1),(3,'C','FXC','FACTURA ELECTRONICA EXENTA',34,'201020101',1),(4,'C','GC','GUIA DESPACHO ELECTRONICA',52,'201040301',1),(5,'C','DC','NOTA DEBITO ELECTRONICA',56,'201020101',1),(6,'C','CC','NOTA CREDITO ELECTRONICA',61,'201020101',1),(7,'V','CV','NOTA CREDITO ELECTRONICA',61,'101030101',1),(8,'V','DV','NOTA DEBITO ELECTRONICA',56,'101030101',1);
/*!40000 ALTER TABLE `tbl_documentos_sii` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_educacion_areas`
--

DROP TABLE IF EXISTS `tbl_educacion_areas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_educacion_areas` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `orden` int(10) NOT NULL,
  `nombre` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `orden` (`orden`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_educacion_areas`
--

LOCK TABLES `tbl_educacion_areas` WRITE;
/*!40000 ALTER TABLE `tbl_educacion_areas` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_educacion_areas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_egresos`
--

DROP TABLE IF EXISTS `tbl_egresos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_egresos` (
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'EP=EnProceso AN=Anulado GR=Guardado TR=Transferido',
  `fecha` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_pago` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time` int(10) NOT NULL,
  `time_ingreso` int(10) NOT NULL,
  `usuario_ingreso` int(10) NOT NULL,
  `time_creacion` int(10) NOT NULL,
  `time_update` int(10) NOT NULL,
  `usuario_update` int(10) NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `id_creador` int(10) NOT NULL,
  `periodo` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `forma_pago` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `cuenta_pago` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `auxiliar_pago` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_banco` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_caja` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_cuenta` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `rut` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `razon_social` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `total_pago` int(10) NOT NULL,
  `folio_cheque` int(10) NOT NULL,
  `fecha_cheque` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_cheque` int(10) NOT NULL,
  `observaciones` text COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `folio` (`folio`),
  KEY `estado` (`estado`),
  KEY `fecha` (`fecha`),
  KEY `time` (`time`),
  KEY `time_ingreso` (`time_ingreso`),
  KEY `usuario_ingreso` (`usuario_ingreso`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `periodo` (`periodo`),
  KEY `time_update` (`time_update`,`usuario_update`),
  KEY `forma_pago` (`forma_pago`,`folio_cheque`,`fecha_cheque`,`time_cheque`),
  KEY `cuenta_pago` (`cuenta_pago`),
  KEY `auxiliar_pago` (`auxiliar_pago`),
  KEY `id_creador` (`id_creador`),
  KEY `time_creacion` (`time_creacion`),
  KEY `rut` (`rut`),
  KEY `razon_social` (`razon_social`),
  KEY `fecha_pago` (`fecha_pago`),
  KEY `codigo_banco` (`codigo_banco`),
  KEY `codigo_caja` (`codigo_caja`),
  KEY `codigo_cuenta` (`codigo_cuenta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_egresos`
--

LOCK TABLES `tbl_egresos` WRITE;
/*!40000 ALTER TABLE `tbl_egresos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_egresos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_egresos_detalle`
--

DROP TABLE IF EXISTS `tbl_egresos_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_egresos_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `periodo` varchar(8) COLLATE utf8_spanish_ci NOT NULL COMMENT 'mm/aaaa',
  `id_sucursal` int(10) NOT NULL,
  `id_item` int(10) NOT NULL,
  `cuenta_deudor` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `tipo_documento` char(3) COLLATE utf8_spanish_ci NOT NULL,
  `folio_documento` int(10) NOT NULL,
  `auxiliar_documento` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `monto_pago` int(10) NOT NULL,
  `forma_pago` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `cuenta_pago` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `auxiliar_pago` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `folio_documento_pago` int(10) NOT NULL,
  `fecha_documento_pago` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_documento_pago` int(10) NOT NULL,
  `glosa` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `folio` (`folio`),
  KEY `estado` (`estado`),
  KEY `id_item` (`id_item`),
  KEY `periodo` (`periodo`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `cuenta_deudor` (`cuenta_deudor`,`tipo_documento`,`folio_documento`,`auxiliar_documento`,`monto_pago`,`forma_pago`,`cuenta_pago`),
  KEY `fecha_documento_pago` (`fecha_documento_pago`),
  KEY `time_documento_pago` (`time_documento_pago`),
  KEY `folio_documento_pago` (`folio_documento_pago`),
  KEY `glosa` (`glosa`),
  KEY `auxiliar_pago` (`auxiliar_pago`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_egresos_detalle`
--

LOCK TABLES `tbl_egresos_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_egresos_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_egresos_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_emision_cheques`
--

DROP TABLE IF EXISTS `tbl_emision_cheques`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_emision_cheques` (
  `id_emision` int(10) NOT NULL AUTO_INCREMENT,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'EP=enproceso GR=grabado AN=anulado PR=procesado',
  `fecha_emision` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_emision` int(10) NOT NULL,
  `id_usuario_emisor` int(10) NOT NULL,
  `codigo_banco` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `numero_cheque` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_cheque` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_cheque` int(10) NOT NULL,
  `monto` int(10) NOT NULL,
  `tipo_auxiliar` char(1) COLLATE utf8_spanish_ci NOT NULL COMMENT 'c=cliente p=proveedor t=trabajador o=otro',
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `nombre` varchar(200) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` int(11) NOT NULL,
  UNIQUE KEY `id_emision` (`id_emision`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_emision_cheques`
--

LOCK TABLES `tbl_emision_cheques` WRITE;
/*!40000 ALTER TABLE `tbl_emision_cheques` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_emision_cheques` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_empleados`
--

DROP TABLE IF EXISTS `tbl_empleados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_empleados` (
  `id_empleado` int(10) NOT NULL AUTO_INCREMENT,
  `id_usuario_sistema` int(10) NOT NULL,
  `estado` int(1) NOT NULL DEFAULT '1',
  `sw_asistencia` int(1) NOT NULL DEFAULT '1' COMMENT '1=si 0=no',
  `orden` int(10) NOT NULL,
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_empleado` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'codigo interno del vendedor especifico para punto de venta',
  `codigo_asistencia` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT 'codigo ej: 00001 de reloj control ',
  `nombre_corto` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `nombres` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `paterno` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `materno` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `fecha_nacimiento` varchar(12) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `email` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion` varchar(150) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_region` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_ciudad` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_comuna` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_cargo` int(10) NOT NULL,
  `cargo` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `sexo` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `estado_civil` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nacionalidad` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `tipo_contrato` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `jornada_semanal` int(11) NOT NULL,
  `tipo_impuesto` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `tasa_impuesto` int(11) NOT NULL,
  `fecha_termino_impuesto` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `sueldo_base` int(10) NOT NULL,
  `valor_hora` int(10) NOT NULL,
  `monto` int(10) NOT NULL,
  `comision` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `bono_colacion` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `bono_movilizacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_centrocosto` int(2) NOT NULL,
  `fecha_ingreso` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `hora_entrada` varchar(25) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `hora_salida` varchar(25) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `tiempo_colacion` varchar(25) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `tipo_trabajador` int(1) NOT NULL,
  `id_afp` varchar(25) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `subsidio_previsional` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_fin_prevision` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `regimen_salud` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `fun_isapre` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_salud` varchar(25) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `tipo_cotizacion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `valor_cotizacion` int(11) NOT NULL,
  `cotizacion_ges_uf` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `tipo_cotiz_voluntaria` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `inst_cotiz_voluntaria` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `valor_cotiz_voluntaria` int(11) NOT NULL,
  `sw_rebaja_impunico` int(1) NOT NULL,
  `plan_salud` decimal(7,4) NOT NULL COMMENT 'tasa pactada con isapre en uf por ej. 2.2790 uf',
  `plan_salud2` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `apv` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `plan_apv` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `porc_sueldo_imp` int(11) NOT NULL,
  `valor_ahorro_imp` int(11) NOT NULL,
  `institucion_ahorro` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `cargas_familiares` int(10) NOT NULL DEFAULT '0',
  `cargas_maternales` int(11) NOT NULL,
  `cargas_invalidos` int(11) NOT NULL,
  `institucion_deshaucio` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `tipo_trato` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `sw_cargo1` int(1) NOT NULL COMMENT 'solicitante',
  `sw_cargo2` int(1) NOT NULL COMMENT 'autorizador',
  `sw_cargo3` int(1) NOT NULL COMMENT 'ejecutor',
  `sw_cargo4` int(1) NOT NULL,
  `sw_vendedor` int(1) NOT NULL DEFAULT '0',
  `sw_operador` int(1) NOT NULL,
  `sw_chofer` int(1) NOT NULL,
  `id_vehiculo` int(11) NOT NULL,
  `horaentrada` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `horasalida` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `colacion` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `colacion_horasalida` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `cargo_asistencia` int(1) NOT NULL,
  `firma_voucher` int(1) NOT NULL,
  `firma_ordencompra` int(1) NOT NULL,
  `firma_ordenproduccion` int(1) NOT NULL,
  `sw_validarfichajes` int(1) NOT NULL,
  `id_jornada` int(10) NOT NULL,
  `sw_colacionfija` int(1) NOT NULL DEFAULT '0',
  `sucursal` int(11) NOT NULL,
  `centro_de_costo` int(11) NOT NULL,
  `presuncion_zona` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `tipo_colacion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `tipo_movilizacion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `seguro_cesantia` int(1) NOT NULL,
  `afp_seguro_cesantia` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `sw_ingreso_minimo` int(1) NOT NULL,
  `tipo_sueldo` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `dias_semana` int(11) NOT NULL,
  `tipo_monedas` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `moneda` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `sueldo_mensual` int(11) NOT NULL,
  `tipo_gratificacion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `valor_gratificacion` int(11) NOT NULL,
  `mayor_retencion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `forma_de_pago` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `banco` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `tipo_cuenta_depago` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `cuenta_de_pago` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_inicio_contrato` varchar(12) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_termino_contrato` varchar(12) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_inicio_cuentaahorro` varchar(12) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_inicio_segurocesantia` varchar(12) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `extranjero` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `tipo_deposito_convenio` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `valor_deposito_convenio` int(11) NOT NULL,
  `porc_cotizacion_tpesado` int(11) NOT NULL,
  `descripcion_tpesado` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `cotiz_ahorro_indemniz` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `porc_comision` decimal(5,3) NOT NULL,
  `porc_comision_meta` decimal(5,3) NOT NULL,
  `meta_mensual` int(10) NOT NULL,
  `edita_nv` tinyint(1) NOT NULL DEFAULT '0',
  `edita_fg` tinyint(1) NOT NULL COMMENT 'Si es 1 permite modificar facturas generadas desde guias',
  UNIQUE KEY `id_empleado` (`id_empleado`),
  KEY `id_cargo` (`id_cargo`),
  KEY `orden` (`orden`),
  KEY `codigo_asistencia` (`codigo_asistencia`),
  KEY `sw_vendedor` (`sw_vendedor`),
  KEY `sw_operador` (`sw_operador`),
  KEY `cargo_asistencia` (`cargo_asistencia`),
  KEY `id_usuario_sistema` (`id_usuario_sistema`),
  KEY `sw_chofer` (`sw_chofer`),
  KEY `firma_voucher` (`firma_voucher`),
  KEY `firma_ordencompra` (`firma_ordencompra`),
  KEY `firma_ordenproduccion` (`firma_ordenproduccion`),
  KEY `sw_validarfichajes` (`sw_validarfichajes`),
  KEY `sw_colacionfija` (`sw_colacionfija`),
  KEY `sw_asistencia` (`sw_asistencia`),
  KEY `rut` (`rut`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_empleados`
--

LOCK TABLES `tbl_empleados` WRITE;
/*!40000 ALTER TABLE `tbl_empleados` DISABLE KEYS */;
INSERT INTO `tbl_empleados` VALUES (1,0,1,0,0,'11111111-1','1','','','VENDEDOR','GENERICO','.','','','','','0','0','',0,'','0','soltero','chilena','',0,'',0,'',0,0,0,'0','0','0',0,'0','0','0','0',0,'','','','','','','',0,'','','',0,0,0.0000,'','0','0',0,0,'',0,0,0,'','',0,0,0,0,0,1,0,0,0,'','','','',0,0,0,0,0,0,0,0,0,'','','',0,'',0,'',0,'','',0,'',0,'','','','','','','','','','','0','',0,0,'','',0.000,0.000,0,0,0);
/*!40000 ALTER TABLE `tbl_empleados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_empleados_cargos`
--

DROP TABLE IF EXISTS `tbl_empleados_cargos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_empleados_cargos` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL,
  `orden` int(10) NOT NULL,
  `rut` varchar(12) COLLATE utf8_spanish_ci NOT NULL,
  `codigo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `orden` (`orden`),
  KEY `codigo` (`codigo`),
  KEY `estado` (`estado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_empleados_cargos`
--

LOCK TABLES `tbl_empleados_cargos` WRITE;
/*!40000 ALTER TABLE `tbl_empleados_cargos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_empleados_cargos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_empleados_supervisores`
--

DROP TABLE IF EXISTS `tbl_empleados_supervisores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_empleados_supervisores` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_supervisor` int(10) NOT NULL,
  `id_operador` int(10) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `id_supervisor` (`id_supervisor`),
  KEY `id_operador` (`id_operador`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_empleados_supervisores`
--

LOCK TABLES `tbl_empleados_supervisores` WRITE;
/*!40000 ALTER TABLE `tbl_empleados_supervisores` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_empleados_supervisores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_empresa`
--

DROP TABLE IF EXISTS `tbl_empresa`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_empresa` (
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `sw_multisucursal` int(1) NOT NULL DEFAULT '0',
  `sw_demo` int(1) NOT NULL,
  `sw_produccionfacturas` int(1) NOT NULL DEFAULT '0',
  `sw_produccionnotasdebito` int(1) NOT NULL DEFAULT '0',
  `sw_produccionnotascredito` int(1) NOT NULL DEFAULT '0',
  `sw_produccionguias` int(1) NOT NULL DEFAULT '0',
  `sw_enviarsiiguias` int(1) NOT NULL DEFAULT '1' COMMENT '0=noenviar 1=sienviar',
  `sw_pyme_pdf` int(1) NOT NULL DEFAULT '0' COMMENT '0=nomostrar 1=enviado 2=recibido 3=aceptado 4=reparado 5=rechazado 7=aprobadosiicontri',
  `sw_valoresbrutos` int(1) NOT NULL,
  `sw_enviar_sii` int(1) NOT NULL,
  `sw_enviar_emisor` int(1) NOT NULL,
  `sw_emisor_receptor` int(1) NOT NULL,
  `sw_enviar_receptor` int(1) NOT NULL,
  `sw_enviar_intercambio` int(1) NOT NULL,
  `sw_logocentral` int(1) NOT NULL DEFAULT '1',
  `sw_logosuperior` int(1) NOT NULL,
  `razon_social` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_fantasia` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `giro` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `comuna` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `ciudad` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `fono` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `fax` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `rut_rep_legal` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `nombre_rep_legal` varchar(150) COLLATE utf8_spanish_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `servidor_intercambio` varchar(200) COLLATE utf8_spanish_ci NOT NULL,
  `email_intercambio` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `pass_intercambio` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `sitio_web` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_resolucion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `num_resolucion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_resolucion_certificacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `num_resolucion_certificacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_actividad` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `rut_enviador` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `rut_firmador` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `email_intercambio_sii` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `sw_factura_default` int(2) NOT NULL DEFAULT '33' COMMENT '33=fact afec 34=fact.exe',
  `token` varchar(12) COLLATE utf8_spanish_ci NOT NULL,
  `time_token` int(10) NOT NULL,
  `codigo_sucursal_sii` int(10) NOT NULL,
  `nombre_sucursal_sii` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `direccion_regional` char(8) COLLATE utf8_spanish_ci NOT NULL,
  `aviso_folio` int(10) NOT NULL COMMENT 'Aviso por correo cuando falten cierta catidad de folios para llegar al limite',
  `nombre_distribuidor` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `pdf_decimales_cantidad` int(10) NOT NULL,
  `pdf_decimales_valores` int(10) NOT NULL,
  `pass_intercambio_sii` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `url_webservice_servidor` text COLLATE utf8_spanish_ci NOT NULL COMMENT 'url del webservice servidor de facturacion electronica',
  `sw_ventasupdateprecios` int(1) NOT NULL,
  `sw_bloqueardatoscoti` int(1) NOT NULL,
  `id_motivo_salida_op` int(5) NOT NULL,
  `tipo_codigo_notas` varchar(5) COLLATE utf8_spanish_ci NOT NULL DEFAULT 'RPX',
  `tipo_codigo_facturas` varchar(5) COLLATE utf8_spanish_ci NOT NULL DEFAULT 'RPX',
  `url_webservice_boletas` text COLLATE utf8_spanish_ci NOT NULL,
  `sw_impobsboletas` int(1) NOT NULL,
  `aviso_folio_vfac` int(11) NOT NULL,
  `aviso_folio_vnc` int(11) NOT NULL,
  `aviso_folio_vnd` int(11) NOT NULL,
  `sw_visualiza_costo` int(1) NOT NULL,
  UNIQUE KEY `rut` (`rut`),
  KEY `sw_demo` (`sw_demo`),
  KEY `rut_firmador` (`rut_firmador`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_empresa`
--

LOCK TABLES `tbl_empresa` WRITE;
/*!40000 ALTER TABLE `tbl_empresa` DISABLE KEYS */;
INSERT INTO `tbl_empresa` VALUES ('77861264-K',0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,'TRANSPORTES FAST LOGISTCS  COMPANY SPA','TRANSPORTES FAST LOGISTCS  COMPANY SPA','k','k','k','k','k','','','','k','','','','k','--/-//','0','--/-//','0','','','','',33,'',0,12312,'','',0,'',0,0,'','',0,0,0,'RPX','RPX','',0,0,0,0,0);
/*!40000 ALTER TABLE `tbl_empresa` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_empresa_sucursales`
--

DROP TABLE IF EXISTS `tbl_empresa_sucursales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_empresa_sucursales` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT '1=activo 0=inactivo',
  `orden` int(10) NOT NULL,
  `codigo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `direccion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `cod_sucsii` int(10) NOT NULL,
  `comuna` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `ciudad` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `correo` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `fono` char(32) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `orden` (`orden`),
  KEY `codigo` (`codigo`),
  KEY `estado` (`estado`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_empresa_sucursales`
--

LOCK TABLES `tbl_empresa_sucursales` WRITE;
/*!40000 ALTER TABLE `tbl_empresa_sucursales` DISABLE KEYS */;
INSERT INTO `tbl_empresa_sucursales` VALUES (1,1,0,'1','CASA MATRIZ','1',1,'1','1','1','1');
/*!40000 ALTER TABLE `tbl_empresa_sucursales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_erpx_mensajeria`
--

DROP TABLE IF EXISTS `tbl_erpx_mensajeria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_erpx_mensajeria` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `sw_pendiente` int(1) NOT NULL,
  `time_envio` int(10) NOT NULL,
  `usuario_envio` int(10) NOT NULL,
  `time_alerta` int(10) NOT NULL,
  `usuario_destinatario` int(10) NOT NULL,
  `time_archivo` int(10) NOT NULL,
  `time_listo` int(10) NOT NULL,
  `asunto` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `comentarios` text COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `sw_pendiente` (`sw_pendiente`),
  KEY `time_archivo` (`time_archivo`),
  KEY `time_listo` (`time_listo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_erpx_mensajeria`
--

LOCK TABLES `tbl_erpx_mensajeria` WRITE;
/*!40000 ALTER TABLE `tbl_erpx_mensajeria` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_erpx_mensajeria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_feriados`
--

DROP TABLE IF EXISTS `tbl_feriados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_feriados` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT '1=activo 0=inactivo',
  `orden` int(10) NOT NULL,
  `codigo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `fecha` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `orden` (`orden`),
  KEY `codigo` (`codigo`),
  KEY `estado` (`estado`),
  KEY `fecha` (`fecha`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_feriados`
--

LOCK TABLES `tbl_feriados` WRITE;
/*!40000 ALTER TABLE `tbl_feriados` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_feriados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_gastos_vehiculos`
--

DROP TABLE IF EXISTS `tbl_gastos_vehiculos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_gastos_vehiculos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_motivo` int(11) NOT NULL,
  `id_vehiculo` int(11) NOT NULL,
  `id_documento` int(11) NOT NULL,
  `tipo_documento` int(2) NOT NULL,
  `monto` int(11) NOT NULL,
  `fecha` int(10) DEFAULT NULL,
  `observacion` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_gastos_vehiculos`
--

LOCK TABLES `tbl_gastos_vehiculos` WRITE;
/*!40000 ALTER TABLE `tbl_gastos_vehiculos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_gastos_vehiculos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_guiasdespacho`
--

DROP TABLE IF EXISTS `tbl_guiasdespacho`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_guiasdespacho` (
  `id_guiadespacho` int(10) NOT NULL AUTO_INCREMENT,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `estado_facturacion` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'FP=Facturado Pendiente FP=Facturado Parcial FT=Facturado Total',
  `solicitud_facturacion` int(1) NOT NULL DEFAULT '0' COMMENT '0=no 1=si',
  `anulada` int(1) NOT NULL DEFAULT '0' COMMENT '0=no 1=Si',
  `folio_guiadespacho` int(10) NOT NULL DEFAULT '0',
  `folio_notaventa` int(10) NOT NULL DEFAULT '0',
  `folio_cotizacion` int(10) NOT NULL DEFAULT '0',
  `folio_despacho` int(10) NOT NULL DEFAULT '0',
  `folio_ordencompra` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_factura` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `tipo_guia` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT 'NO' COMMENT 'NO=normal RE=reposicion DE=demostracion VF=consignacion DO=donacion  VA=venta anticiapada TR=Traslado',
  `exenta` int(1) NOT NULL,
  `facultad` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `laboratorio` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `time_emision` int(10) NOT NULL,
  `fecha_emision` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_formapago` int(10) NOT NULL,
  `paga_flete` int(1) NOT NULL DEFAULT '0' COMMENT '1=Flete Pagado 0=Flete x Pagar',
  `id_empresa` int(10) NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `rut` varchar(12) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `razon_social` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `region` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `ciudad` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `comuna` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefonos` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `contacto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `giro` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion_despacho` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `contacto_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `via_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefonos_despacho` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `region_despacho` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `ciudad_despacho` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `comuna_despacho` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `rut_vendedor` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_proyecto` int(10) NOT NULL DEFAULT '0',
  `subtotal` decimal(12,2) NOT NULL,
  `total_neto` int(10) NOT NULL,
  `descuento_porc` decimal(12,2) NOT NULL,
  `neto` int(10) NOT NULL DEFAULT '0',
  `iva` int(10) NOT NULL,
  `bruto` int(10) NOT NULL,
  `bruto_palabras` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_usuario_anulacion` int(10) NOT NULL DEFAULT '0',
  `id_anulacion` int(10) NOT NULL DEFAULT '0',
  `motivo_anulacion` int(1) NOT NULL DEFAULT '0' COMMENT '1=Error Facturación  2=Error Informática  3=Error Ventas  4=Error Logística  5=Error Bodega  6=Error Cliente  7=Error Desconocido ',
  `orden_compra` int(11) DEFAULT NULL,
  UNIQUE KEY `folio_guiadespacho` (`folio_guiadespacho`),
  UNIQUE KEY `id_guiadespacho` (`id_guiadespacho`),
  KEY `rut` (`rut`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_guiasdespacho`
--

LOCK TABLES `tbl_guiasdespacho` WRITE;
/*!40000 ALTER TABLE `tbl_guiasdespacho` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_guiasdespacho` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_guiasdespacho_compras`
--

DROP TABLE IF EXISTS `tbl_guiasdespacho_compras`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_guiasdespacho_compras` (
  `id_compra` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion de la factura',
  `rut_folio` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'concatenar rut prov y folio fc para campo unico',
  `numero_compra` int(10) NOT NULL AUTO_INCREMENT COMMENT 'numero unico de cada factura',
  `id_usuario` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario creador de la factura',
  `id_proveedor` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `id_centrocosto` int(10) NOT NULL,
  `rut` varchar(12) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `razon_social` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_fantasia` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `contacto` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `factura_importacion` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `costeo_importacion` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no ( Indica cuando la factura ya ha sido costeada)',
  `factura_activofijo` int(1) NOT NULL DEFAULT '0',
  `factura_gasto` int(10) NOT NULL DEFAULT '0',
  `tipo_factura` int(1) NOT NULL DEFAULT '0' COMMENT '1=normal 2=exenta 3=electronica 4=exenta electronica',
  `tipo_contabilizacion` int(1) NOT NULL DEFAULT '0' COMMENT '1=Factura Cuentas 2=Factura por Recibir 3=Factura por ingresar',
  `tipo_documento` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `clase_factura` int(1) NOT NULL DEFAULT '0' COMMENT '0=indefinido 1=Solo cuentas 2=Solo Productos 3=Productos y Cuentas',
  `folio_factura` int(10) NOT NULL DEFAULT '0',
  `folio_facturacion` int(10) NOT NULL COMMENT 'folio de la factura',
  `documento_facturacion` varchar(2) COLLATE utf8_spanish_ci NOT NULL,
  `sw_bloqueo` int(1) NOT NULL DEFAULT '0' COMMENT '0=no bloqueada 1=si bloqueada  ( bloquea la factura cuando esta ya ha sido cerrado el periodo contable )',
  `documento_recepcion` char(3) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'FC=FacturaCompra GD=GuiaDespacho  OC=OrdenCompra',
  `folio_documento_recepcion` int(10) NOT NULL DEFAULT '0' COMMENT 'folio del documento con el cual se recepciono la mercaderia en bodega',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'EP=EnProceso  IN=ingresada  indica si la factura ha sido ingresada al libro de compras',
  `apertura` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `anulada` int(1) NOT NULL DEFAULT '0' COMMENT '0=no 1=si',
  `folio_guiadespacho` varchar(255) COLLATE utf8_spanish_ci NOT NULL COMMENT 'folio-folio-...',
  `folio_ordencompra` varchar(64) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `folio_ordenproduccion` varchar(64) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `time_facturacion` int(10) NOT NULL DEFAULT '0' COMMENT 'timestamp con fecha de emision de la factura',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'mes control libro de compras',
  `ano_control` int(4) NOT NULL DEFAULT '0' COMMENT 'ano control libro de compras',
  `numero_control` int(10) NOT NULL DEFAULT '0' COMMENT 'numero de control del periodo del libro de compras',
  `numero_transaccion` int(10) NOT NULL DEFAULT '0' COMMENT 'numero del boucher del ingreso de la factura de compra',
  `contabilizada` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no indica si la factura ha sido contabilizada en el libro diario',
  `fecha_vencimiento` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `time_vencimiento` int(10) NOT NULL,
  `condiciones_pago` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `subtotal` int(10) NOT NULL DEFAULT '0',
  `descuento_porc` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0',
  `neto` int(10) NOT NULL DEFAULT '0',
  `neto_exento` int(10) NOT NULL,
  `iva` int(10) NOT NULL DEFAULT '0',
  `otros_impuestos` int(10) NOT NULL,
  `sw_iva` int(1) NOT NULL,
  `ajustar_iva` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT '+ sube - baja pesos del iva',
  `bruto` int(10) NOT NULL DEFAULT '0',
  `gastos_importacion` int(10) NOT NULL,
  `saldo_pendiente` int(10) NOT NULL DEFAULT '0',
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `numero_importacion` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `numero_despacho` int(10) NOT NULL DEFAULT '0',
  `id_bodega` int(11) NOT NULL,
  `comuna` int(11) NOT NULL,
  `giro` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `email` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `numero_compra` (`numero_compra`),
  KEY `folio_factura` (`folio_factura`),
  KEY `rut` (`rut`),
  KEY `id_proveedor` (`id_proveedor`),
  KEY `mes_control` (`mes_control`),
  KEY `ano_control` (`ano_control`),
  KEY `sw_iva` (`sw_iva`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `direccion` (`direccion`),
  KEY `contacto` (`contacto`),
  KEY `id_proyecto` (`id_proyecto`,`id_centrocosto`),
  KEY `otros_impuestos` (`otros_impuestos`),
  KEY `folio_facturacion` (`folio_facturacion`),
  KEY `folio_ordencompra` (`folio_ordencompra`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`),
  KEY `documento_facturacion` (`documento_facturacion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_guiasdespacho_compras`
--

LOCK TABLES `tbl_guiasdespacho_compras` WRITE;
/*!40000 ALTER TABLE `tbl_guiasdespacho_compras` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_guiasdespacho_compras` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_guiasdespacho_compras_detalle`
--

DROP TABLE IF EXISTS `tbl_guiasdespacho_compras_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_guiasdespacho_compras_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_compra` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de recepcion de la compra',
  `numero_compra` int(10) NOT NULL DEFAULT '0',
  `id_proveedor` int(10) NOT NULL DEFAULT '0',
  `id_item` int(10) NOT NULL DEFAULT '0',
  `id_centrocosto` int(2) NOT NULL DEFAULT '0',
  `id_centronegocio` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT 'Id del proyecto al cual esta asociado este gasto',
  `id_activofijo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_bodega` int(10) NOT NULL DEFAULT '0',
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'C=cuenta P=producto S=servicio',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `rut` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_factura` int(10) NOT NULL DEFAULT '0',
  `folio_guiadespacho` varchar(100) COLLATE utf8_spanish_ci NOT NULL COMMENT 'folios de guias de despacho asociadas a la factura, se separan por guiones',
  `folio_ordencompra` int(10) NOT NULL DEFAULT '0',
  `folio_notaventa` int(10) NOT NULL DEFAULT '0',
  `folio_importacion` int(10) NOT NULL DEFAULT '0',
  `folio_ordenproduccion` int(10) NOT NULL,
  `guia_venta` int(10) NOT NULL,
  `folio_facturacion` int(10) NOT NULL,
  `documento_facturacion` varchar(2) COLLATE utf8_spanish_ci NOT NULL,
  `id_item_ordenproduccion` int(10) NOT NULL,
  `fecha_compra` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `time_compra` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp de fecha de emision de la factura',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'mes de contabilizacion',
  `ano_control` int(4) NOT NULL DEFAULT '0' COMMENT 'año de contabilizacion',
  `numero_control` int(10) NOT NULL DEFAULT '0' COMMENT 'numero de contabilizacion',
  `codigo_producto` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_final` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `impuesto` int(1) NOT NULL DEFAULT '0' COMMENT '1=SI 0=NO (Indica si el item esta afecto a iva)',
  `precio_lista` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'Precio de lista del proveedor',
  `descuento_porc` int(2) NOT NULL DEFAULT '0' COMMENT 'Porcentaje de descuento lineal',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0' COMMENT 'Descuento lineal en pesos',
  `precio_compra` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'Precio de compra con descuento lineal aplicado',
  `precio_final` decimal(12,2) NOT NULL,
  `cantidad` decimal(12,2) NOT NULL,
  `cantidad_devuelta` int(10) NOT NULL DEFAULT '0' COMMENT 'cantidad devuelta con notas de credito',
  `bultos` int(10) NOT NULL,
  `lote` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `serie` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `subtotal` decimal(12,2) NOT NULL DEFAULT '0.00',
  `monto_impuesto_adicional` int(10) NOT NULL,
  `monto_impuesto_especifico` int(10) NOT NULL,
  `codigo_impuesto_adicional` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `tasa_impuesto_adicional` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `descuento_global` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT '% de descuento global aplicado a la factura',
  `subtotal_final` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal neto con el descuento global aplicado',
  `sw_exento` int(11) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `id_compra` (`id_compra`),
  KEY `id_proveedor` (`id_proveedor`),
  KEY `folio_ordencompra` (`folio_ordencompra`),
  KEY `codigo_producto` (`codigo_producto`),
  KEY `folio_guiadespacho` (`folio_guiadespacho`),
  KEY `estado` (`estado`),
  KEY `id_centronegocio` (`id_centronegocio`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`),
  KEY `id_item_ordenproduccion` (`id_item_ordenproduccion`),
  KEY `codigo_final` (`codigo_final`),
  KEY `folio_facturacion` (`folio_facturacion`),
  KEY `id_bodega` (`id_bodega`),
  KEY `documento_facturacion` (`documento_facturacion`),
  KEY `guia_venta` (`guia_venta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_guiasdespacho_compras_detalle`
--

LOCK TABLES `tbl_guiasdespacho_compras_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_guiasdespacho_compras_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_guiasdespacho_compras_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_guiasdespacho_detalle`
--

DROP TABLE IF EXISTS `tbl_guiasdespacho_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_guiasdespacho_detalle` (
  `id_registro` int(10) NOT NULL AUTO_INCREMENT,
  `id_guiadespacho` int(10) NOT NULL DEFAULT '0',
  `folio_guiadespacho` int(10) NOT NULL DEFAULT '0',
  `folio_factura` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `fecha_emision` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `time_emision` int(10) NOT NULL,
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `id_facturacion` int(10) NOT NULL,
  `anulada` int(1) NOT NULL DEFAULT '0' COMMENT '0=no 1=si',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'rut del cliente',
  `rut_vendedor` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `id_vendedor` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `id_item` int(10) NOT NULL DEFAULT '0',
  `id_activofijo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_producto` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `pmp` int(10) NOT NULL DEFAULT '0',
  `precio_unitario` int(10) NOT NULL DEFAULT '0',
  `precio_venta` decimal(12,2) NOT NULL,
  `precio_final_venta` decimal(12,2) NOT NULL,
  `cantidad` int(10) NOT NULL DEFAULT '0',
  `cantidad_real` decimal(12,2) NOT NULL,
  `subtotal` int(10) NOT NULL DEFAULT '0',
  `descuento_porc` decimal(12,2) NOT NULL,
  `descuento_porc_global` decimal(12,2) NOT NULL,
  `subtotal_neto` decimal(12,2) NOT NULL,
  `subtotal_final` decimal(12,2) NOT NULL,
  `cantidad_facturada` int(10) NOT NULL DEFAULT '0' COMMENT 'indica la cantidad de unidades que se encuentran facturadas',
  `cantidad_sinfacturar` int(10) NOT NULL DEFAULT '0' COMMENT 'indica la cantidad de unidades que no han sido facturadas',
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `id_registro` (`id_registro`),
  KEY `folio_guiadespacho` (`folio_guiadespacho`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_guiasdespacho_detalle`
--

LOCK TABLES `tbl_guiasdespacho_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_guiasdespacho_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_guiasdespacho_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_guiasdespacho_facturar`
--

DROP TABLE IF EXISTS `tbl_guiasdespacho_facturar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_guiasdespacho_facturar` (
  `folio_facturacion` int(10) NOT NULL AUTO_INCREMENT,
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `facturado` int(1) NOT NULL DEFAULT '0' COMMENT '0=no 1=Si',
  `id_registro` int(10) NOT NULL DEFAULT '0',
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `rut_cliente` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folios_guias` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `folio_facturacion` (`folio_facturacion`),
  KEY `id_registro` (`id_registro`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_guiasdespacho_facturar`
--

LOCK TABLES `tbl_guiasdespacho_facturar` WRITE;
/*!40000 ALTER TABLE `tbl_guiasdespacho_facturar` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_guiasdespacho_facturar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_guiasdespacho_facturar_detalle`
--

DROP TABLE IF EXISTS `tbl_guiasdespacho_facturar_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_guiasdespacho_facturar_detalle` (
  `folio_facturacion` int(10) NOT NULL DEFAULT '0',
  `folio_guiadespacho` int(10) NOT NULL DEFAULT '0',
  `codigo_producto` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `cantidad` int(10) NOT NULL DEFAULT '0',
  `pmp` int(10) NOT NULL DEFAULT '0',
  `unitario` int(10) NOT NULL DEFAULT '0',
  `subtotal` int(10) NOT NULL DEFAULT '0',
  KEY `folio_facturacion` (`folio_facturacion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_guiasdespacho_facturar_detalle`
--

LOCK TABLES `tbl_guiasdespacho_facturar_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_guiasdespacho_facturar_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_guiasdespacho_facturar_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_guiasdespacho_tipos`
--

DROP TABLE IF EXISTS `tbl_guiasdespacho_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_guiasdespacho_tipos` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `orden` int(10) NOT NULL,
  `descripcion` varchar(255) NOT NULL,
  `sw_default` int(1) NOT NULL,
  `sw_inventario` int(1) NOT NULL,
  `sw_importaventa` int(1) NOT NULL,
  `sw_voucher` int(1) NOT NULL,
  `comentarios` varchar(255) NOT NULL,
  `sw_predeterminada` int(1) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `orden` (`orden`),
  KEY `sw_inventario` (`sw_inventario`),
  KEY `sw_importaventa` (`sw_importaventa`),
  KEY `sw_voucher` (`sw_voucher`),
  KEY `sw_default` (`sw_default`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_guiasdespacho_tipos`
--

LOCK TABLES `tbl_guiasdespacho_tipos` WRITE;
/*!40000 ALTER TABLE `tbl_guiasdespacho_tipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_guiasdespacho_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_guiasdespacho_ventas`
--

DROP TABLE IF EXISTS `tbl_guiasdespacho_ventas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_guiasdespacho_ventas` (
  `id_transaccion` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion del comprobante contable',
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `folio_guia` int(10) NOT NULL,
  `sw_iva` int(1) NOT NULL,
  `estado_sii` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `estado_merc` int(10) NOT NULL COMMENT 'id del despacho asociado a nota de pedido',
  `track_id` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `sw_envio` int(1) NOT NULL,
  `folio_factura` int(10) NOT NULL,
  `folio_notapedido` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `folio_ordenproduccion` int(10) NOT NULL,
  `folio_cotizacion` int(11) NOT NULL,
  `sw_electronica` int(1) NOT NULL,
  `id_tipoguia` int(10) NOT NULL COMMENT 'tbl_guiasdespacho_tipos',
  `id_tipodespacho` int(2) NOT NULL,
  `id_cliente` int(10) NOT NULL,
  `tipo_documento` int(1) NOT NULL DEFAULT '0',
  `sw_rutear` int(1) NOT NULL DEFAULT '0' COMMENT 'indica si el pedido se debe rutear',
  `folio_ruta` int(10) NOT NULL,
  `rut` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `razon_social` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `direccion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `giro` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `fono_fax` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `comuna` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `ciudad` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_comuna` int(10) NOT NULL,
  `id_ciudad` int(10) NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `clase_sucursal` char(1) COLLATE utf8_spanish_ci NOT NULL COMMENT 'clase de la sucursal del cliente al momento de procesar el pedido',
  `orden_sucursal` int(10) NOT NULL,
  `prioridad_despacho` int(10) NOT NULL,
  `nombre_sucursal` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `contacto` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `email_emisor` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_contacto` int(10) NOT NULL,
  `sw_periodo` int(1) NOT NULL COMMENT '0=abierto 1=cerrado ( corresponde al periodo abierto o cerrado)',
  `sw_multiop` int(1) NOT NULL,
  `fecha_solicitud` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_solicitud` int(10) NOT NULL,
  `fecha_ejecucion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_ejecucion` int(10) NOT NULL,
  `fecha_proceso` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_proceso` int(10) NOT NULL,
  `despacho_desde` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_desde` int(10) NOT NULL,
  `despacho_hasta` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_hasta` int(10) NOT NULL,
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `id_usuario_proceso` int(10) NOT NULL,
  `id_bodega` int(10) NOT NULL COMMENT 'id bodega de destino',
  `id_centrocosto` int(10) NOT NULL,
  `id_centronegocio` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `id_solicita` int(10) NOT NULL,
  `id_autoriza` int(10) NOT NULL,
  `id_ejecuta` int(10) NOT NULL,
  `id_formapago` int(10) NOT NULL,
  `id_vendedor` int(10) NOT NULL,
  `id_tipopedido` int(1) NOT NULL COMMENT '0=guiadirecto 1=guiadesdepedido',
  `id_formaentrega` int(1) NOT NULL COMMENT '0=parcial 1=total',
  `cuenta_origen` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'contracuenta de la contabilizacion ej. merc. nac v/s cuenta_origen',
  `orden_compra` varchar(64) COLLATE utf8_spanish_ci NOT NULL COMMENT '64 bytes para el cod o folio de la oc asociada al pedido',
  `cotizacion` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_sucursal` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `total` int(10) NOT NULL,
  `descuento_cantidad` decimal(13,3) NOT NULL,
  `descuento_porc` decimal(12,2) NOT NULL,
  `descuento_pesos` int(10) NOT NULL,
  `neto` int(10) NOT NULL,
  `iva` int(10) NOT NULL,
  `bruto` int(10) NOT NULL,
  `estado` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(1000) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `comentarios_impresion` text COLLATE utf8_spanish_ci NOT NULL,
  `direccion_despacho` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `descuento_afecto` decimal(12,2) NOT NULL,
  `descuento_exento` decimal(12,2) NOT NULL,
  `tipodescuento_afecto` int(11) NOT NULL,
  `tipodescuento_exento` int(11) NOT NULL,
  `suma_afecto` double(10,2) NOT NULL,
  `suma_exento` double(12,2) NOT NULL,
  `neto_exento` double(10,2) NOT NULL,
  `montodescuento_afecto` double(10,2) NOT NULL,
  `montodescuento_exento` double(10,2) NOT NULL,
  `porcdescuento_afecto` double(10,2) NOT NULL,
  `porcdescuento_exento` double(10,2) NOT NULL,
  `bruto_palabras` varchar(70) COLLATE utf8_spanish_ci NOT NULL,
  `id_motivosanulacion` int(11) NOT NULL,
  `id_listaprecios` int(10) NOT NULL,
  UNIQUE KEY `folio` (`folio`),
  KEY `estado` (`estado`),
  KEY `fecha_ejecucion` (`fecha_ejecucion`),
  KEY `time_ejecucion` (`time_ejecucion`),
  KEY `cuenta_origen` (`cuenta_origen`),
  KEY `id_bodega` (`id_bodega`),
  KEY `sw_periodo` (`sw_periodo`),
  KEY `time_proceso` (`time_proceso`),
  KEY `id_usuario_proceso` (`id_usuario_proceso`),
  KEY `orden_compra` (`orden_compra`),
  KEY `sw_multiop` (`sw_multiop`),
  KEY `codigo_sucursal` (`codigo_sucursal`),
  KEY `rut` (`rut`),
  KEY `razon_social` (`razon_social`),
  KEY `direccion` (`direccion`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `contacto` (`contacto`),
  KEY `id_contacto` (`id_contacto`),
  KEY `id_formapago` (`id_formapago`),
  KEY `id_vendedor` (`id_vendedor`),
  KEY `fecha_solicitud` (`fecha_solicitud`),
  KEY `time_solicitud` (`time_solicitud`),
  KEY `id_tipopedido` (`id_tipopedido`),
  KEY `id_formaentrega` (`id_formaentrega`),
  KEY `cotizacion` (`cotizacion`),
  KEY `despacho_desde` (`despacho_desde`),
  KEY `time_desde` (`time_desde`),
  KEY `despacho_hasta` (`despacho_hasta`),
  KEY `time_hasta` (`time_hasta`),
  KEY `id_cliente` (`id_cliente`),
  KEY `fecha_proceso` (`fecha_proceso`),
  KEY `orden_sucursal` (`orden_sucursal`),
  KEY `prioridad_despacho` (`prioridad_despacho`),
  KEY `clase_sucursal` (`clase_sucursal`),
  KEY `tipo_documento` (`tipo_documento`),
  KEY `sw_rutear` (`sw_rutear`),
  KEY `folio_ruta` (`folio_ruta`),
  KEY `email_emisor` (`email_emisor`),
  KEY `folio_guia` (`folio_guia`),
  KEY `id_tipoguia` (`id_tipoguia`),
  KEY `sw_electronica` (`sw_electronica`),
  KEY `folio_notapedido` (`folio_notapedido`),
  KEY `folio_factura` (`folio_factura`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`),
  KEY `sw_iva` (`sw_iva`),
  KEY `estado_merc` (`estado_merc`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_guiasdespacho_ventas`
--

LOCK TABLES `tbl_guiasdespacho_ventas` WRITE;
/*!40000 ALTER TABLE `tbl_guiasdespacho_ventas` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_guiasdespacho_ventas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_guiasdespacho_ventas_detalle`
--

DROP TABLE IF EXISTS `tbl_guiasdespacho_ventas_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_guiasdespacho_ventas_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `folio_guia` int(10) NOT NULL,
  `folio_factura` int(10) NOT NULL,
  `folio_op` int(10) NOT NULL,
  `fecha_guia` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_guia` int(10) NOT NULL,
  `rut` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `razon_social` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `sw_periodo` int(1) NOT NULL,
  `id_usuario` int(10) NOT NULL COMMENT 'id del usuario creador de la linea 1=Sistema',
  `id_usuario_proceso` int(10) NOT NULL,
  `time_creacion_registro` int(10) NOT NULL,
  `time_proceso` int(10) NOT NULL,
  `id_item` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `codigo` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_sku` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `prioridad_despacho` int(10) NOT NULL COMMENT 'orden de prioridad de despachos por nota de pedido',
  `clase_sucursal` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'Indica al boucher si la linea ha sido finalizada 1=Si 0=No',
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT 'ID del proyecto asociado a la linea contable que genero el cargo u/o abono',
  `id_vendedor` int(10) NOT NULL,
  `id_formaentrega` int(10) NOT NULL,
  `bultos` int(10) NOT NULL,
  `numero_lote` varchar(128) COLLATE utf8_spanish_ci NOT NULL,
  `numero_serie` varchar(128) COLLATE utf8_spanish_ci NOT NULL,
  `cantidad` decimal(15,5) NOT NULL,
  `unidad_medida` char(16) COLLATE utf8_spanish_ci NOT NULL DEFAULT 'UND',
  `cantidad_real` decimal(12,2) NOT NULL,
  `reserva` decimal(12,2) NOT NULL,
  `embalado` decimal(12,2) NOT NULL,
  `facturado` decimal(12,2) NOT NULL,
  `pendiente` decimal(12,2) NOT NULL,
  `pendiente_historico` int(10) NOT NULL COMMENT 'aqui se almacena la cantidad pendiente que se origino al momento procesar el pedido',
  `unitario` decimal(15,5) NOT NULL,
  `descuento` decimal(12,2) NOT NULL COMMENT 'porc de descuento aplicado al subtotal',
  `descuento_pesos` int(10) NOT NULL COMMENT 'descuento en pesos aplicado al subtotal',
  `subtotal` int(10) NOT NULL,
  `subtotal_final` int(11) NOT NULL,
  `monto_impuesto_adicional` int(10) NOT NULL,
  `monto_impuesto_especifico` int(10) NOT NULL,
  `codigo_impuesto_adicional` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `tasa_impuesto_adicional` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `costo_unitario_pmp` int(11) NOT NULL,
  `cpp` int(10) NOT NULL,
  `costo_total` int(11) NOT NULL,
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `orden_compra` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `sw_exento` int(11) NOT NULL,
  `precio_referencial` decimal(12,2) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `folio` (`folio`),
  KEY `id_item` (`id_item`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `time_creacion_registro` (`time_creacion_registro`),
  KEY `tipo_item` (`tipo_item`),
  KEY `codigo` (`codigo`),
  KEY `sw_periodo` (`sw_periodo`),
  KEY `numero_lote` (`numero_lote`),
  KEY `numero_serie` (`numero_serie`),
  KEY `reserva` (`reserva`),
  KEY `time_proceso` (`time_proceso`),
  KEY `id_usuario_proceso` (`id_usuario_proceso`),
  KEY `orden_compra` (`orden_compra`),
  KEY `id_vendedor` (`id_vendedor`),
  KEY `id_formaentrega` (`id_formaentrega`),
  KEY `embalado` (`embalado`),
  KEY `facturado` (`facturado`),
  KEY `prioridad_despacho` (`prioridad_despacho`),
  KEY `codigo_sku` (`codigo_sku`),
  KEY `clase_sucursal` (`clase_sucursal`),
  KEY `folio_guia` (`folio_guia`),
  KEY `rut` (`rut`),
  KEY `folio_factura` (`folio_factura`),
  KEY `folio_op` (`folio_op`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_guiasdespacho_ventas_detalle`
--

LOCK TABLES `tbl_guiasdespacho_ventas_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_guiasdespacho_ventas_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_guiasdespacho_ventas_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_importaciones`
--

DROP TABLE IF EXISTS `tbl_importaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_importaciones` (
  `id_transaccion` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion del comprobante contable',
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `id_cliente` int(10) NOT NULL,
  `rut` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `razon_social` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `direccion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `clase_sucursal` char(1) COLLATE utf8_spanish_ci NOT NULL COMMENT 'clase de la sucursal del cliente al momento de procesar el pedido',
  `orden_sucursal` int(10) NOT NULL,
  `prioridad_despacho` int(10) NOT NULL,
  `nombre_sucursal` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `contacto` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `id_contacto` int(10) NOT NULL,
  `sw_periodo` int(1) NOT NULL COMMENT '0=abierto 1=cerrado ( corresponde al periodo abierto o cerrado)',
  `sw_multiop` int(1) NOT NULL,
  `fecha_solicitud` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_solicitud` int(10) NOT NULL,
  `fecha_ejecucion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_ejecucion` int(10) NOT NULL,
  `fecha_proceso` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_proceso` int(10) NOT NULL,
  `despacho_desde` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_desde` int(10) NOT NULL,
  `despacho_hasta` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_hasta` int(10) NOT NULL,
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `id_usuario_proceso` int(10) NOT NULL,
  `id_bodega` int(10) NOT NULL COMMENT 'id bodega de destino',
  `id_centrocosto` int(10) NOT NULL,
  `id_centronegocio` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `id_solicita` int(10) NOT NULL,
  `id_autoriza` int(10) NOT NULL,
  `id_ejecuta` int(10) NOT NULL,
  `id_formapago` int(10) NOT NULL,
  `id_vendedor` int(10) NOT NULL,
  `id_tipopedido` int(1) NOT NULL,
  `id_formaentrega` int(1) NOT NULL COMMENT '0=parcial 1=total',
  `cuenta_origen` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'contracuenta de la contabilizacion ej. merc. nac v/s cuenta_origen',
  `orden_compra` varchar(64) COLLATE utf8_spanish_ci NOT NULL COMMENT '64 bytes para el cod o folio de la oc asociada al pedido',
  `cotizacion` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_sucursal` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `total` int(10) NOT NULL,
  `estado` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion_despacho` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `factor_costeo` decimal(4,2) NOT NULL,
  `observaciones_internas` varchar(200) COLLATE utf8_spanish_ci NOT NULL,
  `id_origen` int(11) NOT NULL,
  `time_modificacion` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `id_modificador` int(11) NOT NULL,
  `codigo_importacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `sw_autoriza` int(1) NOT NULL,
  `id_proveedor` int(11) NOT NULL,
  `time_modificador` timestamp NULL DEFAULT NULL,
  UNIQUE KEY `folio` (`folio`),
  KEY `estado` (`estado`),
  KEY `fecha_ejecucion` (`fecha_ejecucion`),
  KEY `time_ejecucion` (`time_ejecucion`),
  KEY `cuenta_origen` (`cuenta_origen`),
  KEY `id_bodega` (`id_bodega`),
  KEY `sw_periodo` (`sw_periodo`),
  KEY `time_proceso` (`time_proceso`),
  KEY `id_usuario_proceso` (`id_usuario_proceso`),
  KEY `orden_compra` (`orden_compra`),
  KEY `sw_multiop` (`sw_multiop`),
  KEY `codigo_sucursal` (`codigo_sucursal`),
  KEY `rut` (`rut`),
  KEY `razon_social` (`razon_social`),
  KEY `direccion` (`direccion`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `contacto` (`contacto`),
  KEY `id_contacto` (`id_contacto`),
  KEY `id_formapago` (`id_formapago`),
  KEY `id_vendedor` (`id_vendedor`),
  KEY `fecha_solicitud` (`fecha_solicitud`),
  KEY `time_solicitud` (`time_solicitud`),
  KEY `id_tipopedido` (`id_tipopedido`),
  KEY `id_formaentrega` (`id_formaentrega`),
  KEY `cotizacion` (`cotizacion`),
  KEY `despacho_desde` (`despacho_desde`),
  KEY `time_desde` (`time_desde`),
  KEY `despacho_hasta` (`despacho_hasta`),
  KEY `time_hasta` (`time_hasta`),
  KEY `id_cliente` (`id_cliente`),
  KEY `fecha_proceso` (`fecha_proceso`),
  KEY `orden_sucursal` (`orden_sucursal`),
  KEY `prioridad_despacho` (`prioridad_despacho`),
  KEY `clase_sucursal` (`clase_sucursal`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_importaciones`
--

LOCK TABLES `tbl_importaciones` WRITE;
/*!40000 ALTER TABLE `tbl_importaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_importaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_importaciones_detalle`
--

DROP TABLE IF EXISTS `tbl_importaciones_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_importaciones_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `sw_periodo` int(1) NOT NULL,
  `id_usuario` int(10) NOT NULL COMMENT 'id del usuario creador de la linea 1=Sistema',
  `id_usuario_proceso` int(10) NOT NULL,
  `time_creacion_registro` int(10) NOT NULL,
  `time_proceso` int(10) NOT NULL,
  `id_item` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `codigo` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_sku` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `prioridad_despacho` int(10) NOT NULL COMMENT 'orden de prioridad de despachos por nota de pedido',
  `clase_sucursal` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'Indica al boucher si la linea ha sido finalizada 1=Si 0=No',
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT 'ID del proyecto asociado a la linea contable que genero el cargo u/o abono',
  `id_vendedor` int(10) NOT NULL,
  `id_formaentrega` int(10) NOT NULL,
  `bultos` int(10) NOT NULL,
  `numero_lote` varchar(128) COLLATE utf8_spanish_ci NOT NULL,
  `numero_serie` varchar(128) COLLATE utf8_spanish_ci NOT NULL,
  `cantidad` decimal(12,2) NOT NULL,
  `reserva` decimal(12,2) NOT NULL,
  `embalado` decimal(12,2) NOT NULL,
  `facturado` decimal(12,2) NOT NULL,
  `pendiente` decimal(12,2) NOT NULL,
  `unitario` decimal(12,2) NOT NULL,
  `subtotal` int(10) NOT NULL,
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `orden_compra` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `folio` (`folio`),
  KEY `id_item` (`id_item`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `time_creacion_registro` (`time_creacion_registro`),
  KEY `tipo_item` (`tipo_item`),
  KEY `codigo` (`codigo`),
  KEY `sw_periodo` (`sw_periodo`),
  KEY `numero_lote` (`numero_lote`),
  KEY `numero_serie` (`numero_serie`),
  KEY `reserva` (`reserva`),
  KEY `time_proceso` (`time_proceso`),
  KEY `id_usuario_proceso` (`id_usuario_proceso`),
  KEY `orden_compra` (`orden_compra`),
  KEY `id_vendedor` (`id_vendedor`),
  KEY `id_formaentrega` (`id_formaentrega`),
  KEY `embalado` (`embalado`),
  KEY `facturado` (`facturado`),
  KEY `prioridad_despacho` (`prioridad_despacho`),
  KEY `codigo_sku` (`codigo_sku`),
  KEY `clase_sucursal` (`clase_sucursal`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_importaciones_detalle`
--

LOCK TABLES `tbl_importaciones_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_importaciones_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_importaciones_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_impresoras`
--

DROP TABLE IF EXISTS `tbl_impresoras`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_impresoras` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `nombre` char(64) NOT NULL,
  `estado` int(1) NOT NULL,
  `ip` char(15) NOT NULL,
  `url` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_impresoras`
--

LOCK TABLES `tbl_impresoras` WRITE;
/*!40000 ALTER TABLE `tbl_impresoras` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_impresoras` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_impuestos`
--

DROP TABLE IF EXISTS `tbl_impuestos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_impuestos` (
  `id_impuesto` int(10) NOT NULL AUTO_INCREMENT,
  `sw_adicional` int(1) NOT NULL DEFAULT '1',
  `porcentaje` int(10) NOT NULL,
  `descripcion` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id_impuesto` (`id_impuesto`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_impuestos`
--

LOCK TABLES `tbl_impuestos` WRITE;
/*!40000 ALTER TABLE `tbl_impuestos` DISABLE KEYS */;
INSERT INTO `tbl_impuestos` VALUES (1,0,19,'IVA','Impuesto a las ventas y servicios'),(2,1,27,'ILA','Licores, Piscos, Whiski, Aguardiente y Destilados'),(3,1,15,'ILA','Vinos y Cervezas'),(4,1,13,'ILA','Bebidas, Aguas minerales con sabor  y Jugos');
/*!40000 ALTER TABLE `tbl_impuestos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ingresos`
--

DROP TABLE IF EXISTS `tbl_ingresos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ingresos` (
  `id_ingreso` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion del ingreso',
  `folio_ingreso` int(10) NOT NULL AUTO_INCREMENT,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'EP=en proceso IN=ingresado AN=anulado',
  `id_usuario` int(10) NOT NULL DEFAULT '0' COMMENT 'usuario que creo el ingreso en el sistema',
  `id_responsable` int(10) NOT NULL DEFAULT '0' COMMENT 'usuario que inventario los productos',
  `id_bodega` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `folio_ingreso` (`folio_ingreso`),
  KEY `id_ingreso` (`id_ingreso`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ingresos`
--

LOCK TABLES `tbl_ingresos` WRITE;
/*!40000 ALTER TABLE `tbl_ingresos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ingresos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ingresos_detalle`
--

DROP TABLE IF EXISTS `tbl_ingresos_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ingresos_detalle` (
  `folio_ingreso` int(10) NOT NULL DEFAULT '0',
  `codigo_producto` varchar(12) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `cantidad` int(10) NOT NULL DEFAULT '0',
  `ubicacion` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  KEY `folio_ingreso` (`folio_ingreso`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ingresos_detalle`
--

LOCK TABLES `tbl_ingresos_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_ingresos_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ingresos_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_inventario`
--

DROP TABLE IF EXISTS `tbl_inventario`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_inventario` (
  `registro` int(10) NOT NULL AUTO_INCREMENT COMMENT 'numerador correlativo general de lineas',
  `sw_auditado` int(1) NOT NULL COMMENT 'indica si el movimiento se encuntra auditado 1=si 0=no',
  `time_proceso` int(10) NOT NULL COMMENT 'timestamp fecha proceso',
  `fecha_proceso` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `hora_proceso` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `id_linea` int(10) NOT NULL DEFAULT '0' COMMENT 'numerador correlativo de cada producto',
  `estado` int(1) NOT NULL DEFAULT '0',
  `inicial` int(1) NOT NULL DEFAULT '0' COMMENT '1=Si 0=No',
  `time_registro` int(10) NOT NULL DEFAULT '0' COMMENT 'timestamp fecha documento',
  `fecha` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `hora` varchar(8) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'rut del cliente o proveedor',
  `codigo_producto` varchar(12) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `tipo_comprobante` varchar(3) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'FV=FacturaVenta FC=FacturaCompra GV=GuiaVenta GC=GuiaCompra CI=ConsumoInterno',
  `numero_comprobante` int(10) NOT NULL DEFAULT '0',
  `folio_factura` int(10) NOT NULL DEFAULT '0',
  `folio_guiadespacho` int(10) NOT NULL DEFAULT '0',
  `unidades_entrada` decimal(13,3) NOT NULL DEFAULT '0.000',
  `unidades_salida` decimal(13,3) NOT NULL DEFAULT '0.000',
  `unidades_saldo` decimal(13,3) NOT NULL DEFAULT '0.000',
  `valores_entrada` decimal(13,3) NOT NULL DEFAULT '0.000',
  `valores_salida` decimal(13,3) NOT NULL DEFAULT '0.000',
  `valores_saldo` decimal(12,2) NOT NULL DEFAULT '0.00',
  `pmp` decimal(13,3) NOT NULL DEFAULT '0.000' COMMENT 'cpp proviene de access',
  `precio` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'precio de compra o venta',
  UNIQUE KEY `registro` (`registro`),
  KEY `codigo_producto` (`codigo_producto`),
  KEY `sw_auditado` (`sw_auditado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_inventario`
--

LOCK TABLES `tbl_inventario` WRITE;
/*!40000 ALTER TABLE `tbl_inventario` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_inventario` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_inventario_zonas`
--

DROP TABLE IF EXISTS `tbl_inventario_zonas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_inventario_zonas` (
  `folio_inventario` int(10) NOT NULL AUTO_INCREMENT,
  `id_bodega` int(10) NOT NULL DEFAULT '0',
  `id_zona` int(10) NOT NULL DEFAULT '0',
  `id_usuario_inventario` int(10) NOT NULL DEFAULT '0',
  `time_inventario` int(10) NOT NULL DEFAULT '0',
  `id_usuario_audito` int(10) NOT NULL DEFAULT '0',
  `time_audito` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `folio_inventario` (`folio_inventario`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci COMMENT='Almacena la toma de inventarios';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_inventario_zonas`
--

LOCK TABLES `tbl_inventario_zonas` WRITE;
/*!40000 ALTER TABLE `tbl_inventario_zonas` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_inventario_zonas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_inventario_zonas_detalle`
--

DROP TABLE IF EXISTS `tbl_inventario_zonas_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_inventario_zonas_detalle` (
  `id_registro` int(10) NOT NULL AUTO_INCREMENT,
  `folio_inventario` int(10) NOT NULL DEFAULT '0',
  `id_item` int(10) NOT NULL DEFAULT '0',
  `codigo_producto` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `cantidad_sistema` int(10) NOT NULL DEFAULT '0',
  `cantidad_inventario` int(10) NOT NULL DEFAULT '0',
  `diferencia` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `id_registro` (`id_registro`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci COMMENT='Almacena el detalle de la toma de inventarios';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_inventario_zonas_detalle`
--

LOCK TABLES `tbl_inventario_zonas_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_inventario_zonas_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_inventario_zonas_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_isapres`
--

DROP TABLE IF EXISTS `tbl_isapres`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_isapres` (
  `id_afp` int(10) NOT NULL AUTO_INCREMENT,
  `afp` varchar(25) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `tasa_normal` decimal(10,4) NOT NULL DEFAULT '0.0000',
  `tasa_jubilado` decimal(10,4) NOT NULL DEFAULT '0.0000',
  UNIQUE KEY `id_afp` (`id_afp`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_isapres`
--

LOCK TABLES `tbl_isapres` WRITE;
/*!40000 ALTER TABLE `tbl_isapres` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_isapres` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_items_imagenes`
--

DROP TABLE IF EXISTS `tbl_items_imagenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_items_imagenes` (
  `id_registro` int(10) NOT NULL AUTO_INCREMENT,
  `id_item` int(10) NOT NULL,
  `titulo` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_item` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `sw_principal` int(1) NOT NULL COMMENT 'imagen por defecto que se mostrara al inicio',
  `orden` int(10) NOT NULL,
  `nombre_archivo` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `time` int(10) NOT NULL,
  `usuario` int(10) NOT NULL,
  UNIQUE KEY `id_registro` (`id_registro`),
  KEY `id_item` (`id_item`),
  KEY `codigo_item` (`codigo_item`),
  KEY `usuario` (`usuario`),
  KEY `time` (`time`),
  KEY `orden` (`orden`),
  KEY `sw_principal` (`sw_principal`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_items_imagenes`
--

LOCK TABLES `tbl_items_imagenes` WRITE;
/*!40000 ALTER TABLE `tbl_items_imagenes` DISABLE KEYS */;
INSERT INTO `tbl_items_imagenes` VALUES (1,3,'klklkl','10003',1,1,'10003_16102017_163015.jpg',1508182215,705);
/*!40000 ALTER TABLE `tbl_items_imagenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_librodiario`
--

DROP TABLE IF EXISTS `tbl_librodiario`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_librodiario` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `id_usuario` int(10) NOT NULL COMMENT 'id del usuario creador de la linea 1=Sistema',
  `transaccion_automatica` int(1) NOT NULL DEFAULT '0' COMMENT 'Indica si la linea ha sido creada automaticamente por el sistema 1=Si 0=No',
  `id_linea` int(10) NOT NULL COMMENT 'timestamp con fecha y hora de creacion del boucher',
  `id_item` int(10) NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `id_banco` int(10) NOT NULL,
  `estado` int(1) NOT NULL COMMENT 'Indica al boucher si la linea ha sido finalizada 1=Si 0=No',
  `sw_auditado` int(1) NOT NULL DEFAULT '0',
  `dia` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'Dia del Boucher',
  `mes` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'Mes del boucher',
  `ano` int(4) NOT NULL COMMENT 'AÃ±o del Boucher',
  `time_transaccion` int(10) NOT NULL,
  `estado_transaccion` char(1) COLLATE utf8_spanish_ci NOT NULL COMMENT 'A=abierta C=cerrada N=Anulada',
  `activa` int(1) NOT NULL COMMENT '1=activa 0=inactiva',
  `numero_transaccion` int(10) NOT NULL COMMENT 'Indica el nÃºmero del boucher',
  `tipo_transaccion` char(1) COLLATE utf8_spanish_ci NOT NULL COMMENT 'Indica el tipo de boucher I=Ingreso E=Egreso T=Traspaso',
  `linea_transaccion` int(10) NOT NULL COMMENT 'Indica el nÃºmero de la linea del boucher',
  `tipo_documento` char(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'Indica la clave del documento FV=FacturaVenta FC=FacturaCompra NC=NotaCredito GD=GuiaDespacho DB=Debito CR=Credito',
  `folio_documento` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'Indica el folio del documento ej. folio de factura o cheque o notacredito, etc...',
  `fecha_documento` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'Indica la fecha del documento ej. cheque a fecha',
  `time_vencimiento` int(10) NOT NULL,
  `fecha_operacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT 'fecha que se origino la operacion de la linea ( ej. voucher de pago de factura )',
  `time_operacion` int(10) NOT NULL,
  `rut` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'Rut Auxiliar de Cliente o Proveedor o Cualquier cuenta con auxiliar',
  `codigo_cuenta` int(9) NOT NULL,
  `nombre_cuenta` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `centro_costo` int(10) NOT NULL DEFAULT '0' COMMENT 'Indica el id del centro de costo',
  `centro_ingreso` int(10) NOT NULL DEFAULT '0' COMMENT 'Indica el id del centro de negocio',
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT 'ID del proyecto asociado a la linea contable que genero el cargo u/o abono',
  `id_activofijo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `glosa` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `debe` int(10) NOT NULL,
  `haber` int(10) NOT NULL,
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `order_no` int(10) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `numero_transaccion` (`numero_transaccion`),
  KEY `codigo_cuenta` (`codigo_cuenta`),
  KEY `ano` (`ano`),
  KEY `activa` (`activa`),
  KEY `mes` (`mes`),
  KEY `folio` (`folio`),
  KEY `id_item` (`id_item`),
  KEY `fecha_operacion` (`fecha_operacion`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `time_vencimiento` (`time_vencimiento`),
  KEY `time_operacion` (`time_operacion`),
  KEY `time_transaccion` (`time_transaccion`),
  KEY `order_no` (`order_no`),
  KEY `id_banco` (`id_banco`),
  KEY `folio_documento` (`folio_documento`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_librodiario`
--

LOCK TABLES `tbl_librodiario` WRITE;
/*!40000 ALTER TABLE `tbl_librodiario` DISABLE KEYS */;
INSERT INTO `tbl_librodiario` VALUES (1,1,691,1,1710181106,1,0,0,1,0,'14','12',2023,1702522800,'C',1,1,'T',1,'FC','190837','14/12/2023',1702522800,'',943930800,'78706540-6',102010301,'VEHICULO',0,0,0,'','CUENTA CONTABLE #102010301',2126100,0,'RECEPCIÓN FACTURA ELECTRONICA COMPRA 190837',0),(2,1,691,1,1710181106,2,0,0,1,0,'14','12',2023,1702522800,'C',1,1,'T',2,'FC','190837','14/12/2023',1702522800,'',943930800,'78706540-6',102010301,'VEHICULO',0,0,0,'','CUENTA CONTABLE #102010301',11190000,0,'RECEPCIÓN FACTURA ELECTRONICA COMPRA 190837',0),(3,1,691,1,1710181106,3,0,0,1,0,'14','12',2023,1702522800,'C',1,1,'T',3,'FC','190837','14/12/2023',1702522800,'',943930800,'78706540-6',101070205,'IVA CREDITO FISCAL',0,0,0,'','FACTURA ELECTRONICA COMPRA 190837',0,0,'RECEPCIÓN FACTURA ELECTRONICA COMPRA 190837',0),(4,1,691,1,1710181106,4,0,0,1,1,'14','12',2023,1702522800,'C',1,1,'T',4,'FC','190837','14/12/2023',1702522800,'',943930800,'78706540-6',201020101,'PROVEEDORES',0,0,0,'','FACTURA ELECTRONICA COMPRA 190837',0,13316100,'RECEPCIÓN FACTURA ELECTRONICA COMPRA 190837',0),(5,2,691,1,1710181106,1,0,0,1,0,'22','12',2023,1703214000,'C',1,2,'T',1,'IC','3138','22/12/2023',1703214000,'',943930800,'76620108-3',101070205,'IVA CREDITO FISCAL',0,0,0,'','RECEPCIÓN FACTURA ELECTRONICA COMPRA 3138',31118,0,'otra glosa',0),(6,2,691,1,1710181106,2,0,0,1,0,'22','12',2023,1703214000,'C',1,2,'T',2,'FC','3138','22/12/2023',1703214000,'',943930800,'76620108-3',301020905,'GASTOS GENERALES',0,0,0,'','CUENTA CONTABLE #301020905',163781,0,'RECEPCIÓN FACTURA ELECTRONICA COMPRA 3138',0),(7,2,691,1,1710181106,3,0,0,1,0,'22','12',2023,1703214000,'C',1,2,'T',3,'FC','3138','22/12/2023',1703214000,'',943930800,'76620108-3',101070205,'IVA CREDITO FISCAL',0,0,0,'','FACTURA ELECTRONICA COMPRA 3138',0,0,'RECEPCIÓN FACTURA ELECTRONICA COMPRA 3138',0),(8,2,691,1,1710181106,4,0,0,1,1,'22','12',2023,1703214000,'C',1,2,'T',4,'FC','3138','22/12/2023',1703214000,'',943930800,'76620108-3',201020101,'PROVEEDORES',0,0,0,'','FACTURA ELECTRONICA COMPRA 3138',0,194899,'RECEPCIÓN FACTURA ELECTRONICA COMPRA 3138',0),(9,3,691,0,1,1,0,0,1,0,'14','12',2023,1702522800,'C',1,3,'I',1,'CR','3','',943930800,'',943930800,'',203010201,'CAPITAL PAGADO',0,0,0,'','capital aportado',0,4000000,'otra glosa',0),(10,3,691,0,2,2,0,0,1,0,'14','12',2023,1702522800,'C',1,3,'I',2,'EF','3','',943930800,'',943930800,'',101010101,'CAJA CENTRAL',0,0,0,'','capital aportado',4000000,0,'',0),(11,4,691,0,1,1,0,0,1,0,'15','12',2023,1702609200,'C',1,4,'I',1,'CR','4','',943930800,'',943930800,'',201020302,'PRESTAMOS POR PAGAR',0,0,0,'','prestamo socio',0,9600000,'',0),(12,4,691,0,2,2,0,0,1,0,'15','12',2023,1702609200,'C',1,4,'I',2,'EF','4','',943930800,'',943930800,'',101010101,'CAJA CENTRAL',0,0,0,'','prestamo socio',9600000,0,'',0),(13,5,691,0,1,1,0,0,1,1,'31','12',2023,1703991600,'C',1,5,'I',1,'FC','190837','',943930800,'',943930800,'78706540-6',201020101,'Proveedores',0,0,0,'','FACTURA ELECTRONICA COMPRA 190837',13316100,0,'',0),(14,5,691,0,2,2,0,0,1,1,'31','12',2023,1703991600,'C',1,5,'I',2,'FC','3138','',943930800,'',943930800,'76620108-3',201020101,'Proveedores',0,0,0,'','FACTURA ELECTRONICA COMPRA 3138',194899,0,'',0),(15,5,691,0,3,3,0,0,1,0,'31','12',2023,1703991600,'C',1,5,'I',3,'EF','5','',943930800,'',943930800,'',101010101,'CAJA CENTRAL',0,0,0,'','pago proveedores',0,13510999,'',0),(16,6,1284,1,1717433404,1,0,0,1,0,'02','01',2024,1704164400,'C',1,6,'T',1,'AP','','02/01/2024',1704164400,'',943930800,'',101010101,'CAJA CENTRAL',0,0,0,'','APERTURA BALANCE 2024 CAJA CENTRAL',89001,0,'APERTURA BALANCE 2024',0),(17,6,1284,1,1717433404,2,0,0,1,0,'02','01',2024,1704164400,'C',1,6,'T',2,'AP','','02/01/2024',1704164400,'',943930800,'',101070205,'IVA CREDITO FISCAL',0,0,0,'','APERTURA BALANCE 2024 IVA CREDITO FISCAL',31118,0,'APERTURA BALANCE 2024',0),(18,6,1284,1,1717433404,3,0,0,1,0,'02','01',2024,1704164400,'C',1,6,'T',3,'AP','','02/01/2024',1704164400,'',943930800,'',102010301,'VEHICULO',0,0,0,'','APERTURA BALANCE 2024 VEHICULO',13316100,0,'APERTURA BALANCE 2024',0),(19,6,1284,1,1717433404,4,0,0,1,0,'02','01',2024,1704164400,'C',1,6,'T',4,'AP','','02/01/2024',1704164400,'',943930800,'',201020302,'PRESTAMOS POR PAGAR',0,0,0,'','APERTURA BALANCE 2024 PRESTAMOS POR PAGAR',0,9600000,'APERTURA BALANCE 2024',0),(20,6,1284,1,1717433404,5,0,0,1,0,'02','01',2024,1704164400,'C',1,6,'T',5,'AP','','02/01/2024',1704164400,'',943930800,'',203010201,'CAPITAL PAGADO',0,0,0,'','APERTURA BALANCE 2024 CAPITAL PAGADO',0,4000000,'APERTURA BALANCE 2024',0),(21,6,1284,1,1717433404,6,0,0,1,0,'02','01',2024,1704164400,'C',1,6,'T',6,'DB','6','02/01/2024',1704164400,'',943930800,'',203040301,'UTILIDAD O PERDIDA DEL EJERCICIO',0,0,0,'','APERTURA BALANCE 2024',163781,0,'otra glosa',0);
/*!40000 ALTER TABLE `tbl_librodiario` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_librodiario_compras`
--

DROP TABLE IF EXISTS `tbl_librodiario_compras`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_librodiario_compras` (
  `codigo_cuenta` int(10) NOT NULL DEFAULT '0',
  `monto` int(10) NOT NULL DEFAULT '0',
  `periodo` varchar(7) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'mes año',
  `debe` int(10) NOT NULL DEFAULT '0',
  `haber` int(10) NOT NULL DEFAULT '0',
  KEY `codigo_cuenta` (`codigo_cuenta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_librodiario_compras`
--

LOCK TABLES `tbl_librodiario_compras` WRITE;
/*!40000 ALTER TABLE `tbl_librodiario_compras` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_librodiario_compras` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_librodiario_historial`
--

DROP TABLE IF EXISTS `tbl_librodiario_historial`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_librodiario_historial` (
  `id_historial` int(10) NOT NULL AUTO_INCREMENT,
  `time_operacion` int(10) NOT NULL DEFAULT '0',
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `numero_transaccion` int(10) NOT NULL DEFAULT '0',
  `mes` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `ano` int(10) NOT NULL DEFAULT '0',
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `id_historial` (`id_historial`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_librodiario_historial`
--

LOCK TABLES `tbl_librodiario_historial` WRITE;
/*!40000 ALTER TABLE `tbl_librodiario_historial` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_librodiario_historial` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_librodiario_ventas`
--

DROP TABLE IF EXISTS `tbl_librodiario_ventas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_librodiario_ventas` (
  `codigo_cuenta` int(10) NOT NULL DEFAULT '0',
  `monto` int(10) NOT NULL DEFAULT '0',
  `periodo` varchar(7) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'mes año',
  `debe` int(10) NOT NULL DEFAULT '0',
  `haber` int(10) NOT NULL DEFAULT '0',
  KEY `codigo_cuenta` (`codigo_cuenta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_librodiario_ventas`
--

LOCK TABLES `tbl_librodiario_ventas` WRITE;
/*!40000 ALTER TABLE `tbl_librodiario_ventas` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_librodiario_ventas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_licencias`
--

DROP TABLE IF EXISTS `tbl_licencias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_licencias` (
  `registro` varchar(10) CHARACTER SET latin1 NOT NULL DEFAULT '0',
  `rut` varchar(12) CHARACTER SET latin1 NOT NULL DEFAULT '0',
  `dia` varchar(2) CHARACTER SET latin1 NOT NULL DEFAULT '0',
  `mes` varchar(2) CHARACTER SET latin1 NOT NULL DEFAULT '0',
  `ano` varchar(4) CHARACTER SET latin1 NOT NULL DEFAULT '0',
  `motivo` varchar(100) CHARACTER SET latin1 NOT NULL DEFAULT '0',
  `descontable` varchar(2) CHARACTER SET latin1 NOT NULL DEFAULT '0',
  `tipopermiso` varchar(2) CHARACTER SET latin1 NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_licencias`
--

LOCK TABLES `tbl_licencias` WRITE;
/*!40000 ALTER TABLE `tbl_licencias` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_licencias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_liquidaciones`
--

DROP TABLE IF EXISTS `tbl_liquidaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_liquidaciones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `razon_social` varchar(255) NOT NULL,
  `rut_empresa` varchar(10) NOT NULL,
  `fecha` varchar(11) NOT NULL,
  `nombre` varchar(255) NOT NULL,
  `id_trabajador` int(11) NOT NULL,
  `rut_trabajador` varchar(10) NOT NULL,
  `dias_trabajados` int(2) NOT NULL COMMENT 'total de dias trabajados del periodo',
  `dias_inasistencia` int(11) NOT NULL,
  `dias_atrasos` int(11) NOT NULL,
  `dias_licencia` int(11) NOT NULL,
  `dias_vacaciones` int(11) NOT NULL,
  `hrs_extras_cien` int(11) NOT NULL,
  `hrs_extras_cincuenta` int(11) NOT NULL,
  `sueldo_base` int(11) NOT NULL,
  `sueldo_bruto` int(11) NOT NULL,
  `comision` int(11) NOT NULL,
  `aguinaldos` int(11) NOT NULL,
  `grat_legal` int(7) NOT NULL COMMENT 'equivale al 25% del sueldo base con un tope maximo de ?',
  `movilizacion` int(11) NOT NULL,
  `afp` int(11) NOT NULL,
  `isapre` int(10) NOT NULL COMMENT 'monto total a pagar en salud',
  `imponible` int(11) NOT NULL,
  `tasa` decimal(5,4) NOT NULL COMMENT 'tasa total para la salud pactada en uf ( isapres )',
  `prevision` decimal(7,4) NOT NULL COMMENT 'tasa afp prevision',
  `seguro_cesantia` int(10) NOT NULL COMMENT 'monto total a pagar en seguro cesantia',
  `seguro_cesantiatrabajador` int(10) NOT NULL COMMENT 'monto de seguro cesantia trabajador',
  `seguro_cesantiaempleador` int(10) NOT NULL COMMENT 'monto seguro cesantia del empleador',
  `tasa_saludobligatoria` decimal(5,3) NOT NULL COMMENT 'tasa obligatoria de salud (actualmente 7% sobre el imponible )',
  `salud` int(10) NOT NULL COMMENT 'equivale al 7% del imponible obligatorio para la salud',
  `ahorro_apv` int(11) NOT NULL,
  `renta_afecta` int(11) NOT NULL,
  `tasa_renta` int(11) NOT NULL,
  `imp_unico` int(11) NOT NULL,
  `anticipo` int(11) NOT NULL,
  `ccaf` varchar(255) NOT NULL,
  `prestamos` int(11) NOT NULL,
  `fund_alp` int(11) NOT NULL,
  `fecha_pago` varchar(10) NOT NULL,
  `no_cargas` int(11) NOT NULL,
  `asig_fam` int(11) NOT NULL,
  `colacion` int(11) NOT NULL,
  `hrs_extras` int(11) NOT NULL,
  `adic_salud` int(10) NOT NULL COMMENT 'Monto a pagar adicional en salud ( DESCUENTO VOLUNTARIO )',
  `cotizacion_total` int(11) NOT NULL,
  `renta_total_exenta` int(11) NOT NULL,
  `uf_periodo` decimal(10,2) NOT NULL COMMENT 'valor de la uf del ultimo dia del periodo calculado',
  UNIQUE KEY `id` (`id`),
  KEY `id_2` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_liquidaciones`
--

LOCK TABLES `tbl_liquidaciones` WRITE;
/*!40000 ALTER TABLE `tbl_liquidaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_liquidaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_lista_de_precios`
--

DROP TABLE IF EXISTS `tbl_lista_de_precios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_lista_de_precios` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(50) NOT NULL,
  `tipo_de_precio` tinyint(1) NOT NULL DEFAULT '1',
  `id_moneda` int(11) DEFAULT NULL,
  `cantidad_decimales` int(11) DEFAULT NULL,
  `estado` tinyint(1) DEFAULT NULL,
  `fecha_creacion` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `usuario_creador` int(11) DEFAULT NULL,
  `fecha_modificacion` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `usuario_modificador` int(11) DEFAULT NULL,
  `valor` int(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nombre` (`nombre`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_lista_de_precios`
--

LOCK TABLES `tbl_lista_de_precios` WRITE;
/*!40000 ALTER TABLE `tbl_lista_de_precios` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_lista_de_precios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_lista_de_precios_detalle`
--

DROP TABLE IF EXISTS `tbl_lista_de_precios_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_lista_de_precios_detalle` (
  `id_lista_de_precio` int(11) DEFAULT NULL,
  `id_producto` int(11) DEFAULT NULL,
  `precio_venta` float DEFAULT NULL,
  `fecha_creacion` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `usuario_creador` int(11) DEFAULT NULL,
  `fecha_modificacion` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `usuario_modificador` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_lista_de_precios_detalle`
--

LOCK TABLES `tbl_lista_de_precios_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_lista_de_precios_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_lista_de_precios_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_log_hojas_foliadas`
--

DROP TABLE IF EXISTS `tbl_log_hojas_foliadas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_log_hojas_foliadas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fecha` int(10) NOT NULL,
  `folio_inicial` int(10) NOT NULL,
  `cantidad_folios` int(10) NOT NULL,
  `id_usuario` int(11) NOT NULL,
  `nombre_usuario` varchar(70) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_log_hojas_foliadas`
--

LOCK TABLES `tbl_log_hojas_foliadas` WRITE;
/*!40000 ALTER TABLE `tbl_log_hojas_foliadas` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_log_hojas_foliadas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_log_importar_precios`
--

DROP TABLE IF EXISTS `tbl_log_importar_precios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_log_importar_precios` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_usuario` int(11) NOT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `codigo_producto` int(11) NOT NULL,
  `precio_anterior` double(15,3) NOT NULL,
  `precio_nuevo` double(15,3) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_log_importar_precios`
--

LOCK TABLES `tbl_log_importar_precios` WRITE;
/*!40000 ALTER TABLE `tbl_log_importar_precios` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_log_importar_precios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_log_recepcionproveedores`
--

DROP TABLE IF EXISTS `tbl_log_recepcionproveedores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_log_recepcionproveedores` (
  `id_transaccion` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion del comprobante contable',
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `transaccion_automatica` int(1) NOT NULL DEFAULT '0' COMMENT '0=no 1=si',
  `sw_activa` int(1) NOT NULL,
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL,
  `id_centrocosto` int(10) NOT NULL,
  `id_centronegocio` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `dia` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `mes` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `ano` int(4) NOT NULL DEFAULT '0',
  `fecha` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_transaccion` int(10) NOT NULL COMMENT 'fecha hora de la transaccion contable',
  `estado` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `numero_transaccion` int(10) NOT NULL DEFAULT '0',
  `tipo_transaccion` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'I=ingreso E=egreso T=traspaso',
  `tipo_boucher` char(4) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'ENCV=EmisionNotaCreditoVenta EFV=FacturaVenta  EFC=FacturaCompra PFV=PagoFacturaVenta PFC=PagoFacturaCompra  ENC=EmisionNotaCredito  ENP=EmisionNotacreditoProveedor EBH=EmisionBoletaHonorario ROC=RecepcionOrdenCompra PEN=ParteENtrada PSA=ParteSAlida',
  `folio_documento` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'folio del documento ( boleta venta, boleta honorario, factura )',
  `rut` varchar(12) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'rut de documento contable',
  `centralizar` int(1) NOT NULL DEFAULT '0' COMMENT '1=SI 0=NO ( debe llevar 1 cuando sea factura de compra o de venta )',
  `estado_transaccion` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'A=abierta C=Cerrada N=Nula',
  `debe` int(10) NOT NULL,
  `haber` int(10) NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `folio` (`folio`),
  KEY `mes` (`mes`),
  KEY `ano` (`ano`),
  KEY `numero_transaccion` (`numero_transaccion`),
  KEY `fecha` (`fecha`),
  KEY `estado` (`estado`),
  KEY `sw_activa` (`sw_activa`),
  KEY `time_transaccion` (`time_transaccion`),
  KEY `id_sucursal` (`id_sucursal`,`id_centrocosto`,`id_centronegocio`,`id_proyecto`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_log_recepcionproveedores`
--

LOCK TABLES `tbl_log_recepcionproveedores` WRITE;
/*!40000 ALTER TABLE `tbl_log_recepcionproveedores` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_log_recepcionproveedores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_log_recepcionproveedores_detalle`
--

DROP TABLE IF EXISTS `tbl_log_recepcionproveedores_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_log_recepcionproveedores_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `id_usuario` int(10) NOT NULL COMMENT 'id del usuario creador de la linea 1=Sistema',
  `id_item` int(10) NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `estado` int(1) NOT NULL COMMENT 'Indica al boucher si la linea ha sido finalizada 1=Si 0=No',
  `sw_auditado` int(1) NOT NULL DEFAULT '0',
  `rut` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'Rut Auxiliar de Cliente o Proveedor o Cualquier cuenta con auxiliar',
  `codigo` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT 'ID del proyecto asociado a la linea contable que genero el cargo u/o abono',
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `id` (`id`),
  KEY `folio` (`folio`),
  KEY `id_item` (`id_item`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `codigo` (`codigo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_log_recepcionproveedores_detalle`
--

LOCK TABLES `tbl_log_recepcionproveedores_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_log_recepcionproveedores_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_log_recepcionproveedores_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_logeados`
--

DROP TABLE IF EXISTS `tbl_logeados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_logeados` (
  `id_log` int(10) NOT NULL DEFAULT '0',
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `operacion` varchar(3) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `fecha` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `hora` varchar(8) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `ip` varchar(15) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `so` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nv` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `rx` int(4) NOT NULL DEFAULT '0',
  `ry` int(4) NOT NULL DEFAULT '0',
  `id_sesion` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  KEY `id_log` (`id_log`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_logeados`
--

LOCK TABLES `tbl_logeados` WRITE;
/*!40000 ALTER TABLE `tbl_logeados` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_logeados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_logs`
--

DROP TABLE IF EXISTS `tbl_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_logs` (
  `id_log` int(10) NOT NULL AUTO_INCREMENT,
  `time` int(10) NOT NULL COMMENT 'timestamp log',
  `fecha` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT 'fecha log',
  `hora` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `nombre_usuario` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `usuario` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'nombre de usuario',
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `ip_usuario` varchar(15) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'Direccion IP desde donde efectuo la operacion',
  `operacion` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '' COMMENT 'Documento',
  `folio_operacion` int(10) NOT NULL COMMENT 'folio del documento',
  `accion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` text COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id_log` (`id_log`),
  KEY `id_usuario` (`id_usuario`),
  KEY `folio_operacion` (`folio_operacion`),
  KEY `time` (`time`),
  KEY `fecha` (`fecha`),
  KEY `usuario` (`usuario`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci COMMENT='Registro de los procesos del sistema';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_logs`
--

LOCK TABLES `tbl_logs` WRITE;
/*!40000 ALTER TABLE `tbl_logs` DISABLE KEYS */;
INSERT INTO `tbl_logs` VALUES (1,0,'06/03/2018','12:10:59','Soporte Nivel 2','soporten2@controler.cl',965,'','IT',10001,'Guardar','Guardo Cambios a Item 10001');
/*!40000 ALTER TABLE `tbl_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_mail_inbox`
--

DROP TABLE IF EXISTS `tbl_mail_inbox`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_mail_inbox` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `tipo_archivo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `time_respuesta` int(10) NOT NULL,
  `fecha_respuesta` char(10) COLLATE utf8_spanish_ci NOT NULL,
  `hora_respuesta` char(8) COLLATE utf8_spanish_ci NOT NULL,
  `time_respuesta_merc` int(10) NOT NULL,
  `fecha_respuesta_merc` char(10) COLLATE utf8_spanish_ci NOT NULL,
  `hora_respuesta_merc` char(8) COLLATE utf8_spanish_ci NOT NULL,
  `time_respuesta_com` int(10) NOT NULL,
  `fecha_respuesta_com` char(10) COLLATE utf8_spanish_ci NOT NULL,
  `hora_respuesta_com` char(8) COLLATE utf8_spanish_ci NOT NULL,
  `correo_respuesta` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `time_recepcion` char(22) COLLATE utf8_spanish_ci NOT NULL,
  `doc_id` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `validar` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `rs_emisor` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `time_recibido` int(10) NOT NULL,
  `fecha_recepcion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `hora_recepcion` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `estado` int(1) NOT NULL COMMENT '0=pendiente 1=aprobado 2=rechazado',
  `estado_merc` int(1) NOT NULL,
  `estado_com` int(1) NOT NULL,
  `rut_emisor` varchar(12) COLLATE utf8_spanish_ci NOT NULL,
  `rut_receptor` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `tipo_dte` int(3) NOT NULL,
  `folio_dte` int(10) NOT NULL,
  `fecha_dte` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `neto_afecto` int(10) NOT NULL,
  `neto_exento` int(10) NOT NULL,
  `tasa_iva` int(2) NOT NULL,
  `iva` int(10) NOT NULL,
  `total` int(10) NOT NULL,
  `nombre_carpeta` text COLLATE utf8_spanish_ci NOT NULL,
  `nombre_archivo` text COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `estado_recdte` int(1) NOT NULL,
  `recepcion_sii` char(19) COLLATE utf8_spanish_ci NOT NULL COMMENT 'fecha y hora recepcion dte en el sii',
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `validar` (`validar`),
  KEY `estado` (`estado`),
  KEY `tipo_archivo` (`tipo_archivo`),
  KEY `recepcion_sii` (`recepcion_sii`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_mail_inbox`
--

LOCK TABLES `tbl_mail_inbox` WRITE;
/*!40000 ALTER TABLE `tbl_mail_inbox` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_mail_inbox` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_marcas`
--

DROP TABLE IF EXISTS `tbl_marcas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_marcas` (
  `id_marca` int(10) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT '1=activo 0=inactivo',
  `codigo_marca` char(4) COLLATE utf8_spanish_ci NOT NULL COMMENT '4 caracteres para codigo de marca',
  `nombre` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id_marca` (`id_marca`),
  KEY `codigo_marca` (`codigo_marca`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_marcas`
--

LOCK TABLES `tbl_marcas` WRITE;
/*!40000 ALTER TABLE `tbl_marcas` DISABLE KEYS */;
INSERT INTO `tbl_marcas` VALUES (1,1,'1','GENERICA');
/*!40000 ALTER TABLE `tbl_marcas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_matriculas`
--

DROP TABLE IF EXISTS `tbl_matriculas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_matriculas` (
  `id_matricula` int(10) NOT NULL AUTO_INCREMENT,
  `time_creacion` int(10) NOT NULL,
  `usuario_creacion` int(10) NOT NULL,
  `id_especialidad` int(10) NOT NULL,
  `id_curso` int(10) NOT NULL,
  `tipo_plan` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_matricula` int(10) NOT NULL,
  `fecha_matricula` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_matricula` int(10) NOT NULL,
  `rut_alumno` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `rut_apoderado` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `nombre_alumno` varchar(250) COLLATE utf8_spanish_ci NOT NULL,
  `nombre_apoderado` varchar(250) COLLATE utf8_spanish_ci NOT NULL,
  `valor_curso` int(10) NOT NULL,
  `cantidad_letras` int(10) NOT NULL,
  `cantidad_cuotas` int(10) NOT NULL,
  `id_formapago` int(10) NOT NULL,
  UNIQUE KEY `id_matricula` (`id_matricula`),
  KEY `id_especialidad` (`id_especialidad`,`id_curso`),
  KEY `cantidad_cuotas` (`cantidad_cuotas`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_matriculas`
--

LOCK TABLES `tbl_matriculas` WRITE;
/*!40000 ALTER TABLE `tbl_matriculas` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_matriculas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_mensajes`
--

DROP TABLE IF EXISTS `tbl_mensajes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_mensajes` (
  `folio_mensaje` int(10) NOT NULL AUTO_INCREMENT,
  `fecha_envio` char(10) COLLATE utf8_spanish_ci NOT NULL,
  `hora_envio` char(8) COLLATE utf8_spanish_ci NOT NULL,
  `id_mensaje` int(10) NOT NULL DEFAULT '0',
  `id_remitente` int(10) NOT NULL DEFAULT '0',
  `id_destinatario` int(10) NOT NULL DEFAULT '0',
  `asunto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `comentarios` text COLLATE utf8_spanish_ci NOT NULL,
  `estado` varchar(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT '0=no leido ; 1= leido',
  UNIQUE KEY `folio_mensaje` (`folio_mensaje`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_mensajes`
--

LOCK TABLES `tbl_mensajes` WRITE;
/*!40000 ALTER TABLE `tbl_mensajes` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_mensajes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_menu_nivel1`
--

DROP TABLE IF EXISTS `tbl_menu_nivel1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_menu_nivel1` (
  `id_menu1` int(10) NOT NULL DEFAULT '0',
  `orden` int(10) NOT NULL DEFAULT '0',
  `nombre` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `descripcion` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `sw_accesodirecto` int(1) NOT NULL DEFAULT '0',
  `ventana` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `nivel_0` int(1) NOT NULL DEFAULT '0',
  `nivel_1` int(1) NOT NULL DEFAULT '0',
  `nivel_2` int(1) NOT NULL DEFAULT '0',
  `nivel_3` int(1) NOT NULL DEFAULT '0',
  `nivel_4` int(1) NOT NULL DEFAULT '0',
  `nivel_5` int(1) NOT NULL DEFAULT '0',
  `nivel_6` int(1) NOT NULL DEFAULT '0',
  `nivel_7` int(1) NOT NULL DEFAULT '0',
  `nivel_8` int(1) NOT NULL DEFAULT '0',
  `nivel_9` int(1) NOT NULL DEFAULT '0',
  `nivel_10` int(1) NOT NULL DEFAULT '0',
  `nivel_11` int(1) NOT NULL DEFAULT '0',
  `nivel_12` int(1) NOT NULL DEFAULT '0',
  `nivel_13` int(1) NOT NULL DEFAULT '0',
  `nivel_14` int(1) NOT NULL DEFAULT '0',
  `nivel_15` int(1) NOT NULL DEFAULT '0',
  `nivel_16` int(1) NOT NULL DEFAULT '0',
  `nivel_17` int(1) NOT NULL DEFAULT '0',
  `nivel_18` int(1) NOT NULL DEFAULT '0',
  UNIQUE KEY `id_menu1` (`id_menu1`),
  KEY `orden` (`orden`),
  KEY `sw_accesodirecto` (`sw_accesodirecto`),
  KEY `ventana` (`ventana`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_menu_nivel1`
--

LOCK TABLES `tbl_menu_nivel1` WRITE;
/*!40000 ALTER TABLE `tbl_menu_nivel1` DISABLE KEYS */;
INSERT INTO `tbl_menu_nivel1` VALUES (1217083328,2,'Ventas','Módulo para gestionar; cotizaciones y Notas de venta',0,'_blank',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1217083341,3,'Compras','Modulo para gestionar compras nacionales y extranjeras',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1217083350,7,'Contabilidad','Módulos para sistema contable',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1235272613,5,'Tesorería','Control de Cuentas por pagar y cobrar',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1248752948,17,'Mantenedores','Ingreso y mantención de datos del sistema',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1254503676,6,'Producción','Modulo de Producción',0,'_blank',1,1,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0),(1254627232,4,'Logística','Módulo para control de Inventarios, Bodegas y Rutas',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1254802371,20,'Trabajadores','Módulo de Trabajadores',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1475869816,18,'Configuración','Configuración de Parámetros del Sistema',0,'',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1480387089,19,'Herramientas','Herramientas del Sistema',0,'',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1488323687,8,'Proyectos','0',0,'',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1494707115,1,'CRM','Custon RelationShip Management',0,'',1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1),(1543426475,0,'Transportes','Transportes',0,'principal',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
/*!40000 ALTER TABLE `tbl_menu_nivel1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_menu_nivel2`
--

DROP TABLE IF EXISTS `tbl_menu_nivel2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_menu_nivel2` (
  `id_menu2` int(10) NOT NULL DEFAULT '0',
  `id_menu1` int(10) NOT NULL DEFAULT '0',
  `orden` int(10) NOT NULL DEFAULT '0',
  `nombre` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `descripcion` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `vinculo` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `sw_accesodirecto` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no ( Para que el menu solo sea accesible desde los accesos directos del escritorio virtual',
  `ventana` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `nivel_0` int(1) NOT NULL DEFAULT '0',
  `nivel_1` int(1) NOT NULL DEFAULT '0',
  `nivel_2` int(1) NOT NULL DEFAULT '0',
  `nivel_3` int(1) NOT NULL DEFAULT '0',
  `nivel_4` int(1) NOT NULL DEFAULT '0',
  `nivel_5` int(1) NOT NULL DEFAULT '0',
  `nivel_6` int(1) NOT NULL DEFAULT '0',
  `nivel_7` int(1) NOT NULL DEFAULT '0',
  `nivel_8` int(1) NOT NULL DEFAULT '0',
  `nivel_9` int(1) NOT NULL DEFAULT '0',
  `nivel_10` int(1) NOT NULL DEFAULT '0',
  `nivel_11` int(1) NOT NULL DEFAULT '0',
  `nivel_12` int(1) NOT NULL DEFAULT '0',
  `nivel_13` int(1) NOT NULL DEFAULT '0',
  `nivel_14` int(1) NOT NULL DEFAULT '0',
  `nivel_15` int(1) NOT NULL DEFAULT '0',
  `nivel_16` int(1) NOT NULL DEFAULT '0',
  `nivel_17` int(1) NOT NULL DEFAULT '0',
  `nivel_18` int(1) NOT NULL DEFAULT '0',
  UNIQUE KEY `id_menu2` (`id_menu2`),
  KEY `id_menu1` (`id_menu1`),
  KEY `orden` (`orden`),
  KEY `sw_accesodirecto` (`sw_accesodirecto`),
  KEY `ventana` (`ventana`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_menu_nivel2`
--

LOCK TABLES `tbl_menu_nivel2` WRITE;
/*!40000 ALTER TABLE `tbl_menu_nivel2` DISABLE KEYS */;
INSERT INTO `tbl_menu_nivel2` VALUES (1200688799,20,1,'Gerencia','','0',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1200688810,20,2,'Administración','','0',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1200688829,20,3,'Contabilidad','','0',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1200688839,20,4,'Comercial','','0',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1200688918,20,5,'Logística','','0',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1200688925,20,6,'Informática','','0',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1200689044,4,1,'Nuevo','','0',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1200689052,4,2,'Buscar','','0',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1200689068,4,3,'Listar','','0',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1200689160,8,1,'Asistencia','','0',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1200689168,8,2,'Vacaciones','','0',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1200689175,8,3,'Licencias','','0',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1200689594,8,4,'Permisos','','0',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1200690168,16,1,'Nuevo','','0',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1200690184,16,2,'Listar','','0',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1200690218,16,3,'Buscar','','0',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1200690512,21,1,'Nueva','','0',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1200690517,21,2,'Buscar','','0',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1200690523,21,3,'Listar','','0',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1200690645,18,1,'Nuevo','','0',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1200690658,18,2,'Buscar','','0',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1200690664,18,3,'Listar','','0',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1205862526,1205862513,1,'revizar','asasa','asasavvff',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1205926833,1205862513,2,'prueba','prueba','',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1205933340,1205862513,3,'cuarto','dani','ddddddd',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1205933555,1205862513,4,'tercer nibel','aeeeerrrrr','aaaaaaaaaa',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1205933572,1205862513,5,'tercer nibel','aeeeerrrrr','aaaaaaaaaa',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1209392591,0,1,'Compras','Registrar todas las compras de mercaderias','inventario/listar_compras_pendientes.php',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1209394445,0,2,'Por Inventariar','Ordenes de compra por ingresar al inventario','ordenescompra/listar_por_inventariar.php',0,'_blank',1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1254623883,1248752948,13,'Tablas','0','',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1254626802,1248752948,8,'Accesos','0','',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1257093413,1217083350,2,'Informes','Informes Financieros, Balances y Estados de Resultados','',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1262117700,1248752948,5,'Sistema','0','',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1265650961,1248752948,7,'Licencia de Uso','0','0',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1266855320,1217083341,2,'Informes','0','0',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1267494556,1254627232,2,'Informes','Informes de Inventarios','',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1267495504,1254802371,4,'Mantención','0','0',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1271996172,1235272613,4,'Mantención','0','0',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1271996457,1217083328,4,'Mantención','Mantención de datos de Venta','',0,'_blank',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1271996526,1217083341,4,'Mantención','0','0',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1271996626,1254627232,4,'Mantención','0','0',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1271997068,1254503676,4,'Mantención','0','0',0,'_blank',1,1,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0),(1273212458,1217083350,4,'Mantención','0','0',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1304559340,1217083350,3,'Herramientas','0','0',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1307817460,1217083328,3,'Herramientas','0','0',0,'_blank',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1308173358,1217083341,3,'Herramientas','0','0',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1308880272,1254503676,1,'Documentos','0','0',0,'_blank',1,1,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0),(1309491171,1217083328,1,'Documentos','0','0',0,'_blank',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1310872016,1217083341,1,'Documentos','0','0',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1312610251,1254627232,1,'Documentos','0','0',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1312610681,1217083350,1,'Documentos','0','0',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1319257943,1248752948,5,'Catalogo','Catalogo de Productos y Servicios que se Compran y/o Venden','',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1319259143,1217083328,2,'Informes','0','0',0,'',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1319260709,1235272613,2,'Informes','0','0',0,'',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1370827269,1248752948,7,'Herramientas','0','0',0,'',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1450182789,1248752948,8,'SII','0','0',0,'',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466561982,1254627232,4,'Herramientas','0','0',0,'',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466562395,1235272613,3,'Documentos','0','0',0,'',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466562406,1235272613,4,'Herramientas','0','0',0,'',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466564510,1254503676,3,'Herramientas','0','0',0,'',1,1,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0),(1466573526,0,2,'Herramientas','0','0',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466573534,0,3,'Documentos','0','0',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466573543,1254802371,4,'Informes','0','0',0,'',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1477772021,1248752948,9,'Configuración','0','0',0,'',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1480014196,1475869816,1,'Herramientas','0','0',0,'',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1480387153,1480387089,1,'Enviar Archivos','0','0',0,'',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1481842634,0,2,'Validar Xml','Validar Xml Libro','',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1488323707,1488323687,1,'Informes','0','0',0,'',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1488323748,1488323687,2,'Mantención','0','0',0,'',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1488323760,0,3,'Documentos','0','0',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1488323772,0,4,'Herramientas','0','0',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1494707489,1494707115,3,'Herramientas','0','0',0,'',1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1),(1494707505,1494707115,4,'Mantención','0','0',0,'',1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1),(1501339372,1248752948,10,'Indicadores','Indicadores Económicos','0',0,'',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1543426523,1543426475,0,'Documentos','Documentos','',0,'principal',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
/*!40000 ALTER TABLE `tbl_menu_nivel2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_menu_nivel3`
--

DROP TABLE IF EXISTS `tbl_menu_nivel3`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_menu_nivel3` (
  `id_menu3` int(10) NOT NULL DEFAULT '0',
  `id_menu2` int(10) NOT NULL DEFAULT '0',
  `id_menu1` int(10) NOT NULL DEFAULT '0',
  `orden` int(10) NOT NULL DEFAULT '0',
  `nombre` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `descripcion` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `vinculo` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `sw_accesodirecto` int(1) NOT NULL DEFAULT '0',
  `ventana` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT 'principal',
  `nivel_0` int(1) NOT NULL DEFAULT '0',
  `nivel_1` int(1) NOT NULL DEFAULT '0',
  `nivel_2` int(1) NOT NULL DEFAULT '0',
  `nivel_3` int(1) NOT NULL DEFAULT '0',
  `nivel_4` int(1) NOT NULL DEFAULT '0',
  `nivel_5` int(1) NOT NULL DEFAULT '0',
  `nivel_6` int(1) NOT NULL DEFAULT '0',
  `nivel_7` int(1) NOT NULL DEFAULT '0',
  `nivel_8` int(1) NOT NULL DEFAULT '0',
  `nivel_9` int(1) NOT NULL DEFAULT '0',
  `nivel_10` int(1) NOT NULL DEFAULT '0',
  `nivel_11` int(1) NOT NULL DEFAULT '0',
  `nivel_12` int(1) NOT NULL DEFAULT '0',
  `nivel_13` int(1) NOT NULL DEFAULT '0',
  `nivel_14` int(1) NOT NULL DEFAULT '0',
  `nivel_15` int(1) NOT NULL DEFAULT '0',
  `nivel_16` int(1) NOT NULL DEFAULT '0',
  `nivel_17` int(1) NOT NULL DEFAULT '0',
  `nivel_18` int(1) NOT NULL DEFAULT '0',
  UNIQUE KEY `id_menu3` (`id_menu3`),
  KEY `id_menu2` (`id_menu2`),
  KEY `id_menu1` (`id_menu1`),
  KEY `orden` (`orden`),
  KEY `sw_accesodirecto` (`sw_accesodirecto`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_menu_nivel3`
--

LOCK TABLES `tbl_menu_nivel3` WRITE;
/*!40000 ALTER TABLE `tbl_menu_nivel3` DISABLE KEYS */;
INSERT INTO `tbl_menu_nivel3` VALUES (0,1309491171,1217083328,1,'Boletos Transporte','Permite Crear Boletos para Servicio de Transportes','ventas_documentos_boletos',0,'principal',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1254626815,1254626802,1248752948,8,'Usuarios','Usuarios','mantencion_usuarios/index.php',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1254626823,1254626802,1248752948,8,'Niveles','Niveles de Acceso','mantencion_nivelesusuarios/index.php',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1254626829,1254626802,1248752948,1,'Privilegios','Privilegios de Niveles','mantencion_privilegios/index.php',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1257093446,1257093413,1217083350,8,'Balance Tributario','ajaxpagebalancetributarioLinkCheck','contabilidad_balancetributario/index.php',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1265650977,1265650961,1248752948,8,'Sucursales','Admistrar sucursales de la Empresa','mantencion_licencia_sucursales/index.php',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1267494620,1267494556,1254627232,5,'Inventario por Bodega','Informe de Inventario por Bodegas y Zonas','logistica_inventarioporbodega/index.php',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1271995525,1267495504,1254802371,6,'Trabajadores','','remuneraciones_mantencion_trabajadores/',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1271996185,1271996172,1235272613,5,'Bancos','Mantenci?n de Bancos','tesoreria_mantencion_bancos/index.php',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1271996195,1271996172,1235272613,5,'Cajas','Mantenci?n de Cajas','tesoreria_mantencion_cajas/index.php',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1271996654,1271996626,1254627232,4,'Bodegas','Mantenci?n de Bodegas','logistica_bodegas/index.php',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1271996748,1271996457,1217083328,1,'Clientes','Clientes','ventas_mantencion_clientes/',0,'principal',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1271996790,1271996526,1217083341,2,'Proveedores','','compras_mantencion_proveedores/',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1273212526,1273212458,1217083350,7,'Plan de Cuentas','Mantenedor de Plan de Cuentas','contabilidad_mantencion_plandecuentas/crear.php',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1300168577,1265650961,1248752948,8,'Empresa','Datos de Empresa con Licencia de Uso','mantencion_licencia_empresa',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1301175354,1262117700,1248752948,1,'Configuración Cuentas','Permite indicar las cuentas contables asociadas a los documentos tributarios','mantencion_configuracion_cuentas/index.php',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1307817494,1307817460,1217083328,1,'Envio Dte Masivo','Enviar Dte por Lotes al SII','ventas_herramientas_dtemasivo/',0,'_blank',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1309491233,1309491171,0,8,'Notas de Credito','Notas de Credito Clientes','ventas_documentos_notascredito/',1,'_blank',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1311351787,1310872016,0,2,'Notas de Credito','Notas de Credito','compras_documentos_notascredito/',1,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1312610283,1312610251,1254627232,1,'Parte de Entrada','Parte de Entrada','logistica_partesentrada/index.php',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1312610333,1312610251,1254627232,2,'Parte de Salida','Parte de Salida','logistica_partessalida/index.php',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1312610702,1312610681,1217083350,1,'Voucher','Voucher','contabilidad_documentos_voucher/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1313787107,1254623883,1248752948,1,'Localidades','Localidades','mantencion_tablas_comunas/index.php',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1317672714,1312610251,1254627232,3,'Parte de Traspaso','Traspaso entre Bodegas','logistica_partestraspaso/index.php',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1319203445,1254623883,1248752948,1,'Paises','Maestro de Paises','mantencion_tablas_paises/index.php',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1319257995,1319257943,1248752948,1,'Items','Mantencion de Articulos y/o Servicios','ventas_productos/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1319267612,1319257943,1248752948,8,'Proyectos','Mantencion de Proyectos','ventas_proyectos/index.php',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1319267740,1319257943,1248752948,8,'Marcas','Mantencion de Marcas','tablas_marcas/index.php',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1319267819,1271996172,1235272613,5,'Medios de Pago','Mantencion de Medios de Pago','tesoreria_mantencion_mediospago/',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1319267980,1319260709,1235272613,5,'Cuentas Corrientes','Informe de Cuentas Corrientes','tesoreria_informe_cuentascorrientes/index.php',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1319268945,1257093413,1217083350,7,'Libro Honorarios','Libro Honorarios','contabilidad_librodehonorarios/index.php',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1319268992,1257093413,1217083350,7,'Libro Diario','Libro Diario','contabilidad_informe_librodiario/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1319269095,1257093413,1217083350,7,'Libro Mayor','Libro Mayor','contabilidad_informe_libromayor/index.php',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1319270892,1257093413,1217083350,7,'Libro Existencias','Libro Existencias','contabilidad_libroexistencias/index.php',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1322055056,1309491171,0,11,'Notas de Debito','Notas de Debito','ventas_documentos_notasdebito/',1,'_blank',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1325167856,1267494556,1254627232,4,'Inventario Lote/Serie','Inventario detallado por Item, Lote y Serie','logistica_informe_inventariodetallado/index.php',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1325562019,1273212458,1217083350,7,'Documentos','Mantenedor de documentos contables','contabilidad_mantencion_documentos/index.php',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1326823077,1308880272,1254503676,3,'Orden Produccion','Orden Produccion','produccion_documentos_ordenesproduccion/index.php',0,'_blank',1,1,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0),(1329394989,1271997068,1254503676,3,'Procesos','Mantenedor de Procesos Productivos','produccion_mantencion_procesos/',0,'principal',1,1,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0),(1330120898,1254623883,1248752948,8,'Dias Feriados','Dias Feriados para control de asistencia','mantencion_tablas_feriados/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1347290696,1319259143,1217083328,2,'Libro de Ventas','Libro de Ventas','ventas_informes_libroventas/',1,'principal',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1352082195,1304559340,1217083350,7,'Centralizar','Contabilizar por Lotes / Grupos','contabilidad_herramientas_contabilizar/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1360466365,1310872016,1217083341,2,'Facturas de Compra','Facturas de Compra (Proveedores)','compras_documentos_facturas/',1,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1372891496,1310872016,1217083341,2,'Notas de Debito','Notas de Debito Proveedor','compras_documentos_notasdebito/',1,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1382043066,1309491171,0,4,'Facturas de Venta','Facturas de Venta','ventas_documentos_facturas/',1,'_blank',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1387052917,1254626802,1248752948,8,'Menu Sistema','Administrar Menú Principal del Sistema','menu_sistema/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1424525517,1266855320,1217083341,1,'Libro de Compras','Libro de Compras','compras_informes_librocompras/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1436456823,1308173358,0,1,'Recepcion DTE','Documentos Recibidos de Proveedores','compras_herramientas_documentosrecibidos/',1,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1445649597,1271996457,1217083328,1,'Centros Negocio','0','ventas_mantencion_centrosnegocio/',0,'principal',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1450038974,1309491171,0,3,'Guia de Venta','Guia de Venta','ventas_documentos_guiadespacho/',1,'_blank',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1450182880,1450182789,1248752948,8,'Certificado Digital','0','contabilidad_mantencion_certificados/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1452831950,1319259143,1217083328,2,'Libro de Guias','Libro de Guias','ventas_informes_libroguias/',0,'_blank',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1457776435,1309491171,0,2,'Nota de Venta','Nota de venta','ventas_documentos_notasdepedido/',1,'_blank',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1458228681,1309491171,0,1,'Cotizaciones','Cotizaciones para Clientes','ventas_documentos_cotizaciones/',1,'_blank',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1464424324,1307817460,1217083328,1,'Punto de Venta','Terminal de Punto de Venta al meson','ventas_herramientas_puntoventa/',1,'_blank',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1466559292,1271996526,1217083341,2,'Origenes OC','Origenes OC','compras_mantencion_origenesoc/',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466559447,1308173358,1217083341,2,'Importar Facturas','Importar Facturas','compras_herramientas_importarfacturas/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466559535,1308173358,1217083341,2,'Importar N.Credito','Importar N.Credito','compras_herramientas_importarnotascredito/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466559765,1271996526,1217083341,2,'Centros de Costo','Centros de Costo','compras_mantencion_centroscosto/',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466560142,1310872016,1217083341,3,'Orden de Compra','Orden de Compra','compras_documentos_ordenescompra/',1,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466561502,1271996457,1217083328,1,'Origen Cotizaciones','Origen Cotizaciones','ventas_mantencion_origencotizaciones/',0,'principal',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1466562024,1466561982,1254627232,4,'Actualizar Criticos','Actualizar parametros de stock Critico','logistica_herramientas_actualizarcriticos/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466562149,1267494556,1254627232,4,'Informe Stocks','Informe Stocks','logistica_informe_stocks/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466562222,1267494556,1254627232,4,'Inventario Categorias','Inventario Categorias','logistica_informe_inventario/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466562469,1466562395,1235272613,5,'Cartola Bancaria','Cartola Bancaria','tesoreria_documentos_cartolabancaria/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466562905,1319260709,1235272613,5,'Conciliacion Bancaria','Conciliacion Bancaria','tesoreria_informe_conciliacionbancaria/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466563046,1319260709,1235272613,5,'Flujo','0','tesoreria_informe_flujo/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466563675,1304559340,1217083350,7,'Importar Vouchers','Importar Vouchers','contabilidad_herramientas_importarvouchers/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466563858,1257093413,1217083350,7,'Comparativo','Comparativo','contabilidad_informes_comparativo/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466563886,1257093413,1217083350,7,'Estado Resultados','Estado Resultados','contabilidad_informes_estadoresultado/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466564010,1257093413,1217083350,7,'Balance Clasificado','Balance Clasificado','contabilidad_informes_balanceclasificado/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466564596,1466564510,1254503676,3,'Importar Recetas','Importar Recetas','produccion_herramientas_importarrecetas/',0,'_blank',1,1,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0),(1466564627,1466564510,1254503676,3,'Exportar Recetas','Exportar Recetas','produccion_herramientas_exportarrecetas/',0,'_blank',1,1,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0),(1466565007,1271997068,1254503676,3,'Recetas','Recetas','produccion_recetas/',0,'_blank',1,1,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0),(1466571980,1304559340,1217083350,7,'Apertura Contable','Apertura Contable','contabilidad_herramientas_apertura/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466572439,1304559340,1217083350,7,'Foliador Hojas','Foliador Hojas','contabilidad_herramientas_foliadorhojas/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466572698,1273212458,0,7,'Impuestos','Permite definir y modificar Impuestos especificos','contabilidad_mantencion_impuestos/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466573006,1304559340,1217083350,7,'Control Periodos','Control Periodos','contabilidad_herramientas_periodolibros/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466573773,1466573543,1254802371,6,'Certificado Honorarios','Certificado Honorarios','remuneraciones_informes_certificadohonorarios/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466574854,1466573526,1254802371,6,'Obtener Fichajes','Obtener Fichajes de Asistencia Laboral','remuneraciones_herramientas_obtenerfichajes/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1466575550,1466573526,1254802371,6,'Importar Honorarios','Importar Honorarios','remuneraciones_herramientas_importarhonorarios/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1469894080,1307817460,1217083328,1,'Guias Masivas','Crear Guias por Lotes','ventas_herramientas_guiasmasivas/',0,'_blank',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1470458393,1309491171,1217083328,5,'Boleta de Venta','Modulo Boletas de Venta','ventas_documentos_boletas/',1,'_blank',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1470792515,1310872016,0,2,'Guia de Proveedor','Guia de Proveedor','compras_documentos_guiasdespacho/',1,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1470796875,1319259143,1217083328,1,'Resumen Diario','Resumen Diario','ventas_informes_resumendiario/',0,'_blank',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1472570956,1309491171,0,6,'Boletas Transkbank','Boletas Transkbank','ventas_documentos_boletastransbank',0,'_blank',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1473555509,1271996172,1235272613,5,'Condiciones Pago','Condiciones de Pago ( Ej. 50% anticipado saldo a 30 d?as )','tesoreria_mantencion_condicionespago/',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1475869683,1466562406,1235272613,5,'Banco Chile','dfdfgfd','http://www.bancochile.cl',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1476108440,1309491171,0,7,'Boletas Mensuales','0','ventas_documentos_boletasmensuales/',0,'_blank',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1477772062,1477772021,1248752948,1,'Impresoras','Configuración de Impresoras','mantenedores_configuracion_impresora/',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1478449996,1310872016,1217083341,2,'Requisiciones','0','compras_documentos_requisiciones/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1479150098,1307817460,1217083328,1,'Importar Items','0','ventas_herramientas_actualizarproductos/',0,'_blank',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1479404997,1271996457,1217083328,1,'Lista Precios','Lista Precios','ventas_mantencion_listaprecios',0,'principal',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1479588533,1307817460,1217083328,1,'Reporte Visitas','Reporte Visitas','ventas_herramientas_reportevisitas/',0,'principal',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1479846298,1271996457,1217083328,5,'Clientes Clases','Clientes Clases','ventas_mantencion_clientesclases',0,'principal',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1479847090,1271996457,1217083328,6,'Clientes Tipos','Clientes Tipos','ventas_mantencion_clientestipos',0,'principal',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1479847518,1271996526,1217083341,2,'Importar Proveedores','0','compras_mantencion_proveedoresimportar',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1480106925,1271996626,1254627232,2,'Rutas','0','logistica_mantencion_rutas/',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1480106968,1271996626,1254627232,3,'Vehículos','0','logistica_mantencion_vehiculos/',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1480359951,1319259143,1217083328,1,'Facturas por vendedor','0','ventas_informes_porvendedor/',0,'_blank',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1480387237,1480387153,1480387089,1,'Enviar DTE','Enviar DTE','sdk_herramientas_enviardte/',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1480711027,1271996626,1254627232,4,'Zonas bodegas','0','logistica_mantencion_zonasbodega/',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1480822945,1307817460,1217083328,8,'Facturar Rutas','Facturación de Rutas','ventas_herramientas_facturacionrutas/',0,'principal',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1481842873,1481842634,1480387089,10,'Validar Xml Libro','Validar Xml Libro Compra / Venta','sdk_herramientas_validarxmllibro/',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1482767673,1319259143,1217083328,1,'Comisiones Vendedor','Comisiones Vendedor','ventas_informes_comisiones/',0,'principal',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1482866844,1466573534,1254802371,2,'Liquidaciones','0','remuneraciones_documentos_liquidaciones/',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1483787551,1466561982,1254627232,4,'Capturar Inventario Rpx','Capturar Inventario Rpx','logistica_herramientas_capturarinventariorpx/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1484581510,1466573526,1254802371,6,'Generar Liquidaciones','0','remuneraciones_herramientas_generarliquidaciones',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1486842659,1450182789,1248752948,8,'Timbraje de Folios','Mantenedor de Timbraje de Folios SII','mantencion_sii_timbrajefolios/',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1487683889,1257093413,1217083350,7,'Flujo financiero','0','contabilidad_informes_flujofinancieros',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1488323855,1488323748,1488323687,1,'Proyectos','Mantenedor de Proyectos','ventas_mantencion_proyectos/',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1488323953,1488323707,1488323687,1,'Informe Proyectos','Informe de Proyectos','proyectos_informes_proyectos/',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1488729386,1307817460,1217083328,9,'Consumo Folios','Permite Generar el Archivo de Consumo de Folios de Boletas Elec. y Enviarlo al SII','ventas_herramientas_consumofolios/',0,'principal',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1490268838,1319259143,1217083328,11,'Libro Boletas','Libro de Boletas Electronicas','ventas_informes_libroboletas/',0,'principal',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1490995728,1307817460,1217083328,10,'Importar Ventas','Importar Documentos de Venta','ventas_herramientas_importarventas/',0,'principal',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1490995729,1307817460,1217083328,11,'Estados DTE','Estado Documentos Electronicos','ventas_herramientas_estadodte/',0,'_blank',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1492192555,1307817460,1217083328,1,'Peso Unitario','Calcular el Peso Unitario','ventas_herramientas_pesounitario/',0,'_blank',1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1492362464,1466562406,1235272613,4,'Cobranza Clientes','Cobranza Clientes','tesoreria_herramientas_cobranza/',0,'principal',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1494707608,1494707505,1494707115,1,'Prospectos','Crm Maestro de Prospectos y/o Posibilidades de Negocio','crm_mantencion_prospectos',0,'principal',1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1),(1494913851,1466573526,1254802371,20,'Ingresar Fichajes','Ingresar Fichajes Manualmente','remuneraciones_herramientas_ingresarfichajes/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1495321746,1257093413,1217083350,7,'Cuentas Corrientes','Informe de Movimientos por Auxiliar','tesoreria_informe_cuentascorrientes/',1,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1498107428,1310872016,1217083341,3,'Boleta Honorarios','Boletas de Honorarios','remuneraciones_documentos_boletahonorarios/',0,'_blank',1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1499285009,1494707489,0,3,'Tickets Soporte','Permite la revision y administracion de tickets de soporte','crm_herramientas_soporte/',0,'principal',1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1),(1500667547,1494707505,1494707115,1,'Estados Ticket','Estados Ticket','crm_mantenedores_estadosticket/',0,'principal',1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1),(1501390474,1271996626,1254627232,4,'Tipos Parte Salida','Maestro de Tipos Parte Salida','logistica_mantencion_tipospartesalida/',0,'principal',0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1502510933,1319259143,1217083328,1,'Ranking Productos','Informe Ranking de Productos con Graficos Estadisticos','ventas_informes_rankingproductos/',0,'principal',0,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1502511715,1466562395,1235272613,1,'Rinde Gastos','Modulo para Rendir Fondos','tesoreria_documentos_rendiciones/',0,'principal',0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1502977693,1271997068,1254503676,1,'Estados Produccion','Mantenedor de Estados de una Produccion','produccion_mantencion_estadosproduccion/',0,'principal',0,1,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0),(1503810441,1319259143,1217083328,1,'Resumen Vendedor','Resumen de Ventas Vendedor en Rango Seleccionado','ventas_informes_resumenventas/',1,'principal',0,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1505578098,1271996457,0,1,'Licitaciones','Mantenedor de Licitaciones','ventas_mantencion_licitaciones/',0,'principal',0,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1507427182,1307817460,1217083328,1,'Importar Clientes','Importar Clientes Masivamente','ventas_mantencion_clientesimportar/',0,'_blank',0,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1512675713,1271996457,1217083328,1,'Rutas Transporte','Permite definir las rutas de transporte para cada Cliente','ventas_mantencion_rutastransporte',0,'principal',0,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1),(1520348778,1319257943,1248752948,1,'Unidades de Medida','Mantenedor que permite gestionar las unidades de medida que se le asignan a los Productos','mantenedores_catalogo_unidadesmedida',0,'principal',0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1528490992,1319257943,1248752948,1,'Items Propiedades','Crear Items a partir de las propiedades','ventas_productosmasivo/',0,'principal',0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1528491029,1319257943,1248752948,1,'Propiedades','Mantencion de Propiedades de Articulos','ventas_productos_propiedades/index.php',0,'principal',0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1543352808,1480014196,1475869816,0,'Dashboard','dashboard','mantenedores_herramientas_dashboard/',0,'principal',0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1543426320,1319259143,1217083328,0,'Detalle Ventas Clientes','Items vendidos en un periodo','ventas_informes_ventasclientes',0,'principal',0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1543426357,1319259143,1217083328,0,'Ventas Pendientes','Documentos pendientes por vendedor o cliente','ventas_informes_ventaspendientes',0,'principal',0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1543427169,1543426523,1543426475,0,'Boletos','Permite registrar servicios de transportes por medio de boletos','transportes_documentos_boletos',0,'principal',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1568662980,1271996457,1217083328,0,'Listas de precios','Mantenedor para las listas de precios','ventas_mantencion_lista_de_precios/',0,'principal',1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1569435372,1307817460,1217083328,0,'Importar listas de precios','Permite gestionar listas de precios','ventas_herramientas_actualizar_listas_de_precios/',0,'principal',1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
/*!40000 ALTER TABLE `tbl_menu_nivel3` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_motivos_gastos_vehiculos`
--

DROP TABLE IF EXISTS `tbl_motivos_gastos_vehiculos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_motivos_gastos_vehiculos` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(50) NOT NULL,
  `sw_dte` tinyint(1) NOT NULL,
  `estado` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_motivos_gastos_vehiculos`
--

LOCK TABLES `tbl_motivos_gastos_vehiculos` WRITE;
/*!40000 ALTER TABLE `tbl_motivos_gastos_vehiculos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_motivos_gastos_vehiculos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_motivosanulacion`
--

DROP TABLE IF EXISTS `tbl_motivosanulacion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_motivosanulacion` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` int(11) NOT NULL,
  `motivo` varchar(70) COLLATE utf8_spanish_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_motivosanulacion`
--

LOCK TABLES `tbl_motivosanulacion` WRITE;
/*!40000 ALTER TABLE `tbl_motivosanulacion` DISABLE KEYS */;
INSERT INTO `tbl_motivosanulacion` VALUES (1,1,'ERROR DIGITACION');
/*!40000 ALTER TABLE `tbl_motivosanulacion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_niveles`
--

DROP TABLE IF EXISTS `tbl_niveles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_niveles` (
  `id_nivel` int(10) NOT NULL DEFAULT '0',
  `cargo` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `departamento` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `id_nivel` (`id_nivel`),
  KEY `descripcion` (`departamento`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_niveles`
--

LOCK TABLES `tbl_niveles` WRITE;
/*!40000 ALTER TABLE `tbl_niveles` DISABLE KEYS */;
INSERT INTO `tbl_niveles` VALUES (0,'Administrador del Sistema','Informática'),(1,'Gerencia','Operaciones'),(2,'Administracion','Administracion'),(3,'Ventas','Ventas'),(4,'Desarrollo','Desarrollo'),(5,'Certificaciones','Producción'),(6,'.','.'),(7,'Soporte Nivel 1','.'),(8,'Hotel','.'),(9,'Control Trafico','.'),(10,'Conductor','.'),(11,'.','.'),(12,'.','.'),(13,'.','.'),(14,'.','.'),(15,'.','.'),(16,'.','.'),(17,'.','.'),(18,'Digitadores','Digitacion');
/*!40000 ALTER TABLE `tbl_niveles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_notadebitovta`
--

DROP TABLE IF EXISTS `tbl_notadebitovta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_notadebitovta` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_registro` int(10) NOT NULL,
  `id_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'almacena el timestamp unix del momento cuando se puso listo al pedido',
  `asiento_apertura` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `facturada` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `contabilizada` int(1) NOT NULL DEFAULT '0' COMMENT 'indica si la emision de la factura ya fue contabilizada 1=si 0=no',
  `cancelada` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'VA=venta anticipada CC=cuenta corriente',
  `origen_factura` int(1) NOT NULL COMMENT '0=facturadirecta 1=facturaguias 2=facturapedidos',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'EP=EnProceso GR=grabada PR=Procesada AN=Anulada',
  `nivel_impresion` int(1) NOT NULL DEFAULT '0' COMMENT '0=detallado 1=resumido por categoria 2=resumido por subcategorias',
  `tipo_facturacion` int(1) NOT NULL DEFAULT '0' COMMENT '0=facturacion desde notas de venta 1=FACTURACION DESDE GUIAS DE DESPACHO',
  `anulada` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `sw_bloqueo` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `ano_control` int(4) NOT NULL,
  `numero_control` int(10) NOT NULL,
  `fecha_anulacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_cotizacion` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `folio_notaventa` int(10) NOT NULL DEFAULT '0',
  `folio_despacho` int(10) NOT NULL DEFAULT '0',
  `folio_ruta` int(10) NOT NULL DEFAULT '0',
  `folio_guiadespacho` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_ordencompra` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_recepcion` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'codigo de recepcion que entrega el cliente por ej. falabella codigo IR = Ingreso Recepción nº xxx',
  `id_vendedor` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'rut del empleado vendedor',
  `id_sucursal_venta` int(10) NOT NULL COMMENT 'id de la sucursal donde se emitio la factura',
  `id_bodega_despacho` int(10) NOT NULL COMMENT 'id de la bodega de donde se rebajaran los articulos vendidos',
  `nombre_sucursal_venta` varchar(255) COLLATE utf8_spanish_ci NOT NULL COMMENT 'nombre de la sucursal a la cual esta asociada la factura de venta',
  `exenta` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `electronica` int(1) NOT NULL DEFAULT '0',
  `tipo_factura` int(1) NOT NULL DEFAULT '1' COMMENT '1=manual afecta 2=electronica afecta 3=manual exenta 4=electronica exenta',
  `id_relacion` int(10) NOT NULL DEFAULT '0',
  `tipo_cliente` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'E=Empresa U=Universidad',
  `proyecto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT '0=Sin proyecto',
  `id_empresa` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL DEFAULT '0',
  `id_laboratorio` int(10) NOT NULL DEFAULT '0',
  `id_investigador` int(10) NOT NULL DEFAULT '0',
  `id_contacto` int(10) NOT NULL DEFAULT '0',
  `id_despacho` int(10) NOT NULL DEFAULT '0',
  `id_region` int(10) NOT NULL DEFAULT '0',
  `id_ciudad` int(10) NOT NULL DEFAULT '0',
  `id_comuna` int(10) NOT NULL DEFAULT '0',
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `razon_social` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_fantasia` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `giro` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefonos` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `region` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `ciudad` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `comuna` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_contacto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_investigador` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `atencion_facturacion` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_contacto` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_investigador` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_facturacion` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_proyecto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_facturacion` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp con fecha y hora de emision de la factura',
  `fecha_vencimiento` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_vencimiento` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp con fecha y hora de vencimiento',
  `via_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion_despacho` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_despacho` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `atencion_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `cancela_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `subtotal` int(10) NOT NULL DEFAULT '0',
  `descuento_porc` int(2) NOT NULL DEFAULT '0' COMMENT 'D',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0',
  `neto` int(10) NOT NULL DEFAULT '0',
  `iva` int(10) NOT NULL DEFAULT '0',
  `bruto` int(10) NOT NULL DEFAULT '0',
  `saldo_pendiente` int(10) NOT NULL DEFAULT '0',
  `saldo_va` int(10) NOT NULL DEFAULT '0' COMMENT 'indica el saldo disponible de las facturas va',
  `bruto_palabras` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'Total bruto escrito en palabras',
  `id_condiciones_venta` int(10) NOT NULL DEFAULT '0',
  `condiciones_venta` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT '1=Efectivo 2=Documentado 3=10 Dias 4=15 Dias 5=30 Dias 6=45 Dias 7=60 Dias 8=30/60 Dias 9=30/60/90 Dias',
  `observaciones` text COLLATE utf8_spanish_ci NOT NULL,
  `id_usuario_anulacion` int(10) NOT NULL DEFAULT '0',
  `id_anulacion` int(10) NOT NULL DEFAULT '0',
  `motivo_anulacion` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_usuario_modifico` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario que realizo la ultima modificacion',
  `id_modificacion` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp de la ultima modificacion',
  UNIQUE KEY `folio_factura` (`folio_factura`),
  UNIQUE KEY `id` (`id`),
  KEY `fecha_facturacion` (`fecha_facturacion`),
  KEY `id_factura` (`id_factura`),
  KEY `rut` (`rut`),
  KEY `id_relacion` (`id_relacion`),
  KEY `estado` (`estado`),
  KEY `id_sucursal_venta` (`id_sucursal_venta`),
  KEY `nombre_sucursal_venta` (`nombre_sucursal_venta`),
  KEY `mes_control` (`mes_control`,`ano_control`,`numero_control`),
  KEY `tipo_factura` (`tipo_factura`),
  KEY `codigo_recepcion` (`codigo_recepcion`),
  KEY `id_bodega_despacho` (`id_bodega_despacho`),
  KEY `nivel_impresion` (`nivel_impresion`),
  KEY `origen_factura` (`origen_factura`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_notadebitovta`
--

LOCK TABLES `tbl_notadebitovta` WRITE;
/*!40000 ALTER TABLE `tbl_notadebitovta` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_notadebitovta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_notadebitovta_detalle`
--

DROP TABLE IF EXISTS `tbl_notadebitovta_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_notadebitovta_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_bodega_despacho` int(10) NOT NULL,
  `folio` int(10) NOT NULL COMMENT 'corresponde al id del encabezado',
  `folio_factura` int(10) NOT NULL DEFAULT '0',
  `origen_factura` int(1) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'EP=EnProceso GR=grabada PR=Procesada AN=Anulada',
  `folio_guiadespacho` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `anulada` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT '0=no 1=si',
  `id_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'id de la factura indica cuando se puso listo al pedido en bodega',
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `ano_control` int(4) NOT NULL,
  `numero_control` int(10) NOT NULL,
  `tipo_factura` int(1) NOT NULL DEFAULT '0' COMMENT '0=factura normal 1=facturacion anticipada',
  `id_facturacion` int(10) NOT NULL DEFAULT '0' COMMENT 'Solo para ordenamientos de fecha',
  `id_item` int(10) NOT NULL DEFAULT '0',
  `id_vendedor` int(10) NOT NULL DEFAULT '0',
  `id_relacion` int(10) NOT NULL DEFAULT '0',
  `rut_cliente` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_producto` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_sku` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_ean` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_alt` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_local` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_categoria` int(10) NOT NULL,
  `id_subcategoria` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'P=producto S=servicio C=cuenta',
  `id_activofijo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `pmp` decimal(12,2) NOT NULL DEFAULT '0.00',
  `cpp` int(10) NOT NULL DEFAULT '0',
  `precio_referencial` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'Cuanto costaba al momento de hacer la nota de venta',
  `precio_venta` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'En cuanto se vendio (con descuentos individual aplicado)',
  `precio_final_venta` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'precio de venta con descuento lineal y global aplicado',
  `cantidad` int(10) NOT NULL DEFAULT '0',
  `cantidad_devuelta` int(10) NOT NULL DEFAULT '0' COMMENT 'cantidad de unidades devueltas por medio de una nota de credito',
  `subtotal` int(10) NOT NULL DEFAULT '0',
  `descuento_porc` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT 'porcentaje de descuento',
  `descuento_porc_global` decimal(5,2) NOT NULL DEFAULT '0.00',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0',
  `subtotal_neto` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal con descuento aplicado',
  `subtotal_final` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal con descuento lineal y global aplicado ( SOLO PARA COMISIONES - ESTE ES EL VALOR REAL DE VENTA )',
  `comision_porcentaje` decimal(5,2) NOT NULL DEFAULT '0.00',
  `comision_pesos` int(10) NOT NULL DEFAULT '0',
  `comision_porcentaje_extra` decimal(5,2) NOT NULL DEFAULT '0.00',
  `comision_pesos_extra` int(10) NOT NULL DEFAULT '0',
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `sw_exento` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `folio_factura` (`folio_factura`),
  KEY `id_activofijo` (`id_activofijo`),
  KEY `pmp` (`pmp`),
  KEY `id_proyecto` (`id_proyecto`),
  KEY `estado` (`estado`),
  KEY `mes_control` (`mes_control`,`ano_control`,`numero_control`),
  KEY `folio` (`folio`),
  KEY `id_bodega_despacho` (`id_bodega_despacho`),
  KEY `id_categoria` (`id_categoria`),
  KEY `id_subcategoria` (`id_subcategoria`),
  KEY `codigo_sku` (`codigo_sku`),
  KEY `codigo_ean` (`codigo_ean`),
  KEY `codigo_alt` (`codigo_alt`),
  KEY `codigo_local` (`codigo_local`),
  KEY `origen_factura` (`origen_factura`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_notadebitovta_detalle`
--

LOCK TABLES `tbl_notadebitovta_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_notadebitovta_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_notadebitovta_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_notascredito`
--

DROP TABLE IF EXISTS `tbl_notascredito`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_notascredito` (
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `codigo_referencia` int(1) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'EP=EnProceso AN=Anulado GR=Guardado TR=Transferido',
  `fecha` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `ano_control` int(4) NOT NULL,
  `time` int(10) NOT NULL,
  `time_ingreso` int(10) NOT NULL,
  `usuario_ingreso` int(10) NOT NULL,
  `notacredito` int(10) NOT NULL,
  `factura` varchar(50) COLLATE utf8_spanish_ci NOT NULL,
  `rut_vendedor` varchar(15) COLLATE utf8_spanish_ci NOT NULL COMMENT 'rut del empleado que recepciono',
  `tipo_notacredito` int(10) NOT NULL,
  `tipo_documento` int(1) NOT NULL COMMENT '1=manual afecto 2=manual exento 3=electronico afecto 4=electronico exento',
  `exenta` int(1) NOT NULL DEFAULT '0' COMMENT '1=exenta 0=afecta',
  `electronica` int(1) NOT NULL DEFAULT '0',
  `id_proyecto` int(10) NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `id_centrocosto` int(10) NOT NULL,
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `tipo_cliente` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `razon_social` varchar(250) COLLATE utf8_spanish_ci NOT NULL,
  `giro` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `direccion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `comuna` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `ciudad` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `contacto` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `fono` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `neto` int(10) NOT NULL,
  `neto_exento` int(10) NOT NULL,
  `iva` int(10) NOT NULL,
  `bruto` int(10) NOT NULL,
  `observaciones` text COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `folio` (`folio`),
  KEY `id_proyecto` (`id_proyecto`),
  KEY `tipo_notacredito` (`tipo_notacredito`),
  KEY `factura` (`factura`),
  KEY `notacredito` (`notacredito`),
  KEY `exenta` (`exenta`),
  KEY `electronica` (`electronica`),
  KEY `mes_control` (`mes_control`,`ano_control`),
  KEY `id_sucursal` (`id_sucursal`,`id_centrocosto`),
  KEY `tipo_documento` (`tipo_documento`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_notascredito`
--

LOCK TABLES `tbl_notascredito` WRITE;
/*!40000 ALTER TABLE `tbl_notascredito` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_notascredito` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_notascredito_detalle`
--

DROP TABLE IF EXISTS `tbl_notascredito_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_notascredito_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `ano_control` int(4) NOT NULL,
  `fecha_emision` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_emision` int(10) NOT NULL,
  `id_item` int(10) NOT NULL,
  `id_centrocosto` int(10) NOT NULL,
  `id_centronegocio` int(10) NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '' COMMENT 'P=Producto M=MateriaPrima I=Insumo C=Cuenta',
  `codigo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` text COLLATE utf8_spanish_ci NOT NULL,
  `cantidad` decimal(12,2) NOT NULL,
  `unitario` decimal(12,2) NOT NULL,
  `subtotal` int(10) NOT NULL,
  `observaciones` text COLLATE utf8_spanish_ci NOT NULL,
  `costo_unitario` int(10) NOT NULL,
  `costo_subtotal` int(10) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `folio` (`folio`),
  KEY `estado` (`estado`),
  KEY `codigo` (`codigo`),
  KEY `tipo_item` (`tipo_item`),
  KEY `mes_control` (`mes_control`,`ano_control`),
  KEY `id_centrocosto` (`id_centrocosto`,`id_centronegocio`,`id_sucursal`),
  KEY `fecha_emision` (`fecha_emision`,`time_emision`),
  KEY `id_proyecto` (`id_proyecto`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_notascredito_detalle`
--

LOCK TABLES `tbl_notascredito_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_notascredito_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_notascredito_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_notascredito_proveedores`
--

DROP TABLE IF EXISTS `tbl_notascredito_proveedores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_notascredito_proveedores` (
  `id_compra` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion de la factura',
  `rut_folio` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'concatenar rut prov y folio fc para campo unico',
  `numero_compra` int(10) NOT NULL AUTO_INCREMENT COMMENT 'numero unico de cada factura',
  `id_usuario` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario creador de la factura',
  `id_proveedor` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL,
  `rut` varchar(12) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `razon_social` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_fantasia` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `factura_importacion` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `costeo_importacion` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no ( Indica cuando la factura ya ha sido costeada)',
  `factura_activofijo` int(1) NOT NULL DEFAULT '0',
  `factura_gasto` int(10) NOT NULL DEFAULT '0',
  `tipo_factura` int(1) NOT NULL DEFAULT '0' COMMENT '1=normal 2=exenta 3=electronica 4=exenta electronica',
  `tipo_contabilizacion` int(1) NOT NULL DEFAULT '0' COMMENT '1=Factura Cuentas 2=Factura por Recibir 3=Factura por ingresar',
  `tipo_documento` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `clase_factura` int(1) NOT NULL DEFAULT '0' COMMENT '0=indefinido 1=Solo cuentas 2=Solo Productos 3=Productos y Cuentas',
  `folio_notacredito` int(10) NOT NULL,
  `folio_factura` int(10) NOT NULL DEFAULT '0',
  `sw_bloqueo` int(1) NOT NULL DEFAULT '0' COMMENT '0=no bloqueada 1=si bloqueada  ( bloquea la factura cuando esta ya ha sido cerrado el periodo contable )',
  `documento_recepcion` char(3) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'FC=FacturaCompra GD=GuiaDespacho  OC=OrdenCompra',
  `folio_documento_recepcion` int(10) NOT NULL DEFAULT '0' COMMENT 'folio del documento con el cual se recepciono la mercaderia en bodega',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'EP=EnProceso  IN=ingresada  indica si la factura ha sido ingresada al libro de compras',
  `apertura` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `anulada` int(1) NOT NULL DEFAULT '0' COMMENT '0=no 1=si',
  `folio_guiadespacho` varchar(255) COLLATE utf8_spanish_ci NOT NULL COMMENT 'folio-folio-...',
  `folio_ordencompra` int(10) NOT NULL DEFAULT '0',
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `time_facturacion` int(10) NOT NULL DEFAULT '0' COMMENT 'timestamp con fecha de emision de la factura',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'mes control libro de compras',
  `ano_control` int(4) NOT NULL DEFAULT '0' COMMENT 'ano control libro de compras',
  `numero_control` int(10) NOT NULL DEFAULT '0' COMMENT 'numero de control del periodo del libro de compras',
  `numero_transaccion` int(10) NOT NULL DEFAULT '0' COMMENT 'numero del boucher del ingreso de la factura de compra',
  `contabilizada` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no indica si la factura ha sido contabilizada en el libro diario',
  `fecha_vencimiento` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `time_vencimiento` int(10) NOT NULL,
  `condiciones_pago` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `subtotal` int(10) NOT NULL DEFAULT '0',
  `descuento_porc` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0',
  `neto` int(10) NOT NULL DEFAULT '0',
  `iva` int(10) NOT NULL DEFAULT '0',
  `ajustar_iva` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT '+ sube - baja pesos del iva',
  `bruto` int(10) NOT NULL DEFAULT '0',
  `saldo_pendiente` int(10) NOT NULL DEFAULT '0',
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL,
  `numero_importacion` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `numero_despacho` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `numero_compra` (`numero_compra`),
  KEY `folio_factura` (`folio_factura`),
  KEY `rut` (`rut`),
  KEY `id_proveedor` (`id_proveedor`),
  KEY `mes_control` (`mes_control`),
  KEY `ano_control` (`ano_control`),
  KEY `id_sucursal` (`id_sucursal`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_notascredito_proveedores`
--

LOCK TABLES `tbl_notascredito_proveedores` WRITE;
/*!40000 ALTER TABLE `tbl_notascredito_proveedores` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_notascredito_proveedores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_notascredito_proveedores_detalle`
--

DROP TABLE IF EXISTS `tbl_notascredito_proveedores_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_notascredito_proveedores_detalle` (
  `id_compra` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de recepcion de la compra',
  `numero_compra` int(10) NOT NULL DEFAULT '0',
  `id_proveedor` int(10) NOT NULL DEFAULT '0',
  `id_item` int(10) NOT NULL DEFAULT '0',
  `id_centrocosto` int(2) NOT NULL DEFAULT '0',
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT 'Id del proyecto al cual esta asociado este gasto',
  `id_activofijo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `id_centronegocio` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'C=cuenta P=producto S=servicio',
  `rut` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `folio_notacredito` int(10) NOT NULL,
  `folio_factura` int(10) NOT NULL DEFAULT '0',
  `folio_guiadespacho` varchar(100) COLLATE utf8_spanish_ci NOT NULL COMMENT 'folios de guias de despacho asociadas a la factura, se separan por guiones',
  `folio_ordencompra` int(10) NOT NULL DEFAULT '0',
  `folio_notaventa` int(10) NOT NULL DEFAULT '0',
  `folio_importacion` int(10) NOT NULL DEFAULT '0',
  `fecha_compra` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `time_compra` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp de fecha de emision de la factura',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'mes de contabilizacion',
  `ano_control` int(4) NOT NULL DEFAULT '0' COMMENT 'año de contabilizacion',
  `numero_control` int(10) NOT NULL DEFAULT '0' COMMENT 'numero de contabilizacion',
  `codigo_producto` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `impuesto` int(1) NOT NULL DEFAULT '0' COMMENT '1=SI 0=NO (Indica si el item esta afecto a iva)',
  `precio_lista` decimal(13,3) NOT NULL DEFAULT '0.000' COMMENT 'Precio de lista del proveedor',
  `descuento_porc` int(2) NOT NULL DEFAULT '0' COMMENT 'Porcentaje de descuento lineal',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0' COMMENT 'Descuento lineal en pesos',
  `precio_compra` decimal(13,3) NOT NULL DEFAULT '0.000' COMMENT 'Precio de compra con descuento lineal aplicado',
  `cantidad` int(10) NOT NULL DEFAULT '0',
  `cantidad_devuelta` int(10) NOT NULL DEFAULT '0' COMMENT 'cantidad devuelta con notas de credito',
  `subtotal` decimal(12,2) NOT NULL DEFAULT '0.00',
  `descuento_global` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT '% de descuento global aplicado a la factura',
  `subtotal_final` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal neto con el descuento global aplicado',
  KEY `id_compra` (`id_compra`),
  KEY `id_proveedor` (`id_proveedor`),
  KEY `folio_ordencompra` (`folio_ordencompra`),
  KEY `codigo_producto` (`codigo_producto`),
  KEY `folio_guiadespacho` (`folio_guiadespacho`),
  KEY `id_sucursal` (`id_sucursal`,`id_centronegocio`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_notascredito_proveedores_detalle`
--

LOCK TABLES `tbl_notascredito_proveedores_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_notascredito_proveedores_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_notascredito_proveedores_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_notasdebitoprov`
--

DROP TABLE IF EXISTS `tbl_notasdebitoprov`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_notasdebitoprov` (
  `id_transaccion` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion del comprobante contable',
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `folio_notadebito` int(10) NOT NULL,
  `id_cliente` int(10) NOT NULL,
  `tipo_documento` int(1) NOT NULL DEFAULT '0',
  `sw_rutear` int(1) NOT NULL DEFAULT '0' COMMENT 'indica si el pedido se debe rutear',
  `folio_ruta` int(10) NOT NULL,
  `rut` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `razon_social` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `direccion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `fono_fax` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `comuna` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `id_sucursal` int(10) NOT NULL,
  `clase_sucursal` char(1) COLLATE utf8_spanish_ci NOT NULL COMMENT 'clase de la sucursal del cliente al momento de procesar el pedido',
  `orden_sucursal` int(10) NOT NULL,
  `prioridad_despacho` int(10) NOT NULL,
  `nombre_sucursal` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `contacto` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `email_emisor` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_contacto` int(10) NOT NULL,
  `sw_periodo` int(1) NOT NULL COMMENT '0=abierto 1=cerrado ( corresponde al periodo abierto o cerrado)',
  `sw_multiop` int(1) NOT NULL,
  `fecha_solicitud` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_solicitud` int(10) NOT NULL,
  `fecha_ejecucion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_ejecucion` int(10) NOT NULL,
  `fecha_proceso` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_proceso` int(10) NOT NULL,
  `despacho_desde` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_desde` int(10) NOT NULL,
  `despacho_hasta` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_hasta` int(10) NOT NULL,
  `fecha_contable` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_contable` int(10) NOT NULL,
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `id_usuario_proceso` int(10) NOT NULL,
  `id_bodega` int(10) NOT NULL COMMENT 'id bodega de destino',
  `id_centrocosto` int(10) NOT NULL,
  `id_centronegocio` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `id_solicita` int(10) NOT NULL,
  `id_autoriza` int(10) NOT NULL,
  `id_ejecuta` int(10) NOT NULL,
  `id_formapago` int(10) NOT NULL,
  `id_vendedor` int(10) NOT NULL,
  `id_tipopedido` int(1) NOT NULL,
  `id_formaentrega` int(1) NOT NULL COMMENT '0=parcial 1=total',
  `cuenta_origen` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'contracuenta de la contabilizacion ej. merc. nac v/s cuenta_origen',
  `orden_compra` varchar(64) COLLATE utf8_spanish_ci NOT NULL COMMENT '64 bytes para el cod o folio de la oc asociada al pedido',
  `cotizacion` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_sucursal` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `total` int(10) NOT NULL,
  `descuento_porc` decimal(12,2) NOT NULL,
  `descuento_pesos` int(10) NOT NULL,
  `neto` int(10) NOT NULL,
  `iva` int(10) NOT NULL,
  `bruto` int(10) NOT NULL,
  `estado` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(1000) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion_despacho` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `folio` (`folio`),
  KEY `estado` (`estado`),
  KEY `fecha_ejecucion` (`fecha_ejecucion`),
  KEY `time_ejecucion` (`time_ejecucion`),
  KEY `cuenta_origen` (`cuenta_origen`),
  KEY `id_bodega` (`id_bodega`),
  KEY `sw_periodo` (`sw_periodo`),
  KEY `time_proceso` (`time_proceso`),
  KEY `id_usuario_proceso` (`id_usuario_proceso`),
  KEY `orden_compra` (`orden_compra`),
  KEY `sw_multiop` (`sw_multiop`),
  KEY `codigo_sucursal` (`codigo_sucursal`),
  KEY `rut` (`rut`),
  KEY `razon_social` (`razon_social`),
  KEY `direccion` (`direccion`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `contacto` (`contacto`),
  KEY `id_contacto` (`id_contacto`),
  KEY `id_formapago` (`id_formapago`),
  KEY `id_vendedor` (`id_vendedor`),
  KEY `fecha_solicitud` (`fecha_solicitud`),
  KEY `time_solicitud` (`time_solicitud`),
  KEY `id_tipopedido` (`id_tipopedido`),
  KEY `id_formaentrega` (`id_formaentrega`),
  KEY `cotizacion` (`cotizacion`),
  KEY `despacho_desde` (`despacho_desde`),
  KEY `time_desde` (`time_desde`),
  KEY `despacho_hasta` (`despacho_hasta`),
  KEY `time_hasta` (`time_hasta`),
  KEY `id_cliente` (`id_cliente`),
  KEY `fecha_proceso` (`fecha_proceso`),
  KEY `orden_sucursal` (`orden_sucursal`),
  KEY `prioridad_despacho` (`prioridad_despacho`),
  KEY `clase_sucursal` (`clase_sucursal`),
  KEY `tipo_documento` (`tipo_documento`),
  KEY `sw_rutear` (`sw_rutear`),
  KEY `folio_ruta` (`folio_ruta`),
  KEY `email_emisor` (`email_emisor`),
  KEY `fecha_contable` (`fecha_contable`),
  KEY `time_contable` (`time_contable`),
  KEY `folio_notadebito` (`folio_notadebito`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_notasdebitoprov`
--

LOCK TABLES `tbl_notasdebitoprov` WRITE;
/*!40000 ALTER TABLE `tbl_notasdebitoprov` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_notasdebitoprov` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_notasdebitoprov_detalle`
--

DROP TABLE IF EXISTS `tbl_notasdebitoprov_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_notasdebitoprov_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `sw_periodo` int(1) NOT NULL,
  `id_usuario` int(10) NOT NULL COMMENT 'id del usuario creador de la linea 1=Sistema',
  `id_usuario_proceso` int(10) NOT NULL,
  `time_creacion_registro` int(10) NOT NULL,
  `time_proceso` int(10) NOT NULL,
  `id_item` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `codigo` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_sku` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `prioridad_despacho` int(10) NOT NULL COMMENT 'orden de prioridad de despachos por nota de pedido',
  `clase_sucursal` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'Indica al boucher si la linea ha sido finalizada 1=Si 0=No',
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT 'ID del proyecto asociado a la linea contable que genero el cargo u/o abono',
  `id_vendedor` int(10) NOT NULL,
  `id_formaentrega` int(10) NOT NULL,
  `bultos` int(10) NOT NULL,
  `numero_lote` varchar(128) COLLATE utf8_spanish_ci NOT NULL,
  `numero_serie` varchar(128) COLLATE utf8_spanish_ci NOT NULL,
  `cantidad` decimal(12,2) NOT NULL,
  `reserva` decimal(12,2) NOT NULL,
  `embalado` decimal(12,2) NOT NULL,
  `facturado` decimal(12,2) NOT NULL,
  `pendiente` decimal(12,2) NOT NULL,
  `pendiente_historico` int(10) NOT NULL COMMENT 'aqui se almacena la cantidad pendiente que se origino al momento procesar el pedido',
  `unitario` decimal(12,2) NOT NULL,
  `descuento` decimal(12,2) NOT NULL COMMENT 'porc de descuento aplicado al subtotal',
  `descuento_pesos` int(10) NOT NULL COMMENT 'descuento en pesos aplicado al subtotal',
  `subtotal` int(10) NOT NULL,
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `orden_compra` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `folio` (`folio`),
  KEY `id_item` (`id_item`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `time_creacion_registro` (`time_creacion_registro`),
  KEY `tipo_item` (`tipo_item`),
  KEY `codigo` (`codigo`),
  KEY `sw_periodo` (`sw_periodo`),
  KEY `numero_lote` (`numero_lote`),
  KEY `numero_serie` (`numero_serie`),
  KEY `reserva` (`reserva`),
  KEY `time_proceso` (`time_proceso`),
  KEY `id_usuario_proceso` (`id_usuario_proceso`),
  KEY `orden_compra` (`orden_compra`),
  KEY `id_vendedor` (`id_vendedor`),
  KEY `id_formaentrega` (`id_formaentrega`),
  KEY `embalado` (`embalado`),
  KEY `facturado` (`facturado`),
  KEY `prioridad_despacho` (`prioridad_despacho`),
  KEY `codigo_sku` (`codigo_sku`),
  KEY `clase_sucursal` (`clase_sucursal`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_notasdebitoprov_detalle`
--

LOCK TABLES `tbl_notasdebitoprov_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_notasdebitoprov_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_notasdebitoprov_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_notaspedido`
--

DROP TABLE IF EXISTS `tbl_notaspedido`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_notaspedido` (
  `id_transaccion` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion del comprobante contable',
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `id_sucursal_venta` int(10) NOT NULL,
  `id_cliente` int(10) NOT NULL,
  `id_listaprecios` int(10) NOT NULL,
  `tipo_documento` int(1) NOT NULL DEFAULT '0',
  `sw_rutear` int(1) NOT NULL DEFAULT '0' COMMENT 'indica si el pedido se debe rutear',
  `folio_ruta` int(10) NOT NULL,
  `rut` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `razon_social` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `direccion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `clase_sucursal` char(1) COLLATE utf8_spanish_ci NOT NULL COMMENT 'clase de la sucursal del cliente al momento de procesar el pedido',
  `orden_sucursal` int(10) NOT NULL,
  `prioridad_despacho` int(10) NOT NULL,
  `nombre_sucursal` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `contacto` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `id_contacto` int(10) NOT NULL,
  `sw_periodo` int(1) NOT NULL COMMENT '0=abierto 1=cerrado ( corresponde al periodo abierto o cerrado)',
  `sw_multiop` int(1) NOT NULL,
  `fecha_solicitud` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_solicitud` int(10) NOT NULL,
  `fecha_ejecucion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_ejecucion` int(10) NOT NULL,
  `fecha_proceso` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_proceso` int(10) NOT NULL,
  `despacho_desde` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_desde` int(10) NOT NULL,
  `despacho_hasta` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_hasta` int(10) NOT NULL,
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `id_usuario_proceso` int(10) NOT NULL,
  `id_bodega` int(10) NOT NULL COMMENT 'id bodega de destino',
  `id_centrocosto` int(10) NOT NULL,
  `id_centronegocio` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `id_solicita` int(10) NOT NULL,
  `id_autoriza` int(10) NOT NULL,
  `id_ejecuta` int(10) NOT NULL,
  `id_formapago` int(10) NOT NULL,
  `id_condicionpago` int(2) NOT NULL,
  `id_vendedor` int(10) NOT NULL,
  `id_tipopedido` int(1) NOT NULL,
  `id_formaentrega` int(1) NOT NULL COMMENT '0=parcial 1=total',
  `cuenta_origen` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'contracuenta de la contabilizacion ej. merc. nac v/s cuenta_origen',
  `orden_compra` varchar(64) COLLATE utf8_spanish_ci NOT NULL COMMENT '64 bytes para el cod o folio de la oc asociada al pedido',
  `cotizacion` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_sucursal` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `total` int(10) NOT NULL,
  `estado` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion_despacho` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `estado_pag` int(10) NOT NULL,
  `estado_fac` int(10) NOT NULL,
  `id_comuna` int(11) NOT NULL,
  `subtotal` int(10) NOT NULL,
  `suma_afecto` int(10) NOT NULL,
  `descuento_afecto` decimal(10,2) NOT NULL,
  `tipodescuento_afecto` int(1) NOT NULL,
  `montodescuento_afecto` int(10) NOT NULL,
  `porcdescuento_afecto` decimal(10,2) NOT NULL,
  `suma_exento` int(10) NOT NULL,
  `descuento_exento` decimal(10,2) NOT NULL,
  `tipodescuento_exento` int(1) NOT NULL,
  `montodescuento_exento` int(10) NOT NULL,
  `porcdescuento_exento` decimal(10,5) NOT NULL,
  `descuento_porc` int(2) NOT NULL,
  `descuento_pesos` int(10) NOT NULL,
  `neto` int(10) NOT NULL,
  `neto_exento` int(10) NOT NULL,
  `tasa_iva` int(2) NOT NULL,
  `iva` int(10) NOT NULL,
  `bruto` int(10) NOT NULL,
  `giro` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `email` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `fono_fax` char(32) COLLATE utf8_spanish_ci NOT NULL,
  `comuna` varchar(70) COLLATE utf8_spanish_ci NOT NULL,
  `id_lista_de_precios` int(11) DEFAULT NULL,
  `id_empleado` int(11) NOT NULL,
  UNIQUE KEY `folio` (`folio`),
  KEY `estado` (`estado`),
  KEY `fecha_ejecucion` (`fecha_ejecucion`),
  KEY `time_ejecucion` (`time_ejecucion`),
  KEY `cuenta_origen` (`cuenta_origen`),
  KEY `id_bodega` (`id_bodega`),
  KEY `sw_periodo` (`sw_periodo`),
  KEY `time_proceso` (`time_proceso`),
  KEY `id_usuario_proceso` (`id_usuario_proceso`),
  KEY `orden_compra` (`orden_compra`),
  KEY `sw_multiop` (`sw_multiop`),
  KEY `codigo_sucursal` (`codigo_sucursal`),
  KEY `rut` (`rut`),
  KEY `razon_social` (`razon_social`),
  KEY `direccion` (`direccion`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `contacto` (`contacto`),
  KEY `id_contacto` (`id_contacto`),
  KEY `id_formapago` (`id_formapago`),
  KEY `id_vendedor` (`id_vendedor`),
  KEY `fecha_solicitud` (`fecha_solicitud`),
  KEY `time_solicitud` (`time_solicitud`),
  KEY `id_tipopedido` (`id_tipopedido`),
  KEY `id_formaentrega` (`id_formaentrega`),
  KEY `cotizacion` (`cotizacion`),
  KEY `despacho_desde` (`despacho_desde`),
  KEY `time_desde` (`time_desde`),
  KEY `despacho_hasta` (`despacho_hasta`),
  KEY `time_hasta` (`time_hasta`),
  KEY `id_cliente` (`id_cliente`),
  KEY `fecha_proceso` (`fecha_proceso`),
  KEY `orden_sucursal` (`orden_sucursal`),
  KEY `prioridad_despacho` (`prioridad_despacho`),
  KEY `clase_sucursal` (`clase_sucursal`),
  KEY `tipo_documento` (`tipo_documento`),
  KEY `sw_rutear` (`sw_rutear`),
  KEY `folio_ruta` (`folio_ruta`),
  KEY `id_sucursal_venta` (`id_sucursal_venta`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_notaspedido`
--

LOCK TABLES `tbl_notaspedido` WRITE;
/*!40000 ALTER TABLE `tbl_notaspedido` DISABLE KEYS */;
INSERT INTO `tbl_notaspedido` VALUES (0,1,1,1,0,4,0,0,'11111111-1','PUBLICO GENERAL','GENERICO',0,'',0,0,'','GENERICO',0,0,0,'',0,'',0,'',0,'28/11/2018',0,'28/11/2018',0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,'','','','',0,'EP','TPV','',0,0,274,0,0,0.00,0,0,0.00,0,0.00,0,0,0.00000,0,0,0,0,19,0,0,'GENERICO','.','2222','',NULL,0),(0,2,1,1,0,4,0,0,'11111111-1','PUBLICO GENERAL','GENERICO',0,'',0,0,'','GENERICO',0,0,0,'',0,'',0,'',0,'28/11/2018',0,'28/11/2018',0,0,0,0,0,0,0,0,0,0,5,1,1,1,2,'','','','',0,'EP','TPV','',0,0,274,200,0,0.00,0,0,0.00,0,0.00,0,0,0.00000,0,0,168,0,19,32,200,'GENERICO','.','2222','',NULL,0);
/*!40000 ALTER TABLE `tbl_notaspedido` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_notaspedido_despachos`
--

DROP TABLE IF EXISTS `tbl_notaspedido_despachos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_notaspedido_despachos` (
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT 'EP',
  `time_creacion` int(10) NOT NULL,
  `usuario_creacion` int(10) NOT NULL,
  `usuario_proceso` int(10) NOT NULL,
  `time_proceso` int(10) NOT NULL,
  `folio_notapedido` int(10) NOT NULL,
  `folio_factura` int(10) NOT NULL,
  `folio_guia` int(10) NOT NULL,
  `id_operador` int(10) NOT NULL COMMENT 'id del empleado que ejecuta el despacho',
  UNIQUE KEY `folio` (`folio`),
  KEY `folio_notapedido` (`folio_notapedido`),
  KEY `estado` (`estado`),
  KEY `time_creacion` (`time_creacion`),
  KEY `usuario_creacion` (`usuario_creacion`),
  KEY `id_operador` (`id_operador`),
  KEY `folio_factura` (`folio_factura`),
  KEY `usuario_proceso` (`usuario_proceso`),
  KEY `time_proceso` (`time_proceso`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_notaspedido_despachos`
--

LOCK TABLES `tbl_notaspedido_despachos` WRITE;
/*!40000 ALTER TABLE `tbl_notaspedido_despachos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_notaspedido_despachos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_notaspedido_despachos_detalle`
--

DROP TABLE IF EXISTS `tbl_notaspedido_despachos_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_notaspedido_despachos_detalle` (
  `id_registro` int(10) NOT NULL AUTO_INCREMENT,
  `orden_compra` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `folio_notapedido` int(10) NOT NULL,
  `folio_despacho` int(10) NOT NULL,
  `codigo_sucursal` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `folio_factura` int(10) NOT NULL,
  `folio_guia` int(10) NOT NULL,
  `codigo_bulto` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `id_item_bulto` int(10) NOT NULL COMMENT 'id item del bulto',
  `codigo_item` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `cantidad` decimal(12,2) NOT NULL,
  `codigo_operador` int(10) NOT NULL,
  `operador_modificador` int(10) NOT NULL COMMENT 'codigo del operador que modifico el despacho del pedido',
  UNIQUE KEY `id_registro` (`id_registro`),
  KEY `codigo_item` (`codigo_item`),
  KEY `cantidad` (`cantidad`),
  KEY `orden_compra` (`orden_compra`),
  KEY `folio_factura` (`folio_factura`),
  KEY `codigo_operador` (`codigo_operador`),
  KEY `operador_modificador` (`operador_modificador`),
  KEY `estado` (`estado`),
  KEY `codigo_sucursal` (`codigo_sucursal`),
  KEY `id_sucursal` (`id_sucursal`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_notaspedido_despachos_detalle`
--

LOCK TABLES `tbl_notaspedido_despachos_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_notaspedido_despachos_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_notaspedido_despachos_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_notaspedido_detalle`
--

DROP TABLE IF EXISTS `tbl_notaspedido_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_notaspedido_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `rut` char(10) COLLATE utf8_spanish_ci NOT NULL,
  `fecha` char(10) COLLATE utf8_spanish_ci NOT NULL,
  `sw_periodo` int(1) NOT NULL,
  `id_usuario` int(10) NOT NULL COMMENT 'id del usuario creador de la linea 1=Sistema',
  `id_usuario_proceso` int(10) NOT NULL,
  `time_creacion_registro` int(10) NOT NULL,
  `time_proceso` int(10) NOT NULL,
  `id_item` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `codigo` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_sku` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `prioridad_despacho` int(10) NOT NULL COMMENT 'orden de prioridad de despachos por nota de pedido',
  `clase_sucursal` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'Indica al boucher si la linea ha sido finalizada 1=Si 0=No',
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT 'ID del proyecto asociado a la linea contable que genero el cargo u/o abono',
  `id_vendedor` int(10) NOT NULL,
  `id_formaentrega` int(10) NOT NULL,
  `bultos` int(10) NOT NULL,
  `numero_lote` varchar(128) COLLATE utf8_spanish_ci NOT NULL,
  `numero_serie` varchar(128) COLLATE utf8_spanish_ci NOT NULL,
  `cantidad` decimal(12,2) NOT NULL,
  `reserva` decimal(12,2) NOT NULL,
  `embalado` decimal(12,2) NOT NULL,
  `facturado` decimal(12,2) NOT NULL,
  `pendiente` decimal(12,2) NOT NULL,
  `pendiente_historico` int(10) NOT NULL COMMENT 'aqui se almacena la cantidad pendiente que se origino al momento procesar el pedido',
  `unitario` decimal(12,2) NOT NULL,
  `subtotal` int(10) NOT NULL,
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `orden_compra` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `descuento_porc` decimal(5,2) NOT NULL,
  `descuento_porc_global` decimal(5,2) NOT NULL,
  `descuento_pesos` int(10) NOT NULL,
  `subtotal_neto` int(10) NOT NULL,
  `subtotal_final` int(10) NOT NULL,
  `monto_impuesto_adicional` int(10) NOT NULL,
  `monto_impuesto_especifico` int(10) NOT NULL,
  `codigo_impuesto_adicional` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `tasa_impuesto_adicional` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `sw_exento` int(1) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `folio` (`folio`),
  KEY `id_item` (`id_item`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `time_creacion_registro` (`time_creacion_registro`),
  KEY `tipo_item` (`tipo_item`),
  KEY `codigo` (`codigo`),
  KEY `sw_periodo` (`sw_periodo`),
  KEY `numero_lote` (`numero_lote`),
  KEY `numero_serie` (`numero_serie`),
  KEY `reserva` (`reserva`),
  KEY `time_proceso` (`time_proceso`),
  KEY `id_usuario_proceso` (`id_usuario_proceso`),
  KEY `orden_compra` (`orden_compra`),
  KEY `id_vendedor` (`id_vendedor`),
  KEY `id_formaentrega` (`id_formaentrega`),
  KEY `embalado` (`embalado`),
  KEY `facturado` (`facturado`),
  KEY `prioridad_despacho` (`prioridad_despacho`),
  KEY `codigo_sku` (`codigo_sku`),
  KEY `clase_sucursal` (`clase_sucursal`),
  KEY `rut` (`rut`),
  KEY `fecha` (`fecha`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_notaspedido_detalle`
--

LOCK TABLES `tbl_notaspedido_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_notaspedido_detalle` DISABLE KEYS */;
INSERT INTO `tbl_notaspedido_detalle` VALUES (2,2,'','',0,0,0,0,0,1,'','10001','',0,0,'','','Varios',0,0,0,0,'','',1.00,0.00,0.00,0.00,0.00,0,100.00,100,'0','',0.00,0.00,0,0,0,0,0,'','',0),(3,2,'','',0,0,0,0,0,2,'','10001','',0,0,'','','Varios',0,0,0,0,'','',1.00,0.00,0.00,0.00,0.00,0,100.00,100,'0','',0.00,0.00,0,0,0,0,0,'','',0);
/*!40000 ALTER TABLE `tbl_notaspedido_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_notaspedido_estados`
--

DROP TABLE IF EXISTS `tbl_notaspedido_estados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_notaspedido_estados` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `estado` varchar(70) NOT NULL,
  `orden` varchar(70) NOT NULL,
  `etiqueta` varchar(70) NOT NULL,
  `descripcion` varchar(70) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_notaspedido_estados`
--

LOCK TABLES `tbl_notaspedido_estados` WRITE;
/*!40000 ALTER TABLE `tbl_notaspedido_estados` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_notaspedido_estados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_notaspedido_masivas`
--

DROP TABLE IF EXISTS `tbl_notaspedido_masivas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_notaspedido_masivas` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `orden_compra` varchar(128) COLLATE utf8_spanish_ci NOT NULL,
  `cotizacion` varchar(128) COLLATE utf8_spanish_ci NOT NULL,
  `prioridad` int(10) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `orden_compra` (`orden_compra`),
  KEY `cotizacion` (`cotizacion`),
  KEY `prioridad` (`prioridad`),
  KEY `estado` (`estado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_notaspedido_masivas`
--

LOCK TABLES `tbl_notaspedido_masivas` WRITE;
/*!40000 ALTER TABLE `tbl_notaspedido_masivas` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_notaspedido_masivas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_notaspedido_pagos`
--

DROP TABLE IF EXISTS `tbl_notaspedido_pagos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_notaspedido_pagos` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `id_mediopago` int(10) NOT NULL,
  `id_condicionpago` int(10) NOT NULL,
  `monto` int(10) NOT NULL,
  `numero_documento` char(32) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_notaspedido_pagos`
--

LOCK TABLES `tbl_notaspedido_pagos` WRITE;
/*!40000 ALTER TABLE `tbl_notaspedido_pagos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_notaspedido_pagos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_novedades`
--

DROP TABLE IF EXISTS `tbl_novedades`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_novedades` (
  `id_novedad` decimal(10,0) NOT NULL DEFAULT '0',
  `categoria` char(1) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `numero` decimal(3,0) NOT NULL DEFAULT '0',
  `cant_img` int(10) NOT NULL DEFAULT '0',
  `dia` decimal(2,0) NOT NULL DEFAULT '0',
  `mes` decimal(2,0) NOT NULL DEFAULT '0',
  `ano` decimal(4,0) NOT NULL DEFAULT '0',
  `titulo` varchar(100) CHARACTER SET latin1 NOT NULL DEFAULT '0',
  `subtitulo` varchar(200) CHARACTER SET latin1 NOT NULL DEFAULT '0',
  `detalle` text CHARACTER SET latin1 NOT NULL,
  UNIQUE KEY `id_novedad` (`id_novedad`),
  KEY `numero` (`numero`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_novedades`
--

LOCK TABLES `tbl_novedades` WRITE;
/*!40000 ALTER TABLE `tbl_novedades` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_novedades` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenes_recepcion`
--

DROP TABLE IF EXISTS `tbl_ordenes_recepcion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenes_recepcion` (
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'EP=EnProceso AN=Anulado GR=Guardado TR=Transferido',
  `fecha` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time` int(10) NOT NULL,
  `time_ingreso` int(10) NOT NULL,
  `usuario_ingreso` int(10) NOT NULL,
  `rut_receptor` varchar(15) COLLATE utf8_spanish_ci NOT NULL COMMENT 'rut del empleado que recepciono',
  `id_motivo` int(10) NOT NULL,
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `tipo_cliente` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `razon_social` varchar(250) COLLATE utf8_spanish_ci NOT NULL,
  `direccion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `contacto` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `fono` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` text COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `folio` (`folio`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenes_recepcion`
--

LOCK TABLES `tbl_ordenes_recepcion` WRITE;
/*!40000 ALTER TABLE `tbl_ordenes_recepcion` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenes_recepcion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenes_recepcion_detalle`
--

DROP TABLE IF EXISTS `tbl_ordenes_recepcion_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenes_recepcion_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `id_item` int(10) NOT NULL,
  `descripcion` text COLLATE utf8_spanish_ci NOT NULL,
  `tipo_documento` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `folio_documento` int(10) NOT NULL,
  `id_motivo` int(2) NOT NULL,
  `marca` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `modelo` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `serie` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` text COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `folio` (`folio`),
  KEY `estado` (`estado`),
  KEY `tipo_documento` (`tipo_documento`,`folio_documento`,`id_motivo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenes_recepcion_detalle`
--

LOCK TABLES `tbl_ordenes_recepcion_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_ordenes_recepcion_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenes_recepcion_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenescompra`
--

DROP TABLE IF EXISTS `tbl_ordenescompra`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenescompra` (
  `id_ordencompra` int(10) NOT NULL DEFAULT '0' COMMENT 'timestamp con fecha de creacion de la oc',
  `folio_ordencompra` int(10) NOT NULL AUTO_INCREMENT,
  `id_proveedor` int(10) NOT NULL DEFAULT '0',
  `id_contacto` int(10) NOT NULL DEFAULT '0' COMMENT 'id del contacto del proveedor',
  `id_usuario` int(10) NOT NULL DEFAULT '0' COMMENT 'Usuario que creo la cotizacion',
  `id_proyecto` int(10) NOT NULL,
  `rut_autorizador` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `sw_autorizador` int(1) NOT NULL DEFAULT '0',
  `rut_solicitante` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `rut` varchar(12) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `razon_social` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'razon social del proveedor',
  `nombre_fantasia` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_ruta` int(10) NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL COMMENT 'timestamp de la fecha de la orden de compra',
  `fecha` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT 'fecha de la orden de compra',
  `time_llegada` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora estimada de llegada de la compra',
  `fecha_llegada` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT 'fecha de llegada o fecha de retiro del despacho',
  `fecha_envio` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'timestamp con fecha y hora de envio de la oc al proveedor',
  `usuario_envio` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario que envio la oc al proveedor',
  `usuario_recepciono` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario que recepciono la oc',
  `time_recepciono` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de recepcion de la oc',
  `id_lectura` int(10) NOT NULL DEFAULT '0' COMMENT 'timestamp de lectura del proveedor',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'EP=en proceso EN=enviada RE=recepcionada AN=anulada',
  `suma` int(10) NOT NULL DEFAULT '0',
  `descuento` int(2) NOT NULL DEFAULT '0' COMMENT 'porcentaje de descuento',
  `neto` int(10) NOT NULL DEFAULT '0',
  `iva` int(10) NOT NULL DEFAULT '0',
  `bruto` int(10) NOT NULL DEFAULT '0',
  `condiciones_pago` int(2) NOT NULL DEFAULT '0',
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL,
  `direccion_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `folio_ordencompra` (`folio_ordencompra`),
  KEY `id_ordencompra` (`id_ordencompra`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenescompra`
--

LOCK TABLES `tbl_ordenescompra` WRITE;
/*!40000 ALTER TABLE `tbl_ordenescompra` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenescompra` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenescompra_det`
--

DROP TABLE IF EXISTS `tbl_ordenescompra_det`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenescompra_det` (
  `id_ordencompra` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion de la oc',
  `time_llegada` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp con fecha y hora de llegada del item',
  `folio_ordencompra` int(10) NOT NULL DEFAULT '0',
  `id_item` int(10) NOT NULL DEFAULT '0',
  `codigo_maquina` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'codigo de la maquinaria que está requiriendo el gasto',
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'P=producto C=cuenta S=servicios  I=Insumo M=materiaprima  R=repuesto V=Varios',
  `id_proveedor` int(10) NOT NULL DEFAULT '0',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'EP=en proceso EN=enviada RE=recepcionada AN=anulada',
  `id_compra` int(10) NOT NULL DEFAULT '0' COMMENT 'almacena el timestamps del momento en que estan recibiendo una compra',
  `codigo_producto` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_centrocosto` int(10) NOT NULL,
  `codigo_catalogo` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'Codigo del producto del proveedor',
  `cantidad` int(10) NOT NULL DEFAULT '0' COMMENT 'Cantidad que se emitira en la orden de compra',
  `cantidad_pendiente` int(10) NOT NULL DEFAULT '0' COMMENT 'cantidad pendiente de compra',
  `cantidad_recepcionada` int(10) NOT NULL DEFAULT '0' COMMENT 'cantidad recepcionada por bodega',
  `precio_unitario` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'Precio referencial de lista',
  `subtotal` int(10) NOT NULL DEFAULT '0',
  `descuento_global` int(10) NOT NULL DEFAULT '0' COMMENT '% de descuento global aplicado a la oc',
  `unitario_final` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'unitario aplicando el descuento global',
  `subtotal_final` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal aplicando el descuento global',
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  KEY `folio_ordencompra` (`folio_ordencompra`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenescompra_det`
--

LOCK TABLES `tbl_ordenescompra_det` WRITE;
/*!40000 ALTER TABLE `tbl_ordenescompra_det` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenescompra_det` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenescompra_imp`
--

DROP TABLE IF EXISTS `tbl_ordenescompra_imp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenescompra_imp` (
  `id_ordencompra` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp con fecha y hora de creacion de la oci',
  `time_envio` int(10) NOT NULL DEFAULT '0' COMMENT 'timestamp conb fecha y hora que se envio la oci al proveedor',
  `time_recepcion` int(10) NOT NULL DEFAULT '0' COMMENT 'timestamp con fecha y hora en que se recepciono la oci',
  `folio_ordencompra` int(10) NOT NULL AUTO_INCREMENT,
  `folio_importacion` int(10) NOT NULL DEFAULT '0' COMMENT 'folio de la importacion asociada a la oci',
  `numero_importacion` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'numero de la importacion, este numero viene en todos las fact o doctos asociados',
  `id_proveedor` int(10) NOT NULL DEFAULT '0',
  `id_contacto` int(10) NOT NULL DEFAULT '0' COMMENT 'id del contacto del proveedor',
  `id_usuario` int(10) NOT NULL DEFAULT '0' COMMENT 'Usuario que creo la orden de compra',
  `id_usuario_envio` int(10) NOT NULL DEFAULT '0',
  `id_usuario_recepciono` int(10) NOT NULL DEFAULT '0',
  `id_bodega` int(10) NOT NULL DEFAULT '0' COMMENT 'id de la bodega donde se recepcionara la mercaderia',
  `rut` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `razon_social` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_fantasia` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_ruta` int(10) NOT NULL DEFAULT '0',
  `fecha_llegada` int(10) NOT NULL DEFAULT '0' COMMENT 'timestamp con fecha estimada de la compra',
  `id_lectura` int(10) NOT NULL DEFAULT '0' COMMENT 'timestamp de lectura del proveedor',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'EP=en proceso EN=enviada RE=recepcionada AN=anulada',
  `items_pendientes` int(10) NOT NULL DEFAULT '0' COMMENT 'cantidad de items pendientes por recepcionar o recepcionados en forma parcial',
  `costeada` int(1) NOT NULL DEFAULT '0' COMMENT '0=no 1=si',
  `tipo_moneda` int(10) NOT NULL DEFAULT '0',
  `valor_moneda` decimal(12,2) NOT NULL DEFAULT '0.00',
  `estimado_flete` int(10) NOT NULL DEFAULT '0' COMMENT 'gasto estimado en flete',
  `estimado_agencia` int(10) NOT NULL DEFAULT '0' COMMENT 'gasto estimado en agencia aduanera',
  `factor_estimado` decimal(10,2) NOT NULL DEFAULT '0.00',
  `suma` int(10) NOT NULL DEFAULT '0',
  `descuento` int(2) NOT NULL DEFAULT '0' COMMENT 'porcentaje de descuento',
  `neto` decimal(10,4) NOT NULL DEFAULT '0.0000',
  `neto_costeado` int(10) NOT NULL DEFAULT '0' COMMENT 'total neto con el ajuste aplicado',
  `iva` int(10) NOT NULL DEFAULT '0',
  `bruto` int(10) NOT NULL DEFAULT '0',
  `subtotal_fob_pesos` int(10) NOT NULL DEFAULT '0',
  `condiciones_pago` int(2) NOT NULL DEFAULT '0',
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `folio_ordencompra` (`folio_ordencompra`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenescompra_imp`
--

LOCK TABLES `tbl_ordenescompra_imp` WRITE;
/*!40000 ALTER TABLE `tbl_ordenescompra_imp` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenescompra_imp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenescompra_imp_det`
--

DROP TABLE IF EXISTS `tbl_ordenescompra_imp_det`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenescompra_imp_det` (
  `id_ordencompra` int(10) NOT NULL DEFAULT '0',
  `folio_ordencompra` int(10) NOT NULL DEFAULT '0',
  `id_item` int(10) NOT NULL DEFAULT '0',
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'P=producto C=cuenta S=servicios',
  `id_proveedor` int(10) NOT NULL DEFAULT '0',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'EP=enproceso EN=enviado RE=recepcionado  AN=anulado',
  `id_compra` int(10) NOT NULL DEFAULT '0' COMMENT 'almacena el timestamps del momento en que estan recibiendo una compra',
  `codigo_producto` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_catalogo` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'Codigo del producto del proveedor',
  `cantidad` int(10) NOT NULL DEFAULT '0' COMMENT 'Cantidad que se emitira en la orden de compra',
  `cantidad_pendiente` int(10) NOT NULL DEFAULT '0' COMMENT 'cantidad pendiente de compra',
  `cantidad_recepcionada` int(10) NOT NULL DEFAULT '0' COMMENT 'cantidad recepcionada por bodega',
  `precio_unitario` decimal(17,7) NOT NULL DEFAULT '0.0000000' COMMENT 'unitario fob en moneda extranjera',
  `subtotal` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  KEY `folio_ordencompra` (`folio_ordencompra`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenescompra_imp_det`
--

LOCK TABLES `tbl_ordenescompra_imp_det` WRITE;
/*!40000 ALTER TABLE `tbl_ordenescompra_imp_det` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenescompra_imp_det` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenescompras`
--

DROP TABLE IF EXISTS `tbl_ordenescompras`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenescompras` (
  `id_transaccion` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion del comprobante contable',
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `id_modificador` int(10) NOT NULL,
  `time_modificador` int(10) NOT NULL,
  `id_cliente` int(10) NOT NULL,
  `id_proveedor` int(10) NOT NULL,
  `id_origen` int(10) NOT NULL,
  `rut` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `razon_social` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `direccion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `clase_sucursal` char(1) COLLATE utf8_spanish_ci NOT NULL COMMENT 'clase de la sucursal del cliente al momento de procesar el pedido',
  `orden_sucursal` int(10) NOT NULL,
  `prioridad_despacho` int(10) NOT NULL,
  `nombre_sucursal` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `contacto` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `id_contacto` int(10) NOT NULL,
  `sw_periodo` int(1) NOT NULL COMMENT '0=abierto 1=cerrado ( corresponde al periodo abierto o cerrado)',
  `sw_multiop` int(1) NOT NULL,
  `fecha_solicitud` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_solicitud` int(10) NOT NULL,
  `fecha_ejecucion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_ejecucion` int(10) NOT NULL,
  `fecha_proceso` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_proceso` int(10) NOT NULL,
  `despacho_desde` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_desde` int(10) NOT NULL,
  `despacho_hasta` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_hasta` int(10) NOT NULL,
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `id_usuario_proceso` int(10) NOT NULL,
  `id_bodega` int(10) NOT NULL COMMENT 'id bodega de destino',
  `id_centrocosto` int(10) NOT NULL,
  `id_centronegocio` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `id_solicita` int(10) NOT NULL,
  `id_autoriza` int(10) NOT NULL,
  `sw_autoriza` int(1) NOT NULL DEFAULT '0' COMMENT '0=no 1=si',
  `id_ejecuta` int(10) NOT NULL,
  `id_formapago` int(10) NOT NULL,
  `id_vendedor` int(10) NOT NULL,
  `id_tipopedido` int(1) NOT NULL,
  `id_formaentrega` int(1) NOT NULL COMMENT '0=parcial 1=total',
  `cuenta_origen` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'contracuenta de la contabilizacion ej. merc. nac v/s cuenta_origen',
  `orden_compra` varchar(64) COLLATE utf8_spanish_ci NOT NULL COMMENT '64 bytes para el cod o folio de la oc asociada al pedido',
  `cotizacion` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_sucursal` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `subtotal` int(10) NOT NULL,
  `descuento_porcentaje` decimal(12,2) NOT NULL,
  `descuento_porcentaje_exento` int(11) NOT NULL,
  `descuento_pesos` int(10) NOT NULL,
  `descuento_pesos_exento` int(11) NOT NULL,
  `neto` int(10) NOT NULL,
  `iva` int(10) NOT NULL,
  `total` int(10) NOT NULL,
  `suma_afecto` int(11) NOT NULL,
  `estado` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `observaciones_internas` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `direccion_despacho` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `comuna` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `giro` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `fono` varchar(15) COLLATE utf8_spanish_ci NOT NULL,
  `email` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `sw_exento` int(1) NOT NULL,
  `descuento_afecto` int(11) NOT NULL,
  `descuento_exento` int(11) NOT NULL,
  `suma_exento` int(11) NOT NULL,
  `neto_exento` int(11) NOT NULL,
  `montodescuento_exento` int(11) NOT NULL,
  `porcdescuento_exento` int(11) NOT NULL,
  UNIQUE KEY `folio` (`folio`),
  KEY `estado` (`estado`),
  KEY `fecha_ejecucion` (`fecha_ejecucion`),
  KEY `time_ejecucion` (`time_ejecucion`),
  KEY `cuenta_origen` (`cuenta_origen`),
  KEY `id_bodega` (`id_bodega`),
  KEY `sw_periodo` (`sw_periodo`),
  KEY `time_proceso` (`time_proceso`),
  KEY `id_usuario_proceso` (`id_usuario_proceso`),
  KEY `orden_compra` (`orden_compra`),
  KEY `sw_multiop` (`sw_multiop`),
  KEY `codigo_sucursal` (`codigo_sucursal`),
  KEY `rut` (`rut`),
  KEY `razon_social` (`razon_social`),
  KEY `direccion` (`direccion`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `contacto` (`contacto`),
  KEY `id_contacto` (`id_contacto`),
  KEY `id_formapago` (`id_formapago`),
  KEY `id_vendedor` (`id_vendedor`),
  KEY `fecha_solicitud` (`fecha_solicitud`),
  KEY `time_solicitud` (`time_solicitud`),
  KEY `id_tipopedido` (`id_tipopedido`),
  KEY `id_formaentrega` (`id_formaentrega`),
  KEY `cotizacion` (`cotizacion`),
  KEY `despacho_desde` (`despacho_desde`),
  KEY `time_desde` (`time_desde`),
  KEY `despacho_hasta` (`despacho_hasta`),
  KEY `time_hasta` (`time_hasta`),
  KEY `id_cliente` (`id_cliente`),
  KEY `fecha_proceso` (`fecha_proceso`),
  KEY `orden_sucursal` (`orden_sucursal`),
  KEY `prioridad_despacho` (`prioridad_despacho`),
  KEY `clase_sucursal` (`clase_sucursal`),
  KEY `id_proveedor` (`id_proveedor`),
  KEY `sw_autoriza` (`sw_autoriza`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenescompras`
--

LOCK TABLES `tbl_ordenescompras` WRITE;
/*!40000 ALTER TABLE `tbl_ordenescompras` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenescompras` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenescompras_detalle`
--

DROP TABLE IF EXISTS `tbl_ordenescompras_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenescompras_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `sw_periodo` int(1) NOT NULL,
  `id_usuario` int(10) NOT NULL COMMENT 'id del usuario creador de la linea 1=Sistema',
  `id_usuario_proceso` int(10) NOT NULL,
  `id_proveedor` int(10) NOT NULL,
  `time_creacion_registro` int(10) NOT NULL,
  `time_proceso` int(10) NOT NULL,
  `id_item` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `sw_exento` int(1) NOT NULL,
  `codigo` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_sku` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `prioridad_despacho` int(10) NOT NULL COMMENT 'orden de prioridad de despachos por nota de pedido',
  `clase_sucursal` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'Indica al boucher si la linea ha sido finalizada 1=Si 0=No',
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT 'ID del proyecto asociado a la linea contable que genero el cargo u/o abono',
  `id_vendedor` int(10) NOT NULL,
  `id_formaentrega` int(10) NOT NULL,
  `bultos` int(10) NOT NULL,
  `numero_lote` varchar(128) COLLATE utf8_spanish_ci NOT NULL,
  `numero_serie` varchar(128) COLLATE utf8_spanish_ci NOT NULL,
  `cantidad` decimal(12,2) NOT NULL,
  `reserva` decimal(12,2) NOT NULL,
  `embalado` decimal(12,2) NOT NULL,
  `facturado` decimal(12,2) NOT NULL,
  `recepcionado` decimal(12,2) NOT NULL,
  `pendiente` decimal(12,2) NOT NULL,
  `unitario` decimal(12,2) NOT NULL,
  `subtotal` int(10) NOT NULL,
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `orden_compra` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `folio` (`folio`),
  KEY `id_item` (`id_item`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `time_creacion_registro` (`time_creacion_registro`),
  KEY `tipo_item` (`tipo_item`),
  KEY `codigo` (`codigo`),
  KEY `sw_periodo` (`sw_periodo`),
  KEY `numero_lote` (`numero_lote`),
  KEY `numero_serie` (`numero_serie`),
  KEY `reserva` (`reserva`),
  KEY `time_proceso` (`time_proceso`),
  KEY `id_usuario_proceso` (`id_usuario_proceso`),
  KEY `orden_compra` (`orden_compra`),
  KEY `id_vendedor` (`id_vendedor`),
  KEY `id_formaentrega` (`id_formaentrega`),
  KEY `embalado` (`embalado`),
  KEY `facturado` (`facturado`),
  KEY `prioridad_despacho` (`prioridad_despacho`),
  KEY `codigo_sku` (`codigo_sku`),
  KEY `clase_sucursal` (`clase_sucursal`),
  KEY `id_proveedor` (`id_proveedor`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenescompras_detalle`
--

LOCK TABLES `tbl_ordenescompras_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_ordenescompras_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenescompras_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenescompras_origenes`
--

DROP TABLE IF EXISTS `tbl_ordenescompras_origenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenescompras_origenes` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT '1=activo 0=inactivo',
  `orden` int(10) NOT NULL,
  `codigo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `orden` (`orden`),
  KEY `codigo` (`codigo`),
  KEY `estado` (`estado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenescompras_origenes`
--

LOCK TABLES `tbl_ordenescompras_origenes` WRITE;
/*!40000 ALTER TABLE `tbl_ordenescompras_origenes` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenescompras_origenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenescorte`
--

DROP TABLE IF EXISTS `tbl_ordenescorte`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenescorte` (
  `id_transaccion` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion del comprobante contable',
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `folio_notapedido` int(10) NOT NULL,
  `folio_ordenproduccion` int(10) NOT NULL,
  `op_origen` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_pedido` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT 'fecha del pedido del cliente osea la orden de de compra',
  `fecha_solicitud` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT 'fecha en que fue solicitada la orden de corte',
  `fecha_inicio` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT 'fecha en la cual se inicio el proceso de tendido de tela para el corte',
  `fecha_termino` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT 'fecha termino del proceso de corte ( no incluye tiempo de tendido)',
  `fecha_tela` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `hora_inicio` varchar(5) COLLATE utf8_spanish_ci NOT NULL COMMENT 'HH:MM',
  `hora_termino` varchar(5) COLLATE utf8_spanish_ci NOT NULL COMMENT 'HH:MM',
  `id_categoria` int(10) NOT NULL COMMENT 'id categoria del producto final',
  `sw_aplicar_valor` int(1) NOT NULL COMMENT 'aplicar el valor de la categoria para el calculo de peso',
  `producto_destino` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `time_solicitud` int(10) NOT NULL,
  `time_inicio` int(10) NOT NULL,
  `time_termino` int(10) NOT NULL,
  `tiempo_tendido` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `tiempo_tizado` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `tiempo_reposo` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `tiempo_corte` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `largo_tizado` decimal(12,2) NOT NULL,
  `ancho_tizado` decimal(12,2) NOT NULL,
  `capas_tizado` int(10) NOT NULL,
  `porc_perdida_estimada` decimal(12,2) NOT NULL COMMENT 'PORCENTAJE DE PERDIDA ESTIMADA DEL TIZADO',
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL,
  `id_bodega` int(10) NOT NULL COMMENT 'id bodega de destino',
  `id_centrocosto` int(10) NOT NULL,
  `id_centronegocio` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `id_solicita` int(10) NOT NULL,
  `id_autoriza` int(10) NOT NULL,
  `id_ejecuta` int(10) NOT NULL,
  `id_tendedor` int(11) NOT NULL COMMENT '10',
  `id_tizador` int(11) NOT NULL COMMENT '10',
  `id_cortador` int(10) NOT NULL,
  `id_origen` int(10) NOT NULL,
  `id_formaentrega` int(10) NOT NULL,
  `id_proveedor` int(10) NOT NULL,
  `id_proceso` int(10) NOT NULL COMMENT 'id del proceso de la produccion por ej. confeccion, teñido, estampado, corte, etc...',
  `time_modificacion` int(10) NOT NULL,
  `id_modificacion` int(10) NOT NULL,
  `rut_proveedor` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `razon_social_proveedor` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `contacto_proveedor` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `cuenta_origen` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'contracuenta de la contabilizacion ej. merc. nac v/s cuenta_origen',
  `orden_compra` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_item` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `total` int(10) NOT NULL,
  `costo_total_estimado` int(10) NOT NULL COMMENT 'costo total de la orden de produccion',
  `costo_total_consumido` int(10) NOT NULL COMMENT 'costo total consumido de la op',
  `estado` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `estado_produccion` int(1) NOT NULL COMMENT '0=sin iniciar 1=iniciada 2=finalizada',
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `sw_material_reserva` int(1) NOT NULL,
  `sw_material_pendiente` int(1) NOT NULL,
  `sw_oporigen` int(1) NOT NULL,
  `merma_puntas` decimal(12,2) NOT NULL,
  `merma_recorte` decimal(12,2) NOT NULL,
  `merma_fallada` decimal(12,2) NOT NULL,
  `total_merma` decimal(12,2) NOT NULL,
  `p1` decimal(12,2) NOT NULL,
  `p2` decimal(12,2) NOT NULL,
  `p3` decimal(12,2) NOT NULL,
  `p4` decimal(12,2) NOT NULL,
  `p5` decimal(12,2) NOT NULL,
  `p6` decimal(12,2) NOT NULL,
  `p7` decimal(12,2) NOT NULL,
  `p8` decimal(12,2) NOT NULL,
  `p9` decimal(12,2) NOT NULL,
  `p10` decimal(12,2) NOT NULL,
  `peso_tallas` decimal(12,2) NOT NULL COMMENT 'peso total de todas las tallas',
  `t1` varchar(11) COLLATE utf8_spanish_ci NOT NULL,
  `t2` varchar(11) COLLATE utf8_spanish_ci NOT NULL,
  `t3` varchar(11) COLLATE utf8_spanish_ci NOT NULL,
  `t4` varchar(11) COLLATE utf8_spanish_ci NOT NULL,
  `t5` varchar(11) COLLATE utf8_spanish_ci NOT NULL,
  `t6` varchar(11) COLLATE utf8_spanish_ci NOT NULL,
  `t7` varchar(11) COLLATE utf8_spanish_ci NOT NULL,
  `t8` varchar(11) COLLATE utf8_spanish_ci NOT NULL,
  `t9` varchar(11) COLLATE utf8_spanish_ci NOT NULL,
  `t10` varchar(11) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `folio` (`folio`),
  KEY `estado` (`estado`),
  KEY `id_sucursal` (`id_sucursal`,`id_centrocosto`,`id_centronegocio`,`id_proyecto`),
  KEY `id_solicita` (`id_solicita`,`id_autoriza`,`id_ejecuta`),
  KEY `cuenta_origen` (`cuenta_origen`),
  KEY `id_bodega` (`id_bodega`),
  KEY `estado_produccion` (`estado_produccion`),
  KEY `id_origen` (`id_origen`),
  KEY `codigo_item` (`codigo_item`),
  KEY `orden_compra` (`orden_compra`),
  KEY `folio_notapedido` (`folio_notapedido`),
  KEY `id_formaentrega` (`id_formaentrega`),
  KEY `rut_proveedor` (`rut_proveedor`),
  KEY `razon_social_proveedor` (`razon_social_proveedor`),
  KEY `contacto_proveedor` (`contacto_proveedor`),
  KEY `id_proveedor` (`id_proveedor`),
  KEY `id_proceso` (`id_proceso`),
  KEY `sw_material_reserva` (`sw_material_reserva`),
  KEY `sw_material_pendiente` (`sw_material_pendiente`),
  KEY `sw_oporigen` (`sw_oporigen`),
  KEY `op_origen` (`op_origen`),
  KEY `time_modificacion` (`time_modificacion`),
  KEY `fecha_tela` (`fecha_tela`),
  KEY `id_categoria` (`id_categoria`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenescorte`
--

LOCK TABLES `tbl_ordenescorte` WRITE;
/*!40000 ALTER TABLE `tbl_ordenescorte` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenescorte` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenescorte_detalle`
--

DROP TABLE IF EXISTS `tbl_ordenescorte_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenescorte_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `folio_notapedido` int(10) NOT NULL,
  `folio_ordenproduccion` int(10) NOT NULL,
  `id_usuario` int(10) NOT NULL COMMENT 'id del usuario creador de la linea 1=Sistema',
  `time_creacion_registro` int(10) NOT NULL,
  `fecha_solicitud` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `fecha_inicio` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_termino` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_pedido` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `producto_destino` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `time_solicitud` int(10) NOT NULL,
  `time_inicio` int(10) NOT NULL COMMENT 'ts de incio del corte',
  `time_termino` int(10) NOT NULL COMMENT 'ts del final del corte',
  `id_item` int(10) NOT NULL,
  `tipo_item` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `codigo` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_sku` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `id_bodega` int(10) NOT NULL,
  `id_cortador` int(10) NOT NULL,
  `id_modelista` int(10) NOT NULL,
  `id_proceso` int(10) NOT NULL COMMENT 'id del proceso de la produccion por ej. confeccion, teñido, estampado, corte, etc...',
  `rut_proveedor` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'Indica al boucher si la linea ha sido finalizada 1=Si 0=No',
  `estado_produccion` int(1) NOT NULL COMMENT '0=sin iniciar 1=iniciada 2=finalizada',
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT 'ID del proyecto asociado a la linea contable que genero el cargo u/o abono',
  `cantidad_solicitada` decimal(12,2) NOT NULL COMMENT 'cantidad con la que se origino la orden de prod. cuando es generada desde una nota de pedido',
  `cantidad` decimal(12,2) NOT NULL COMMENT 'cantidad de capas',
  `cantidad_estimada` decimal(12,2) NOT NULL COMMENT 'cantidad de tela estimada para tipo de tela',
  `cantidad_reservada` decimal(12,2) NOT NULL COMMENT 'cantidad de tela reservada',
  `cantidad_prendas` int(10) NOT NULL COMMENT 'cantidad de prendas a producir',
  `cantidad_estado2` decimal(12,2) NOT NULL,
  `cantidad_estado3` decimal(12,2) NOT NULL,
  `cantidad_recepcionada` decimal(12,2) NOT NULL,
  `cantidad_pendiente` decimal(12,2) NOT NULL,
  `cantidad_merma` decimal(12,2) NOT NULL,
  `unitario` decimal(12,2) NOT NULL,
  `subtotal` decimal(12,2) NOT NULL,
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `orden_compra` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `talla_01` int(10) NOT NULL,
  `talla_02` int(10) NOT NULL,
  `talla_03` int(10) NOT NULL,
  `talla_04` int(10) NOT NULL,
  `talla_05` int(10) NOT NULL,
  `talla_06` int(10) NOT NULL,
  `talla_07` int(10) NOT NULL,
  `talla_08` int(10) NOT NULL,
  `talla_09` int(10) NOT NULL,
  `talla_10` int(10) NOT NULL,
  `total` int(10) NOT NULL COMMENT 'suma de todas las tallas de la fila',
  UNIQUE KEY `id` (`id`),
  KEY `folio` (`folio`),
  KEY `id_item` (`id_item`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `time_creacion_registro` (`time_creacion_registro`),
  KEY `codigo` (`codigo`),
  KEY `estado_produccion` (`estado_produccion`),
  KEY `orden_compra` (`orden_compra`),
  KEY `cantidad_recepcionada` (`cantidad_recepcionada`),
  KEY `cantidad_pendiente` (`cantidad_pendiente`),
  KEY `folio_notapedido` (`folio_notapedido`),
  KEY `id_bodega` (`id_bodega`),
  KEY `rut_proveedor` (`rut_proveedor`),
  KEY `id_proceso` (`id_proceso`),
  KEY `codigo_sku` (`codigo_sku`),
  KEY `fecha_solicitud` (`fecha_solicitud`),
  KEY `time_solicitud` (`time_solicitud`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`),
  KEY `time_inicio` (`time_inicio`),
  KEY `time_termino` (`time_termino`),
  KEY `id_modelista` (`id_modelista`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenescorte_detalle`
--

LOCK TABLES `tbl_ordenescorte_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_ordenescorte_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenescorte_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenescorte_estadosavance`
--

DROP TABLE IF EXISTS `tbl_ordenescorte_estadosavance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenescorte_estadosavance` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL DEFAULT '1',
  `ordenamiento` int(10) NOT NULL,
  `codigo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `codigo` (`codigo`),
  KEY `descripcion` (`descripcion`),
  KEY `ordenamiento` (`ordenamiento`),
  KEY `estado` (`estado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenescorte_estadosavance`
--

LOCK TABLES `tbl_ordenescorte_estadosavance` WRITE;
/*!40000 ALTER TABLE `tbl_ordenescorte_estadosavance` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenescorte_estadosavance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenesdetrabajo_detalle_receta`
--

DROP TABLE IF EXISTS `tbl_ordenesdetrabajo_detalle_receta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenesdetrabajo_detalle_receta` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `id_item` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL COMMENT 'S=Servicio P=Producto M=Materia Prima I=Insumo',
  `codigo` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `cantidad` int(10) NOT NULL,
  `unitario` int(10) NOT NULL,
  `subtotal` int(10) NOT NULL,
  `nombre` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `id` (`id`),
  KEY `folio` (`folio`),
  KEY `id_item` (`id_item`),
  KEY `nombre` (`nombre`),
  KEY `tipo_item` (`tipo_item`),
  KEY `codigo` (`codigo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenesdetrabajo_detalle_receta`
--

LOCK TABLES `tbl_ordenesdetrabajo_detalle_receta` WRITE;
/*!40000 ALTER TABLE `tbl_ordenesdetrabajo_detalle_receta` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenesdetrabajo_detalle_receta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenesdetrabajo_motivos`
--

DROP TABLE IF EXISTS `tbl_ordenesdetrabajo_motivos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenesdetrabajo_motivos` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT '1=activo 0=inactivo',
  `orden` int(10) NOT NULL,
  `codigo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `orden` (`orden`),
  KEY `codigo` (`codigo`),
  KEY `estado` (`estado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenesdetrabajo_motivos`
--

LOCK TABLES `tbl_ordenesdetrabajo_motivos` WRITE;
/*!40000 ALTER TABLE `tbl_ordenesdetrabajo_motivos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenesdetrabajo_motivos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenesproduccion`
--

DROP TABLE IF EXISTS `tbl_ordenesproduccion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenesproduccion` (
  `id_transaccion` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion del comprobante contable',
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `folio_notapedido` int(10) NOT NULL,
  `op_origen` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_ejecucion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_pedido` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT 'fecha de despacho del pedido',
  `fecha_entrega` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_entrega_hasta` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_ejecucion` int(10) NOT NULL,
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL,
  `id_bodega` int(10) NOT NULL COMMENT 'id bodega de destino',
  `id_centrocosto` int(10) NOT NULL,
  `id_centronegocio` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `id_solicita` int(10) NOT NULL,
  `id_autoriza` int(10) NOT NULL,
  `id_ejecuta` int(10) NOT NULL,
  `id_origen` int(10) NOT NULL,
  `id_formaentrega` int(10) NOT NULL,
  `id_proveedor` int(10) NOT NULL,
  `id_proceso` int(10) NOT NULL COMMENT 'id del proceso de la produccion por ej. confeccion, teñido, estampado, corte, etc...',
  `time_modificacion` int(10) NOT NULL,
  `id_modificacion` int(10) NOT NULL,
  `rut_proveedor` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `razon_social_proveedor` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `contacto_proveedor` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `cuenta_origen` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'contracuenta de la contabilizacion ej. merc. nac v/s cuenta_origen',
  `orden_compra` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_item` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `total` int(10) NOT NULL,
  `costo_total_estimado` int(10) NOT NULL COMMENT 'costo total de la orden de produccion',
  `costo_total_consumido` int(10) NOT NULL COMMENT 'costo total consumido de la op',
  `estado` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `id_estado_produccion` int(10) NOT NULL COMMENT 'id del estado en el cual se encuentra actualmente la produccion',
  `estado_produccion` varchar(255) COLLATE utf8_spanish_ci NOT NULL COMMENT 'breve resumen que indique como va la caga de produccion',
  `observaciones` text COLLATE utf8_spanish_ci NOT NULL,
  `sw_material_reserva` int(1) NOT NULL,
  `sw_material_pendiente` int(1) NOT NULL,
  `sw_oporigen` int(1) NOT NULL,
  UNIQUE KEY `folio` (`folio`),
  KEY `estado` (`estado`),
  KEY `id_sucursal` (`id_sucursal`,`id_centrocosto`,`id_centronegocio`,`id_proyecto`),
  KEY `fecha_ejecucion` (`fecha_ejecucion`),
  KEY `time_ejecucion` (`time_ejecucion`),
  KEY `id_solicita` (`id_solicita`,`id_autoriza`,`id_ejecuta`),
  KEY `cuenta_origen` (`cuenta_origen`),
  KEY `id_bodega` (`id_bodega`),
  KEY `id_origen` (`id_origen`),
  KEY `codigo_item` (`codigo_item`),
  KEY `orden_compra` (`orden_compra`),
  KEY `folio_notapedido` (`folio_notapedido`),
  KEY `id_formaentrega` (`id_formaentrega`),
  KEY `rut_proveedor` (`rut_proveedor`),
  KEY `razon_social_proveedor` (`razon_social_proveedor`),
  KEY `contacto_proveedor` (`contacto_proveedor`),
  KEY `id_proveedor` (`id_proveedor`),
  KEY `id_proceso` (`id_proceso`),
  KEY `sw_material_reserva` (`sw_material_reserva`),
  KEY `sw_material_pendiente` (`sw_material_pendiente`),
  KEY `sw_oporigen` (`sw_oporigen`),
  KEY `op_origen` (`op_origen`),
  KEY `time_modificacion` (`time_modificacion`),
  KEY `fecha_pedido` (`fecha_pedido`),
  KEY `id_estado_produccion` (`id_estado_produccion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenesproduccion`
--

LOCK TABLES `tbl_ordenesproduccion` WRITE;
/*!40000 ALTER TABLE `tbl_ordenesproduccion` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenesproduccion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenesproduccion_corte`
--

DROP TABLE IF EXISTS `tbl_ordenesproduccion_corte`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenesproduccion_corte` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio_ordenproduccion` int(10) NOT NULL,
  `codigo` varchar(32) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codigo_final` varchar(32) NOT NULL COMMENT 'codigo del item final de la op asociada a la tela seleccionada',
  `tizado_largo` decimal(12,2) NOT NULL,
  `tizado_ancho` decimal(12,2) NOT NULL,
  `tizado_capas` decimal(12,2) NOT NULL,
  `merma_puntas` decimal(12,2) NOT NULL,
  `merma_recorte` decimal(12,2) NOT NULL,
  `merma_fallada` decimal(12,2) NOT NULL,
  `talla_rn` decimal(12,2) NOT NULL,
  `talla_3m` decimal(12,2) NOT NULL,
  `talla_6m` decimal(12,2) NOT NULL,
  `talla_9m` int(10) NOT NULL,
  `talla_12m` decimal(12,2) NOT NULL,
  `talla_18m` decimal(12,2) NOT NULL,
  `talla_24m` decimal(12,2) NOT NULL,
  `talla_36m` decimal(12,2) NOT NULL,
  `curva_rn` int(10) NOT NULL,
  `curva_3m` int(10) NOT NULL,
  `curva_6m` int(10) NOT NULL,
  `curva_9m` int(10) NOT NULL,
  `curva_12m` int(10) NOT NULL,
  `curva_18m` int(10) NOT NULL,
  `curva_24m` int(10) NOT NULL,
  `curva_36m` int(10) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`),
  KEY `codigo` (`codigo`),
  KEY `codigo_final` (`codigo_final`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenesproduccion_corte`
--

LOCK TABLES `tbl_ordenesproduccion_corte` WRITE;
/*!40000 ALTER TABLE `tbl_ordenesproduccion_corte` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenesproduccion_corte` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenesproduccion_curvas`
--

DROP TABLE IF EXISTS `tbl_ordenesproduccion_curvas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenesproduccion_curvas` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio_ordenproduccion` int(10) NOT NULL,
  `curva_rn` int(10) NOT NULL,
  `curva_3m` int(10) NOT NULL,
  `curva_6m` int(10) NOT NULL,
  `curva_9m` int(10) NOT NULL,
  `curva_12m` int(10) NOT NULL,
  `curva_18m` int(10) NOT NULL,
  `curva_24m` int(10) NOT NULL,
  `curva_36m` int(10) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenesproduccion_curvas`
--

LOCK TABLES `tbl_ordenesproduccion_curvas` WRITE;
/*!40000 ALTER TABLE `tbl_ordenesproduccion_curvas` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenesproduccion_curvas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenesproduccion_detalle`
--

DROP TABLE IF EXISTS `tbl_ordenesproduccion_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenesproduccion_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `folio_notapedido` int(10) NOT NULL,
  `id_usuario` int(10) NOT NULL COMMENT 'id del usuario creador de la linea 1=Sistema',
  `time_creacion_registro` int(10) NOT NULL,
  `fecha_solicitud` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '' COMMENT 'fecha de OP',
  `fecha_pedido` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT 'fecha de despacho del pedido',
  `fecha_entrega_desde` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT 'fecha inicio de produccion',
  `fecha_entrega_hasta` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT 'fecha termino de produccion',
  `time_solicitud` int(10) NOT NULL,
  `id_item` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `codigo` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_sku` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `id_bodega` int(10) NOT NULL,
  `id_proveedor` int(10) NOT NULL,
  `id_proceso` int(10) NOT NULL COMMENT 'id del proceso de la produccion por ej. confeccion, teñido, estampado, corte, etc...',
  `rut_proveedor` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'Indica al boucher si la linea ha sido finalizada 1=Si 0=No',
  `estado_produccion` int(1) NOT NULL COMMENT '0=sin iniciar 1=iniciada 2=finalizada',
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT 'ID del proyecto asociado a la linea contable que genero el cargo u/o abono',
  `cantidad_solicitada` decimal(12,2) NOT NULL COMMENT 'cantidad con la que se origino la orden de prod. cuando es generada desde una nota de pedido',
  `cantidad` decimal(12,2) NOT NULL,
  `bultos` int(10) NOT NULL,
  `cantidad_estado1` decimal(12,2) NOT NULL,
  `cantidad_estado2` decimal(12,2) NOT NULL,
  `cantidad_estado3` decimal(12,2) NOT NULL,
  `cantidad_recepcionada` decimal(12,2) NOT NULL,
  `cantidad_pendiente` decimal(12,2) NOT NULL,
  `cantidad_merma` decimal(12,2) NOT NULL,
  `unitario` decimal(12,2) NOT NULL,
  `subtotal` decimal(12,2) NOT NULL,
  `prioridad` int(10) NOT NULL COMMENT '1=alta 2=media 3=baja',
  `id_estado_avance` int(10) NOT NULL,
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `orden_compra` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `folio` (`folio`),
  KEY `id_item` (`id_item`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `time_creacion_registro` (`time_creacion_registro`),
  KEY `tipo_item` (`tipo_item`),
  KEY `codigo` (`codigo`),
  KEY `estado_produccion` (`estado_produccion`),
  KEY `orden_compra` (`orden_compra`),
  KEY `cantidad_recepcionada` (`cantidad_recepcionada`),
  KEY `cantidad_pendiente` (`cantidad_pendiente`),
  KEY `folio_notapedido` (`folio_notapedido`),
  KEY `id_bodega` (`id_bodega`),
  KEY `id_proveedor` (`id_proveedor`),
  KEY `rut_proveedor` (`rut_proveedor`),
  KEY `id_proceso` (`id_proceso`),
  KEY `codigo_sku` (`codigo_sku`),
  KEY `fecha_solicitud` (`fecha_solicitud`),
  KEY `time_solicitud` (`time_solicitud`),
  KEY `fecha_pedido` (`fecha_pedido`),
  KEY `fecha_entrega_desde` (`fecha_entrega_desde`),
  KEY `fecha_entrega_hasta` (`fecha_entrega_hasta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenesproduccion_detalle`
--

LOCK TABLES `tbl_ordenesproduccion_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_ordenesproduccion_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenesproduccion_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenesproduccion_estados`
--

DROP TABLE IF EXISTS `tbl_ordenesproduccion_estados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenesproduccion_estados` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `orden` int(10) NOT NULL,
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `orden` (`orden`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenesproduccion_estados`
--

LOCK TABLES `tbl_ordenesproduccion_estados` WRITE;
/*!40000 ALTER TABLE `tbl_ordenesproduccion_estados` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenesproduccion_estados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenesproduccion_historial`
--

DROP TABLE IF EXISTS `tbl_ordenesproduccion_historial`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenesproduccion_historial` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `time_reporte` int(10) NOT NULL,
  `id_usuario` int(10) NOT NULL,
  `op` int(10) NOT NULL,
  `campo` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `valor` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `time_reporte` (`time_reporte`),
  KEY `id_usuario` (`id_usuario`),
  KEY `op` (`op`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenesproduccion_historial`
--

LOCK TABLES `tbl_ordenesproduccion_historial` WRITE;
/*!40000 ALTER TABLE `tbl_ordenesproduccion_historial` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenesproduccion_historial` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenesproduccion_materialpendiente`
--

DROP TABLE IF EXISTS `tbl_ordenesproduccion_materialpendiente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenesproduccion_materialpendiente` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio_op` int(10) NOT NULL,
  `codigo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_proveedor` int(10) NOT NULL,
  `orden_compra` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `cantidad` decimal(12,2) NOT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `folio_op` (`folio_op`),
  KEY `id_proveedor` (`id_proveedor`),
  KEY `orden_compra` (`orden_compra`),
  KEY `codigo` (`codigo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenesproduccion_materialpendiente`
--

LOCK TABLES `tbl_ordenesproduccion_materialpendiente` WRITE;
/*!40000 ALTER TABLE `tbl_ordenesproduccion_materialpendiente` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenesproduccion_materialpendiente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenesproduccion_recepcion`
--

DROP TABLE IF EXISTS `tbl_ordenesproduccion_recepcion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenesproduccion_recepcion` (
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT 'EP',
  `time_creacion` int(10) NOT NULL,
  `usuario_creacion` int(10) NOT NULL,
  `usuario_proceso` int(10) NOT NULL,
  `time_proceso` int(10) NOT NULL,
  `folio_notapedido` int(10) NOT NULL,
  `folio_ordenproduccion` int(10) NOT NULL,
  `folio_recepcion` int(10) NOT NULL,
  `folio_factura` int(10) NOT NULL,
  `id_operador` int(10) NOT NULL COMMENT 'id del empleado que ejecuta el despacho',
  `numero_lote` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `cantidad_bultos` int(10) NOT NULL,
  UNIQUE KEY `folio` (`folio`),
  KEY `folio_notapedido` (`folio_notapedido`),
  KEY `estado` (`estado`),
  KEY `time_creacion` (`time_creacion`),
  KEY `usuario_creacion` (`usuario_creacion`),
  KEY `id_operador` (`id_operador`),
  KEY `folio_factura` (`folio_factura`),
  KEY `usuario_proceso` (`usuario_proceso`),
  KEY `time_proceso` (`time_proceso`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`),
  KEY `folio_recepcion` (`folio_recepcion`),
  KEY `numero_lote` (`numero_lote`),
  KEY `cantidad_bultos` (`cantidad_bultos`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenesproduccion_recepcion`
--

LOCK TABLES `tbl_ordenesproduccion_recepcion` WRITE;
/*!40000 ALTER TABLE `tbl_ordenesproduccion_recepcion` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenesproduccion_recepcion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenesproduccion_recepcion_detalle`
--

DROP TABLE IF EXISTS `tbl_ordenesproduccion_recepcion_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenesproduccion_recepcion_detalle` (
  `id_registro` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL COMMENT '???',
  `folio_ordenproduccion` int(10) NOT NULL,
  `folio_recepcion` int(10) NOT NULL,
  `orden_compra` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `folio_notapedido` int(10) NOT NULL,
  `folio_despacho` int(10) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `folio_factura` int(10) NOT NULL,
  `codigo_bulto` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `id_item_bulto` int(10) NOT NULL COMMENT 'id item del bulto',
  `codigo_item` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `cantidad` decimal(12,2) NOT NULL,
  `codigo_operador` int(10) NOT NULL,
  `operador_modificador` int(10) NOT NULL COMMENT 'codigo del operador que modifico el despacho del pedido',
  `lote` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `bultos` int(10) NOT NULL DEFAULT '0',
  `cantidad_bultos` int(10) NOT NULL,
  UNIQUE KEY `id_registro` (`id_registro`),
  KEY `codigo_item` (`codigo_item`),
  KEY `cantidad` (`cantidad`),
  KEY `orden_compra` (`orden_compra`),
  KEY `folio_factura` (`folio_factura`),
  KEY `codigo_operador` (`codigo_operador`),
  KEY `operador_modificador` (`operador_modificador`),
  KEY `estado` (`estado`),
  KEY `folio` (`folio`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`),
  KEY `folio_recepcion` (`folio_recepcion`),
  KEY `lote` (`lote`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenesproduccion_recepcion_detalle`
--

LOCK TABLES `tbl_ordenesproduccion_recepcion_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_ordenesproduccion_recepcion_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenesproduccion_recepcion_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenesproduccion_receta`
--

DROP TABLE IF EXISTS `tbl_ordenesproduccion_receta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenesproduccion_receta` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio_op` int(10) NOT NULL,
  `id_proveedor` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `codigo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `cantidad_requerida` decimal(17,7) NOT NULL,
  `cantidad_consumida` decimal(17,7) NOT NULL,
  `cantidad_reservada` decimal(17,7) NOT NULL,
  `cantidad_pendiente` decimal(17,7) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `id_proveedor` (`id_proveedor`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenesproduccion_receta`
--

LOCK TABLES `tbl_ordenesproduccion_receta` WRITE;
/*!40000 ALTER TABLE `tbl_ordenesproduccion_receta` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenesproduccion_receta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ordenesproduccion_servicios`
--

DROP TABLE IF EXISTS `tbl_ordenesproduccion_servicios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ordenesproduccion_servicios` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_usuario_asigno` int(10) NOT NULL,
  `time_asigno` int(10) NOT NULL,
  `folio_op` int(10) NOT NULL,
  `fecha_op` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_op` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `id_proceso` int(10) NOT NULL,
  `guia_despacho` int(10) NOT NULL,
  `item_op` int(10) NOT NULL,
  `codigo_final` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_servicio` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `unitario` decimal(12,2) NOT NULL,
  `cantidad` decimal(12,2) NOT NULL,
  `recepcionado` decimal(12,2) NOT NULL,
  `pendiente` decimal(12,2) NOT NULL,
  `id_proveedor` int(10) NOT NULL,
  `talla` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `color` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `folio_op` (`folio_op`),
  KEY `codigo_final` (`codigo_final`),
  KEY `codigo_servicio` (`codigo_servicio`),
  KEY `id_proveedor` (`id_proveedor`),
  KEY `id_usuario_asigno` (`id_usuario_asigno`),
  KEY `time_asigno` (`time_asigno`),
  KEY `talla` (`talla`),
  KEY `color` (`color`),
  KEY `fecha_op` (`fecha_op`),
  KEY `time_op` (`time_op`),
  KEY `id_proyecto` (`id_proyecto`),
  KEY `id_proceso` (`id_proceso`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ordenesproduccion_servicios`
--

LOCK TABLES `tbl_ordenesproduccion_servicios` WRITE;
/*!40000 ALTER TABLE `tbl_ordenesproduccion_servicios` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ordenesproduccion_servicios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_pagosclientes`
--

DROP TABLE IF EXISTS `tbl_pagosclientes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_pagosclientes` (
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `folio_boleta` int(10) NOT NULL COMMENT 'folio del documento que esta cancelando',
  `matricula` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'numero de la matricula para version educacional',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `id_creador` int(10) NOT NULL,
  `time_creacion` int(10) NOT NULL,
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `razon_social` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_pago` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_cheque` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `forma_pago` int(10) NOT NULL,
  `codigo_banco` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `folio_cheque` int(10) NOT NULL,
  `codigo_caja` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `total_pago` int(10) NOT NULL COMMENT 'monto total del pago realizado',
  `cuota` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'version educacional',
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `folio` (`folio`),
  KEY `folio_boleta` (`folio_boleta`),
  KEY `matricula` (`matricula`),
  KEY `cuota` (`cuota`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_pagosclientes`
--

LOCK TABLES `tbl_pagosclientes` WRITE;
/*!40000 ALTER TABLE `tbl_pagosclientes` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_pagosclientes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_pagosclientes_detalle`
--

DROP TABLE IF EXISTS `tbl_pagosclientes_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_pagosclientes_detalle` (
  `id_registro` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `id_item` int(10) NOT NULL,
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `folio_factura` int(10) NOT NULL,
  `monto` int(10) NOT NULL,
  UNIQUE KEY `id_registro` (`id_registro`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_pagosclientes_detalle`
--

LOCK TABLES `tbl_pagosclientes_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_pagosclientes_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_pagosclientes_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_pagosproveedores`
--

DROP TABLE IF EXISTS `tbl_pagosproveedores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_pagosproveedores` (
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `id_creador` int(10) NOT NULL,
  `time_creacion` int(10) NOT NULL,
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `razon_social` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_pago` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_cheque` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `forma_pago` int(10) NOT NULL,
  `codigo_banco` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `folio_cheque` int(10) NOT NULL,
  `codigo_caja` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `total_pago` int(10) NOT NULL COMMENT 'monto total del pago realizado',
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `folio` (`folio`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_pagosproveedores`
--

LOCK TABLES `tbl_pagosproveedores` WRITE;
/*!40000 ALTER TABLE `tbl_pagosproveedores` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_pagosproveedores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_pagosproveedores_detalle`
--

DROP TABLE IF EXISTS `tbl_pagosproveedores_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_pagosproveedores_detalle` (
  `id_registro` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `id_item` int(10) NOT NULL,
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `folio_factura` int(10) NOT NULL,
  `monto` int(10) NOT NULL,
  UNIQUE KEY `id_registro` (`id_registro`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_pagosproveedores_detalle`
--

LOCK TABLES `tbl_pagosproveedores_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_pagosproveedores_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_pagosproveedores_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_pagostarjeta`
--

DROP TABLE IF EXISTS `tbl_pagostarjeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_pagostarjeta` (
  `id_registro` int(10) NOT NULL,
  `id_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'almacena el timestamp unix del momento cuando se puso listo al pedido',
  `id_bodega` int(10) NOT NULL DEFAULT '0' COMMENT 'id de la bodega de donde se rebajara el inventario',
  `id_sucursal_venta` int(10) NOT NULL,
  `asiento_apertura` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `facturada` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `contabilizada` int(1) NOT NULL DEFAULT '0' COMMENT 'indica si la emision de la factura ya fue contabilizada 1=si 0=no',
  `cancelada` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'VA=venta anticipada CC=cuenta corriente',
  `folio_final` int(10) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `tipo_facturacion` int(1) NOT NULL DEFAULT '0' COMMENT '0=facturacion desde notas de venta 1=FACTURACION DESDE GUIAS DE DESPACHO 2=facturacion manual',
  `anulada` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `fecha_anulacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_cotizacion` int(10) NOT NULL DEFAULT '0',
  `folio_notaventa` int(10) NOT NULL DEFAULT '0',
  `folio_despacho` int(10) NOT NULL DEFAULT '0',
  `folio_ruta` int(10) NOT NULL DEFAULT '0',
  `folio_guiadespacho` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_ordencompra` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `rut_vendedor` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `id_vendedor` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `exenta` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `electronica` int(1) NOT NULL DEFAULT '0',
  `id_relacion` int(10) NOT NULL DEFAULT '0',
  `tipo_cliente` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'E=Empresa U=Universidad',
  `proyecto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT '0=Sin proyecto',
  `id_empresa` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL DEFAULT '0',
  `id_laboratorio` int(10) NOT NULL DEFAULT '0',
  `id_investigador` int(10) NOT NULL DEFAULT '0',
  `id_contacto` int(10) NOT NULL DEFAULT '0',
  `id_despacho` int(10) NOT NULL DEFAULT '0',
  `id_region` int(10) NOT NULL DEFAULT '0',
  `id_ciudad` int(10) NOT NULL DEFAULT '0',
  `id_comuna` int(10) NOT NULL DEFAULT '0',
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `razon_social` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_fantasia` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `giro` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefonos` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `region` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `ciudad` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `comuna` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_contacto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_investigador` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `atencion_facturacion` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_contacto` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_investigador` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_facturacion` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_proyecto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `tipo_factura` int(1) NOT NULL DEFAULT '0' COMMENT '0=normal 1=facturacion acticipada (VA)',
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_facturacion` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp con fecha y hora de emision de la factura',
  `fecha_vencimiento` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_vencimiento` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp con fecha y hora de vencimiento',
  `via_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion_despacho` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_despacho` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `atencion_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `cancela_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `subtotal` int(10) NOT NULL DEFAULT '0',
  `descuento_porc` int(2) NOT NULL DEFAULT '0' COMMENT 'D',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0',
  `neto` int(10) NOT NULL DEFAULT '0',
  `iva` int(10) NOT NULL DEFAULT '0',
  `bruto` int(10) NOT NULL DEFAULT '0',
  `cancelo` int(10) NOT NULL,
  `saldo_pendiente` int(10) NOT NULL DEFAULT '0',
  `saldo_va` int(10) NOT NULL DEFAULT '0' COMMENT 'indica el saldo disponible de las facturas va',
  `bruto_palabras` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'Total bruto escrito en palabras',
  `id_condiciones_venta` int(10) NOT NULL DEFAULT '0',
  `condiciones_venta` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT '1=Efectivo 2=Documentado 3=10 Dias 4=15 Dias 5=30 Dias 6=45 Dias 7=60 Dias 8=30/60 Dias 9=30/60/90 Dias',
  `observaciones` text COLLATE utf8_spanish_ci NOT NULL,
  `id_usuario_anulacion` int(10) NOT NULL DEFAULT '0',
  `id_anulacion` int(10) NOT NULL DEFAULT '0',
  `motivo_anulacion` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_usuario_modifico` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario que realizo la ultima modificacion',
  `id_modificacion` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp de la ultima modificacion',
  `documento_emision` int(1) NOT NULL,
  `cantidad_cuotas` int(2) NOT NULL,
  `folio_facturado` int(10) NOT NULL,
  `tipo_tarjeta` int(1) NOT NULL,
  UNIQUE KEY `folio_factura` (`folio_factura`),
  KEY `fecha_facturacion` (`fecha_facturacion`),
  KEY `id_factura` (`id_factura`),
  KEY `rut` (`rut`),
  KEY `id_relacion` (`id_relacion`),
  KEY `id_sucursal_venta` (`id_sucursal_venta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_pagostarjeta`
--

LOCK TABLES `tbl_pagostarjeta` WRITE;
/*!40000 ALTER TABLE `tbl_pagostarjeta` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_pagostarjeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_pagostarjeta_detalle`
--

DROP TABLE IF EXISTS `tbl_pagostarjeta_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_pagostarjeta_detalle` (
  `folio_factura` int(10) NOT NULL DEFAULT '0',
  `id_sucursal_venta` int(10) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `folio_guiadespacho` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `anulada` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT '0=no 1=si',
  `id_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'id de la factura indica cuando se puso listo al pedido en bodega',
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `tipo_factura` int(1) NOT NULL DEFAULT '0' COMMENT '0=factura normal 1=facturacion anticipada',
  `id_facturacion` int(10) NOT NULL DEFAULT '0' COMMENT 'Solo para ordenamientos de fecha',
  `id_item` int(10) NOT NULL DEFAULT '0',
  `rut_vendedor` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_relacion` int(10) NOT NULL DEFAULT '0',
  `rut_cliente` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_producto` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'P=producto S=servicio C=cuenta',
  `sw_facturable` int(1) NOT NULL DEFAULT '1',
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `pmp` int(10) NOT NULL DEFAULT '0',
  `precio_referencial` int(10) NOT NULL DEFAULT '0' COMMENT 'Precio referencial al momento de pegar el item',
  `precio_venta` int(10) NOT NULL DEFAULT '0' COMMENT 'precio de venta',
  `precio_final_venta` int(10) NOT NULL DEFAULT '0' COMMENT 'precio de venta unitario con descuento lineal y global aplicado',
  `cantidad` int(10) NOT NULL DEFAULT '0',
  `cantidad_devuelta` int(10) NOT NULL DEFAULT '0' COMMENT 'cantidad de unidades devueltas por medio de una nota de credito',
  `subtotal` int(10) NOT NULL DEFAULT '0' COMMENT 'precio de venta x cantidad',
  `descuento_porc` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT 'porcentaje de descuento',
  `descuento_porc_global` decimal(5,2) NOT NULL DEFAULT '0.00',
  `subtotal_neto` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal con descuento lineal aplicado',
  `subtotal_final` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal con descuento lineal y global aplicado',
  `subtotal_costo` int(10) NOT NULL COMMENT 'pmp x cantidad',
  `comision_porcentaje` decimal(5,2) NOT NULL DEFAULT '0.00',
  `comision_pesos` int(10) NOT NULL DEFAULT '0',
  `comision_porcentaje_extra` decimal(5,2) NOT NULL DEFAULT '0.00',
  `comision_pesos_extra` int(10) NOT NULL DEFAULT '0',
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  KEY `folio_factura` (`folio_factura`),
  KEY `id_sucursal_venta` (`id_sucursal_venta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_pagostarjeta_detalle`
--

LOCK TABLES `tbl_pagostarjeta_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_pagostarjeta_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_pagostarjeta_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_paises`
--

DROP TABLE IF EXISTS `tbl_paises`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_paises` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT '1=activo 0=inactivo',
  `orden` int(10) NOT NULL,
  `codigo` char(3) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `codigo` (`codigo`),
  KEY `estado` (`estado`),
  KEY `descripcion` (`descripcion`),
  KEY `orden` (`orden`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_paises`
--

LOCK TABLES `tbl_paises` WRITE;
/*!40000 ALTER TABLE `tbl_paises` DISABLE KEYS */;
INSERT INTO `tbl_paises` VALUES (1,1,1,'CHI','Chile'),(2,1,2,'CHN','China'),(3,1,3,'JPN','Japon'),(4,1,4,'ESP','España'),(5,1,5,'BR','Brazil'),(6,1,6,'PE','Perú');
/*!40000 ALTER TABLE `tbl_paises` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_partediario`
--

DROP TABLE IF EXISTS `tbl_partediario`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_partediario` (
  `id_ordencompra` int(10) NOT NULL DEFAULT '0' COMMENT 'timestamp con fecha de creacion de la oc',
  `folio_ordencompra` int(10) NOT NULL AUTO_INCREMENT,
  `id_proveedor` int(10) NOT NULL DEFAULT '0',
  `id_contacto` int(10) NOT NULL DEFAULT '0' COMMENT 'id del contacto del proveedor',
  `id_usuario` int(10) NOT NULL DEFAULT '0' COMMENT 'Usuario que creo la cotizacion',
  `id_proyecto` int(10) NOT NULL,
  `id_maquina` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_bodega` int(10) NOT NULL,
  `id_encargado` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `rut` varchar(12) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `razon_social` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'razon social del proveedor',
  `nombre_fantasia` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_ruta` int(10) NOT NULL DEFAULT '0',
  `time_partediario` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora del parte diario',
  `fecha_partediario` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'fecha del parte diario',
  `turno1` varchar(15) COLLATE utf8_spanish_ci NOT NULL,
  `turno2` varchar(15) COLLATE utf8_spanish_ci NOT NULL,
  `horometro_entrada` int(10) NOT NULL,
  `horometro_salida` int(10) NOT NULL,
  `usuario_envio` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario que envio la oc al proveedor',
  `usuario_recepciono` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario que recepciono la oc',
  `time_recepciono` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de recepcion de la oc',
  `id_lectura` int(10) NOT NULL DEFAULT '0' COMMENT 'timestamp de lectura del proveedor',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'EP=en proceso EN=enviada RE=recepcionada AN=anulada',
  `suma` int(10) NOT NULL DEFAULT '0',
  `descuento` int(2) NOT NULL DEFAULT '0' COMMENT 'porcentaje de descuento',
  `neto` int(10) NOT NULL DEFAULT '0',
  `iva` int(10) NOT NULL DEFAULT '0',
  `bruto` int(10) NOT NULL DEFAULT '0',
  `condiciones_pago` int(2) NOT NULL DEFAULT '0',
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `folio_ordencompra` (`folio_ordencompra`),
  KEY `id_ordencompra` (`id_ordencompra`),
  KEY `id_encargado` (`id_encargado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_partediario`
--

LOCK TABLES `tbl_partediario` WRITE;
/*!40000 ALTER TABLE `tbl_partediario` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_partediario` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_partediario_detalle`
--

DROP TABLE IF EXISTS `tbl_partediario_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_partediario_detalle` (
  `id_ordencompra` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion de la oc',
  `time_llegada` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp con fecha y hora de llegada del item',
  `folio_ordencompra` int(10) NOT NULL DEFAULT '0',
  `id_item` int(10) NOT NULL DEFAULT '0',
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'P=producto C=cuenta S=servicios  I=Insumo M=materiaprima  R=repuesto V=Varios',
  `id_proveedor` int(10) NOT NULL DEFAULT '0',
  `id_activofijo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL DEFAULT '0',
  `id_operador` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'EP=en proceso EN=enviada RE=recepcionada AN=anulada',
  `id_compra` int(10) NOT NULL DEFAULT '0' COMMENT 'almacena el timestamps del momento en que estan recibiendo una compra',
  `codigo_producto` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_catalogo` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'Codigo del producto del proveedor',
  `cantidad` int(10) NOT NULL DEFAULT '0' COMMENT 'Cantidad que se emitira en la orden de compra',
  `cantidad_pendiente` int(10) NOT NULL DEFAULT '0' COMMENT 'cantidad pendiente de compra',
  `cantidad_recepcionada` int(10) NOT NULL DEFAULT '0' COMMENT 'cantidad recepcionada por bodega',
  `precio_unitario` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'Precio referencial de lista',
  `subtotal` int(10) NOT NULL DEFAULT '0',
  `descuento_global` int(10) NOT NULL DEFAULT '0' COMMENT '% de descuento global aplicado a la oc',
  `unitario_final` int(10) NOT NULL DEFAULT '0' COMMENT 'unitario aplicando el descuento global',
  `subtotal_final` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal aplicando el descuento global',
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `horometro_inicio` int(10) NOT NULL,
  `horometro_fin` int(10) NOT NULL,
  `numero_report` int(10) NOT NULL,
  `observaciones_report` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `turno_report` varchar(50) COLLATE utf8_spanish_ci NOT NULL,
  KEY `folio_ordencompra` (`folio_ordencompra`),
  KEY `id_activofijo` (`id_activofijo`),
  KEY `id_proyecto` (`id_proyecto`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_partediario_detalle`
--

LOCK TABLES `tbl_partediario_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_partediario_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_partediario_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_partesentrada`
--

DROP TABLE IF EXISTS `tbl_partesentrada`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_partesentrada` (
  `id_transaccion` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion del comprobante contable',
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `sw_ok` int(11) NOT NULL COMMENT 'indica si el documento ha sido validado',
  `sw_periodo` int(1) NOT NULL COMMENT '0=abierto 1=cerrado ( corresponde al periodo abierto o cerrado)',
  `fecha_ejecucion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_ejecucion` int(10) NOT NULL,
  `tipo_documento` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `folio_documento` int(10) NOT NULL,
  `folio_ordencorte` int(10) NOT NULL,
  `folio_ordenproduccion` int(10) NOT NULL,
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL,
  `id_bodega` int(10) NOT NULL COMMENT 'id bodega de destino',
  `id_centrocosto` int(10) NOT NULL,
  `id_centronegocio` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `id_solicita` int(10) NOT NULL,
  `id_autoriza` int(10) NOT NULL,
  `id_ejecuta` int(10) NOT NULL,
  `cuenta_origen` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'contracuenta de la contabilizacion ej. merc. nac v/s cuenta_origen',
  `total` int(10) NOT NULL,
  `estado` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `folio` (`folio`),
  KEY `estado` (`estado`),
  KEY `id_sucursal` (`id_sucursal`,`id_centrocosto`,`id_centronegocio`,`id_proyecto`),
  KEY `fecha_ejecucion` (`fecha_ejecucion`),
  KEY `time_ejecucion` (`time_ejecucion`),
  KEY `id_solicita` (`id_solicita`,`id_autoriza`,`id_ejecuta`),
  KEY `cuenta_origen` (`cuenta_origen`),
  KEY `id_bodega` (`id_bodega`),
  KEY `sw_periodo` (`sw_periodo`),
  KEY `tipo_documento` (`tipo_documento`),
  KEY `folio_documento` (`folio_documento`),
  KEY `folio_ordencorte` (`folio_ordencorte`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`),
  KEY `sw_ok` (`sw_ok`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_partesentrada`
--

LOCK TABLES `tbl_partesentrada` WRITE;
/*!40000 ALTER TABLE `tbl_partesentrada` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_partesentrada` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_partesentrada_detalle`
--

DROP TABLE IF EXISTS `tbl_partesentrada_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_partesentrada_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `folio_ordencorte` int(10) NOT NULL,
  `folio_ordenproduccion` int(10) NOT NULL,
  `sw_periodo` int(1) NOT NULL,
  `id_usuario` int(10) NOT NULL COMMENT 'id del usuario creador de la linea 1=Sistema',
  `time_creacion_registro` int(10) NOT NULL,
  `id_item` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `codigo` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `tipo_documento` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `folio_documento` int(10) NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'Indica al boucher si la linea ha sido finalizada 1=Si 0=No',
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT 'ID del proyecto asociado a la linea contable que genero el cargo u/o abono',
  `bultos` int(10) NOT NULL,
  `numero_lote` varchar(128) COLLATE utf8_spanish_ci NOT NULL,
  `numero_serie` varchar(128) COLLATE utf8_spanish_ci NOT NULL,
  `id_zona` int(10) NOT NULL,
  `cantidad` decimal(12,2) NOT NULL,
  `unitario` decimal(12,2) NOT NULL,
  `subtotal` int(10) NOT NULL,
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `id` (`id`),
  KEY `folio` (`folio`),
  KEY `id_item` (`id_item`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `time_creacion_registro` (`time_creacion_registro`),
  KEY `tipo_item` (`tipo_item`),
  KEY `codigo` (`codigo`),
  KEY `sw_periodo` (`sw_periodo`),
  KEY `numero_lote` (`numero_lote`),
  KEY `numero_serie` (`numero_serie`),
  KEY `id_zona` (`id_zona`),
  KEY `tipo_documento` (`tipo_documento`),
  KEY `folio_documento` (`folio_documento`),
  KEY `folio_ordencorte` (`folio_ordencorte`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_partesentrada_detalle`
--

LOCK TABLES `tbl_partesentrada_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_partesentrada_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_partesentrada_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_partesrecepcion`
--

DROP TABLE IF EXISTS `tbl_partesrecepcion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_partesrecepcion` (
  `id_transaccion` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion del comprobante contable',
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `sw_periodo` int(1) NOT NULL COMMENT '0=abierto 1=cerrado ( corresponde al periodo abierto o cerrado)',
  `fecha_ejecucion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_ejecucion` int(10) NOT NULL,
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL,
  `id_bodega` int(10) NOT NULL COMMENT 'id bodega de destino',
  `id_centrocosto` int(10) NOT NULL,
  `id_centronegocio` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `id_solicita` int(10) NOT NULL,
  `id_autoriza` int(10) NOT NULL,
  `id_ejecuta` int(10) NOT NULL,
  `cuenta_origen` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'contracuenta de la contabilizacion ej. merc. nac v/s cuenta_origen',
  `total` int(10) NOT NULL,
  `estado` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `folio` (`folio`),
  KEY `estado` (`estado`),
  KEY `id_sucursal` (`id_sucursal`,`id_centrocosto`,`id_centronegocio`,`id_proyecto`),
  KEY `fecha_ejecucion` (`fecha_ejecucion`),
  KEY `time_ejecucion` (`time_ejecucion`),
  KEY `id_solicita` (`id_solicita`,`id_autoriza`,`id_ejecuta`),
  KEY `cuenta_origen` (`cuenta_origen`),
  KEY `id_bodega` (`id_bodega`),
  KEY `sw_periodo` (`sw_periodo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_partesrecepcion`
--

LOCK TABLES `tbl_partesrecepcion` WRITE;
/*!40000 ALTER TABLE `tbl_partesrecepcion` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_partesrecepcion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_partesrecepcion_detalle`
--

DROP TABLE IF EXISTS `tbl_partesrecepcion_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_partesrecepcion_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `sw_periodo` int(1) NOT NULL,
  `id_usuario` int(10) NOT NULL COMMENT 'id del usuario creador de la linea 1=Sistema',
  `time_creacion_registro` int(10) NOT NULL,
  `id_item` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `codigo` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'Indica al boucher si la linea ha sido finalizada 1=Si 0=No',
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT 'ID del proyecto asociado a la linea contable que genero el cargo u/o abono',
  `bultos` int(10) NOT NULL,
  `cantidad` decimal(12,2) NOT NULL,
  `unitario` decimal(12,2) NOT NULL,
  `subtotal` int(10) NOT NULL,
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `id` (`id`),
  KEY `folio` (`folio`),
  KEY `id_item` (`id_item`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `time_creacion_registro` (`time_creacion_registro`),
  KEY `tipo_item` (`tipo_item`),
  KEY `codigo` (`codigo`),
  KEY `sw_periodo` (`sw_periodo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_partesrecepcion_detalle`
--

LOCK TABLES `tbl_partesrecepcion_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_partesrecepcion_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_partesrecepcion_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_partessalida`
--

DROP TABLE IF EXISTS `tbl_partessalida`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_partessalida` (
  `id_transaccion` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion del comprobante contable',
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `sw_ok` int(1) NOT NULL COMMENT 'indica si ha sido validado 0=no 1=si',
  `folio_ordenproduccion` int(10) NOT NULL,
  `folio_ordencorte` int(10) NOT NULL,
  `id_item_ordenproduccion` int(10) NOT NULL,
  `folio_guiadespacho` int(10) NOT NULL,
  `fecha_ejecucion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_ejecucion` int(10) NOT NULL,
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL,
  `id_bodega` int(10) NOT NULL COMMENT 'id bodega de destino',
  `id_centrocosto` int(10) NOT NULL,
  `id_centronegocio` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `id_solicita` int(10) NOT NULL,
  `id_autoriza` int(10) NOT NULL,
  `id_ejecuta` int(10) NOT NULL,
  `id_proveedor` int(10) NOT NULL,
  `cuenta_origen` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'contracuenta de la contabilizacion ej. merc. nac v/s cuenta_origen',
  `total` int(10) NOT NULL,
  `estado` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `folio` (`folio`),
  KEY `estado` (`estado`),
  KEY `id_sucursal` (`id_sucursal`,`id_centrocosto`,`id_centronegocio`,`id_proyecto`),
  KEY `fecha_ejecucion` (`fecha_ejecucion`),
  KEY `time_ejecucion` (`time_ejecucion`),
  KEY `id_solicita` (`id_solicita`,`id_autoriza`,`id_ejecuta`),
  KEY `cuenta_origen` (`cuenta_origen`),
  KEY `id_bodega` (`id_bodega`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`),
  KEY `id_item_ordenproduccion` (`id_item_ordenproduccion`),
  KEY `folio_guiadespacho` (`folio_guiadespacho`),
  KEY `id_proveedor` (`id_proveedor`),
  KEY `folio_ordencorte` (`folio_ordencorte`),
  KEY `sw_ok` (`sw_ok`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_partessalida`
--

LOCK TABLES `tbl_partessalida` WRITE;
/*!40000 ALTER TABLE `tbl_partessalida` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_partessalida` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_partessalida_detalle`
--

DROP TABLE IF EXISTS `tbl_partessalida_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_partessalida_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `folio_ordenproduccion` int(10) NOT NULL,
  `id_item_ordenproduccion` int(10) NOT NULL,
  `folio_ordencorte` int(10) NOT NULL,
  `id_usuario` int(10) NOT NULL COMMENT 'id del usuario creador de la linea 1=Sistema',
  `time_creacion_registro` int(10) NOT NULL,
  `id_item` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `codigo` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'Indica al boucher si la linea ha sido finalizada 1=Si 0=No',
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT 'ID del proyecto asociado a la linea contable que genero el cargo u/o abono',
  `id_proveedor` int(10) NOT NULL,
  `cantidad` decimal(12,3) NOT NULL,
  `unitario` int(10) NOT NULL,
  `subtotal` int(10) NOT NULL,
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `numero_lote` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `numero_serie` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `folio` (`folio`),
  KEY `id_item` (`id_item`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `time_creacion_registro` (`time_creacion_registro`),
  KEY `tipo_item` (`tipo_item`),
  KEY `codigo` (`codigo`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`),
  KEY `id_item_ordenproduccion` (`id_item_ordenproduccion`),
  KEY `numero_lote` (`numero_lote`),
  KEY `numero_serie` (`numero_serie`),
  KEY `id_proveedor` (`id_proveedor`),
  KEY `folio_ordencorte` (`folio_ordencorte`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_partessalida_detalle`
--

LOCK TABLES `tbl_partessalida_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_partessalida_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_partessalida_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_partessalida_tipos`
--

DROP TABLE IF EXISTS `tbl_partessalida_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_partessalida_tipos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `firstname` varchar(100) CHARACTER SET latin1 NOT NULL,
  `age` int(11) DEFAULT NULL,
  `height` decimal(3,2) DEFAULT NULL,
  `id_continent` int(10) DEFAULT NULL COMMENT 'codigo de la cuenta contable',
  `id_country` char(2) CHARACTER SET latin1 DEFAULT NULL,
  `email` varchar(100) CHARACTER SET latin1 DEFAULT NULL,
  `freelance` tinyint(4) DEFAULT NULL,
  `lastvisit` date DEFAULT NULL,
  `website` varchar(100) CHARACTER SET latin1 DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci COMMENT='tipos de parte de salida (consumo op, ajuste inventario, otr';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_partessalida_tipos`
--

LOCK TABLES `tbl_partessalida_tipos` WRITE;
/*!40000 ALTER TABLE `tbl_partessalida_tipos` DISABLE KEYS */;
INSERT INTO `tbl_partessalida_tipos` VALUES (1,'Produccion','',NULL,NULL,101060102,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `tbl_partessalida_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_partestraspaso`
--

DROP TABLE IF EXISTS `tbl_partestraspaso`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_partestraspaso` (
  `id_transaccion` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion del comprobante contable',
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `sw_periodo` int(1) NOT NULL COMMENT '0=abierto 1=cerrado ( corresponde al periodo abierto o cerrado)',
  `fecha_ejecucion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_ejecucion` int(10) NOT NULL,
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL,
  `id_bodega_origen` int(10) NOT NULL COMMENT 'id bodega de destino',
  `id_bodega_destino` int(10) NOT NULL,
  `id_centrocosto` int(10) NOT NULL,
  `id_centronegocio` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `id_solicita` int(10) NOT NULL,
  `id_autoriza` int(10) NOT NULL,
  `id_ejecuta` int(10) NOT NULL,
  `cuenta_origen` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'contracuenta de la contabilizacion ej. merc. nac v/s cuenta_origen',
  `total` int(10) NOT NULL,
  `estado` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `folio` (`folio`),
  KEY `estado` (`estado`),
  KEY `id_sucursal` (`id_sucursal`,`id_centrocosto`,`id_centronegocio`,`id_proyecto`),
  KEY `fecha_ejecucion` (`fecha_ejecucion`),
  KEY `time_ejecucion` (`time_ejecucion`),
  KEY `id_solicita` (`id_solicita`,`id_autoriza`,`id_ejecuta`),
  KEY `sw_periodo` (`sw_periodo`),
  KEY `id_bodega_destino` (`id_bodega_destino`),
  KEY `id_bodega_origen` (`id_bodega_origen`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_partestraspaso`
--

LOCK TABLES `tbl_partestraspaso` WRITE;
/*!40000 ALTER TABLE `tbl_partestraspaso` DISABLE KEYS */;
INSERT INTO `tbl_partestraspaso` VALUES (1508533128,1,0,'20/10/2017',1508468400,7,0,1,1,0,0,0,2,3,2,'',0,'GR','');
/*!40000 ALTER TABLE `tbl_partestraspaso` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_partestraspaso_detalle`
--

DROP TABLE IF EXISTS `tbl_partestraspaso_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_partestraspaso_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `sw_periodo` int(1) NOT NULL,
  `id_usuario` int(10) NOT NULL COMMENT 'id del usuario creador de la linea 1=Sistema',
  `fecha_ejecucion` int(10) NOT NULL,
  `time_ejecucion` int(10) NOT NULL,
  `time_creacion_registro` int(10) NOT NULL,
  `id_item` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `codigo` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'Indica al boucher si la linea ha sido finalizada 1=Si 0=No',
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT 'ID del proyecto asociado a la linea contable que genero el cargo u/o abono',
  `id_bodega_origen` int(10) NOT NULL,
  `id_bodega_destino` int(10) NOT NULL,
  `cantidad` decimal(12,2) NOT NULL,
  `unitario` decimal(12,2) NOT NULL,
  `subtotal` int(10) NOT NULL,
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `id` (`id`),
  KEY `folio` (`folio`),
  KEY `id_item` (`id_item`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `time_creacion_registro` (`time_creacion_registro`),
  KEY `tipo_item` (`tipo_item`),
  KEY `codigo` (`codigo`),
  KEY `sw_periodo` (`sw_periodo`),
  KEY `id_bodega_origen` (`id_bodega_origen`,`id_bodega_destino`),
  KEY `fecha_ejecucion` (`fecha_ejecucion`,`time_ejecucion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_partestraspaso_detalle`
--

LOCK TABLES `tbl_partestraspaso_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_partestraspaso_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_partestraspaso_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_periodoslibros`
--

DROP TABLE IF EXISTS `tbl_periodoslibros`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_periodoslibros` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `orden` int(10) NOT NULL,
  `periodo` char(7) NOT NULL,
  `estado` int(1) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_periodoslibros`
--

LOCK TABLES `tbl_periodoslibros` WRITE;
/*!40000 ALTER TABLE `tbl_periodoslibros` DISABLE KEYS */;
INSERT INTO `tbl_periodoslibros` VALUES (1,1,'01/2023',1),(2,2,'02/2023',1),(3,3,'03/2023',1),(4,4,'04/2023',1),(5,5,'05/2023',1),(6,6,'06/2023',1),(7,7,'07/2023',1),(8,8,'08/2023',1),(9,9,'09/2023',1),(10,10,'10/2023',1);
/*!40000 ALTER TABLE `tbl_periodoslibros` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_plandecuentas`
--

DROP TABLE IF EXISTS `tbl_plandecuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_plandecuentas` (
  `id_cuenta` int(10) NOT NULL AUTO_INCREMENT,
  `id_nivel` int(1) NOT NULL DEFAULT '0',
  `id_padre` int(10) NOT NULL DEFAULT '0',
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT '1=activo 0=inactivo',
  `orden` int(10) NOT NULL,
  `ordenamiento` int(10) NOT NULL,
  `sw_bloquear` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT '1=Si 0=No ( Bloquea la modificacion de la  cuenta o grupo de cuentas )',
  `sw_creargrupo` int(10) NOT NULL DEFAULT '0',
  `sw_crearcuenta` int(10) NOT NULL DEFAULT '0',
  `codigo_cuenta` int(10) NOT NULL DEFAULT '0',
  `codigo_alternativo` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `codigo_barras` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `tipo_cuenta` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'A=activo P=Pasivo R=Perdida G=Ganancia  O=Orden  S=Resultado',
  `imputable` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'S=SI N=NO',
  `nombre_cuenta` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `centro_costo` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `centro_ingreso` int(1) NOT NULL DEFAULT '0' COMMENT 'Indica si la cuenta pertenece a un centro de negocios 0=no 1=si',
  `id_centroingreso` int(10) NOT NULL DEFAULT '0' COMMENT 'id del centro de ingreso asociado a la cuenta imputable',
  `id_subclase` int(10) NOT NULL DEFAULT '0',
  `sw_1` int(1) NOT NULL DEFAULT '0' COMMENT 'Ventas',
  `sw_2` int(1) NOT NULL DEFAULT '0' COMMENT 'serviciotecnico',
  `sw_3` int(1) NOT NULL DEFAULT '0' COMMENT 'Produccion',
  `sw_4` int(1) NOT NULL COMMENT 'tesoreria',
  `sw_5` int(1) NOT NULL DEFAULT '0' COMMENT 'recursos humanos',
  `sw_6` int(1) NOT NULL DEFAULT '0' COMMENT 'logistica',
  `auxiliar` int(1) NOT NULL DEFAULT '0' COMMENT '1= si maneja auxiliar 0=no',
  `sw_clave` int(1) NOT NULL,
  `sw_referencia` int(1) NOT NULL,
  `sw_emision` int(1) NOT NULL,
  `sw_vencimiento` int(1) NOT NULL,
  `sw_auxiliar` int(1) NOT NULL,
  `sw_centrocosto` int(1) NOT NULL,
  `sw_proyecto` int(1) NOT NULL,
  `sw_flujo` int(1) NOT NULL,
  `sw_ctacte` int(1) NOT NULL DEFAULT '0' COMMENT 'indica si maneja cuenta corriente',
  `sw_glosa` int(1) NOT NULL,
  `sw_modulo_pago` int(1) NOT NULL,
  UNIQUE KEY `id_cuenta` (`id_cuenta`),
  KEY `sw_4` (`sw_4`),
  KEY `orden` (`orden`),
  KEY `sw_5` (`sw_5`,`sw_6`),
  KEY `codigo_barras` (`codigo_barras`),
  KEY `estado` (`estado`),
  KEY `sw_ctacte` (`sw_ctacte`),
  KEY `ordenamiento` (`ordenamiento`),
  KEY `codigo_cuenta` (`codigo_cuenta`),
  KEY `imputable` (`imputable`),
  KEY `codigo_alternativo` (`codigo_alternativo`)
) ENGINE=InnoDB AUTO_INCREMENT=1976 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_plandecuentas`
--

LOCK TABLES `tbl_plandecuentas` WRITE;
/*!40000 ALTER TABLE `tbl_plandecuentas` DISABLE KEYS */;
INSERT INTO `tbl_plandecuentas` VALUES (1,1,0,1,0,0,'1',1,0,1,'','','A','N','ACTIVO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(2,2,1,1,0,0,'0',1,0,101,'','','A','N','CIRCULANTE',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(3,3,2,1,0,0,'0',1,0,10101,'','','A','N','DISPONIBLE',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(17,3,2,1,0,0,'0',1,0,10102,'','','A','N','DEPOSITOS A PLAZO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(22,3,2,1,0,0,'0',1,0,10103,'','','A','N','DEUDORES POR VENTA',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(23,4,22,1,0,0,'0',0,1,1010301,'','','A','N','CLIENTES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(28,3,2,1,0,0,'0',1,0,10104,'','','A','N','DOCUMENTOS POR COBRAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(35,3,2,1,0,0,'0',1,0,10105,'','','A','N','DEUDORES VARIOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(36,4,35,1,0,0,'0',0,0,1010501,'','','A','N','CUENTAS DEL PERSONAL',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(39,3,2,1,0,0,'0',1,0,10106,'','','A','N','MERCADERIAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(62,2,1,1,0,0,'0',1,0,102,'','','A','N','ACTIVO FIJO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(63,3,2,1,0,0,'0',1,0,10107,'','','A','N','IMPUESTO POR RECUPERAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(69,3,2,1,0,0,'0',1,0,10108,'','','A','N','GASTOS DIFERIDOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(77,3,2,1,0,0,'0',1,0,10109,'','','A','N','OTROS ACTIVOS CIRCULANTES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(78,3,2,1,0,0,'0',1,0,10110,'','','A','N','CUENTA CORRIENTE DE SOCIOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(112,2,1,1,0,0,'0',1,0,103,'','','A','N','OTROS ACTIVOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(114,3,112,1,0,0,'0',1,0,10302,'','','A','N','INTANGIBLES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(117,3,112,1,0,0,'0',1,0,10303,'','','A','N','AMORTIZACIóN',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(121,1,0,1,0,0,'1',1,0,2,'','','P','N','PASIVO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(122,2,121,1,0,0,'0',1,0,201,'','','P','N','PASIVO CIRCULANTE',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(123,3,122,1,0,0,'0',1,0,20101,'','','P','N','OBLIGACIONES CON BANCOS E INS. FINANCIERAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(124,4,123,1,0,0,'0',0,1,2010101,'','','P','N','OBLIG. C/BCOS E INST FINANCIERAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(139,4,123,1,0,0,'0',0,1,2010102,'','','P','N','OTROS CREDITOS BANCARIOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(145,3,122,1,0,0,'0',1,0,20102,'','','P','N','CUENTAS POR PAGAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(146,4,145,1,0,0,'0',0,1,2010201,'','','P','N','PROVEEDORES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(160,4,145,1,0,0,'0',0,1,2010202,'','','P','N','DOCUMENTOS POR PAGAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(163,4,145,1,0,0,'0',0,1,2010203,'','','P','N','ACREEDORES VARIOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(181,4,145,1,0,0,'0',0,1,2010204,'','','P','N','IMPUESTOS DE RETENCION',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(189,3,122,1,0,0,'0',1,0,20103,'','','P','N','PROVISIONES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(191,3,122,1,0,0,'0',1,0,20104,'','','P','N','OTROS PASIVOS CIRCULANTE',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(193,2,121,1,0,0,'0',1,0,202,'','','P','N','PASIVO A LARGO PLAZO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(194,3,193,1,0,0,'0',1,0,20201,'','','P','N','OBLIGACIONES CON BANCOS E INS. FINANCIERAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(195,4,194,1,0,0,'0',0,1,2020101,'','','P','N','OBLIG. C/BCOS E INST FINANCIERAS  L/P',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(202,3,193,1,0,0,'0',1,0,20202,'','','P','N','DOCUMENTOS POR PAGAR A LARGO PLAZO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(203,3,193,1,0,0,'0',1,0,20203,'','','P','N','ACREEDORES VARIOS A LARGO PLAZO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(204,3,193,1,0,0,'0',1,0,20204,'','','P','N','PROVISIONES A LARGO PLAZO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(205,2,121,1,0,0,'0',1,0,203,'','','P','N','PATRIMONIO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(206,3,205,1,0,0,'0',1,0,20301,'','','P','N','CAPITAL PAGADO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(208,3,205,1,0,0,'0',1,0,20302,'','','P','N','RESERVA REVALORIZACIóN CAPITAL',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(210,3,205,1,0,0,'0',1,0,20303,'','','P','N','OTRAS RESERVAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(213,3,205,1,0,0,'0',1,0,20304,'','','P','N','UTILIDADES RETENIDAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(217,1,0,1,0,0,'1',1,0,3,'','','R','N','GASTO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(561,5,181,1,0,0,'0',0,0,201020401,'212','','P','S','IVA DEBITO FISCAL',0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0),(564,5,23,1,0,0,'0',0,0,101030101,'110','','A','S','CLIENTES',0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0),(565,5,146,1,0,0,'0',0,0,201020101,'205','','P','S','PROVEEDORES',0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0),(589,5,181,1,0,0,'0',0,0,201020402,'213','','P','S','RETENCION DE HONORARIOS',0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0),(837,5,36,1,0,0,'0',0,0,101050101,'114','','A','S','ANTICIPO DE SUELDOS',0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0),(1180,5,163,1,0,0,'0',0,0,201020301,'210','','P','S','ACREEDORES VARIOS',0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,0,0,0,0),(1358,4,189,1,0,0,'0',0,1,2010301,'','','P','N','PROVISIONES IMPUESTO RENTA',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1359,5,1358,1,0,0,'0',0,0,201030101,'225','','P','S','PROVISIONES IMPUESTO RENTA',0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,0,0,0,0),(1365,4,3,1,0,0,'0',0,1,1010101,'','','A','N','CAJAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1366,4,3,1,0,0,'0',0,1,1010102,'','','A','N','BANCOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1413,4,17,1,0,0,'0',0,1,1010201,'','','A','N','DEPOSITO A PLAZO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1415,5,1413,1,0,0,'0',0,0,101020102,'109','','A','S','INVERSIONES VARIAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1451,4,28,1,0,0,'0',0,0,1010401,'','','A','N','DOCUMENTOS POR COBRAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1452,1,0,1,0,0,'1',1,0,4,'','','G','0','INGRESO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1453,2,1452,1,0,0,'0',1,0,401,'','','G','N','INGRESOS DE EXPLOTACIóN',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1454,2,1452,1,0,0,'0',1,0,402,'','','G','N','INGRESOS FUERA DE EXPLOTACIóN',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1461,2,217,1,0,0,'0',1,0,301,'','','R','N','EGRESOS DE EXPLOTACIóN',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1462,2,217,1,0,0,'0',1,0,302,'','','R','N','EGRESOS FUERA DE EXPLOTACIóN',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1463,3,1454,1,0,0,'0',1,0,40201,'','','G','N','INGRESOS NO OPERACIONALES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1464,3,1454,1,0,0,'0',1,0,40202,'','','G','N','OTROS INGRESOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1504,3,1461,1,0,0,'0',1,0,30101,'','','R','N','COSTOS DE EXPLOTACIóN',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1505,3,1461,1,0,0,'0',1,0,30102,'','','R','N','GASTOS OPERACIONALES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1506,3,1462,1,0,0,'0',1,0,30201,'','','R','N','GASTOS FINANCIEROS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1507,3,1462,1,0,0,'0',1,0,30202,'','','R','N','OTROS GASTOS NO OPERACIONALES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1508,4,1505,1,0,0,'0',0,1,3010201,'','','R','N','REMUNERACION',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1509,4,1505,1,0,0,'0',0,1,3010202,'','','R','N','ARRIENDO Y GASTOS COMUNES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1517,5,1508,1,0,0,'0',0,0,301020101,'302','','R','S','REMUNERACION',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1518,5,1508,1,0,0,'0',0,0,301020102,'303','','R','S','INDEMNIZACION',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1522,5,1509,1,0,0,'0',0,0,301020201,'304','','R','S','GASTOS ARRIENDO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1523,5,1509,1,0,0,'0',0,0,301020202,'305','','R','S','GASTOS COMUNES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1524,3,1453,1,0,0,'0',1,0,40101,'','','G','N','INGRESOS DE EXPLOTACIóN',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1565,5,1451,1,0,0,'0',0,0,101040101,'111','','A','S','CHEQUES POR COBRAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0),(1566,5,1451,1,0,0,'0',0,0,101040102,'112','','A','S','LETRAS POR COBRAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0),(1567,5,1451,1,0,0,'0',0,0,101040103,'113','','A','S','LETRAS POR COBRAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0),(1568,5,36,1,0,0,'0',0,0,101050102,'115','','A','S','PRESTAMO DEL PERSONAL',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0),(1569,5,36,1,0,0,'0',0,0,101050103,'116','','A','S','ASIGNACION FAMILIAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0),(1570,4,35,1,0,0,'0',0,1,1010502,'','','A','N','OTROS DEUDORES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1571,5,1570,1,0,0,'0',0,0,101050201,'117','','A','S','DEUDORES VARIOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0),(1574,4,63,1,0,0,'0',0,1,1010702,'','','A','N','IMPUESTO POR RECUPERAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1575,5,1574,1,0,0,'0',0,0,101070201,'121','','A','S','PPM',0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,0,0,0,0),(1576,5,1574,1,0,0,'0',0,0,101070202,'122','','A','S','SENCE',0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,0,0,0,0),(1577,5,1574,1,0,0,'0',0,0,101070203,'123','','A','S','CREDITO 4% ACTIVO FIJO',0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,0,0,0,0),(1578,5,1574,1,0,0,'0',0,0,101070204,'124','','A','S','IMPUESTO POR RECUPERAR',0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,0,0,0,0),(1579,4,69,1,0,0,'0',0,0,1010802,'','','A','N','INTERES DIFERIDO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1584,5,1579,1,0,0,'0',0,0,101080201,'126','','A','S','INTERES DIFERIDO',0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,0,0,0,0),(1585,4,77,1,0,0,'0',0,0,1010901,'','','A','N','IMPUESTO POR DEVENGAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1586,5,1585,1,0,0,'0',0,0,101090101,'128','','A','S','PROVISION IVA Y PPM',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1587,5,1585,1,0,0,'0',0,0,101090102,'129','','A','S','IVA POR DEVENGAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1588,4,78,1,0,0,'0',0,0,1011001,'','','A','N','CUENTA PARTICULARES SOCIOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1590,5,1588,1,0,0,'0',0,0,101100102,'130','','A','S','CUENTA PARTICULAR SOCIO 2',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1591,3,2,1,0,0,'0',1,0,10111,'','','A','N','CUENTA EMPRESAS RELACIONADAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1592,4,1591,1,0,0,'0',0,0,1011101,'','','A','N','CUENTAS EMPRESAS RELACIONADAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1593,5,1592,1,0,0,'0',0,0,101110101,'131','','A','S','CTA CTE INMOBILIARIA',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1598,4,1597,1,0,0,'0',0,0,1020301,'','','A','N','TERRENO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1599,5,1598,1,0,0,'0',0,0,102030101,'145','','A','S','TERRENO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1601,4,1600,1,0,0,'0',0,0,1020401,'','','A','N','CONSTRUCCION E INFRAESTRUCTURA',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1602,5,1601,1,0,0,'0',0,0,102040101,'146','','A','S','EDIFICIO Y CONSTRUCCION',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1603,5,1601,1,0,0,'0',0,0,102040102,'147','','A','S','INSTALACIONES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1604,4,86,1,0,0,'0',0,1,1020101,'','','A','N','VEHICULO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1608,3,62,1,0,0,'0',1,0,10201,'','','A','N','ACTIVO FIJO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1609,3,62,1,0,0,'0',1,0,10202,'','','A','N','DEPRECIACION (MENOS)',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1610,4,1608,1,0,0,'0',0,1,1020101,'','','A','N','VEHICULO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1611,4,1608,1,0,0,'0',0,0,1020102,'','','A','N','CONSTRUCCIONES E INFRAESTRUCTURA',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1612,4,1608,1,0,0,'0',0,0,1020103,'','','A','N','VEHICULO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1613,4,1608,1,0,0,'0',0,0,1020104,'','','A','N','MAQUINARIA Y EQUIPO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1614,4,1608,1,0,0,'0',0,1,1020105,'','','A','N','ACTIVO FIJO MUEBLES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1615,4,1608,1,0,0,'0',0,0,1020106,'','','A','N','OTRO ACTIVO FIJO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1616,4,1609,1,0,0,'0',0,0,1020201,'','','A','N','DEP. ACUM. ACTIVO FIJO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1622,5,1610,1,0,0,'0',0,0,102010101,'132','','A','S','PROPIEDADES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1623,5,1616,1,0,0,'0',0,0,102020101,'143','','A','S','DEPRECIACION ACUMULADA',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1624,5,1611,1,0,0,'0',0,0,102010201,'134','','A','S','EDIFICACION Y CONSTRUCCION',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1625,5,1611,1,0,0,'0',0,0,102010202,'135','','A','S','INSTALACIONES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1628,5,1612,1,0,0,'0',0,0,102010301,'136','','A','S','VEHICULO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1630,5,1614,1,0,0,'0',0,0,102010501,'140','','A','S','ACTIVO FIJO MUEBLES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1632,5,1613,1,0,0,'0',0,0,102010401,'137','','A','S','MAQUINARIA Y EQUIPO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1633,5,1613,1,0,0,'0',0,0,102010402,'138','','A','S','EQUIPO COMPUTACIONALES E IMPRESORA',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1634,5,1613,1,0,0,'0',0,0,102010403,'139','','A','S','ARTICULOS ELECTRONICOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1638,5,1615,1,0,0,'0',0,0,102010601,'141','','A','S','VEHICULOS EN LEASING',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1639,5,1615,1,0,0,'0',0,0,102010602,'142','','A','S','MAQUINARIA EN LEASING',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1642,3,112,1,0,0,'0',1,0,10304,'','','A','N','INVERSIONES EMPRESAS RELACIONADAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1643,3,112,1,0,0,'0',1,0,10305,'','','A','N','RETIROS REINVERSION',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1652,4,1609,1,0,0,'0',0,0,1020202,'','','A','N','DEP. ACUM OTROS ACTIVOS FIJOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1653,5,1652,1,0,0,'0',0,0,102020201,'144','','A','S','DEP. ACUM. ACTIVOS EN LEASING',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1654,5,1574,1,0,0,'0',0,0,101070205,'125','','A','S','IVA CREDITO FISCAL',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1655,4,114,1,0,0,'0',0,1,1030203,'','','A','N','INTANGIBLES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1656,5,1655,1,0,0,'0',0,0,103020301,'148','','A','S','DERECHO DE LLAVES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1657,5,1655,1,0,0,'0',0,0,103020302,'149','','A','S','PATENTE',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1658,4,206,1,0,0,'0',0,1,2030102,'','','P','N','CAPITAL PAGADO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1659,5,1658,1,0,0,'0',0,0,203010201,'233','','P','S','CAPITAL PAGADO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1660,4,1642,1,0,0,'0',0,1,1030402,'','','A','N','INVERSIONES EMPRESAS RELACIONADAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1662,4,1643,1,0,0,'0',0,1,1030502,'','','A','N','RETIROS REINVERSION',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1663,5,1662,1,0,0,'0',0,0,103050201,'150','','A','S','RETIRO REINVERSION',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1668,5,160,1,0,0,'0',0,0,201020201,'206','','P','S','HONORARIOS POR PAGAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0),(1669,5,124,1,0,0,'0',0,0,201010101,'201','','P','S','OBLIG. C/BCOS E INST FINANCIERAS MONEDA NACIONAL',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1670,5,124,1,0,0,'0',0,0,201010102,'202','','P','S','OBLIG. C/BCOS E INST FINANCIERAS MONEDA EXTRANJERA',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1671,5,139,1,0,0,'0',0,0,201010201,'203','','P','S','LINEA DE CREDITO BCO BCI',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1672,5,139,1,0,0,'0',0,0,201010202,'204','','P','S','TARJETA DE CREDITO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1673,4,145,1,0,0,'0',0,1,2010205,'','','P','N','REMUNERACIONES POR PAGAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1674,5,160,1,0,0,'0',0,0,201020202,'207','','P','S','LETRAS POR PAGAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1675,5,160,1,0,0,'0',0,0,201020203,'208','','P','S','IMPUESTO POR PAGAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0),(1676,5,160,1,0,0,'0',0,0,201020204,'209','','P','S','CHEQUE A FECHA',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0),(1677,5,181,1,0,0,'0',0,0,201020403,'214','','P','S','IMPUESTO UNICO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1678,5,1673,1,0,0,'0',0,0,201020501,'215','','P','S','REMUNERACIONES POR PAGAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1679,4,145,1,0,0,'0',0,1,2010206,'','','P','N','HONORARIOS POR PAGAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1680,5,1679,1,0,0,'0',0,0,201020601,'216','','P','S','HONORARIOS POR PAGAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1681,4,145,1,0,0,'0',0,1,2010207,'','','P','N','LEYES SOCIALES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1682,5,1681,1,0,0,'0',0,0,201020701,'217','','P','S','INP POR PAGAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1683,5,1681,1,0,0,'0',0,0,201020702,'218','','P','S','AFP POR PAGAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1684,5,1681,1,0,0,'0',0,0,201020703,'219','','P','S','ISAPRE POR PAGAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1685,5,1681,1,0,0,'0',0,0,201020704,'220','','P','S','MUTUAL POR PAGAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1686,5,1681,1,0,0,'0',0,0,201020705,'221','','P','S','CCAF',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1687,5,1681,1,0,0,'0',0,0,201020706,'222','','P','S','AFC POR PAGAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1688,5,1681,1,0,0,'0',0,0,201020707,'223','','P','S','PRESTAMO CCAF',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1689,4,145,1,0,0,'0',0,1,2010208,'','','P','N','OTROS DSCTO AL TRABAJADOR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1690,5,1689,1,0,0,'0',0,0,201020801,'224','','P','S','OTROS DSCTO AL TRABAJADOR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1691,4,191,1,0,0,'0',0,1,2010401,'','','P','N','INGRESO PERC X ADELANTADO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1692,5,1691,1,0,0,'0',0,0,201040101,'227','','P','S','PROVISION IMPUESTO RENTA',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1693,5,195,1,0,0,'0',0,0,202010101,'231','','P','S','OBLIG. C/BCOS E INST FINANCIERAS MONEDA NACIONAL L/P',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1694,5,195,1,0,0,'0',0,0,202010102,'232','','P','S','OBLIG. C/BCOS E INST FINANCIERAS MONEDA EXTRANJERA L/P',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1695,4,189,1,0,0,'0',0,1,2010302,'','','P','N','PROVISIONES VARIAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1696,5,1695,1,0,0,'0',0,0,201030201,'226','','P','S','PROVISIONES VARIAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1697,4,191,1,0,0,'0',0,1,2010402,'','','P','N','OBLIGACIONES POR LEASING',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1698,5,1697,1,0,0,'0',0,0,201040201,'228','','P','S','OBLIGACIONES POR LEASING',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1699,4,208,1,0,0,'0',0,1,2030201,'','','P','N','RESERVA REVALORIZACIóN CAPITAL',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1700,5,1699,1,0,0,'0',0,0,203020101,'234','','P','S','RESERVA REVALORIZACIóN CAPITAL',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1701,4,213,1,0,0,'0',0,1,2030401,'','','P','N','UTILIDADES ACUMULADAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1702,4,213,1,0,0,'0',0,1,2030402,'','','P','N','PERDIDAS ACUMULADAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1703,4,213,1,0,0,'0',0,1,2030403,'','','P','N','UTILIDAD O PERDIDA DEL EJERCICIO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1704,4,213,1,0,0,'0',0,1,2030404,'','','P','N','APORTE FUT AUMENTO DE CAPITAL',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1705,5,1701,1,0,0,'0',0,0,203040101,'235','','P','S','UTILIDADES ACUMULADAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1706,5,1702,1,0,0,'0',0,0,203040201,'236','','P','S','PERDIDAS ACUMULADAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1707,5,1703,1,0,0,'0',0,0,203040301,'237','','P','S','UTILIDAD O PERDIDA DEL EJERCICIO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1708,5,1704,1,0,0,'0',0,0,203040401,'238','','P','S','APORTE FUT AUMENTO DE CAPITAL',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0),(1711,4,1463,1,0,0,'0',0,1,4020101,'','','G','N','INGRESOS NO OPERACIONALES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1712,5,1711,1,0,0,'0',0,0,402010101,'402','','G','S','INGRESOS FINANCIEROS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1713,5,1711,1,0,0,'0',0,0,402010102,'403','','G','S','OTROS INGRESOS NO OPERACIONALES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1714,5,1711,1,0,0,'0',0,0,402010103,'404','','G','S','DIFERENCIA DE CAMBIO GANANCIA',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1715,5,1711,1,0,0,'0',0,0,402010104,'405','','G','S','CORRECCION MONETARIA GANANCIA',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1716,5,1711,1,0,0,'0',0,0,402010105,'406','','G','S','UTILIDAD VENTA DE ACTIVO FIJO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1717,5,1711,1,0,0,'0',0,0,402010106,'407','','G','S','INTERESES DEVENGADOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1724,4,1505,1,0,0,'0',0,1,3010203,'','','R','N','SERVICIOS BASICOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1725,5,1724,1,0,0,'0',0,0,301020301,'306','','R','S','GASTOS AGUA',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1726,5,1724,1,0,0,'0',0,0,301020302,'307','','R','S','GASTOS LUZ',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1727,5,1724,1,0,0,'0',0,0,301020303,'308','','R','S','GASTOS FONO FIJO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1728,5,1724,1,0,0,'0',0,0,301020304,'309','','R','S','SEGURIDAD',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1729,5,1724,1,0,0,'0',0,0,301020305,'310','','R','S','GASTOS GAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1730,4,1505,1,0,0,'0',0,1,3010204,'','','R','N','ASESORIAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1731,5,1730,1,0,0,'0',0,0,301020401,'312','','R','S','GASTOS SERVICIO JURIDICO',0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1732,5,1730,1,0,0,'0',0,0,301020402,'313','','R','S','GASTOS SERVICIO CONTABILIDAD',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1734,4,1505,1,0,0,'0',0,1,3010205,'','','R','N','TRASLADO Y VIAJES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1735,5,1734,1,0,0,'0',0,0,301020501,'314','','R','S','MOVILIZACION TRABAJADORES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1736,5,1734,1,0,0,'0',0,0,301020502,'315','','R','S','PEAJES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1737,5,1734,1,0,0,'0',0,0,301020503,'316','','R','S','GASTOS COMBUSTIBLE',0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1738,5,1734,1,0,0,'0',0,0,301020504,'317','','R','S','FLETE Y DESPACHO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1739,5,1734,1,0,0,'0',0,0,301020505,'318','','R','S','GASTOS VIAJE Y ESTADIA',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1740,5,1734,1,0,0,'0',0,0,301020506,'319','','R','S','VIATICO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1741,4,1505,1,0,0,'0',0,1,3010206,'','','R','N','SEGURO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1742,5,1741,1,0,0,'0',0,0,301020601,'321','','R','S','SEGURO VEHICULO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1743,5,1741,1,0,0,'0',0,0,301020602,'322','','R','S','SEGURO EMPRESA',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1744,4,1505,1,0,0,'0',0,1,3010207,'','','R','N','MANTENCION Y REPARACION',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1745,5,1744,1,0,0,'0',0,0,301020701,'323','','R','S','MANTENCION Y REPARACION',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1746,4,1505,1,0,0,'0',0,1,3010208,'','','R','N','MATERIALES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1747,5,1746,1,0,0,'0',0,0,301020801,'324','','R','S','GASTO ARTICULOS ESCRITORIO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1748,4,1505,1,0,0,'0',0,1,3010209,'','','R','N','OTROS GASTOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1749,5,1748,1,0,0,'0',0,0,301020901,'326','','R','S','GASTOS REPRESENTACION',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1750,5,1748,1,0,0,'0',0,0,301020902,'327','','R','S','GASTOS DE PUBLICIDAD',0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1751,5,1748,1,0,0,'0',0,0,301020903,'328','','R','S','SUSCRIPCION',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1752,5,1748,1,0,0,'0',0,0,301020904,'329','','R','S','GASTOS MENORES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1753,5,1748,1,0,0,'0',0,0,301020905,'330','','R','S','GASTOS GENERALES',0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1755,4,1505,1,0,0,'0',0,1,3010210,'','','R','N','PATENTES PERMISOS Y CONTRIBUCIONES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1756,5,1755,1,0,0,'0',0,0,301021001,'331','','R','S','PATENTES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1757,5,1755,1,0,0,'0',0,0,301021002,'332','','R','S','CONSTRIBUCIONES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1758,5,1755,1,0,0,'0',0,0,301021003,'333','','R','S','PERMISOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1759,4,1505,1,0,0,'0',0,1,3010211,'','','R','N','DEPRECIACION',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1760,5,1759,1,0,0,'0',0,0,301021101,'334','','R','S','DEPRECIACION',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1761,4,1505,1,0,0,'0',0,1,3010212,'','','R','N','GASTOS BANCARIOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1762,5,1761,1,0,0,'0',0,0,301021201,'335','','R','S','GASTOS BANCARIOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1763,4,1506,1,0,0,'0',0,1,3020101,'','','R','N','GASTOS FINANCIEROS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1764,5,1763,1,0,0,'0',0,0,302010101,'336','','R','S','INTERESES DE PRESTAMOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1765,5,1763,1,0,0,'0',0,0,302010102,'337','','R','S','COMISION Y CARGOS BANCARIOS L/C',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1766,4,1507,1,0,0,'0',0,1,3020201,'','','R','N','OTROS GASTOS NO OPERACIONALES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1767,5,1766,1,0,0,'0',0,0,302020101,'338','','R','S','DIFERENCIA DE CAMBIO PERDIDA',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1768,5,1766,1,0,0,'0',0,0,302020102,'339','','R','S','CORRECCION MONETARIA PERDIDA',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1769,5,1766,1,0,0,'0',0,0,302020103,'340','','R','S','PERDIDA VENTA DE ACTIVO FIJO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1770,5,1766,1,0,0,'0',0,0,302020104,'341','','R','S','CASTIGO DE EXISTENCIA',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1771,5,1766,1,0,0,'0',0,0,302020105,'342','','R','S','CASTIGO DEUDORES INCOBRABLE',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1772,5,1766,1,0,0,'0',0,0,302020106,'343','','R','S','AJUSTE EJERCICIO ANTERIOR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1773,5,1766,1,0,0,'0',0,0,302020107,'344','','R','S','IMPUESTO RENTA',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1774,5,1766,1,0,0,'0',0,0,302020108,'345','','R','S','DONACIONES SIN FINES PROMOCIONALES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1777,5,1734,1,0,0,'0',0,0,301020507,'320','','R','S','ESTACIONAMIENTO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1782,5,1746,1,0,0,'0',0,0,301020802,'325','','R','S','GASTOS ARTICULOS ASEO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1783,5,1724,1,0,0,'0',0,0,301020306,'311','','R','S','SERVICIO DE HIGIENE Y ASEO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1795,4,191,1,0,0,'0',0,1,2010403,'','','P','N','DOCUMENTOS POR INGRESAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1796,5,1795,1,0,0,'0',0,0,201040301,'229','','P','S','DOCUMENTOS POR INGRESAR',0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0),(1862,4,69,1,0,0,'0',0,1,1010803,'','','A','N','ANTICIPOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1863,5,1862,1,0,0,'0',0,0,101080301,'127','','A','S','ANTICIPO DE HONORARIOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0),(1864,5,163,1,0,0,'0',0,0,201020302,'211','','P','S','PRESTAMOS POR PAGAR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1871,5,1570,1,0,0,'0',0,0,101050202,'118','','A','S','ANTICIPO A PROVEEDORES',0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,1,1,0,0),(1896,4,1507,1,0,0,'0',0,1,3020202,'','','R','N','GASTOS PARTICULARES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1897,5,1896,1,0,0,'0',0,0,302020201,'346','','R','S','GASTOS COLACIóN/ALMUERZO/DESAYUNOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1898,5,1570,1,0,0,'0',0,0,101050203,'119','','A','S','FONDOS POR RENDIR',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0),(1901,5,1896,1,0,0,'0',0,0,302020204,'347','','R','S','GASTOS INTERESES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1902,5,1896,1,0,0,'0',0,0,302020205,'348','','R','S','GASTOS REPARACIONES/MANTENCIONES',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1905,5,1795,1,0,0,'0',0,0,201040302,'230','','P','S','ANTICIPO DE CLIENTES',0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,1,0,0),(1909,4,1504,1,0,0,'0',0,1,3010101,'','','R','N','COSTOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1911,5,1909,1,0,0,'0',0,0,301010101,'301','','R','S','COSTOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1912,4,1524,1,0,0,'0',0,1,4010101,'','','G','N','INGRESOS POR VENTA',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1913,5,1912,1,0,0,'0',0,0,401010101,'401','','G','S','VENTAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1918,4,39,1,0,0,'0',0,1,1010601,'','','A','N','MERCADERIAS EXISTENCIAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1925,4,3,1,0,0,'0',0,1,1010103,'','','A','N','DOCUMENTOS EN CARTERA',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1926,5,1925,1,0,0,'0',0,0,101010301,'104','','A','S','CHEQUES EN CARTERA',0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0),(1929,4,3,1,0,0,'0',0,1,1010104,'','','A','N','PAGOS CON TARJETAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1930,5,1929,1,0,0,'0',0,0,101010401,'105','','A','S','TRANSBANK TARJETAS CRÉDITO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1931,5,1929,1,0,0,'0',0,0,101010402,'106','','A','S','TRANSBANK TARJETAS DÉBITO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1932,5,1929,1,0,0,'0',0,0,101010403,'107','','A','S','TRANSFERENCIAS RECIBIDAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1933,5,1929,1,0,0,'0',0,0,101010404,'108','','A','S','VALE VISTA RECIBIDOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1935,5,1918,1,0,0,'0',0,0,101060101,'120','','A','S','EXISTENCIAS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1957,5,1365,1,0,0,'0',0,0,101010101,'101','','A','S','CAJA CENTRAL',0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,1,0,0,0,0),(1959,5,1366,1,0,0,'0',0,0,101010201,'102','','A','S','BANCO SANTANDER',0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,1,0,0,0,0),(1960,5,1610,1,0,0,'0',0,0,102010102,'133','','A','S','TERRENOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1969,5,1366,1,0,0,'0',0,0,101010202,'103','','A','S','BANCO CHILE',0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1973,5,1365,1,0,0,'0',0,0,101010102,'','','A','S','CAJA RECAUDOS',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1974,5,1918,1,0,0,'0',0,0,101060102,'','','A','S','PRODUCTOS EN PROCESO',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(1975,5,1574,1,0,0,'0',0,0,101070206,'','','A','S','IMPUESTO HARINA 12%',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
/*!40000 ALTER TABLE `tbl_plandecuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ppm`
--

DROP TABLE IF EXISTS `tbl_ppm`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ppm` (
  `id_ppm` int(10) NOT NULL AUTO_INCREMENT,
  `tasa` decimal(2,1) NOT NULL DEFAULT '0.0',
  `mes` char(2) CHARACTER SET latin1 NOT NULL DEFAULT '0',
  `ano` int(4) NOT NULL DEFAULT '0',
  UNIQUE KEY `id_ppm` (`id_ppm`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ppm`
--

LOCK TABLES `tbl_ppm` WRITE;
/*!40000 ALTER TABLE `tbl_ppm` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ppm` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_preguntasfrecuentes`
--

DROP TABLE IF EXISTS `tbl_preguntasfrecuentes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_preguntasfrecuentes` (
  `id_preguntafrecuente` int(10) NOT NULL DEFAULT '0',
  `categoria` char(1) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `numero` int(3) NOT NULL DEFAULT '0',
  `dia` decimal(2,0) NOT NULL DEFAULT '0',
  `mes` decimal(2,0) NOT NULL DEFAULT '0',
  `ano` decimal(4,0) NOT NULL DEFAULT '0',
  `titulo` varchar(100) CHARACTER SET latin1 NOT NULL DEFAULT '0',
  `subtitulo` varchar(200) CHARACTER SET latin1 NOT NULL DEFAULT '0',
  `detalle` text CHARACTER SET latin1 NOT NULL,
  UNIQUE KEY `id_novedad` (`id_preguntafrecuente`),
  KEY `numero` (`numero`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_preguntasfrecuentes`
--

LOCK TABLES `tbl_preguntasfrecuentes` WRITE;
/*!40000 ALTER TABLE `tbl_preguntasfrecuentes` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_preguntasfrecuentes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_presupuestos`
--

DROP TABLE IF EXISTS `tbl_presupuestos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_presupuestos` (
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'EP=EnProceso AN=Anulado GR=Guardado TR=Transferido',
  `fecha` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time` int(10) NOT NULL,
  `time_ingreso` int(10) NOT NULL,
  `usuario_ingreso` int(10) NOT NULL,
  `rut_receptor` varchar(15) COLLATE utf8_spanish_ci NOT NULL COMMENT 'rut del empleado que recepciono',
  `id_motivo` int(10) NOT NULL,
  `precio_costo` int(10) NOT NULL,
  `precio_venta` int(10) NOT NULL,
  `utilidad` int(10) NOT NULL,
  `rentabilidad` decimal(12,2) NOT NULL,
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `tipo_cliente` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `razon_social` varchar(250) COLLATE utf8_spanish_ci NOT NULL,
  `direccion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `contacto` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `fono` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` text COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `folio` (`folio`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_presupuestos`
--

LOCK TABLES `tbl_presupuestos` WRITE;
/*!40000 ALTER TABLE `tbl_presupuestos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_presupuestos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_presupuestos_detalle`
--

DROP TABLE IF EXISTS `tbl_presupuestos_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_presupuestos_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `id_item` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '' COMMENT 'P=Producto M=MateriaPrima I=Insumo C=Cuenta',
  `codigo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` text COLLATE utf8_spanish_ci NOT NULL,
  `cantidad` decimal(12,2) NOT NULL,
  `unitario` decimal(12,2) NOT NULL,
  `subtotal` int(10) NOT NULL,
  `observaciones` text COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `folio` (`folio`),
  KEY `estado` (`estado`),
  KEY `codigo` (`codigo`),
  KEY `tipo_item` (`tipo_item`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_presupuestos_detalle`
--

LOCK TABLES `tbl_presupuestos_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_presupuestos_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_presupuestos_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_productos`
--

DROP TABLE IF EXISTS `tbl_productos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_productos` (
  `id_producto` int(10) NOT NULL AUTO_INCREMENT,
  `id_receta` int(10) NOT NULL,
  `usuario_creacion` int(10) NOT NULL,
  `time_creacion` int(10) NOT NULL,
  `usuario_modificacion` int(10) NOT NULL,
  `time_modificacion` int(10) NOT NULL,
  `codigo_producto` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'Codigo maestro del producto',
  `codigo_alternativo_similar` varchar(128) COLLATE utf8_spanish_ci NOT NULL COMMENT 'codigo alternativo del producto similar',
  `tipo_producto` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'P=producto R=repuesto I=insumo M=materiaprima F=ActivoFijo',
  `estado` int(1) NOT NULL DEFAULT '0' COMMENT '0=ocultar 1=mostrar',
  `sw_muestra` int(1) NOT NULL,
  `sw_fiscalizar` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no ( 1 indica que el inventario del producto se debe fiscalizar, ya que no coincide por el del sistema)',
  `sw_actualizar_referencial` int(1) NOT NULL DEFAULT '0',
  `sw_facturable` int(1) NOT NULL DEFAULT '1' COMMENT '1=si 0=no ( Indica si el producto debe emitir factura o boleta )',
  `sw_inventario` int(1) NOT NULL DEFAULT '1' COMMENT '1=si 0=no ( Indica si el producto maneja inventario )',
  `estado_inventario` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT '1=verde 2=amarillo 3=rojo',
  `codigo_alternativo` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '' COMMENT 'Codigo alternativo 1',
  `codigo_sku` varchar(255) COLLATE utf8_spanish_ci NOT NULL COMMENT 'codigo sku tiendas b2b',
  `codigo_sku_madre` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_categoria` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_marca` char(4) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_marca` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `origen` int(1) NOT NULL DEFAULT '0' COMMENT '1=importado 0=nacional',
  `unidad_medida` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'UN=unidad KG=kilo gramo  LT=litro CJ=caja  BL=bolsa',
  `unidad_conversion` decimal(12,2) NOT NULL,
  `presentacion` decimal(12,2) NOT NULL,
  `nombre` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '' COMMENT 'Nombre del producto',
  `nombre_corto` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '' COMMENT 'nombre corto principalmente para etiquetas ej de ropa o boletas de punto de venta',
  `descripcion` text COLLATE utf8_spanish_ci NOT NULL COMMENT 'Descripción completa del producto',
  `clase` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'Clase del producto, de acuerdo a su nivel de venta (A,B,C,etc) Z=sin movimiento',
  `stock` decimal(15,5) NOT NULL DEFAULT '0.00000' COMMENT 'Almacena el ultimo saldo en unidades del inventario',
  `stock_auditado` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `reserva` decimal(15,5) NOT NULL DEFAULT '0.00000' COMMENT 'Unidades reservadas por notas de ventas o similares',
  `disponible` decimal(15,5) NOT NULL DEFAULT '0.00000' COMMENT 'stock disponible= stock-reserva=disponible',
  `pendiente` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `compra` int(10) NOT NULL DEFAULT '0' COMMENT 'cantidad de unidades en compra',
  `importacion` int(10) NOT NULL COMMENT 'cantidad de unidades por recibir de una importacion',
  `produccion` int(10) NOT NULL COMMENT 'unidades en proceso de fabricacion',
  `time_compra` int(10) NOT NULL COMMENT 'fecha de orden de compra mas poxima',
  `time_produccion` int(10) NOT NULL COMMENT 'fecha de produccion mas proxima',
  `time_importacion` int(10) NOT NULL COMMENT 'fecha de importacion mas proxima',
  `merma` decimal(12,2) NOT NULL,
  `devolucion` int(10) NOT NULL DEFAULT '0' COMMENT 'cantidad de unidades en proceso de devolucion',
  `pmp` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'ultimo precio medio ponderado del producto',
  `precio_compra` decimal(12,2) NOT NULL,
  `stock_minimo` int(10) NOT NULL DEFAULT '0' COMMENT 'stock minimo del producto',
  `stock_maximo` int(10) NOT NULL DEFAULT '0' COMMENT 'Stock maximo en unidades (sobrestockeado)',
  `stock_reposicion` int(10) NOT NULL DEFAULT '0' COMMENT 'Cantidad de unidades en las cuales debe reponerse el productos',
  `precio_referencial` decimal(15,5) NOT NULL DEFAULT '0.00000' COMMENT 'precio referencial de venta',
  `precio_publico` int(10) NOT NULL,
  `cantidad_mayorista` int(7) NOT NULL,
  `sw_bruto` int(1) NOT NULL DEFAULT '0',
  `impuesto` int(3) NOT NULL DEFAULT '0',
  `sw_impuesto_especifico` int(1) NOT NULL,
  `descuento_maximo` int(2) NOT NULL DEFAULT '0' COMMENT 'porcentaje de descuento maximo permitido',
  `comision` decimal(12,2) NOT NULL,
  `tipo_comision` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'PO=porcentaje PE=pesos',
  `monto_produccion` int(10) NOT NULL COMMENT 'monto a cancelar por producción por cada unidad fabricada',
  `tipo_produccion` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `id_centroingreso` int(10) NOT NULL DEFAULT '0' COMMENT 'codigo de la cuenta contable asociada al producto',
  `id_categoria` int(10) NOT NULL COMMENT 'id de la categoria del articulo',
  `id_marca` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `codigo_linea` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_sublinea` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_clase` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_subclase` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `item_centronegocio` int(10) NOT NULL DEFAULT '0' COMMENT 'este es el correlativo de productos del centro de negocios y siempre sera incremental',
  `producto_fabricacion` int(1) NOT NULL DEFAULT '0' COMMENT '1=SI 0=NO ( Indica si el producto es de fabricacion o transformacion )',
  `producto_serie` int(1) NOT NULL DEFAULT '0' COMMENT '1=SI 0=NO (Indica si el producto maneja numero de serie)',
  `codigo_barra` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `ordenamiento` int(10) NOT NULL,
  `sw_sitioweb` int(1) NOT NULL DEFAULT '1',
  `sw_lote` int(1) NOT NULL,
  `id_prop1` int(10) NOT NULL,
  `id_prop2` int(10) NOT NULL,
  `id_prop3` int(10) NOT NULL,
  `prop_1` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `prop_2` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `prop_3` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `decimales` int(10) NOT NULL COMMENT 'cantifdad de decimales que utiliza para el inventario',
  `decimales_cantidad` int(10) NOT NULL,
  `nombre_archivo` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_impuesto` int(10) NOT NULL,
  `id_impuesto_especifico` int(1) NOT NULL,
  `sw_intermedio` bit(1) NOT NULL COMMENT 'determina producto intermedio',
  UNIQUE KEY `id_producto` (`id_producto`),
  KEY `nombre` (`nombre`),
  KEY `codigo_barra` (`codigo_barra`),
  KEY `ordenamiento` (`ordenamiento`),
  KEY `sw_sitioweb` (`sw_sitioweb`),
  KEY `codigo_sku` (`codigo_sku`),
  KEY `merma` (`merma`),
  KEY `importacion` (`importacion`,`produccion`),
  KEY `time_compra` (`time_compra`,`time_produccion`,`time_importacion`),
  KEY `usuario_creacion` (`usuario_creacion`,`time_creacion`),
  KEY `id_categoria` (`id_categoria`),
  KEY `usuario_modificacion` (`usuario_modificacion`,`time_modificacion`),
  KEY `id_marca` (`id_marca`),
  KEY `codigo_producto` (`codigo_producto`),
  KEY `codigo_alternativo` (`codigo_alternativo`),
  KEY `nombre_corto` (`nombre_corto`),
  KEY `nombre_marca` (`nombre_marca`),
  KEY `tipo_produccion` (`tipo_produccion`),
  KEY `id_receta` (`id_receta`),
  KEY `prop_1` (`prop_1`),
  KEY `prop_2` (`prop_2`),
  KEY `prop_3` (`prop_3`),
  KEY `id_proyecto` (`id_proyecto`),
  KEY `id_prop1` (`id_prop1`),
  KEY `id_prop2` (`id_prop2`),
  KEY `id_prop3` (`id_prop3`),
  KEY `sw_lote` (`sw_lote`),
  KEY `codigo_linea` (`codigo_linea`),
  KEY `codigo_sublinea` (`codigo_sublinea`),
  KEY `codigo_clase` (`codigo_clase`),
  KEY `codigo_subclase` (`codigo_subclase`),
  KEY `precio_publico` (`precio_publico`),
  KEY `codigo_sku_madre` (`codigo_sku_madre`),
  KEY `nombre_archivo` (`nombre_archivo`),
  KEY `pendiente` (`pendiente`),
  KEY `codigo_alternativo_similar` (`codigo_alternativo_similar`),
  KEY `id_impuesto_especifico` (`id_impuesto_especifico`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci COMMENT='Nivel 5';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_productos`
--

LOCK TABLES `tbl_productos` WRITE;
/*!40000 ALTER TABLE `tbl_productos` DISABLE KEYS */;
INSERT INTO `tbl_productos` VALUES (1,0,965,1520347690,965,1520349059,'10001','','P',1,0,0,0,1,1,'1','','','','0','0','',1,'1',1.00,0.00,'GENERICO','','','A',0.00000,0,0.00000,0.00000,0.00000,0,0,0,0,0,0,0.00,0,0.00,0.00,0,0,0,0.00000,0,0,0,0,0,0,0.00,'SC',0,'SC',1,1,1,0,'0','','','',0,0,0,'',0,1,0,0,0,0,'','','',0,0,'',0,0,_binary '\0');
/*!40000 ALTER TABLE `tbl_productos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_productos_atributos`
--

DROP TABLE IF EXISTS `tbl_productos_atributos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_productos_atributos` (
  `id_cuenta` int(10) NOT NULL AUTO_INCREMENT,
  `id_nivel` int(1) NOT NULL DEFAULT '0',
  `id_padre` int(10) NOT NULL DEFAULT '0',
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT '1=activo 0=inactivo',
  `orden` int(10) NOT NULL,
  `ordenamiento` int(10) NOT NULL,
  `sw_bloquear` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT '1=Si 0=No ( Bloquea la modificacion de la  cuenta o grupo de cuentas )',
  `sw_creargrupo` int(10) NOT NULL DEFAULT '0',
  `sw_crearcuenta` int(10) NOT NULL DEFAULT '0',
  `sw_final` int(1) NOT NULL DEFAULT '0',
  `codigo_cuenta` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_alternativo` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `codigo_barras` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `tipo_cuenta` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'A=activo P=Pasivo R=Perdida G=Ganancia  O=Orden  S=Resultado',
  `imputable` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'S=SI N=NO',
  `nombre_cuenta` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `centro_costo` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `centro_ingreso` int(1) NOT NULL DEFAULT '0' COMMENT 'Indica si la cuenta pertenece a un centro de negocios 0=no 1=si',
  `id_centroingreso` int(10) NOT NULL DEFAULT '0' COMMENT 'id del centro de ingreso asociado a la cuenta imputable',
  `id_subclase` int(10) NOT NULL DEFAULT '0',
  `sw_1` int(1) NOT NULL DEFAULT '0' COMMENT 'Ventas',
  `sw_2` int(1) NOT NULL DEFAULT '0' COMMENT 'serviciotecnico',
  `sw_3` int(1) NOT NULL DEFAULT '0' COMMENT 'Adquisiciones',
  `sw_4` int(1) NOT NULL COMMENT 'tesoreria',
  `sw_5` int(1) NOT NULL DEFAULT '0' COMMENT 'recursos humanos',
  `sw_6` int(1) NOT NULL DEFAULT '0' COMMENT 'logistica',
  `auxiliar` int(1) NOT NULL DEFAULT '0' COMMENT '1= si maneja auxiliar 0=no',
  `sw_clave` int(1) NOT NULL,
  `sw_referencia` int(1) NOT NULL,
  `sw_vencimiento` int(1) NOT NULL,
  `sw_auxiliar` int(1) NOT NULL,
  `sw_centrocosto` int(1) NOT NULL,
  `sw_proyecto` int(1) NOT NULL,
  `sw_flujo` int(1) NOT NULL,
  `sw_ctacte` int(1) NOT NULL DEFAULT '0' COMMENT 'indica si maneja cuenta corriente',
  UNIQUE KEY `id_cuenta` (`id_cuenta`),
  KEY `sw_4` (`sw_4`),
  KEY `sw_clave` (`sw_clave`,`sw_referencia`,`sw_vencimiento`,`sw_auxiliar`,`sw_centrocosto`,`sw_proyecto`,`sw_flujo`),
  KEY `orden` (`orden`),
  KEY `sw_5` (`sw_5`,`sw_6`),
  KEY `codigo_barras` (`codigo_barras`),
  KEY `estado` (`estado`),
  KEY `sw_ctacte` (`sw_ctacte`),
  KEY `ordenamiento` (`ordenamiento`),
  KEY `sw_final` (`sw_final`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_productos_atributos`
--

LOCK TABLES `tbl_productos_atributos` WRITE;
/*!40000 ALTER TABLE `tbl_productos_atributos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_productos_atributos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_productos_catalogo`
--

DROP TABLE IF EXISTS `tbl_productos_catalogo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_productos_catalogo` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_centroingreso` int(10) NOT NULL,
  `ancho` int(10) NOT NULL,
  `alto` int(10) NOT NULL,
  `filas` int(10) NOT NULL,
  `columnas` int(10) NOT NULL,
  `espaciado_a` int(10) NOT NULL,
  `espaciado_b` int(10) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `id_centroingreso` (`id_centroingreso`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_productos_catalogo`
--

LOCK TABLES `tbl_productos_catalogo` WRITE;
/*!40000 ALTER TABLE `tbl_productos_catalogo` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_productos_catalogo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_productos_categorias`
--

DROP TABLE IF EXISTS `tbl_productos_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_productos_categorias` (
  `id_cuenta` int(10) NOT NULL AUTO_INCREMENT,
  `id_nivel` int(1) NOT NULL DEFAULT '0',
  `id_padre` int(10) NOT NULL DEFAULT '0',
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT '1=activo 0=inactivo',
  `orden` int(10) NOT NULL,
  `ordenamiento` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL COMMENT 'P=producto m=materia prima I=insumo S=servicios',
  `sw_bloquear` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT '1=Si 0=No ( Bloquea la modificacion de la  cuenta o grupo de cuentas )',
  `sw_creargrupo` int(10) NOT NULL DEFAULT '0',
  `sw_crearcuenta` int(10) NOT NULL DEFAULT '0',
  `sw_final` int(1) NOT NULL DEFAULT '0',
  `codigo_cuenta` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_alternativo` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `codigo_barras` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `tipo_cuenta` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'A=activo P=Pasivo R=Perdida G=Ganancia  O=Orden  S=Resultado',
  `imputable` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'S=SI N=NO',
  `nombre_cuenta` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `valor` int(11) NOT NULL COMMENT 'en caso pilidu se utiliza el valor como peso en grs promedio por categoria de productos',
  `columnas` int(10) NOT NULL,
  `alto` int(10) NOT NULL,
  `ancho` int(10) NOT NULL,
  `espaciado` int(10) NOT NULL,
  `centro_costo` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `centro_ingreso` int(1) NOT NULL DEFAULT '0' COMMENT 'Indica si la cuenta pertenece a un centro de negocios 0=no 1=si',
  `id_centroingreso` int(10) NOT NULL DEFAULT '0' COMMENT 'id del centro de ingreso asociado a la cuenta imputable',
  `id_subclase` int(10) NOT NULL DEFAULT '0',
  `sw_1` int(1) NOT NULL DEFAULT '0' COMMENT 'Ventas',
  `sw_2` int(1) NOT NULL DEFAULT '0' COMMENT 'serviciotecnico',
  `sw_3` int(1) NOT NULL DEFAULT '0' COMMENT 'Adquisiciones',
  `sw_4` int(1) NOT NULL COMMENT 'tesoreria',
  `sw_5` int(1) NOT NULL DEFAULT '0' COMMENT 'recursos humanos',
  `sw_6` int(1) NOT NULL DEFAULT '0' COMMENT 'logistica',
  `auxiliar` int(1) NOT NULL DEFAULT '0' COMMENT '1= si maneja auxiliar 0=no',
  `sw_clave` int(1) NOT NULL,
  `sw_referencia` int(1) NOT NULL,
  `sw_vencimiento` int(1) NOT NULL,
  `sw_auxiliar` int(1) NOT NULL,
  `sw_centrocosto` int(1) NOT NULL,
  `sw_proyecto` int(1) NOT NULL,
  `sw_flujo` int(1) NOT NULL,
  `sw_ctacte` int(1) NOT NULL DEFAULT '0' COMMENT 'indica si maneja cuenta corriente',
  UNIQUE KEY `id_cuenta` (`id_cuenta`),
  KEY `sw_4` (`sw_4`),
  KEY `sw_clave` (`sw_clave`,`sw_referencia`,`sw_vencimiento`,`sw_auxiliar`,`sw_centrocosto`,`sw_proyecto`,`sw_flujo`),
  KEY `orden` (`orden`),
  KEY `sw_5` (`sw_5`,`sw_6`),
  KEY `codigo_barras` (`codigo_barras`),
  KEY `estado` (`estado`),
  KEY `sw_ctacte` (`sw_ctacte`),
  KEY `ordenamiento` (`ordenamiento`),
  KEY `sw_final` (`sw_final`),
  KEY `tipo_item` (`tipo_item`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_productos_categorias`
--

LOCK TABLES `tbl_productos_categorias` WRITE;
/*!40000 ALTER TABLE `tbl_productos_categorias` DISABLE KEYS */;
INSERT INTO `tbl_productos_categorias` VALUES (1,0,0,1,0,0,'','0',1,1,1,'01','1','','','N','GENERICA',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
/*!40000 ALTER TABLE `tbl_productos_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_productos_historial_stocks`
--

DROP TABLE IF EXISTS `tbl_productos_historial_stocks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_productos_historial_stocks` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_usuario` int(10) NOT NULL,
  `timen` int(10) NOT NULL,
  `fecha` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `hora` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `codigo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `stock` decimal(12,2) NOT NULL,
  `reserva` decimal(12,2) NOT NULL,
  `disponible` decimal(12,2) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_productos_historial_stocks`
--

LOCK TABLES `tbl_productos_historial_stocks` WRITE;
/*!40000 ALTER TABLE `tbl_productos_historial_stocks` DISABLE KEYS */;
INSERT INTO `tbl_productos_historial_stocks` VALUES (1,841,1513798341,'20/12/2017','16:32:21','10067',10.00,-10.00,20.00);
/*!40000 ALTER TABLE `tbl_productos_historial_stocks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_productos_imagenes`
--

DROP TABLE IF EXISTS `tbl_productos_imagenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_productos_imagenes` (
  `id_imagen` int(10) NOT NULL,
  `tipo_imagen` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_registro` int(10) NOT NULL,
  `codigo_producto` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_complementario` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `nombre` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  KEY `id_imagen` (`id_imagen`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_productos_imagenes`
--

LOCK TABLES `tbl_productos_imagenes` WRITE;
/*!40000 ALTER TABLE `tbl_productos_imagenes` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_productos_imagenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_productos_items`
--

DROP TABLE IF EXISTS `tbl_productos_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_productos_items` (
  `id_producto` int(10) NOT NULL AUTO_INCREMENT,
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `time_creacion` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `id_producto` (`id_producto`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci COMMENT='esta tabla es solo para obtener un id automatico incremental';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_productos_items`
--

LOCK TABLES `tbl_productos_items` WRITE;
/*!40000 ALTER TABLE `tbl_productos_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_productos_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_productos_listaprecios`
--

DROP TABLE IF EXISTS `tbl_productos_listaprecios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_productos_listaprecios` (
  `id` int(1) NOT NULL AUTO_INCREMENT,
  `nombre` char(32) COLLATE utf8_spanish_ci NOT NULL,
  `clase` int(1) NOT NULL COMMENT '0=todoslositems 1=soloitemsseleccionados',
  `tipo` int(1) NOT NULL COMMENT '0=descuento 1=recargo',
  `valor` decimal(12,2) NOT NULL COMMENT 'valor del descuento o recargo',
  `formato` char(1) COLLATE utf8_spanish_ci NOT NULL COMMENT '$ o %',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_productos_listaprecios`
--

LOCK TABLES `tbl_productos_listaprecios` WRITE;
/*!40000 ALTER TABLE `tbl_productos_listaprecios` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_productos_listaprecios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_productos_listaprecios_detalle`
--

DROP TABLE IF EXISTS `tbl_productos_listaprecios_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_productos_listaprecios_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_lista` int(10) NOT NULL,
  `codigo` varchar(32) NOT NULL,
  `valor` decimal(12,2) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `id_lista` (`id_lista`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_productos_listaprecios_detalle`
--

LOCK TABLES `tbl_productos_listaprecios_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_productos_listaprecios_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_productos_listaprecios_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_productos_procesos`
--

DROP TABLE IF EXISTS `tbl_productos_procesos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_productos_procesos` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT '1=activo 0=inactivo',
  `orden` int(10) NOT NULL,
  `codigo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_productos_procesos`
--

LOCK TABLES `tbl_productos_procesos` WRITE;
/*!40000 ALTER TABLE `tbl_productos_procesos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_productos_procesos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_productos_propiedades`
--

DROP TABLE IF EXISTS `tbl_productos_propiedades`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_productos_propiedades` (
  `id_propiedad` int(10) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL DEFAULT '1',
  `orden` int(10) NOT NULL,
  `nombre` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id_propiedad` (`id_propiedad`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_productos_propiedades`
--

LOCK TABLES `tbl_productos_propiedades` WRITE;
/*!40000 ALTER TABLE `tbl_productos_propiedades` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_productos_propiedades` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_productos_propiedades_detalle`
--

DROP TABLE IF EXISTS `tbl_productos_propiedades_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_productos_propiedades_detalle` (
  `id_detalle` int(10) NOT NULL AUTO_INCREMENT,
  `id_propiedad` int(10) NOT NULL,
  `codigo_producto` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id_detalle` (`id_detalle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_productos_propiedades_detalle`
--

LOCK TABLES `tbl_productos_propiedades_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_productos_propiedades_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_productos_propiedades_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_productos_proveedores`
--

DROP TABLE IF EXISTS `tbl_productos_proveedores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_productos_proveedores` (
  `id_registro` int(10) NOT NULL DEFAULT '0',
  `id_fecha_compra` int(10) NOT NULL DEFAULT '0',
  `id_proveedor` int(10) NOT NULL DEFAULT '0',
  `codigo_producto` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `precio_compra` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `id_registro` (`id_registro`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_productos_proveedores`
--

LOCK TABLES `tbl_productos_proveedores` WRITE;
/*!40000 ALTER TABLE `tbl_productos_proveedores` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_productos_proveedores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_productos_series`
--

DROP TABLE IF EXISTS `tbl_productos_series`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_productos_series` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_bodega` int(10) NOT NULL,
  `id_zona` int(10) NOT NULL,
  `sw_imprimir` int(1) NOT NULL,
  `tipo_documento` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'tipo docto con el que se realizo el ingreso del item por ej. PI=ParteEntrada',
  `folio_documento` int(10) NOT NULL COMMENT 'folio del docto con el cual ingreso el item',
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `codigo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `numero_serie` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `numero_lote` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `estado` int(1) NOT NULL DEFAULT '1',
  `fecha_ingreso` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_ingreso` int(10) NOT NULL,
  `usuario_ingreso` int(10) NOT NULL,
  `fecha_egreso` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_egreso` int(10) NOT NULL,
  `usuario_egreso` int(10) NOT NULL,
  `documento_egreso` char(3) COLLATE utf8_spanish_ci NOT NULL COMMENT 'ps=parte salida etc...',
  `folio_documento_egreso` int(10) NOT NULL,
  `cantidad` decimal(12,2) NOT NULL COMMENT 'cantidad neto',
  `sw_audito` int(1) NOT NULL,
  `usuario_audito` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `time_audito` int(10) NOT NULL,
  `cantidad_consumida` decimal(12,2) NOT NULL,
  `cantidad_bruto` decimal(12,2) NOT NULL COMMENT 'ej. peso bruto para el caso de telas',
  `cantidad_disponible` decimal(12,2) NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `obs_audito` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `codigo` (`codigo`),
  KEY `numero_serie` (`numero_serie`),
  KEY `numero_lote` (`numero_lote`),
  KEY `fecha_ingreso` (`fecha_ingreso`),
  KEY `time_ingreso` (`time_ingreso`),
  KEY `cantidad` (`cantidad`),
  KEY `cantidad_bruto` (`cantidad_bruto`),
  KEY `id_bodega` (`id_bodega`),
  KEY `usuario_ingreso` (`usuario_ingreso`),
  KEY `tipo_documento` (`tipo_documento`),
  KEY `folio_documento` (`folio_documento`),
  KEY `cantidad_disponible` (`cantidad_disponible`),
  KEY `fecha_egreso` (`fecha_egreso`),
  KEY `time_egreso` (`time_egreso`),
  KEY `usuario_egreso` (`usuario_egreso`),
  KEY `estado` (`estado`),
  KEY `tipo_item` (`tipo_item`),
  KEY `documento_egreso` (`documento_egreso`),
  KEY `folio_documento_egreso` (`folio_documento_egreso`),
  KEY `id_zona` (`id_zona`),
  KEY `cantidad_consumida` (`cantidad_consumida`),
  KEY `sw_imprimir` (`sw_imprimir`),
  KEY `sw_audito` (`sw_audito`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_productos_series`
--

LOCK TABLES `tbl_productos_series` WRITE;
/*!40000 ALTER TABLE `tbl_productos_series` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_productos_series` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_programaestudios`
--

DROP TABLE IF EXISTS `tbl_programaestudios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_programaestudios` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `time` int(10) NOT NULL,
  `id_usuario` int(10) NOT NULL,
  `codigo_servicio` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `objetivos` text COLLATE utf8_spanish_ci NOT NULL,
  `duracion` text COLLATE utf8_spanish_ci NOT NULL,
  `metodologia` text COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` text COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `time` (`time`,`id_usuario`,`codigo_servicio`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_programaestudios`
--

LOCK TABLES `tbl_programaestudios` WRITE;
/*!40000 ALTER TABLE `tbl_programaestudios` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_programaestudios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_programaestudios_detalle`
--

DROP TABLE IF EXISTS `tbl_programaestudios_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_programaestudios_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `codigo_carrera` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `orden` int(10) NOT NULL,
  `descripcion` text COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `orden` (`orden`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_programaestudios_detalle`
--

LOCK TABLES `tbl_programaestudios_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_programaestudios_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_programaestudios_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_proveedores`
--

DROP TABLE IF EXISTS `tbl_proveedores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_proveedores` (
  `id_proveedor` int(10) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL DEFAULT '0' COMMENT '1=activo 0=inactivo',
  `rut` varchar(12) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `letras_codigo` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'en este campo almaceno las 2 letras finales de cada proveedor',
  `razon_social` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_fantasia` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `giro` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_comuna` int(10) NOT NULL DEFAULT '0',
  `id_ciudad` int(10) NOT NULL DEFAULT '0',
  `id_region` int(10) NOT NULL DEFAULT '0',
  `telefonos` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `contacto` varchar(200) COLLATE utf8_spanish_ci NOT NULL,
  `fax` varchar(15) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `email` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `sitio_web` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `tipo_proveedor` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'N=nacional E=extranjero',
  `proveedor_delgiro` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'S=si N=no A=ambos',
  `tipo_productos` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'tipo de productos que vende utilizando 2 primeras letras del codigo del producto y separadas por guion',
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'observaciones de retiro de productos y/o documentos',
  `direccion_ruteo` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `comuna` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `forma_pago` int(1) NOT NULL DEFAULT '0',
  `vencimiento_proveedor` int(1) NOT NULL DEFAULT '0',
  `linea_credito` int(10) NOT NULL DEFAULT '0',
  `documentado` int(1) NOT NULL DEFAULT '0',
  `ubicacion_ruteo` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `pago_efectivo` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `pago_condiciones` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `pago_documentar` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `vencimiento_facturacion` int(1) NOT NULL DEFAULT '0',
  `tipo_facturacion` int(1) NOT NULL DEFAULT '0' COMMENT '1=afecto 2=exentoso 3=ambos',
  `codigo_cuenta` int(10) NOT NULL,
  `factura_electronica` int(1) NOT NULL,
  `contacto_cobranza` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `comuna_ruteo` varchar(222) COLLATE utf8_spanish_ci NOT NULL,
  `mail_cobranza` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `fono_cobranza` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `sw_produccion` int(1) NOT NULL DEFAULT '0' COMMENT 'indica que es un proveedor de producción',
  `sw_factoring` int(1) NOT NULL,
  `codigo_alternativo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `rut` (`rut`),
  UNIQUE KEY `id_proveedor` (`id_proveedor`),
  KEY `codigo_cuenta` (`codigo_cuenta`,`factura_electronica`),
  KEY `sw_produccion` (`sw_produccion`),
  KEY `codigo_alternativo` (`codigo_alternativo`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_proveedores`
--

LOCK TABLES `tbl_proveedores` WRITE;
/*!40000 ALTER TABLE `tbl_proveedores` DISABLE KEYS */;
INSERT INTO `tbl_proveedores` VALUES (1,1,'11111111-1','0','GENERICO','','GENERICO','RAMON SUBERCASEUX 1268 DEPTO 1007',274,0,0,'22222222','GENERICO','','camilo.araneda@controler.cl','','N','0','0','0','0','0',2,0,0,0,'0','0','0','0',0,0,0,0,'','','','',1,0,'');
/*!40000 ALTER TABLE `tbl_proveedores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_proveedores_productos`
--

DROP TABLE IF EXISTS `tbl_proveedores_productos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_proveedores_productos` (
  `id_proveedor` int(10) NOT NULL DEFAULT '0',
  `id_registro` int(10) NOT NULL DEFAULT '0',
  `id_compra` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp con fecha y hora de la compra',
  `codigo_producto` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `precio_compra` int(10) NOT NULL DEFAULT '0',
  `fecha_compra` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  KEY `codigo_producto` (`codigo_producto`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_proveedores_productos`
--

LOCK TABLES `tbl_proveedores_productos` WRITE;
/*!40000 ALTER TABLE `tbl_proveedores_productos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_proveedores_productos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_proveedores_sucursales`
--

DROP TABLE IF EXISTS `tbl_proveedores_sucursales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_proveedores_sucursales` (
  `id_sucursal` int(10) NOT NULL AUTO_INCREMENT,
  `orden` int(10) NOT NULL,
  `estado` int(1) NOT NULL DEFAULT '1',
  `id_proveedor` int(10) NOT NULL,
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `direccion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id_sucursal` (`id_sucursal`),
  KEY `id_proveedor` (`id_proveedor`),
  KEY `orden` (`orden`),
  KEY `estado` (`estado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_proveedores_sucursales`
--

LOCK TABLES `tbl_proveedores_sucursales` WRITE;
/*!40000 ALTER TABLE `tbl_proveedores_sucursales` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_proveedores_sucursales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_provincias`
--

DROP TABLE IF EXISTS `tbl_provincias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_provincias` (
  `id_provincia` int(10) NOT NULL AUTO_INCREMENT,
  `id_region` decimal(2,0) NOT NULL DEFAULT '0',
  `numero` varchar(3) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  UNIQUE KEY `id_provincia` (`id_provincia`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_provincias`
--

LOCK TABLES `tbl_provincias` WRITE;
/*!40000 ALTER TABLE `tbl_provincias` DISABLE KEYS */;
INSERT INTO `tbl_provincias` VALUES (1,1,'1','ARICA'),(2,1,'2','PARINACOTA'),(3,2,'1','IQUIQUE'),(4,2,'1','TAMARUGAL'),(5,3,'1','ANTOFAGASTA'),(6,3,'2','EL LOA'),(7,3,'1','TOCOPILLA'),(8,4,'1','COPIAPÓ'),(9,4,'1','CHAÑARAL'),(10,4,'1','HUASCO'),(11,5,'1','ELQUI'),(12,5,'1','CHOAPA'),(13,5,'1','LIMARÍ'),(14,6,'1','VALPARAÍSO'),(15,6,'1','ISLA DE PASCUA'),(16,6,'1','LOS ANDES'),(17,6,'1','PETORCA'),(18,6,'1','QUILLOTA'),(19,6,'1','SAN ANTONIO'),(20,6,'1','SAN FELIPE DE ACONCAGUA'),(21,6,'1','MARGA MARGA'),(22,7,'1','CACHAPOAL'),(23,7,'1','CARDENAL CARO'),(24,7,'1','COLCHAGUA'),(25,8,'1','TALCA'),(26,8,'1','CAUQUENES'),(27,8,'1','CURICÓ'),(28,8,'1','LINARES'),(29,9,'1','CONCEPCIÓN'),(30,9,'1','ARAUCO'),(31,9,'1','BIOBÍO'),(32,9,'1','ÑUBLE'),(33,10,'1','CAUTÍN'),(34,10,'1','MALLECO'),(35,11,'1','VALDIVIA'),(36,11,'1','RANCO'),(37,12,'1','LLANQUIHUE'),(38,12,'1','CHILOÉ'),(39,12,'1','OSORNO'),(40,12,'1','PALENA'),(41,13,'1','COIHAIQUE'),(43,13,'1','CPITÁN PRAT'),(44,13,'1','CAPITÁN PRAT'),(45,13,'1','AISÉN'),(46,13,'1','GENERAL CARRERA'),(47,14,'1','MAGALLANES'),(48,14,'1','ANTÁRTICA CHILENA'),(49,14,'1','TIERRA DE FUEGO'),(50,14,'1','ULTIMA ESPERANZA'),(51,15,'1','SANTIAGO'),(52,15,'1','CORDILLERA'),(53,15,'1','CHACABUCO'),(54,15,'1','MAIPO'),(55,15,'1','MELIPILLA'),(56,15,'1','TALAGANTE');
/*!40000 ALTER TABLE `tbl_provincias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_proyectos`
--

DROP TABLE IF EXISTS `tbl_proyectos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_proyectos` (
  `id_proyecto` int(10) NOT NULL AUTO_INCREMENT,
  `ordenamiento` int(10) NOT NULL,
  `codigo_proyecto` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `nombre_proyecto` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `descripcion` text COLLATE utf8_spanish_ci NOT NULL,
  `numero_contrato` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `estado` int(1) NOT NULL DEFAULT '0' COMMENT '0=Nulo 1=en Proceso 2=Finalizado',
  `time_inicio` int(10) NOT NULL DEFAULT '0' COMMENT 'Fecha de Inicio',
  `time_termino` int(10) NOT NULL DEFAULT '0' COMMENT 'Fecha finalizacion del proyecto',
  `time_termino_estimado` int(10) NOT NULL DEFAULT '0' COMMENT 'Fecha de Término estimada',
  `insumos_estimado` int(10) NOT NULL DEFAULT '0',
  `materiaprima_estimado` int(10) NOT NULL DEFAULT '0',
  `manoobra_estimado` int(10) NOT NULL DEFAULT '0',
  `depreciacion_estimado` int(10) NOT NULL DEFAULT '0',
  `cantidad_realizar` int(10) NOT NULL DEFAULT '0' COMMENT 'Cantidad de unidades a realizar',
  UNIQUE KEY `id_proyecto` (`id_proyecto`),
  KEY `codigo_proyecto` (`codigo_proyecto`),
  KEY `ordenamiento` (`ordenamiento`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_proyectos`
--

LOCK TABLES `tbl_proyectos` WRITE;
/*!40000 ALTER TABLE `tbl_proyectos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_proyectos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_puntoventa_detalle`
--

DROP TABLE IF EXISTS `tbl_puntoventa_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_puntoventa_detalle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `item` int(10) NOT NULL,
  `tipo` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `codigo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `unitario` decimal(12,2) NOT NULL,
  `cantidad` decimal(12,2) NOT NULL,
  `subtotal` decimal(12,2) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `folio` (`folio`),
  KEY `item` (`item`),
  KEY `tipo` (`tipo`),
  KEY `codigo` (`codigo`),
  KEY `descripcion` (`descripcion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_puntoventa_detalle`
--

LOCK TABLES `tbl_puntoventa_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_puntoventa_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_puntoventa_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_recetas`
--

DROP TABLE IF EXISTS `tbl_recetas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_recetas` (
  `id_transaccion` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion del comprobante contable',
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `id_modificacion` int(10) NOT NULL COMMENT 'usuario de la ultima modificacion de la receta',
  `time_modificacion` int(10) NOT NULL COMMENT 'time de la ultima modificacion de la receta',
  `tipo_receta` int(1) NOT NULL COMMENT '0=sindefinir 1=receta para articulo 2=receta para orden de produccion',
  `origen` int(1) NOT NULL COMMENT '0=creada manualmente 1=creada auto desde item ',
  `folio_ordenproduccion` int(10) NOT NULL,
  `codigo_final` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `cantidad_simulacion` decimal(12,2) NOT NULL,
  `codigo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_item_ordenproduccion` int(10) NOT NULL,
  `codigo_item_ordenproduccion` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_ejecucion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_ejecucion` int(10) NOT NULL,
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL,
  `id_bodega` int(10) NOT NULL COMMENT 'id bodega de destino',
  `id_centrocosto` int(10) NOT NULL,
  `id_centronegocio` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `id_solicita` int(10) NOT NULL,
  `id_autoriza` int(10) NOT NULL,
  `id_ejecuta` int(10) NOT NULL,
  `cuenta_origen` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'contracuenta de la contabilizacion ej. merc. nac v/s cuenta_origen',
  `total` int(10) NOT NULL,
  `estado` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `rentabilidad` int(10) NOT NULL,
  UNIQUE KEY `folio` (`folio`),
  KEY `estado` (`estado`),
  KEY `id_sucursal` (`id_sucursal`,`id_centrocosto`,`id_centronegocio`,`id_proyecto`),
  KEY `fecha_ejecucion` (`fecha_ejecucion`),
  KEY `time_ejecucion` (`time_ejecucion`),
  KEY `id_solicita` (`id_solicita`,`id_autoriza`,`id_ejecuta`),
  KEY `cuenta_origen` (`cuenta_origen`),
  KEY `id_bodega` (`id_bodega`),
  KEY `tipo_receta` (`tipo_receta`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`),
  KEY `id_item_ordenproduccion` (`id_item_ordenproduccion`),
  KEY `codigo_item_ordenproduccion` (`codigo_item_ordenproduccion`),
  KEY `descripcion` (`descripcion`),
  KEY `codigo_final` (`codigo_final`),
  KEY `origen` (`origen`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_recetas`
--

LOCK TABLES `tbl_recetas` WRITE;
/*!40000 ALTER TABLE `tbl_recetas` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_recetas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_recetas_detalle`
--

DROP TABLE IF EXISTS `tbl_recetas_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_recetas_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `tipo_receta` int(1) NOT NULL COMMENT '0=sindefinir 1=receta para articulo 2=receta para orden de produccion',
  `folio_ordenproduccion` int(10) NOT NULL,
  `id_item_ordenproduccion` int(10) NOT NULL,
  `codigo_item_ordenproduccion` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_final` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_usuario` int(10) NOT NULL COMMENT 'id del usuario creador de la linea 1=Sistema',
  `time_creacion_registro` int(10) NOT NULL,
  `id_item` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `codigo` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'Indica al boucher si la linea ha sido finalizada 1=Si 0=No',
  `descripcion` varchar(177) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT 'ID del proyecto asociado a la linea contable que genero el cargo u/o abono',
  `cantidad` decimal(13,3) NOT NULL,
  `unitario` decimal(13,3) NOT NULL,
  `subtotal` int(10) NOT NULL,
  `observaciones` varchar(247) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `id` (`id`),
  KEY `folio` (`folio`),
  KEY `id_item` (`id_item`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `time_creacion_registro` (`time_creacion_registro`),
  KEY `tipo_item` (`tipo_item`),
  KEY `codigo` (`codigo`),
  KEY `tipo_receta` (`tipo_receta`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`,`id_item_ordenproduccion`),
  KEY `codigo_item_ordenproduccion` (`codigo_item_ordenproduccion`),
  KEY `codigo_final` (`codigo_final`),
  KEY `descripcion` (`descripcion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_recetas_detalle`
--

LOCK TABLES `tbl_recetas_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_recetas_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_recetas_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_recetas_op`
--

DROP TABLE IF EXISTS `tbl_recetas_op`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_recetas_op` (
  `id_transaccion` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion del comprobante contable',
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `id_modificacion` int(10) NOT NULL COMMENT 'usuario de la ultima modificacion de la receta',
  `time_modificacion` int(10) NOT NULL COMMENT 'time de la ultima modificacion de la receta',
  `tipo_receta` int(1) NOT NULL COMMENT '0=sindefinir 1=receta para articulo 2=receta para orden de produccion',
  `origen` int(1) NOT NULL COMMENT '0=creada manualmente 1=creada auto desde item ',
  `folio_ordenproduccion` int(10) NOT NULL,
  `codigo_final` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `cantidad_simulacion` decimal(12,2) NOT NULL,
  `codigo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_item_ordenproduccion` int(10) NOT NULL,
  `codigo_item_ordenproduccion` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_ejecucion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_ejecucion` int(10) NOT NULL,
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL,
  `id_bodega` int(10) NOT NULL COMMENT 'id bodega de destino',
  `id_centrocosto` int(10) NOT NULL,
  `id_centronegocio` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `id_solicita` int(10) NOT NULL,
  `id_autoriza` int(10) NOT NULL,
  `id_ejecuta` int(10) NOT NULL,
  `cuenta_origen` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'contracuenta de la contabilizacion ej. merc. nac v/s cuenta_origen',
  `total` int(10) NOT NULL,
  `estado` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `folio` (`folio`),
  KEY `estado` (`estado`),
  KEY `id_sucursal` (`id_sucursal`,`id_centrocosto`,`id_centronegocio`,`id_proyecto`),
  KEY `fecha_ejecucion` (`fecha_ejecucion`),
  KEY `time_ejecucion` (`time_ejecucion`),
  KEY `id_solicita` (`id_solicita`,`id_autoriza`,`id_ejecuta`),
  KEY `cuenta_origen` (`cuenta_origen`),
  KEY `id_bodega` (`id_bodega`),
  KEY `tipo_receta` (`tipo_receta`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`),
  KEY `id_item_ordenproduccion` (`id_item_ordenproduccion`),
  KEY `codigo_item_ordenproduccion` (`codigo_item_ordenproduccion`),
  KEY `descripcion` (`descripcion`),
  KEY `codigo_final` (`codigo_final`),
  KEY `origen` (`origen`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_recetas_op`
--

LOCK TABLES `tbl_recetas_op` WRITE;
/*!40000 ALTER TABLE `tbl_recetas_op` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_recetas_op` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_recetas_op_detalle`
--

DROP TABLE IF EXISTS `tbl_recetas_op_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_recetas_op_detalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `tipo_receta` int(1) NOT NULL COMMENT '0=sindefinir 1=receta para articulo 2=receta para orden de produccion',
  `folio_ordenproduccion` int(10) NOT NULL,
  `id_item_ordenproduccion` int(10) NOT NULL,
  `codigo_item_ordenproduccion` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_final` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_usuario` int(10) NOT NULL COMMENT 'id del usuario creador de la linea 1=Sistema',
  `time_creacion_registro` int(10) NOT NULL,
  `id_item` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL,
  `codigo` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'Indica al boucher si la linea ha sido finalizada 1=Si 0=No',
  `descripcion` varchar(177) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT 'ID del proyecto asociado a la linea contable que genero el cargo u/o abono',
  `cantidad` decimal(13,3) NOT NULL,
  `unitario` decimal(13,3) NOT NULL,
  `subtotal` int(10) NOT NULL,
  `observaciones` varchar(247) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `id` (`id`),
  KEY `folio` (`folio`),
  KEY `id_item` (`id_item`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `time_creacion_registro` (`time_creacion_registro`),
  KEY `tipo_item` (`tipo_item`),
  KEY `codigo` (`codigo`),
  KEY `tipo_receta` (`tipo_receta`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`,`id_item_ordenproduccion`),
  KEY `codigo_item_ordenproduccion` (`codigo_item_ordenproduccion`),
  KEY `codigo_final` (`codigo_final`),
  KEY `descripcion` (`descripcion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_recetas_op_detalle`
--

LOCK TABLES `tbl_recetas_op_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_recetas_op_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_recetas_op_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_referencias_documentos`
--

DROP TABLE IF EXISTS `tbl_referencias_documentos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_referencias_documentos` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `tipo_dte_origen` int(3) NOT NULL,
  `folio_dte_origen` int(10) NOT NULL,
  `tipo_dte_referencia` char(3) COLLATE utf8_spanish_ci NOT NULL,
  `folio_dte_referencia` int(10) NOT NULL,
  `fecha_dte_referencia` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_referencia` int(1) NOT NULL COMMENT '1=anula 2=corrigetextos 3=corrigevalores',
  `razon_referencia` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_referencias_documentos`
--

LOCK TABLES `tbl_referencias_documentos` WRITE;
/*!40000 ALTER TABLE `tbl_referencias_documentos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_referencias_documentos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_regiones`
--

DROP TABLE IF EXISTS `tbl_regiones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_regiones` (
  `id_region` int(2) NOT NULL AUTO_INCREMENT,
  `numero` varchar(4) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `nombre` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  UNIQUE KEY `id_region` (`id_region`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_regiones`
--

LOCK TABLES `tbl_regiones` WRITE;
/*!40000 ALTER TABLE `tbl_regiones` DISABLE KEYS */;
INSERT INTO `tbl_regiones` VALUES (1,'','ARICA Y PARINACOTA'),(2,'','TARAPACÁ'),(3,'','ANTOFAGASTA'),(4,'','ATACAMA'),(5,'','COQUIMBO'),(6,'','VALPARAÍSO'),(7,'','DEL LIBERTADOR GRAL. BERNARDO O´HIGGINS'),(8,'','DEL MAULE'),(9,'','DEL BIOBÍO'),(10,'','DE LA ARAUCANÍA'),(11,'','DE LOS RÍOS'),(12,'','DE LOS LAGOS '),(13,'','AISÉN DEL GRAL. CARLOS IBÁÑEZ DEL CAMPO'),(14,'','MAGALLANES Y DE LA ANTÁRTICA'),(15,'','METROPOLITANA DE SANTIAGO');
/*!40000 ALTER TABLE `tbl_regiones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_remuneraciones_anticipos`
--

DROP TABLE IF EXISTS `tbl_remuneraciones_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_remuneraciones_anticipos` (
  `id_registro` int(10) NOT NULL AUTO_INCREMENT,
  `nombres` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario que autorizo el anticipo',
  `id_empleado` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'id del empleado que solicito el anticipo',
  `id_usuario` int(10) NOT NULL,
  `id_autorizador` int(10) NOT NULL,
  `monto` int(10) NOT NULL DEFAULT '0',
  `mes` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `ano` int(4) NOT NULL,
  UNIQUE KEY `id_registro` (`id_registro`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_remuneraciones_anticipos`
--

LOCK TABLES `tbl_remuneraciones_anticipos` WRITE;
/*!40000 ALTER TABLE `tbl_remuneraciones_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_remuneraciones_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_remuneraciones_asistencia`
--

DROP TABLE IF EXISTS `tbl_remuneraciones_asistencia`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_remuneraciones_asistencia` (
  `id_empleado` int(10) NOT NULL,
  `mes` int(10) NOT NULL,
  `ano` int(10) NOT NULL,
  `dias` int(10) NOT NULL,
  `horas` int(10) NOT NULL,
  `licencia` int(10) NOT NULL,
  `vacaciones` int(10) NOT NULL,
  `horas50` int(10) NOT NULL,
  `horas100` int(10) NOT NULL,
  UNIQUE KEY `id_empleado` (`id_empleado`),
  UNIQUE KEY `id_empleado_2` (`id_empleado`),
  UNIQUE KEY `id_empleado_3` (`id_empleado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_remuneraciones_asistencia`
--

LOCK TABLES `tbl_remuneraciones_asistencia` WRITE;
/*!40000 ALTER TABLE `tbl_remuneraciones_asistencia` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_remuneraciones_asistencia` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_remuneraciones_cajacom`
--

DROP TABLE IF EXISTS `tbl_remuneraciones_cajacom`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_remuneraciones_cajacom` (
  `id_caja` int(10) NOT NULL,
  `nombre_caja` varchar(50) COLLATE utf8_spanish_ci NOT NULL,
  `tasa` int(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_remuneraciones_cajacom`
--

LOCK TABLES `tbl_remuneraciones_cajacom` WRITE;
/*!40000 ALTER TABLE `tbl_remuneraciones_cajacom` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_remuneraciones_cajacom` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_remuneraciones_familiar`
--

DROP TABLE IF EXISTS `tbl_remuneraciones_familiar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_remuneraciones_familiar` (
  `id_familiar` int(11) NOT NULL,
  `tramo` int(10) NOT NULL,
  `desde` int(10) NOT NULL,
  `hasta` int(10) NOT NULL,
  `monto` int(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_remuneraciones_familiar`
--

LOCK TABLES `tbl_remuneraciones_familiar` WRITE;
/*!40000 ALTER TABLE `tbl_remuneraciones_familiar` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_remuneraciones_familiar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_remuneraciones_haberes`
--

DROP TABLE IF EXISTS `tbl_remuneraciones_haberes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_remuneraciones_haberes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(11) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  `cuenta_contable` varchar(5) NOT NULL,
  `nombre_cuenta_contable` varchar(25) NOT NULL,
  `codigo_previred` varchar(11) NOT NULL,
  `tipo` int(1) NOT NULL COMMENT '0 = porcentaje, 1=pesos',
  `porcentaje` decimal(3,2) NOT NULL,
  `pesos` int(11) NOT NULL,
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_remuneraciones_haberes`
--

LOCK TABLES `tbl_remuneraciones_haberes` WRITE;
/*!40000 ALTER TABLE `tbl_remuneraciones_haberes` DISABLE KEYS */;
INSERT INTO `tbl_remuneraciones_haberes` VALUES (11,'1','SUELDO BASE','IC','Iva Crédito Fiscal','222',1,0.00,280000);
/*!40000 ALTER TABLE `tbl_remuneraciones_haberes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_remuneraciones_mantencion_afp`
--

DROP TABLE IF EXISTS `tbl_remuneraciones_mantencion_afp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_remuneraciones_mantencion_afp` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `orden` int(10) NOT NULL,
  `nombre_afp` varchar(255) NOT NULL,
  `tasas_afpd` decimal(12,2) NOT NULL,
  `tasas_afpd_sis` decimal(12,2) NOT NULL,
  `tasas_afpi` decimal(12,2) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_remuneraciones_mantencion_afp`
--

LOCK TABLES `tbl_remuneraciones_mantencion_afp` WRITE;
/*!40000 ALTER TABLE `tbl_remuneraciones_mantencion_afp` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_remuneraciones_mantencion_afp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_remuneraciones_mantencion_salud`
--

DROP TABLE IF EXISTS `tbl_remuneraciones_mantencion_salud`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_remuneraciones_mantencion_salud` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `orden` int(10) NOT NULL,
  `nombre_isapre` varchar(255) NOT NULL,
  `unidad` int(1) NOT NULL,
  `cantidad` decimal(12,2) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_remuneraciones_mantencion_salud`
--

LOCK TABLES `tbl_remuneraciones_mantencion_salud` WRITE;
/*!40000 ALTER TABLE `tbl_remuneraciones_mantencion_salud` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_remuneraciones_mantencion_salud` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_remuneraciones_parametros`
--

DROP TABLE IF EXISTS `tbl_remuneraciones_parametros`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_remuneraciones_parametros` (
  `id_parametro` int(10) NOT NULL,
  `sueldo_min1` int(10) NOT NULL,
  `sueldo_min2` int(10) NOT NULL,
  `sueldo_min3` int(10) NOT NULL,
  `uf` int(10) NOT NULL,
  `utm` int(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_remuneraciones_parametros`
--

LOCK TABLES `tbl_remuneraciones_parametros` WRITE;
/*!40000 ALTER TABLE `tbl_remuneraciones_parametros` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_remuneraciones_parametros` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_remuneraciones_salud`
--

DROP TABLE IF EXISTS `tbl_remuneraciones_salud`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_remuneraciones_salud` (
  `id_salud` int(10) NOT NULL DEFAULT '0',
  `salud` varchar(25) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_remuneraciones_salud`
--

LOCK TABLES `tbl_remuneraciones_salud` WRITE;
/*!40000 ALTER TABLE `tbl_remuneraciones_salud` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_remuneraciones_salud` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_rendiciongastos`
--

DROP TABLE IF EXISTS `tbl_rendiciongastos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_rendiciongastos` (
  `id_rendicion` int(11) NOT NULL AUTO_INCREMENT,
  `fecha` varchar(10) NOT NULL,
  `estado` varchar(2) NOT NULL,
  `concepto` varchar(200) NOT NULL,
  `total` int(10) NOT NULL,
  `id_trabajador` int(5) NOT NULL,
  PRIMARY KEY (`id_rendicion`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_rendiciongastos`
--

LOCK TABLES `tbl_rendiciongastos` WRITE;
/*!40000 ALTER TABLE `tbl_rendiciongastos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_rendiciongastos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_rendiciongastos_detalle`
--

DROP TABLE IF EXISTS `tbl_rendiciongastos_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_rendiciongastos_detalle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_rendicion` int(11) NOT NULL,
  `id_gasto` int(11) NOT NULL,
  `descripcion` varchar(100) NOT NULL,
  `monto` int(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_rendiciongastos_detalle`
--

LOCK TABLES `tbl_rendiciongastos_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_rendiciongastos_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_rendiciongastos_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_rentaafecta_pesos`
--

DROP TABLE IF EXISTS `tbl_rentaafecta_pesos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_rentaafecta_pesos` (
  `id_renta` int(11) NOT NULL AUTO_INCREMENT,
  `desde` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `hasta` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `tasa` decimal(15,2) NOT NULL DEFAULT '0.00',
  `rebaja` decimal(15,5) NOT NULL,
  PRIMARY KEY (`id_renta`),
  UNIQUE KEY `id_renta` (`id_renta`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_rentaafecta_pesos`
--

LOCK TABLES `tbl_rentaafecta_pesos` WRITE;
/*!40000 ALTER TABLE `tbl_rentaafecta_pesos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_rentaafecta_pesos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_rentaafecta_utm`
--

DROP TABLE IF EXISTS `tbl_rentaafecta_utm`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_rentaafecta_utm` (
  `id_renta` int(11) NOT NULL AUTO_INCREMENT,
  `desde` decimal(15,0) NOT NULL DEFAULT '0',
  `hasta` decimal(15,1) NOT NULL DEFAULT '0.0',
  `tasa` decimal(15,0) NOT NULL DEFAULT '0',
  `rebaja` decimal(15,3) NOT NULL,
  PRIMARY KEY (`id_renta`),
  UNIQUE KEY `id_renta` (`id_renta`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_rentaafecta_utm`
--

LOCK TABLES `tbl_rentaafecta_utm` WRITE;
/*!40000 ALTER TABLE `tbl_rentaafecta_utm` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_rentaafecta_utm` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_rentaimponibleminimo`
--

DROP TABLE IF EXISTS `tbl_rentaimponibleminimo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_rentaimponibleminimo` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `monto` int(10) NOT NULL,
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_rentaimponibleminimo`
--

LOCK TABLES `tbl_rentaimponibleminimo` WRITE;
/*!40000 ALTER TABLE `tbl_rentaimponibleminimo` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_rentaimponibleminimo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_rentatope`
--

DROP TABLE IF EXISTS `tbl_rentatope`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_rentatope` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `cantidad_uf` decimal(13,3) NOT NULL,
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_rentatope`
--

LOCK TABLES `tbl_rentatope` WRITE;
/*!40000 ALTER TABLE `tbl_rentatope` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_rentatope` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_reportevisitas`
--

DROP TABLE IF EXISTS `tbl_reportevisitas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_reportevisitas` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `lat` decimal(13,10) NOT NULL,
  `lon` decimal(13,10) NOT NULL,
  `acc` decimal(13,5) NOT NULL,
  `codigo` char(32) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `etiqueta` varchar(255) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `codigo` (`codigo`),
  KEY `etiqueta` (`etiqueta`(191))
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_reportevisitas`
--

LOCK TABLES `tbl_reportevisitas` WRITE;
/*!40000 ALTER TABLE `tbl_reportevisitas` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_reportevisitas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_requisiciones`
--

DROP TABLE IF EXISTS `tbl_requisiciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_requisiciones` (
  `id_compra` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion de la factura',
  `id_bodega` int(10) NOT NULL,
  `rut_folio` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'concatenar rut prov y folio fc para campo unico',
  `numero_compra` int(10) NOT NULL AUTO_INCREMENT COMMENT 'numero unico de cada factura',
  `id_usuario` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario creador de la factura',
  `id_proveedor` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `id_centrocosto` int(10) NOT NULL,
  `rut` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `razon_social` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `nombre_fantasia` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `contacto` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `giro` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `comuna` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `fono` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `factura_importacion` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `costeo_importacion` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no ( Indica cuando la factura ya ha sido costeada)',
  `factura_activofijo` int(1) NOT NULL DEFAULT '0',
  `factura_gasto` int(10) NOT NULL DEFAULT '0',
  `tipo_factura` int(1) NOT NULL DEFAULT '0' COMMENT '1=normal 2=exenta 3=electronica 4=exenta electronica',
  `tipo_contabilizacion` int(1) NOT NULL DEFAULT '0' COMMENT '1=Factura Cuentas 2=Factura por Recibir 3=Factura por ingresar',
  `tipo_documento` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `clase_factura` int(1) NOT NULL DEFAULT '0' COMMENT '0=indefinido 1=Solo cuentas 2=Solo Productos 3=Productos y Cuentas',
  `folio_factura` bigint(15) NOT NULL DEFAULT '0',
  `sw_bloqueo` int(1) NOT NULL DEFAULT '0' COMMENT '0=no bloqueada 1=si bloqueada  ( bloquea la factura cuando esta ya ha sido cerrado el periodo contable )',
  `documento_recepcion` char(3) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'FC=FacturaCompra GD=GuiaDespacho  OC=OrdenCompra',
  `folio_documento_recepcion` int(10) NOT NULL DEFAULT '0' COMMENT 'folio del documento con el cual se recepciono la mercaderia en bodega',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'EP=EnProceso  IN=ingresada  indica si la factura ha sido ingresada al libro de compras',
  `apertura` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `anulada` int(1) NOT NULL DEFAULT '0' COMMENT '0=no 1=si',
  `folio_guiadespacho` varchar(255) COLLATE utf8_spanish_ci NOT NULL COMMENT 'folio-folio-...',
  `folio_ordencompra` varchar(64) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `folio_ordenproduccion` varchar(64) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `time_facturacion` int(10) NOT NULL DEFAULT '0' COMMENT 'timestamp con fecha de emision de la factura',
  `fecha_contable` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT 'fecha libro compras dd/mm/aaaa',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'mes control libro de compras',
  `ano_control` int(4) NOT NULL DEFAULT '0' COMMENT 'ano control libro de compras',
  `numero_control` int(10) NOT NULL DEFAULT '0' COMMENT 'numero de control del periodo del libro de compras',
  `numero_transaccion` int(10) NOT NULL DEFAULT '0' COMMENT 'numero del boucher del ingreso de la factura de compra',
  `contabilizada` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no indica si la factura ha sido contabilizada en el libro diario',
  `fecha_vencimiento` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `time_vencimiento` int(10) NOT NULL,
  `condiciones_pago` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `subtotal` int(10) NOT NULL DEFAULT '0',
  `descuento_porc` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0',
  `neto` int(10) NOT NULL DEFAULT '0',
  `neto_exento` int(10) NOT NULL,
  `iva` int(10) NOT NULL DEFAULT '0',
  `codigo_otrosimpuestos` int(10) NOT NULL,
  `otros_impuestos` int(10) NOT NULL,
  `sw_iva` int(1) NOT NULL,
  `ajustar_iva` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT '+ sube - baja pesos del iva',
  `bruto` int(10) NOT NULL DEFAULT '0',
  `sw_ivausocomun` int(1) NOT NULL,
  `codigo_ivanorecuperable` int(2) NOT NULL,
  `gastos_importacion` int(10) NOT NULL,
  `saldo_pendiente` int(10) NOT NULL DEFAULT '0',
  `observaciones` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `numero_importacion` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `numero_despacho` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `numero_compra` (`numero_compra`),
  KEY `folio_factura` (`folio_factura`),
  KEY `id_proveedor` (`id_proveedor`),
  KEY `mes_control` (`mes_control`),
  KEY `ano_control` (`ano_control`),
  KEY `sw_iva` (`sw_iva`),
  KEY `id_sucursal` (`id_sucursal`),
  KEY `direccion` (`direccion`),
  KEY `contacto` (`contacto`),
  KEY `otros_impuestos` (`otros_impuestos`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`),
  KEY `id_bodega` (`id_bodega`),
  KEY `rut` (`rut`),
  KEY `razon_social` (`razon_social`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_requisiciones`
--

LOCK TABLES `tbl_requisiciones` WRITE;
/*!40000 ALTER TABLE `tbl_requisiciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_requisiciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_requisicionesdetalle`
--

DROP TABLE IF EXISTS `tbl_requisicionesdetalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_requisicionesdetalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `id_compra` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de recepcion de la compra',
  `numero_compra` int(10) NOT NULL DEFAULT '0',
  `id_proveedor` int(10) NOT NULL DEFAULT '0',
  `id_item` int(10) NOT NULL DEFAULT '0',
  `id_centrocosto` int(2) NOT NULL DEFAULT '0',
  `id_centronegocio` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT 'Id del proyecto al cual esta asociado este gasto',
  `id_activofijo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_bodega` int(10) NOT NULL DEFAULT '0',
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'C=cuenta P=producto S=servicio',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `rut` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_factura` int(10) NOT NULL DEFAULT '0',
  `folio_guiadespacho` varchar(100) COLLATE utf8_spanish_ci NOT NULL COMMENT 'folios de guias de despacho asociadas a la factura, se separan por guiones',
  `folio_ordencompra` int(10) NOT NULL DEFAULT '0',
  `folio_notaventa` int(10) NOT NULL DEFAULT '0',
  `folio_importacion` int(10) NOT NULL DEFAULT '0',
  `folio_ordenproduccion` int(10) NOT NULL,
  `id_item_ordenproduccion` int(10) NOT NULL,
  `fecha_compra` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `time_compra` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp de fecha de emision de la factura',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'mes de contabilizacion',
  `ano_control` int(4) NOT NULL DEFAULT '0' COMMENT 'año de contabilizacion',
  `numero_control` int(10) NOT NULL DEFAULT '0' COMMENT 'numero de contabilizacion',
  `codigo_producto` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `sw_exento` int(1) NOT NULL,
  `codigo_final` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `impuesto` int(1) NOT NULL DEFAULT '0' COMMENT '1=SI 0=NO (Indica si el item esta afecto a iva)',
  `precio_lista` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'Precio de lista del proveedor',
  `descuento_porc` int(2) NOT NULL DEFAULT '0' COMMENT 'Porcentaje de descuento lineal',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0' COMMENT 'Descuento lineal en pesos',
  `precio_compra` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'Precio de compra con descuento lineal aplicado',
  `precio_final` decimal(12,2) NOT NULL,
  `cantidad` decimal(12,2) NOT NULL,
  `cantidad_devuelta` int(10) NOT NULL DEFAULT '0' COMMENT 'cantidad devuelta con notas de credito',
  `bultos` int(10) NOT NULL,
  `lote` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `serie` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `subtotal` decimal(12,2) NOT NULL DEFAULT '0.00',
  `descuento_global` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT '% de descuento global aplicado a la factura',
  `subtotal_final` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal neto con el descuento global aplicado',
  UNIQUE KEY `id` (`id`),
  KEY `id_compra` (`id_compra`),
  KEY `id_proveedor` (`id_proveedor`),
  KEY `folio_ordencompra` (`folio_ordencompra`),
  KEY `codigo_producto` (`codigo_producto`),
  KEY `folio_guiadespacho` (`folio_guiadespacho`),
  KEY `estado` (`estado`),
  KEY `id_centronegocio` (`id_centronegocio`),
  KEY `folio_ordenproduccion` (`folio_ordenproduccion`),
  KEY `id_item_ordenproduccion` (`id_item_ordenproduccion`),
  KEY `codigo_final` (`codigo_final`),
  KEY `id_bodega` (`id_bodega`),
  KEY `folio` (`folio`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_requisicionesdetalle`
--

LOCK TABLES `tbl_requisicionesdetalle` WRITE;
/*!40000 ALTER TABLE `tbl_requisicionesdetalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_requisicionesdetalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_reserva_productos`
--

DROP TABLE IF EXISTS `tbl_reserva_productos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_reserva_productos` (
  `id_reserva` int(10) NOT NULL DEFAULT '0' COMMENT 'almacena la fecha y hora que se creo la reserva',
  `id_ruteo` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp con fecha y hora que se asigno la ruta al despacho',
  `id_usuario_ruteo` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario que asigno la ruta al despacho',
  `folio_reserva` int(10) NOT NULL AUTO_INCREMENT,
  `folio_notaventa` int(10) NOT NULL DEFAULT '0',
  `folio_despacho` int(10) NOT NULL DEFAULT '0' COMMENT 'Numero del despacho',
  `folio_ruta` int(10) NOT NULL DEFAULT '0',
  `id_usuario_facturo` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario que puso listo a la facturacion',
  `time_facturo` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora que puso listo a la facturacion',
  `sw_armando_pedido` int(10) NOT NULL DEFAULT '0' COMMENT '0=todavia no arman el pedido 32234322=time stamp que indica que comenzo a preparar el pedido',
  `usuario_pedido_listo` int(10) NOT NULL DEFAULT '0',
  `time_pedido_listo` int(10) NOT NULL DEFAULT '0',
  `documentos` int(1) NOT NULL DEFAULT '0' COMMENT '1=factura 2=guia 3=ambos',
  `impresos` int(1) NOT NULL DEFAULT '0' COMMENT '0=quedan doctos por imprimir 1=se imprimieron todos los documentos',
  `folio_guia` int(10) NOT NULL DEFAULT '0' COMMENT 'folios de las guias de despacho impresas en el pedido',
  `folio_factura` int(10) NOT NULL DEFAULT '0',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'PE=pendiente EP=En Proceso EM=embalado DE=despachado AN=Anulado',
  `cantidad_bolsas` int(10) NOT NULL DEFAULT '0',
  `cantidad_cajas` int(10) NOT NULL DEFAULT '0',
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_cierre_despacho` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp con fecha y hora de cierre  de la nota de venta',
  `id_usuario_cierre` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario que cerro el despacho de la nota de venta',
  `nombre` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `fecha` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `via_despacho` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `numero_boleto` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `folio_reserva` (`folio_reserva`),
  KEY `id_reserva` (`id_reserva`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_reserva_productos`
--

LOCK TABLES `tbl_reserva_productos` WRITE;
/*!40000 ALTER TABLE `tbl_reserva_productos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_reserva_productos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_reserva_productos_detalle`
--

DROP TABLE IF EXISTS `tbl_reserva_productos_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_reserva_productos_detalle` (
  `id_reserva` int(10) NOT NULL DEFAULT '0',
  `folio_reserva` int(10) NOT NULL DEFAULT '0',
  `folio_notaventa` int(10) NOT NULL DEFAULT '0',
  `folio_despacho` int(10) NOT NULL DEFAULT '0',
  `id_item` int(10) NOT NULL DEFAULT '0',
  `codigo_producto` varchar(12) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `cantidad` int(10) NOT NULL DEFAULT '0' COMMENT 'es la cantidad que se debe despachar',
  `cantidad_pendiente` int(10) NOT NULL DEFAULT '0',
  `cantidad_despachada` int(10) NOT NULL DEFAULT '0' COMMENT 'este campo se llena cuando bodega pone listo',
  `cantidad_embalada` int(10) NOT NULL DEFAULT '0' COMMENT 'esta cantidad la digita bodega al armar el pedido',
  `prioridad` int(10) NOT NULL DEFAULT '0',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'AN=anulado PE=pendiente EM=embalado DE=despachado RE=recibido',
  KEY `id_reserva` (`id_reserva`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_reserva_productos_detalle`
--

LOCK TABLES `tbl_reserva_productos_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_reserva_productos_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_reserva_productos_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_rutas`
--

DROP TABLE IF EXISTS `tbl_rutas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_rutas` (
  `folio_ruta` int(10) NOT NULL AUTO_INCREMENT,
  `id_ruta` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp con fecha y hora de creacion de la ruta',
  `id_ruteador` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario creador de la ruta',
  `id_chofer` int(10) NOT NULL DEFAULT '0',
  `id_vehiculo` int(10) NOT NULL DEFAULT '0',
  `nombre_ruta` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `fecha` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `hora` varchar(8) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `time_ruta` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp con fecha y hora de la ruta',
  `tope_modificacion` int(10) NOT NULL DEFAULT '0' COMMENT 'indica el time stamp maximo permitido para modificar la ruta (BORRAR ESTE CAMPO DESPUES)',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'AC=Activa ER=En Ruta DR=regreso de ruta  AN=anulada',
  `time_salida` int(10) NOT NULL DEFAULT '0',
  `km_salida` int(10) NOT NULL DEFAULT '0',
  `time_llegada` int(10) NOT NULL DEFAULT '0',
  `km_llegada` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `folio_ruta` (`folio_ruta`),
  KEY `id_ruta` (`id_ruta`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_rutas`
--

LOCK TABLES `tbl_rutas` WRITE;
/*!40000 ALTER TABLE `tbl_rutas` DISABLE KEYS */;
INSERT INTO `tbl_rutas` VALUES (1,0,0,1,1,'NORTE','20/09/2017','',0,9,'1',9,1,11,2);
/*!40000 ALTER TABLE `tbl_rutas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_rutas_det`
--

DROP TABLE IF EXISTS `tbl_rutas_det`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_rutas_det` (
  `folio_ruta` int(10) NOT NULL,
  `id_ruta` int(10) NOT NULL DEFAULT '0',
  `id_ruteo` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora que se ruteo la nv',
  `id_usuario_ruteo` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario que ruteo la nv',
  `orden` int(10) NOT NULL DEFAULT '0',
  `tipo_documento` varchar(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'PV=postventa NV=nota de venta OC=Orden de Compra SD=sin documento  VA=VentaAnticipada',
  `folio_documento` int(10) NOT NULL DEFAULT '0' COMMENT 'folio del documento a rutear',
  `folio_despacho` int(10) NOT NULL DEFAULT '0',
  `estado` varchar(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'PE=pendiente RL=ruteo listo',
  KEY `id_ruta` (`id_ruta`),
  KEY `folio_documento` (`folio_documento`),
  KEY `folio_ruta` (`folio_ruta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_rutas_det`
--

LOCK TABLES `tbl_rutas_det` WRITE;
/*!40000 ALTER TABLE `tbl_rutas_det` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_rutas_det` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_rutas_transporte`
--

DROP TABLE IF EXISTS `tbl_rutas_transporte`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_rutas_transporte` (
  `id_ruta` int(11) NOT NULL AUTO_INCREMENT,
  `origen` varchar(50) COLLATE utf8_spanish_ci NOT NULL,
  `destino` varchar(50) COLLATE utf8_spanish_ci NOT NULL,
  `codigo` varchar(11) COLLATE utf8_spanish_ci NOT NULL,
  `id_cliente` varchar(11) COLLATE utf8_spanish_ci NOT NULL,
  `nombre_servicio` varchar(50) COLLATE utf8_spanish_ci NOT NULL,
  `mostrar` int(1) NOT NULL COMMENT 'si se muestra o no en los clientes',
  PRIMARY KEY (`id_ruta`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_rutas_transporte`
--

LOCK TABLES `tbl_rutas_transporte` WRITE;
/*!40000 ALTER TABLE `tbl_rutas_transporte` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_rutas_transporte` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_salud`
--

DROP TABLE IF EXISTS `tbl_salud`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_salud` (
  `id_salud` int(10) NOT NULL DEFAULT '0',
  `salud` varchar(25) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `tasa` decimal(4,2) NOT NULL DEFAULT '0.00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_salud`
--

LOCK TABLES `tbl_salud` WRITE;
/*!40000 ALTER TABLE `tbl_salud` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_salud` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_segurocesantia`
--

DROP TABLE IF EXISTS `tbl_segurocesantia`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_segurocesantia` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `tipo_contrato` int(1) NOT NULL COMMENT '1=indefinido 2=plazofijo 3=plazoindefinidomasde11años',
  `porc_empleador` decimal(4,2) NOT NULL,
  `porc_trabajador` decimal(4,2) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_segurocesantia`
--

LOCK TABLES `tbl_segurocesantia` WRITE;
/*!40000 ALTER TABLE `tbl_segurocesantia` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_segurocesantia` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_servicios`
--

DROP TABLE IF EXISTS `tbl_servicios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_servicios` (
  `id_servicio` int(10) NOT NULL AUTO_INCREMENT,
  `codigo_servicio` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'Codigo maestro del producto',
  `orden` int(10) NOT NULL,
  `estado` int(1) NOT NULL DEFAULT '0' COMMENT '0=ocultar 1=mostrar',
  `codigo_alternativo` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'Codigo alternativo 1',
  `codigo_barra` varchar(64) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `nombre` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'Nombre del producto',
  `descripcion` text COLLATE utf8_spanish_ci NOT NULL COMMENT 'Descripción completa del producto',
  `unidad_medida` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `clase` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'Clase del producto, de acuerdo a su nivel de venta (A,B,C,etc) Z=sin movimiento',
  `pmp` int(10) NOT NULL DEFAULT '0' COMMENT 'ultimo precio medio ponderado del producto',
  `precio_costo` decimal(12,2) NOT NULL COMMENT 'precio de costo o de ultima compra del servicio',
  `precio_referencial` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'precio referencial de venta',
  `tipo_cambio` int(10) NOT NULL COMMENT 'indica el tipo de cambio ej. dollar, pesos, euros, ucos, etc...',
  `sw_impuesto` int(1) NOT NULL COMMENT '1=afecto 0=exento',
  `descuento_maximo` int(2) NOT NULL DEFAULT '0' COMMENT 'porcentaje de descuento maximo permitido',
  `id_centroingreso` int(10) NOT NULL DEFAULT '0' COMMENT 'codigo de la cuenta contable asociada al producto',
  `id_area` int(10) NOT NULL,
  UNIQUE KEY `id_servicio` (`id_servicio`),
  UNIQUE KEY `codigo_servicio` (`codigo_servicio`),
  KEY `nombre` (`nombre`),
  KEY `codigo_alternativo` (`codigo_alternativo`),
  KEY `codigo_barra` (`codigo_barra`),
  KEY `orden` (`orden`),
  KEY `id_area` (`id_area`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci COMMENT='Nivel 5';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_servicios`
--

LOCK TABLES `tbl_servicios` WRITE;
/*!40000 ALTER TABLE `tbl_servicios` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_servicios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_sii_ivanorecuperable`
--

DROP TABLE IF EXISTS `tbl_sii_ivanorecuperable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_sii_ivanorecuperable` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(255) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_sii_ivanorecuperable`
--

LOCK TABLES `tbl_sii_ivanorecuperable` WRITE;
/*!40000 ALTER TABLE `tbl_sii_ivanorecuperable` DISABLE KEYS */;
INSERT INTO `tbl_sii_ivanorecuperable` VALUES (1,'Compras destinadas a IVA a generar operaciones no gravadas o exentas'),(2,'Facturas de proveedores registradas fuera de plazo'),(3,'Gastos rechazados'),(4,'Entregas gratuitas (premios, bonificaciones, etc.) recibidas'),(9,'Otros');
/*!40000 ALTER TABLE `tbl_sii_ivanorecuperable` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_sii_otrosimpuestos`
--

DROP TABLE IF EXISTS `tbl_sii_otrosimpuestos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_sii_otrosimpuestos` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `codigo` int(10) NOT NULL,
  `codigo_cambio` int(10) NOT NULL,
  `tasa` decimal(12,2) NOT NULL,
  `nombre` varchar(255) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` text CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `documentos_aplica` varchar(255) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL COMMENT '30-33-54-60-61',
  UNIQUE KEY `id` (`id`),
  KEY `codigo` (`codigo`),
  KEY `codigo_cambio` (`codigo_cambio`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_sii_otrosimpuestos`
--

LOCK TABLES `tbl_sii_otrosimpuestos` WRITE;
/*!40000 ALTER TABLE `tbl_sii_otrosimpuestos` DISABLE KEYS */;
INSERT INTO `tbl_sii_otrosimpuestos` VALUES (1,15,0,0.00,'IVA retenido total','Corresponde al IVA retenido en Facturas de compra del contribuyente que genera el libro. Suma de retenciones con tasa total del IVA','45-46-60-61-55-56'),(2,14,0,0.00,'IVA  de  margen  de  comercialización','Para Facturas de venta del contribuyente','30-33-60-61-55-56'),(3,17,0,0.00,'IVA  ANTICIPADO  FAENAMIENTO CARNE','Tasa de 5% sobre Monto base \r\nfaenamiento. Se registra el monto de IVA \r\nanticipado cobrado al cliente. ','30-33-60-61-55-56'),(4,18,0,0.00,'IVA  ANTICIPADO CARNE','Tasa de 5%. Se registra el monto de IVA \r\nanticipado cobrado al cliente.','30-33-60-61-55-56'),(5,19,101070206,12.00,'IVA ANTICIPADO HARINA','Tasa de 12%. Se registra el monto de IVA anticipado cobradoal cliente','201020401'),(6,23,0,0.00,'IMPUESTO ADICIONAL Art 37 Letras a, b, c ','Tasa del 15%\r\na)\r\nartículos oro, platino, marfil\r\nb)\r\nJoyas, piedras preciosas\r\nc)\r\nPieles finas','30-33-60-61-55-56'),(7,24,0,31.50,'DL 825/74 , ART. 42, letra b)','Tasa del 31,5%\r\nLicores,  Piscos,  whisky,  aguardiente,  y \r\nvinos licorosos o aromatizados. ','30-33-60-61-55-56'),(8,25,0,0.00,'DL 825/74 , ART. 42, letra c)','Tasa del 20,5%\r\nVinos','30-33-60-61-55-56'),(9,26,0,0.00,'DL 825/74 , ART. 42, letra c)','Tasa del 20,5%\r\nCervezas y bebidas alcohólicas ','30-33-60-61-55-56'),(10,27,0,0.00,'DL 825/74 , ART. 42, letra a)','Tasa del 10% Bebidas analcohólicas y minerales','30-33-60-61-55-56'),(11,271,0,0.00,'DL  825/74 ,  ART.  42,  letra  a)  Inciso Segu ndo','Tasa del 18%\r\nBebidas analcohólicas y Minerales con \r\nelevado contenido de azúcares. (según \r\nindica la ley)','30-33-60-61-55-56'),(12,28,0,10.00,'Impuesto especifico diesel','1,5    UTM    por    m3.    Traspasado    al comprador por compra de diesel. Artículo 6,  Ley  N°  18.502,  y  artículos  1°  y  3°  del  Decreto supremo N° 311/86',''),(13,30,301,0.00,'IVA RETENIDO  LEGUMBRES','Normalmente 13% retención. \r\n\r\nSi  se  retuvo  el  13%,  el  monto  retenido \r\nse   registra   en   el   IEC   en   Retención \r\nparcial\r\n\r\nSi  se  retuvo  el  total  del  IVA,  por  ser \r\nNDF  se  re\r\ngistra  también  en  Retención \r\nTotal.','45-46-60-61-55-56'),(14,31,0,0.00,'IVA RE TENIDO  SILVESTRES','total   del   IVA   retención.   El   monto \r\nretenido   se   registra   en   el   IEC   en \r\nRetención total.','45-46-60-61-55-56'),(15,32,321,0.00,'IVA RETENIDO GANADO','Normalmente 8% retención. \r\n\r\nSi se retuvo el 8%, el monto retenido se \r\nregistra en el IEC en Retención parcial\r\n\r\nSi  se  retuvo  el  total  del  IVA,  por  ser \r\nNDF,    se    registra    en    el    IE\r\nC    en \r\nRetención Total.','45-46-60-61-55-56'),(16,33,331,0.00,'IVA RETENIDO MADE RA','Normalmente 8% retención. \r\n\r\nSi se retuvo el 8%, el monto retenido se \r\nregistra en el IEC en Retención parcial\r\n\r\nSi  se  retuvo  el  total  del  IVA,  por  ser \r\nNDF,    se    registra    en    el    IEC    en \r\nRetención Total.','45-46-60-61-55-56'),(17,34,341,0.00,'IVA RETENIDO TRIGO','Normalmente 11% retención. \r\n\r\nSi  se  retuvo  el  11%,  el  monto  retenido \r\nse  registra \r\nen  el  IEC  en    Retención \r\nparcial\r\n\r\nSi se retuvo el total del IVA por ser NDF \r\nse   registra   en   el   IEC   en   Retención \r\nTotal.','45-46-60-61-55-56'),(18,35,0,0.00,'Impuesto especifico gasolina','4,5  a  6  UTM  por  m3.  Artículo  6,  Ley  N° \r\n18.502,  y  artículos  1°  y  3°  del    Decreto \r\nSupremo  N°  311/86.  No  da  derecho  a credito.se considera rebaja transitoria del componente variable dispuesto por la ley 20.259.',''),(19,36,361,0.00,'IVA RETENID O ARROZ','Normalmente 10% retención. \r\n\r\nSi  se  retuvo  el  10%,  el  monto  retenido \r\nse   registra   en   el   IEC   en   Retención \r\nparcial\r\n\r\nSi se retuvo el total del IVA por ser NDF \r\nse   registra   en   el   IEC   en   Retención \r\nTotal','45-46-60-61-55-56'),(20,37,371,0.00,'IVA RETENIDO HIDROBIOLO GICAS','Normalmente 10% retención. \r\n\r\nSi  se  retuvo  el  10%,  el  monto  reten\r\nido \r\nse   registra   en   el   IEC   en   Retención \r\nparcial\r\n\r\nSi se retuvo el total del IVA por ser NDF \r\nse   registra   en   el   IEC   en   Retención \r\nTotal',''),(21,38,0,0.00,'IVA RETENIDO CHATARRA','total  del  IVA  retención. El monto retenido \r\nse registra en el IEC en Retención total.','45-46-60-61-55-56'),(22,39,0,0.00,'VA RETENIDO PPA','total  del  IVA  retención. El monto retenido \r\nse registra en el IEC en Retención total.','45-46-60-61-55-56'),(23,41,0,0.00,'VA  RETENIDO  CONSTRUCCION','Se retiene el total del IVA.','45-46-60-61-55-56'),(24,44,0,0.00,'MPUESTO ADICIONAL Art 37 Letras e, h, I, l','Tasa  del 15% en 1era venta\r\na)\r\nAlfombras, tapices\r\nb)\r\nCasa roda\r\nntes\r\nc)\r\nCaviar\r\nd)\r\nArmas de aire o gas','45-46-60-61-55-56'),(25,45,0,0.00,'IMPUESTO ADICIONAL Art 37 Letras j','Tasa  del 50% en 1era venta\r\na)\r\nPirotecnia','30-33-60-61-55-56'),(26,46,0,0.00,'VA RETENIDO ORO','Retencion del 100% del IVA','45-46-60-61-55-56'),(27,47,0,0.00,'VA RETENIDO CARTONES','Retención Total','45-46-60-61-55-56'),(28,48,481,0.00,'VA RETENIDO  FRAMBUESAS ','Retención 14%','45-46-60-61-55-56'),(29,49,0,0.00,'FACTURA DE COMPRA SIN  RETENCIÓN (hoy utilizada  sólo por Bolsa de Productos  de Chile, lo cual es valid ado  por el sistema)','0% de retención','45-46-60-61-55-56'),(30,50,0,0.00,'IVA de margen de  comercialización de  instrumentos de prepago','Para Facturas de venta del contribuyente','30-33-60-61-55-56'),(32,51,0,0.00,'mpuesto gas natural  comprimido; 1,93 UTM/KM3,  Art. 1°, Ley N° 20.052','Para Facturas de venta del contribuyente','30-33-60-61-55-56'),(34,52,0,0.00,'Impuesto gas licuado de  petróleo; 1,40 UTM/M3, Art  1°, Ley N° 20.052','Para Facturas de venta del contribuyente','30-33-60-61-55-56'),(35,53,0,0.00,'Impuesto Retenido  Suplementeros Art 74 N°5  Ley de la Renta','Para Facturas de venta del contribuyente, \r\nretención  del  0,5%  sobre  el  precio  de \r\nventa al público','30-33-60-61-55-56');
/*!40000 ALTER TABLE `tbl_sii_otrosimpuestos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_siicertificados`
--

DROP TABLE IF EXISTS `tbl_siicertificados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_siicertificados` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `rut` varchar(10) NOT NULL,
  `nombre` varchar(200) NOT NULL,
  `estado` int(1) NOT NULL,
  `fecha_inicio` varchar(10) NOT NULL,
  `fecha_termino` varchar(10) NOT NULL,
  `modulo` text NOT NULL,
  `exponente` varchar(32) NOT NULL,
  `cert_x509` text NOT NULL,
  `privkey_sinpass` text NOT NULL,
  `nombre_archivo` varchar(255) NOT NULL,
  `pass_certificado` varchar(32) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `estado` (`estado`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_siicertificados`
--

LOCK TABLES `tbl_siicertificados` WRITE;
/*!40000 ALTER TABLE `tbl_siicertificados` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_siicertificados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_siicodigosreferencia`
--

DROP TABLE IF EXISTS `tbl_siicodigosreferencia`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_siicodigosreferencia` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `codigo` int(2) NOT NULL,
  `tipo_documento` int(2) NOT NULL,
  `descripcion` varchar(100) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_siicodigosreferencia`
--

LOCK TABLES `tbl_siicodigosreferencia` WRITE;
/*!40000 ALTER TABLE `tbl_siicodigosreferencia` DISABLE KEYS */;
INSERT INTO `tbl_siicodigosreferencia` VALUES (1,1,61,'ANULA DOCUMENTO'),(2,2,61,'CORRIGE TEXTOS'),(3,3,61,'CORRIGE MONTOS');
/*!40000 ALTER TABLE `tbl_siicodigosreferencia` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_siicombustible`
--

DROP TABLE IF EXISTS `tbl_siicombustible`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_siicombustible` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `nombre` char(32) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `fecha_desde` char(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL COMMENT 'dd/mm/aaaa',
  `id_combustible` int(1) NOT NULL COMMENT '1=gasolina93 - 2=gasolina97 - 3=petroleo - 4=gaslicuado - 5=gasnatural',
  `comp_base` decimal(10,4) NOT NULL COMMENT 'componente_base',
  `comp_variable` decimal(10,4) NOT NULL COMMENT 'componente variable',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_siicombustible`
--

LOCK TABLES `tbl_siicombustible` WRITE;
/*!40000 ALTER TABLE `tbl_siicombustible` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_siicombustible` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_siicombustible_tipos`
--

DROP TABLE IF EXISTS `tbl_siicombustible_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_siicombustible_tipos` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL COMMENT '1 o 0',
  `orden` int(10) NOT NULL,
  `codigo` char(32) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `nombre` char(64) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `codigo` (`codigo`),
  KEY `estado` (`estado`),
  KEY `orden` (`orden`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_siicombustible_tipos`
--

LOCK TABLES `tbl_siicombustible_tipos` WRITE;
/*!40000 ALTER TABLE `tbl_siicombustible_tipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_siicombustible_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_siienviomasivo`
--

DROP TABLE IF EXISTS `tbl_siienviomasivo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_siienviomasivo` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `track_id` varchar(32) NOT NULL,
  `time_recepcion` varchar(32) NOT NULL,
  `nombre_archivo` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_siienviomasivo`
--

LOCK TABLES `tbl_siienviomasivo` WRITE;
/*!40000 ALTER TABLE `tbl_siienviomasivo` DISABLE KEYS */;
INSERT INTO `tbl_siienviomasivo` VALUES (1,'','','ENVIOMASIVO_111111111_60803000K_F07012018_H103029_FIRMADO.xml'),(2,'','','ENVIOMASIVO_111111111_60803000K_F07012018_H110812_FIRMADO.xml'),(3,'','','ENVIOMASIVO_111111111_60803000K_F07012018_H111502_FIRMADO.xml'),(4,'','','ENVIOMASIVO_111111111_60803000K_F07012018_H112014_FIRMADO.xml');
/*!40000 ALTER TABLE `tbl_siienviomasivo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_siifoliosconsumidos`
--

DROP TABLE IF EXISTS `tbl_siifoliosconsumidos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_siifoliosconsumidos` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_timbraje` int(10) NOT NULL,
  `tipo_documento` int(3) NOT NULL,
  `folio` int(10) NOT NULL,
  `sw_consumido` int(1) NOT NULL,
  `sw_anulado` int(1) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `id_timbraje` (`id_timbraje`),
  KEY `folio` (`folio`),
  KEY `sw_consumido` (`sw_consumido`),
  KEY `tipo_documento` (`tipo_documento`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_siifoliosconsumidos`
--

LOCK TABLES `tbl_siifoliosconsumidos` WRITE;
/*!40000 ALTER TABLE `tbl_siifoliosconsumidos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_siifoliosconsumidos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_siifoliostimbrados`
--

DROP TABLE IF EXISTS `tbl_siifoliostimbrados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_siifoliostimbrados` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `sw_ambiente` int(1) NOT NULL,
  `estado` int(1) NOT NULL,
  `rut_emisor` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `razonsocial_emisor` varchar(200) COLLATE utf8_spanish_ci NOT NULL,
  `folio_timbraje` int(10) NOT NULL,
  `tipo_documento` int(2) NOT NULL,
  `folio_desde` int(10) NOT NULL,
  `nombre_documento` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `folio_hasta` int(10) NOT NULL,
  `total_folios` int(10) NOT NULL,
  `fecha_autorizacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `modulo` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `exponente` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `indice` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `firma` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `llave_privada` text COLLATE utf8_spanish_ci NOT NULL,
  `llave_publica` text COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `folio_timbraje` (`folio_timbraje`),
  KEY `estado` (`estado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_siifoliostimbrados`
--

LOCK TABLES `tbl_siifoliostimbrados` WRITE;
/*!40000 ALTER TABLE `tbl_siifoliostimbrados` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_siifoliostimbrados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_siireciboenvios`
--

DROP TABLE IF EXISTS `tbl_siireciboenvios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_siireciboenvios` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `semilla` varchar(32) NOT NULL,
  `token` varchar(32) NOT NULL,
  `time_recepcion` varchar(20) NOT NULL,
  `id_recepcion` int(10) NOT NULL,
  `documento` varchar(255) NOT NULL,
  `timestamp_envio` int(10) NOT NULL,
  `validacion_sii` int(10) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `validacion_sii` (`validacion_sii`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_siireciboenvios`
--

LOCK TABLES `tbl_siireciboenvios` WRITE;
/*!40000 ALTER TABLE `tbl_siireciboenvios` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_siireciboenvios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_siireciboproveedores`
--

DROP TABLE IF EXISTS `tbl_siireciboproveedores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_siireciboproveedores` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `tipo_archivo` varchar(16) COLLATE utf8_spanish_ci NOT NULL,
  `tipo_dte` int(3) NOT NULL,
  `folio_dte` int(10) NOT NULL,
  `nombre_carpeta` text COLLATE utf8_spanish_ci NOT NULL,
  `nombre_archivo` text COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `tipo_archivo` (`tipo_archivo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_siireciboproveedores`
--

LOCK TABLES `tbl_siireciboproveedores` WRITE;
/*!40000 ALTER TABLE `tbl_siireciboproveedores` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_siireciboproveedores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_siitipos_despacho`
--

DROP TABLE IF EXISTS `tbl_siitipos_despacho`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_siitipos_despacho` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `codigo` int(2) NOT NULL,
  `tipo_documento` int(2) NOT NULL,
  `descripcion` varchar(100) NOT NULL,
  `observaciones` varchar(255) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_siitipos_despacho`
--

LOCK TABLES `tbl_siitipos_despacho` WRITE;
/*!40000 ALTER TABLE `tbl_siitipos_despacho` DISABLE KEYS */;
INSERT INTO `tbl_siitipos_despacho` VALUES (1,1,52,'DESPACHO POR CUENTA DEL RECEPTOR','DESPACHO POR CUENTA DEL RECEPTOR DEL DOCUMENTO (CLIENTE O VENDEDOR EN CASO DE FACTURAS DE COMPRA)'),(2,2,52,'DESPACHO POR CUENTA DEL EMISOR A INSTALACIONES DEL CLIENTE','DESPACHO POR CUENTA DEL EMISOR A INSTALACIONES DEL CLIENTE'),(3,3,52,'DESPACHO POR CUENTA DEL EMISOR A OTRAS INSTALACIONES','DESPACHO POR CUENTA DEL EMISOR A OTRAS INSTALACIONES EJEMPLO ENTREGA EN OBRA');
/*!40000 ALTER TABLE `tbl_siitipos_despacho` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_siitipos_guia`
--

DROP TABLE IF EXISTS `tbl_siitipos_guia`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_siitipos_guia` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `codigo` int(2) NOT NULL,
  `tipo_documento` int(2) NOT NULL,
  `descripcion` varchar(100) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_siitipos_guia`
--

LOCK TABLES `tbl_siitipos_guia` WRITE;
/*!40000 ALTER TABLE `tbl_siitipos_guia` DISABLE KEYS */;
INSERT INTO `tbl_siitipos_guia` VALUES (1,1,52,'OPERACIÓN CONSTITUYE VENTA'),(2,2,52,'VENTAS POR EFECTUAR'),(3,3,52,'CONSIGNACIONES'),(4,4,52,'ENTREGA GRATUITA'),(5,5,52,'TRASLADOS INTERNOS'),(6,6,52,'OTROS TRASLADOS NO VENTA'),(7,7,52,'GUIA DE DEVOLUCIÓN'),(8,8,52,'TRASLADO PARA EXPORTACIÓN NO VENTA'),(9,9,52,'VENTA PARA EXPORTACIÓN');
/*!40000 ALTER TABLE `tbl_siitipos_guia` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_sitioweb_keywords`
--

DROP TABLE IF EXISTS `tbl_sitioweb_keywords`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_sitioweb_keywords` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `titulo_sitio` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `titulo_pagina` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `autor` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `tema` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` text COLLATE utf8_spanish_ci NOT NULL,
  `keywords` text COLLATE utf8_spanish_ci NOT NULL,
  `editorweb` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_sitioweb_keywords`
--

LOCK TABLES `tbl_sitioweb_keywords` WRITE;
/*!40000 ALTER TABLE `tbl_sitioweb_keywords` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_sitioweb_keywords` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_skumadre`
--

DROP TABLE IF EXISTS `tbl_skumadre`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_skumadre` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT '1=activo 0=inactivo',
  `orden` int(10) NOT NULL,
  `codigo` char(3) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `estado` (`estado`),
  KEY `descripcion` (`descripcion`),
  KEY `orden` (`orden`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_skumadre`
--

LOCK TABLES `tbl_skumadre` WRITE;
/*!40000 ALTER TABLE `tbl_skumadre` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_skumadre` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_soporte`
--

DROP TABLE IF EXISTS `tbl_soporte`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_soporte` (
  `id_soporte` decimal(10,0) NOT NULL DEFAULT '0',
  `id_usuario` decimal(10,0) NOT NULL DEFAULT '0',
  `id_modulo` decimal(10,0) NOT NULL DEFAULT '0',
  `tipo_solicitud` varchar(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `prioridad` varchar(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `estado` varchar(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `comentarios` text COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id_soporte` (`id_soporte`),
  KEY `id_usuario` (`id_usuario`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_soporte`
--

LOCK TABLES `tbl_soporte` WRITE;
/*!40000 ALTER TABLE `tbl_soporte` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_soporte` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_soporte_det`
--

DROP TABLE IF EXISTS `tbl_soporte_det`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_soporte_det` (
  `id_soporte_det` decimal(10,0) NOT NULL DEFAULT '0',
  `id_soporte` decimal(10,0) NOT NULL DEFAULT '0',
  `id_usuario` decimal(10,0) NOT NULL DEFAULT '0',
  `comentario` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `id_detalle` (`id_soporte_det`),
  KEY `id_soporte` (`id_soporte`,`id_usuario`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_soporte_det`
--

LOCK TABLES `tbl_soporte_det` WRITE;
/*!40000 ALTER TABLE `tbl_soporte_det` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_soporte_det` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_soporte_estados`
--

DROP TABLE IF EXISTS `tbl_soporte_estados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_soporte_estados` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_orden` int(11) NOT NULL,
  `descripcion` varchar(150) COLLATE utf8_spanish_ci NOT NULL,
  `sw_ocultar` int(1) NOT NULL COMMENT 'ocultar del listado inicial',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_soporte_estados`
--

LOCK TABLES `tbl_soporte_estados` WRITE;
/*!40000 ALTER TABLE `tbl_soporte_estados` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_soporte_estados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_soporte_tel`
--

DROP TABLE IF EXISTS `tbl_soporte_tel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_soporte_tel` (
  `id_soporte` int(11) NOT NULL AUTO_INCREMENT,
  `rut_empresa` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `id_empresa` int(11) NOT NULL,
  `razon_social` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `contacto` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `correo` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `fonos` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `fecha` varchar(15) COLLATE utf8_spanish_ci NOT NULL,
  `hora` char(10) COLLATE utf8_spanish_ci NOT NULL,
  `timestamp` int(10) NOT NULL,
  `tiempo_llamada` int(11) NOT NULL COMMENT 'tiempo en segundos',
  `id_usuario_recibe` int(11) NOT NULL,
  `problema` text COLLATE utf8_spanish_ci NOT NULL,
  `solucion` text COLLATE utf8_spanish_ci,
  `observacion` text COLLATE utf8_spanish_ci,
  `estado` int(1) NOT NULL DEFAULT '1',
  `nivel` int(1) NOT NULL DEFAULT '1',
  `id_empleado_asignado` int(11) NOT NULL,
  `prioridad` varchar(5) COLLATE utf8_spanish_ci NOT NULL,
  `modulo` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `sw_produccion` int(1) NOT NULL DEFAULT '0',
  `fecha_produccion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  PRIMARY KEY (`id_soporte`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_soporte_tel`
--

LOCK TABLES `tbl_soporte_tel` WRITE;
/*!40000 ALTER TABLE `tbl_soporte_tel` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_soporte_tel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_soporte_telBK`
--

DROP TABLE IF EXISTS `tbl_soporte_telBK`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_soporte_telBK` (
  `id_soporte` int(11) NOT NULL AUTO_INCREMENT,
  `rut_empresa` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `id_empresa` int(11) NOT NULL,
  `razon_social` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `contacto` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `correo` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `fonos` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `fecha` varchar(15) COLLATE utf8_spanish_ci NOT NULL,
  `hora` char(10) COLLATE utf8_spanish_ci NOT NULL,
  `timestamp` int(10) NOT NULL,
  `tiempo_llamada` int(11) NOT NULL COMMENT 'tiempo en segundos',
  `id_usuario_recibe` int(11) NOT NULL,
  `problema` text COLLATE utf8_spanish_ci NOT NULL,
  `solucion` text COLLATE utf8_spanish_ci,
  `observacion` text COLLATE utf8_spanish_ci,
  `estado` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id_soporte`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_soporte_telBK`
--

LOCK TABLES `tbl_soporte_telBK` WRITE;
/*!40000 ALTER TABLE `tbl_soporte_telBK` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_soporte_telBK` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_spam`
--

DROP TABLE IF EXISTS `tbl_spam`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_spam` (
  `folio_spam` int(10) NOT NULL AUTO_INCREMENT,
  `remitente` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `titulo` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `contenido` text COLLATE utf8_spanish_ci NOT NULL,
  `vinculo` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `texto_vinculo` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_imagen` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `folio_spam` (`folio_spam`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_spam`
--

LOCK TABLES `tbl_spam` WRITE;
/*!40000 ALTER TABLE `tbl_spam` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_spam` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_spam_usuarios`
--

DROP TABLE IF EXISTS `tbl_spam_usuarios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_spam_usuarios` (
  `id_usuario` int(10) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT '1=on 0=off',
  `nombres` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `apellidos` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `correo` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `telefonos` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `empresa` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `clasificacion` int(1) NOT NULL DEFAULT '0',
  UNIQUE KEY `id_usuario` (`id_usuario`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_spam_usuarios`
--

LOCK TABLES `tbl_spam_usuarios` WRITE;
/*!40000 ALTER TABLE `tbl_spam_usuarios` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_spam_usuarios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_tablahonorarios`
--

DROP TABLE IF EXISTS `tbl_tablahonorarios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_tablahonorarios` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT '1=activo 0=inactivo',
  `orden` int(10) NOT NULL,
  `codigo` decimal(13,3) NOT NULL,
  `descripcion` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `orden` (`orden`),
  KEY `codigo` (`codigo`),
  KEY `estado` (`estado`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_tablahonorarios`
--

LOCK TABLES `tbl_tablahonorarios` WRITE;
/*!40000 ALTER TABLE `tbl_tablahonorarios` DISABLE KEYS */;
INSERT INTO `tbl_tablahonorarios` VALUES (3,1,0,26568.490,'02/05/2017'),(4,1,0,26572.030,'03/05/2017'),(5,1,0,26575.560,'04/05/2017'),(6,1,0,26579.100,'05/05/2017'),(7,1,0,26582.640,'06/05/2017'),(8,1,0,26586.170,'07/05/2017'),(9,1,0,26589.710,'08/05/2017'),(10,1,0,26593.250,'09/05/2017'),(11,1,0,26594.960,'10/05/2017'),(12,1,0,26596.680,'11/05/2017'),(13,1,0,26598.390,'12/05/2017'),(14,1,0,26600.110,'13/05/2017'),(15,1,0,26601.820,'14/05/2017'),(16,1,0,26603.540,'15/05/2017'),(17,1,0,26605.250,'16/05/2017'),(18,1,0,26606.970,'17/05/2017'),(19,1,0,26608.680,'18/05/2017'),(20,1,0,26610.400,'19/05/2017'),(21,1,0,26612.110,'20/05/2017'),(22,1,0,26613.830,'21/05/2017'),(23,1,0,26615.540,'22/05/2017'),(24,1,0,26617.260,'23/05/2017'),(25,1,0,26618.970,'24/05/2017'),(26,1,0,26620.690,'25/05/2017'),(27,1,0,26622.400,'26/05/2017'),(28,1,0,26624.120,'27/05/2017'),(29,1,0,26625.840,'28/05/2017'),(30,1,0,26627.550,'29/05/2017'),(31,1,0,26629.270,'30/05/2017'),(32,1,0,26630.980,'31/05/2017'),(33,1,0,26632.700,'01/06/2017'),(34,1,0,26634.420,'02/06/2017'),(35,1,0,26636.130,'03/06/2017'),(36,1,0,26637.850,'04/06/2017'),(37,1,0,26639.570,'05/06/2017'),(38,1,0,26641.280,'06/06/2017'),(39,1,0,26643.000,'07/06/2017'),(40,1,0,26644.720,'08/06/2017'),(41,1,0,26646.440,'09/06/2017'),(42,1,0,1.050,'10/2017');
/*!40000 ALTER TABLE `tbl_tablahonorarios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_tablas`
--

DROP TABLE IF EXISTS `tbl_tablas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_tablas` (
  `id_tabla` int(10) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `sw_vaciar` int(1) NOT NULL DEFAULT '0',
  UNIQUE KEY `id_tabla` (`id_tabla`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_tablas`
--

LOCK TABLES `tbl_tablas` WRITE;
/*!40000 ALTER TABLE `tbl_tablas` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_tablas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_telasinforme`
--

DROP TABLE IF EXISTS `tbl_telasinforme`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_telasinforme` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `codigo_color` varchar(12) COLLATE utf8_spanish_ci NOT NULL,
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `codigo_color` (`codigo_color`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_telasinforme`
--

LOCK TABLES `tbl_telasinforme` WRITE;
/*!40000 ALTER TABLE `tbl_telasinforme` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_telasinforme` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_terminales`
--

DROP TABLE IF EXISTS `tbl_terminales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_terminales` (
  `id_terminal` int(10) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `nombre` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `folio_boleta` int(10) NOT NULL,
  `folio_factura` int(10) NOT NULL,
  `folio_guia` int(10) NOT NULL,
  UNIQUE KEY `id_terminal` (`id_terminal`),
  KEY `codigo` (`codigo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_terminales`
--

LOCK TABLES `tbl_terminales` WRITE;
/*!40000 ALTER TABLE `tbl_terminales` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_terminales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_tiposmoneda`
--

DROP TABLE IF EXISTS `tbl_tiposmoneda`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_tiposmoneda` (
  `id_tipomoneda` int(10) NOT NULL AUTO_INCREMENT,
  `estado` int(1) NOT NULL DEFAULT '1',
  `orden` int(10) NOT NULL,
  `nombre` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_plural` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `simbolo` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `valor_pesos` int(10) NOT NULL DEFAULT '0' COMMENT 'valor de cambio en pesos',
  UNIQUE KEY `id_tipomoneda` (`id_tipomoneda`),
  KEY `estado` (`estado`),
  KEY `orden` (`orden`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_tiposmoneda`
--

LOCK TABLES `tbl_tiposmoneda` WRITE;
/*!40000 ALTER TABLE `tbl_tiposmoneda` DISABLE KEYS */;
INSERT INTO `tbl_tiposmoneda` VALUES (1,1,0,'Dolar','Dolares','U$',550),(2,1,0,'Euro','Euros','&euro;',890),(3,1,0,'Peso','Pesos','$',1),(4,1,0,'Uf','Ufs','UF',20170);
/*!40000 ALTER TABLE `tbl_tiposmoneda` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_transacciones`
--

DROP TABLE IF EXISTS `tbl_transacciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_transacciones` (
  `id_transaccion` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de creacion del comprobante contable',
  `fecha_creacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL COMMENT 'fecha creacion del voucher',
  `folio` int(10) NOT NULL AUTO_INCREMENT,
  `transaccion_automatica` int(1) NOT NULL DEFAULT '0' COMMENT '0=no 1=si',
  `sw_activa` int(1) NOT NULL,
  `id_usuario` int(10) NOT NULL DEFAULT '0',
  `id_modificador` int(10) NOT NULL,
  `time_modificador` int(10) NOT NULL,
  `id_sucursal` int(10) NOT NULL,
  `id_centrocosto` int(10) NOT NULL,
  `id_centronegocio` int(10) NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `dia` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `mes` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `ano` int(4) NOT NULL DEFAULT '0',
  `fecha` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `time_transaccion` int(10) NOT NULL COMMENT 'fecha hora de la transaccion contable',
  `estado` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `numero_transaccion` int(10) NOT NULL DEFAULT '0',
  `tipo_transaccion` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'I=ingreso E=egreso T=traspaso',
  `tipo_boucher` char(4) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'ENCV=EmisionNotaCreditoVenta EFV=FacturaVenta  EFC=FacturaCompra PFV=PagoFacturaVenta PFC=PagoFacturaCompra  ENC=EmisionNotaCredito  ENP=EmisionNotacreditoProveedor EBH=EmisionBoletaHonorario ROC=RecepcionOrdenCompra PEN=ParteENtrada PSA=ParteSAlida',
  `folio_documento` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'folio del documento ( boleta venta, boleta honorario, factura )',
  `rut` varchar(12) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'rut de documento contable',
  `centralizar` int(1) NOT NULL DEFAULT '0' COMMENT '1=SI 0=NO ( debe llevar 1 cuando sea factura de compra o de venta )',
  `estado_transaccion` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'A=abierta C=Cerrada N=Nula',
  `debe` int(10) NOT NULL,
  `haber` int(10) NOT NULL,
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `folio` (`folio`),
  KEY `mes` (`mes`),
  KEY `ano` (`ano`),
  KEY `numero_transaccion` (`numero_transaccion`),
  KEY `fecha` (`fecha`),
  KEY `estado` (`estado`),
  KEY `sw_activa` (`sw_activa`),
  KEY `time_transaccion` (`time_transaccion`),
  KEY `id_sucursal` (`id_sucursal`,`id_centrocosto`,`id_centronegocio`,`id_proyecto`),
  KEY `fecha_creacion` (`fecha_creacion`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_transacciones`
--

LOCK TABLES `tbl_transacciones` WRITE;
/*!40000 ALTER TABLE `tbl_transacciones` DISABLE KEYS */;
INSERT INTO `tbl_transacciones` VALUES (1710181106,'',1,1,1,691,0,0,0,0,0,0,'14','12',2023,'14/12/2023',1702522800,'PR',1,'T','FC','190837','78706540-6',1,'C',0,0,'RECEPCIÓN FACTURA ELECTRONICA COMPRA 190837'),(1710181106,'',2,1,1,691,1284,1712787126,0,0,0,0,'22','12',2023,'22/12/2023',1703214000,'GR',2,'T','FC','3138','76620108-3',1,'C',194899,194899,'RECEPCIÓN FACTURA ELECTRONICA COMPRA 3138'),(1710181670,'11/03/2024',3,0,1,691,691,1710181849,0,0,0,0,'14','12',2023,'14/12/2023',1702522800,'GR',3,'T','VM','','',0,'C',4000000,4000000,'CAPITAL APORTADO'),(1710181933,'11/03/2024',4,0,1,691,691,1710182036,0,0,0,0,'15','12',2023,'15/12/2023',1702609200,'GR',4,'T','VM','','',0,'C',9600000,9600000,'PRESTAMO SOCIO'),(1710182047,'11/03/2024',5,0,1,691,691,1710182088,0,0,0,0,'31','12',2023,'31/12/2023',1703991600,'GR',5,'E','VM','','',0,'C',13510999,13510999,'PAGO PROVEEDORES'),(1717433404,'',6,1,1,1284,970,1725465966,0,0,0,0,'02','01',2024,'02/01/2024',1704164400,'GR',6,'T','AP','','',1,'C',13600000,13600000,'APERTURA BALANCE 2024');
/*!40000 ALTER TABLE `tbl_transacciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_traspasos`
--

DROP TABLE IF EXISTS `tbl_traspasos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_traspasos` (
  `id_traspaso` int(10) NOT NULL DEFAULT '0' COMMENT 'timestamp de creacion del traspaso',
  `folio_traspaso` int(10) NOT NULL AUTO_INCREMENT,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_usuario` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario que genero el traspaso',
  `id_operador` int(10) NOT NULL DEFAULT '0',
  `usuario_recepcion` int(10) NOT NULL DEFAULT '0' COMMENT 'usuario que recepciono y reviso el traspaso',
  `time_recepcion` int(10) NOT NULL DEFAULT '0' COMMENT 'fecha y hora de recepcion del traspaso',
  `id_bodega_origen` int(10) NOT NULL DEFAULT '0',
  `id_bodega_destino` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `folio_traspaso` (`folio_traspaso`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_traspasos`
--

LOCK TABLES `tbl_traspasos` WRITE;
/*!40000 ALTER TABLE `tbl_traspasos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_traspasos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_traspasos_detalle`
--

DROP TABLE IF EXISTS `tbl_traspasos_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_traspasos_detalle` (
  `folio_traspaso` int(10) NOT NULL DEFAULT '0',
  `id_item` int(10) NOT NULL DEFAULT '0',
  `codigo_producto` varchar(20) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `cantidad` int(10) NOT NULL DEFAULT '0',
  `ubicacion` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  KEY `codigo_producto` (`codigo_producto`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_traspasos_detalle`
--

LOCK TABLES `tbl_traspasos_detalle` WRITE;
/*!40000 ALTER TABLE `tbl_traspasos_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_traspasos_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_uf`
--

DROP TABLE IF EXISTS `tbl_uf`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_uf` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `fecha` char(10) NOT NULL,
  `valor` decimal(12,2) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_uf`
--

LOCK TABLES `tbl_uf` WRITE;
/*!40000 ALTER TABLE `tbl_uf` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_uf` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_unidades`
--

DROP TABLE IF EXISTS `tbl_unidades`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_unidades` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `codigo_unidad` char(4) COLLATE utf8_spanish_ci NOT NULL DEFAULT 'UNI',
  `descripcion` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `codigo_unidad` (`codigo_unidad`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci COMMENT='Almacena los tipos de unidades de medición de productos';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_unidades`
--

LOCK TABLES `tbl_unidades` WRITE;
/*!40000 ALTER TABLE `tbl_unidades` DISABLE KEYS */;
INSERT INTO `tbl_unidades` VALUES (2,'Hora','Hora'),(1,'UND','UNIDAD');
/*!40000 ALTER TABLE `tbl_unidades` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_usuarios`
--

DROP TABLE IF EXISTS `tbl_usuarios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_usuarios` (
  `id_usuario` int(10) NOT NULL AUTO_INCREMENT COMMENT 'timestamp de registro',
  `time_inicio` int(10) NOT NULL COMMENT 'timestamp de ingreso a la empresa',
  `id_empleado` int(10) NOT NULL,
  `estado` int(1) NOT NULL DEFAULT '0' COMMENT '1=ON - 0=OFF',
  `acceso` int(1) NOT NULL DEFAULT '0' COMMENT '0=Local 1=Remoto',
  `rut` varchar(12) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'rut de la empresa',
  `rut_usuario` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `usuario` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '',
  `clave` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_nivel` int(10) NOT NULL DEFAULT '0',
  `nombres` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `apellidos` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `sexo` int(1) NOT NULL,
  `edad` int(3) NOT NULL,
  `referencia` int(2) NOT NULL,
  `correo` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `anexo` int(2) NOT NULL DEFAULT '0',
  `id_sesion` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_click` int(10) NOT NULL DEFAULT '0' COMMENT 'timestamp del ultimo clik que dio el usuario',
  `id_impresora` int(10) NOT NULL,
  UNIQUE KEY `id_usuario` (`id_usuario`),
  KEY `usuario` (`usuario`),
  KEY `rut_usuario` (`rut_usuario`),
  KEY `id_empleado` (`id_empleado`),
  KEY `id_impresora` (`id_impresora`)
) ENGINE=InnoDB AUTO_INCREMENT=1285 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_usuarios`
--

LOCK TABLES `tbl_usuarios` WRITE;
/*!40000 ALTER TABLE `tbl_usuarios` DISABLE KEYS */;
INSERT INTO `tbl_usuarios` VALUES (691,1712867921,0,1,1,'77861264-K','22','camilo.araneda@lavtax.cl','camilo2014',1,'Camilo','Araneda',0,0,0,'camilo.araneda@lavtax.cl','0',0,'f4d62qug5se8o5cot7ql2a5ca4',1712868018,0),(970,1725465923,0,1,1,'77861264-K','','hector.llanos@controler.cl','hllanos1988',1,'Hector Alejandro','LLanos Ramirez',0,0,0,'hector.llanos@controler.cl','0',0,'',1725466024,0),(1284,1732211118,1284,1,1,'77861264-K','','jaime.molina@lavtax.cl','lt1905lt',1,'Jaime','Molina',0,0,0,'jaime.molina@lavtax.cl','',0,'m98vkcdq5mh6qfmic72vj85g07',1732211539,0);
/*!40000 ALTER TABLE `tbl_usuarios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_uta`
--

DROP TABLE IF EXISTS `tbl_uta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_uta` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `ano` int(4) NOT NULL,
  `valor` decimal(12,2) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_uta`
--

LOCK TABLES `tbl_uta` WRITE;
/*!40000 ALTER TABLE `tbl_uta` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_uta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_utm`
--

DROP TABLE IF EXISTS `tbl_utm`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_utm` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `mes` char(2) NOT NULL,
  `ano` int(4) NOT NULL,
  `valor` decimal(12,2) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_utm`
--

LOCK TABLES `tbl_utm` WRITE;
/*!40000 ALTER TABLE `tbl_utm` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_utm` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_vacaciones`
--

DROP TABLE IF EXISTS `tbl_vacaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_vacaciones` (
  `registro` varchar(10) CHARACTER SET latin1 NOT NULL DEFAULT '0',
  `rut` varchar(12) CHARACTER SET latin1 NOT NULL DEFAULT '0',
  `dia` varchar(2) CHARACTER SET latin1 NOT NULL DEFAULT '0',
  `mes` varchar(2) CHARACTER SET latin1 NOT NULL DEFAULT '0',
  `ano` varchar(4) CHARACTER SET latin1 NOT NULL DEFAULT '0',
  KEY `registro` (`registro`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_vacaciones`
--

LOCK TABLES `tbl_vacaciones` WRITE;
/*!40000 ALTER TABLE `tbl_vacaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_vacaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_validaciones`
--

DROP TABLE IF EXISTS `tbl_validaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_validaciones` (
  `registro` varchar(10) CHARACTER SET latin1 NOT NULL DEFAULT '0',
  `rut` varchar(12) CHARACTER SET latin1 NOT NULL DEFAULT '0',
  `dia` varchar(2) CHARACTER SET latin1 NOT NULL DEFAULT '0',
  `mes` varchar(2) CHARACTER SET latin1 NOT NULL DEFAULT '0',
  `ano` varchar(4) CHARACTER SET latin1 NOT NULL DEFAULT '0',
  `usuario` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `motivo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `usuarioquevalido` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  KEY `registro` (`registro`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_validaciones`
--

LOCK TABLES `tbl_validaciones` WRITE;
/*!40000 ALTER TABLE `tbl_validaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_validaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_vehiculos`
--

DROP TABLE IF EXISTS `tbl_vehiculos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_vehiculos` (
  `id_vehiculo` int(10) NOT NULL AUTO_INCREMENT,
  `patente` varchar(6) NOT NULL,
  `marca` varchar(20) NOT NULL,
  `modelo` varchar(20) NOT NULL,
  `tipo` varchar(20) NOT NULL,
  `fecha_mantencion` varchar(10) NOT NULL,
  `fecha_revisiontecnica` varchar(10) NOT NULL,
  `km_inicial` int(10) NOT NULL,
  `km_mantencion` int(11) NOT NULL,
  `estado` int(1) NOT NULL COMMENT '0=inactivo, 1=activo',
  PRIMARY KEY (`id_vehiculo`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_vehiculos`
--

LOCK TABLES `tbl_vehiculos` WRITE;
/*!40000 ALTER TABLE `tbl_vehiculos` DISABLE KEYS */;
INSERT INTO `tbl_vehiculos` VALUES (1,'AABB77','SUZUKI','FURGON 1','FURGON','01/01/2018','05/03/2018',1000,30000,1);
/*!40000 ALTER TABLE `tbl_vehiculos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_vendedores_bodegas`
--

DROP TABLE IF EXISTS `tbl_vendedores_bodegas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_vendedores_bodegas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_vendedor` int(11) NOT NULL,
  `id_bodega` int(11) NOT NULL,
  `timestamp` int(10) DEFAULT NULL,
  `id_usuario` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_vendedores_bodegas`
--

LOCK TABLES `tbl_vendedores_bodegas` WRITE;
/*!40000 ALTER TABLE `tbl_vendedores_bodegas` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_vendedores_bodegas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ventas`
--

DROP TABLE IF EXISTS `tbl_ventas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ventas` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `folio` int(10) NOT NULL,
  `time_timbrado` varchar(20) COLLATE utf8_spanish_ci NOT NULL,
  `sw_envio` int(1) NOT NULL COMMENT '0=sinagregar  1=agregadoporenviar 2=enviado',
  `sw_backup` int(1) NOT NULL,
  `id_enviomasivo` int(10) NOT NULL,
  `time_listaenvio` int(10) NOT NULL COMMENT 'ordenamiento de los documentos a enviar por orden en que fueron agregados al listado',
  `estado_sii` int(1) NOT NULL DEFAULT '0' COMMENT 'estados dte ante el sii: 1.-Por Enviar - rojo 2.-Enviado - amarillo 3.-Aceptado - verde 4.-Rechazado - negro',
  `estado_recepcion` char(8) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_recepcion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `hora_recepcion` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `time_recepcion` int(10) NOT NULL,
  `id_recepcion` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `folio_timbraje` int(10) NOT NULL,
  `tipo_documento` varchar(2) COLLATE utf8_spanish_ci NOT NULL,
  `tipo_guia` int(2) NOT NULL COMMENT 'codigos sii de tipos de guias',
  `tipo_despacho` int(1) NOT NULL,
  `sw_ok` int(1) NOT NULL COMMENT 'indica si ha sido validado',
  `id_registro` int(10) NOT NULL,
  `id_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'almacena el timestamp unix del momento cuando se puso listo al pedido',
  `asiento_apertura` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `facturada` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `contabilizada` int(1) NOT NULL DEFAULT '0' COMMENT 'indica si la emision de la factura ya fue contabilizada 1=si 0=no',
  `cancelada` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_referencia` char(32) COLLATE utf8_spanish_ci NOT NULL,
  `folio_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'VA=venta anticipada CC=cuenta corriente',
  `folio_facturado` int(10) NOT NULL,
  `folio_notadebito` int(10) NOT NULL,
  `folio_notacredito` int(10) NOT NULL,
  `origen_factura` int(1) NOT NULL COMMENT '0=facturadirecta 1=facturaguias 2=facturapedidos',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'EP=EnProceso GR=grabada PR=Procesada AN=Anulada',
  `nivel_impresion` int(1) NOT NULL DEFAULT '0' COMMENT '0=detallado 1=resumido por categoria 2=resumido por subcategorias',
  `tipo_facturacion` int(1) NOT NULL DEFAULT '0' COMMENT '0=facturacion desde notas de venta 1=FACTURACION DESDE GUIAS DE DESPACHO',
  `anulada` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `sw_bloqueo` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `ano_control` int(4) NOT NULL,
  `numero_control` int(10) NOT NULL,
  `fecha_anulacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_cotizacion` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `folio_notaventa` int(10) NOT NULL DEFAULT '0',
  `folio_despacho` int(10) NOT NULL DEFAULT '0',
  `folio_ruta` int(10) NOT NULL DEFAULT '0',
  `folio_guiadespacho` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_ordencompra` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_recepcion` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'codigo de recepcion que entrega el cliente por ej. falabella codigo IR = Ingreso Recepción nº xxx',
  `id_vendedor` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'rut del empleado vendedor',
  `id_sucursal_venta` int(10) NOT NULL COMMENT 'id de la sucursal donde se emitio la factura',
  `id_bodega_despacho` int(10) NOT NULL COMMENT 'id de la bodega de donde se rebajaran los articulos vendidos',
  `nombre_sucursal_venta` varchar(255) COLLATE utf8_spanish_ci NOT NULL COMMENT 'nombre de la sucursal a la cual esta asociada la factura de venta',
  `exenta` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `electronica` int(1) NOT NULL DEFAULT '0',
  `tipo_factura` int(1) NOT NULL DEFAULT '1' COMMENT '1=manual afecta 2=electronica afecta 3=manual exenta 4=electronica exenta',
  `id_relacion` int(10) NOT NULL DEFAULT '0',
  `tipo_cliente` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'E=Empresa U=Universidad',
  `proyecto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT '0=Sin proyecto',
  `id_empresa` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL DEFAULT '0',
  `id_laboratorio` int(10) NOT NULL DEFAULT '0',
  `id_investigador` int(10) NOT NULL DEFAULT '0',
  `id_contacto` int(10) NOT NULL DEFAULT '0',
  `id_despacho` int(10) NOT NULL DEFAULT '0',
  `id_region` int(10) NOT NULL DEFAULT '0',
  `id_ciudad` int(10) NOT NULL DEFAULT '0',
  `id_comuna` int(10) NOT NULL DEFAULT '0',
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `razon_social` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_fantasia` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `giro` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefonos` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `region` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `ciudad` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `comuna` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_contacto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `mail_contacto` varchar(200) COLLATE utf8_spanish_ci NOT NULL,
  `nombre_investigador` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `atencion_facturacion` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_contacto` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_investigador` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_facturacion` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_proyecto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_facturacion` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp con fecha y hora de emision de la factura',
  `fecha_vencimiento` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_vencimiento` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp con fecha y hora de vencimiento',
  `via_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion_despacho` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_despacho` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `atencion_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `cancela_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `anticipo` int(10) NOT NULL,
  `subtotal` int(10) NOT NULL DEFAULT '0',
  `suma_afecto` int(10) NOT NULL,
  `descuento_afecto` decimal(12,2) NOT NULL,
  `tipodescuento_afecto` int(1) NOT NULL,
  `montodescuento_afecto` int(10) NOT NULL,
  `porcdescuento_afecto` decimal(5,2) NOT NULL,
  `suma_exento` int(10) NOT NULL,
  `descuento_exento` decimal(12,2) NOT NULL,
  `tipodescuento_exento` int(1) NOT NULL,
  `montodescuento_exento` int(10) NOT NULL,
  `porcdescuento_exento` decimal(5,2) NOT NULL,
  `descuento_porc` int(2) NOT NULL DEFAULT '0' COMMENT 'D',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0',
  `neto` int(10) NOT NULL DEFAULT '0',
  `neto_exento` int(10) NOT NULL,
  `tasa_iva` int(2) NOT NULL DEFAULT '19',
  `iva` int(10) NOT NULL DEFAULT '0',
  `impuesto_especifico` int(10) NOT NULL COMMENT 'monto de impuesto especifico combustible',
  `bruto` int(10) NOT NULL DEFAULT '0',
  `saldo_pendiente` int(10) NOT NULL DEFAULT '0',
  `saldo_va` int(10) NOT NULL DEFAULT '0' COMMENT 'indica el saldo disponible de las facturas va',
  `bruto_palabras` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'Total bruto escrito en palabras',
  `id_condiciones_venta` int(10) NOT NULL DEFAULT '0',
  `condiciones_venta` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT '1=Efectivo 2=Documentado 3=10 Dias 4=15 Dias 5=30 Dias 6=45 Dias 7=60 Dias 8=30/60 Dias 9=30/60/90 Dias',
  `observaciones` text COLLATE utf8_spanish_ci NOT NULL,
  `razon_referencia` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_usuario_anulacion` int(10) NOT NULL DEFAULT '0',
  `id_anulacion` int(10) NOT NULL DEFAULT '0',
  `motivo_anulacion` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_usuario_modifico` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario que realizo la ultima modificacion',
  `id_modificacion` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp de la ultima modificacion',
  `id_marca` int(10) NOT NULL,
  `id_listaprecios` int(10) NOT NULL,
  `estatus_sii` varchar(20) COLLATE utf8_spanish_ci NOT NULL,
  `id_condicionpago` int(10) NOT NULL,
  `total_pagado` int(11) NOT NULL,
  `efectivo` int(11) NOT NULL,
  `vuelto` int(11) NOT NULL,
  `codigo_transbank` int(20) NOT NULL,
  `id_lista_de_precios` int(11) DEFAULT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `fecha_facturacion` (`fecha_facturacion`),
  KEY `id_factura` (`id_factura`),
  KEY `rut` (`rut`),
  KEY `id_relacion` (`id_relacion`),
  KEY `estado` (`estado`),
  KEY `id_sucursal_venta` (`id_sucursal_venta`),
  KEY `nombre_sucursal_venta` (`nombre_sucursal_venta`),
  KEY `mes_control` (`mes_control`,`ano_control`,`numero_control`),
  KEY `tipo_factura` (`tipo_factura`),
  KEY `codigo_recepcion` (`codigo_recepcion`),
  KEY `id_bodega_despacho` (`id_bodega_despacho`),
  KEY `nivel_impresion` (`nivel_impresion`),
  KEY `origen_factura` (`origen_factura`),
  KEY `sw_ok` (`sw_ok`),
  KEY `folio_timbraje` (`folio_timbraje`),
  KEY `folio_facturado` (`folio_facturado`),
  KEY `folio_notadebito` (`folio_notadebito`),
  KEY `folio_notacredito` (`folio_notacredito`),
  KEY `tipo_guia` (`tipo_guia`),
  KEY `estado_sii` (`estado_sii`),
  KEY `estado_recepcion` (`estado_recepcion`),
  KEY `sw_envio` (`sw_envio`),
  KEY `time_listaenvio` (`time_listaenvio`),
  KEY `id_enviomasivo` (`id_enviomasivo`),
  KEY `sw_backup` (`sw_backup`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ventas`
--

LOCK TABLES `tbl_ventas` WRITE;
/*!40000 ALTER TABLE `tbl_ventas` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ventas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ventas_boleta`
--

DROP TABLE IF EXISTS `tbl_ventas_boleta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ventas_boleta` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `sw_backup` int(1) NOT NULL,
  `time_timbrado` varchar(20) COLLATE utf8_spanish_ci NOT NULL,
  `sw_envio` int(1) NOT NULL COMMENT '0=sinagregar  1=agregadoporenviar 2=enviado',
  `id_enviomasivo` int(10) NOT NULL,
  `time_listaenvio` int(10) NOT NULL COMMENT 'ordenamiento de los documentos a enviar por orden en que fueron agregados al listado',
  `estado_sii` int(1) NOT NULL DEFAULT '0' COMMENT 'estados dte ante el sii: 1.-Por Enviar - rojo 2.-Enviado - amarillo 3.-Aceptado - verde 4.-Rechazado - negro',
  `estado_recepcion` char(8) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_recepcion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `hora_recepcion` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `time_recepcion` int(10) NOT NULL,
  `id_recepcion` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `folio_timbraje` int(10) NOT NULL,
  `tipo_documento` varchar(2) COLLATE utf8_spanish_ci NOT NULL,
  `tipo_guia` int(2) NOT NULL COMMENT 'codigos sii de tipos de guias',
  `tipo_despacho` int(1) NOT NULL,
  `sw_ok` int(1) NOT NULL COMMENT 'indica si ha sido validado',
  `id_registro` int(10) NOT NULL,
  `id_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'almacena el timestamp unix del momento cuando se puso listo al pedido',
  `asiento_apertura` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `facturada` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `contabilizada` int(1) NOT NULL DEFAULT '0' COMMENT 'indica si la emision de la factura ya fue contabilizada 1=si 0=no',
  `cancelada` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_referencia` int(1) NOT NULL,
  `folio_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'VA=venta anticipada CC=cuenta corriente',
  `folio_facturado` int(10) NOT NULL,
  `folio_notadebito` int(10) NOT NULL,
  `folio_notacredito` int(10) NOT NULL,
  `origen_factura` int(1) NOT NULL COMMENT '0=facturadirecta 1=facturaguias 2=facturapedidos',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'EP=EnProceso GR=grabada PR=Procesada AN=Anulada',
  `nivel_impresion` int(1) NOT NULL DEFAULT '0' COMMENT '0=detallado 1=resumido por categoria 2=resumido por subcategorias',
  `tipo_facturacion` int(1) NOT NULL DEFAULT '0' COMMENT '0=facturacion desde notas de venta 1=FACTURACION DESDE GUIAS DE DESPACHO',
  `anulada` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `sw_bloqueo` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `ano_control` int(4) NOT NULL,
  `numero_control` int(10) NOT NULL,
  `fecha_anulacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_cotizacion` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `folio_notaventa` int(10) NOT NULL DEFAULT '0',
  `folio_despacho` int(10) NOT NULL DEFAULT '0',
  `folio_ruta` int(10) NOT NULL DEFAULT '0',
  `folio_guiadespacho` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_ordencompra` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_recepcion` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'codigo de recepcion que entrega el cliente por ej. falabella codigo IR = Ingreso Recepción nº xxx',
  `id_vendedor` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'rut del empleado vendedor',
  `id_sucursal_venta` int(10) NOT NULL COMMENT 'id de la sucursal donde se emitio la factura',
  `id_bodega_despacho` int(10) NOT NULL COMMENT 'id de la bodega de donde se rebajaran los articulos vendidos',
  `nombre_sucursal_venta` varchar(255) COLLATE utf8_spanish_ci NOT NULL COMMENT 'nombre de la sucursal a la cual esta asociada la factura de venta',
  `exenta` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `electronica` int(1) NOT NULL DEFAULT '0',
  `tipo_factura` int(1) NOT NULL DEFAULT '1' COMMENT '1=manual afecta 2=electronica afecta 3=manual exenta 4=electronica exenta',
  `id_relacion` int(10) NOT NULL DEFAULT '0',
  `tipo_cliente` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'E=Empresa U=Universidad',
  `proyecto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT '0=Sin proyecto',
  `id_empresa` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL DEFAULT '0',
  `id_laboratorio` int(10) NOT NULL DEFAULT '0',
  `id_investigador` int(10) NOT NULL DEFAULT '0',
  `id_contacto` int(10) NOT NULL DEFAULT '0',
  `id_despacho` int(10) NOT NULL DEFAULT '0',
  `id_region` int(10) NOT NULL DEFAULT '0',
  `id_ciudad` int(10) NOT NULL DEFAULT '0',
  `id_comuna` int(10) NOT NULL DEFAULT '0',
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `razon_social` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_fantasia` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `giro` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefonos` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `region` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `ciudad` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `comuna` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_contacto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `mail_contacto` varchar(200) COLLATE utf8_spanish_ci NOT NULL,
  `nombre_investigador` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `atencion_facturacion` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_contacto` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_investigador` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_facturacion` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_proyecto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_facturacion` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp con fecha y hora de emision de la factura',
  `fecha_vencimiento` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_vencimiento` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp con fecha y hora de vencimiento',
  `via_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion_despacho` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_despacho` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `atencion_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `cancela_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `anticipo` int(10) NOT NULL,
  `subtotal` int(10) NOT NULL DEFAULT '0',
  `suma_afecto` int(10) NOT NULL,
  `descuento_afecto` decimal(12,2) NOT NULL,
  `tipodescuento_afecto` int(1) NOT NULL,
  `montodescuento_afecto` int(10) NOT NULL,
  `porcdescuento_afecto` decimal(5,2) NOT NULL,
  `suma_exento` int(10) NOT NULL,
  `descuento_exento` decimal(12,2) NOT NULL,
  `tipodescuento_exento` int(1) NOT NULL,
  `montodescuento_exento` int(10) NOT NULL,
  `porcdescuento_exento` decimal(5,2) NOT NULL,
  `descuento_porc` int(2) NOT NULL DEFAULT '0' COMMENT 'D',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0',
  `neto` int(10) NOT NULL DEFAULT '0',
  `neto_exento` int(10) NOT NULL,
  `tasa_iva` int(2) NOT NULL DEFAULT '19',
  `iva` int(10) NOT NULL DEFAULT '0',
  `bruto` int(10) NOT NULL DEFAULT '0',
  `saldo_pendiente` int(10) NOT NULL DEFAULT '0',
  `saldo_va` int(10) NOT NULL DEFAULT '0' COMMENT 'indica el saldo disponible de las facturas va',
  `bruto_palabras` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'Total bruto escrito en palabras',
  `id_condiciones_venta` int(10) NOT NULL DEFAULT '0',
  `id_mediopago` int(10) NOT NULL,
  `condiciones_venta` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT '1=Efectivo 2=Documentado 3=10 Dias 4=15 Dias 5=30 Dias 6=45 Dias 7=60 Dias 8=30/60 Dias 9=30/60/90 Dias',
  `observaciones` text COLLATE utf8_spanish_ci NOT NULL,
  `total_pagado` int(11) NOT NULL,
  `efectivo` int(11) NOT NULL,
  `vuelto` int(11) NOT NULL,
  `codigo_transbank` int(20) NOT NULL,
  `razon_referencia` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_usuario_anulacion` int(10) NOT NULL DEFAULT '0',
  `id_anulacion` int(10) NOT NULL DEFAULT '0',
  `motivo_anulacion` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_usuario_modifico` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario que realizo la ultima modificacion',
  `id_modificacion` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp de la ultima modificacion',
  `id_listaprecios` int(10) NOT NULL,
  `id_bodega` int(10) NOT NULL,
  `folio_final` int(10) NOT NULL,
  `rut_vendedor` char(10) COLLATE utf8_spanish_ci NOT NULL,
  `cancelo` int(10) NOT NULL,
  `trackid_masivo` varchar(20) COLLATE utf8_spanish_ci NOT NULL,
  `trackid_frecepcion` varchar(20) COLLATE utf8_spanish_ci NOT NULL,
  `trackid_eenvio` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `trackid_esii` int(10) NOT NULL,
  `trackid_destado` varchar(50) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `fecha_facturacion` (`fecha_facturacion`),
  KEY `id_factura` (`id_factura`),
  KEY `rut` (`rut`),
  KEY `id_relacion` (`id_relacion`),
  KEY `estado` (`estado`),
  KEY `id_sucursal_venta` (`id_sucursal_venta`),
  KEY `nombre_sucursal_venta` (`nombre_sucursal_venta`),
  KEY `mes_control` (`mes_control`,`ano_control`,`numero_control`),
  KEY `tipo_factura` (`tipo_factura`),
  KEY `codigo_recepcion` (`codigo_recepcion`),
  KEY `id_bodega_despacho` (`id_bodega_despacho`),
  KEY `nivel_impresion` (`nivel_impresion`),
  KEY `origen_factura` (`origen_factura`),
  KEY `sw_ok` (`sw_ok`),
  KEY `folio_timbraje` (`folio_timbraje`),
  KEY `folio_facturado` (`folio_facturado`),
  KEY `folio_notadebito` (`folio_notadebito`),
  KEY `folio_notacredito` (`folio_notacredito`),
  KEY `tipo_guia` (`tipo_guia`),
  KEY `estado_sii` (`estado_sii`),
  KEY `estado_recepcion` (`estado_recepcion`),
  KEY `sw_envio` (`sw_envio`),
  KEY `time_listaenvio` (`time_listaenvio`),
  KEY `id_enviomasivo` (`id_enviomasivo`),
  KEY `sw_backup` (`sw_backup`),
  KEY `id_mediopago` (`id_mediopago`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ventas_boleta`
--

LOCK TABLES `tbl_ventas_boleta` WRITE;
/*!40000 ALTER TABLE `tbl_ventas_boleta` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ventas_boleta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ventas_boletadetalle`
--

DROP TABLE IF EXISTS `tbl_ventas_boletadetalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ventas_boletadetalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `sw_backup` int(1) NOT NULL,
  `sw_exento` int(1) NOT NULL,
  `id_bodega_despacho` int(10) NOT NULL,
  `folio` int(10) NOT NULL COMMENT 'corresponde al id del encabezado',
  `folio_factura` int(10) NOT NULL DEFAULT '0',
  `orden_compra` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `folio_notapedido` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `origen_factura` int(1) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'EP=EnProceso GR=grabada PR=Procesada AN=Anulada',
  `folio_guiadespacho` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `anulada` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT '0=no 1=si',
  `id_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'id de la factura indica cuando se puso listo al pedido en bodega',
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `ano_control` int(4) NOT NULL,
  `numero_control` int(10) NOT NULL,
  `tipo_factura` int(1) NOT NULL DEFAULT '0' COMMENT '0=factura normal 1=facturacion anticipada',
  `id_facturacion` int(10) NOT NULL DEFAULT '0' COMMENT 'Solo para ordenamientos de fecha',
  `id_item` int(10) NOT NULL DEFAULT '0',
  `id_vendedor` int(10) NOT NULL DEFAULT '0',
  `id_relacion` int(10) NOT NULL DEFAULT '0',
  `rut_cliente` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_producto` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `unidad_medida` char(4) COLLATE utf8_spanish_ci NOT NULL,
  `sku_madre` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `nombre_sku_madre` varchar(250) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_sku` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_ean` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_alt` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_local` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_categoria` int(10) NOT NULL,
  `id_subcategoria` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'P=producto S=servicio C=cuenta',
  `id_activofijo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `pmp` decimal(12,2) NOT NULL DEFAULT '0.00',
  `cpp` int(10) NOT NULL DEFAULT '0',
  `precio_referencial` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'Cuanto costaba al momento de hacer la nota de venta',
  `precio_venta` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'En cuanto se vendio (con descuentos individual aplicado)',
  `precio_final_venta` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'precio de venta con descuento lineal y global aplicado',
  `cantidad` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `cantidad_devuelta` int(10) NOT NULL DEFAULT '0' COMMENT 'cantidad de unidades devueltas por medio de una nota de credito',
  `subtotal` int(10) NOT NULL DEFAULT '0',
  `descuento_porc` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT 'porcentaje de descuento',
  `descuento_porc_global` decimal(5,2) NOT NULL DEFAULT '0.00',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0',
  `subtotal_neto` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal con descuento aplicado',
  `subtotal_final` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal con descuento lineal y global aplicado ( SOLO PARA COMISIONES - ESTE ES EL VALOR REAL DE VENTA )',
  `monto_impuesto_adicional` int(10) NOT NULL,
  `monto_impuesto_especifico` int(10) NOT NULL,
  `comision_porcentaje` decimal(5,2) NOT NULL DEFAULT '0.00',
  `comision_pesos` int(10) NOT NULL DEFAULT '0',
  `comision_porcentaje_extra` decimal(5,2) NOT NULL DEFAULT '0.00',
  `comision_pesos_extra` int(10) NOT NULL DEFAULT '0',
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_sucursal_venta` int(10) NOT NULL,
  `rut_vendedor` char(10) COLLATE utf8_spanish_ci NOT NULL,
  `sw_facturable` int(1) NOT NULL,
  `subtotal_costo` int(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `folio_factura` (`folio_factura`),
  KEY `id_activofijo` (`id_activofijo`),
  KEY `pmp` (`pmp`),
  KEY `id_proyecto` (`id_proyecto`),
  KEY `estado` (`estado`),
  KEY `mes_control` (`mes_control`,`ano_control`,`numero_control`),
  KEY `folio` (`folio`),
  KEY `id_bodega_despacho` (`id_bodega_despacho`),
  KEY `id_categoria` (`id_categoria`),
  KEY `id_subcategoria` (`id_subcategoria`),
  KEY `codigo_sku` (`codigo_sku`),
  KEY `codigo_ean` (`codigo_ean`),
  KEY `codigo_alt` (`codigo_alt`),
  KEY `codigo_local` (`codigo_local`),
  KEY `origen_factura` (`origen_factura`),
  KEY `orden_compra` (`orden_compra`),
  KEY `folio_notapedido` (`folio_notapedido`),
  KEY `sku_madre` (`sku_madre`),
  KEY `nombre_sku_madre` (`nombre_sku_madre`),
  KEY `codigo_producto` (`codigo_producto`),
  KEY `anulada` (`anulada`),
  KEY `sw_backup` (`sw_backup`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ventas_boletadetalle`
--

LOCK TABLES `tbl_ventas_boletadetalle` WRITE;
/*!40000 ALTER TABLE `tbl_ventas_boletadetalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ventas_boletadetalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ventas_boletadetallekk`
--

DROP TABLE IF EXISTS `tbl_ventas_boletadetallekk`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ventas_boletadetallekk` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `sw_backup` int(1) NOT NULL,
  `sw_exento` int(1) NOT NULL,
  `id_bodega_despacho` int(10) NOT NULL,
  `folio` int(10) NOT NULL COMMENT 'corresponde al id del encabezado',
  `folio_factura` int(10) NOT NULL DEFAULT '0',
  `orden_compra` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `folio_notapedido` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `origen_factura` int(1) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'EP=EnProceso GR=grabada PR=Procesada AN=Anulada',
  `folio_guiadespacho` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `anulada` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT '0=no 1=si',
  `id_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'id de la factura indica cuando se puso listo al pedido en bodega',
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `ano_control` int(4) NOT NULL,
  `numero_control` int(10) NOT NULL,
  `tipo_factura` int(1) NOT NULL DEFAULT '0' COMMENT '0=factura normal 1=facturacion anticipada',
  `id_facturacion` int(10) NOT NULL DEFAULT '0' COMMENT 'Solo para ordenamientos de fecha',
  `id_item` int(10) NOT NULL DEFAULT '0',
  `id_vendedor` int(10) NOT NULL DEFAULT '0',
  `id_relacion` int(10) NOT NULL DEFAULT '0',
  `rut_cliente` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_producto` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `unidad_medida` char(4) COLLATE utf8_spanish_ci NOT NULL,
  `sku_madre` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `nombre_sku_madre` varchar(250) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_sku` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_ean` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_alt` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_local` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_categoria` int(10) NOT NULL,
  `id_subcategoria` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'P=producto S=servicio C=cuenta',
  `id_activofijo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `pmp` decimal(12,2) NOT NULL DEFAULT '0.00',
  `cpp` int(10) NOT NULL DEFAULT '0',
  `precio_referencial` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'Cuanto costaba al momento de hacer la nota de venta',
  `precio_venta` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'En cuanto se vendio (con descuentos individual aplicado)',
  `precio_final_venta` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'precio de venta con descuento lineal y global aplicado',
  `cantidad` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `cantidad_devuelta` int(10) NOT NULL DEFAULT '0' COMMENT 'cantidad de unidades devueltas por medio de una nota de credito',
  `subtotal` int(10) NOT NULL DEFAULT '0',
  `descuento_porc` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT 'porcentaje de descuento',
  `descuento_porc_global` decimal(5,2) NOT NULL DEFAULT '0.00',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0',
  `subtotal_neto` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal con descuento aplicado',
  `subtotal_final` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal con descuento lineal y global aplicado ( SOLO PARA COMISIONES - ESTE ES EL VALOR REAL DE VENTA )',
  `comision_porcentaje` decimal(5,2) NOT NULL DEFAULT '0.00',
  `comision_pesos` int(10) NOT NULL DEFAULT '0',
  `comision_porcentaje_extra` decimal(5,2) NOT NULL DEFAULT '0.00',
  `comision_pesos_extra` int(10) NOT NULL DEFAULT '0',
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_sucursal_venta` int(10) NOT NULL,
  `rut_vendedor` char(10) COLLATE utf8_spanish_ci NOT NULL,
  `sw_facturable` int(1) NOT NULL,
  `subtotal_costo` int(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `folio_factura` (`folio_factura`),
  KEY `id_activofijo` (`id_activofijo`),
  KEY `pmp` (`pmp`),
  KEY `id_proyecto` (`id_proyecto`),
  KEY `estado` (`estado`),
  KEY `mes_control` (`mes_control`,`ano_control`,`numero_control`),
  KEY `folio` (`folio`),
  KEY `id_bodega_despacho` (`id_bodega_despacho`),
  KEY `id_categoria` (`id_categoria`),
  KEY `id_subcategoria` (`id_subcategoria`),
  KEY `codigo_sku` (`codigo_sku`),
  KEY `codigo_ean` (`codigo_ean`),
  KEY `codigo_alt` (`codigo_alt`),
  KEY `codigo_local` (`codigo_local`),
  KEY `origen_factura` (`origen_factura`),
  KEY `orden_compra` (`orden_compra`),
  KEY `folio_notapedido` (`folio_notapedido`),
  KEY `sku_madre` (`sku_madre`),
  KEY `nombre_sku_madre` (`nombre_sku_madre`),
  KEY `codigo_producto` (`codigo_producto`),
  KEY `anulada` (`anulada`),
  KEY `sw_backup` (`sw_backup`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ventas_boletadetallekk`
--

LOCK TABLES `tbl_ventas_boletadetallekk` WRITE;
/*!40000 ALTER TABLE `tbl_ventas_boletadetallekk` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ventas_boletadetallekk` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ventas_consumofolios`
--

DROP TABLE IF EXISTS `tbl_ventas_consumofolios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ventas_consumofolios` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `fecha` date NOT NULL,
  `trackid` char(10) NOT NULL,
  `neto39` int(10) NOT NULL,
  `exento39` int(10) NOT NULL,
  `iva39` int(10) NOT NULL,
  `total39` int(10) NOT NULL,
  `total41` int(10) NOT NULL,
  `foliosemitidos39` int(10) NOT NULL,
  `foliosanulados39` int(10) NOT NULL,
  `foliosutilizados39` int(10) NOT NULL,
  `rangoutilizadosinicial39` int(10) NOT NULL,
  `rangoutilizadosfinal39` int(10) NOT NULL,
  `rangoanuladosinicial39` int(10) NOT NULL,
  `rangoanuladosfinal39` int(10) NOT NULL,
  `foliosemitidos41` int(10) NOT NULL,
  `foliosanulados41` int(10) NOT NULL,
  `foliosutilizados41` int(10) NOT NULL,
  `rangoutilizadosinicial41` int(10) NOT NULL,
  `rangoutilizadosfinal41` int(10) NOT NULL,
  `rangoanuladosinicial41` int(10) NOT NULL,
  `rangoanuladosfinal41` int(10) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ventas_consumofolios`
--

LOCK TABLES `tbl_ventas_consumofolios` WRITE;
/*!40000 ALTER TABLE `tbl_ventas_consumofolios` DISABLE KEYS */;
INSERT INTO `tbl_ventas_consumofolios` VALUES (1,'2017-11-20','',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(2,'2018-01-07','',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
/*!40000 ALTER TABLE `tbl_ventas_consumofolios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ventas_credito`
--

DROP TABLE IF EXISTS `tbl_ventas_credito`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ventas_credito` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `sw_backup` int(1) NOT NULL,
  `time_timbrado` varchar(20) COLLATE utf8_spanish_ci NOT NULL,
  `sw_envio` int(1) NOT NULL COMMENT '0=sinagregar  1=agregadoporenviar 2=enviado',
  `time_listaenvio` int(10) NOT NULL COMMENT 'ordenamiento de los documentos a enviar por orden en que fueron agregados al listado',
  `estado_sii` int(1) NOT NULL DEFAULT '0' COMMENT 'estados dte ante el sii: 1.-Por Enviar - rojo 2.-Enviado - amarillo 3.-Aceptado - verde 4.-Rechazado - negro',
  `estado_recepcion` char(8) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_recepcion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `hora_recepcion` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `time_recepcion` int(10) NOT NULL,
  `id_recepcion` varchar(16) COLLATE utf8_spanish_ci NOT NULL,
  `folio_timbraje` int(10) NOT NULL,
  `tipo_documento` varchar(2) COLLATE utf8_spanish_ci NOT NULL,
  `tipo_guia` int(2) NOT NULL COMMENT 'codigos sii de tipos de guias',
  `tipo_despacho` int(1) NOT NULL,
  `sw_ok` int(1) NOT NULL COMMENT 'indica si ha sido validado',
  `id_registro` int(10) NOT NULL,
  `id_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'almacena el timestamp unix del momento cuando se puso listo al pedido',
  `asiento_apertura` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `facturada` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `contabilizada` int(1) NOT NULL DEFAULT '0' COMMENT 'indica si la emision de la factura ya fue contabilizada 1=si 0=no',
  `cancelada` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_referencia` int(1) NOT NULL,
  `folio_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'VA=venta anticipada CC=cuenta corriente',
  `folio_facturado` int(10) NOT NULL,
  `folio_notadebito` int(10) NOT NULL,
  `folio_notacredito` int(10) NOT NULL,
  `origen_factura` int(1) NOT NULL COMMENT '0=facturadirecta 1=facturaguias 2=facturapedidos',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'EP=EnProceso GR=grabada PR=Procesada AN=Anulada',
  `nivel_impresion` int(1) NOT NULL DEFAULT '0' COMMENT '0=detallado 1=resumido por categoria 2=resumido por subcategorias',
  `tipo_facturacion` int(1) NOT NULL DEFAULT '0' COMMENT '0=facturacion desde notas de venta 1=FACTURACION DESDE GUIAS DE DESPACHO',
  `anulada` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `sw_bloqueo` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `ano_control` int(4) NOT NULL,
  `numero_control` int(10) NOT NULL,
  `fecha_anulacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_cotizacion` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `folio_notaventa` int(10) NOT NULL DEFAULT '0',
  `folio_despacho` int(10) NOT NULL DEFAULT '0',
  `folio_ruta` int(10) NOT NULL DEFAULT '0',
  `folio_guiadespacho` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_ordencompra` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_recepcion` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'codigo de recepcion que entrega el cliente por ej. falabella codigo IR = Ingreso Recepción nº xxx',
  `id_vendedor` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'rut del empleado vendedor',
  `id_sucursal_venta` int(10) NOT NULL COMMENT 'id de la sucursal donde se emitio la factura',
  `id_bodega_despacho` int(10) NOT NULL COMMENT 'id de la bodega de donde se rebajaran los articulos vendidos',
  `nombre_sucursal_venta` varchar(255) COLLATE utf8_spanish_ci NOT NULL COMMENT 'nombre de la sucursal a la cual esta asociada la factura de venta',
  `exenta` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `electronica` int(1) NOT NULL DEFAULT '0',
  `tipo_factura` int(1) NOT NULL DEFAULT '1' COMMENT '1=manual afecta 2=electronica afecta 3=manual exenta 4=electronica exenta',
  `id_relacion` int(10) NOT NULL DEFAULT '0',
  `tipo_cliente` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'E=Empresa U=Universidad',
  `proyecto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT '0=Sin proyecto',
  `id_empresa` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL DEFAULT '0',
  `id_laboratorio` int(10) NOT NULL DEFAULT '0',
  `id_investigador` int(10) NOT NULL DEFAULT '0',
  `id_contacto` int(10) NOT NULL DEFAULT '0',
  `id_despacho` int(10) NOT NULL DEFAULT '0',
  `id_region` int(10) NOT NULL DEFAULT '0',
  `id_ciudad` int(10) NOT NULL DEFAULT '0',
  `id_comuna` int(10) NOT NULL DEFAULT '0',
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `razon_social` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_fantasia` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `giro` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefonos` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `region` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `ciudad` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `comuna` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_contacto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `mail_contacto` varchar(200) COLLATE utf8_spanish_ci NOT NULL,
  `nombre_investigador` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `atencion_facturacion` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_contacto` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_investigador` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_facturacion` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_proyecto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_facturacion` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp con fecha y hora de emision de la factura',
  `fecha_vencimiento` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_vencimiento` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp con fecha y hora de vencimiento',
  `via_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion_despacho` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_despacho` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `atencion_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `cancela_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `anticipo` int(10) NOT NULL,
  `subtotal` int(10) NOT NULL DEFAULT '0',
  `suma_afecto` int(10) NOT NULL,
  `descuento_afecto` decimal(12,2) NOT NULL,
  `tipodescuento_afecto` int(1) NOT NULL,
  `montodescuento_afecto` int(10) NOT NULL,
  `porcdescuento_afecto` decimal(5,2) NOT NULL,
  `suma_exento` int(10) NOT NULL,
  `descuento_exento` decimal(12,2) NOT NULL,
  `tipodescuento_exento` int(1) NOT NULL,
  `montodescuento_exento` int(10) NOT NULL,
  `porcdescuento_exento` decimal(5,2) NOT NULL,
  `descuento_porc` int(2) NOT NULL DEFAULT '0' COMMENT 'D',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0',
  `neto` int(10) NOT NULL DEFAULT '0',
  `neto_exento` int(10) NOT NULL,
  `tasa_iva` int(2) NOT NULL DEFAULT '19',
  `iva` int(10) NOT NULL DEFAULT '0',
  `bruto` int(10) NOT NULL DEFAULT '0',
  `saldo_pendiente` int(10) NOT NULL DEFAULT '0',
  `saldo_va` int(10) NOT NULL DEFAULT '0' COMMENT 'indica el saldo disponible de las facturas va',
  `bruto_palabras` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'Total bruto escrito en palabras',
  `id_condiciones_venta` int(10) NOT NULL DEFAULT '0',
  `condiciones_venta` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT '1=Efectivo 2=Documentado 3=10 Dias 4=15 Dias 5=30 Dias 6=45 Dias 7=60 Dias 8=30/60 Dias 9=30/60/90 Dias',
  `observaciones` text COLLATE utf8_spanish_ci NOT NULL,
  `razon_referencia` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_usuario_anulacion` int(10) NOT NULL DEFAULT '0',
  `id_anulacion` int(10) NOT NULL DEFAULT '0',
  `motivo_anulacion` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_usuario_modifico` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario que realizo la ultima modificacion',
  `id_modificacion` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp de la ultima modificacion',
  `tipo_documento_referencia` char(3) COLLATE utf8_spanish_ci NOT NULL,
  `sw_fueraplazo` int(1) NOT NULL,
  `estatus_sii` varchar(20) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `fecha_facturacion` (`fecha_facturacion`),
  KEY `id_factura` (`id_factura`),
  KEY `rut` (`rut`),
  KEY `id_relacion` (`id_relacion`),
  KEY `estado` (`estado`),
  KEY `id_sucursal_venta` (`id_sucursal_venta`),
  KEY `nombre_sucursal_venta` (`nombre_sucursal_venta`),
  KEY `mes_control` (`mes_control`,`ano_control`,`numero_control`),
  KEY `tipo_factura` (`tipo_factura`),
  KEY `codigo_recepcion` (`codigo_recepcion`),
  KEY `id_bodega_despacho` (`id_bodega_despacho`),
  KEY `nivel_impresion` (`nivel_impresion`),
  KEY `origen_factura` (`origen_factura`),
  KEY `sw_ok` (`sw_ok`),
  KEY `folio_timbraje` (`folio_timbraje`),
  KEY `folio_facturado` (`folio_facturado`),
  KEY `folio_notadebito` (`folio_notadebito`),
  KEY `folio_notacredito` (`folio_notacredito`),
  KEY `tipo_guia` (`tipo_guia`),
  KEY `estado_sii` (`estado_sii`),
  KEY `estado_recepcion` (`estado_recepcion`),
  KEY `sw_envio` (`sw_envio`),
  KEY `time_listaenvio` (`time_listaenvio`),
  KEY `sw_backup` (`sw_backup`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ventas_credito`
--

LOCK TABLES `tbl_ventas_credito` WRITE;
/*!40000 ALTER TABLE `tbl_ventas_credito` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ventas_credito` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ventas_debito`
--

DROP TABLE IF EXISTS `tbl_ventas_debito`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ventas_debito` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `sw_backup` int(1) NOT NULL,
  `time_timbrado` varchar(20) COLLATE utf8_spanish_ci NOT NULL,
  `sw_envio` int(1) NOT NULL COMMENT '0=sinagregar  1=agregadoporenviar 2=enviado',
  `time_listaenvio` int(10) NOT NULL COMMENT 'ordenamiento de los documentos a enviar por orden en que fueron agregados al listado',
  `estado_sii` int(1) NOT NULL DEFAULT '0' COMMENT 'estados dte ante el sii: 1.-Por Enviar - rojo 2.-Enviado - amarillo 3.-Aceptado - verde 4.-Rechazado - negro',
  `estado_recepcion` char(8) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_recepcion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `hora_recepcion` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `time_recepcion` int(10) NOT NULL,
  `id_recepcion` int(10) NOT NULL,
  `folio_timbraje` int(10) NOT NULL,
  `tipo_documento` varchar(2) COLLATE utf8_spanish_ci NOT NULL,
  `tipo_guia` int(2) NOT NULL COMMENT 'codigos sii de tipos de guias',
  `tipo_despacho` int(1) NOT NULL,
  `sw_ok` int(1) NOT NULL COMMENT 'indica si ha sido validado',
  `id_registro` int(10) NOT NULL,
  `id_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'almacena el timestamp unix del momento cuando se puso listo al pedido',
  `asiento_apertura` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `facturada` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `contabilizada` int(1) NOT NULL DEFAULT '0' COMMENT 'indica si la emision de la factura ya fue contabilizada 1=si 0=no',
  `cancelada` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_referencia` int(1) NOT NULL,
  `folio_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'VA=venta anticipada CC=cuenta corriente',
  `folio_facturado` int(10) NOT NULL,
  `folio_notadebito` int(10) NOT NULL,
  `folio_notacredito` int(10) NOT NULL,
  `origen_factura` int(1) NOT NULL COMMENT '0=facturadirecta 1=facturaguias 2=facturapedidos',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'EP=EnProceso GR=grabada PR=Procesada AN=Anulada',
  `nivel_impresion` int(1) NOT NULL DEFAULT '0' COMMENT '0=detallado 1=resumido por categoria 2=resumido por subcategorias',
  `tipo_facturacion` int(1) NOT NULL DEFAULT '0' COMMENT '0=facturacion desde notas de venta 1=FACTURACION DESDE GUIAS DE DESPACHO',
  `anulada` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `sw_bloqueo` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `ano_control` int(4) NOT NULL,
  `numero_control` int(10) NOT NULL,
  `fecha_anulacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_cotizacion` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `folio_notaventa` int(10) NOT NULL DEFAULT '0',
  `folio_despacho` int(10) NOT NULL DEFAULT '0',
  `folio_ruta` int(10) NOT NULL DEFAULT '0',
  `folio_guiadespacho` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_ordencompra` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_recepcion` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'codigo de recepcion que entrega el cliente por ej. falabella codigo IR = Ingreso Recepción nº xxx',
  `id_vendedor` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'rut del empleado vendedor',
  `id_sucursal_venta` int(10) NOT NULL COMMENT 'id de la sucursal donde se emitio la factura',
  `id_bodega_despacho` int(10) NOT NULL COMMENT 'id de la bodega de donde se rebajaran los articulos vendidos',
  `nombre_sucursal_venta` varchar(255) COLLATE utf8_spanish_ci NOT NULL COMMENT 'nombre de la sucursal a la cual esta asociada la factura de venta',
  `exenta` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `electronica` int(1) NOT NULL DEFAULT '0',
  `tipo_factura` int(1) NOT NULL DEFAULT '1' COMMENT '1=manual afecta 2=electronica afecta 3=manual exenta 4=electronica exenta',
  `id_relacion` int(10) NOT NULL DEFAULT '0',
  `tipo_cliente` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'E=Empresa U=Universidad',
  `proyecto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT '0=Sin proyecto',
  `id_empresa` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL DEFAULT '0',
  `id_laboratorio` int(10) NOT NULL DEFAULT '0',
  `id_investigador` int(10) NOT NULL DEFAULT '0',
  `id_contacto` int(10) NOT NULL DEFAULT '0',
  `id_despacho` int(10) NOT NULL DEFAULT '0',
  `id_region` int(10) NOT NULL DEFAULT '0',
  `id_ciudad` int(10) NOT NULL DEFAULT '0',
  `id_comuna` int(10) NOT NULL DEFAULT '0',
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `razon_social` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_fantasia` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `giro` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefonos` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `region` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `ciudad` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `comuna` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_contacto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `mail_contacto` varchar(200) COLLATE utf8_spanish_ci NOT NULL,
  `nombre_investigador` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `atencion_facturacion` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_contacto` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_investigador` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_facturacion` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_proyecto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_facturacion` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp con fecha y hora de emision de la factura',
  `fecha_vencimiento` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_vencimiento` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp con fecha y hora de vencimiento',
  `via_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion_despacho` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_despacho` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `atencion_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `cancela_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `anticipo` int(10) NOT NULL,
  `subtotal` int(10) NOT NULL DEFAULT '0',
  `suma_afecto` int(10) NOT NULL,
  `descuento_afecto` decimal(12,2) NOT NULL,
  `tipodescuento_afecto` int(1) NOT NULL,
  `montodescuento_afecto` int(10) NOT NULL,
  `porcdescuento_afecto` decimal(5,2) NOT NULL,
  `suma_exento` int(10) NOT NULL,
  `descuento_exento` decimal(12,2) NOT NULL,
  `tipodescuento_exento` int(1) NOT NULL,
  `montodescuento_exento` int(10) NOT NULL,
  `porcdescuento_exento` decimal(5,2) NOT NULL,
  `descuento_porc` int(2) NOT NULL DEFAULT '0' COMMENT 'D',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0',
  `neto` int(10) NOT NULL DEFAULT '0',
  `neto_exento` int(10) NOT NULL,
  `tasa_iva` int(2) NOT NULL DEFAULT '19',
  `iva` int(10) NOT NULL DEFAULT '0',
  `bruto` int(10) NOT NULL DEFAULT '0',
  `saldo_pendiente` int(10) NOT NULL DEFAULT '0',
  `saldo_va` int(10) NOT NULL DEFAULT '0' COMMENT 'indica el saldo disponible de las facturas va',
  `bruto_palabras` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'Total bruto escrito en palabras',
  `id_condiciones_venta` int(10) NOT NULL DEFAULT '0',
  `condiciones_venta` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT '1=Efectivo 2=Documentado 3=10 Dias 4=15 Dias 5=30 Dias 6=45 Dias 7=60 Dias 8=30/60 Dias 9=30/60/90 Dias',
  `observaciones` text COLLATE utf8_spanish_ci NOT NULL,
  `razon_referencia` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_usuario_anulacion` int(10) NOT NULL DEFAULT '0',
  `id_anulacion` int(10) NOT NULL DEFAULT '0',
  `motivo_anulacion` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_usuario_modifico` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario que realizo la ultima modificacion',
  `id_modificacion` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp de la ultima modificacion',
  `tipo_documento_referencia` char(3) COLLATE utf8_spanish_ci NOT NULL,
  `estatus_sii` varchar(20) COLLATE utf8_spanish_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `fecha_facturacion` (`fecha_facturacion`),
  KEY `id_factura` (`id_factura`),
  KEY `rut` (`rut`),
  KEY `id_relacion` (`id_relacion`),
  KEY `estado` (`estado`),
  KEY `id_sucursal_venta` (`id_sucursal_venta`),
  KEY `nombre_sucursal_venta` (`nombre_sucursal_venta`),
  KEY `mes_control` (`mes_control`,`ano_control`,`numero_control`),
  KEY `tipo_factura` (`tipo_factura`),
  KEY `codigo_recepcion` (`codigo_recepcion`),
  KEY `id_bodega_despacho` (`id_bodega_despacho`),
  KEY `nivel_impresion` (`nivel_impresion`),
  KEY `origen_factura` (`origen_factura`),
  KEY `sw_ok` (`sw_ok`),
  KEY `folio_timbraje` (`folio_timbraje`),
  KEY `folio_facturado` (`folio_facturado`),
  KEY `folio_notadebito` (`folio_notadebito`),
  KEY `folio_notacredito` (`folio_notacredito`),
  KEY `tipo_guia` (`tipo_guia`),
  KEY `estado_sii` (`estado_sii`),
  KEY `estado_recepcion` (`estado_recepcion`),
  KEY `sw_envio` (`sw_envio`),
  KEY `time_listaenvio` (`time_listaenvio`),
  KEY `sw_backup` (`sw_backup`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ventas_debito`
--

LOCK TABLES `tbl_ventas_debito` WRITE;
/*!40000 ALTER TABLE `tbl_ventas_debito` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ventas_debito` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ventas_transbank`
--

DROP TABLE IF EXISTS `tbl_ventas_transbank`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ventas_transbank` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `sw_backup` int(1) NOT NULL,
  `time_timbrado` varchar(20) COLLATE utf8_spanish_ci NOT NULL,
  `sw_envio` int(1) NOT NULL COMMENT '0=sinagregar  1=agregadoporenviar 2=enviado',
  `id_enviomasivo` int(10) NOT NULL,
  `time_listaenvio` int(10) NOT NULL COMMENT 'ordenamiento de los documentos a enviar por orden en que fueron agregados al listado',
  `estado_sii` int(1) NOT NULL DEFAULT '0' COMMENT 'estados dte ante el sii: 1.-Por Enviar - rojo 2.-Enviado - amarillo 3.-Aceptado - verde 4.-Rechazado - negro',
  `estado_recepcion` char(8) COLLATE utf8_spanish_ci NOT NULL,
  `fecha_recepcion` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `hora_recepcion` varchar(8) COLLATE utf8_spanish_ci NOT NULL,
  `time_recepcion` int(10) NOT NULL,
  `id_recepcion` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `folio_timbraje` int(10) NOT NULL,
  `tipo_documento` varchar(2) COLLATE utf8_spanish_ci NOT NULL,
  `tipo_guia` int(2) NOT NULL COMMENT 'codigos sii de tipos de guias',
  `tipo_despacho` int(1) NOT NULL,
  `sw_ok` int(1) NOT NULL COMMENT 'indica si ha sido validado',
  `id_registro` int(10) NOT NULL,
  `id_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'almacena el timestamp unix del momento cuando se puso listo al pedido',
  `asiento_apertura` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `facturada` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `contabilizada` int(1) NOT NULL DEFAULT '0' COMMENT 'indica si la emision de la factura ya fue contabilizada 1=si 0=no',
  `cancelada` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_referencia` int(1) NOT NULL,
  `folio_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'VA=venta anticipada CC=cuenta corriente',
  `folio_facturado` int(10) NOT NULL,
  `folio_notadebito` int(10) NOT NULL,
  `folio_notacredito` int(10) NOT NULL,
  `origen_factura` int(1) NOT NULL COMMENT '0=facturadirecta 1=facturaguias 2=facturapedidos',
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'EP=EnProceso GR=grabada PR=Procesada AN=Anulada',
  `nivel_impresion` int(1) NOT NULL DEFAULT '0' COMMENT '0=detallado 1=resumido por categoria 2=resumido por subcategorias',
  `tipo_facturacion` int(1) NOT NULL DEFAULT '0' COMMENT '0=facturacion desde notas de venta 1=FACTURACION DESDE GUIAS DE DESPACHO',
  `anulada` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `sw_bloqueo` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `ano_control` int(4) NOT NULL,
  `numero_control` int(10) NOT NULL,
  `fecha_anulacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_cotizacion` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `folio_notaventa` int(10) NOT NULL DEFAULT '0',
  `folio_despacho` int(10) NOT NULL DEFAULT '0',
  `folio_ruta` int(10) NOT NULL DEFAULT '0',
  `folio_guiadespacho` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `folio_ordencompra` varchar(30) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_recepcion` varchar(32) COLLATE utf8_spanish_ci NOT NULL COMMENT 'codigo de recepcion que entrega el cliente por ej. falabella codigo IR = Ingreso Recepción nº xxx',
  `id_vendedor` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'rut del empleado vendedor',
  `id_sucursal_venta` int(10) NOT NULL COMMENT 'id de la sucursal donde se emitio la factura',
  `id_bodega_despacho` int(10) NOT NULL COMMENT 'id de la bodega de donde se rebajaran los articulos vendidos',
  `nombre_sucursal_venta` varchar(255) COLLATE utf8_spanish_ci NOT NULL COMMENT 'nombre de la sucursal a la cual esta asociada la factura de venta',
  `exenta` int(1) NOT NULL DEFAULT '0' COMMENT '1=si 0=no',
  `electronica` int(1) NOT NULL DEFAULT '0',
  `tipo_factura` int(1) NOT NULL DEFAULT '1' COMMENT '1=manual afecta 2=electronica afecta 3=manual exenta 4=electronica exenta',
  `id_relacion` int(10) NOT NULL DEFAULT '0',
  `tipo_cliente` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'E=Empresa U=Universidad',
  `proyecto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_proyecto` int(10) NOT NULL DEFAULT '0' COMMENT '0=Sin proyecto',
  `id_empresa` int(10) NOT NULL DEFAULT '0',
  `id_sucursal` int(10) NOT NULL DEFAULT '0',
  `id_laboratorio` int(10) NOT NULL DEFAULT '0',
  `id_investigador` int(10) NOT NULL DEFAULT '0',
  `id_contacto` int(10) NOT NULL DEFAULT '0',
  `id_despacho` int(10) NOT NULL DEFAULT '0',
  `id_region` int(10) NOT NULL DEFAULT '0',
  `id_ciudad` int(10) NOT NULL DEFAULT '0',
  `id_comuna` int(10) NOT NULL DEFAULT '0',
  `rut` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `razon_social` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_fantasia` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `giro` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefonos` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `region` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `ciudad` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `comuna` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_contacto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `mail_contacto` varchar(200) COLLATE utf8_spanish_ci NOT NULL,
  `nombre_investigador` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `atencion_facturacion` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_contacto` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_investigador` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_facturacion` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `nombre_proyecto` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_facturacion` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp con fecha y hora de emision de la factura',
  `fecha_vencimiento` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_vencimiento` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp con fecha y hora de vencimiento',
  `via_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `direccion_despacho` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `telefono_despacho` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `atencion_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `cancela_despacho` varchar(200) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `anticipo` int(10) NOT NULL,
  `subtotal` int(10) NOT NULL DEFAULT '0',
  `suma_afecto` int(10) NOT NULL,
  `descuento_afecto` decimal(12,2) NOT NULL,
  `tipodescuento_afecto` int(1) NOT NULL,
  `montodescuento_afecto` int(10) NOT NULL,
  `porcdescuento_afecto` decimal(5,2) NOT NULL,
  `suma_exento` int(10) NOT NULL,
  `descuento_exento` decimal(12,2) NOT NULL,
  `tipodescuento_exento` int(1) NOT NULL,
  `montodescuento_exento` int(10) NOT NULL,
  `porcdescuento_exento` decimal(5,2) NOT NULL,
  `descuento_porc` int(2) NOT NULL DEFAULT '0' COMMENT 'D',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0',
  `neto` int(10) NOT NULL DEFAULT '0',
  `neto_exento` int(10) NOT NULL,
  `tasa_iva` int(2) NOT NULL DEFAULT '19',
  `iva` int(10) NOT NULL DEFAULT '0',
  `bruto` int(10) NOT NULL DEFAULT '0',
  `saldo_pendiente` int(10) NOT NULL DEFAULT '0',
  `saldo_va` int(10) NOT NULL DEFAULT '0' COMMENT 'indica el saldo disponible de las facturas va',
  `bruto_palabras` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'Total bruto escrito en palabras',
  `id_condiciones_venta` int(10) NOT NULL DEFAULT '0',
  `condiciones_venta` varchar(50) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT '1=Efectivo 2=Documentado 3=10 Dias 4=15 Dias 5=30 Dias 6=45 Dias 7=60 Dias 8=30/60 Dias 9=30/60/90 Dias',
  `observaciones` text COLLATE utf8_spanish_ci NOT NULL,
  `razon_referencia` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `id_usuario_anulacion` int(10) NOT NULL DEFAULT '0',
  `id_anulacion` int(10) NOT NULL DEFAULT '0',
  `motivo_anulacion` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_usuario_modifico` int(10) NOT NULL DEFAULT '0' COMMENT 'id del usuario que realizo la ultima modificacion',
  `id_modificacion` int(10) NOT NULL DEFAULT '0' COMMENT 'time stamp de la ultima modificacion',
  `id_listaprecios` int(10) NOT NULL,
  `id_bodega` int(10) NOT NULL,
  `folio_final` int(10) NOT NULL,
  `rut_vendedor` char(10) COLLATE utf8_spanish_ci NOT NULL,
  `cancelo` int(10) NOT NULL,
  `documento_emision` int(10) NOT NULL,
  `cantidad_cuotas` int(2) NOT NULL,
  `tipo_tarjeta` int(10) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `fecha_facturacion` (`fecha_facturacion`),
  KEY `id_factura` (`id_factura`),
  KEY `rut` (`rut`),
  KEY `id_relacion` (`id_relacion`),
  KEY `estado` (`estado`),
  KEY `id_sucursal_venta` (`id_sucursal_venta`),
  KEY `nombre_sucursal_venta` (`nombre_sucursal_venta`),
  KEY `mes_control` (`mes_control`,`ano_control`,`numero_control`),
  KEY `tipo_factura` (`tipo_factura`),
  KEY `codigo_recepcion` (`codigo_recepcion`),
  KEY `id_bodega_despacho` (`id_bodega_despacho`),
  KEY `nivel_impresion` (`nivel_impresion`),
  KEY `origen_factura` (`origen_factura`),
  KEY `sw_ok` (`sw_ok`),
  KEY `folio_timbraje` (`folio_timbraje`),
  KEY `folio_facturado` (`folio_facturado`),
  KEY `folio_notadebito` (`folio_notadebito`),
  KEY `folio_notacredito` (`folio_notacredito`),
  KEY `tipo_guia` (`tipo_guia`),
  KEY `estado_sii` (`estado_sii`),
  KEY `estado_recepcion` (`estado_recepcion`),
  KEY `sw_envio` (`sw_envio`),
  KEY `time_listaenvio` (`time_listaenvio`),
  KEY `id_enviomasivo` (`id_enviomasivo`),
  KEY `sw_backup` (`sw_backup`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ventas_transbank`
--

LOCK TABLES `tbl_ventas_transbank` WRITE;
/*!40000 ALTER TABLE `tbl_ventas_transbank` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ventas_transbank` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ventas_transbankdetalle`
--

DROP TABLE IF EXISTS `tbl_ventas_transbankdetalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ventas_transbankdetalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `sw_backup` int(1) NOT NULL,
  `sw_exento` int(1) NOT NULL,
  `id_bodega_despacho` int(10) NOT NULL,
  `folio` int(10) NOT NULL COMMENT 'corresponde al id del encabezado',
  `folio_factura` int(10) NOT NULL DEFAULT '0',
  `orden_compra` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `folio_notapedido` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `origen_factura` int(1) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'EP=EnProceso GR=grabada PR=Procesada AN=Anulada',
  `folio_guiadespacho` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `anulada` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT '0=no 1=si',
  `id_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'id de la factura indica cuando se puso listo al pedido en bodega',
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `ano_control` int(4) NOT NULL,
  `numero_control` int(10) NOT NULL,
  `tipo_factura` int(1) NOT NULL DEFAULT '0' COMMENT '0=factura normal 1=facturacion anticipada',
  `id_facturacion` int(10) NOT NULL DEFAULT '0' COMMENT 'Solo para ordenamientos de fecha',
  `id_item` int(10) NOT NULL DEFAULT '0',
  `id_vendedor` int(10) NOT NULL DEFAULT '0',
  `id_relacion` int(10) NOT NULL DEFAULT '0',
  `rut_cliente` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_producto` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `unidad_medida` char(4) COLLATE utf8_spanish_ci NOT NULL,
  `sku_madre` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `nombre_sku_madre` varchar(250) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_sku` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_ean` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_alt` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_local` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_categoria` int(10) NOT NULL,
  `id_subcategoria` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'P=producto S=servicio C=cuenta',
  `id_activofijo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `pmp` decimal(12,2) NOT NULL DEFAULT '0.00',
  `cpp` int(10) NOT NULL DEFAULT '0',
  `precio_referencial` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'Cuanto costaba al momento de hacer la nota de venta',
  `precio_venta` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'En cuanto se vendio (con descuentos individual aplicado)',
  `precio_final_venta` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'precio de venta con descuento lineal y global aplicado',
  `cantidad` int(10) NOT NULL DEFAULT '0',
  `cantidad_devuelta` int(10) NOT NULL DEFAULT '0' COMMENT 'cantidad de unidades devueltas por medio de una nota de credito',
  `subtotal` int(10) NOT NULL DEFAULT '0',
  `descuento_porc` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT 'porcentaje de descuento',
  `descuento_porc_global` decimal(5,2) NOT NULL DEFAULT '0.00',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0',
  `subtotal_neto` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal con descuento aplicado',
  `subtotal_final` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal con descuento lineal y global aplicado ( SOLO PARA COMISIONES - ESTE ES EL VALOR REAL DE VENTA )',
  `comision_porcentaje` decimal(5,2) NOT NULL DEFAULT '0.00',
  `comision_pesos` int(10) NOT NULL DEFAULT '0',
  `comision_porcentaje_extra` decimal(5,2) NOT NULL DEFAULT '0.00',
  `comision_pesos_extra` int(10) NOT NULL DEFAULT '0',
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_sucursal_venta` int(10) NOT NULL,
  `rut_vendedor` char(10) COLLATE utf8_spanish_ci NOT NULL,
  `sw_facturable` int(11) NOT NULL,
  `subtotal_costo` int(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `folio_factura` (`folio_factura`),
  KEY `id_activofijo` (`id_activofijo`),
  KEY `pmp` (`pmp`),
  KEY `id_proyecto` (`id_proyecto`),
  KEY `estado` (`estado`),
  KEY `mes_control` (`mes_control`,`ano_control`,`numero_control`),
  KEY `folio` (`folio`),
  KEY `id_bodega_despacho` (`id_bodega_despacho`),
  KEY `id_categoria` (`id_categoria`),
  KEY `id_subcategoria` (`id_subcategoria`),
  KEY `codigo_sku` (`codigo_sku`),
  KEY `codigo_ean` (`codigo_ean`),
  KEY `codigo_alt` (`codigo_alt`),
  KEY `codigo_local` (`codigo_local`),
  KEY `origen_factura` (`origen_factura`),
  KEY `orden_compra` (`orden_compra`),
  KEY `folio_notapedido` (`folio_notapedido`),
  KEY `sku_madre` (`sku_madre`),
  KEY `nombre_sku_madre` (`nombre_sku_madre`),
  KEY `codigo_producto` (`codigo_producto`),
  KEY `anulada` (`anulada`),
  KEY `sw_backup` (`sw_backup`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ventas_transbankdetalle`
--

LOCK TABLES `tbl_ventas_transbankdetalle` WRITE;
/*!40000 ALTER TABLE `tbl_ventas_transbankdetalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ventas_transbankdetalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ventasdetalle`
--

DROP TABLE IF EXISTS `tbl_ventasdetalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ventasdetalle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `sw_backup` int(1) NOT NULL,
  `sw_exento` int(1) NOT NULL,
  `id_bodega_despacho` int(10) NOT NULL,
  `folio` int(10) NOT NULL COMMENT 'corresponde al id del encabezado',
  `folio_factura` int(10) NOT NULL DEFAULT '0',
  `orden_compra` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `folio_notapedido` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `origen_factura` int(1) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'EP=EnProceso GR=grabada PR=Procesada AN=Anulada',
  `folio_guiadespacho` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `anulada` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT '0=no 1=si',
  `id_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'id de la factura indica cuando se puso listo al pedido en bodega',
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `ano_control` int(4) NOT NULL,
  `numero_control` int(10) NOT NULL,
  `tipo_factura` int(1) NOT NULL DEFAULT '0' COMMENT '0=factura normal 1=facturacion anticipada',
  `id_facturacion` int(10) NOT NULL DEFAULT '0' COMMENT 'Solo para ordenamientos de fecha',
  `id_item` int(10) NOT NULL DEFAULT '0',
  `id_vendedor` int(10) NOT NULL DEFAULT '0',
  `id_relacion` int(10) NOT NULL DEFAULT '0',
  `rut_cliente` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_producto` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `unidad_medida` char(4) COLLATE utf8_spanish_ci NOT NULL,
  `sku_madre` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `nombre_sku_madre` varchar(250) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_sku` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_ean` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_alt` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_local` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_categoria` int(10) NOT NULL,
  `id_subcategoria` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'P=producto S=servicio C=cuenta',
  `id_activofijo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `pmp` decimal(12,2) NOT NULL DEFAULT '0.00',
  `cpp` int(10) NOT NULL DEFAULT '0',
  `precio_referencial` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'Cuanto costaba al momento de hacer la nota de venta',
  `precio_venta` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'En cuanto se vendio (con descuentos individual aplicado)',
  `precio_final_venta` decimal(15,5) NOT NULL COMMENT 'precio de venta con descuento lineal y global aplicado',
  `cantidad` decimal(15,5) NOT NULL,
  `cantidad_devuelta` int(10) NOT NULL DEFAULT '0' COMMENT 'cantidad de unidades devueltas por medio de una nota de credito',
  `subtotal` decimal(12,2) NOT NULL DEFAULT '0.00',
  `descuento_porc` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT 'porcentaje de descuento',
  `descuento_porc_global` decimal(5,2) NOT NULL DEFAULT '0.00',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0',
  `subtotal_neto` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal con descuento aplicado',
  `subtotal_final` decimal(12,2) NOT NULL DEFAULT '0.00',
  `monto_impuesto_adicional` int(10) NOT NULL,
  `monto_impuesto_especifico` int(10) NOT NULL,
  `comision_porcentaje` decimal(5,2) NOT NULL DEFAULT '0.00',
  `comision_pesos` int(10) NOT NULL DEFAULT '0',
  `comision_porcentaje_extra` decimal(5,2) NOT NULL DEFAULT '0.00',
  `comision_pesos_extra` int(10) NOT NULL DEFAULT '0',
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `folio_factura` (`folio_factura`),
  KEY `id_activofijo` (`id_activofijo`),
  KEY `pmp` (`pmp`),
  KEY `id_proyecto` (`id_proyecto`),
  KEY `estado` (`estado`),
  KEY `mes_control` (`mes_control`,`ano_control`,`numero_control`),
  KEY `folio` (`folio`),
  KEY `id_bodega_despacho` (`id_bodega_despacho`),
  KEY `id_categoria` (`id_categoria`),
  KEY `id_subcategoria` (`id_subcategoria`),
  KEY `codigo_sku` (`codigo_sku`),
  KEY `codigo_ean` (`codigo_ean`),
  KEY `codigo_alt` (`codigo_alt`),
  KEY `codigo_local` (`codigo_local`),
  KEY `origen_factura` (`origen_factura`),
  KEY `orden_compra` (`orden_compra`),
  KEY `folio_notapedido` (`folio_notapedido`),
  KEY `sku_madre` (`sku_madre`),
  KEY `nombre_sku_madre` (`nombre_sku_madre`),
  KEY `codigo_producto` (`codigo_producto`),
  KEY `anulada` (`anulada`),
  KEY `sw_backup` (`sw_backup`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ventasdetalle`
--

LOCK TABLES `tbl_ventasdetalle` WRITE;
/*!40000 ALTER TABLE `tbl_ventasdetalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ventasdetalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ventasdetalle_credito`
--

DROP TABLE IF EXISTS `tbl_ventasdetalle_credito`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ventasdetalle_credito` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `sw_backup` int(1) NOT NULL,
  `sw_exento` int(1) NOT NULL,
  `id_bodega_despacho` int(10) NOT NULL,
  `folio` int(10) NOT NULL COMMENT 'corresponde al id del encabezado',
  `folio_factura` int(10) NOT NULL DEFAULT '0',
  `orden_compra` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `folio_notapedido` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `origen_factura` int(1) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'EP=EnProceso GR=grabada PR=Procesada AN=Anulada',
  `folio_guiadespacho` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `anulada` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT '0=no 1=si',
  `id_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'id de la factura indica cuando se puso listo al pedido en bodega',
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `ano_control` int(4) NOT NULL,
  `numero_control` int(10) NOT NULL,
  `tipo_factura` int(1) NOT NULL DEFAULT '0' COMMENT '0=factura normal 1=facturacion anticipada',
  `id_facturacion` int(10) NOT NULL DEFAULT '0' COMMENT 'Solo para ordenamientos de fecha',
  `id_item` int(10) NOT NULL DEFAULT '0',
  `id_vendedor` int(10) NOT NULL DEFAULT '0',
  `id_relacion` int(10) NOT NULL DEFAULT '0',
  `rut_cliente` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_producto` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `unidad_medida` char(4) COLLATE utf8_spanish_ci NOT NULL,
  `sku_madre` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `nombre_sku_madre` varchar(250) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_sku` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_ean` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_alt` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_local` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_categoria` int(10) NOT NULL,
  `id_subcategoria` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'P=producto S=servicio C=cuenta',
  `id_activofijo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `pmp` decimal(12,2) NOT NULL DEFAULT '0.00',
  `cpp` int(10) NOT NULL DEFAULT '0',
  `precio_referencial` decimal(15,5) NOT NULL DEFAULT '0.00000' COMMENT 'Cuanto costaba al momento de hacer la nota de venta',
  `precio_venta` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'En cuanto se vendio (con descuentos individual aplicado)',
  `precio_final_venta` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'precio de venta con descuento lineal y global aplicado',
  `cantidad` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `cantidad_devuelta` int(10) NOT NULL DEFAULT '0' COMMENT 'cantidad de unidades devueltas por medio de una nota de credito',
  `subtotal` int(10) NOT NULL DEFAULT '0',
  `descuento_porc` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT 'porcentaje de descuento',
  `descuento_porc_global` decimal(5,2) NOT NULL DEFAULT '0.00',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0',
  `subtotal_neto` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal con descuento aplicado',
  `subtotal_final` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal con descuento lineal y global aplicado ( SOLO PARA COMISIONES - ESTE ES EL VALOR REAL DE VENTA )',
  `monto_impuesto_adicional` int(10) NOT NULL,
  `monto_impuesto_especifico` int(10) NOT NULL,
  `comision_porcentaje` decimal(5,2) NOT NULL DEFAULT '0.00',
  `comision_pesos` int(10) NOT NULL DEFAULT '0',
  `comision_porcentaje_extra` decimal(5,2) NOT NULL DEFAULT '0.00',
  `comision_pesos_extra` int(10) NOT NULL DEFAULT '0',
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `folio_factura` (`folio_factura`),
  KEY `id_activofijo` (`id_activofijo`),
  KEY `pmp` (`pmp`),
  KEY `id_proyecto` (`id_proyecto`),
  KEY `estado` (`estado`),
  KEY `mes_control` (`mes_control`,`ano_control`,`numero_control`),
  KEY `folio` (`folio`),
  KEY `id_bodega_despacho` (`id_bodega_despacho`),
  KEY `id_categoria` (`id_categoria`),
  KEY `id_subcategoria` (`id_subcategoria`),
  KEY `codigo_sku` (`codigo_sku`),
  KEY `codigo_ean` (`codigo_ean`),
  KEY `codigo_alt` (`codigo_alt`),
  KEY `codigo_local` (`codigo_local`),
  KEY `origen_factura` (`origen_factura`),
  KEY `orden_compra` (`orden_compra`),
  KEY `folio_notapedido` (`folio_notapedido`),
  KEY `sku_madre` (`sku_madre`),
  KEY `nombre_sku_madre` (`nombre_sku_madre`),
  KEY `codigo_producto` (`codigo_producto`),
  KEY `anulada` (`anulada`),
  KEY `sw_backup` (`sw_backup`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ventasdetalle_credito`
--

LOCK TABLES `tbl_ventasdetalle_credito` WRITE;
/*!40000 ALTER TABLE `tbl_ventasdetalle_credito` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ventasdetalle_credito` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ventasdetalle_debito`
--

DROP TABLE IF EXISTS `tbl_ventasdetalle_debito`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_ventasdetalle_debito` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `sw_backup` int(1) NOT NULL,
  `sw_exento` int(1) NOT NULL,
  `id_bodega_despacho` int(10) NOT NULL,
  `folio` int(10) NOT NULL COMMENT 'corresponde al id del encabezado',
  `folio_factura` int(10) NOT NULL DEFAULT '0',
  `orden_compra` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `folio_notapedido` varchar(255) COLLATE utf8_spanish_ci NOT NULL,
  `origen_factura` int(1) NOT NULL,
  `estado` char(2) COLLATE utf8_spanish_ci NOT NULL COMMENT 'EP=EnProceso GR=grabada PR=Procesada AN=Anulada',
  `folio_guiadespacho` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `anulada` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT '0=no 1=si',
  `id_factura` int(10) NOT NULL DEFAULT '0' COMMENT 'id de la factura indica cuando se puso listo al pedido en bodega',
  `fecha_facturacion` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `mes_control` char(2) COLLATE utf8_spanish_ci NOT NULL,
  `ano_control` int(4) NOT NULL,
  `numero_control` int(10) NOT NULL,
  `tipo_factura` int(1) NOT NULL DEFAULT '0' COMMENT '0=factura normal 1=facturacion anticipada',
  `id_facturacion` int(10) NOT NULL DEFAULT '0' COMMENT 'Solo para ordenamientos de fecha',
  `id_item` int(10) NOT NULL DEFAULT '0',
  `id_vendedor` int(10) NOT NULL DEFAULT '0',
  `id_relacion` int(10) NOT NULL DEFAULT '0',
  `rut_cliente` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `codigo_producto` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `unidad_medida` char(4) COLLATE utf8_spanish_ci NOT NULL,
  `sku_madre` varchar(64) COLLATE utf8_spanish_ci NOT NULL,
  `nombre_sku_madre` varchar(250) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_sku` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_ean` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_alt` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `codigo_local` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_categoria` int(10) NOT NULL,
  `id_subcategoria` int(10) NOT NULL,
  `tipo_item` char(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT 'P=producto S=servicio C=cuenta',
  `id_activofijo` varchar(32) COLLATE utf8_spanish_ci NOT NULL,
  `id_proyecto` int(10) NOT NULL,
  `descripcion` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `pmp` decimal(12,2) NOT NULL DEFAULT '0.00',
  `cpp` int(10) NOT NULL DEFAULT '0',
  `precio_referencial` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'Cuanto costaba al momento de hacer la nota de venta',
  `precio_venta` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'En cuanto se vendio (con descuentos individual aplicado)',
  `precio_final_venta` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT 'precio de venta con descuento lineal y global aplicado',
  `cantidad` int(10) NOT NULL DEFAULT '0',
  `cantidad_devuelta` int(10) NOT NULL DEFAULT '0' COMMENT 'cantidad de unidades devueltas por medio de una nota de credito',
  `subtotal` int(10) NOT NULL DEFAULT '0',
  `descuento_porc` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT 'porcentaje de descuento',
  `descuento_porc_global` decimal(5,2) NOT NULL DEFAULT '0.00',
  `descuento_pesos` int(10) NOT NULL DEFAULT '0',
  `subtotal_neto` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal con descuento aplicado',
  `subtotal_final` int(10) NOT NULL DEFAULT '0' COMMENT 'subtotal con descuento lineal y global aplicado ( SOLO PARA COMISIONES - ESTE ES EL VALOR REAL DE VENTA )',
  `monto_impuesto_adicional` int(10) NOT NULL,
  `monto_impuesto_especifico` int(10) NOT NULL,
  `comision_porcentaje` decimal(5,2) NOT NULL DEFAULT '0.00',
  `comision_pesos` int(10) NOT NULL DEFAULT '0',
  `comision_porcentaje_extra` decimal(5,2) NOT NULL DEFAULT '0.00',
  `comision_pesos_extra` int(10) NOT NULL DEFAULT '0',
  `observaciones` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `folio_factura` (`folio_factura`),
  KEY `id_activofijo` (`id_activofijo`),
  KEY `pmp` (`pmp`),
  KEY `id_proyecto` (`id_proyecto`),
  KEY `estado` (`estado`),
  KEY `mes_control` (`mes_control`,`ano_control`,`numero_control`),
  KEY `folio` (`folio`),
  KEY `id_bodega_despacho` (`id_bodega_despacho`),
  KEY `id_categoria` (`id_categoria`),
  KEY `id_subcategoria` (`id_subcategoria`),
  KEY `codigo_sku` (`codigo_sku`),
  KEY `codigo_ean` (`codigo_ean`),
  KEY `codigo_alt` (`codigo_alt`),
  KEY `codigo_local` (`codigo_local`),
  KEY `origen_factura` (`origen_factura`),
  KEY `orden_compra` (`orden_compra`),
  KEY `folio_notapedido` (`folio_notapedido`),
  KEY `sku_madre` (`sku_madre`),
  KEY `nombre_sku_madre` (`nombre_sku_madre`),
  KEY `codigo_producto` (`codigo_producto`),
  KEY `anulada` (`anulada`),
  KEY `sw_backup` (`sw_backup`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ventasdetalle_debito`
--

LOCK TABLES `tbl_ventasdetalle_debito` WRITE;
/*!40000 ALTER TABLE `tbl_ventasdetalle_debito` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ventasdetalle_debito` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_version`
--

DROP TABLE IF EXISTS `tbl_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_version` (
  `id` int(10) NOT NULL,
  `numero_version` char(32) NOT NULL,
  `fecha` char(10) NOT NULL,
  `hora` char(8) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_version`
--

LOCK TABLES `tbl_version` WRITE;
/*!40000 ALTER TABLE `tbl_version` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_visitas`
--

DROP TABLE IF EXISTS `tbl_visitas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_visitas` (
  `id_visita` decimal(10,0) NOT NULL DEFAULT '0',
  `ip` varchar(15) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `res_x` decimal(4,0) NOT NULL DEFAULT '0',
  `res_y` decimal(4,0) NOT NULL DEFAULT '0',
  `nombre_navegador` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `info_navegador` varchar(250) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `sistema_op` varchar(100) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `id_sesion` varchar(32) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  `procedencia` varchar(255) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `id_sesion` (`id_sesion`),
  KEY `id` (`id_visita`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_visitas`
--

LOCK TABLES `tbl_visitas` WRITE;
/*!40000 ALTER TABLE `tbl_visitas` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_visitas` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-01-24 23:15:24
