<?php
/*
para calcular el impto especifico
http://www.sii.cl/preguntas_frecuentes/iva/001_030_6125.htm

A continuación se muestra un ejemplo numérico para efectuar dicho cálculo:

Ejemplo: Contribuyente recibe factura de fecha 31.03.2011, correspondiente a Guía de Despacho emitida el 19.03.2011,
por compra de 5.000 litros de petróleo Diesel, equivalentes a 5 m3, con el siguiente detalle:

Base Imponible IVA $ 2.200.668
19% $ 418.127
IEF Componente Base (Fijo) $ 283.455 ((1,5 UTM/m3) * 5 m3)       ____   IEF = (UTM * CBASE ) * M3COMB 
IEV Componente Variable $ -118.315 ((- 0,6261 UTM/m3) * 5 m3)
=========
TOTAL FACTURA $ 2.783.935

(UTM marzo 2011 = $37.794) 
*/





/* 

// params
$utm=37794;
$cbase=1.5;
$cvariable=0.6261;
$tasaiva=1.19;


// datos venta
$m3=5; // cantidad m3
$totalbruto=2783935;


// calculos
$ief=(($utm*$cbase)*$m3);
$iev=($cvariable*$utm)*$m3;
$mntimpto=$ief-$iev;
$brutin=$totalbruto-$mntimpto;
$neto=round($brutin/$tasaiva);
$iva=$brutin-$neto;

// depurar
echo "<br>ief=".number_format($ief,2,",",".");
echo "<br>iev=".number_format($iev,2,",",".");
echo "<br>mntimpto=".number_format($mntimpto,2,",",".");
echo "<br>neto=".number_format($neto,0,",",".");
echo "<br>iva=".number_format($iva,0,",",".");
echo "<br>total=".number_format($totalbruto,0,",",".");
 */


function CalcularImpuestoEspecifico($tipocomb,$cantidad_litros,$total_bruto){

	// obtener la cantidad de m3 a partir de la cantidad de litros
	$m3=$cantidad_litros/1000;
	//echo "<br>m3=$m3";
	// params
	$utm=37794;
	$cbase=1.5;
	$cvariable=0.6261;
	$tasaiva=1.19;

	// calculos para determinar impuesto especifico
	$ief=(($utm*$cbase)*$m3);
	//echo "<br>ief=$ief";
	$iev=($cvariable*$utm)*$m3;
	//echo "<br>iev=$iev";
	$mntimpto=round($ief-$iev);
	
	
	// calculos finales
	$brutin=round($total_bruto-$mntimpto);
	
	// calcular neto
	 $neto=round(($brutin/$tasaiva));
	
	// calcular neto formula juan pablo corona
	// ((precio venta guía – impuesto específico) / 1.19)
	//$neto=(($total_bruto-$mntimpto)/1.19);
	
	// calcular iva
	$iva=round($brutin-$neto);
	
	// depurar
	echo "<br>neto=$neto";
	echo "<br>iva=$iva";
	echo "<br>brutin=$brutin";
	echo "<br>mntimpto=$mntimpto";
	echo "<br>total_bruto=$total_bruto";
	
	global $neto;
	global $iva;
	global $mntimpto;
	
}


//-------------------------------------------------------


$tipocomb=4;
$cantidad_litros=5000;
$total_bruto=2783935;

CalcularImpuestoEspecifico($tipocomb,$cantidad_litros,$total_bruto);


/*
echo "<hr>";
echo "<br>mntimpto=".number_format($mntimpto,2,",",".");
echo "<br>neto=".number_format($neto,0,",",".");
echo "<br>iva=".number_format($iva,0,",",".");
echo "<br>total=".number_format($totalbruto,0,",",".");
*/
?>