var $cargando = "<div class=\"modal-body\">\
         	<div class=\"progress\"> \
                    <div class=\"progress-bar progress-bar-warning progress-bar-striped active\" role=\"progressbar\" aria-valuenow=\"100\" aria-valuemin=\"0\" aria-valuemax=\"100\" style=\"width: 100%\">\
                        <span class=\"sr-only\">100% Complete</span> \
                    </div> \
                  </div>\
                </div>";
var $tablaSucursal;
var datos = {};
var fEmpresa = document.getElementById("form-cliente");
for(var i = 0; i < fEmpresa.elements.length; i++){
	campo = fEmpresa.elements[i];
	if(campo.name !== ""){
		datos[campo.name] = campo.value
	}
}

function validarFormatoRut(){
 	rut = document.getElementById('rut').value.replace('.','').replace('-','');
 	if(rut.length>1){
 		rut_final = rut.slice(0,rut.length-2)+'-'+rut.slice(rut.lenght-2);
 	}
 	document.getElementById('rut').value = rut_final ;

 }	

function relocate(page,params){
	  var body = document.body;
	  form=document.createElement('form'); 
	  form.method = 'POST'; 
	  form.action = page;
	  form.name = 'jsform';
	  form.target='_blank';
	  for (index in params)
	  {
			var input = document.createElement('input');
			input.type='hidden';
			input.name=index;
			input.id=index;
			input.value=params[index];
			form.appendChild(input);
	  }	  		  			  
	  body.appendChild(form);
	  form.submit();
}

function setDatos(){
	var f = document.getElementById("form-sucursal");
	for(var i = 0; i < f.elements.length; i++){
		campo = f.elements[i];
		if(campo.name !== ""){
			datos[campo.name] = campo.value
		}
	}
	datos.comuna = $('#form-sucursal #id_comuna option:selected').text();
	
	return true;
}

function guardarSucursal(){
	setDatos();
	
	$.ajax({
		method : "POST",
		url : "librerias/sucursal.php",
		data : datos,
		dataType : 'json',
		success : function(e) {
			if(e.datos === "ok" && e.total == 1){
				$('#md-sucursal').modal('hide');
				buscarSucursales();
			}
			else if(e.datos === "ok" && e.total == 0){
				alert('El código ingresado ya existe');
				$('input#codigo').focus();
			}
			
			if(e.datos == "error"){
				alert("Ha ocurrido un error al guardar");
			}
		}
	});
}

function eliminarSucursal(id){

	datos.accion = "eliminar"
	datos.id = id;
	
	$.ajax({
		method : "POST",
		url : "librerias/sucursal.php",
		data : datos,
		dataType : 'json',
		success : function(e) {
			if(e.datos === "ok" && e.total == 1){
				buscarSucursales();
			}
			
			if(e.datos == "error"){
				alert("Ha ocurrido un error al eliminar");
			}
		}
	});
}

function buscarSucursales(){
	datos.accion = "buscar";
	$.ajax({
		method : "POST",
		url : "librerias/sucursal.php",
		data : datos,
		dataType : 'json',
		beforeSend: function(){
			if(typeof $tablaSucursal !== "undefined"){
				$tablaSucursal.destroy();
			}
		},
		success : function(e) {
			s = e.datos;
			$tablaSucursal = $("#dt-sucursales").DataTable({
				data : s,
				columns : [
					{
						data : 'accion_html'
					}
					, {
						data : 'codigo'
					}
					, {
						data : 'sucursal_html'
					}
					, {
						data : 'contacto_html'
					}
					, {
						data : 'giro'
					}
				],
			});
		}
		
	});
}

document.addEventListener("DOMContentLoaded", function(event) {
	
	//modal
	$("#md-sucursal").on('shown.bs.modal', function(event){
		var button = $(event.relatedTarget);
		var sucursalId = button.data('sucursal-id');
		var accion = button.data('accion');
		var modal = $(this);
		$.ajax( {
			method: "GET",
			url: "vistas/ficha_sucursal.php",
			data: {
				id: sucursalId
				, accion: accion
			},
			success: function(resp){
				modal.find('.modal-content').html(resp);
			}
		});
	});

	$("#md-sucursal").on('hidden.bs.modal', function(event){
		$(this).find('.modal-content').html($cargando);
	});

	$('#tab-opciones a').click(function (e) {
		e.preventDefault()
		$(this).tab('show')
		if($(this).data('nombre') == "sucursales" && typeof $tablaSucursal === "undefined"){
			buscarSucursales();
		}
	})
});