<?php

// Función para obtener el resumen de la asistencia segun empleado y periodo.
function ResumenVentas($fecha_inicio, $fecha_termino)
{
    global $link_sistema;
    global $bd_sistema;
    global $ventas;
    
    $select = [];
    // facturas
  
    $select[] = "SELECT vd.folio_factura, vd.descripcion, vd.id_vendedor, vd.fecha_facturacion, vd.cantidad, vd.subtotal_final, vd.estado
FROM tbl_ventasdetalle AS vd";
 

    // notas de venta
    
    
    $select[] = "SELECT npd.folio folio_factura, npd.descripcion, np.id_vendedor, np.fecha_solicitud fecha_facturacion, npd.cantidad, npd.subtotal subtotal_final, np.estado 
FROM tbl_notaspedido AS np 
JOIN tbl_notaspedido_detalle AS npd ON np.folio = npd.folio";

    
    // boletas
    $select[] = "SELECT vbd.folio_factura, vbd.descripcion, vb.id_vendedor, vb.fecha_facturacion , vbd.cantidad, vbd.subtotal_final, vb.estado 
FROM tbl_ventas_boleta AS vb 
JOIN tbl_ventas_boletadetalle AS vbd ON vb.id = vbd.folio";
    
    // transbank
    $select[] = "SELECT vtd.folio folio_factura, vtd.descripcion, vt.id_vendedor, vt.fecha_facturacion, vtd.cantidad, vtd.subtotal_final, vt.estado 
FROM tbl_ventas_transbank AS vt 
JOIN tbl_ventas_transbankdetalle AS vtd ON vt.id = vtd.folio";
    
    // ventas debito
    $select[] = "SELECT vdd.folio_factura, vdd.descripcion, vd.id_vendedor, vd.fecha_facturacion, vdd.cantidad, vdd.subtotal_final, vd.estado 
FROM tbl_ventas_debito AS vd 
JOIN tbl_ventasdetalle_debito AS vdd ON vd.id = vdd.folio";

 
    
    // empleados
    $sql = "SELECT e.id_empleado, e.codigo_empleado, e.nombres, e.paterno, e.materno, sum( ventas.cantidad ) cantidad, sum( ventas.subtotal_final ) subtotal_final 
FROM tbl_empleados AS e 
RIGHT JOIN (";
    
    $n = count($select);
    foreach ($select as $s) {
        $sql .= $s;
        if ($n > 1) {
            $sql .= " UNION " . PHP_EOL;
        }
        $n --;
    }
    
    $sql .= ") as ventas ON e.id_empleado = ventas.id_vendedor 
WHERE STR_TO_DATE( ventas.fecha_facturacion, '%d/%m/%Y' ) 
BETWEEN '{$fecha_inicio}' 
AND '{$fecha_termino}' 
AND ventas.estado = 'PR' 
GROUP BY id_empleado";
    
    $ventas = [
        'cantidad' => 0,
        'subtotal' => 0,
        'ventas' => null,
        'n' => 0,
        'sql' => [
            $sql
        ]
    ];
    
    $v = [];
    
    $rsl = EjecutarSql($sql);
    while ($row = ListarSql($rsl)) {
        //
        $id = $row["id_empleado"] != null ? utf8_encode($row["id_empleado"]) : 'null';
        $v[$id]['id_empleado'] = $id;
        $v[$id]['codigo_empleado'] = trim(utf8_encode($row["codigo_empleado"]));
        $v[$id]['nombre_empleado'] = trim(utf8_encode($row["nombres"] . " " . $row["paterno"] . " " . $row["materno"]));
        $v[$id]['cantidad'] = (float) $row["cantidad"];
        $v[$id]['subtotal_final'] = (float) $row["subtotal_final"];
        //
        $v[$id]["n"] = $ventas['n'] + 1;
        //
        $ventas['cantidad'] += $v[$id]['cantidad'];
        $ventas['subtotal'] += $v[$id]['subtotal_final'];
        //
        $ventas['n'] ++;
    }
    
    // 
    $sql = "SELECT e.id_empleado, e.codigo_empleado, e.nombres, e.paterno, e.materno, sum( vcd.cantidad ) cantidad, sum( vcd.subtotal_final ) subtotal_final 
FROM tbl_empleados AS e 
RIGHT JOIN tbl_ventas_credito AS vc ON e.id_empleado = vc.id_vendedor 
RIGHT JOIN tbl_ventasdetalle_credito AS vcd ON vc.id = vcd.folio 
WHERE STR_TO_DATE( vc.fecha_facturacion, '%d/%m/%Y' ) 
BETWEEN '{$fecha_inicio}' 
AND '{$fecha_termino}' 
GROUP BY id_empleado";
    
    array_push($ventas['sql'], $sql);
    $rsl = EjecutarSql($sql);
    while ($row = ListarSql($rsl)) {
        $id = $row["id_empleado"] != null ? utf8_encode($row["id_empleado"]) : 'null';
        if (array_key_exists($id, $v)) {
            $v[$id]['cantidad'] -= (float) $row["cantidad"];
            $v[$id]['subtotal_final'] -= (float) $row["subtotal_final"];
        } else {
            $v[$id]['id_empleado'] = $id;
            $v[$id]['codigo_empleado'] = trim(utf8_encode($row["codigo_empleado"]));
            $v[$id]['nombre_empleado'] = trim(utf8_encode($row["nombres"] . " " . $row["paterno"] . " " . $row["materno"]));
            $v[$id]['cantidad'] = (float) $row["cantidad"] * - 1.0;
            $v[$id]['subtotal_final'] = (float) $row["subtotal_final"] * - 1.0;
            //
            $v[$id]['n'] = $ventas['n'] + 1;
            $ventas['n'] ++;
        }
        
        //
        $ventas['cantidad'] -= (float) $row["cantidad"];
        $ventas['subtotal'] -= (float) $row["subtotal_final"];
    }
    
    $ventas['ventas'] = $v;
    
    $rsl = null;
    
    return $ventas;
}
?>
