var datos = {
	fecha_inicio : null,
	fecha_termino : null
};

var grafico;

function setGrafico(g) {
	grafico = g;
}

function setDatos() {
	f = document.getElementById("form-ranking-productos");
	fecha_inicio = f.fecha_inicio.value != "" ? f.fecha_inicio.value : null;
	fecha_termino = f.fecha_termino.value != "" ? f.fecha_termino.value : null;

	if (fecha_inicio == null || fecha_termino == null) {
		alert('Debe indicar un intervalo de fecha');
		return false;
	}

	datos = {
		fecha_inicio : fecha_inicio,
		fecha_termino : fecha_termino
	};
	return true;
}

function exportar(){
	if (!setDatos()) {
		return false;
	}
	datos.exportar = 1;

	var win = window.open("imprimir.php?exportar=" + datos.exportar
	+ "&fecha_inicio=" + datos.fecha_inicio
	+ "&fecha_termino=" + datos.fecha_termino
		, "_blank");
}

function imprimir() {
	if (!setDatos()) {
		return false;
	}

	imagen = grafico.exportChart({
		format : "png",
		toDataURL : true,
		fileName : 'grafico.png'
	});
	
	datos.imprimir = "imprimir";

	var win = window.open("imprimir.php?imprimir=" + datos.imprimir
	+ "&fecha_inicio=" + datos.fecha_inicio
	+ "&fecha_termino=" + datos.fecha_termino
		, "_blank");
	
	win.window.onload = function() {
		imgContainer = win.document.getElementById("grafico-top-productos");
		imgContainer.setAttribute('src', imagen);
		this.setTimeout(function(){
			this.print();
			this.close();			
		}, 1000);
	}
}

function cargaGrafico() {
	datos.accion = "top-productos";
	$.ajax({
		method : "POST",
		url : "librerias/ajax.php",
		data : datos,
		dataType : 'json',
		success : function(e) {
			var d = e.datos;
			var chart = new CanvasJS.Chart("productos-chart",
				{
					title : {
						text : "Productos más vendidos"
					},
					animationEnabled : true,
					axisY : {
						title : "Cantidad"
					},
					legend : {
						verticalAlign : "bottom",
						horizontalAlign : "center"
					},
					theme : "theme2",
					data : [
						{
							type : "column",
							dataPoints : d
						}
					]
				});
			chart.render();
			setGrafico(chart);
		}
	});
}

function cargaTabla() {
	datos.accion = "buscar";
	$.ajax({
		method : "POST",
		url : "librerias/ajax.php",
		data : datos,
		dataType : 'json',
		beforeSend : function() {
			$("#dataTables-example").DataTable().destroy();
		},
		success : function(e) {
			console.log(e);
			console.log(e.datos);
			var d = e.datos;
			$("#dataTables-example").DataTable({
				data : d,
				columns : [
					{
						data : 'n'
					}
					, {
						data : 'nombre_producto'
					}
					, {
						data : 'cantidad'
					}
					, {
						data : 'subtotal',
						render : $.fn.dataTable.render.number('.', ',', 0, '$ ')
					}
					, {
						data : 'costo',
						render : $.fn.dataTable.render.number('.', ',', 0, '$ ')
					}
					, {
						data : 'utilidad',
						render : $.fn.dataTable.render.number('.', ',', 0, '$ ')
					}
				 
					 
					, {
						data : undefined,
						"defaultContent" : " "
					}
					 
				],
				searching : false,
				scrollX : 400,
				order : [ [ 2, 'desc' ] ],
				responsive : true,
				"footerCallback" : function(row, data, start, end, display) {

					var api = this.api(),
						data;

					// Remove the formatting to get integer data for summation
					var intVal = function(i) {
						return typeof i === 'string' ?
							i.replace(/[\$\.]/g, '') * 1 :
							typeof i === 'number' ?
								i : 0;
					};

					// Total over all pages
					cantidad_total = api.column(2).data().reduce(function(a, b) {
						return intVal(a) + intVal(b);
					}, 0);

					subtotal_total = api.column(3).data().reduce(function(a, b) {
						return intVal(a) + intVal(b);
					}, 0);

					costo_total = api.column(4).data().reduce(function(a, b) {
						return intVal(a) + intVal(b);
					}, 0);

					utilidad_total = api.column(5).data().reduce(function(a, b) {
						return intVal(a) + intVal(b);
					}, 0);

					var numFormat = $.fn.dataTable.render.number('.', ',', 0, '$ ').display;

					// Update footer
					$(api.column(1).footer()).html("TOTAL");
					$(api.column(2).footer()).html(cantidad_total);

					$(api.column(3).footer()).html(
						numFormat(subtotal_total)
					);
					$(api.column(4).footer()).html(
						numFormat(costo_total)
					);
					$(api.column(5).footer()).html(
						numFormat(utilidad_total)
					);

					$(api.column(6).footer()).html('100%');

					// calcula columna porcentaje
					table = $("#dataTables-example").DataTable();
					table.rows().every(function(rowIndx, tableLoop, rowLoop) {
						var d = this.data();
						
						d[6] = (d["costo"] / subtotal_total * 100).toFixed(2) + "%";
						this.data(d);
					});
					this.data().draw;
				}
			});
		}
	});
}

function buscar() {
	if (!setDatos()) {
		return false;
	}
	$('.mostrar').show();
	cargaGrafico();
	cargaTabla();
}

document.addEventListener("DOMContentLoaded", function(event) {
	$('.form_date').datetimepicker({
		language : 'es',
		weekStart : 1,
		todayBtn : 1,
		autoclose : 1,
		todayHighlight : 1,
		startView : 2,
		minView : 2,
		forceParse : 0
	});
});