<?php
# Función para obtener el resumen de la asistencia segun empleado y periodo.
function RankingProductos($fecha_inicio, $fecha_termino){
	
	global $link_sistema;
	global $bd_sistema;
	global $ranking;
	
	$select = [];
	//facturas
	$select[] = "SELECT vd.id_item, vd.fecha_facturacion, vd.cantidad, vd.subtotal_final, vd.cpp 
FROM tbl_ventasdetalle AS vd";
	
	//notas de venta
	$select[] = "SELECT npd.id_item, np.fecha_solicitud fecha_facturacion, npd.cantidad, npd.subtotal subtotal_final, 0 as cpp 
FROM tbl_notaspedido AS np 
JOIN tbl_notaspedido_detalle AS npd ON np.folio = npd.folio";
	
	// boletas
	$select[] = "SELECT vbd.id_item, vb.fecha_facturacion , vbd.cantidad, vbd.subtotal_final, vbd.cpp 
FROM tbl_ventas_boleta AS vb 
JOIN tbl_ventas_boletadetalle AS vbd ON vb.id = vbd.folio";
	
	//transbank
	$select[] = "SELECT vtd.id_item, vt.fecha_facturacion, vtd.cantidad, vtd.subtotal_final, vtd.cpp 
FROM tbl_ventas_transbank AS vt 
JOIN tbl_ventas_transbankdetalle AS vtd ON vt.id = vtd.folio";
	
	//ventas debito
	$select[] = "SELECT vdd.id_item, vd.fecha_facturacion, vdd.cantidad, vdd.subtotal_final, vdd.cpp 
FROM tbl_ventas_debito AS vd 
JOIN tbl_ventasdetalle_debito AS vdd ON vd.id = vdd.folio";
	
	$sql = "SELECT p.id_producto, p.nombre as nombre_producto, sum( ventas.cantidad ) cantidad, sum( ventas.subtotal_final ) subtotal_final, sum(ventas.cpp) cpp 
FROM tbl_productos AS p 
JOIN (";
	
	$n = count($select);
	foreach ($select as $s){
	    $sql .= $s;
	    if($n > 1){
	        $sql .= " UNION ".PHP_EOL;
	    }
	    $n--;
	}
	
	$sql .= ") as ventas ON p.id_producto = ventas.id_item 
WHERE STR_TO_DATE( ventas.fecha_facturacion, '%d/%m/%Y' ) 
BETWEEN '{$fecha_inicio}' 
AND '{$fecha_termino}' 
GROUP BY nombre_producto";
	
	$ranking = [
	    'cantidad' => 0
	    , 'subtotal' => 0
	    , 'costo' => 0
	    , 'utilidad' => 0
	    , 'productos' => null
	    , 'n' => 0
	    , 'sql' => [$sql]
	];
	
	$p = [];
	
	$rsl = EjecutarSql($sql);
	while($row = ListarSql($rsl)) {
	    #
	    $id = utf8_encode($row["id_producto"]);
	    $p[$id]['id_producto'] = $id;
	    $p[$id]['nombre_producto'] = trim(utf8_encode($row["nombre_producto"]));
	    $p[$id]['cantidad'] = (float) $row["cantidad"];
	    $p[$id]['subtotal_final'] = (float) $row["subtotal_final"];
	     
	    //Sugeto a revision dado desconocido el valor de costo o cpp
	    //$p[$id]['costo'] = (float) $row["cpp"];
	    $p[$id]['costo'] = $p[$id]['subtotal_final'] - ($p[$id]['subtotal_final'] * 0.7);
	    
	    $p[$id]['utilidad'] = $p[$id]['subtotal_final'] - $p[$id]['costo'];
	    #
	    $p[$id]["n"] = $ranking['n']+1;
	    #
	    $ranking['cantidad'] += $p[$id]['cantidad'];
	    $ranking['subtotal'] += $p[$id]['subtotal_final'];
	    $ranking['costo'] += $p[$id]['costo'];
	    $ranking['utilidad'] += $p[$id]['utilidad'];
	    #
	    $ranking['n']++;
	}
	
	//ventas credito
	$sql = "SELECT p.id_producto, p.nombre as nombre_producto, sum( vcd.cantidad ) cantidad, sum( vcd.subtotal_final ) subtotal_final, sum(vcd.cpp) cpp 
FROM tbl_productos AS p 
JOIN tbl_ventasdetalle_credito AS vcd ON p.id_producto = vcd.id_item 
JOIN tbl_ventas_credito AS vc ON vc.id = vcd.folio 
WHERE STR_TO_DATE( vc.fecha_facturacion, '%d/%m/%Y' ) 
BETWEEN '{$fecha_inicio}' 
AND '{$fecha_termino}' 
GROUP BY nombre_producto";
	array_push($ranking['sql'], $sql);
	$rsl = EjecutarSql($sql);
	while($row = ListarSql($rsl)) {
	    $id = utf8_encode($row["id_producto"]);
	    
	    if(array_key_exists($id, $p)){
	        $p[$id]['cantidad'] -= (float) $row["cantidad"];
	        $p[$id]['subtotal_final'] -= (float) $row["subtotal_final"];
	        $p[$id]['costo'] -= (float) $row["cpp"];
	        $p[$id]['utilidad'] -= (float) $row["subtotal_final"] - (float) $row["cpp"];
	    }
	    else {
	        $p[$id]['id_producto'] = $id;
	        $p[$id]['nombre_producto'] = trim(utf8_encode($row["nombre_producto"]));
	        $p[$id]['cantidad'] = (float) $row["cantidad"] * -1.0;
	        $p[$id]['subtotal_final'] = (float) $row["subtotal_final"] * -1.0;
	        $p[$id]['costo'] = (float) $row["cpp"] * -1.0;
	        //se invierten los valores dado que son numeros negativos
	        $p[$id]['utilidad'] = $p[$id]['costo'] - $p[$id]['subtotal_final'];
	        #
	        $p[$id]['n'] = $ranking['n']+1;
	        $ranking['n']++;
	    }
	    
	    #
	    $ranking['cantidad'] -= (float) $row["cantidad"];
	    $ranking['subtotal'] -= (float) $row["subtotal_final"];
	    $ranking['costo'] -= (float) $row["cpp"];
	    $ranking['utilidad'] -= $p[$id]['utilidad'];
	}
	
	$ranking['productos'] = $p;
	
	$rsl = null;
	
	return $ranking;
}
?>