<?php
/* Change to the correct path if you copy this example! */
require __DIR__ . '/../../autoload.php';
use Mike42\Escpos\Printer;
use Mike42\Escpos\PrintConnectors\NetworkPrintConnector;

/* Most printers are open on port 9100, so you just need to know the IP 
 * address of your receipt printer, and then fsockopen() it on that port.
 */
try {
    $connector = new NetworkPrintConnector("192.168.192.7", 9100);
    
    /* Print a "Hello world" receipt" */
    $printer = new Printer($connector);
    $printer -> text("Hello World!\n");
    $printer -> text("Hello World!\n");
    $printer -> text("Hello World!\n");
    $printer -> text("Hello World!\n");
    $printer -> text("Hello World!\n");
    $printer -> text("Hello World!\n");
    $printer -> text("Hello World!\n");
    $printer -> text("Hello World!\n");
    $printer -> text("Hello World!\n");
    $printer -> text("Hello World!\n");
    $printer -> text("Hello World!\n");
    $printer -> text("Hello World!\n");
    $printer -> text("Hello World!\n");
    $printer -> text("Hello World!\n");   
    
	// Most simple example
	//title($printer, "PDF417 code demo\n");
	$testStr = "Testing 123aij ijfiaj sifjaiosjfioajsfiojou8u	90c03 09j0cjd0 a0s9j f09as jf09a F0AJ09Fja0JF AJFI JAISFjIOSFJIMAFM90ASFM90iA9F90ASICMAmcu90u	m309c2um3	9cr02u39m	cu2903umc092um390c	um2390umc0923um9cud23m90cum9203umdc923umceuumcqweumq809w4uf80q4u8wemq8vumnwe8urmv8weumrv8weum8rmvuwe89umrv8qwe";
	$printer -> pdf417Code($testStr);
	$printer -> text("Most simple example\n");
	$printer -> feed();    
    
    $printer -> cut();
    
    /* Close printer */
    $printer -> close();
} catch (Exception $e) {
    echo "Couldn't print to this printer: " . $e -> getMessage() . "\n";
}
