<?php
# pre
include("../librerias/php/header.php");
# mostrar errores
ini_set('display_errors',1);
# solo advertencias
error_reporting(E_WARNING);
# Funcion para calcular el resumen (Digest) de un archivo
function ObtenerDigestion($url_archivo)    {
	// Crear Objeto Xml
    $doc = new DOMDocument();
	// Preservar los espacios tabulaciones, etc...
	$doc->preserveWhiteSpace = true; 
	// Carga archivo en el objeto
	$doc->load($url_archivo);
	//  Embeber
    $dom = $doc->documentElement;
 	// Calcular Digestion
	$digestion = base64_encode(sha1($dom->C14N(), true));
 	// Retornar Valor Calculado
	return $digestion;
}

# run
$Documento='ecuador_porfirmar';
# Calcular la digestion del archivo
echo "Digesta Ecuatoriana=".$digesta=ObtenerDigestion($url_archivo="temp/".$Documento.".xml");
exit;
# plantilla bendita para firmar la digesta
$firmador='<SignedInfo xmlns="http://www.w3.org/2000/09/xmldsig#"><CanonicalizationMethod Algorithm="http://www.w3.org/TR/2001/REC-xml-c14n-20010315"></CanonicalizationMethod><SignatureMethod Algorithm="http://www.w3.org/2000/09/xmldsig#rsa-sha1"></SignatureMethod><Reference URI="#'.$Documento.'"><Transforms><Transform Algorithm="http://www.w3.org/2000/09/xmldsig#enveloped-signature"></Transform></Transforms><DigestMethod Algorithm="http://www.w3.org/2000/09/xmldsig#sha1"></DigestMethod><DigestValue>'.$digesta.'</DigestValue></Reference></SignedInfo>';
# guardar la plantilla signature con la digesta del documento
$archivo=fopen("temp/digestador.xml","w") or die("ERROR AL CREAR");
fputs($archivo,$firmador);
fclose($archivo);




# obtener la firma binaria del archivo signature con la digesta
exec('openssl dgst -sha1 -sign certificados/privkey_sinpass.txt -out temp/firmado.bin temp/digestador.xml');
//exec('openssl dgst -sha1 -sign ../../home/139352238/almacen/privkey_idiaz_sinpass.txt -out temp/firmado.bin temp/digestador.xml');
# pasar la firma binaria del docto a base64
exec("openssl enc -base64 -in temp/firmado.bin -out temp/firma_documento.txt"); 
# leer la firma obtenida
$archivo_abrir=fopen("temp/firma_documento.txt","r");
$SignatureValueDocumento=fread($archivo_abrir, filesize("temp/firma_documento.txt"));
fclose($archivo_abrir);
# armar el signature con la digesta y con 
$signature_docto='<Signature xmlns="http://www.w3.org/2000/09/xmldsig#"><SignedInfo><CanonicalizationMethod Algorithm="http://www.w3.org/TR/2001/REC-xml-c14n-20010315"/><SignatureMethod Algorithm="http://www.w3.org/2000/09/xmldsig#rsa-sha1"/><Reference URI="#'.$Documento.'"><Transforms><Transform Algorithm="http://www.w3.org/2000/09/xmldsig#enveloped-signature"/></Transforms><DigestMethod Algorithm="http://www.w3.org/2000/09/xmldsig#sha1"/><DigestValue>'.$digesta.'</DigestValue></Reference></SignedInfo><SignatureValue>'.$SignatureValueDocumento.'</SignatureValue><KeyInfo><KeyValue>
<RSAKeyValue><Modulus>'.$CertificadoModulus.'</Modulus><Exponent>'.$CertificadoExponent.'</Exponent></RSAKeyValue></KeyValue><X509Data><X509Certificate>'.$CertificadoX509Certificate.'</X509Certificate></X509Data></KeyInfo></Signature>';
# DOCUMENTO FIRMADO
$setdte='<?xml version="1.0" encoding="ISO-8859-1"?>
'.$dte_cabeza.'
'.$doc_cabeza.$doc_detalle.'
'.$doc_timbre.'
'.$doc_pie.$signature_docto.$dte_pie;
# guardar el elemento set para calcular su digesta
$archivo=fopen('temp/'.$Documento.'_firmado.xml',"w") or die("ERROR AL CREAR");
fputs($archivo,$setdte);
fclose($archivo);


?>