var $tabla;

var rendicion = {
	id: null,
	fecha: null,
	concepto: null,
	total_solicitado: null,
	id_empleado: null
}

var detalle = {
	id: null,
	id_rendicion: null,
	id_gasto: null,
	descripcion: null,
	monto: 0
}

function setRendicion(soloId = false) {
	var f = document.getElementById("form_rendicion");
	rendicion.id = f.id_rendicion.value != "" ? f.id_rendicion.value : null;

	if(soloId) return true;

	var msg = "";

	if (!f.id_empleado.checkValidity()) {
		msg = msg + "Favor seleccione trabajador!\n";
	}

	if (!f.fecha.checkValidity()) {
		msg = msg + "Favor indique fecha!\n";
	}

	if (!f.total_solicitado.checkValidity()) {
		msg = msg + "Favor indique monto solicitado!\n";
	}

	if (!f.concepto.checkValidity()) {
		msg = msg + "Favor indique concepto!\n";
	}

	if (msg != "") {
		alert(msg);
		return false;
	}

	rendicion.fecha = f.fecha.value != "" ? f.fecha.value : null;
	rendicion.concepto = f.concepto.value != "" ? f.concepto.value : null;
	rendicion.total_solicitado = f.total_solicitado.value != "" ? f.total_solicitado.value : null;
	rendicion.id_empleado = f.id_empleado.value != "" ? f.id_empleado.value : null;

	return true;
}

function setDetalle() {
	setRendicion(true);

	var f = document.getElementById("form_rendicion_detalle");

	var msg = "";

	if (!f.id_gasto.checkValidity()) {
		msg = msg + "Favor seleccione gasto\n";
	}
	if (!f.descripcion.checkValidity()) {
		msg = msg + "Favor indique descripcion\n";
	}
	if (!f.monto.checkValidity()) {
		msg = msg + "Favor indique monto\n";
	}

	if (msg != "") {
		alert(msg);
		return false;
	}

	detalle.id_rendicion = rendicion.id;

	detalle.id = f.id_detalle.value != "" ? f.id_detalle.value : null;
	detalle.id_gasto = f.id_gasto.value != "" ? f.id_gasto.value : null;
	detalle.descripcion = f.descripcion.value != "" ? f.descripcion.value : null;
	detalle.monto = f.monto.value != "" ? f.monto.value : null;

	return true;
}

function guardar() {
	if (!setRendicion()) {
		return false;
	}

	rendicion.accion = "guardar";

	$.ajax({
		method: "POST",
		url: "librerias/ajax.php",
		data: rendicion,
		dataType: 'json',
		success: function (e) {
			if (e.total == 1) {
				location.href = "index.php?accion=ver&id="+rendicion.id;
			}
			else {
				alert("Error al guardar");
				console.log(e.datos);
			}
		}
	});

	return true;
}

function cancelar(){
	setRendicion(true);
	var confirmar = confirm("Esta seguro?")
	if (confirmar){
		location.href='index.php?accion=eliminar&id='+rendicion.id;
    } 
}

function agregarDetalle() {
	if (!setDetalle()) {
		return false;
	}

	detalle.accion = "agregarDetalle";
	if(typeof detalle.id != 'undefined' && detalle.id != "null" && detalle.id != ""){
		removerDetalle(detalle.id);
	}

	$.ajax({
		method: "POST",
		url: "librerias/ajax.php",
		data: detalle,
		dataType: 'json',
		success: function (e) {
			if (e.total == 1) {
				detalle = e.detalle;
				insertarDetalle();
				resetDetalle();
			}
			else {
				alert("Error al agregar");
				console.log(e.datos);
			}
		}
	});

	return true;
}

function quitarDetalle(id) {
	var datos = {
		accion: "quitarDetalle",
		id_detalle: id,
		id_rendicion: rendicion.id
	}

	$.ajax({
		method: "POST",
		url: "librerias/ajax.php",
		data: datos,
		dataType: 'json',
		success: function (e) {
			if (e.total == 1) {
				removerDetalle(id);
			}
			else {
				alert("Error al quitar");
				console.log(e.datos);
			}
		}
	});

	return true;
}

function buscarFila(id) {
	var filas = $tabla.rows().indexes();
	for(i = 0; i < filas.length; i++){
		data = $tabla.row(i).data();
		if(data[0] == id){
			break;
		}
	}
	return i;
}

function leerDetalle(id) {
	var fila = buscarFila(id);
	var f = document.getElementById("form_rendicion_detalle");

	opciones = f.id_gasto.options;

	for(i = 0; i < opciones.length; i++){
		if(opciones[i].value == $tabla.row(fila).data()[1]){
			f.id_gasto.selectedIndex = i;
			break;
		}
	}

	f.id_detalle.value = $tabla.row(fila).data()[0];
	f.descripcion.value = $tabla.row(fila).data()[3];
	f.monto.value = $tabla.row(fila).data()[4];

	$("#boton-agregar").html("Modificar");
	$("#boton-cancelar").fadeIn();

	return true;
}

function insertarDetalle() {

	$tabla.row.add([
		 detalle.id
		, detalle.id_gasto
		, detalle.gasto
		, detalle.descripcion
		, detalle.monto
		, detalle.opciones
	]).draw(false);
	return true;
}

/*
* Remover detalle de la datatabble
*/
function removerDetalle(id) {

	var fila = buscarFila(id);
	$tabla.row(fila).remove().draw(false);

	return true;
}

function resetDetalle() {
	var f = document.getElementById("form_rendicion_detalle");

	f.id_gasto.selectedIndex = 0;
	f.descripcion.value = "";
	f.monto.value = "";
	f.id_detalle.value = "";

	detalle.id = null;
	detalle.opciones = null;
	detalle.id_gasto = null;
	detalle.gasto = null;
	detalle.descripcion = null;
	detalle.monto = null;

	if($("#boton-cancelar").is(":visible")){
		$("#boton-agregar").html("Agregar");
		$("#boton-cancelar").hide();
	}
	return true;
}

document.addEventListener("DOMContentLoaded", function (event) {
	$('.form_date').datetimepicker({
		language: 'es',
		weekStart: 1,
		todayBtn: 1,
		autoclose: 1,
		todayHighlight: 1,
		startView: 2,
		minView: 2,
		forceParse: 0
	});

	$tabla = $("#dt-detalle").DataTable({
		scrollY: "400px",
		scrollX: true,
		scrollCollapse: true,
		paging: false,
		info: false,
		columns: [
			{	name: 'id', visible: false }
			, { name: 'id_gasto', visible: false }
			, { name: 'gasto' }
			, { name: 'descripcion' }
			, { name: 'monto', render: $.fn.dataTable.render.number('.', ',', 0, '$ ') }
			, { name: 'opciones', visible: editar }
		],
		dom: '<"pull-left"lf>tip'
	});
});