<?php

require_once(__DIR__.'/../../../contabilidad_mantencion_documentos_sii/librerias/leer.php');

/**
 * busca el menor de los folios disponibles
 * @param $cod_sii int el codigo del tipo de documento
 * @return int el folio
 */
function obtenerFolio($cod_sii){
    if($cod_sii == 48){ //el documento tipo 48 (boleta transbank no lleva folio sii)
        $sql = "SELECT MAX(folio_factura) +1 FROM tbl_ventas_boleta WHERE tipo_documento = '{$cod_sii}'";
    }
    else {

      //Si el documento vence
        if( in_array($cod_sii,array(110,112,111)) ){
          $timeActual = time();
          // Se valida que el folio este disponible y no este vencido
          $sql = "SELECT MIN(fc.folio)
                  FROM tbl_siifoliosconsumidos fc
                  LEFT JOIN tbl_siifoliostimbrados ft ON fc.id_timbraje=ft.id
                  WHERE fc.tipo_documento='$cod_sii' and sw_consumido='0'
                  AND (UNIX_TIMESTAMP(ft.fecha_autorizacion) + (86400*180))>{$timeActual}
                  ORDER BY folio ASC
                  ";
        }else{
          $sql = "select min(folio) from tbl_siifoliosconsumidos where tipo_documento='$cod_sii' and sw_consumido='0'";
        }
    }
    $rsl = EjecutarSql($sql);
    if(!$rsl){
        echo "Error Sql: {$sql}<br>". mysql_error();
        return false;
    }
    return mysql_result($rsl,0,0);
}

/**
 * setea el folio como consumido
 * @param $cod_sii int el tipo de documento a foliar
 * @param $folio int el folio a consumir
 * @return boolean true en caso de exito
 */
function consumirFolio($cod_sii, $folio){
    $sql="UPDATE tbl_siifoliosconsumidos
    SET sw_consumido = '1'
    WHERE tipo_documento = '$cod_sii'
    AND folio = '$folio'";
    return EjecutarSql($sql);
}

/**
 * verifica que exista el folio y que esté disponible
 * @param $cod_sii int el tipo de documento
 * @param $folio int el folio a verificar
 * @param $id int el id del documento a verificar
 * @return boolean true en caso de exito
 */
function validarFolio($cod_sii, $folio, $id){
    $doc = leerDocumentoSii('E', $cod_sii);

    $sqlCheck = "SELECT sw_consumido FROM tbl_siifoliosconsumidos WHERE tipo_documento='{$cod_sii}' AND folio='{$folio}'";
    $queryCheck = EjecutarSql($sqlCheck);
    if(!$queryCheck){
        echo "Error Sql: {$sqlCheck}<br>". mysql_error();
        return false;
    }
    if(mysql_num_rows($queryCheck) == 0){
        echo "Error\nEl folio solicitado no se encuentra cargado.\n";
        return false;
    }
    $consumido = mysql_result($queryCheck, 0) == 1;

    $sqlCheck = "SELECT {$doc['campo_id']} FROM {$doc['tabla']} WHERE {$doc['campo_folio']} = '{$folio}' AND estado = 'PR'";
    $queryCheck = EjecutarSql($sqlCheck);
    if(!$queryCheck){
        echo "Error Sql: {$sqlCheck}<br>". mysql_error();
    }

    if(mysql_num_rows($queryCheck) >= 1 // existe al menos uno
    && mysql_result($queryCheck, 0) != $id // no es el mismo documento
    && $consumido){ // folio ya consumido
        echo "Error\nEl folio ingresado ya está en uso, favor reintentar con otro o dejar en blanco.";
        return false;
    }

    return true;
}

/**
 * Verifica si el tipo de documento tiene folios cargados y disponibles
 * @param $cod_sii int el tipo de documento sii
 * @return boolean true en caso de existir
 */
function tieneFolio($cod_sii){
    if(in_array($cod_sii, array(48, 35))){ //el documento tipo 48 (boleta transbank no lleva folio sii)
        return true;
    }
    $sqlCheck = "SELECT count(sw_consumido) FROM tbl_siifoliosconsumidos WHERE tipo_documento='{$cod_sii}' AND sw_consumido=0";
    $queryCheck = EjecutarSql($sqlCheck);
    if(!$queryCheck){
        echo "Error Sql: {$sqlCheck}<br>". mysql_error();
        return false;
    }

    $tiene = mysql_result($queryCheck, 0) >= 1;
    if(!$tiene){
        echo "Error\nEste tipo de documento no tiene folios disponibles.\n";
    }

    return $tiene;
}
