<?php
/*
  ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
*/

  $camposAtributos = [
    'rut' => [ 'max' => 10 , 'tipo' => 'rut', 'nombre' => 'Rut'],
    'giro' => [ 'max' => 75 , 'tipo' => 'alfa', 'nombre' => 'Giro'],
    'direccion' => [ 'max' => 70 , 'tipo' => 'alfa', 'nombre' => 'Direccion'],
    'email' => [ 'max' => 80 , 'tipo' => 'email', 'nombre' => 'Email'],
    'comuna' => [ 'max' => 40 , 'tipo' => 'alfa', 'nombre' => 'Comuna'],
    'contacto' => [ 'max' => 80 , 'tipo' => 'alfa', 'nombre' => 'Contacto'],
    'direccion' => [ 'max' => 70 , 'tipo' => 'alfa', 'nombre' => 'Direccion'],
    'razon_social' => [ 'max' => 100 , 'tipo' => 'alfa', 'nombre' => 'Razon Social'],
    'telefono' => [ 'max' => 100 , 'tipo' => 'alfa', 'nombre' => 'Telefono'],
    'id_formapago' => [ 'max' => 11, 'tipo'=>'id', 'nombre' => 'Forma de pago'  ]
  ];
/*
  function valida_rut($rut){
    if(strlen($rut) > 10){ return false; }

    if(strstr($rut, '-') == false){ return false; }

    $array_rut_sin_guion = explode('-',$rut); // separamos el la cadena del digito verificador.
    $rut_sin_guion = $array_rut_sin_guion[0]; // la primera cadena
    $digito_verificador = $array_rut_sin_guion[1];// el digito despues del guion.


    if(is_numeric($rut_sin_guion)== false){ return false; }
    if ($digito_verificador != 'k' and $digito_verificador != 'K'){
      if(is_numeric($digito_verificador)== false){ return false; }
    }
    $cantidad = strlen($rut_sin_guion); //8 o 7 elementos
    for ( $i = 0; $i < $cantidad; $i++){ //pasamos el rut sin guion a un vector
      $rut_array[$i] = $rut_sin_guion{$i};
    }
    $i = ($cantidad-1);
    $x=$i;
    for ($ib = 0; $ib < $cantidad; $ib++)// ingresamos los elementos del ventor rut_array en otro vector pero al reves.
    {
      $rut_reverse[$ib]= $rut_array[$i];
      $rut_reverse[$ib];
      $i=$i-1;
    }

    $i=2;
    $ib=0;
    $acum=0;
    do{
      if( $i > 7 ){ $i=2; }
      $acum = $acum + ($rut_reverse[$ib]*$i);
      $i++;
      $ib++;
    }while ( $ib <= $x);

    $resto = $acum%11;
    $resultado = 11-$resto;
    if ($resultado == 11) { $resultado=0; }
    if ($resultado == 10) { $resultado='k'; }
    if ($digito_verificador == 'k' or $digito_verificador =='K') { $digito_verificador='k';}

    if ($resultado == $digito_verificador){ return true;}
    else{ return false; }
  }

*/
  function RutValidate($rut) {
        $rut=str_replace('.', '', $rut);
        if (preg_match('/^(\d{1,9})-((\d|k|K){1})$/',$rut,$d)) {
          $s=1;
          $r=$d[1];
          for($m=0;$r!=0;$r/=10){$s=($s+$r%10*(9-$m++%6))%11;}
          return chr($s?$s+47:75)==strtoupper($d[2]);
        }
  }

  function validar(/*Nombre del campo */ $campo, /*Dato*/ $d){
        $r = [ 'bool'=> true , 'error' => '', 'campo' => $campo ];
        global $camposAtributos;
        $c = $camposAtributos[$campo];
        //Verificacion de Campo Vacio//
        if( $d == ''){
          $r['bool'] = false;
          $r['error'] .= "El campo [{$c['nombre']}] se encuentra vacio. |";
          if($campo!='rut'){
            return $r;
          }
        }
        ///////////////////////////////
        ##
        //Verificacion de Largo de Caracter//
        if( strlen($d) > $c['max'] ){
          $exceso = strlen($d) - $c['max'];
          $r['bool'] = false;
          $r['error'] .= "El campo [{$c['nombre']}] excede el largo maximo por $exceso caracteres. |";
        }
        /////////////////////////////////////
        ##
        //Verificacion de ID//
        if($c['tipo'] == 'id'){
          if(!is_numeric($d)){
            $r['bool'] = false;
            $r['error'] .= "El campo [{$c['nombre']}] excede el largo maximo por $exceso caracteres. |";
          }
        }
        //////////////////////
        //Verificacion Alfanumerica//
        if( $c['tipo'] == 'alfa' ){
          /*
          if(strpos($d, '-') !== FALSE ){
            $r['bool'] = false;
            $r['error'] = 'El campo ['.$c->nombre.'] contiene caracteres no permitidos ( - ).|';
          }
          */
          if(strpos($d, '_') !== FALSE ){
            $r['bool'] = false;
            $r['error'] .= "El campo [{$c['nombre']}] contiene caracteres no permitidos ( _ ) |";
          }
          if(strpos($d, '/') !== FALSE ){
            $r['bool'] = false;
            $r['error'] .= "El campo [{$c['nombre']}] contiene caracteres no permitidos ( / ) |";
          }
          if(strpos($d, '?') !== FALSE ){
            $r['bool'] = false;
            $r['error'] .= "El campo [{$c['nombre']}] contiene caracteres no permitidos ( ? ) |";
          }
        }
        /////////////////////////////
        ##
        //Validar Rut//
        if($c['tipo'] == 'rut'){
          if(RutValidate($d)==false){
            $r['bool'] = false;
            $r['error'] .= "El campo [{$c['nombre']}] no es valido. |";
          }
        }
        ///////////////

        //Validar Email//
        if($c['tipo'] == 'email' ){
          if (!filter_var($d, FILTER_VALIDATE_EMAIL)) {
            $r['bool'] = false;
            $r['error'] .= 'El [Email] no es una direccion de correo electronico valida. |';
          }
        }
        /////////////////
        return $r;
  }

  /**
  * Funcion que Determina la cantidad de dias transcurridos entre dos fechas
  * @param $fechaFinal string // fecha del documento que se quiere emitir
  * @param $fechaInicial string // fecha del documento al que se hace referencia
  * @return $diferencia int|NULL // numeros de dias transcurridos entre ambas fechas
  **/
  function RestarDias($fechaFinal,$fechaInicial){
    if($fechaFinal=='' or $fechaInicial==''){ return NULL; }
    $ff = explode('/',$fechaFinal);
    $fi = explode('/',$fechaInicial);
    if( !isset($ff[2]) or !isset($fi[2]) ){ return NULL; }

    $diasFinal = $ff[2]*365 + $ff[1]*30 + $ff[0];
    $diasInicial = $fi[2]*365 + $fi[1]*30 + $fi[0];
    $diferencia = $diasFinal - $diasInicial;
    return $diferencia;
  }


/*

$documentosVenta = [
  '33' => [ 'nombre' => 'Factura Venta',
          'tabla' => 'tbl_ventas',
          'detalle' => 'tbl_ventasdetalle',
          'folio' => 'folio_factura',
          'id' => 'id',
          'folioSii' => 'folio_factura'
          ],
  '61' => [ 'nombre' => 'Nota de Credito Venta',
          'tabla' => 'tbl_ventas_credito',
          'detalle' => 'tbl_ventasdetalle_credito',
          'folio' => 'folio_notacredito',
          'id' => 'id',
          'folioSii' => 'folio_notacredito'
          ],
  '56' => [ 'nombre' => 'Nota de Debito Venta',
          'tabla' => 'tbl_ventas_debito',
          'detalle' => 'tbl_ventasdetalle_debito',
          'folio' => 'folio_notadebito',
          'id' => 'id',
          'folioSii' => 'folio_notadebito'
          ],
  '52' => [ 'nombre' => 'Guia de Despacho Venta',
          'tabla' => 'tbl_guiasdespacho_ventas',
          'detalle' => 'tbl_guiasdespacho_ventas_detalle',
          'folio' => 'folio_guia',
          'id' => 'folio',
          'folioSii' => ''
          ]   ,
  'fc' => ['nombre' => 'Factura Compra',
          'tabla' => 'tbl_compras',
          'detalle' => 'tbl_comprasdetalle',
          'folio' => '',
          'id' => 'numero_compra',
          'cod_sii' => 33,
          'folioSii' => ''
          ],
  'cc' => ['nombre' => 'Nota de Credito Compra',
          'tabla' => 'tbl_compras_credito',
          'detalle' => 'tbl_comprasdetalle_credito',
          'folio' => '',
          'id' => '',
          'cod_sii' => 61,
          'folioSii' => ''
          ],
  'dc' => ['nombre' => 'Nota de Debito Compra',
          'tabla' => 'tbl_compras_debito',
          'detalle' => 'tbl_comprasdetalle_debito',
          'folio' => '',
          'id' => '',
          'cod_sii' => 56,
          'folioSii' => ''
          ],
  'gc' => ['nombre' => 'Guia de Despacho Compra',
          'tabla' => 'tbl_guiasdespacho_compras',
          'detalle' => 'tbl_guiasdespacho_compras_detalle',
          'folio' => '',
          'id' => 'id',
          'cod_sii' => 52,
          'folioSii' => ''
          ]

];
*/
//valida duplicidad de folio y tipo de documento
/**
* Funcion que valida duplicidad de folio del documentos
* @param $documento int // Numero de documento
* @param $folio int // Folio del Documento
* @param $id int // Id del documento
* @param $rutProveedor string
* @return $r [boolean,srting,string] detalle de la validacion
**/
 function validarDocumentoDuplicado($documento,$folio,$id){
   //echo 'inicio function|';
   global $documentosVenta_exp;
   $doc = $documentosVenta_exp[$documento];
   $r = ['bool' => true, 'error' => '', 'campo' => 'FOLIO '.$doc['nombre'] ];
   /*
   if($folio='' or $folio=0 or !isset($folio) ){
     $r['bool'] = false;
     $r['error'] = "Ya existe una [{$doc['nombre']}] tipo {$tipoDocumento} con folio {$folio}.";
     return $r;
   }
   */
   if($documento=='' or $documento==0 or !isset($documento) ){
     $r['bool'] = false;
     $r['error'] = "No se ha especificado un [Tipo de Documento] |";
     return $r;
   }
   $duplicadas = [];
   if($folio!=''){
     $x = EjecutarSql("select * from {$doc['tabla']} where {$doc['campo_folio']}='$folio' and tipo_documento='$documento'");
     while($y=ListarSql($x)){
       $duplicadas[] = $y[$doc['campo_id']];
     }
     if(count($duplicadas)>1){
       $r['bool'] = false;
       $r['error'] = "Ya existe una [{$doc['nombre']}] tipo {$documento} con folio {$folio}. |";
       return $r;
     }
     if(count($duplicadas)==1 and !in_array($id,$duplicadas)){
      $r['bool'] = false;
      $r['error'] = "Ya existe una [{$doc['nombre']}] tipo {$documento} con folio {$folio}. |";
    }
   }
   return $r;
 }




/**
* Valida Document de Referencia
* @param $tipoDoc int // Numero de tipo Documento
* @param $folioDoc int // Folio del Documento a emitir
* @param $codSiiRef int // Numedo de Documento Referencia
* @param $folioRef int // Folio del Documento al que se le hace referencia
* @return  [
*          bool boolean // confirmacion
*          error string // mensaje de error
*          campo string // id-name del input que lanzó el error
*          ]
**/
 function validarReferencia(/*fv-fc-cv-dv-etc*/$tipoDoc,$folioDoc,$idDoc,/*numero_sii*/$codSiiRef,$folioRef){
   $codSiiRef+=0;
   global $documentosVenta_exp;
   $r = ['bool' => true, 'error' => '', 'campo' => 'fecha_emision' ];
   $doc = $documentosVenta_exp[$tipoDoc];
   $docRef = $documentosVenta_exp[$codSiiRef] ;
   if(!isset($docRef) or $codSiiRef==''){
     $r['bool'] = false;
     $r['error'] = "[Tipo Documento Referencia] es invalido. |";
     return $r;
   }

   // Valida si es que existe la referencia //
   $referencia = NULL;
   $x = EjecutarSql("select * from {$docRef['tabla']} where {$docRef['campo_folio']}='$folioRef' ");
   while( $y = ListarSql($x) ){
     $referencia = [
       'razon_social' => $y['razon_social'],
       'rut' => $y['rut'],
       'fechaContable' => $y['fecha_facturacion']
     ];
   }
   if( $referencia==NULL ){
     $r['bool'] = false;
     $r['error'] = "El documento tipo {$codSiiRef} folio {$folioRef} al que hace referencia no existe.|";
     return $r;
   }

   //valida que no haya otro documento anulandolo
   if($doc['codigo'] == 'CV' or $doc['codigo'] == 'DV'){
     if($doc['codigo']=='CV'){ $campoRef = 'folio_factura'; }
     else{ $campoRef = 'folio_notacredito'; }
     $x = EjecutarSql( "select * from {$doc['tabla']} where {$campoRef}='$folioRef' and tipo_documento_referencia='$codSiiRef' and codigo_referencia=1 and estado='PR'" );
     while( $y = ListarSql($x) ){
       $idAn = $y[$doc['campo_id']];
       $folioAn = $y['folio_notacredito'];
       if($folioAn==''){ $folioAn = $y['folio_notadebito']; }
       $tipoAn = $y['tipo_documento'];
       if($idDoc!=$idAn){
         $r['bool'] = false;
         $r['error'] = "El documento tipo {$tipoAn} folio {$folioAn} ya anuló este documento|";
         return $r;
       }
     }
   }


   //  Valida la antiguedad de la referencia //
   $date = new DateTime();
   $fecha_actual =  date_format($date, 'd/m/Y');
   $dias_diferencia = RestarDias( $fecha_actual , $referencia['fechaContable'] );
   if($dias_diferencia === NULL or $dias_diferencia > 90){
     $r['bool'] = false;
     $r['error'] = "No se pueden hacer referencia a un documento emitido hace mas de 90 dias. | fecha_actual={$fecha_actual} dias_diferencia={$dias_diferencia} referencia={$referencia['fechaContable']}";
     $r['campo'] = 'fecha_emision';
     return $r;
   }

   return $r;
 }


include_once(__DIR__."/validarPeriodo.php");
//
// function validarPeriodo($fecha_emision){
//   $r = ['bool' => true, 'error' => '', 'campo' => 'fecha_emision' ];
//   $fechaCheck = substr($fecha_emision, 3, 8);
//   $sqlCheck = "SELECT estado FROM tbl_periodoslibros WHERE periodo = '$fechaCheck'";
//   $queryCheck = EjecutarSql($sqlCheck);
//   if(!ListarSql($queryCheck)){
//     return $r;
//   }
//   $abierto = 0;
//   if(mysql_result($queryCheck, 0) != $abierto){
//     $r['bool'] = false;
//   	$r['error'] = "No se puede emitir el documento, el periodo {$fechaCheck} se encuentra cerrado |";
//   }
//   return $r;
// }


function validarLineas($tipoDocumento,$folio,$origenFactura){
      $r = ['bool' => true, 'error' => '', 'campo' => 'Lineas de Item' ];
      global $documentosVenta_exp;
      $doc = $documentosVenta_exp[$tipoDocumento];
      $atr = $doc['atributos_detalle'];
      $maxLineas = $origenFactura=='4' && in_array( $tipoDocumento, array(35,39,30,32,33,34,46,48,110,112) ) ? 60 : 20;
      $lineasCheck = "SELECT COUNT(*) FROM {$doc['tabla_detalle']} WHERE {$atr['idEncabezado']}='$folio' AND {$atr['observaciones']} = ''";
      $sqlLineas = EjecutarSql($lineasCheck);
      $itemSolo = mysql_result($sqlLineas, 0) *1;

      $lineasCheck = "SELECT COUNT(*) FROM {$doc['tabla_detalle']} WHERE {$atr['idEncabezado']}='$folio' AND {$atr['observaciones']} != ''";
      $sqlLineas = EjecutarSql($lineasCheck);
      $itemDoble = mysql_result($sqlLineas, 0) *2;
      $totalLineas = $itemSolo + $itemDoble;
      if($totalLineas < 1){
        $r = ['bool' => false, 'error' => 'No hay ningun item', 'campo' => 'Lineas de Item.' ];
      }
      if($totalLineas > $maxLineas){
        $exceso = ($totalLineas-$maxLineas)*(1);
        $r['bool'] = false;
        $r['error'] = "Se ha excedido el numero maximo de lineas de detalle en {$exceso}. Elimine items y facturelos con otro folio. |" ;
      }
      return $r;
}



/**
* Funcion que crea o modifica cliente
* @param $rut string rut del cliente
* @param $razonSocial string
* @param $direccion string
* @param $giro string
* @param $telefono string
* @param $idComuna int
* @param $contacto string
* @param $mailContacto email
* @param $idVendedor int
* @param $formaPago int
* @return $r boolean // confirmacion de la creacion o modificacion del cliente
**/
  function crearCliente($rut,$razonSocial,$direccion,$giro,$telefonos,$idComuna,$contacto,$mailContacto,$idVendedor,$formaPago,$condicionVenta){

    $sql="select * from tbl_clientes_empresas where rut='$rut'";
    $rsl=EjecutarSql($sql);
    $sw_existe_rut=mysql_num_rows($rsl);


    #
    if($sw_existe_rut>0){
      $updateMedioPago = $formaPago>0 ? "forma_pago = '{$formaPago}'," : '';
      $updateCondicionVenta = $condicionVenta>0 ? "id_condiciones_venta = '{$condicionVenta}'," : '';
      $accion = 'modificar';
    	$x = EjecutarSql("update tbl_clientes_empresas set
    	razon_social='$razonSocial',
    	giro='$giro',
    	direccion='$direccion',
    	id_comuna='$idComuna',
    	contacto='$contacto',
    	email='$mailContacto',
    	telefono='$telefonos',
    	{$updateCondicionVenta}
      {$updateMedioPago}
    	id_vendedor='$idVendedor'
    	where rut='$rut'");
      echo mysql_error();
    	if($x){ $r = true; }else{ $r = false; }
    }else{
      $accion = 'crear';
    	$x = EjecutarSql( "insert into tbl_clientes_empresas (
    	rut,
    	razon_social,
    	giro,
    	direccion,
    	id_comuna,
    	contacto,
    	email,
    	telefono,
    	nombre_fantasia,
    	id_vendedor,
    	id_condiciones_venta
    		) values (
    	'$rut',
    	'$razonSocial',
    	'$giro',
    	'$direccion',
    	'$idComuna',
    	'$contacto',
    	'$mailContacto',
    	'$telefonos',
    	'$razonSocial',
    	'$idVendedor',
    	'$formaPago')");

      if($x){ $r = true; }else{  $r = false; }
    }
    return array('bool'=>$r,'accion'=>$accion);
}

  //echo 'fin archivo validacion';
?>
