<?php

require_once('exp_validarFolio.php');
require_once('exp_checkStock.php');
require_once('exp_checkCentroNegocio.php');
require_once(__DIR__.'/../arrays/exp_centros_negocio.php');
require_once(__DIR__.'/../../../contabilidad_mantencion_documentos_sii/librerias/leer.php');
require_once('validarCliente.php');

function validarCuenta($c){
      if( !is_numeric($c) || strlen($c)!=9 ){
        return false;
      }
      $sql = "SELECT * FROM tbl_plandecuentas WHERE codigo_cuenta='{$c}' ";
      $query = EjecutarSql($sql);
      if( mysql_num_rows($query)>0 ){
        return true;
      }else{
        return false;
      }
}

function validarKit($codigoKit,$cantidadKit,$idBodega){
    $errores = "";
    $sql = "SELECT
            r.cantidad
            , bi.cantidad stock
            , p.codigo_producto
            , CASE WHEN p.codigo_linea=2 THEN 1 ELSE 0 END kit
            FROM tbl_recetas_detalle r
            JOIN tbl_productos p ON r.codigo=p.codigo_producto
            LEFT JOIN tbl_bodegas_inventario bi ON p.codigo_producto=bi.codigo_producto AND bi.id_bodega={$idBodega}
            WHERE r.codigo_final={$codigoKit}";
    $query = EjecutarSql($sql);
    if( mysql_num_rows($query)==0 ){
      return array("error" => true, "e_msg" => "Hay un error en con el kit [{$codigoKit}]. Por favor verifique que los productos que componen este kit existan o modifique la receta.");
    }
    // echo mysql_num_rows($query);
    while( $r = mysql_fetch_array($query) ){
        if($r['kit']=="1"){
            $v = validarKit($r['codigo_producto'],$r['cantidad']*$cantidadKit,$idBodega);
            $errores .= $v['error'] ? $v['e_msg'] : "";
        }else{
            if( $r['stock'] < $r['cantidad']*$cantidadKit ){
                $errores .= "[{$r['codigo_producto']}] Stock en bodega insuficiente!\n";
            }
        }
    }
    if($errores!=""){
        return array("error" => true, "e_msg" => $errores);
    }else{
        return array("error" => false, "e_msg" => "");
    }
}


function validarProductos( $id, $infoDoc /* variable con el toda la info del documento */){
  global $empresa;
  $r = array('error' => '', 'e_msg' => '');
  $sql = "SELECT CASE WHEN {$infoDoc['atributos']['folioNotaPedido']}>0 THEN 1 ELSE 0 END
          FROM {$infoDoc['tabla']}
          WHERE {$infoDoc['campo_id']}={$id}";
  $query = EjecutarSql($sql);
  // echo mysql_error();

  $folioNotaPedido = mysql_result($query,0,0);
  // var_dump($folioNotaPedido);
  // exit();
  $sql = "SELECT
          p.id_centroingreso
          , i.id id_impuesto
          , vd.{$infoDoc['atributos_detalle']['cantidad']} cantidadActual
          , vd.{$infoDoc['atributos_detalle']['codigoProducto']} codigo
          , vd.{$infoDoc['atributos_detalle']['tipoItem']} tipo
          , vd.{$infoDoc['atributos_detalle']['idItem']} item
          , bi.cantidad saldo
          , p.codigo_producto
          , CASE WHEN p.codigo_linea=2 THEN 1 ELSE 0 END kit
          , v.{$infoDoc['atributos']['idBodegaDespacho']} id_bodega
          , p.sw_inventario
          FROM {$infoDoc['tabla_detalle']} vd
          JOIN {$infoDoc['tabla']} v ON vd.{$infoDoc['atributos_detalle']['idEncabezado']}=v.{$infoDoc['atributos']['id']}
          LEFT JOIN tbl_productos p ON vd.{$infoDoc['atributos_detalle']['codigoProducto']}=p.codigo_producto
          LEFT JOIN tbl_centrosdeingreso ci ON p.id_centroingreso=ci.id_centroingreso
          LEFT JOIN tbl_sii_otrosimpuestos i ON p.id_impuesto=i.id
          LEFT JOIN tbl_bodegas_inventario bi ON p.codigo_producto=bi.codigo_producto AND bi.id_bodega=v.{$infoDoc['atributos']['idBodegaDespacho']}
          WHERE vd.{$infoDoc['atributos_detalle']['idEncabezado']}={$id} ";

          $queryy = EjecutarSql($sql);
          while( $row = mysql_fetch_array($queryy) ){
            $idItem = $row['item'];
            $codigoProducto = $row['codigo'];
            $tipoProducto = $row['tipo'];
            $centroIngreso = $row['id_centroingreso'];
            $impto = $row['id_impuesto'];
            $manejaInventario = $row['sw_inventario']=='1';

            //Validar Stock en bodega
            if( $row['saldo'] - $row['cantidadActual'] < 0
                && $empresa['sw_validar_stock']=="0"
                && !in_array($infoDoc['cod_sii'],array(112))
                && $tipoProducto!="C"
                && !$infoDoc['esFacturacionGuias']
            ){
              if( $row['kit']=='0'){
                if($manejaInventario){
                  $r['error'] = true;
                  $r['e_msg'] = "El item [{$row['codigo_producto']}] no tiene suficiente stock en bodega.";
                  return $r;
                }
              }else{
                $vKit = validarKit($row['codigo_producto'],$row['cantidadActual'],$row['id_bodega']);
                if($vKit['error']){
                  $r['error'] = true;
                  $r['e_msg'] = $vKit['e_msg'];
                  return $r;
                }
              }
            }


    //validar Centros Ingreso
    if($tipoProducto!='C' ){
        if($centroIngreso==0){
          $r['error'] = true;
          $r['e_msg'] = "El item [{$row['codigo_producto']}] no tiene centro de ingreso configurado.";
          return $r;
        }
        $sql = "SELECT cuenta_venta,cuenta_costo,cuenta_mercaderia FROM tbl_centrosdeingreso WHERE id_centroingreso='{$centroIngreso}'";
        $query = EjecutarSql($sql);
        // echo $sql;
        // echo mysql_error();
        if( mysql_num_rows($query)==0 ){
          $r['error'] = true;
          $r['e_msg'] = "El centro de ingreso del item [{$row['codigo_producto']}] ya no existe. Por favor configurele uno antes de procesar.";
          return $r;
        }
        $cuentasCI = array(
          'cuenta de Venta' => mysql_result($query,0,0),
          'cuenta de Costo' => mysql_result($query,0,1),
          'cuenta de Mercaderia' => mysql_result($query,0,2)
        );
        $e = false;
        $em = '';
        foreach ($cuentasCI as $nombre => $c) {
          $v = validarCuenta($c);
          $e = !$v ? true : $e ;
          $em .= !$v ? " {$nombre}," : '' ;
        }
        // Se borra la ultima coma
        $em =  substr($em,0,-1);

        if($e){
          $r['error'] = true;
          $r['e_msg'] = "El centro de ingreso del item [{$row['codigo_producto']}] no tiene configurado {$em}.";
          return $r;
        }
    }
    /* Si es Cuenta Contable */
    else{
        if( !validarCuenta($codigoProducto) ){
          $r['error'] = true;
          $r['e_msg'] = "La cuenta contable del item [{$row['codigo_producto']}] no existe.";
          return $r;
        }
    }

    if($impto>0){
        $sql = "SELECT codigo_cambio cuenta_df, tasa FROM tbl_sii_otrosimpuestos WHERE id='{$impto}' ";
        $query = EjecutarSql($sql);
        if( mysql_num_rows($query)==0 ){
          $r['error'] = true;
          $r['e_msg'] = "El impuesto adicional del item [{$row['codigo_producto']}] no est&aacute; configurado.";
          return $r;
        }
        // aplica Venta
        if( mysql_result($query,0,0)==0 ){
          $r['error'] = true;
          $r['e_msg'] = "El impuesto adicional del item [{$row['codigo_producto']}] no aplica a la venta.";
          return $r;
        }

        // Tasa
        if( mysql_result($query,0,1)==0 ){
          $r['error'] = true;
          $r['e_msg'] = "El impuesto adicional del item [{$row['codigo_producto']}] no tiene configurada la tasa.";
          return $r;
        }

    }

  }
  return $r;
}


/**
 * Valida el estado del periodo al que se hace referencia en el documento
 * @param $fecha String indica la fecha del documento en formato 'd/m/Y'
 * @return boolean true en caso de estar abierto el periodo
 */
// function validarPeriodo($fecha){
//   $periodoValidar = implode('-',array_reverse(explode('/',substr($fecha,3))));
//   $sql = "SELECT ventas FROM tbl_cierres WHERE periodo='{$periodoValidar}' ";
//   $query = EjecutarSql($sql);
//   if(mysql_num_rows($query)>0){
//     if(mysql_result($query,0,0)=='1'){
//       return true;
//     }else{
//       return false;
//     }
//   }else{
//     return true;
//   }
// }





/**
 * Procesa un documento de venta en el sistema
 * @param $cod_sii int el codigo del tipo de documento
 * @param $id el id del documento
 * @return boolean true en caso de exito
 */
function procesarDocumentoVenta($cod_sii, $id){
    global $CONFIG;
    global $centros_negocios;
    global $RUTRecep;

    $infoDoc = leerDocumentoSii('E', $cod_sii);

    // leer
    $sql = "SELECT * FROM {$infoDoc['tabla']} WHERE {$infoDoc['campo_id']} = '{$id}'";
    $query = EjecutarSql($sql);
    if(!$query){
        echo "Error Sql: ". mysql_error();
        return false;
    }
    $documento = mysql_fetch_array($query);
    $folio = (int) $documento[$infoDoc['campo_folio']];


    $bodega = [
        'id' => $documento[$infoDoc['atributos']['idBodegaDespacho']] > 0 ? $documento[$infoDoc['atributos']['idBodegaDespacho']] : NULL,
        'zona' => 1, // ?????????
    ];

    // variables para comparacion origen documento
    if(array_key_exists('origen_factura', $documento)){
        // 3=facturadirecto  2=facturarpedidos  1=facturarguias
        $origenDocumento =  $documento['origen_factura'];
        $desdeDirecto = "3";
        $desdePedido = "2";
        $desdeGuia = "1";
    }
    else {
        $origenDocumento =  $documento['id_tipopedido'];
        $desdeDirecto = "0";
        $desdePedido = "1";
        $desdeGuia = "-1"; // solo para evitar error de variable no encontrada
    }

    //si viene de guia
    if($origenDocumento == $desdeGuia){
        $infoGuia = leerDocumentoSii('V', 52); //obtiene los datos de guía
    }


    //Validar Periodo
    include_once(__DIR__."/validarPeriodo.php");
    if( !validarPeriodo('ventas',$documento[$infoDoc['atributos']['fechaFacturacion']]) ){
      $np = nombrePeriodo($documento[$infoDoc['atributos']['fechaFacturacion']]);
        echo "El periodo {$np} se encuentra cerrado para la venta. Pongase en contacto con el administrador de sistema en su empresa para que habilite el periodo y pueda procesar el documento.";
        return false;
    }


    //Validar cliente
    // la funcion validarCliente() se encarga de emitir los mensajes de error
    if( !validarCliente($documento[$infoDoc['atributos']['rut']]) ) {
      return false;
    }


    //validar folio

    // si no trae folio obtener
    if($folio == 0 || $folio == "" || $folio == NULL){ // no viene con folio

      //Si la empresa esta configurada como "ENVIA AL SII", se obtiene el folio
      if($CONFIG['sw_enviar_sii']=="1"){
        if( in_array( $cod_sii, array(35,48) ) ){
            echo "Debe ingresar el numero de folio de la boleta para Procesar";
            return false;
        }
        if(!tieneFolio($cod_sii)){
            return false;
        }
        $folio = obtenerFolio($cod_sii);
      }else{
        echo "Debe ingresar el numero de folio del documento";
        return false;
      }
    }

    // valida disponibilidad y consume
    if( $cod_sii != 48 ){ //el documento tipo 48 (boleta transbank no lleva folio sii)
        if(!validarFolio($cod_sii, $folio, $documento[$infoDoc['campo_id']])){
            return false;
        }
    }

    //Valida monto minimo $180
    if( $documento['bruto']<1){  // && $documento["id_tipoguia"]!=5 && $documento["id_tipoguia"]!=6 && $documento["id_tipoguia"]!=8 ){
      if( in_array($cod_sii,array(112)) ){
        if( $documento[$infoDoc['atributos']['codigoReferencia']] != 2 ){
          echo "Error: \n-El monto bruto del documento debe ser mayor a 1";
          return false;
        }
      }else{
        echo "Error: \n-El monto bruto del documento debe ser mayor a 1";
        return false;
      }

    }

    $infoDoc['esFacturacionGuias'] = $origenDocumento == $desdeGuia;
    $vp = validarProductos($id,$infoDoc);
    if( $vp['error'] ){
      echo "Error : ". $vp['e_msg'];
      return false;
    }



    //traer detalle para validacion
    $sql ="SELECT p.codigo_producto, p.codigo_linea, r.folio id_receta, p.id_centroingreso, vd.cantidad
    FROM `{$infoDoc['tabla_detalle']}` vd
    JOIN `tbl_productos` p
    ON p.codigo_producto = vd.{$infoDoc['atributos_detalle']['codigoProducto']}
    LEFT JOIN `tbl_recetas` r ON p.codigo_producto=r.codigo_final
    WHERE vd.folio = '{$id}'";
    $query = EjecutarSql($sql);
    if(!$query){
        echo "Error Sql: ". mysql_error();
        return false;
    }
    $items = array();
    $centrosNegocios = array();
    while ($r = mysql_fetch_array($query)){
        //si es receta (kit)
        if($r['codigo_linea'] == 2){
            $sql = "SELECT rd.codigo, rd.cantidad, p.id_centroingreso
            FROM `tbl_recetas_detalle` rd
            LEFT JOIN `tbl_productos` p ON rd.codigo = p.codigo_producto
            WHERE rd.folio = {$r['id_receta']}";
            $recetaQuery = EjecutarSql($sql);
            while($detReceta = mysql_fetch_array($recetaQuery)){
                //cantidad de items en el kit por la cantidad de kits
                $cantidad = $detReceta['cantidad'] * $r['cantidad'];
                if(array_key_exists($detReceta['codigo'], $items)){
                    $items[$detReceta['codigo']] += $cantidad;
                }
                else {
                    $items[$detReceta['codigo']] = $cantidad;
                }
                $centrosNegocios[$detReceta['id_centroingreso']] = true;
            }
        }
        //regular
        else{
            if(array_key_exists($r['codigo_producto'], $items)){
                $items[$r['codigo_producto']] += $r['cantidad'];
            }
            else {
                $items[$r['codigo_producto']] = $r['cantidad'];
            }
            if(isset($r['id_centroingreso']) && $r['id_centroingreso'] != ""){
                $centrosNegocios[$r['id_centroingreso']] = true;
            }
        }
    }

    //validar stock
    // si sw_validar_stock = 0 validar
    if(!$CONFIG['sw_validar_stock'] && !in_array($cod_sii, array(112))){
      //si el producto maneja inventario
      if($r['sw_inventario']==1 && $origenDocumento != $desdeGuia ){
        $errores = checkStock($items, $bodega['id']);
        if(count($errores) > 0){
            $mensaje = "Error\n";
            foreach($errores as $c => $e){
                $mensaje .= "[{$c}] {$e}";
            }
            echo $mensaje;
            return false;
        }
      }
    }

    //validar cuentas contables (centro de negocio) de los productos
    if(count($centrosNegocios) >= 1){
        $errores = checkCentroNegocio($centrosNegocios);
        if(count($errores) > 0){
            $mensaje = "ERROR\n";
            foreach($errores as $id => $info){
                $mensaje .= "En el centro de negocio {$info['nombre']} [ID:{$id}]:\n";
                foreach($info['errores'] as $err){
                    $mensaje .= $err;
                }
            }
            echo $mensaje;
            return false;
        }
    }

    //validar cuenta contable del documento

    if($infoDoc['cod_cuenta'] == 0 || $infoDoc['cod_cuenta'] == "" || $infoDoc['cod_cuenta'] == '0'){
        echo "Error\nEl documento no posee cuenta asignada.";
        return false;
    }

    // validar cuenta iva
    if($CONFIG['contabilidad_cuenta_iva'] == 0 || $CONFIG['contabilidad_cuenta_iva'] == "" || $CONFIG['contabilidad_cuenta_iva'] == '0'){
        echo "Error\nCuenta debito fiscal no configurada.";
        return false;
    }

    // posee descuentos globales
    $porcDescuentoGlobal = [
        $documento[$infoDoc['atributos']['porcDescuentoAfecto']] / 100,
        $documento[$infoDoc['atributos']['porcDescuentoExento']] / 100,
    ];


    $fechaVencimiento = array_key_exists('fechaVencimiento', $infoDoc['atributos']) ? $documento[$infoDoc['atributos']['fechaVencimiento']] : NULL; // si posee el campo
    $fechaVencimiento = $fechaVencimiento == NULL
        || $documento[$infoDoc['atributos']['fechaVencimiento']] == "0"
        || strpos($documento[$infoDoc['atributos']['fechaVencimiento']], '1969') !== false ?
        $documento[$infoDoc['atributos']['fechaFacturacion']] // si no posee fecha vencimiento set emision
        : $fechaVencimiento; // si es una fecha valida > a 1969
    //encabezado voucher
    $voucher = [
        'tipo' => 'T', //Traspaso
        'documento' => [
            'tipo' => $infoDoc['codigo'],
            'folio' => $folio,
        ],
        'auxiliar' => $documento['rut'],
        'observaciones' => utf8_encode("EMISION {$infoDoc['nombre']} VENTA $folio"),
        'fecha' => $documento[$infoDoc['atributos']['fechaFacturacion']],
        'fecha_vencimiento' => $fechaVencimiento,
    ];
    $voucher['folio'] = VoucherCabeza($voucher['fecha'], $voucher['tipo'], $voucher['documento']['tipo'], $folio, $voucher['auxiliar'], $voucher['observaciones']);

    $campoValVenta = $infoDoc['atributos']['valoresVenta'];
    $esVentaBruta = (bool) $documento[$campoValVenta]; // 1 es venta bruta

    // contabilidad voucher
    $operacionesVoucher = array('neto', 'iva', 'venta', 'costo', 'existencia');
    if(in_array($cod_sii, array(112))){ // nota de credito ?
        $operacionesVoucher['neto'] = "CR";
        $operacionesVoucher['iva'] = "DB";
        $operacionesVoucher['venta'] = "DB";
        $operacionesVoucher['costo'] = "CR";
        $operacionesVoucher['existencia'] = "DB";
        $operacionesVoucher['impuestoAdicional'] = "DB";
    }
    else {
        $operacionesVoucher['neto'] = "DB";
        $operacionesVoucher['iva'] = "CR";
        $operacionesVoucher['venta'] = "CR";
        $operacionesVoucher['costo'] = "DB";
        $operacionesVoucher['existencia'] = "CR";
        $operacionesVoucher['impuestoAdicional'] = "CR";
    }

    // recorrer detalle
    $sql = "SELECT vd.{$infoDoc['atributos_detalle']['codigoProducto']}
        , p.nombre
        , p.codigo_linea
        , r.folio id_receta
        , p.id_centroingreso
        , p.sw_inventario
        , vd.{$infoDoc['atributos_detalle']['pmp']}
        , p.reserva
        , p.disponible
        , vd.cantidad
        , vd.{$infoDoc['atributos_detalle']['precioVenta']}
        , vd.subtotal
        , vd.descripcion
        ";
    //Si es boleta o Factura, busca tambien el folio de la guia de despacho
    $sql .= !in_array($cod_sii,array(112)) ? ", vd.folio_guiadespacho" : "";
    if(is_array($infoDoc['atributos_detalle'])
    && array_key_exists('montoImpuestoAdicional', $infoDoc['atributos_detalle'])
    ){
        $sql .= ", vd.{$infoDoc['atributos_detalle']['montoImpuestoAdicional']} impuesto_adicional_monto
        , vd.{$infoDoc['atributos_detalle']['codigoImpuestoAdicional']} impuesto_adicional_codigo
        ";
    }
        $sql .= ", vd.id_item
        , vd.tipo_item
        , vd.{$infoDoc['atributos_detalle']['swExento']}
        FROM `{$infoDoc['tabla_detalle']}` vd
        LEFT JOIN `tbl_productos` p ON p.codigo_producto = vd.{$infoDoc['atributos_detalle']['codigoProducto']}
        LEFT JOIN `tbl_recetas` r ON vd.{$infoDoc['atributos_detalle']['codigoProducto']}=r.codigo_final
        WHERE vd.folio = '{$id}'
        ORDER BY vd.id_item";
    $detalleQuery = EjecutarSql($sql);
    if(!$detalleQuery){
        echo "Error Sql: " . mysql_error();
        return false;
    }

    $subtotal = [0, 0]; // indice 0 no exento
    $impuestoAdicional = [0, 0];
    while($detalleDoc = mysql_fetch_array($detalleQuery)){
        $detalleVoucher = array();
        $cuentasVoucher = array('venta', 'costo', 'existencia');
        $exento = (int) $detalleDoc[$infoDoc['atributos_detalle']['swExento']];

        //si es cuenta
        $esCuenta = $detalleDoc["tipo_item"] ==    "C";
        $codigoProducto = $detalleDoc[$infoDoc['atributos_detalle']['codigoProducto']];

        $detalleVoucher['auxiliar'] = $esCuenta ? $RUTRecep : $codigoProducto;
        $detalleVoucher['glosa'] = utf8_encode($detalleDoc['descripcion']);

        $manejaInventario = $detalleDoc['sw_inventario']=="1";

        if($esCuenta){
            // contabilizar venta
            $detalleVoucher['codigo_cuenta'] = $codigoProducto;
            $detalleVoucher['operacion'] = $operacionesVoucher['venta'];
            $detalleVoucher['monto'] = $esVentaBruta && !$exento ? round($detalleDoc["subtotal"]) : $detalleDoc["subtotal"];
            //   $detalleVoucher['monto'] = $esVentaBruta && !$exento ? round($detalleDoc["subtotal"]/1.19) : $detalleDoc["subtotal"];
            $subtotal[$exento] += $detalleVoucher['monto'];

            @VoucherDetalle($voucher['folio'], $voucher['fecha'], $detalleVoucher['codigo_cuenta'], $voucher['documento']['tipo'], $folio, $voucher['tipo'], $voucher['fecha_vencimiento'], $detalleVoucher['auxiliar'], $detalleVoucher['operacion'], $detalleVoucher['monto'], $centro_costo="", $centro_ingreso="", $id_proyecto="", str_replace("'","",$detalleVoucher['glosa']), $id_activofijo="", $sw_auditar="", $voucher['observaciones']);
            continue;
        }

        $cuentasVoucher['venta'] = $centros_negocios[$detalleDoc['id_centroingreso']]["cuenta_ganancia"];
        $cuentasVoucher['costo'] = $cod_sii != 52 && $cod_sii != 50 ?
                        $centros_negocios[$detalleDoc['id_centroingreso']]["cuenta_costo"] : //si no es guia
                        $infoDoc['cod_cuenta']; //si es guia
        $cuentasVoucher['existencia'] = $origenDocumento != $desdeGuia ?
                        $centros_negocios[$detalleDoc['id_centroingreso']]["cuenta_existencia"] : // si no viene de guia
                        $infoGuia['cod_cuenta']; // si viene de guia

        // contabilizar impuesto adicional
        $tieneImpuesto = array_key_exists('impuesto_adicional_monto', $detalleDoc) && $detalleDoc['impuesto_adicional_monto'] > 0;
        $impAplicaVenta = false;

        if($tieneImpuesto && !$exento){ // si tiene impuesto, es afecto
            // obtener la cuenta contable asociada al codigo impuesto adicional
            $sqq = "SELECT documentos_aplica,codigo_cambio,nombre from tbl_sii_otrosimpuestos where codigo = '{$detalleDoc['impuesto_adicional_codigo']}'";
            $rss = EjecutarSql($sqq);
            $cuenta_cf = mysql_result($rss,0,0);
            $cuenta_df = mysql_result($rss,0,1);
            $nombre = mysql_result($rss, 0, 2);
            $impAplicaVenta = $cuenta_df != '0';

            $detalleVoucher['monto'] = $detalleDoc['impuesto_adicional_monto'];
            // aplica descuento global
            $detalleVoucher['monto'] -= round($detalleVoucher['monto'] * $porcDescuentoGlobal[$exento]);
            $detalleVoucher['glosa'] = utf8_encode($nombre);
            $impuestoAdicional[$exento] += $detalleVoucher['monto'];

            if($cuenta_df > 0 && !in_array($cod_sii, array(50, 52))){ // tiene cuenta conf. y no es guia

                $detalleVoucher['codigo_cuenta'] = $cuenta_df;
                $detalleVoucher['operacion'] = $operacionesVoucher['impuestoAdicional'];
                $detalleVoucher['auxiliar'] = $cuenta_df;
                @VoucherDetalle($voucher['folio'], $voucher['fecha'], $detalleVoucher['codigo_cuenta'], $voucher['documento']['tipo'], $folio, $voucher['tipo'], $voucher['fecha_vencimiento'], $detalleVoucher['auxiliar'], $detalleVoucher['operacion'], $detalleVoucher['monto'], $centro_costo="", $centro_ingreso="", $id_proyecto="", str_replace("'","",$detalleVoucher['glosa']), $id_activofijo="", $sw_auditar="", $voucher['observaciones']);
            }
        }

        $detalleVoucher['auxiliar'] = $esCuenta ? $RUTRecep : $codigoProducto;
        $detalleVoucher['glosa'] = utf8_encode($detalleDoc['descripcion']);

        // contabilizar venta
        $detalleVoucher['codigo_cuenta'] = $cuentasVoucher['venta'];
        $detalleVoucher['operacion'] = $operacionesVoucher['venta'];

        if($impAplicaVenta && $esVentaBruta){
            $detalleDoc['subtotal'] -= $detalleDoc['impuesto_adicional_monto'];
        }
        //calculo de neto
        $detalleVoucher['monto'] = $esVentaBruta && !$exento ? round($detalleDoc["subtotal"]) : $detalleDoc["subtotal"];
        //$detalleVoucher['monto'] = $esVentaBruta && !$exento ? round($detalleDoc["subtotal"]/1.19) : $detalleDoc["subtotal"];
        // aplica descuento global
        $detalleVoucher['monto'] -= round($detalleVoucher['monto'] * $porcDescuentoGlobal[$exento]);
        $subtotal[$exento] += $detalleVoucher['monto'];

        if(!in_array($cod_sii, array(50,52))){ // si no es guia contabilizar
            @VoucherDetalle($voucher['folio'], $voucher['fecha'], $detalleVoucher['codigo_cuenta'], $voucher['documento']['tipo'], $folio, $voucher['tipo'], $voucher['fecha_vencimiento'], $detalleVoucher['auxiliar'], $detalleVoucher['operacion'], $detalleVoucher['monto'], $centro_costo="", $centro_ingreso="", $id_proyecto="", str_replace("'","",$detalleVoucher['glosa']), $id_activofijo="", $sw_auditar="", $voucher['observaciones']);
        }


        if( !in_array($cod_sii, array(31,34,38,41)) ){
          // contabilizar costo
          $detalleVoucher['codigo_cuenta'] = $cuentasVoucher['costo'];
          $detalleVoucher['operacion'] = $operacionesVoucher['costo'];
          $detalleVoucher['monto'] = round($detalleDoc[$infoDoc['atributos_detalle']['pmp']] * $detalleDoc['cantidad']);

          @VoucherDetalle($voucher['folio'], $voucher['fecha'], $detalleVoucher['codigo_cuenta'], $voucher['documento']['tipo'], $folio, $voucher['tipo'], $voucher['fecha_vencimiento'], $detalleVoucher['auxiliar'], $detalleVoucher['operacion'], $detalleVoucher['monto'], $centro_costo="", $centro_ingreso="", $id_proyecto="", str_replace("'","",$detalleVoucher['glosa']), $id_activofijo="", $sw_auditar="", $voucher['observaciones']);

          // contabilizar existencias
          $detalleVoucher['codigo_cuenta'] = $cuentasVoucher['existencia'];
          $detalleVoucher['operacion'] = $operacionesVoucher['existencia'];

          @VoucherDetalle($voucher['folio'], $voucher['fecha'], $detalleVoucher['codigo_cuenta'], $voucher['documento']['tipo'], $folio, $voucher['tipo'], $voucher['fecha_vencimiento'], $detalleVoucher['auxiliar'], $detalleVoucher['operacion'], $detalleVoucher['monto'], $centro_costo="", $centro_ingreso="", $id_proyecto="", str_replace("'","",$detalleVoucher['glosa']), $id_activofijo="", $sw_auditar="", $voucher['observaciones']);
        }



        // mueve inventario ?
        if($detalleDoc['sw_inventario'] == "1"){
            // movimiento de stock si es nota credito = IN
            if(in_array($cod_sii, array(112))){
                $operacionStock = 'IN';
                $campoPrecio = $infoDoc['atributos_detalle']['pmp'];
            }
            else {
                $operacionStock = 'OUT';
                $campoPrecio = $infoDoc['atributos_detalle']['precioVenta'];
            }



            // documento no viene desde guia
            if($origenDocumento != $desdeGuia){ // 3=facturadirecto  2=facturarpedidos  1=facturarguias

                // disminuir reserva y aumenta disponible para movimiento de inventario
                $sql = "UPDATE tbl_productos SET ";
                $disponible = $detalleDoc['codigo_linea'] != "2" ? $detalleDoc['cantidad'] : 0; // si es kit disponible = 0
                if($origenDocumento == $desdePedido) {
                    if($detalleDoc['codigo_linea'] == "2") { //si es kit
                        $sql .= "pendiente = GREATEST(0, pendiente - {$detalleDoc['cantidad']}), ";
                    }
                    else {
                        $x = "SELECT pendiente FROM tbl_notaspedido_detalle WHERE folio = {$documento[$infoDoc['atributos']['folioNotaPedido']]} AND {$detalleDoc[$infoDoc['atributos_detalle']['codigoProducto']]}";
                        $y = EjecutarSql($x);
                        $pendiente = (int) mysql_result($y,0,0);
                        // var_dump($pendiente);
                        if($pendiente>0){
                          $sql .= "pendiente = GREATEST(0, pendiente - {$pendiente}), reserva = GREATEST(0, reserva - ({$detalleDoc['cantidad']}-{$pendiente})), ";
                        }else{
                          $sql .= "reserva = GREATEST(0, reserva - {$detalleDoc['cantidad']}), ";
                        }
                    }
                }
                $sql .= "disponible = disponible + {$disponible}
                WHERE codigo_producto = '{$codigoProducto}'";

                if(!EjecutarSql($sql)){
                    echo "Error Sql: " . mysql_error();
                    return false;
                }



                if($detalleDoc['codigo_linea'] == "2"){ //si es kit

                    $sql = "SELECT rd.codigo, rd.cantidad, rd.unitario, p.pmp
                    FROM tbl_recetas_detalle rd
                    JOIN tbl_productos p
                    ON p.codigo_producto = rd.codigo
                    WHERE rd.codigo_final='{$codigoProducto}'
                    ORDER BY rd.id_item ASC";
                    $kitQuery = EjecutarSql($sql);

                    if(!$kitQuery){
                        echo "Error Sql: " . mysql_error();
                        return false;
                    }

                    $sumacosto = 0;
                    while($detalleKit = mysql_fetch_array($kitQuery)) {
                        $cantidad = $detalleKit['cantidad'] * $detalleDoc['cantidad'];
                        // disminuir reserva y aumenta disponible para movimiento de inventario
                        if($origenDocumento == $desdePedido) {
                            $sql = "UPDATE tbl_productos SET reserva = GREATEST(0, reserva - GREATEST(0,{$cantidad} - pendiente))
                            , pendiente = GREATEST(0,pendiente - {$cantidad})
                            , disponible = disponible + {$cantidad}
                            WHERE codigo_producto = '{$detalleKit['codigo']}'";
                            if(!EjecutarSql($sql)){
                                echo "Error Sql: " . mysql_error();
                                return false;
                            }
                        }
                        // mueve existencia componentes kit
                        TarjetaExistencia($detalleKit['codigo'], $cantidad, $detalleKit['pmp'], $operacionStock, $infoDoc['codigo'], $folio, $documento[$infoDoc['atributos']['fechaFacturacion']], $documento['rut']);
                        // rebaja de bodega
                        TarjetaBodega($bodega['id'], $bodega['zona'], $detalleKit['codigo'], $cantidad, $operacionStock, $infoDoc['codigo'], $folio, $documento[$infoDoc['atributos']['fechaFacturacion']], $documento['rut']);
                        $sumacosto += $detalleKit['pmp'] * $detalleKit['cantidad'];
                    }
                    mysql_free_result($kitQuery);
                    if(in_array($cod_sii, array(112))){
                        $operacion = 'IN';
                        $operacionStock = 'OUT';
                    }
                    else {
                        $operacion = $operacionStock == 'IN' ? 'OUT' : 'IN';
                    }
                    // mueve existencia kit
                    TarjetaExistencia($codigoProducto, $detalleDoc['cantidad'], $sumacosto, $operacion, $infoDoc['codigo'], $folio, $documento[$infoDoc['atributos']['fechaFacturacion']], $documento['rut']);
                    // mueve existencia bodega kit
                    TarjetaBodega($bodega['id'], $bodega['zona'], $codigoProducto, $detalleDoc['cantidad'], $operacion, $infoDoc['codigo'], $folio, $documento[$infoDoc['atributos']['fechaFacturacion']], $documento['rut']);
                }// FIN KIT

                // mueve existencia
                TarjetaExistencia($codigoProducto, $detalleDoc['cantidad'], $detalleDoc[$campoPrecio], $operacionStock, $infoDoc['codigo'], $folio, $documento[$infoDoc['atributos']['fechaFacturacion']], $documento['rut']);
                // mueve existencia bodega
                TarjetaBodega($bodega['id'], $bodega['zona'], $codigoProducto, $detalleDoc['cantidad'], $operacionStock, $infoDoc['codigo'], $folio, $documento[$infoDoc['atributos']['fechaFacturacion']], $documento['rut']);
            } //fin documento directo

        }

        // si viene de nota de pedido modificar reservas del detalle del pedido
        if($origenDocumento == $desdePedido ){
            // disminuir reserva y aumenta facturado para detalle de pedido
            $sql = "UPDATE tbl_notaspedido_detalle SET ";
            if( $manejaInventario ){
              if($detalleDoc['codigo_linea'] == "2"){ //si es kit
                $sql .= "reserva = GREATEST(0, reserva - {$detalleDoc['cantidad']}) , pendiente = GREATEST(0, pendiente - {$detalleDoc['cantidad']}), ";
              }else{
                //se valida stock del producto
                // if( $detalleDoc['disponible']>$detalleDoc['cantidad'] ){
                //     $sql .= "reserva = GREATEST(0, reserva - {$detalleDoc['cantidad']})";
                // }else{
                $sql .= "reserva = GREATEST(0, reserva - {$detalleDoc['cantidad']} + pendiente), pendiente = GREATEST(0, pendiente - {$detalleDoc['cantidad']}), ";
                // }
              }
            }
            // $sql .= ", facturado = facturado + {$detalleDoc['cantidad']}
            $sql .= "facturado = cantidad
            WHERE codigo = '{$codigoProducto}'
            AND folio = '{$documento['folio_notaventa']}'";
            // echo $sql;
            if(!EjecutarSql($sql)){
                echo "Error Sql: " . mysql_error();
                return false;
            }
        }

        if( $origenDocumento == $desdeGuia ){
          if( !in_array($cod_sii,array(112)) ){
            $folioGuia = $detalleDoc['folio_guiadespacho'];
            $atrGuia = $infoGuia['atributos'];
            $atrDG = $infoGuia['atributos_detalle'];

            //$sql = "SELECT FROM $infoGuia['tabla_detalle'] WHERE folio_guia";
            $sql = "UPDATE {$infoGuia['tabla_detalle']} gdd
                          JOIN {$infoGuia['tabla']} gd ON gdd.{$atrDG['idEncabezado']}=gd.{$atrGuia['id']}
                          SET gdd.{$atrDG['facturado']} = gdd.{$atrDG['facturado']}+{$detalleDoc['cantidad']}
                          WHERE gd.{$atrGuia['folio']}={$folioGuia}";
            $k =  EjecutarSql($sql);
            if(!$k){ echo $sql."   ".mysql_error(); }
          }
        }

    }

    $cuentaDocumentoSii = $infoDoc['cod_cuenta'];

    // $cuentaMedioPago = 0;
    // if(is_array($infoDoc['atributos'])
    // && array_key_exists('idMedioPago', $infoDoc['atributos'])
    // ){
    //     $medioPago = $documento[$infoDoc['atributos']['idMedioPago']]; // $documento['id_condiciones_venta'];
    //     if($medioPago > 0){
    //         $sql = "SELECT codigo_cuenta FROM tbl_condicionespago WHERE id_formapago='$medioPago'";
    //         $cuentaQuery = EjecutarSql($sql);
    //         $cuentaMedioPago = mysql_result($cuentaQuery,0,0);
    //     }
    // }

    // ajuste de total (diferencia redondeo decimales)
    if($esVentaBruta){ // 1 si es venta bruta
        $bruto = $documento['bruto'];
        $iva = $bruto
          - array_sum($subtotal)
          - array_sum($impuestoAdicional);
    }
    else {
        $iva =0; //round($subtotal[0] * 0.19);
        $bruto = array_sum($subtotal)
            + $iva
            + array_sum($impuestoAdicional);
    }

    if(!in_array($cod_sii, array(50,52))){ // si no es guia contabilizar

        // contabilizar cuenta (bruto)
        $detalleVoucher = [
            'codigo_cuenta' => $cuentaDocumentoSii,
            'operacion' => $operacionesVoucher['neto'],
            'monto' => $bruto,
            'glosa' => "{$infoDoc['nombre']} VENTA {$folio}",
            'auxiliar' => $voucher['auxiliar'],
        ];

        if(in_array($cod_sii, array(112))){ // nota credito o debito
            $infoRef = leerDocumentoSii('V', "110"); //$documento[$infoDoc['atributos']['tipoDocumentoReferencia']]);
            $detalleVoucher['glosa'] .= " [{$infoRef['codigo']} {$documento[$infoDoc['atributos']['folioReferencia']]}]";
        }

        @VoucherDetalle($voucher['folio'], $voucher['fecha'], $detalleVoucher['codigo_cuenta'], $voucher['documento']['tipo'], $folio, $voucher['tipo'], $voucher['fecha_vencimiento'], $detalleVoucher['auxiliar'], $detalleVoucher['operacion'], $detalleVoucher['monto'], $centro_costo="", $centro_ingreso="", $id_proyecto="", str_replace("'","",$detalleVoucher['glosa']), $id_activofijo="", $sw_auditar="", $voucher['observaciones']);

        // contabilizar iva
        $detalleVoucher = [
            'codigo_cuenta' => $CONFIG['contabilidad_cuenta_iva'], // se debe generar la caonfiguracion para la cuenta iva debito fiscal
            'operacion' => $operacionesVoucher['iva'],
            'monto' => $iva,
            'glosa' => "{$infoDoc['nombre']} VENTA {$folio}",
            'auxiliar' => $voucher['auxiliar'],
        ];

        if(in_array($cod_sii, array(112))){ // nota credito o debito
            $detalleVoucher['glosa'] .= " [{$infoRef['codigo']} {$documento[$infoDoc['atributos']['folioReferencia']]}]";
        }

        @VoucherDetalle($voucher['folio'], $voucher['fecha'], $detalleVoucher['codigo_cuenta'], $voucher['documento']['tipo'], $folio, $voucher['tipo'], $voucher['fecha_vencimiento'], $detalleVoucher['auxiliar'], $detalleVoucher['operacion'], $detalleVoucher['monto'], $centro_costo="", $centro_ingreso="", $id_proyecto="", $detalleVoucher['glosa'], $id_activofijo="", $sw_auditar="", $voucher['observaciones']);
    }

    //Si es NC corrige textos, se elimina el voucher contable
    if( in_array($cod_sii, array(112)) && $documento[$infoDoc['atributos']['codigoReferencia']] == 2 ){
      $sql = EjecutarSql("DELETE FROM tbl_librodiario WHERE folio={$voucher['folio']}");
      $sql = EjecutarSql("DELETE FROM tbl_transacciones WHERE folio={$voucher['folio']}");
    }
    // set procesado
    $sql="UPDATE {$infoDoc['tabla']} SET estado = 'PR'
    , estado_sii = '0'
    , {$infoDoc['campo_folio']} = '$folio'
    , {$infoDoc['atributos']['iva']} = '$iva'
    , {$infoDoc['atributos']['neto']} = '{$subtotal[0]}'
    , {$infoDoc['atributos']['netoExento']} = '{$subtotal[1]}'
    , {$infoDoc['atributos']['bruto']} = '$bruto'
    -- , {$infoDoc['atributos']['sumaAfecto']} = '{$subtotal[0]}'
    -- , {$infoDoc['atributos']['sumaExento']} = '{$subtotal[1]}'
    WHERE {$infoDoc['campo_id']} = '$id'";

    if(!EjecutarSql($sql)){
        echo "Error Sql: " . mysql_error();
        return false;
    }
    // set procesado detalle
    $sql="UPDATE {$infoDoc['tabla_detalle']} SET estado = 'PR'
    , folio_factura = '$folio'
    WHERE {$infoDoc['atributos_detalle']['idEncabezado']} = '$id'";

    if(!EjecutarSql($sql)){
        echo "Error Sql: " . mysql_error();
        return false;
    }

    // valida disponibilidad y consume
    if($cod_sii != 48){ //el documento tipo 48 (boleta transbank no lleva folio sii)
        consumirFolio($cod_sii, $folio);
    }

    return true;
}
