<?php
require_once('checkStock.php');
require_once($basePath.'/contabilidad_mantencion_documentos_sii/librerias/leer.php');

function capturarItem($post){
	$documento = [];
	foreach ($post['documento'] as $attr => $val) {
		$documento[$attr] = (int) utf8_decode(trim($val));
	}
	foreach ($post['descuentos'] as $attr => $val) {
		$documento['descuentos'][$attr] = [
			'tipo' => $val['tipo'],
			'monto' => (float) $val['monto'],
		];
	}
	$item = [
	  'documento' => $documento,
	];
	foreach ($post['item'] as $attr => $val) {
		if($val != ""){
			$item[$attr] = $val;
		}
		elseif (is_string($val) && $val == "") {
			$item[$attr] = NULL;
		}
	}
	$item['monto']['valor'] = (float) utf8_decode(trim($post['item']['monto']['valor']));
	$item['monto']['exento'] = (float) utf8_decode(trim($post['item']['monto']['exento']));
	$item['monto']['descuentoPorc'] = (float) utf8_decode(trim($post['item']['monto']['descuentoPorc']));
  //$item['id_lista_de_precios'] = (float)$post['id_listaprecios'];



	return $item;
}

function capturarParametros($post){
	$params = [
		'accion' => utf8_decode(trim($post['accion'])),
		'ventaBruta' => (boolean) utf8_decode(trim($post['ventaBruta'])),
		'ventaSinStock' => (boolean) utf8_decode(trim($post['ventaSinStock'])),
	];

	return $params;
}
//
function obtenerPmp($codigo){
  $sql = "SELECT pmp FROM tbl_inventario WHERE codigo_producto = '{$codigo}' ORDER BY id_linea DESC LIMIT 1";
  $query = EjecutarSql($sql);
  if(!$query){
    echo "Error al obtener el PMP!.";
    return 0;
  }
  $pmp = mysql_result($query, 0);
  return $pmp <= 0 ? 0 : $pmp;
}
//
function obtenerUnidadMedida($codigo){
  $unidad = [
    'codigo' => 'UN',
    'descripcion' => 'UNIDAD',
  ];
  $sql = "SELECT u.codigo_unidad, u.descripcion
    FROM tbl_productos p
    JOIN tbl_unidades u
    ON p.unidad_medida = u.id
    WHERE p.codigo_producto = '{$codigo}'";
  $query = EjecutarSql($sql);
  if(!$query){
    echo "[W]No se pudo obtener unidad medida!";
    return $unidad;
  }
  $tieneUnidad = mysql_num_rows($query) > 0;
  if($tieneUnidad){
    $data = mysql_fetch_array($query);
    $unidad['codigo'] = mb_strtoupper(utf8_encode($data['codigo_unidad']));
    $unidad['descripcion'] = mb_strtoupper(utf8_encode($data['descripcion']));
  }
  return $unidad;
}
//
function aplicarDescuentos($item){
  $monto = $item['monto'];
  $monto['total'] = $monto['valor'] * $item['cantidad'];
  $monto['descuentoPesos'] = round($monto['total'] * ($monto['descuentoPorc'] / 100));
  $monto['total'] -= $monto['descuentoPesos'];
  $item['monto'] = $monto;
  return $item;
}
//
function calcularImpuestoAdicional($item, $ventaBruta, $impBase = 19){
  $codigo = $item['codigo'];
  $porcImpuesto = $impBase;
	$impuesto = [
		'codigo' => '',
		'tasa' => 0,
		'cuenta' => '',
		'valor' => 0,
	];
	if($item['monto']['exento']){
		return $impuesto;
	}
  $sql = "SELECT imp.codigo, imp.tasa, imp.codigo_cambio cuenta_venta
    FROM tbl_productos p
    JOIN tbl_sii_otrosimpuestos imp
    ON p.id_impuesto = imp.id
    WHERE p.codigo_producto = '{$codigo}'";
  $query = EjecutarSql($sql);
  $tieneImpuesto = mysql_num_rows($query) > 0;

  if($tieneImpuesto){
    $data = mysql_fetch_array($query);
    $aplicaVenta = $data['cuenta_venta'] != '0';

    if($aplicaVenta){
      $impuesto = [
        'codigo' => utf8_encode($data['codigo']),
        'tasa' => utf8_encode($data['tasa']),
        'cuenta' => utf8_encode($data['cuenta_venta']),
        'valor' => 0,
      ];
      $neto = $item['monto']['total'];

      if($ventaBruta){
				$porcImpuesto += $impuesto['tasa']; // adicional
				$porcImpuesto = ($porcImpuesto / 100) +1;
				$neto /= $porcImpuesto;
			}

			$impuesto['valor'] = round($neto * ($impuesto['tasa'] / 100));

    }
  }

  return $impuesto;
}

function validarStock($params, $item){
	//traer detalle para validacion
	$sql = "SELECT p.codigo_producto, p.codigo_linea, r.folio id_receta,p.sw_inventario, {$item['cantidad']} cantidad
	FROM `tbl_productos` p
	LEFT JOIN `tbl_recetas` r ON p.codigo_producto=r.codigo_final
	WHERE p.codigo_producto = '{$item['codigo']}'";
	$query = EjecutarSql($sql);
	if(!$query){
			echo "Error Sql: ". mysql_error();
			return false;
	}
	$items = array();
	$r = mysql_fetch_array($query);
	//si es receta (kit)
	if($r['codigo_linea'] == 2){
			$sql = "SELECT rd.codigo, rd.cantidad, p.id_centroingreso
			FROM `tbl_recetas_detalle` rd
			LEFT JOIN `tbl_productos` p ON rd.codigo = p.codigo_producto
			WHERE rd.folio = {$r['id_receta']}";
			$recetaQuery = EjecutarSql($sql);
			while($detReceta = mysql_fetch_array($recetaQuery)){
					//cantidad de items en el kit por la cantidad de kits
					$cantidad = $detReceta['cantidad'] * $r['cantidad'];
					if(array_key_exists($detReceta['codigo'], $items)){
							$items[$detReceta['codigo']] += $cantidad;
					}
					else {
							$items[$detReceta['codigo']] = (int) $cantidad;
					}
			}
	}
	//regular
	else{
			if(array_key_exists($r['codigo_producto'], $items)){
					$items[$r['codigo_producto']] += $r['cantidad'];
			}
			else {
					$items[$r['codigo_producto']] = (int) $r['cantidad'];
			}
	}

	if(!in_array($item['documento']['tipo'], array(61,60))){
		//si el producto maneja inventario
		if($r['sw_inventario']==1){
			$errores = checkStock($items, $item['bodega']);
			if(count($errores) > 0){
					$mensaje = "Error\n";
					foreach($errores as $c => $e){
							$mensaje .= "[{$c}] {$e}";
					}
					echo $mensaje;
					return false;
			}
		}
	}
	return true;
}

function guardarItemVenta($params, $item){

  $infoDoc = leerDocumentoSii('E', $item['documento']['tipo']);
	if( !$infoDoc['existe'] ){
		  $infoDoc = leerDocumentoSii('E', $item['documento']['tipo']);
      if( !$infoDoc['existe'] ){
				echo "\nDebe seleccionar un tipo de documento.". $item['documento']['tipo']."\n";
		    return false;
			}
	}
  $attrTabla = $infoDoc['atributos_detalle'];
	$params['tabla_detalle'] = $infoDoc['tabla_detalle'];
	$params['campoCodigoProducto'] = $attrTabla['codigoProducto'];
	unset($infoDoc);


	if(!$params['ventaSinStock']){
		$aptoVenta = validarStock($params, $item);
		if(!$aptoVenta){
			return false;
		}
	}
  $item['monto']['pmp'] = obtenerPmp($item['codigo']);
  $item['monto']['cpp'] = $item['monto']['pmp'] * $item['cantidad'];
  $item['unidadMedida'] = obtenerUnidadMedida($item['codigo']);
  $item = aplicarDescuentos($item);

  if($item['tipo'] != 'C'){
    $item['impuesto'] = calcularImpuestoAdicional($item, $params['ventaBruta']);
  }


	//Validar solo servicios en Documentos Exentos
	if( in_array( $item['documento']['tipo'] , array('41','38','34','31') ) && $item['tipo'] == 'P'){
		echo "\nUn documento exento no puede incluir productos!\n";
		return false;
	}

	$swExento = in_array( $item['documento']['tipo'] , array('41','34','31') ) ? '1' : $item['monto']['exento'];
  $data = [
    'idEncabezado' => $item['documento']['id'],
    'idItem' => $item['numero'],
    'tipoItem' => $item['tipo'],
    'codigoProducto' => $item['codigo'],
    'descripcion' => str_replace(array("'","\""),"",$item['nombre']),
    'cantidad' => $item['cantidad'],
    'precioReferencial' => $item['monto']['valor'],
    'precioVenta' => $item['monto']['valor'],
    'subtotal' => $item['monto']['total'],
    'subtotalFinal' => $item['monto']['total'],
    'observaciones' => $item['descripcion'],
    'descuentoPorc' => $item['monto']['descuentoPorc'],
    'descuentoPesos' => $item['monto']['descuentoPesos'],
    'swExento' => $swExento,
    'unidadMedida' => $item['unidadMedida']['codigo'],
    'montoImpuestoAdicional' => $item['impuesto']['valor'],
    'codigoImpuestoAdicional' => $item['impuesto']['codigo'],
    'tasaImpuestoAdicional' => $item['impuesto']['tasa'],
    'pmp' => $item['monto']['pmp'],
    'cpp' => $item['monto']['cpp'],
  ];



  // armar consulta
  if($params['accion'] == "I"){
    $columnas = "(";
    $values = "(";
    $i = 0;
    foreach ($data as $attr => $value) {


      if($i == 0){


          $columnas .= $attrTabla[$attr];



        $values .= isset($value) ? "'{$value}'" : "''";
      }
      else {
        $columnas .= ", " . $attrTabla[$attr];
        $values .= isset($value) ? ", '{$value}'" : ", ''";
      }
      $i += 1;
    }
    $columnas .= ")";
    $values .= ")";




    $sql = "INSERT INTO {$params['tabla_detalle']} {$columnas}
      VALUES {$values}";




  }

  if($params['accion'] == "M"){
    $sql = "UPDATE {$params['tabla_detalle']} SET ";
    $i = 0;
    $where = " WHERE ";
    $where .= "{$attrTabla['idEncabezado']} = '{$data['idEncabezado']}' ";
    unset($data['idEncabezado']);
    $where .= "AND {$attrTabla['idItem']} = '{$data['idItem']}' ";
    unset($data['idItem']);
    foreach ($data as $attr => $value) {
      if($i == 0){
        $sql .= "{$attrTabla[$attr]} = '{$value}'";
      }
      else {
        $sql .= ", {$attrTabla[$attr]} = '{$value}'";
      }
      $i += 1;
    }
    $sql .= $where;
  }
// echo $sql;
  $query = EjecutarSql($sql);
  if(!$query){
    echo "No se pudo agregar Item!\n";
    echo mysql_error();
    return false;
  }
  return true;
}


function eliminarItemVenta($item){
  $infoDoc = leerDocumentoSii('E', $item['documento']['tipo']);
  $attrTabla = $infoDoc['atributos_detalle'];
	$params['tabla_detalle'] = $infoDoc['tabla_detalle'];
  unset($infoDoc);

  # Eliminar el item de la base de datos
  $sql = "DELETE FROM {$params['tabla_detalle']}
  WHERE {$attrTabla['idEncabezado']} = '{$item['documento']['id']}'
  AND {$attrTabla['idItem']} = '{$item['numero']}'";

  $query = EjecutarSql($sql);
  if($query){ // si se elimino
    $sql = "UPDATE {$params['tabla_detalle']}
    SET {$attrTabla['idItem']} = ({$attrTabla['idItem']} -1)
    WHERE {$attrTabla['idEncabezado']} = {$item['documento']['id']}
    AND {$attrTabla['idItem']} > {$item['numero']}";
    $query = EjecutarSql($sql);
  }
  return $query;
}
