<?php

function checkCentroNegocio($idCentro){
    $codigos = array_keys($idCentro);
    $codigos = implode(',', $codigos);

    $sql = "SELECT cn.id_centroingreso
        , cn.nombre nombre_centro
        , cn.cuenta_mercaderia
        , cn.cuenta_venta
        , cn.cuenta_costo
        , GROUP_CONCAT(pc.codigo_cuenta SEPARATOR ';') codigos
        , GROUP_CONCAT(pc.tipo_cuenta SEPARATOR ';') tipos
    FROM `tbl_plandecuentas` pc
    LEFT JOIN `tbl_centrosdeingreso` cn
        ON pc.codigo_cuenta = cn.cuenta_mercaderia
        OR pc.codigo_cuenta = cn.cuenta_venta
        OR pc.codigo_cuenta = cn.cuenta_costo
    WHERE cn.id_centroingreso IN ({$codigos})
    GROUP BY cn.id_centroingreso, nombre_centro";

    $errores = array();
    $query = EjecutarSql($sql);
    while($r = mysql_fetch_array($query)){

        $tipos = explode(";", $r['tipos']);
        $codigos = explode(";", $r['codigos']);
        $cuentas = array();
        $err = array();
        $i = 0;
        foreach($tipos as $t){
            switch($t){
                case "A":
                    $cuentas['existencia'] = $codigos[$i];
                    break;
                case "R":
                    $cuentas['costo'] = $codigos[$i];
                    break;
                case "G":
                    $cuentas['venta'] = $codigos[$i];
                    break;
            }
            $i++;
        }

        if(!array_key_exists('venta', $cuentas)){
            $err[] = "\t- La cuenta de venta {$r['cuenta_venta']} no existe en el sistema.\n";
        }
        if(!array_key_exists('costo', $cuentas)){
            $err[] = "\t- La cuenta de costo {$r['cuenta_costo']} no existe en el sistema.\n";
        }
        if(!array_key_exists('existencia', $cuentas)){
            $err[] = "\t- La cuenta de existencia {$r['cuenta_mercaderia']} no existe en el sistema.\n";
        }

        if(count($err) > 0){
            $errores[$r['id_centroingreso']] = [
                'nombre' => $r['nombre_centro'],
                'errores' => $err,
            ];
        }
    }
    return $errores;

}
