<?php
/* Change to the correct path if you copy this example! */
require __DIR__ . '/../../autoload.php';
use Mike42\Escpos\Printer;
use Mike42\Escpos\EscposImage;
use Mike42\Escpos\PrintConnectors\NetworkPrintConnector;

/* Most printers are open on port 9100, so you just need to know the IP 
 * address of your receipt printer, and then fsockopen() it on that port.
 */
try {
    $connector = new NetworkPrintConnector("192.168.192.7", 9100);
    
    /* Print a "Hello world" receipt" */
    $printer = new Printer($connector);
    

    $tux = EscposImage::load("logo_400.png", false);
    
    $printer -> graphics($tux);    
    
    $printer -> setFont(Printer::FONT_A);
    $printer -> setJustification(Printer::JUSTIFY_CENTER);
    $printer -> setEmphasis(true);
    $printer -> text("RUT : 76.134.946-5\n");
    // 
    $printer -> setFont(Printer::FONT_B);
    $printer -> setJustification(Printer::JUSTIFY_CENTER);
    $printer -> setEmphasis(false);
    $printer -> text("ADMIN. DE SUPERMERCADOS EXPRESS LTDA\n");
    $printer -> text("AV. PDTE. EDO. FREI MONTALVA 8301, QUILICURA\n");
    $printer -> text("SUC.  AV. MEXICO 1577\n");
    $printer -> text("GRANDES ESTABLECIMIENTOS VENTA DE ALIMENTOS, COMERCIO AL POR MENO DE DIARIOS Y REVISTAS, OTROS TIPOS INTERMEDIACION MONETARIA NCP\n");
    $printer -> text("VENTA POR CUENTA DE WALMART CHILE S.A.\n\n");
    // 
    $printer -> setFont(Printer::FONT_A);
    $printer -> setJustification(Printer::JUSTIFY_CENTER);     
    $printer -> setEmphasis(true);
    $printer -> text("========================================\n");
    $printer -> text("BOLETA ELECTRÓNICA Nº 77788999\n");
    $printer -> text("Fecha: 19-10-2016    Hora: 22:02:22\n");
    $printer -> text("========================================\n");
    //
    $printer -> setFont(Printer::FONT_B);    
    $printer -> setJustification(Printer::JUSTIFY_LEFT);  
    $printer -> setEmphasis(false);
    $printer -> feed();
    $printer -> text("Atendido por: Juan Perez Gonzalez\n");
    $printer -> feed();
    //
    $printer -> setFont(Printer::FONT_B);    
    $printer -> setJustification(Printer::JUSTIFY_CENTER);     
    $printer -> setEmphasis(true);
    $printer -> text("* * * * * * * DETALLE DE ARTICULOS * * * * * * * \n");
    //
    $printer -> setFont(Printer::FONT_B);    
    $printer -> setJustification(Printer::JUSTIFY_LEFT);   
    $printer -> setEmphasis(false);
    $printer -> text("1234567890123 2 X $2.490 PAPELUCHO CUENTA CUENTOS $4.950\n");
    $printer -> text("1234567890123 2 X $2.490 PAPELUCHO CUENTA CUENTOS $4.950\n");
    $printer -> text("1234567890123 2 X $2.490 PAPELUCHO CUENTA CUENTOS $4.950\n");
    $printer -> text("1234567890123 2 X $2.490 PAPELUCHO CUENTA CUENTOS $4.950\n");
$printer -> feed();
$printer -> feed();
    //
    $printer -> setFont(Printer::FONT_A);
    $printer -> setJustification(Printer::JUSTIFY_LEFT);
    $printer -> setEmphasis(true);
    $printer -> text("========================================\n");
    $printer -> text("TOTAL   $ 14.950\n");
    $printer -> text("EFECTIVO   $ 20.000\n");
    $printer -> text("VUELTO   $ 5.050\n");
    $printer -> text("========================================\n");


// Most simple example
 
$testStr = '<TED version="1.0"><DD><RE>96792430-K</RE><TD>33</TD><F>77247427</F><FE>2016-07-26</FE><RR>76606716-6</RR><RSR>FACTRONICA SPA </RSR><MNT>32541</MNT><IT1>TELEFONO INAL ENTEL AUTO PA </IT1><CAF version="1.0"><DA><RE>96792430-K</RE><RS>SODIMAC S A</RS><TD>33</TD><RNG><D>76509030</D><H>77509028</H></RNG><FA>2016-04-29</FA><RSAPK><M>2b+CLrGYFY7/5m4jmSXhWsWB7LyOhxv0uZABETZZztT3G1i8iy/ZnrdhoLIKXi0O8y7U+UBkaHzqb8MbD5tNnQ==</M><E>Aw==</E></RSAPK><IDK>300</IDK></DA><FRMA algoritmo="SHA1withRSA">YWm5bW3elattByzunyF4DYmjGIqxuE9O/gwzYq6ykCPnIpfC5q68W1MwxQNsuOvJBBXxGJkC4a78nyl14Spzdw==</FRMA></CAF><TSTED>2016-07-26T18:15:51</TSTED></DD><FRMT algoritmo="SHA1withRSA">NGaRcBXu+FjpQk9vh+dA51G38VES6jT3WHOAIFLS9FTweIIr2ufG68j8potCsR1LaNW2FFBPsfrwhNSOiJn+IQ==</FRMT></TED>';
$printer -> pdf417Code($testStr,2);

// 
$printer -> setFont(Printer::FONT_B);    
$printer -> setJustification(Printer::JUSTIFY_LEFT);   
$printer -> setEmphasis(false);
$printer -> text("Timbre Electrónico SII Res. 85 de 2011\n");
$printer -> text("Verifique documento en www.sii.cl\n");
$printer -> feed();

/// Pulse
//$printer -> pulse();
//   
$printer -> cut();
/* Close printer */
$printer -> close();

/*

// Demo that alignment is the same as text
$printer -> setJustification(Printer::JUSTIFY_CENTER);
$printer -> pdf417Code($testStr, 3, 3, 2);
$printer -> text("Same content, narrow and centred\n");
$printer -> setJustification();
$printer -> feed();

// Demo of error correction
 
$ec = array(0.1, 0.5, 1.0, 2.0, 4.0);
foreach ($ec as $level) {
    $printer -> pdf417Code($testStr, 3, 3, 0, $level);
    $printer -> text("Error correction ratio $level\n");
    $printer -> feed();
}

// Change size
 
$sizes = array(
    2 => "(minimum)",
    3 => "(default)",
    4 => "",
    8 => "(maximum)");
foreach ($sizes as $size => $label) {
    $printer -> pdf417Code($testStr, $size);
    $printer -> text("Module width $size dots $label\n");
    $printer -> feed();
}

// Change height
 
$sizes = array(
    2 => "(minimum)",
    3 => "(default)",
    4 => "",
    8 => "(maximum)");
foreach ($sizes as $size => $label) {
    $printer -> pdf417Code($testStr, 3, $size);
    $printer -> text("Height multiplier $size $label\n");
    $printer -> feed();
}

// Chage data column count
 
$columnCounts = array(
    0 => "(auto, default)",
    1 => "",
    2 => "",
    3 => "",
    4 => "",
    5 => "",
    30 => "(maximum, doesnt fit!)");
foreach ($columnCounts as $columnCount => $label) {
    $printer -> pdf417Code($testStr, 3, 3, $columnCount);
    $printer -> text("Column count $columnCount $label\n");
    $printer -> feed();
}

// Change options
 
$models = array(
    Printer::PDF417_STANDARD => "Standard",
    Printer::PDF417_TRUNCATED => "Truncated");
foreach ($models as $model => $name) {
    $printer -> pdf417Code($testStr, 3, 3, 0, 0.10, $model);
    $printer -> text("$name\n");
    $printer -> feed();
}

*/


    

/* Stuff around with left margin 
$printer -> setEmphasis(true);
$printer -> text("Left margin\n");
$printer -> setEmphasis(false);
$printer -> text("Default left\n");
foreach(array(1, 2, 4, 8, 16, 32, 64, 128, 256, 512) as $margin) {
    $printer -> setPrintLeftMargin($margin);
    $printer -> text("left margin $margin\n");
}
*/
// Reset left 
//$printer -> setPrintLeftMargin(0);

/* Stuff around with page width */
/*
$printer -> setEmphasis(true);
$printer -> text("Page width\n");
$printer -> setEmphasis(false);
$printer -> setJustification(Printer::JUSTIFY_RIGHT);
$printer -> text("Default width\n");
foreach(array(512, 256, 128, 64) as $width) {
    $printer -> setPrintWidth($width);
    $printer -> text("page width $width\n");
} 
*/
    

    
    //$printer -> cut();
    
 
    
    
    
/* Text 
$printer -> text("Hello world\n");
$printer -> cut();
*/






/* Line feeds  
$printer -> text("ABC");
$printer -> feed(7);
$printer -> text("DEF");
$printer -> feedReverse(3);
$printer -> text("GHI");
$printer -> feed();
$printer -> cut();

*/





/* Font modes  
$modes = array(
    Printer::MODE_FONT_B,
    Printer::MODE_EMPHASIZED,
    Printer::MODE_DOUBLE_HEIGHT,
    Printer::MODE_DOUBLE_WIDTH,
    Printer::MODE_UNDERLINE);
for ($i = 0; $i < pow(2, count($modes)); $i++) {
    $bits = str_pad(decbin($i), count($modes), "0", STR_PAD_LEFT);
    $mode = 0;
    for ($j = 0; $j < strlen($bits); $j++) {
        if (substr($bits, $j, 1) == "1") {
            $mode |= $modes[$j];
        }
    }
    $printer -> selectPrintMode($mode);
    $printer -> text("ABCDEFGHIJabcdefghijk\n");
}
$printer -> selectPrintMode(); // Reset
$printer -> cut();
*/









/* Underline 
for ($i = 0; $i < 3; $i++) {
    $printer -> setUnderline($i);
    $printer -> text("The quick brown fox jumps over the lazy dog\n");
}
$printer -> setUnderline(0); // Reset
$printer -> cut();
*/
/* Cuts 
$printer -> text("Partial cut\n(not available on all printers)\n");
$printer -> cut(Printer::CUT_PARTIAL);
$printer -> text("Full cut\n");
$printer -> cut(Printer::CUT_FULL);
*/
/* Emphasis 
for ($i = 0; $i < 2; $i++) {
    $printer -> setEmphasis($i == 1);
    $printer -> text("The quick brown fox jumps over the lazy dog\n");
}
$printer -> setEmphasis(false); // Reset
$printer -> cut();
*/
/* Double-strike (looks basically the same as emphasis) 
for ($i = 0; $i < 2; $i++) {
    $printer -> setDoubleStrike($i == 1);
    $printer -> text("The quick brown fox jumps over the lazy dog\n");
}
$printer -> setDoubleStrike(false);
$printer -> cut();
*/





/* Fonts (many printers do not have a 'Font C')
$fonts = array(
    Printer::FONT_A,
    Printer::FONT_B,
    Printer::FONT_C);
for ($i = 0; $i < count($fonts); $i++) {
    $printer -> setFont($fonts[$i]);
    $printer -> text("The quick brown fox jumps over the lazy dog\n");
}
$printer -> setFont(); // Reset
$printer -> cut();

 */


/* Justification  
$justification = array(
    Printer::JUSTIFY_LEFT,
    Printer::JUSTIFY_CENTER,
    Printer::JUSTIFY_RIGHT);
for ($i = 0; $i < count($justification); $i++) {
    $printer -> setJustification($justification[$i]);
    $printer -> text("A man a plan a canal panama\n");
}
$printer -> setJustification(); // Reset
$printer -> cut();
*/





/* Barcodes - see barcode.php for more detail  /
$printer -> setBarcodeHeight(80);
$printer->setBarcodeTextPosition(Printer::BARCODE_TEXT_BELOW);
$printer -> barcode("9876");
$printer -> feed();
$printer -> cut();
*/








/* Graphics - this demo will not work on some non-Epson printers  
try {
    $logo = EscposImage::load("resources/escpos-php.png", false);
    $imgModes = array(
        Printer::IMG_DEFAULT,
        Printer::IMG_DOUBLE_WIDTH,
        Printer::IMG_DOUBLE_HEIGHT,
        Printer::IMG_DOUBLE_WIDTH | Printer::IMG_DOUBLE_HEIGHT
    );
    foreach ($imgModes as $mode) {
        $printer -> graphics($logo, $mode);
    }
} catch (Exception $e) {
    // Images not supported on your PHP, or image file not found  
    $printer -> text($e -> getMessage() . "\n");
}
$printer -> cut();
*/






/* Bit image 
try {
    $logo = EscposImage::load("resources/escpos-php.png", false);
    $imgModes = array(
        Printer::IMG_DEFAULT,
        Printer::IMG_DOUBLE_WIDTH,
        Printer::IMG_DOUBLE_HEIGHT,
        Printer::IMG_DOUBLE_WIDTH | Printer::IMG_DOUBLE_HEIGHT
    );
    foreach ($imgModes as $mode) {
        $printer -> bitImage($logo, $mode);
    }
} catch (Exception $e) {
    // Images not supported on your PHP, or image file not found 
    $printer -> text($e -> getMessage() . "\n");
}
$printer -> cut();

*/






/* QR Code - see also the more in-depth demo at qr-code.php
$testStr = "Testing 123";
$models = array(
    Printer::QR_MODEL_1 => "QR Model 1",
    Printer::QR_MODEL_2 => "QR Model 2 (default)",
    Printer::QR_MICRO => "Micro QR code\n(not supported on all printers)");
foreach ($models as $model => $name) {
    $printer -> qrCode($testStr, Printer::QR_ECLEVEL_L, 3, $model);
    $printer -> text("$name\n");
    $printer -> feed();
}

 */

} catch (Exception $e) {
    echo "Couldn't print to this printer: " . $e -> getMessage() . "\n";
}
