;(function() {
    
//-----------------------------------------------------------------------------
// if audio is not available in this environment, create a fake one
//-----------------------------------------------------------------------------
if(!window.Audio) {
    window.Audio = function() {};
     Audio.prototype.load = Audio;
    Audio.prototype.play = Audio;
}

//-----------------------------------------------------------------------------
// return a beeper
//    sourceURL - the sound that the beeper should play
//-----------------------------------------------------------------------------
// This function returns another function, a beeper.  A beeper plays
// the sound it was created with, if passed no arguments.  If passed an
// argument, that argument should be a function.  In that case, the beeper
// will return a new function, which wraps the original function.  When that
// new function is invoked, it will play the sound the beeper was created with
// and then call the original function.
//-----------------------------------------------------------------------------
function createBeeper(soundURL) {
    
    // load the requested audio resource
    var audio = new Audio(soundURL);
    audio.load();
    audio.autoplay = false;
    
    // function returning a function which beeps and then executes the
    // passed in function.  The new function also has a property "original",
    // which is the original function, when you want to unwind the wrapper.
    function wrapper(originalFunction) {
        var result = function() {
            audio.play();
            var args = Array.prototype.slice.call(arguments);
            return originalFunction.apply(this, args);
        };
        
        result.original = originalFunction;
        
        return result;
    }
    
    // either play the sound, or wrap the requested function
    function beep(originalFunction) {
        if (originalFunction) {
            if ("function" != typeof originalFunction) {
                throw new TypeError("expecting a function");
            }
            
            return wrapper(originalFunction);
        }
        
        // didn't pass anything in, just play the sound
        audio.play();
    }
    
    // return the beep function
    return beep;
}

//-----------------------------------------------------------------------------
// install some globals
//-----------------------------------------------------------------------------
window.createBeeper = createBeeper;

//window.beep = createBeeper("http://muellerware.org/sounds/beepxxxxxxxx.wav");
//window.boop = createBeeper("http://muellerware.org/sounds/boopxxxxxxx.wav");
//window.beep = createBeeper("http://www.gnulinux.cl/erpx_system/snd_sistema/beep.wav");
//window.beep = createBeeper("http://www.gnulinux.cl/erpx_system/snd_sistema/boop.wav");

window.beep = createBeeper("../snd_sistema/snd_ok.wav");
window.boop = createBeeper("../snd_sistema/snd_error.wav");


})();

