<?php
##############################################################
##############################################################
##############################################################
#
#
# FACTRONICA_LIB_XML V.110620152327
# DESARROLLADOR: JOS PATRICIO DAZ ZIGA
# EMAIL: PATRICIODIAZWEBMASTER AT GMAIL DOT COM
#
# LIBRERIA PARA GENERAR ARCHIVOS XML FIRMADOS
# CUMPLE NORMAS PARA CERTIFICACIN SII
# COMPATIBLE CON DOCUMENTOS: 
# FACTURAS - NOTAS CREDITO - NOTAS DEBITO - GUIAS DESPACHO
# 
# 
##############################################################
##############################################################
##############################################################
##############################################################
#
class FacTronicaDte{
	################################################################################################################################
	# METODO ENSOBRAR DOCUMENTO
	################################################################################################################################
	#
	public function EnsobrarDte($destinatario){
		#
		#
		global $IdDoc;
		global $certificado;
		global $Archivos;
		global $caratula;
		global $Receptor;
		global $FACTRONICA;
		#
		$URI_SOBRE="SetDoc";//FACTRONICA";
		$cantidad_dtes=1;
		#
$caratulalera='<Caratula version="1.0">
<RutEmisor>'.$caratula["RutEmisor"].'</RutEmisor>
<RutEnvia>'.$caratula["RutEnvia"].'</RutEnvia>';

if($destinatario=="CLIENTE"){
	$caratulalera=$caratulalera.'
<RutReceptor>'.$Receptor["RUTRecep"].'</RutReceptor>';
}elseif($destinatario=="SII"){
	$caratulalera=$caratulalera.'
<RutReceptor>'.$caratula["RutReceptor"].'</RutReceptor>';
}

$caratulalera=$caratulalera.'
<FchResol>'.$caratula["FchResol"].'</FchResol>
<NroResol>'.$caratula["NroResol"].'</NroResol>
<TmstFirmaEnv>'.EstamparTiempo().'</TmstFirmaEnv>
<SubTotDTE>
<TpoDTE>'.$IdDoc["TipoDTE"].'</TpoDTE>
<NroDTE>'.$cantidad_dtes.'</NroDTE>
</SubTotDTE>
</Caratula>'; 




# DOCUMENTO FIRMADO
$setdte='<?xml version="1.0" encoding="ISO-8859-1"?>
<SetDTE xmlns="http://www.sii.cl/SiiDte" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" ID="'.$URI_SOBRE.'">
'.$caratulalera.CargarDocumento($FACTRONICA["FOLDERFILES"]."/".$FACTRONICA["DTEFIRMADO"]).'</SetDTE>';
# guardar el elemento set para calcular su digesta
$archivo=fopen($FACTRONICA["FOLDERFILES"]."/".$FACTRONICA["SETDTEPORFIRMAR"],"w") or die("ERROR: Linea 70");
fputs($archivo,$setdte);
fclose($archivo);





# calcular la digesta del sobre
$digesta_sobre=ObtenerDigestion($FACTRONICA["FOLDERFILES"]."/".$FACTRONICA["SETDTEPORFIRMAR"]);


# plantilla del signature
$firmador_sobre='<SignedInfo xmlns="http://www.w3.org/2000/09/xmldsig#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"><CanonicalizationMethod Algorithm="http://www.w3.org/TR/2001/REC-xml-c14n-20010315"></CanonicalizationMethod><SignatureMethod Algorithm="http://www.w3.org/2000/09/xmldsig#rsa-sha1"></SignatureMethod><Reference URI="#'.$URI_SOBRE.'"><Transforms><Transform Algorithm="http://www.w3.org/2000/09/xmldsig#enveloped-signature"></Transform></Transforms><DigestMethod Algorithm="http://www.w3.org/2000/09/xmldsig#sha1"></DigestMethod><DigestValue>'.$digesta_sobre.'</DigestValue></Reference></SignedInfo>';


# calcular la $firma binaria
@openssl_sign($firmador_sobre, $firma,$FACTRONICA["PrivKey"], OPENSSL_ALGO_SHA1);
# convertir la $firma binaria a base64
$SignatureValueSobre=base64_encode($firma);
# Definir signature del sobre
$signature_sobre='<Signature xmlns="http://www.w3.org/2000/09/xmldsig#"><SignedInfo><CanonicalizationMethod Algorithm="http://www.w3.org/TR/2001/REC-xml-c14n-20010315"/><SignatureMethod Algorithm="http://www.w3.org/2000/09/xmldsig#rsa-sha1"/><Reference URI="#'.$URI_SOBRE.'"><Transforms><Transform Algorithm="http://www.w3.org/2000/09/xmldsig#enveloped-signature"/></Transforms><DigestMethod Algorithm="http://www.w3.org/2000/09/xmldsig#sha1"/><DigestValue>'.$digesta_sobre.'</DigestValue></Reference></SignedInfo><SignatureValue>'.$SignatureValueSobre.'</SignatureValue><KeyInfo><KeyValue><RSAKeyValue><Modulus>'.$FACTRONICA["Modulus"].'</Modulus><Exponent>'.$FACTRONICA["Exponent"].'</Exponent></RSAKeyValue></KeyValue><X509Data><X509Certificate>'.$FACTRONICA["X509Certificate"].'</X509Certificate></X509Data></KeyInfo></Signature>';


	
		
# DOCUMENTO FIRMADO
$enviodte='<?xml version="1.0" encoding="ISO-8859-1"?>
<EnvioDTE xmlns="http://www.sii.cl/SiiDte" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0" xsi:schemaLocation="http://www.sii.cl/SiiDte EnvioDTE_v10.xsd">'.CargarDocumento($FACTRONICA["FOLDERFILES"]."/".$FACTRONICA["SETDTEPORFIRMAR"]).$signature_sobre.'</EnvioDTE>';
if($destinatario=="CLIENTE"){
	$archivo=fopen($FACTRONICA["FOLDERFILES"]."/".$FACTRONICA["SETDTEFIRMADO_CLIENTE"],"w") or die("ERROR: Linea 100");
}elseif($destinatario=="SII"){
	$archivo=fopen($FACTRONICA["FOLDERFILES"]."/".$FACTRONICA["SETDTEFIRMADO_SII"],"w") or die("ERROR: Linea 102");
}		

fputs($archivo,$enviodte);
fclose($archivo);
unlink($FACTRONICA["FOLDERFILES"]."/".$FACTRONICA["SETDTEPORFIRMAR"]);
}//end public function EnsobrarDte($destinatario){



		
	################################################################################################################################	
	##############################################################
	#######	METODO FIRMAR DOCUMENTO
	##############################################################
	#
	public function FirmarDte(){
		#
		global $IdDoc;
		global $certificado;
		global $Archivos;
		global $FACTRONICA;
		# DECLARAR CONSTANTE PARA LA URI
		$URI="FOLIO".$IdDoc["Folio"]."TIPO".$IdDoc["TipoDTE"]; 
		
		
		
		
		
		
		# Funcion para calcular el resumen (Digest) de un archivo
		function ObtenerDigestion($url_archivo){
			// crear tabulacion automatica
			// $doc->formatOutput = true; 
			// Crear Objeto Xml
			$doc = new DOMDocument();
			// Preservar los espacios tabulaciones, etc...
			$doc->preserveWhiteSpace = true; 
			// Carga archivo en el objeto
			$doc->load($url_archivo);
			//  Embeber
			$dom = $doc->documentElement;
			// Calcular Digestion
			$digestion = base64_encode(sha1($dom->C14N(), true));
			// Retornar Valor Calculado
			return $digestion;
		}	
		#
		function CargarDocumento($path_absolute){
			#
			global $archivo;
			#
			$archivo_leer=fopen($path_absolute,"r");
			#
			$contenido_xml=fread($archivo_leer, filesize($path_absolute));
			#
			$contenido_xml=str_replace('<?xml version="1.0" encoding="ISO-8859-1"?>','',$contenido_xml);	
			#
			fclose($archivo_leer);	
			#
			// fputs($archivo,$contenido_xml);
			return $contenido_xml;
		}		
		
		
		 
		
		
		# Calcular la digestion del archivo
		$digesta=ObtenerDigestion($FACTRONICA["FOLDERFILES"]."/".$FACTRONICA["DTEPORFIRMAR"]);
		# plantilla bendita para firmar la digesta
		$firmador='<SignedInfo xmlns="http://www.w3.org/2000/09/xmldsig#"><CanonicalizationMethod Algorithm="http://www.w3.org/TR/2001/REC-xml-c14n-20010315"></CanonicalizationMethod><SignatureMethod Algorithm="http://www.w3.org/2000/09/xmldsig#rsa-sha1"></SignatureMethod><Reference URI="#'.$URI.'"><Transforms><Transform Algorithm="http://www.w3.org/2000/09/xmldsig#enveloped-signature"></Transform></Transforms><DigestMethod Algorithm="http://www.w3.org/2000/09/xmldsig#sha1"></DigestMethod><DigestValue>'.$digesta.'</DigestValue></Reference></SignedInfo>';
		# calcular la $firma binaria
		@openssl_sign($firmador, $firma, $FACTRONICA["PrivKey"], OPENSSL_ALGO_SHA1);
		# convertir la $firma binaria a base64
		$SignatureValueDocumento=base64_encode($firma);
		# armar el signature con la digesta y con 
		$signature_docto='<Signature xmlns="http://www.w3.org/2000/09/xmldsig#"><SignedInfo><CanonicalizationMethod Algorithm="http://www.w3.org/TR/2001/REC-xml-c14n-20010315"/><SignatureMethod Algorithm="http://www.w3.org/2000/09/xmldsig#rsa-sha1"/><Reference URI="#'.$URI.'"><Transforms><Transform Algorithm="http://www.w3.org/2000/09/xmldsig#enveloped-signature"/></Transforms><DigestMethod Algorithm="http://www.w3.org/2000/09/xmldsig#sha1"/><DigestValue>'.$digesta.'</DigestValue></Reference></SignedInfo><SignatureValue>'.$SignatureValueDocumento.'</SignatureValue><KeyInfo><KeyValue><RSAKeyValue><Modulus>'.$FACTRONICA["Modulus"].'</Modulus><Exponent>'.$FACTRONICA["Exponent"].'</Exponent></RSAKeyValue></KeyValue><X509Data><X509Certificate>'.$FACTRONICA["X509Certificate"].'</X509Certificate></X509Data></KeyInfo></Signature>';
# DOCUMENTO FIRMADO
$setdte='<?xml version="1.0" encoding="ISO-8859-1"?>
<DTE version="1.0">'.CargarDocumento($FACTRONICA["FOLDERFILES"]."/".$FACTRONICA["DTEPORFIRMAR"]).'
'.$signature_docto.
'</DTE>';
		# guardar el elemento set para calcular su digesta
		$archivo=fopen($FACTRONICA["FOLDERFILES"]."/".$FACTRONICA["DTEFIRMADO"],"w") or die("ERROR: Linea 188");
		fputs($archivo,$setdte);
		fclose($archivo);	
        unlink($FACTRONICA["FOLDERFILES"]."/".$FACTRONICA["DTEPORFIRMAR"]);
	}// end public function FirmarDte(){
		
	################################################################################################################################
	# METODO CREAR DOCUMENTO
	################################################################################################################################
	#
	public function CrearDte(){
		#######	VARIABLES GLOBALES
		#
		global $IdDoc;
		global $Emisor;
		global $Receptor;
		global $Totales;
		global $Archivos;
		global $CAF;
		#
		global $caratula;
		global $detalle;
		global $referencias;
		global $doc_referencia;
		global $FACTRONICA;
		global $ImptoReten;
		
		
		
		
 
		
		
		
		
		
		
		##############################################################   
		#######	RUTA DE LA CARPETA DONDE QUEDARON ALMACENADOS LOS XML
		##############################################################
		$RutaDocumento="xml/";
		$lineas_detalle=count($detalle,0);//"6"; # CANTIDAD DE LINEAS DEL DETALLE DEL DTE
		$URI="FOLIO".$IdDoc["Folio"]."TIPO".$IdDoc["TipoDTE"];
		
		
		
		
		
		
		
		##############################################################
		#######	CARGAR LIBRERIAS
		##############################################################
		# funcion para reemplazar caracteres de acuerdo con lo exigido por el sii
		# ej. Pintura B&W AFECTO, en este caso & se debe reemplazar por &amp;
		function ConvertirCaracteres($string){
			#
			$buscar  = array('&', '<', '>', '"', "'");
			$reemplazar = array('&amp;', '&lt;', '&gt;', '&quot;', '&apos;');
			#
			return str_replace($buscar, $reemplazar, $string);
		}
		##############################################################
		#######	CARGAR LIBRERIAS
		##############################################################
		# Funcin para convertir timestamp a fecha en formato dd/mm/aaaa
		function EstamparTiempo(){
			global $FACTRONICA;
			// $FACTRONICA["TIMESTAMP"]="2017-06-06T18:08:07";
			if($FACTRONICA["TIMESTAMP"]!=""){
				return $FACTRONICA["TIMESTAMP"];
			}else{
				# 
				$ts=time();
				# 
				$ano_actual=date("Y",$ts);
				$mes_actual=date("m",$ts);
				$dia_actual=date("d",$ts);
				#
				$hora_actual=date("H",$ts);
				$minu_actual=date("i",$ts);
				$segu_actual=date("s",$ts);
				#
				$tiempo_estampado="$ano_actual-$mes_actual-$dia_actual"."T"."$hora_actual:$minu_actual:$segu_actual";
				#
				return $tiempo_estampado;
			}
		}
		##############################################################
		####### 
		##############################################################
		# GENERAR EL TIMBRE ELECTRONICO 
		function TimbrarDocumento(){
			#
			global $CAF;
			global $Receptor;
			global $IdDoc;
			global $Totales;
			global $detalle;
			global $FACTRONICA;
			# .
			$DD_FRMT='<DD><RE>'.$CAF["RE"].'</RE><TD>'.$CAF["TD"].'</TD><F>'.$IdDoc["Folio"].'</F><FE>'.$IdDoc["FchEmis"].'</FE><RR>'.$Receptor["RUTRecep"].'</RR><RSR>'.substr($Receptor["RznSocRecep"],0,40).'</RSR><MNT>'.$Totales["MntTotal"].'</MNT><IT1>'.substr(ConvertirCaracteres($detalle["1"]["NmbItem"]),0,40).'</IT1><CAF version="1.0"><DA><RE>'.$CAF["RE"].'</RE><RS>'.ConvertirCaracteres(substr($CAF["RS"],0,40)).'</RS><TD>'.$CAF["TD"].'</TD><RNG><D>'.$CAF["RNG_D"].'</D><H>'.$CAF["RNG_H"].'</H></RNG><FA>'.$CAF["FA"].'</FA><RSAPK><M>'.$CAF["RSAPK_M"].'</M><E>'.$CAF["RSAPK_E"].'</E></RSAPK><IDK>'.$CAF["RSAPK_IDK"].'</IDK></DA><FRMA algoritmo="SHA1withRSA">'.$CAF["FRMA"].'</FRMA></CAF><TSTED>'.EstamparTiempo().'</TSTED></DD>';
			# calcular la $firma binaria
			@openssl_sign($DD_FRMT, $firma,$CAF["RSASK"], OPENSSL_ALGO_SHA1);
			# convertir la $firma binaria a base64
			$firma_timbre=base64_encode($firma);
# IMPORTANTE: <FRMT debe comenzar pegado al costado izquierdo obligatoriamente
$FR='
<FRMT algoritmo="SHA1withRSA">'.$firma_timbre.'</FRMT>';
			#
			$dd=$DD_FRMT.$FR;
			#
			return $dd;
		}
##############################################################
#######	
##############################################################
$FRMT=TimbrarDocumento();
##############################################################
#######	DETALLE
##############################################################
$doc_detalle='';
# RECORRER LAS LINEAS DEL DETALLE DEL DOCUMENTO	
for($lin=1;$lin<=$lineas_detalle;$lin++){ 	


#
$doc_detalle=$doc_detalle.'
<Detalle>
<NroLinDet>'.$detalle["$lin"]["NroLinDet"].'</NroLinDet>';


if($detalle["$lin"]["TpoCodigo"]!="" and $detalle["$lin"]["VlrCodigo"]!=""){
$doc_detalle=$doc_detalle.'
<CdgItem>
<TpoCodigo>'.$detalle["$lin"]["TpoCodigo"].'</TpoCodigo>
<VlrCodigo>'.$detalle["$lin"]["VlrCodigo"].'</VlrCodigo>
</CdgItem>';
}

/*

if($detalle["$lin"]["TpoCodigo"]!=""){
$detalle=$detalle.'
<CdgItem>
<TpoCodigo>'.$detalle["$lin"]["TpoCodigo"].'</TpoCodigo>
<VlrCodigo>'.$detalle["$lin"]["VlrCodigo"].'</VlrCodigo>
</CdgItem>';
}
*/


# si el item es exento
if($detalle["$lin"]["IndExe"]=="1"){
$doc_detalle=$doc_detalle.'
<IndExe>'.$detalle["$lin"]["IndExe"].'</IndExe>';
}
$doc_detalle=$doc_detalle.'
<NmbItem>'.ConvertirCaracteres(substr($detalle["$lin"]["NmbItem"],0,80)).'</NmbItem>';

if($detalle["$lin"]["DscItem"]!="" and $detalle["$lin"]["DscItem"]!="0"){
# DESCRIPCIN LARGA HASTA 1000 CARACTERES
$doc_detalle=$doc_detalle.'
<DscItem>'.ConvertirCaracteres(substr($detalle["$lin"]["DscItem"],0,1000)).'</DscItem>';
}

#
if($detalle["$lin"]["QtyItem"]>0){
$doc_detalle=$doc_detalle.'
<QtyItem>'.round($detalle["$lin"]["QtyItem"],2).'</QtyItem>';
}

if($detalle["$lin"]["UnmdItem"]!=""){
$doc_detalle=$doc_detalle.'
<UnmdItem>'.substr($detalle["$lin"]["UnmdItem"],0,4).'</UnmdItem>';
}



 

#
if($detalle["$lin"]["PrcItem"]>0){
// xml con valores netos 0=neto_xml 1=bruto_xml
if($FACTRONICA["VALORES_XML"]=="0"){
$doc_detalle=$doc_detalle.'
<PrcItem>'.$detalle["$lin"]["NetoUnitario"].'</PrcItem>';   
// xml valores brutos
}else{
$doc_detalle=$doc_detalle.'
<PrcItem>'.$detalle["$lin"]["PrcItem"].'</PrcItem>';   
}
}

 





# DESCUENTO LINEAL
if($detalle["$lin"]["DescuentoPct"]>0){
$doc_detalle=$doc_detalle.'
<DescuentoPct>'.$detalle["$lin"]["DescuentoPct"].'</DescuentoPct>
<DescuentoMonto>'.$detalle["$lin"]["DescuentoMonto"].'</DescuentoMonto>';
}
# RECARGO LINEAL
if($detalle["$lin"]["RecargoPct"]>0){
$doc_detalle=$doc_detalle.'
<RecargoPct>'.$detalle["$lin"]["RecargoPct"].'</RecargoPct>
<RecargoMonto>'.$detalle["$lin"]["RecargoMonto"].'</RecargoMonto>';
}

 

if($detalle["$lin"]["CodImpAdic"]>0){
$doc_detalle=$doc_detalle.'
<CodImpAdic>'.$detalle["$lin"]["CodImpAdic"].'</CodImpAdic>';
}


// 0=neto_xml 1=bruto_xml
if($FACTRONICA["VALORES_XML"]=="0"){
#
$doc_detalle=$doc_detalle.'
<MontoItem>'.$detalle["$lin"]["NetoSubtotal"].'</MontoItem>
</Detalle>';
}else{
$doc_detalle=$doc_detalle.'
<MontoItem>'.$detalle["$lin"]["MontoItem"].'</MontoItem>
</Detalle>';
}



}# FINAL DEL CICLO QUE RECORRE LAS LINEAS DEL DETALLE
#
# RECORRER LAS LINEAS DE DESCUENTOS GLOBALES
global $DscRcgGlobal;

if($DscRcgGlobal["1"]["ValorDR"]>0){
for($lin=1;$lin<=count($DscRcgGlobal);$lin++){ 
$doc_detalle=$doc_detalle.'
<DscRcgGlobal>
<NroLinDR>'.$DscRcgGlobal["$lin"]["NroLinDR"].'</NroLinDR>
<TpoMov>'.$DscRcgGlobal["$lin"]["TpoMov"].'</TpoMov>
<GlosaDR>'.$DscRcgGlobal["$lin"]["GlosaDR"].'</GlosaDR>
<TpoValor>'.$DscRcgGlobal["$lin"]["TpoValor"].'</TpoValor>
<ValorDR>'.$DscRcgGlobal["$lin"]["ValorDR"].'</ValorDR>';
#
if($DscRcgGlobal["$lin"]["ValorDROtrMnda"]>0){
$doc_detalle=$doc_detalle.'<ValorDROtrMnda>'.$DscRcgGlobal["$lin"]["ValorDROtrMnda"].'</ValorDROtrMnda>';
}
#
if($DscRcgGlobal["$lin"]["IndExeDR"]>0){
$doc_detalle=$doc_detalle.'<IndExeDR>'.$DscRcgGlobal["$lin"]["IndExeDR"].'</IndExeDR>';
}
$doc_detalle=$doc_detalle.'</DscRcgGlobal>';
} // for
}//if


#  
$maxref=0;
global $doc_referencia;
global $FACTRONICA;
global $OtraMoneda;
global $Transporte;
# 
for($ref=1;$ref<=count($doc_referencia);$ref++){ 
if($doc_referencia["$ref"]["FolioRef"]!=""){
$doc_detalle=$doc_detalle.'
<Referencia>
<NroLinRef>'.$ref.'</NroLinRef>
<TpoDocRef>'.$doc_referencia["$ref"]["TpoDocRef"].'</TpoDocRef>';
if($doc_referencia["$ref"]["IndGlobal"]>0){
$doc_detalle=$doc_detalle.'
<IndGlobal>'.$doc_referencia["$ref"]["IndGlobal"].'</IndGlobal>';
}

$doc_detalle=$doc_detalle.'
<FolioRef>'.$doc_referencia["$ref"]["FolioRef"].'</FolioRef>
<FchRef>'.$doc_referencia["$ref"]["FchRef"].'</FchRef>';
#
if($doc_referencia["$ref"]["CodRef"]>0){
$doc_detalle=$doc_detalle.'
<CodRef>'.$doc_referencia["$ref"]["CodRef"].'</CodRef>';
}
$doc_detalle=$doc_detalle.'
<RazonRef>'.substr($doc_referencia["$ref"]["RazonRef"],0,90).'</RazonRef>';



$doc_detalle=$doc_detalle.'
</Referencia>';

}
}
##############################################################
#######	DOCUMENTO
##############################################################
# 
$dte_cabeza='<DTE version="1.0">';
# 
$doc_cabeza='<Exportaciones ID="'.$URI.'">
<Encabezado>
<IdDoc>
<TipoDTE>'.$IdDoc["TipoDTE"].'</TipoDTE>
<Folio>'.$IdDoc["Folio"].'</Folio>
<FchEmis>'.$IdDoc["FchEmis"].'</FchEmis>';
#
if($IdDoc["IndServicio"]>0){
$doc_cabeza=$doc_cabeza.'
<IndServicio>'.$IdDoc["IndServicio"].'</IndServicio>';
}
#
if($IdDoc["FmaPagExp"]!=""){
$doc_cabeza=$doc_cabeza.'
<FmaPagExp>'.$IdDoc["FmaPagExp"].'</FmaPagExp>';
}
# INICIO - SOLO SI ES GUA DESPACHO
if($IdDoc["TipoDTE"]=="52"){ 
if($IdDoc["TipoDespacho"]>0){ 
$doc_cabeza=$doc_cabeza.'
<TipoDespacho>'.$IdDoc["TipoDespacho"].'</TipoDespacho>';
}
# me dice si la guia es tipo 1=facturable o tipo 2 3 4 5 6 7 (que son no facturables)
if($IdDoc["IndTraslado"]>0){ 
$doc_cabeza=$doc_cabeza.'
<IndTraslado>'.$IdDoc["IndTraslado"].'</IndTraslado>'; 
}
}
# FINAL - SOLO SI ES GUA DESPACHO



# INDICADOR DE LINEAS DE DETALLE CON VALORES BRUTOS
if($IdDoc["MntBruto"]=="1"){
$doc_cabeza=$doc_cabeza.'
<MntBruto>'.$IdDoc["MntBruto"].'</MntBruto>'; 
}



 
/*

# COMPRA 1=del giro
if(!$IdDoc["TpoTranCompra"]>0){
   $IdDoc["TpoTranCompra"]=1; 
}
if($IdDoc["TpoTranCompra"]>0){ 
$doc_cabeza=$doc_cabeza.'
<TpoTranCompra>'.$IdDoc["TpoTranCompra"].'</TpoTranCompra>';
}
*/


/*
# VENTA 1=del giro
if(!$IdDoc["TpoTranVenta"]>0){
   $IdDoc["TpoTranVenta"]=1; 
}
if($IdDoc["TpoTranVenta"]>0){ 
$doc_cabeza=$doc_cabeza.'
<TpoTranVenta>'.$IdDoc["TpoTranVenta"].'</TpoTranVenta>';
}
*/
 

 



if($IdDoc["TermPagoGlosa"]!=""){
$doc_cabeza=$doc_cabeza.'
<TermPagoGlosa>'.$IdDoc["TermPagoGlosa"].'</TermPagoGlosa>';
}
if($IdDoc["FchVenc"]!=""){
$doc_cabeza=$doc_cabeza.'
<FchVenc>'.$IdDoc["FchVenc"].'</FchVenc>';
}









/*

---

# INDICADOR DE LINEAS DE DETALLE CON VALORES BRUTOS
if($IdDoc["MntBruto"]=="1"){
$doc_cabeza=$doc_cabeza.'
<MntBruto>'.$IdDoc["MntBruto"].'</MntBruto>'; 
}



 

#
if($IdDoc["TpoTranCompra"]>0){ 
$doc_cabeza=$doc_cabeza.'
<TpoTranCompra>'.$IdDoc["TpoTranCompra"].'</TpoTranCompra>';
}


#
if($IdDoc["TpoTranVenta"]>0){ 
$doc_cabeza=$doc_cabeza.'
<TpoTranVenta>'.$IdDoc["TpoTranVenta"].'</TpoTranVenta>';
}

 




if($IdDoc["TermPagoGlosa"]!=""){
$doc_cabeza=$doc_cabeza.'
<TermPagoGlosa>'.$IdDoc["TermPagoGlosa"].'</TermPagoGlosa>';
}
if($IdDoc["FchVenc"]!=""){
$doc_cabeza=$doc_cabeza.'
<FchVenc>'.$IdDoc["FchVenc"].'</FchVenc>';
}
---
*/













$doc_cabeza=$doc_cabeza.'
</IdDoc>
<Emisor>
<RUTEmisor>'.substr($Emisor["RUTEmisor"],0,10).'</RUTEmisor>
<RznSoc>'.ConvertirCaracteres(substr($Emisor["RznSoc"],0,100)).'</RznSoc>
<GiroEmis>'.substr($Emisor["GiroEmis"],0,80).'</GiroEmis>
<Telefono>'.substr($Emisor["Telefono"],0,20).'</Telefono>
<CorreoEmisor>'.substr($Emisor["CorreoEmisor"],0,80).'</CorreoEmisor>
<Acteco>'.$Emisor["Acteco"].'</Acteco>
<CdgSIISucur>'.$Emisor["CdgSIISucur"].'</CdgSIISucur>
<DirOrigen>'.$Emisor["DirOrigen"].'</DirOrigen>
<CmnaOrigen>'.substr($Emisor["CmnaOrigen"],0,20).'</CmnaOrigen>
<CiudadOrigen>'.substr($Emisor["CiudadOrigen"],0,20).'</CiudadOrigen>
</Emisor>
<Receptor>
<RUTRecep>'.substr($Receptor["RUTRecep"],0,10).'</RUTRecep>';
#
if($Receptor["CdgIntRecep"]!=""){
$doc_cabeza=$doc_cabeza.'
<CdgIntRecep>'.substr($Receptor["CdgIntRecep"],0,20).'</CdgIntRecep>';
}
#
if($Receptor["NumId"]!=""){
$doc_cabeza=$doc_cabeza.'
<NumId>'.substr($Receptor["NumId"],0,20).'</NumId>
<Nacionalidad>'.substr($Receptor["Nacionalidad"],0,3).'</Nacionalidad>';
}

$doc_cabeza=$doc_cabeza.'
<RznSocRecep>'.substr($Receptor["RznSocRecep"],0,100).'</RznSocRecep>';
#
if($Receptor["Nacionalidad"]>0){
$doc_cabeza=$doc_cabeza.'
<Extranjero>
<Nacionalidad>'.$Receptor["Nacionalidad"].'</Nacionalidad>
</Extranjero>';
}
#
$doc_cabeza=$doc_cabeza.'
<GiroRecep>'.substr($Receptor["GiroRecep"],0,40).'</GiroRecep>
<Contacto>'.substr($Receptor["Contacto"],0,80).'</Contacto>
<CorreoRecep>'.substr($Receptor["CorreoRecep"],0,80).'</CorreoRecep>
<DirRecep>'.substr($Receptor["DirRecep"],0,70).'</DirRecep>
<CmnaRecep>'.substr($Receptor["CmnaRecep"],0,20).'</CmnaRecep>
<CiudadRecep>'.substr($Receptor["CiudadRecep"],0,20).'</CiudadRecep>
</Receptor>';




##############################################################
#######	TRANSPORTE
##############################################################
#
$doc_cabeza=$doc_cabeza.'
<Transporte>';
#
if($Transporte["Patente"]!=""){
$doc_cabeza=$doc_cabeza.'
<Patente>'.$Transporte["Patente"].'</Patente>';
}
#
if($Transporte["RUTTrans"]!=""){
$doc_cabeza=$doc_cabeza.'
<RUTTrans>'.$Transporte["RUTTrans"].'</RUTTrans>';
}
#
$doc_cabeza=$doc_cabeza.'
<Chofer>';
#
if($Transporte["RUTChofer"]!=""){
$doc_cabeza=$doc_cabeza.'
<RUTChofer>'.$Transporte["RUTChofer"].'</RUTChofer>';
}
#
if($Transporte["NombreChofer"]!=""){
$doc_cabeza=$doc_cabeza.'
<NombreChofer>'.$Transporte["NombreChofer"].'</NombreChofer>';
}
#
$doc_cabeza=$doc_cabeza.'
</Chofer>';
#
$doc_cabeza=$doc_cabeza.'
<Aduana>';
#
if($Transporte["CodModVenta"]!=""){
$doc_cabeza=$doc_cabeza.'
<CodModVenta>'.$Transporte["CodModVenta"].'</CodModVenta>';
}
#
if($Transporte["CodClauVenta"]!=""){
$doc_cabeza=$doc_cabeza.'
<CodClauVenta>'.$Transporte["CodClauVenta"].'</CodClauVenta>';
}
#
if($Transporte["TotClauVenta"]>0){
$doc_cabeza=$doc_cabeza.'
<TotClauVenta>'.$Transporte["TotClauVenta"].'</TotClauVenta>';
}
#
if($Transporte["CodViaTransp"]!=""){
$doc_cabeza=$doc_cabeza.'
<CodViaTransp>'.$Transporte["CodViaTransp"].'</CodViaTransp>';
}
#
if($Transporte["CodPtoEmbarque"]!=""){
$doc_cabeza=$doc_cabeza.'
<CodPtoEmbarque>'.$Transporte["CodPtoEmbarque"].'</CodPtoEmbarque>';
}
#
if($Transporte["IdAdicPtoEmb"]!=""){
$doc_cabeza=$doc_cabeza.'
<IdAdicPtoEmb>'.$Transporte["IdAdicPtoEmb"].'</IdAdicPtoEmb>';
}
#
if($Transporte["CodPtoDesemb"]!=""){
$doc_cabeza=$doc_cabeza.'
<CodPtoDesemb>'.$Transporte["CodPtoDesemb"].'</CodPtoDesemb>';
}
#
if($Transporte["IdAdicPtoDesemb"]!=""){
$doc_cabeza=$doc_cabeza.'
<IdAdicPtoDesemb>'.$Transporte["IdAdicPtoDesemb"].'</IdAdicPtoDesemb>';
}
#
if($Transporte["CodUnidMedTara"]!=""){
$doc_cabeza=$doc_cabeza.'
<CodUnidMedTara>'.$Transporte["CodUnidMedTara"].'</CodUnidMedTara>';
}
#
if($Transporte["CodUnidPesoBruto"]!=""){
$doc_cabeza=$doc_cabeza.'
<CodUnidPesoBruto>'.$Transporte["CodUnidPesoBruto"].'</CodUnidPesoBruto>';
}
#
if($Transporte["CodUnidPesoNeto"]!=""){
$doc_cabeza=$doc_cabeza.'
<CodUnidPesoNeto>'.$Transporte["CodUnidPesoNeto"].'</CodUnidPesoNeto>';
}
#
if($Transporte["TotItems"]>0){
$doc_cabeza=$doc_cabeza.'
<TotItems>'.$Transporte["TotItems"].'</TotItems>';
}
#
if($Transporte["TotBultos"]>0){
$doc_cabeza=$doc_cabeza.'
<TotBultos>'.$Transporte["TotBultos"].'</TotBultos>';
}
#
$doc_cabeza=$doc_cabeza.'
<TipoBultos>';
#
if($Transporte["CodTpoBultos"]!=""){
$doc_cabeza=$doc_cabeza.'
<CodTpoBultos>'.$Transporte["CodTpoBultos"].'</CodTpoBultos>';
}
#
if($Transporte["CantBultos"]>0){
$doc_cabeza=$doc_cabeza.'
<CantBultos>'.$Transporte["CantBultos"].'</CantBultos>';
}
#
if($Transporte["Marcas"]!=""){
$doc_cabeza=$doc_cabeza.'
<Marcas>'.$Transporte["Marcas"].'</Marcas>';
}
#
if($Transporte["IdContainer"]!=""){
$doc_cabeza=$doc_cabeza.'
<IdContainer>'.$Transporte["IdContainer"].'</IdContainer>';
}
#
if($Transporte["Sello"]!=""){
$doc_cabeza=$doc_cabeza.'
<Sello>'.$Transporte["Sello"].'</Sello>';
}
#
if($Transporte["EmisorSello"]!=""){
$doc_cabeza=$doc_cabeza.'
<EmisorSello>'.$Transporte["EmisorSello"].'</EmisorSello>';
}
#
$doc_cabeza=$doc_cabeza.'
</TipoBultos>';
#
if($Transporte["MntFlete"]>0){
$doc_cabeza=$doc_cabeza.'
<MntFlete>'.$Transporte["MntFlete"].'</MntFlete>';
}
#
if($Transporte["MntSeguro"]>0){
$doc_cabeza=$doc_cabeza.'
<MntSeguro>'.$Transporte["MntSeguro"].'</MntSeguro>';
}
#
if($Transporte["CodPaisRecep"]!=""){
$doc_cabeza=$doc_cabeza.'
<CodPaisRecep>'.$Transporte["CodPaisRecep"].'</CodPaisRecep>';
}
#
if($Transporte["CodPaisDestin"]!=""){
$doc_cabeza=$doc_cabeza.'
<CodPaisDestin>'.$Transporte["CodPaisDestin"].'</CodPaisDestin>';
}
#
$doc_cabeza=$doc_cabeza.'
</Aduana>';
#
$doc_cabeza=$doc_cabeza.'
</Transporte>';




 

##############################################################
#######	TOTALES
##############################################################
#
$doc_cabeza=$doc_cabeza.'
<Totales>';
#
if($Totales["TpoMoneda"]!=""){ 
$doc_cabeza=$doc_cabeza.'
<TpoMoneda>'.$Totales["TpoMoneda"].'</TpoMoneda>';
}
#
if($Totales["MntNeto"]>0){ 
$doc_cabeza=$doc_cabeza.'
<MntNeto>'.$Totales["MntNeto"].'</MntNeto>';
}
#
if($Totales["MntExe"]>0){ 
$doc_cabeza=$doc_cabeza.'
<MntExe>'.$Totales["MntExe"].'</MntExe>';
}
#
if($Totales["ValComNeto"]>0){ 
$doc_cabeza=$doc_cabeza.'
<ValComNeto>'.$Totales["ValComNeto"].'</ValComNeto>';
}
#
if($Totales["IVA"]>0){
$doc_cabeza=$doc_cabeza.'
<TasaIVA>'.$Totales["TasaIVA"].'</TasaIVA>
<IVA>'.$Totales["IVA"].'</IVA>';
}

##############################################################
#######	OTROS IMPUESTOS
##############################################################
for($tipos_impuestos=1;$tipos_impuestos<=300;$tipos_impuestos++){

if($ImptoReten["$tipos_impuestos"]["MontoImp"]>0){

$doc_cabeza=$doc_cabeza.'
<ImptoReten>
<TipoImp>'.$tipos_impuestos.'</TipoImp>';

if($ImptoReten["$tipos_impuestos"]["TasaImp"]>0){
$doc_cabeza=$doc_cabeza.'
<TasaImp>'.$ImptoReten["$tipos_impuestos"]["TasaImp"].'</TasaImp>';
}

$doc_cabeza=$doc_cabeza.'
<MontoImp>'.$ImptoReten["$tipos_impuestos"]["MontoImp"].'</MontoImp>
</ImptoReten>';

}//if
}//for
 







#
$doc_cabeza=$doc_cabeza.'
<MntTotal>'.$Totales["MntTotal"].'</MntTotal>';
#
#
##############################################################
#######	COMISIONES
##############################################################
if($Comisiones["1"]["TasaComision"]>0){
$doc_cabeza=$doc_cabeza.'
<Comisiones>
<NroLinCom>'.$Comisiones["1"]["NroLinCom"].'</NroLinCom>
<TipoMovim>'.$Comisiones["1"]["TipoMovim"].'</TipoMovim>
<TasaComision>'.$Comisiones["1"]["TasaComision"].'</TasaComision>
</Comisiones>';
}
#
$doc_cabeza=$doc_cabeza.'			
</Totales>';



##############################################################
#######	OTRA MONEDA
##############################################################
if($OtraMoneda["TpoCambio"]>0){
$doc_cabeza=$doc_cabeza.'
<OtraMoneda>
<TpoMoneda>'.$OtraMoneda["TpoMoneda"].'</TpoMoneda>
<TpoCambio>'.$OtraMoneda["TpoCambio"].'</TpoCambio>
<MntExeOtrMnda>'.$OtraMoneda["MntExeOtrMnda"].'</MntExeOtrMnda>
<MntTotOtrMnda>'.$OtraMoneda["MntTotOtrMnda"].'</MntTotOtrMnda>
</OtraMoneda>';
}




$doc_cabeza=$doc_cabeza.'			
</Encabezado>';	










##############################################################
#######	ARMAR TIMBRADO
##############################################################
# 	
$doc_timbre='<TED version="1.0">
'.$FRMT.'
</TED>';	
# 	
$doc_pie='<TmstFirma>'.EstamparTiempo().'</TmstFirma>
</Exportaciones>';
# 
$dte_pie='</DTE>';











##############################################################
#######	ARMAR DOCUMENTO
##############################################################
$tdocumento='<?xml version="1.0" encoding="ISO-8859-1"?>
'.$doc_cabeza.$doc_detalle.'
'.$doc_timbre.'
'.$doc_pie;
# guarda el archivo con el documento para obtener la digestion
$archivo=fopen($FACTRONICA["FOLDERFILES"]."/".$FACTRONICA["DTEPORFIRMAR"],"w") or die("ERROR: AL CREAR EL DTE POR FIRMAR ".$FACTRONICA["FOLDERFILES"]."/".$FACTRONICA["DTEPORFIRMAR"]);
fputs($archivo,$tdocumento);
fclose($archivo);
}// End public function CrearDte(){
	
}// End CLass <MntBruto>
?>
