<?php
# CERTIFICACION LIBRO DE COMPRAS 5 EMES
#
include("../librerias/php/header.php");
#
include("../librerias/php/factronica_libs/invertir_fecha.php");

$ano="2016";
$mes="02";
$sw_certificacion="1";

##############################################################
##############################################################
##############################################################
#
#
# FACTRONICA_LIB_IECV Version.11072014
# FACTRONICA_LIB_IECV UpDate.26092015
# DESARROLLADOR: JOSÉ PATRICIO DÍAZ ZÚÑIGA
# EMAIL: CONTACTO@FACTRONICA.CL
# CEL.: +569 8 804 05 74
#
# LIBRERIA PARA GENERAR LIBRO DE COMPRAS
# CUMPLE NORMAS PARA CERTIFICACIÓN SII CHILE
# COMPATIBLE CON DOCUMENTOS:
# FACTURAS - NOTAS CREDITO - NOTAS DEBITO - FACTURA PROPIA (ELECTRÓNICOS)
# FACTURAS - NOTAS CREDITO - NOTAS DEBITO - FACTURA PROPIA (MANUALES)
# 
##############################################################
##############################################################
##############################################################
##############################################################
#
# EJEMPLO DE SET BASICO DE PRUEBAS SII (LIBRO DE COMPRAS)
#
/*
--------------------------------------------------------------------------------
SET LIBRO DE COMPRAS - NUMERO DE ATENCION:  468996
 
==========================================================================
TIPO DOCUMENTO				FOLIO
OBSERVACIONES
MONTO EXENTO	MONTO AFECTO
==========================================================================
FACTURA					234
FACTURA DEL GIRO CON DERECHO A CREDITO
		  31306

FACTURA ELECTRONICA 			 32
FACTURA DEL GIRO CON DERECHO A CREDITO
   9404		   8076

FACTURA					781
FACTURA CON IVA USO COMUN
		  29906

NOTA DE CREDITO				451
NOTA DE CREDITO POR DESCUENTO A FACTURA 234
		   2784

FACTURA ELECTRONICA			 67
ENTREGA GRATUITA DEL PROVEEDOR
		  10686

FACTURA DE COMPRA ELECTRONICA		  9
COMPRA CON RETENCION TOTAL DEL IVA
		   9906

NOTA DE CREDITO				211
NOTA DE CREDITO POR DESCUENTO FACTURA ELECTRONICA 32
		   5902
==========================================================================

OBSERVACIONES GENERALES
-----------------------
EN FACTURA CON IVA USO COMUN CONSIDERE QUE EL FACTOR DE PROPORCIONALIDAD 
DEL IVA ES DE 0.60

*/
#
##############################################################
# INCLUIR LA CLASE LIBRO COMPRAS
##############################################################
#  
include("../factronica_lib_xml_librocompras/class_factronica_librocompras.php");

##############################################################
# INCLUIR DATOS DEL CERTIFICADO DIGITAL
##############################################################
# Estatico
// include("certificado_x509.php");
# Dinamico ( obtendrá el certificado dependiendo de la empresa seleccionada)
include("../librerias/php/factronica_libs/datos_certificado.php");

##############################################################
# CARATULA DEL LIBRO
##############################################################
#
$caratula["RutEmisorLibro"]=$rut_pyme;
$caratula["RutEnvia"]=$RutEnvia; 
$caratula["PeriodoTributario"]=$ano."-".$mes; 

$caratula["FchResol"]=$fecha_resolucion_certificacion;
$caratula["NroResol"]=$num_resolucion_certificacion;
$caratula["TipoOperacion"]="COMPRA";
$caratula["TipoLibro"]="MENSUAL";
$caratula["TipoEnvio"]="TOTAL";
$caratula["Cantidad_Documentos"]=7;

 

# Documento 1
/*
==========================================================================
TIPO DOCUMENTO				FOLIO
OBSERVACIONES
MONTO EXENTO	MONTO AFECTO
==========================================================================
FACTURA					234
FACTURA DEL GIRO CON DERECHO A CREDITO
		  31306
*/
$detalle["TpoDoc"]["1"]="30"; 
$detalle["NroDoc"]["1"]="234";
$detalle["TpoImp"]["1"]="1";
$detalle["TasaImp"]["1"]="19";
$detalle["FchDoc"]["1"]=$ano."-".$mes."-01";
$detalle["RUTDoc"]["1"]="86630800-4";
$detalle["RznSoc"]["1"]="COMERCIAL E INDUSTRIAL SUPER LTDA.";
$detalle["MntExe"]["1"]="0";
$detalle["MntNeto"]["1"]="5582";//REEMPLAZAR
$detalle["MntIVA"]["1"]=round(($detalle["MntNeto"]["1"]*$detalle["TasaImp"]["1"])/100);
$detalle["IVARetTotal"]["1"]="0";
$detalle["CodIVANoRec"]["1"]="0";
$detalle["MntIVANoRec"]["1"]="0";
$detalle["IVAUsoComun"]["1"]="0";
$detalle["MntTotal"]["1"]=$detalle["MntNeto"]["1"]+$detalle["MntIVA"]["1"];
# Documento 2
/*
==========================================================================
TIPO DOCUMENTO				FOLIO
OBSERVACIONES
MONTO EXENTO	MONTO AFECTO
==========================================================================
FACTURA ELECTRONICA 			 32
FACTURA DEL GIRO CON DERECHO A CREDITO
   9404		   8076
*/   
$detalle["TpoDoc"]["2"]="33"; 
$detalle["NroDoc"]["2"]="32";
$detalle["TpoImp"]["2"]="1";
$detalle["TasaImp"]["2"]="19";
$detalle["FchDoc"]["2"]=$ano."-".$mes."-01";
$detalle["RUTDoc"]["2"]="86630800-4";
$detalle["RznSoc"]["2"]="COMERCIAL E INDUSTRIAL SUPER LTDA.";
$detalle["MntExe"]["2"]="7964";//REEMPLAZAR
$detalle["MntNeto"]["2"]="4095";//REEMPLAZAR
$detalle["MntIVA"]["2"]=round(($detalle["MntNeto"]["2"]*$detalle["TasaImp"]["2"])/100);
$detalle["IVARetTotal"]["2"]="0";
$detalle["CodIVANoRec"]["2"]="0";
$detalle["MntIVANoRec"]["2"]="0";
$detalle["IVAUsoComun"]["2"]="0";
$detalle["MntTotal"]["2"]=$detalle["MntNeto"]["2"]+$detalle["MntIVA"]["2"]+$detalle["MntExe"]["2"];
# Documento 3
/*
==========================================================================
TIPO DOCUMENTO				FOLIO
OBSERVACIONES
MONTO EXENTO	MONTO AFECTO
==========================================================================
FACTURA					781
FACTURA CON IVA USO COMUN
		  29906
*/		  
$detalle["TpoDoc"]["3"]="30"; 
$detalle["NroDoc"]["3"]="781";
$detalle["TpoImp"]["3"]="1";
$detalle["TasaImp"]["3"]="19";
$detalle["FchDoc"]["3"]=$ano."-".$mes."-01";
$detalle["RUTDoc"]["3"]="86630800-4";
$detalle["RznSoc"]["3"]="COMERCIAL E INDUSTRIAL PRUEBAS S.A.";
$detalle["MntExe"]["3"]="0";
$detalle["MntNeto"]["3"]="29596";//REEMPLAZAR 
$detalle["MntIVA"]["3"]="0";
$detalle["IVARetTotal"]["3"]="0";
$detalle["CodIVANoRec"]["3"]="0";
$detalle["MntIVANoRec"]["3"]="0";
$detalle["IVAUsoComun"]["3"]=round(($detalle["MntNeto"]["3"]*$detalle["TasaImp"]["3"])/100);
$detalle["MntTotal"]["3"]=$detalle["MntNeto"]["3"]+$detalle["IVAUsoComun"]["3"];
# Documento 4
/*
==========================================================================
TIPO DOCUMENTO				FOLIO
OBSERVACIONES
MONTO EXENTO	MONTO AFECTO
==========================================================================
NOTA DE CREDITO				451
NOTA DE CREDITO POR DESCUENTO A FACTURA 234
		   2784
*/
$detalle["TpoDoc"]["4"]="60"; 
$detalle["NroDoc"]["4"]="451";
$detalle["TpoImp"]["4"]="1";
$detalle["TasaImp"]["4"]="19";
$detalle["FchDoc"]["4"]=$ano."-".$mes."-01";
$detalle["RUTDoc"]["4"]="86630800-4";
$detalle["RznSoc"]["4"]="COMERCIAL E INDUSTRIAL PRUEBAS S.A.";
$detalle["MntExe"]["4"]="0";
$detalle["MntNeto"]["4"]="2616";//REEMPLAZAR 
$detalle["MntIVA"]["4"]=round(($detalle["MntNeto"]["4"]*$detalle["TasaImp"]["4"])/100);
$detalle["IVARetTotal"]["4"]="0";
$detalle["CodIVANoRec"]["4"]="0";
$detalle["MntIVANoRec"]["4"]="0";
$detalle["IVAUsoComun"]["4"]="0";
$detalle["MntTotal"]["4"]=$detalle["MntNeto"]["4"]+$detalle["MntIVA"]["4"];
# Documento 5
/*
==========================================================================
TIPO DOCUMENTO				FOLIO
OBSERVACIONES
MONTO EXENTO	MONTO AFECTO
==========================================================================
FACTURA ELECTRONICA			 67
ENTREGA GRATUITA DEL PROVEEDOR
		  10686
*/
$detalle["TpoDoc"]["5"]="33"; 
$detalle["NroDoc"]["5"]="67";
$detalle["TpoImp"]["5"]="1";
$detalle["TasaImp"]["5"]="19";
$detalle["FchDoc"]["5"]=$ano."-".$mes."-01";
$detalle["RUTDoc"]["5"]="86630800-4";
$detalle["RznSoc"]["5"]="COMERCIAL E INDUSTRIAL PRUEBAS S.A.";
$detalle["MntExe"]["5"]="0";
$detalle["MntNeto"]["5"]="8988";//REEMPLAZAR   
$detalle["MntIVA"]["5"]="0";
$detalle["IVARetTotal"]["5"]="0";
$detalle["CodIVANoRec"]["5"]="4"; 
$detalle["MntIVANoRec"]["5"]=round(($detalle["MntNeto"]["5"]*$detalle["TasaImp"]["5"])/100);
$detalle["IVAUsoComun"]["5"]="0";
$detalle["MntTotal"]["5"]=$detalle["MntNeto"]["5"]+$detalle["MntIVANoRec"]["5"];
# Documento 6
/*
==========================================================================
TIPO DOCUMENTO				FOLIO
OBSERVACIONES
MONTO EXENTO	MONTO AFECTO
==========================================================================
FACTURA DE COMPRA ELECTRONICA		  9
COMPRA CON RETENCION TOTAL DEL IVA
		   9906
*/
$detalle["TpoDoc"]["6"]="46"; 
$detalle["NroDoc"]["6"]="9";
$detalle["TpoImp"]["6"]="1";
$detalle["TasaImp"]["6"]="19";
$detalle["FchDoc"]["6"]=$ano."-".$mes."-01";
$detalle["RUTDoc"]["6"]="86630800-4";
$detalle["RznSoc"]["6"]="COMERCIAL E INDUSTRIAL PRUEBAS S.A.";
$detalle["MntExe"]["6"]="0";
$detalle["MntNeto"]["6"]="9055";//REEMPLAZAR 
$detalle["MntIVA"]["6"]=round(($detalle["MntNeto"]["6"]*$detalle["TasaImp"]["6"])/100);
$detalle["CodImp"]["6"]="15"; 
$detalle["MntImp"]["6"]=$detalle["MntIVA"]["6"];
$detalle["IVARetTotal"]["6"]="0";
$detalle["CodIVANoRec"]["6"]="0";
$detalle["MntIVANoRec"]["6"]="0";
$detalle["IVAUsoComun"]["6"]="0";
$detalle["MntTotal"]["6"]=$detalle["MntNeto"]["6"];
# Documento 7
/*
==========================================================================
TIPO DOCUMENTO				FOLIO
OBSERVACIONES
MONTO EXENTO	MONTO AFECTO
==========================================================================
NOTA DE CREDITO				211
NOTA DE CREDITO POR DESCUENTO FACTURA ELECTRONICA 32
		   5902
*/
$detalle["TpoDoc"]["7"]="60"; 
$detalle["NroDoc"]["7"]="211";
$detalle["TpoImp"]["7"]="1";
$detalle["TasaImp"]["7"]="19";
$detalle["FchDoc"]["7"]=$ano."-".$mes."-01";
$detalle["RUTDoc"]["7"]="86630800-4";
$detalle["RznSoc"]["7"]="COMERCIAL E INDUSTRIAL PRUEBAS S.A.";
$detalle["MntExe"]["7"]="0";
$detalle["MntNeto"]["7"]="2209";//REEMPLAZAR   
$detalle["MntIVA"]["7"]=round(($detalle["MntNeto"]["7"]*$detalle["TasaImp"]["7"])/100);
$detalle["IVARetTotal"]["7"]="0";
$detalle["CodIVANoRec"]["7"]="0";
$detalle["MntIVANoRec"]["7"]="0";
$detalle["IVAUsoComun"]["7"]="0";
$detalle["MntTotal"]["7"]=$detalle["MntNeto"]["7"]+$detalle["MntIVA"]["7"];

################################################### 
# TOTALES
###################################################
# TIPO 30  (DOC 1 Y 3)
$totales["TpoDoc"]["1"]="30"; 
$totales["TotDoc"]["1"]=2;
$totales["TotMntExe"]["1"]="0";
$totales["TotMntNeto"]["1"]=$detalle["MntNeto"]["1"]+$detalle["MntNeto"]["3"]; 
$totales["TotMntIVA"]["1"]=$detalle["MntIVA"]["1"]+$detalle["MntIVA"]["3"]; 
$totales["TotOpIVAUsoComun"]["1"]="1";  
$totales["TotIVAUsoComun"]["1"]=$detalle["IVAUsoComun"]["1"]+$detalle["IVAUsoComun"]["3"]; 
$totales["FctProp"]["1"]="0.6"; 
$totales["TotCredIVAUsoComun"]["1"]=round($totales["TotIVAUsoComun"]["1"]*$totales["FctProp"]["1"]); 
$totales["TotIVAFueraPlazo"]["1"]="0";
$totales["TotIVARetTotal"]["1"]="0";
$totales["CodIVANoRec"]["1"]="0";
$totales["TotOpIVANoRec"]["1"]="0";
$totales["TotMntIVANoRec"]["1"]="0";
$totales["TotMntTotal"]["1"]=$detalle["MntTotal"]["1"]+$detalle["MntTotal"]["3"]; 
# TIPO 33 (DOC 2 Y 5)
$totales["TpoDoc"]["2"]="33"; 
$totales["TotDoc"]["2"]=2; 
$totales["TotMntExe"]["2"]=$detalle["MntExe"]["2"]+$detalle["MntExe"]["5"]; 
$totales["TotMntNeto"]["2"]=$detalle["MntNeto"]["2"]+$detalle["MntNeto"]["5"]; 
$totales["TotMntIVA"]["2"]=$detalle["MntIVA"]["2"]+$detalle["MntIVA"]["5"]; 
$totales["TotOpIVAUsoComun"]["2"]="0";
$totales["TotIVAUsoComun"]["2"]="0";
$totales["FctProp"]["2"]="0";
$totales["TotCredIVAUsoComun"]["2"]="0";
$totales["TotIVAFueraPlazo"]["2"]="0";
$totales["TotIVARetTotal"]["2"]="0";
$totales["CodIVANoRec"]["2"]="4"; 
$totales["TotOpIVANoRec"]["2"]="1"; 
$totales["TotMntIVANoRec"]["2"]=$detalle["MntIVANoRec"]["2"]+$detalle["MntIVANoRec"]["5"]; 
$totales["TotMntTotal"]["2"]=$detalle["MntTotal"]["2"]+$detalle["MntTotal"]["5"]; 
# TIPO 60 (DOC 4 Y 7)
$totales["TpoDoc"]["3"]="60";
$totales["TotDoc"]["3"]=2; 
$totales["TotMntExe"]["3"]="0";
$totales["TotMntNeto"]["3"]=$detalle["MntNeto"]["4"]+$detalle["MntNeto"]["7"]; 
$totales["TotMntIVA"]["3"]=$detalle["MntIVA"]["4"]+$detalle["MntIVA"]["7"];
$totales["TotOpIVAUsoComun"]["3"]="0";
$totales["TotIVAUsoComun"]["3"]="0";
$totales["FctProp"]["3"]="0";
$totales["TotCredIVAUsoComun"]["3"]="0";
$totales["TotIVAFueraPlazo"]["3"]="0";
$totales["TotIVARetTotal"]["3"]="0";
$totales["CodIVANoRec"]["3"]="0";
$totales["TotOpIVANoRec"]["3"]="0";
$totales["TotMntIVANoRec"]["3"]="0";
$totales["TotMntTotal"]["3"]=$detalle["MntTotal"]["4"]+$detalle["MntTotal"]["7"];
# TIPO 46 (DOC 6)
$totales["TpoDoc"]["4"]="46"; 
$totales["TotDoc"]["4"]=1; 
$totales["TotMntExe"]["4"]="0";
$totales["TotMntNeto"]["4"]=$detalle["MntNeto"]["6"];
$totales["TotMntIVA"]["4"]=$detalle["MntIVA"]["6"];
$totales["CodImp"]["4"]="15"; 
$totales["TotMntImp"]["4"]=$detalle["MntImp"]["6"]; 
$totales["TotOpIVAUsoComun"]["4"]="0";
$totales["TotIVAUsoComun"]["4"]="0";
$totales["FctProp"]["4"]="0";
$totales["TotCredIVAUsoComun"]["4"]="0";
$totales["TotIVAFueraPlazo"]["4"]="0";
$totales["TotIVARetTotal"]["4"]="0";
$totales["CodIVANoRec"]["4"]="0";
$totales["TotOpIVANoRec"]["4"]="0";
$totales["TotMntIVANoRec"]["4"]="0";
$totales["TotMntTotal"]["4"]=$detalle["MntTotal"]["6"];

##############################################################
# DATOS
##############################################################
# INDICA DONDE VAN A SER GUARDADOS LOS XML PORFIRMAR Y FIRMADO
$datos["URI"]="LIBROCOMPRAS_".$caratula["PeriodoTributario"];
$datos["LIBROPORFIRMAR"]="xml/librocompras_porfirmar.xml";
$datos["LIBROFIRMADO"]="xml/librocompras_firmado.xml";


##############################################################
# INSTANCIAR LA CLASE 
##############################################################
#
$LibroCompras = new FacTronica_LibroCompras(); 

##############################################################
# LLAMADA AL METODO PARA GENERAR EL LIBRO
##############################################################
# 
$LibroCompras->Crear_LibroCompras();
#
##############################################################
# DESCARGAR ARCHIVO FIRMADO CON EL LIBRO
##############################################################
# 
echo "<a href='descargar.php?Documento=librocompras_firmado.xml' target='_blank'>Descargar Libro Compras Firmado</a>"; 
#
?>