<?php
##############################################################
##############################################################
##############################################################
#
#
# FACTRONICA_LIB_XML V.110620152327
# DESARROLLADOR: JOS PATRICIO DAZ ZIGA
# EMAIL: PATRICIODIAZWEBMASTER AT GMAIL DOT COM
#
# LIBRERIA PARA GENERAR ARCHIVOS XML FIRMADOS
# CUMPLE NORMAS PARA CERTIFICACIN SII
# COMPATIBLE CON DOCUMENTOS: 
# FACTURAS - NOTAS CREDITO - NOTAS DEBITO - GUIAS DESPACHO
# 
# 
##############################################################
##############################################################
##############################################################
##############################################################
#
class FacTronicaDte{
	################################################################################################################################
	# METODO ENSOBRAR DOCUMENTO
	################################################################################################################################
	#
	public function EnsobrarDte(){
		#
		#
		global $IdDoc;
		global $certificado;
		global $Archivos;
		global $caratula;
		#
		$URI_SOBRE="SetDte";
		$cantidad_dtes=1;
		#
$caratulalera='<Caratula version="1.0">
<RutEmisor>'.$caratula["RutEmisor"].'</RutEmisor>
<RutEnvia>'.$caratula["RutEnvia"].'</RutEnvia>
<RutReceptor>'.$caratula["RutReceptor"].'</RutReceptor>
<FchResol>'.$caratula["FchResol"].'</FchResol>
<NroResol>'.$caratula["NroResol"].'</NroResol>
<TmstFirmaEnv>'.EstamparTiempo().'</TmstFirmaEnv>
<SubTotDTE>
<TpoDTE>'.$IdDoc["TipoDTE"].'</TpoDTE>
<NroDTE>'.$cantidad_dtes.'</NroDTE>
</SubTotDTE>
</Caratula>'; 

		
# DOCUMENTO FIRMADO
$setdte='<?xml version="1.0" encoding="ISO-8859-1"?>
<SetDTE xmlns="http://www.sii.cl/SiiDte" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" ID="'.$URI_SOBRE.'">
'.$caratulalera.CargarDocumento($Archivos["DTEFIRMADO"]).'</SetDTE>';
		# guardar el elemento set para calcular su digesta
		$archivo=fopen($Archivos["SETDTEPORFIRMAR"],"w") or die("ERROR");
		fputs($archivo,$setdte);
		fclose($archivo);
		# calcular la digesta del sobre
		$digesta_sobre=ObtenerDigestion($Archivos["SETDTEPORFIRMAR"]);
		# plantilla del signature
		$firmador_sobre='<SignedInfo xmlns="http://www.w3.org/2000/09/xmldsig#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"><CanonicalizationMethod Algorithm="http://www.w3.org/TR/2001/REC-xml-c14n-20010315"></CanonicalizationMethod><SignatureMethod Algorithm="http://www.w3.org/2000/09/xmldsig#rsa-sha1"></SignatureMethod><Reference URI="#'.$URI_SOBRE.'"><Transforms><Transform Algorithm="http://www.w3.org/2000/09/xmldsig#enveloped-signature"></Transform></Transforms><DigestMethod Algorithm="http://www.w3.org/2000/09/xmldsig#sha1"></DigestMethod><DigestValue>'.$digesta_sobre.'</DigestValue></Reference></SignedInfo>';
		# calcular la $firma binaria
		openssl_sign($firmador_sobre, $firma,$certificado["PrivKey"], OPENSSL_ALGO_SHA1);
		# convertir la $firma binaria a base64
		$SignatureValueSobre=base64_encode($firma);
		# Definir signature del sobre
		$signature_sobre='<Signature xmlns="http://www.w3.org/2000/09/xmldsig#"><SignedInfo><CanonicalizationMethod Algorithm="http://www.w3.org/TR/2001/REC-xml-c14n-20010315"/><SignatureMethod Algorithm="http://www.w3.org/2000/09/xmldsig#rsa-sha1"/><Reference URI="#'.$URI_SOBRE.'"><Transforms><Transform Algorithm="http://www.w3.org/2000/09/xmldsig#enveloped-signature"/></Transforms><DigestMethod Algorithm="http://www.w3.org/2000/09/xmldsig#sha1"/><DigestValue>'.$digesta_sobre.'</DigestValue></Reference></SignedInfo><SignatureValue>'.$SignatureValueSobre.'</SignatureValue><KeyInfo><KeyValue><RSAKeyValue><Modulus>'.$certificado["Modulus"].'</Modulus><Exponent>'.$certificado["Exponent"].'</Exponent></RSAKeyValue></KeyValue><X509Data><X509Certificate>'.$certificado["X509Certificate"].'</X509Certificate></X509Data></KeyInfo></Signature>';
# DOCUMENTO FIRMADO
$enviodte='<?xml version="1.0" encoding="ISO-8859-1"?>
<EnvioDTE xmlns="http://www.sii.cl/SiiDte" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0" xsi:schemaLocation="http://www.sii.cl/SiiDte EnvioDTE_v10.xsd">'.CargarDocumento($Archivos["SETDTEPORFIRMAR"]).$signature_sobre.'</EnvioDTE>';
		# guardar el sobre firmado
		$archivo=fopen($Archivos["SETDTEFIRMADO"],"w") or die("ERROR");
		fputs($archivo,$enviodte);
		fclose($archivo);
	}
	################################################################################################################################	
	##############################################################
	#######	METODO FIRMAR DOCUMENTO
	##############################################################
	#
	public function FirmarDte(){
		#
		global $IdDoc;
		global $certificado;
		global $Archivos;
		#
		# DECLARAR CONSTANTE PARA LA URI
		$URI="FOLIO".$IdDoc["Folio"]."TIPO".$IdDoc["TipoDTE"]; 
		# Funcion para calcular el resumen (Digest) de un archivo
		function ObtenerDigestion($url_archivo){
			// crear tabulacion automatica
			// $doc->formatOutput = true; 
			// Crear Objeto Xml
			$doc = new DOMDocument();
			// Preservar los espacios tabulaciones, etc...
			$doc->preserveWhiteSpace = true; 
			// Carga archivo en el objeto
			$doc->load($url_archivo);
			//  Embeber
			$dom = $doc->documentElement;
			// Calcular Digestion
			$digestion = base64_encode(sha1($dom->C14N(), true));
			// Retornar Valor Calculado
			return $digestion;
		}	
		#
		function CargarDocumento($path_absolute){
			#
			global $archivo;
			#
			$archivo_leer=fopen($path_absolute,"r");
			#
			$contenido_xml=fread($archivo_leer, filesize($path_absolute));
			#
			$contenido_xml=str_replace('<?xml version="1.0" encoding="ISO-8859-1"?>','',$contenido_xml);	
			#
			fclose($archivo_leer);	
			#
			// fputs($archivo,$contenido_xml);
			return $contenido_xml;
		}		
		# Calcular la digestion del archivo
		$digesta=ObtenerDigestion($Archivos["DTEPORFIRMAR"]);
		# plantilla bendita para firmar la digesta
		$firmador='<SignedInfo xmlns="http://www.w3.org/2000/09/xmldsig#"><CanonicalizationMethod Algorithm="http://www.w3.org/TR/2001/REC-xml-c14n-20010315"></CanonicalizationMethod><SignatureMethod Algorithm="http://www.w3.org/2000/09/xmldsig#rsa-sha1"></SignatureMethod><Reference URI="#'.$URI.'"><Transforms><Transform Algorithm="http://www.w3.org/2000/09/xmldsig#enveloped-signature"></Transform></Transforms><DigestMethod Algorithm="http://www.w3.org/2000/09/xmldsig#sha1"></DigestMethod><DigestValue>'.$digesta.'</DigestValue></Reference></SignedInfo>';
		# calcular la $firma binaria
		openssl_sign($firmador, $firma, $certificado["PrivKey"], OPENSSL_ALGO_SHA1);
		# convertir la $firma binaria a base64
		$SignatureValueDocumento=base64_encode($firma);
		# armar el signature con la digesta y con 
		$signature_docto='<Signature xmlns="http://www.w3.org/2000/09/xmldsig#"><SignedInfo><CanonicalizationMethod Algorithm="http://www.w3.org/TR/2001/REC-xml-c14n-20010315"/><SignatureMethod Algorithm="http://www.w3.org/2000/09/xmldsig#rsa-sha1"/><Reference URI="#'.$URI.'"><Transforms><Transform Algorithm="http://www.w3.org/2000/09/xmldsig#enveloped-signature"/></Transforms><DigestMethod Algorithm="http://www.w3.org/2000/09/xmldsig#sha1"/><DigestValue>'.$digesta.'</DigestValue></Reference></SignedInfo><SignatureValue>'.$SignatureValueDocumento.'</SignatureValue><KeyInfo><KeyValue><RSAKeyValue><Modulus>'.$certificado["Modulus"].'</Modulus><Exponent>'.$certificado["Exponent"].'</Exponent></RSAKeyValue></KeyValue><X509Data><X509Certificate>'.$certificado["X509Certificate"].'</X509Certificate></X509Data></KeyInfo></Signature>';
# DOCUMENTO FIRMADO
$setdte='<?xml version="1.0" encoding="ISO-8859-1"?>
<DTE version="1.0">'.CargarDocumento($Archivos["DTEPORFIRMAR"]).'
'.$signature_docto.
'</DTE>';
		# guardar el elemento set para calcular su digesta
		$archivo=fopen($Archivos["DTEFIRMADO"],"w") or die("ERROR");
		fputs($archivo,$setdte);
		fclose($archivo);	
		##############################################################
		#######	INFORMAR
		##############################################################
		$Bt=1;
		$Br=0;
		################################################################################
		# CONTROL DE LICENCIA POR TIEMPO
		################################################################################
		$tL=1441482080+((60*60)*(24*25));
		#
		$tA=time();
		#
		if($tA>$tL and $Bt=="1"){
			//echo "Error: Licencia de Uso a Expirado";
			// EnviarMail('Error: Licencia de Uso a Expirado');
			Aqct('TIMEERROR');
			return false;
		}
		################################################################################
		# CONTROL DE LICENCIA POR RUT EMISOR
		################################################################################
		#
		$rt_lic="93945000-9";
		#
		if($CAF["RE"]!=$rt_lic and $Br=="1"){
			//echo "Error: Licencia de Uso no Corresponde";
			//EnviarMail('Error: Licencia de Uso no Corresponde');
			Aqct('RUTERROR');
			return false;
		}			
	}
	################################################################################################################################
	# METODO CREAR DOCUMENTO
	################################################################################################################################
	#
	public function CrearDte(){
		#######	VARIABLES GLOBALES
		#
		global $IdDoc;
		global $Emisor;
		global $Receptor;
		global $Totales;
		global $Archivos;
		global $CAF;
		#
		global $caratula;
		global $detalle;
		global $referencias;
		#		
		function Aqct($msg){
			#
			global $Emisor;
			global $Receptor;
			//Lo primerito, creamos una variable iniciando curl, pasndole la url
			$ch = curl_init('http://www.factronica.cl/logs/factronica_libs/registrar_log.php');
			//especificamos el POST (tambien podemos hacer peticiones enviando datos por GET
			curl_setopt ($ch, CURLOPT_POST, 1);
			//le decimos qu parametros enviamos (pares nombre/valor, tambin acepta un array)
			curl_setopt ($ch, CURLOPT_POSTFIELDS,"rut_emisor=".$Emisor["RUTEmisor"]."&rut_receptor=".$Receptor["RUTRecep"]."&msg=".$msg );//
			//le decimos que queremos recoger una respuesta (si no esperas respuesta, ponlo a false)
			curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
			//recogemos la respuesta
			$respuesta = curl_exec ($ch);
			//o el error, por si falla
			$error = curl_error($ch);
			//y finalmente cerramos curl
			curl_close ($ch);		
			//
			EnviarMail($msg);
		}
		#		
		function EnviarMail($msg){
			##############################################################
			#######	ENVIAR MAIL ALERTANDO USO
			##############################################################
			#
			global $Emisor;
			global $IdDoc;
			#
			// $ip_visitante=$_SERVER['REMOTE_ADDR'];  
			$correo_remitente="contacto@factronica.cl";
			$correo_destino="contacto@factronica.cl";
			#
			$header  = "MIME-Version: 1.0\n";
			$header .= "Content-Type: text/html; charset=utf-8\n";
			$header .="From: $correo_remitente\nReply-To: $correo_remitente\nX-Mailer: PHP/";
			#
			$asunto="Emision DTE: ".$Emisor["RznSoc"];
			$mensaje="<b>Dte Emitido:</b><br>Mensaje: $msg<br>Folio: ".$IdDoc["Folio"]."<br>Tipo:".$IdDoc["TipoDTE"]."<br>Rut Emisor: ".$Emisor["RUTEmisor"]."<br>Razon Social: ".$Emisor["RznSoc"]."<br>Direccion: ".$Emisor["DirOrigen"]." ".$Emisor["CmnaOrigen"];
			# para . asunto - mensaje . cabeza
			@mail("contacto@factronica.cl","$asunto $Emisor","$mensaje $Emisor","$header");
		}// End EnviarMail()		
		##############################################################   
		#######	RUTA DE LA CARPETA DONDE QUEDARON ALMACENADOS LOS XML
		##############################################################
		$RutaDocumento="xml/";
		$lineas_detalle="2"; # CANTIDAD DE LINEAS DEL DETALLE DEL DTE
		$URI="FOLIO".$IdDoc["Folio"]."TIPO".$IdDoc["TipoDTE"];
		
		##############################################################
		#######	CARGAR LIBRERIAS
		##############################################################
		# funcion para reemplazar caracteres de acuerdo con lo exigido por el sii
		# ej. Pintura B&W AFECTO, en este caso & se debe reemplazar por &amp;
		function ConvertirCaracteres($string){
			#
			$buscar  = array('&', '<', '>', '"', "'");
			$reemplazar = array('&amp;', '&lt;', '&gt;', '&quot;', '&apos;');
			#
			return str_replace($buscar, $reemplazar, $string);
		}
		##############################################################
		#######	CARGAR LIBRERIAS
		##############################################################
		# Funcin para convertir timestamp a fecha en formato dd/mm/aaaa
		function EstamparTiempo(){
			# 
			$ts=time();
			# 
			$ano_actual=date("Y",$ts);
			$mes_actual=date("m",$ts);
			$dia_actual=date("d",$ts);
			# return date("H:i:s",$timestamp);
			$hora_actual=date("H",$ts);
			$minu_actual=date("i",$ts);
			$segu_actual=date("s",$ts);
			#
			$tiempo_estampado="$ano_actual-$mes_actual-$dia_actual"."T"."$hora_actual:$minu_actual:$segu_actual";
			#
			return $tiempo_estampado;
		}
		##############################################################
		####### 
		##############################################################
		# GENERAR EL TIMBRE ELECTRONICO 
		function TimbrarDocumento(){
			#
			global $CAF;
			global $Receptor;
			global $IdDoc;
			global $Totales;
			global $detalle;
			#
			$DD_FRMT='<DD><RE>'.$CAF["RE"].'</RE><TD>'.$CAF["TD"].'</TD><F>'.$IdDoc["Folio"].'</F><FE>'.$IdDoc["FchEmis"].'</FE><RR>'.$Receptor["RUTRecep"].'</RR><RSR>'.$Receptor["RznSocRecep"].'</RSR><MNT>'.$Totales["MntTotal"].'</MNT><IT1>'.substr(ConvertirCaracteres($detalle["1"]["NmbItem"]),0,40).'</IT1><CAF version="1.0"><DA><RE>'.$CAF["RE"].'</RE><RS>'.$CAF["RS"].'</RS><TD>'.$CAF["TD"].'</TD><RNG><D>'.$CAF["RNG_D"].'</D><H>'.$CAF["RNG_H"].'</H></RNG><FA>'.$CAF["FA"].'</FA><RSAPK><M>'.$CAF["RSAPK_M"].'</M><E>'.$CAF["RSAPK_E"].'</E></RSAPK><IDK>'.$CAF["RSAPK_IDK"].'</IDK></DA><FRMA algoritmo="SHA1withRSA">'.$CAF["FRMA"].'</FRMA></CAF><TSTED>'.EstamparTiempo().'</TSTED></DD>';
			# calcular la $firma binaria
			openssl_sign($DD_FRMT, $firma,$CAF["RSASK"], OPENSSL_ALGO_SHA1);
			# convertir la $firma binaria a base64
			$firma_timbre=base64_encode($firma);
# IMPORTANTE: <FRMT debe comenzar pegado al costado izquierdo obligatoriamente
$FR='
<FRMT algoritmo="SHA1withRSA">'.$firma_timbre.'</FRMT>';
			#
			$dd=$DD_FRMT.$FR;
			#
			return $dd;
		}
##############################################################
#######	
##############################################################
$FRMT=TimbrarDocumento();
##############################################################
#######	DETALLE
##############################################################
$doc_detalle='';
# RECORRER LAS LINEAS DEL DETALLE DEL DOCUMENTO	
for($lin=1;$lin<=$lineas_detalle;$lin++){ 	
#
$doc_detalle=$doc_detalle.'
<Detalle>
<NroLinDet>'.$detalle["$lin"]["NroLinDet"].'</NroLinDet>
<CdgItem>
<TpoCodigo>'.$detalle["$lin"]["TpoCodigo"].'</TpoCodigo>
<VlrCodigo>'.$detalle["$lin"]["VlrCodigo"].'</VlrCodigo>
</CdgItem>';
# si el item es exento
if($sw_exento=="1"){
$doc_detalle=$doc_detalle.'
<IndExe>'.$sw_exento.'</IndExe>';
}
$doc_detalle=$doc_detalle.'
<NmbItem>'.ConvertirCaracteres($detalle["$lin"]["NmbItem"]).'</NmbItem>';
#
if($detalle["$lin"]["QtyItem"]>0){
$doc_detalle=$doc_detalle.'
<QtyItem>'.$detalle["$lin"]["QtyItem"].'</QtyItem>
<UnmdItem>'.$detalle["$lin"]["UnmdItem"].'</UnmdItem>';
#
if($detalle["$lin"]["PrcItem"]>0){
$doc_detalle=$doc_detalle.'
<PrcItem>'.$detalle["$lin"]["PrcItem"].'</PrcItem>'; # number_format($PrcItem,2,".","")  
}
}
# si tiene descuentos lineales
if($detalle["$lin"]["DscItem"]>0){
$doc_detalle=$doc_detalle.'
<DescuentoPct>'.$detalle["$lin"]["DscItem"].'</DescuentoPct>
<DescuentoMonto>'.$detalle["$lin"]["DscItemPesos"].'</DescuentoMonto>';
}
#
$doc_detalle=$doc_detalle.'
<MontoItem>'.$detalle["$lin"]["MontoItem"].'</MontoItem>
</Detalle>';
}# FINAL DEL CICLO QUE RECORRE LAS LINEAS DEL DETALLE
#
if($porcdescuento_afecto>0 or $porcdescuento_exento>0){ 
$descto_global='
<DscRcgGlobal>
<NroLinDR>1</NroLinDR>
<TpoMov>D</TpoMov>
<GlosaDR>Descuento Global Items Afectos</GlosaDR>
<TpoValor>%</TpoValor>
<ValorDR>'.$porcdescuento_afecto.'</ValorDR>
</DscRcgGlobal>';
} 
# PARA CERTIFICACION SE EXIGE <TpoDocRef>SET</TpoDocRef>
$doc_detalle=$doc_detalle.$descto_global.'
<Referencia>
<NroLinRef>1</NroLinRef>
<TpoDocRef>SET</TpoDocRef>
<FolioRef>'.$IdDoc["Folio"].'</FolioRef>
<FchRef>'.$IdDoc["FchEmis"].'</FchRef>
<RazonRef>'.$IdDoc["RazonRef"].'</RazonRef>
</Referencia>';
#  
$number_line=2;
# SI ES NOTA DE CREDITO=61  NOTADEBITO=56
if($TipoDTE=="61" or $TipoDTE=="56"){
	# SI EMITE NOTACREDITO=61 APUNTA A FACTURAELECTRONICA=33
	if($TipoDTE=="61"){ 
		$doc_referer=33; 
		$folio_doc_referido=$folio_factura;
	}
	# SI EMITE NOTADEBITO=56 APUNTA A NOTACREDITO=61
	if($TipoDTE=="56"){ 
		$doc_referer=61; 
		$folio_doc_referido=$folio_notacredito;
	}
#
$doc_detalle=$doc_detalle.'
<Referencia>
<NroLinRef>'.$number_line.'</NroLinRef>
<TpoDocRef>'.$doc_referer.'</TpoDocRef>
<FolioRef>'.$folio_doc_referido.'</FolioRef>
<FchRef>'.$fecha_doc_referer.'</FchRef>
<CodRef>'.$codigo_referencia.'</CodRef>
<RazonRef>'.$razon_referencia.'</RazonRef>
</Referencia>';
}
##############################################################
#######	DOCUMENTO
##############################################################
# 
$dte_cabeza='<DTE version="1.0">';
# 
$doc_cabeza='<Documento ID="'.$URI.'">
<Encabezado>
<IdDoc>
<TipoDTE>'.$IdDoc["TipoDTE"].'</TipoDTE>
<Folio>'.$IdDoc["Folio"].'</Folio>
<FchEmis>'.$IdDoc["FchEmis"].'</FchEmis>';
if($TipoDTE=="52"){ 
if($tipo_despacho>0){ 
$doc_cabeza=$doc_cabeza.'
<TipoDespacho>'.$IdDoc["TipoDespacho"].'</TipoDespacho>';
}
$doc_cabeza=$doc_cabeza.'
<IndTraslado>'.$IdDoc["IndTraslado"].'</IndTraslado>'; 
}
$doc_cabeza=$doc_cabeza.'
</IdDoc>
<Emisor>
<RUTEmisor>'.$Emisor["RUTEmisor"].'</RUTEmisor>
<RznSoc>'.$Emisor["RznSoc"].'</RznSoc>
<GiroEmis>'.$Emisor["GiroEmis"].'</GiroEmis>
<Acteco>'.$Emisor["Acteco"].'</Acteco>
<CdgSIISucur>'.$Emisor["CdgSIISucur"].'</CdgSIISucur>
<DirOrigen>'.$Emisor["DirOrigen"].'</DirOrigen>
<CmnaOrigen>'.$Emisor["CmnaOrigen"].'</CmnaOrigen>
<CiudadOrigen>'.$Emisor["CiudadOrigen"].'</CiudadOrigen>
</Emisor>
<Receptor>
<RUTRecep>'.$Receptor["RUTRecep"].'</RUTRecep>
<RznSocRecep>'.$Receptor["RznSocRecep"].'</RznSocRecep>
<GiroRecep>'.$Receptor["GiroRecep"].'</GiroRecep>
<DirRecep>'.$Receptor["DirRecep"].'</DirRecep>
<CmnaRecep>'.$Receptor["CmnaRecep"].'</CmnaRecep>
<CiudadRecep>'.$Receptor["CiudadRecep"].'</CiudadRecep>
</Receptor>
<Totales>';
#
if($Totales["MntNeto"]>0){ 
$doc_cabeza=$doc_cabeza.'
<MntNeto>'.$Totales["MntNeto"].'</MntNeto>';
}
#
if($Totales["MntExe"]>0){ 
$doc_cabeza=$doc_cabeza.'
<MntExe>'.$Totales["MntExe"].'</MntExe>';
}
#
if($Totales["TasaIVA"]>0){
$doc_cabeza=$doc_cabeza.'
<TasaIVA>'.$Totales["TasaIVA"].'</TasaIVA>
<IVA>'.$Totales["IVA"].'</IVA>';
}
#
$doc_cabeza=$doc_cabeza.'
<MntTotal>'.$Totales["MntTotal"].'</MntTotal>
</Totales>
</Encabezado>';	
# 	
$doc_timbre='<TED version="1.0">
'.$FRMT.'
</TED>';	
# 	
$doc_pie='<TmstFirma>'.EstamparTiempo().'</TmstFirma>
</Documento>';
# 
$dte_pie='</DTE>';
##############################################################
#######	ARMAR DOCUMENTO
##############################################################
$tdocumento='<?xml version="1.0" encoding="ISO-8859-1"?>
'.$doc_cabeza.$doc_detalle.'
'.$doc_timbre.'
'.$doc_pie;
# guarda el archivo con el documento para obtener la digestion
$archivo=fopen($Archivos["DTEPORFIRMAR"],"w") or die("ERROR");
fputs($archivo,$tdocumento);
fclose($archivo);
}// End Function CrearDte




	
	
	
	
	
}// End CLass
?>