class Modulo extends App {
    constructor (id, url) {
        super(id, url);
        this.idTablas = [];
        this.tablas = {};
    }

    generarBotones(id){
    	return '<div class="btn-group" role="group" aria-label="acciones"> \
		<button type="button" class="btn btn-warning btn-xs btn-submit" data-accion="editar" data-id="'+id+'" data-loading-text="Procesando...">Editar</button> \
		<button class="btn btn-danger btn-xs btn-submit" data-accion="eliminar" data-id="'+id+'" data-loading-text="Quitando...">Quitar</button>\
		</div>';
    }

    init(){
      super.init();
      this.initForm();
    }

    initTablas(){
  		var _this = this;
  		var formatPesos = $.fn.dataTable.render.number('.', ',', 0, '$ ').display;
      var formatCantidad = $.fn.dataTable.render.number('.', ',', 2, '').display;

  		var columnasResumen = [
        { 'data' : 'tipo' },
        { 'data' : 'nombre' },
        { 'data' : 'nDocs' },
        //{ 'data' : 'neto',
        //render : $.fn.dataTable.render.number('.', ',', 0, '$ ') },
        { 'data' : 'neto_exento',
        render : $.fn.dataTable.render.number('.', ',', 0, '$ ') },
        //{ 'data' : 'iva',
        //render : $.fn.dataTable.render.number('.', ',', 0, '$ ') },
        { 'data' : 'impuestos',
        render : $.fn.dataTable.render.number('.', ',', 0, '$ ') },
        { 'data' : 'bruto',
        render : $.fn.dataTable.render.number('.', ',', 0, '$ ') }
      ];

      var columnasFacturas = [
        {'data' : 'tipo'},
        {'data' : 'folio'},
        {'data' : 'fecha'},
        {'data' : 'rut'},
        {'data' : 'razonSocial'},
      //  {'data' : 'neto',
      //  render : $.fn.dataTable.render.number('.', ',', 0, '$ ')},
        {'data' : 'neto_exento',
        render : $.fn.dataTable.render.number('.', ',', 0, '$ ')},
      //  {'data' : 'iva',
      //  render : $.fn.dataTable.render.number('.', ',', 0, '$ ')},
        {'data' : 'montoImpuesto'},
        {'data' : 'codigoImpuesto'},
        {'data' : 'bruto',
        render : $.fn.dataTable.render.number('.', ',', 0, '$ ')}
      ];

      var columnasNotas = [
        {'data' : 'tipo'},
        {'data' : 'folio'},
        {'data' : 'fecha'},
        {'data' : 'referencia'},
        {'data' : 'rut'},
        {'data' : 'razonSocial'},
      //  {'data' : 'neto',
      //  render : $.fn.dataTable.render.number('.', ',', 0, '$ ')},
        {'data' : 'neto_exento',
        render : $.fn.dataTable.render.number('.', ',', 0, '$ ')},
      //  {'data' : 'iva',
      //  render : $.fn.dataTable.render.number('.', ',', 0, '$ ')},
        {'data' : 'montoImpuesto'},
        {'data' : 'codigoImpuesto'},
        {'data' : 'bruto',
        render : $.fn.dataTable.render.number('.', ',', 0, '$ ')}
      ];

      var columnasImpuestos = [
        { 'data' : 'codigo' },
        { 'data' : 'descripcion' },
        { 'data' : 'nombre' },
        { 'data' : 'nDocs' },
        { 'data' : 'monto',
        render : $.fn.dataTable.render.number('.', ',', 0, '$ ') }];

  		this.tablas['resumen'] = {
  			tabla: $(this.idTabla+'-resumen')
    			.DataTable({
	        		columns: columnasResumen,
					    processing: true,
              "footerCallback" : function ( row, data, start, end, display ) {
                var api = this.api();
                // Remove the formatting to get integer data for summation
                var intVal = function ( j ) {
                    return typeof j === 'string' ?
                        j.replace(/[\$,]/g, '')*1 :
                        typeof j === 'number' ?
                            j : 0;
                };
                var numFormat = $.fn.dataTable.render.number('.', ',', 0, '$ ').display;
                var columnasSuma = [2,3,4,5];
                var columnaTotal = 1;
                $.each(columnasSuma,function(index,columna){
                  var total = api
                      .column( columna )
                      .data()
                      .reduce( function (a, b) {
                          return intVal(a) + intVal(b);
                      }, 0 );
                  $( api.column( columna ).footer() ).html(numFormat(total) );
                });
                $( api.column( columnaTotal ).footer() ).html('TOTAL');
              }
        }),
    		cargado: false,
  		};
      /*
      this.tablas['B'] = {
  			tabla: $(this.idTabla+'-B')
    			.DataTable({
	        		columns: columnasFacturas,
					    processing: true,
              footerCallback : function(){
                var api = this.api();
                // Remove the formatting to get integer data for summation
                var intVal = function ( j ) {
                    return typeof j === 'string' ?
                        j.replace(/[\$,]/g, '')*1 :
                        typeof j === 'number' ?
                            j : 0;
                };
                var numFormat = $.fn.dataTable.render.number('.', ',', 0, '$ ').display;
                var columnasSuma = [5,6,7,10];
                var columnaTotal = 4;
                $.each(columnasSuma,function(index,columna){
                  var total = api
                      .column( columna )
                      .data()
                      .reduce( function (a, b) {
                          return intVal(a) + intVal(b);
                      }, 0 );
                  $( api.column( columna ).footer() ).html(numFormat(total) );
                });
                $( api.column( columnaTotal ).footer() ).html('TOTAL');
              }
        }),
    		cargado: false,
      };
      */

  		this.tablas['FEX'] = {
  			tabla: $(this.idTabla+'-F')
    			.DataTable({
	        		columns: columnasFacturas,
					    processing: true,
              footerCallback : function(){
                var api = this.api();
                // Remove the formatting to get integer data for summation
                var intVal = function ( j ) {
                    return typeof j === 'string' ?
                        j.replace(/[\$,]/g, '')*1 :
                        typeof j === 'number' ?
                            j : 0;
                };
                var numFormat = $.fn.dataTable.render.number('.', ',', 0, '$ ').display;
                var columnasSuma = [2,3,4,5];
                var columnaTotal = 4;
                $.each(columnasSuma,function(index,columna){
                  var total = api
                      .column( columna )
                      .data()
                      .reduce( function (a, b) {
                          return intVal(a) + intVal(b);
                      }, 0 );
                  $( api.column( columna ).footer() ).html(numFormat(total) );
                });
                $( api.column( columnaTotal ).footer() ).html('TOTAL');
              }
        }),
    		cargado: false,
  		};

  		this.tablas['NEX'] = {
  			tabla: $(this.idTabla+'-C')
    			.DataTable({
          		columns: columnasNotas,
  				    processing: true,
              footerCallback : function(){
                var api = this.api();
                // Remove the formatting to get integer data for summation
                var intVal = function ( j ) {
                    return typeof j === 'string' ?
                        j.replace(/[\$,]/g, '')*1 :
                        typeof j === 'number' ?
                            j : 0;
                };
                var numFormat = $.fn.dataTable.render.number('.', ',', 0, '$ ').display;
                var columnasSuma = [2,3,4,5];
                var columnaTotal = 4;
                $.each(columnasSuma,function(index,columna){
                  var total = api
                      .column( columna )
                      .data()
                      .reduce( function (a, b) {
                          return intVal(a) + intVal(b);
                      }, 0 );
                  $( api.column( columna ).footer() ).html(numFormat(total) );
                });
                $( api.column( columnaTotal ).footer() ).html('TOTAL');
              }
        }),
    		cargado: false,
  		};

      /*
  		this.tablas['D'] = {
  			tabla: $(this.idTabla+'-D')
    			.DataTable({
	        		columns: columnasNotas,
					    processing: true,
              footerCallback : function(){
                var api = this.api();
                // Remove the formatting to get integer data for summation
                var intVal = function ( j ) {
                    return typeof j === 'string' ?
                        j.replace(/[\$,]/g, '')*1 :
                        typeof j === 'number' ?
                            j : 0;
                };
                var numFormat = $.fn.dataTable.render.number('.', ',', 0, '$ ').display;
                var columnasSuma = [6,7,8,11];
                var columnaTotal = 5;
                $.each(columnasSuma,function(index,columna){
                  var total = api
                      .column( columna )
                      .data()
                      .reduce( function (a, b) {
                          return intVal(a) + intVal(b);
                      }, 0 );
                  $( api.column( columna ).footer() ).html(numFormat(total) );
                });
                $( api.column( columnaTotal ).footer() ).html('TOTAL');
              }
        }),
    		cargado: false,
  		}; */

  		this.tablas['impuestos'] = {
  			tabla: $(this.idTabla+'-impuestos')
    			.DataTable({
	        		columns: columnasImpuestos,
					    processing: true,
              footerCallback : function(){
                var api = this.api();
                // Remove the formatting to get integer data for summation
                var intVal = function ( j ) {
                    return typeof j === 'string' ?
                        j.replace(/[\$,]/g, '')*1 :
                        typeof j === 'number' ?
                            j : 0;
                };
                var numFormat = $.fn.dataTable.render.number('.', ',', 0, '$ ').display;
                var columnasSuma = [3,4];
                var columnaTotal = 2;
                $.each(columnasSuma,function(index,columna){
                  var total = api
                      .column( columna )
                      .data()
                      .reduce( function (a, b) {
                          return intVal(a) + intVal(b);
                      }, 0 );
                  $( api.column( columna ).footer() ).html(numFormat(total) );
                });
                $( api.column( columnaTotal ).footer() ).html('TOTAL');
              }
        }),
    		cargado: false,
  		};

		  var params = '&mes='+ this._datos.mes +'&ano='+ this._datos.anio;
      this.tabla = this.tablas[this.idTablas[0]].tabla;
    	this.tabla.ajax.url(this.url +'?a=datos&codigo='+ this.idTablas[0] + params);
    	this.tablas[this.idTablas[0]].cargado = true;
      $('button[data-codigo="resumen"]').click();

    	$('button[data-toggle="collapse"]').on('click', function (e) {

  			var codigo = $(this).data().codigo;//e.target.dataset.codigo;
        //alert(e,codigo);
  			//delete _this.fila;
  			_this.tabla = _this.tablas[codigo].tabla;
    		if(!_this.tablas[codigo].cargado){
	    		_this.tabla.ajax.url(_this.url + '?a=datos&codigo='+ codigo + params);
	        _this.tabla.ajax.reload();
	        _this.tablas[codigo].cargado = true;
    		}
		  });

    	return this.tablas;
	}

  ocultar(){
    $("#tablas").hide(700);
    $(".btn-warning").hide(700);
    $(".btn-success").hide(700);
    return true;
  }

	buscar(buttonElem, nueva = true){
		// var _this = this;
		var $boton = $(buttonElem);
		$(buttonElem).button('loading');
		if(nueva){
			this.form.elements['pagina'].value = 1;
		}
    var sCallback = function(r){
			$(buttonElem).button('reset');
			$('#tablas').html(r).show(500);
      $(".btn-warning").show(500);
      $(".btn-success").show(500);

		}
    return this.submit(sCallback);
	}

	buscarSiguiente(buttonElem){
		var campoPagina = this.form.elements['pagina'];
		campoPagina.value = parseInt(campoPagina.value) +1;
		this.buscar(buttonElem, false);
	}

	buscarAnterior(buttonElem){
		var campoPagina = this.form.elements['pagina'];
		var pActual = parseInt(campoPagina.value);
		campoPagina.value = pActual <= 1 ? 1 : pActual -1;
		this.buscar(buttonElem, false);
	}

}
