<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

class LibroVentas {
  public $mes;
  public $anio;
  public $documentos;
  public $tipoDocumentos;
  public $catDocumentos;

  public function __construct($anio,$mes){
    $this->anio = $anio *1;
    $mes *= 1;
    $this->mes = $mes >= 10 ? $mes : '0'.$mes;
    // boleta, factura, credito, debito
    $this->tipoDocumentos = ['FEX', 'NEX']; //['B', 'F', 'C', 'D'];
    $this->catDocumentos = [
    //  'B' => 'Boletas',
      'FEX' => 'Facturas',
      'NEX' => 'Notas de Credito',
    //  'D' => 'Notas de Debito',
    ];
    $this->leerDocumentos();
    $this->prepararConsulta();
  }

  public function leerDocumentos(){
    global $baseDatosServidor;

    $sql = "SELECT GROUP_CONCAT(codigo) codigos, GROUP_CONCAT(nombre) nombres, GROUP_CONCAT(cod_sii) cod_sii, campo_folio, tabla, tabla_detalle, atributos, atributos_detalle
    FROM $baseDatosServidor.tbl_documentos
    WHERE tipo = 'E' AND ";
    $nTipos = count($this->tipoDocumentos);
    for($i = 0; $i < $nTipos; $i++){
      if($i == 0){
        $sql .= "(";
      }

      $sql .= "codigo LIKE '{$this->tipoDocumentos[$i]}%'";

      if($i < ($nTipos-1)){
        $sql .= " OR ";
      }
    }
    $sql .= ")
    GROUP BY tabla";

    $query = EjecutarSql($sql);

    while($r = mysql_fetch_array($query)){

      $codigos = explode(',', $r['codigos']);
      $nombres = explode(',', $r['nombres']);
      $cod_sii = explode(',', $r['cod_sii']);

      $tipo = $codigos[0];
      $tipos = [];
      for($i = 0; $i < count($codigos); $i++){
        $tipos[$cod_sii[$i]] = [
          'nombre' => $nombres[$i],
          'cod_sii' => $cod_sii[$i],
          'codigo' => $codigos[$i].'E',
        ];
      }

      $this->documentos[$tipo] = [
        'tipos' => $tipos,
        'campo_folio' => $r['campo_folio'],
        'tabla' => $r['tabla'],
        'tabla_detalle' => $r['tabla_detalle'],
        'atributos' => json_decode($r['atributos'], true),
        'atributos_detalle' => json_decode($r['atributos_detalle'], true),
      ];
    }
    mysql_free_result($query);

  }

  public function prepararConsulta(){
    // $documentos = $this->documentos;
    foreach($this->documentos as $t => $doc){
      $sql = "SELECT
        '{$t}' categoria
        , t.{$doc['atributos']['id']} id
        , t.{$doc['atributos']['tipoDocumento']} tipo_documento
        , t.{$doc['atributos']['folio']} folio
        , t.{$doc['atributos']['fechaFacturacion']} fecha_facturacion
        , t.{$doc['atributos']['rut']} rut
        , t.{$doc['atributos']['razonSocial']} razon_social

        , t.{$doc['atributos']['netoExento']} neto_exento

        , t.{$doc['atributos']['bruto']} bruto";

        // , t.{$doc['atributos']['neto']} neto
        //, t.{$doc['atributos']['iva']} iva

      $sql .= isset($doc['atributos']['folioReferencia']) ?
        ", t.{$doc['atributos']['folioReferencia']} ref_folio" :
        ", 0 ref_folio";

      $sql .= isset($doc['atributos']['tipoDocumentoReferencia']) ?
        ", t.{$doc['atributos']['tipoDocumentoReferencia']} ref_tipo" :
        ", 0 ref_tipo";

      $sql.= ", SUM(det.{$doc['atributos_detalle']['montoImpuestoAdicional']}) impuesto_monto
        , det.{$doc['atributos_detalle']['codigoImpuestoAdicional']} impuesto_codigo
        , i.nombre impuesto_nombre
        , i.descripcion impuesto_descr
        FROM {$doc['tabla']} t
        LEFT JOIN {$doc['tabla_detalle']} det
          ON t.{$doc['atributos']['id']} = det.{$doc['atributos_detalle']['idEncabezado']}
        LEFT JOIN tbl_sii_otrosimpuestos i
          ON det.{$doc['atributos_detalle']['codigoImpuestoAdicional']} = i.codigo
        WHERE (t.{$doc['atributos']['estado']} = 'GR' or t.{$doc['atributos']['estado']} = 'EP')
        AND t.{$doc['atributos']['fechaFacturacion']} LIKE '%/{$this->mes}/{$this->anio}'
        GROUP BY folio, impuesto_codigo
        ORDER BY folio
        ";

        //  or t.{$doc['atributos']['estado']} = 'EP')
        // WHERE t.{$doc['atributos']['estado']} = 'PR'
        //t.{$doc['atributos']['estado']} = 'GR'

      unset($this->documentos[$t]['campo_folio']);
      unset($this->documentos[$t]['tabla']);
      unset($this->documentos[$t]['tabla_detalle']);
      unset($this->documentos[$t]['atributos']);
      unset($this->documentos[$t]['atributos_detalle']);
      $this->documentos[$t]['sql'] = $sql;
    }
  }

  public function obtenerDatos($docs = NULL){
    $documentos = isset($docs) && is_array($docs) ? $docs : $this->tipoDocumentos;

    $nDocs = count($documentos);
    $sql = "";
    foreach($documentos as $d){
      $sql .= "({$this->documentos[$d]['sql']})";
      $nDocs -= 1;
      if($nDocs > 0){
        $sql .= " UNION ALL ";
      }
    }

    $query = EjecutarSql($sql);
    $folioAnterior = 0;
    $tipoAnterior = 0;
    $resumen = [];
    $detalle = [];
    $documento = [];
    $resumenImpuestos = [];

    while($r = mysql_fetch_array($query)){
      $tipo = $r['tipo_documento'] *1;
      $folio = $r['folio'] *1;
      $codImpuesto = $r['impuesto_codigo'];
      //$neto = $r['neto'] *1;
      $netoExento = $r['neto_exento'] *1;
      //$iva = $r['iva'] *1;
      $bruto = $r['bruto'] *1;
      $montoImpuesto = $r['impuesto_monto'] *1;

      $categoria = $r['categoria'];
      $docDiferente = $folio != $folioAnterior || $tipo != $tipoAnterior;

      if(!array_key_exists($tipo, $resumen)){
        $resumen[$tipo] = [
          'tipo' => $tipo,
          'nombre' => $this->documentos[$categoria]['tipos'][$tipo]['nombre'],
          'nDocs' => 0,
          //'neto' => 0,
          'neto_exento' => 0,
          //'iva' => 0,
          'impuestos' => 0,
          'bruto' => 0,
        ];
      }

      if($categoria == 'NEX'){
        //$neto *= -1;
        $netoExento *= -1;
        //$iva *= -1;
        $bruto *= -1;
        $montoImpuesto *= -1;
      }

      if($docDiferente){
        $documento = [
          'tipo' => $tipo,
          'folio' => $folio,
          'fecha' => $r['fecha_facturacion'],
          'referencia' => "{$r['ref_tipo']} - {$r['ref_folio']}",
          'rut' => $r['rut'],
          'razonSocial' => utf8_encode( $r['razon_social'] ),
          //'neto' => $neto,
          'neto_exento' => $netoExento,
          //'iva' => $iva,
          'montoImpuesto' => '',
          'codigoImpuesto' => '',
          'bruto' => $bruto,
          'impuestos' => array(),
        ];

        $resumen[$tipo]['nDocs'] += 1;
        //$resumen[$tipo]['neto'] += $neto;
        $resumen[$tipo]['neto_exento'] += $netoExento;
        //$resumen[$tipo]['iva'] += $iva;
        $resumen[$tipo]['bruto'] += $bruto;
      }

      if($r['impuesto_monto'] > 0){
        if(!array_key_exists($codImpuesto, $resumenImpuestos)){
          $resumenImpuestos[$codImpuesto] = [
            'codigo' => $codImpuesto,
            'nombre' => utf8_encode( $r['impuesto_nombre'] ),
            'descripcion' => utf8_encode( $r['impuesto_descr'] ),
            'nDocs' => 0,
            'monto' => 0,
          ];
        }

        $documento['impuestos'][$codImpuesto] = $montoImpuesto;
        $montoImpuestoFormat = number_format($montoImpuesto, 0, ',', '.');
        $documento['montoImpuesto'] .= "$ {$montoImpuestoFormat}<br>";
        $documento['codigoImpuesto'] .= "{$codImpuesto}<br>";
        $resumen[$tipo]['impuestos'] += $montoImpuesto;

        $resumenImpuestos[$codImpuesto]['monto'] += $montoImpuesto;
        if($docDiferente){
          $resumenImpuestos[$codImpuesto]['nDocs'] += 1;
        }
      }

      $detalle[$categoria][] = $documento;
      $folioAnterior = $folio;
      $tipoAnterior = $tipo;
    }
    mysql_free_result($query);

    return [
      'resumen' => $resumen,
      'detalle' => $detalle,
      'impuestos' => $resumenImpuestos,
    ];

  }


}
