<?php
// parametros de entrada
$accion = $_GET['a'];
$rutaCarpeta = __DIR__;

ob_start();
// libreria base
require('leer.php');
require('../../librerias/php/header.php');
$buffClean = ob_get_contents();
ob_end_clean();

error_reporting(E_ALL);
ini_set('display_errors', 1);

// util meses
$mesesNombre = [
    1 => 'ENERO',
    2 => 'FEBRERO',
    3 => 'MARZO',
    4 => 'ABRIL',
    5 => 'MAYO',
    6 => 'JUNIO',
    7 => 'JULIO',
    8 => 'AGOSTO',
    9 => 'SEPTIEMBRE',
    10 => 'OCTUBRE',
    11 => 'NOVIEMBRE',
    12 => 'DICIEMBRE',
];

if($accion == "buscar"){
    // filtros
    $anio = $_POST['anio'];
    $mes = $_POST['mes'];
    $pagina = (int) $_POST['pagina'];

    include(__DIR__."/../vistas/tabla.php");
}

if($accion == "datos"){

    $mes = $_GET['mes'];
    $anio = $_GET['ano'];
    $libro = new LibroVentas($anio, $mes);

    $data = $libro->obtenerDatos();
    $categoria = $_GET['codigo'];

    if($categoria == 'resumen'){
      $ventas = array_values($libro->obtenerDatos()['resumen']);
    }
    elseif($categoria == 'impuestos'){
      $ventas = array_values($libro->obtenerDatos()['impuestos']);
    }
    else {
      $ventas = $libro->obtenerDatos([$categoria])['detalle'];
      $ventas = count($ventas) > 0 ? $ventas[$categoria] : [];
    }
    //header('Content-Type: application/json');
    echo json_encode(['data' => $ventas], JSON_UNESCAPED_UNICODE);

}

if($accion == "exportar"){
    $tipo  = $_GET['t'];
    $mes   = $_POST['mes']>=10 ? $_POST['mes'] : '0'.$_POST['mes'];
    $anio  = $_POST['anio'];
    $libro = new LibroVentas($anio, $mes);
    $datosLibro = $libro->obtenerDatos();

    $campos = [
      'tipo' => 'TIPO',
      'folio' => 'FOLIO',
      'fecha' => 'FECHA',
      'referencia' => 'REFERENCIA',
      'rut' => 'RUT',
      'razonSocial' => 'RAZON SOCIAL',
      //'neto' => 'NETO',
      'neto_exento' => 'NETO EXENTO',
      // 'iva' => 'IVA',
      'montoImpuesto' => 'MONTO OTROS IMPUESTOS',
      'codigoImpuesto' => 'CODIGO OTROS IMPUESTOS',
      'bruto' => 'TOTAL',
     ];

    $info = "El siguiente informe corresponde al Libro Exportacion Ventas de  {$mesesNombre[intval($mes)]} del año {$anio}. ";
    if($tipo == "excel"){
        require_once($basePath."/librerias/php/clases/crearExcel.php");

        $excel = new crearExcel("Libro Exportacion Ventas {$mesesNombre[intval($mes)]}" , $rutaCarpeta);
        $excel->setInfo($info);

        // Resumen
        $cabeceraResumen = array('TIPO','DOCUMENTO','CANTIDAD','EXENTO','OTROS IMPUESTOS','BRUTO') ;
        //$cabeceraResumen = array('TIPO','DOCUMENTO','CANTIDAD','NETO','EXENTO','IVA','OTROS IMPUESTOS','BRUTO') ;

        $tablaResumen = array();
        $cantidadDocumentos = 0;
        $sumaNeto = 0;
        $sumaExento = 0;
        $sumaIva = 0;
        $sumaImpuesto = 0;
        $sumaBruto = 0;


        foreach ($datosLibro['resumen'] as $i => $fila) {
            $tablaResumen[] = array_values($fila);
            $cantidadDocumentos += $fila['nDocs'];
            //$sumaNeto += $fila['neto'];
            $sumaExento += $fila['neto_exento'];
            //$sumaIva += $fila['iva'];
            $sumaImpuesto += $fila['impuestos'];
            $sumaBruto += $fila['bruto'];
        }
        unset($datosLibro['resumen']);
        //$tablaResumen[] = array('*','_TOTALES_',"_{$cantidadDocumentos}_","_{$sumaNeto}_","_{$sumaExento}_","_{$sumaIva}_","_{$sumaImpuesto}_","_{$sumaBruto}_");
        $tablaResumen[] = array('*','_TOTALES_',"_{$cantidadDocumentos}_","_{$sumaExento}_","_{$sumaImpuesto}_","_{$sumaBruto}_");
        $excel->addContenido('Resumen', $cabeceraResumen, $tablaResumen);

        // resumen impuestos

        $cabeceraImpuesto = array('CODIGO','NOMBRE','DESCRIPCION','CANTIDAD DOCUMENTOS','MONTO');
        $tablaImpuesto = array();
        $suma = 0;
        $cantidad = 0;
        foreach ($datosLibro['impuestos'] as $key => $fila) {
          $tablaImpuesto[] = array_values( $fila );
          $suma += $fila['monto'];
          $cantidad += $fila['nDocs'];
        }
        unset($datosLibro['impuestos']);
        $tablaImpuesto[] = array('*','*','_TOTALES_',"_{$cantidad}_","_{$suma}_");
        $excel->addContenido('Impuestos Adicionales', $cabeceraImpuesto, $tablaImpuesto);

        // documentos
        $i=0;
        foreach($datosLibro['detalle'] as $cat => $documentos){

          $cabeceraDocumentos = $campos;
          $tieneReferencia = in_array($cat, array('FEX', 'NEX'));
          if(!$tieneReferencia){
            unset($cabeceraDocumentos['referencia']);
          }

          //hoja categoria
          $tablaDocumentos = array();
          $sumaNeto = 0;
          $sumaExento = 0;
          $sumaIva = 0;
          $sumaImpuesto = 0;
          $sumaTotal = 0;
          foreach ($documentos as $doc) {
              // if(!$tieneReferencia){
              //   unset($doc['referencia']);
              // }
              $tieneImpuestos = count($doc['impuestos']) > 0;
              $doc['montoImpuesto'] = $tieneImpuestos ? array_sum($doc['impuestos']) : 0;
              $doc['codigoImpuesto'] = $tieneImpuestos ? implode(",", array_keys($doc['impuestos'])) : 0;

              $doc = array_intersect_key($doc, $cabeceraDocumentos);
              $tablaDocumentos[] = array_values( $doc );
              //$sumaNeto += $doc['neto'];
              $sumaExento += $doc['neto_exento'];
              //$sumaIva += $doc['iva'];
              $sumaImpuesto += $doc['montoImpuesto'];
              $sumaTotal += $doc['bruto'];
          }

          if(!$tieneReferencia){
            //$tablaDocumentos[] = array('*','*','*','*','_TOTALES_',"_{$sumaNeto}_","_{$sumaExento}_","_{$sumaIva}_","_{$sumaImpuesto}_","__","_{$sumaTotal}_");
            $tablaDocumentos[] = array('*','*','*','*','_TOTALES_',"_{$sumaExento}_","_{$sumaImpuesto}_","__","_{$sumaTotal}_");
          }
          else {
            //$tablaDocumentos[] = array('*','*','*','*','*','_TOTALES_',"_{$sumaNeto}_","_{$sumaExento}_","_{$sumaIva}_","_{$sumaImpuesto}_","__","_{$sumaTotal}_");
            $tablaDocumentos[] = array('*','*','*','*','*','_TOTALES_',"_{$sumaExento}_","_{$sumaImpuesto}_","__","_{$sumaTotal}_");
          }
          $excel->addContenido($libro->catDocumentos[$cat], array_values($cabeceraDocumentos), $tablaDocumentos);

        }

        unset($datosLibro['detalle']);
        $archivo = $excel->obtener();


    }

    if($tipo == "pdf"){
        require_once($basePath."/librerias/php/clases/informePdf.php");
        $camposPeso = [
          //'neto',
          'neto_exento',
          //'iva',
          'impuestos',
          'monto',
          'bruto',
          'montoImpuesto',
        ];

        $docPdf = new InformePdf($rutaCarpeta, 'Libro Exportacion Ventas');
        $docPdf->setInfo($info);
        $docPdf->makeTitulo();
        $docPdf->pdf->SetFont(PDF_FONT_NAME_DATA, '', '6');

        // Resumen
        $estructura = "<h3>Resumen</h3>
        <table style=\"border-collapse:collapse;\" width=\"100%\" bordercolor=\"#333333\" border=\"1\">
                        <tr>
                          <td><strong>TIPO</strong></td>
                          <td><strong>DOCUMENTO</strong></td>
                          <td><strong>CANTIDAD</strong></td>

                          <td><strong>EXENTO</strong></td>

                          <td><strong>OTROS IMPUESTOS</strong></td>
                          <td><strong>BRUTO</strong></td>
                        </tr>
                        ";
                        // <td><strong>NETO</strong></td>
                        //<td><strong>IVA</strong></td>
        $cantidadDocumentos = 0;
        $sumaNeto = 0;
        $sumaExento = 0;
        $sumaIva = 0;
        $sumaImpuesto = 0;
        $sumaBruto = 0;
        foreach ($datosLibro['resumen'] as $i => $fila) {
            $estructura .= "<tr>";
            foreach ($fila as $ii => $f) {
              if(in_array($ii, $camposPeso)){
                $f = "$ " . number_format($f, 0, ',', '.');
              }
              $estructura .= "<td>{$f}</td>";
            }
            $estructura .= "</tr>";
            $cantidadDocumentos += $fila['nDocs'];
            //$sumaNeto += $fila['neto'];
            $sumaExento += $fila['neto_exento'];
            //$sumaIva += $fila['iva'];
            $sumaImpuesto += $fila['impuestos'];
            $sumaBruto += $fila['bruto'];
        }

        //$sumaNeto = number_format($sumaNeto, 0, ',', '.');
        $sumaExento = number_format($sumaExento, 0, ',', '.');
        //$sumaIva = number_format($sumaIva, 0, ',', '.');
        $sumaImpuesto = number_format($sumaImpuesto, 0, ',', '.');
        $sumaBruto = number_format($sumaBruto, 0, ',', '.');

        $estructura .= "<tr>
                          <td></td>
                          <td><strong>TOTAL</strong></td>
                          <td><strong>$cantidadDocumentos</strong></td>

                          <td><strong>$ {$sumaExento}</strong></td>

                          <td><strong>$ {$sumaImpuesto}</strong></td>
                          <td><strong>$ {$sumaBruto}</strong></td>
                        </tr>
                      </table>
                      <br><br><br>";
                      //<td><strong>$ {$sumaNeto}</strong></td>
                      // <td><strong>$ {$sumaIva}</strong></td>


        $docPdf->agregarHtml($estructura);

        // resumen impuesto
        $estructura = "<h3>Resumen de Impuestos</h3>
        <table style=\"border-collapse:collapse;\" width=\"100%\" bordercolor=\"#333333\" border=\"1\">
                        <tr>
                          <td><strong>CODIGO</strong></td>
                          <td><strong>NOMBRE</strong></td>
                          <td><strong>DESCRIPCION</strong></td>
                          <td><strong>CANTIDAD DOCUMENTOS</strong></td>
                          <td><strong>MONTO</strong></td>
                        </tr>
                        ";
        $cantidad = 0;
        $suma = 0;
        foreach ($datosLibro['impuestos'] as $i => $fila) {
          $estructura .= "<tr>";
          foreach ($fila as $ii => $f) {
            if(in_array($ii, $camposPeso)){
              $f = "$ " . number_format($f, 0, ',', '.');
            }
            $estructura .= "<td>{$f}</td>";
          }
          $estructura .= "</tr>";
          $suma += $fila['monto'];
          $cantidad += $fila['nDocs'];
        }
        $suma = number_format($suma, 0, ',', '.');
        $estructura .= "<tr>
                          <td>&nbsp;</td>
                          <td>&nbsp;</td>
                          <td><strong>TOTAL</strong></td>
                          <td><strong>$cantidad</strong></td>
                          <td><strong>$ {$suma}</strong></td>
                        </tr>
                      </table>
                      <br><br><br>";

        $docPdf->agregarHtml($estructura);

        // documentos
        foreach($datosLibro['detalle'] as $cat => $documentos){

          $cabeceraDocumentos = $campos;
          $tieneReferencia = in_array($cat, array('NEX', 'D'));
          if(!$tieneReferencia){
            unset($cabeceraDocumentos['referencia']);
          }

          $estructura = "<h3>{$libro->catDocumentos[$cat]}</h3>
                      <table style=\"border-collapse:collapse;\" width=\"100%\" bordercolor=\"#333333\" border=\"1\">
                        <tr>";
          foreach($cabeceraDocumentos as $columna){
            $estructura .= "<td><strong>{$columna}</strong></td>";
          }
          $estructura .= "</tr>";

          //hoja categoria
          $sumaNeto = 0;
          $sumaExento = 0;
          $sumaIva = 0;
          $sumaImpuesto = 0;
          $sumaTotal = 0;
          foreach ($documentos as $doc) {
            $tieneImpuestos = count($doc['impuestos']) > 0;
            $doc['montoImpuesto'] = $tieneImpuestos ? array_sum($doc['impuestos']) : 0;
            $doc['codigoImpuesto'] = $tieneImpuestos ? implode(",", array_keys($doc['impuestos'])) : 0;

            $doc = array_intersect_key($doc, $cabeceraDocumentos);

            $estructura .= "<tr>";
            foreach ($doc as $ii => $f) {
              if(in_array($ii, $camposPeso)){
                $f = "$ " . number_format($f, 0, ',', '.');
              }
              $estructura .= "<td>{$f}</td>";
            }
            $estructura .= "</tr>";

            //$sumaNeto += $doc['neto'];
            $sumaExento += $doc['neto_exento'];
            //$sumaIva += $doc['iva'];
            $sumaImpuesto += $doc['montoImpuesto'];
            $sumaTotal += $doc['bruto'];
          }


          //$sumaNeto = number_format($sumaNeto, 0, ',', '.');
          $sumaExento = number_format($sumaExento, 0, ',', '.');
          //$sumaIva = number_format($sumaIva, 0, ',', '.');
          $sumaImpuesto = number_format($sumaImpuesto, 0, ',', '.');
          $sumaTotal = number_format($sumaTotal, 0, ',', '.');

          $estructura .= "<tr>
                        <td><strong></strong></td>
                        <td><strong></strong></td>
                        <td><strong></strong></td>
                        <td><strong></strong></td>";
          if($tieneReferencia){
            $estructura .= "<td><strong></strong></td>";
          }
          $estructura .= "<td><strong>TOTAL</strong></td>

                        <td><strong>$ {$sumaExento}</strong></td>

                        <td><strong>$ {$sumaImpuesto}</strong></td>
                        <td><strong></strong></td>
                        <td><strong>$ {$sumaTotal}</strong></td>
                      </tr>
                    </table><br><br><br>";
                    // <td><strong>$ {$sumaNeto}</strong></td>
                    // <td><strong>$ {$sumaIva}</strong></td>
          $docPdf->agregarHtml($estructura);
        }

        $archivo = $docPdf->obtener();
    }

    echo base64_encode($archivo);
}

if($accion == 'descargar'){
    $tipo = $_GET['t'];
    $codigo = $_GET['f'];

    $nombre = base64_decode($codigo);
    $archivo = $rutaCarpeta."/".$nombre;

    header("Content-Transfer-Encoding: Binary");

    if($tipo == "excel"){
        header("Content-Type: application/ms-excel");
        header("Content-disposition: attachment; filename=\"LibroDeVentas.xlsx\"");
    }

    if($tipo == "pdf"){
        header('Content-Type: application/pdf');
        header("Content-disposition: attachment; filename=\"LibroDeVentas.pdf\"");
    }

    if(is_file($archivo)){
        readfile($archivo); // do the double-download-dance (dirty but worky)
        unlink($archivo);
    }
}
