var $botonBuscar;
var $botonContar;
var $rut;
var $tabla;
var $ventana;
var $cargando = "<div class=\"progress\"> \
                    <div class=\"progress-bar progress-bar-warning progress-bar-striped active\" role=\"progressbar\" aria-valuenow=\"100\" aria-valuemin=\"0\" aria-valuemax=\"100\" style=\"width: 100%\">\
                        <span class=\"sr-only\">100% Complete</span> \
                    </div> \
                    </div>";
var datos = {};

function setDatos(){
	var f = document.getElementById("form_soporte");
	error = 0;
	$.each(f.elements, function(idx, campo){
		$parent = $(campo).parents('.form-group');
		if(campo.name !== ""){
			if(campo.checkValidity()){
				if($parent.hasClass('has-error')){
					$parent.removeClass('has-error');
				}
				datos[campo.name] = campo.value;
			}
			else {
				campo.focus();
				$parent.addClass('has-error');
				error++;
			}
		}
	});
	return (error == 0);
}

function imprimir(){
	
	id = document.getElementById('id').value;
	rut_empresa = document.getElementById('rut_empresa').value;
	rs = document.getElementById('rs').value;
	contacto = document.getElementById('contacto').value;
	fonos = document.getElementById('fonos').value;
	correo = document.getElementById('correo').value;
	nivel = document.getElementById('nivel').value;
	estado = document.getElementById('estado').value;
	id_empleado = document.getElementById('id_empleado').value;
	problema = document.getElementById('problema').value;
	solucion = document.getElementById('solucion').value;
	observaciones = document.getElementById('observaciones').value;
	//alert("antes de datos");
	datos = "imprimir.php?id="+id+"&rut_empresa="+rut_empresa+"&rs="+rs+"&contacto="+contacto+"&fonos="+fonos+"&correo="+correo+"&nivel="+nivel+"&estado="+estado+"&id_empleado="+id_empleado
				+"&problema="+problema+"&solucion="+solucion+"&observaciones="+observaciones;
	//alert("antes de window");
	window.open(datos,"_blank");
	//alert('despues');
}

function setTabla(t){
	$tabla = t;
}

function aceptar(){

	var nuevo = datos.id == 0;
	if(!setDatos()){
		return false;
	}
	$.ajax({
		method: "POST",
		url: "librerias/ajax.php",
		data: datos,
		success: function(r){
			resp = JSON.parse(r);
			s = resp.datos;
			var fila = buscarFila(s.id);
			if(resp.total == 0){
				$tabla.row(fila).remove().draw(false);
			}
			else {
				colores = {
					"ALTA": "danger"
					, "MEDIA": "warning"
					, "BAJA": "success"
				};
				color = colores[s.prioridad];
				var columnas = [
					'<button type="button" class="btn btn-success btn-xs" data-toggle="modal" data-target="#md-ticket" data-ticket-id="'+s.id+'" data-accion="ver">Ver</button> \
					<button type="button" class="btn btn-warning btn-xs"  data-toggle="modal" data-target="#md-ticket" data-ticket-id="'+s.id+'" data-accion="modificar">Editar</button>'
					,'<b><a href="index.php?accion=modificar&id='+s.id+'" target="_blank">Ticket: '+s.id+'</a></b><br>'+s.fecha+'<BR>'+s.hora+'\
					<br><span class="label label-'+color+'">'+s.prioridad+'</span>'
					,'<b>'+s.contacto+'</b><br>'+s.rs+'<br>Fonos:'+s.fonos+'<br>Correo:'+s.correo
					, s.problema
					, 'Nivel '+s.nivel+'<br> \
					<u>Estado:</u><br>'+s.estado_ticket+'<br>\
					<u>Respuesta:</u><br>'+s.solucion
					, s.estado
					, s.nivel
					, s.id_empleado_asignado
					, s.prioridad
				];
				if(typeof resp.nuevo !== "undefined" && resp.nuevo == true){
					insertarElemento(columnas);
				}
				else {
					$tabla.row(fila).data(columnas);
				}
				$tabla.order([1, 'desc']).draw(false);
			}
			$('#md-ticket').modal('hide');
		}
	});
}

function enviarEmail(id){
	$.ajax({
		method: "POST",
		url: "librerias/email.php",
		data: { id: id
			, accion: 'enviarEmail' },
		success: function(d){
			alert(d);
			if(d.indexOf("OK") !== -1){
				$('#boton-email').hide();
			}
		}
	});
}

function buscarEmpresa(){
	if($rut.attr('disabled')){
		$rut.attr('disabled', false);
		$('#rs').attr('disabled', false);
		$botonBuscar.text('Buscar');
		return false;
	}
	
	if($rut.val() == ''){
		alert("Ingresar rut!");
		$rut.focus();
		return false;
	}
	
	datos = {
			accion: 'buscarEmpresa'
			, rut: $rut.val()
		}
	;
	$.ajax({
		method: "POST",
		url: "librerias/buscar.php",
		data: datos,
		success: function(d){
			if(d.n > 0){
				$botonBuscar.text('Volver a Buscar');
				$('#id_empresa').val(d.empresa.id_empresa);
				$rut
					.val(d.empresa.rut)
					.attr('disabled', true);
				$('#rut_empresa_s').val(d.empresa.rut);
				$('#rs')
					.val(d.empresa.rs)
					.attr('disabled', true);
				$('#rs_s').val(d.empresa.rs);
			}
			else {
				alert('No se encontró la empresa!');
			}
		}
	});
}

var cuenta;

function contar(){
	$divTiempo = $('#divTiempo');
	var t = 0;
	if($botonContar.hasClass('btn-primary')){
		$botonContar
			.removeClass('btn-primary')
			.addClass('btn-danger')
			.text('Detener');
		cuenta = setInterval(function () {
			  ++t;
			  if(t > 59){
				  $divTiempo.text(Math.floor(t/60) + " min. " + (t % 60) + ' seg.');
			  }
			  else {
				  $divTiempo.text(t + " seg.");
			  }
			  $('#tiempo').val(t);
			}, 1000);
	}
	else {
		$botonContar
			.removeClass('btn-danger')
			.addClass('btn-primary')
			.text('Iniciar');
		clearInterval(cuenta);
	}
}


function buscarFila(id) {
	var filas = $tabla.rows().indexes();
	var columna = 1; //columna contenedora del id buscado
	for(i = 0; i < filas.length; i++){
		data = $tabla.row(i).data();
		if(data[columna].indexOf(id) !== -1 || data[columna] == id){
			break;
		}
	}
	return i;
}

function insertarElemento(elm) {

	$tabla.row.add(elm).draw(false);
	return true;
}

/*
* Remover detalle de la datatabble
*/
function removerElemento(id) {

	var fila = buscarFila(id);
	$tabla.row(fila).remove().draw(false);

	return true;
}

document.addEventListener("DOMContentLoaded", function(event) {
	$botonBuscar = $('.buscar');
	$botonContar = $('.contador');
	$rut = $('#rut_empresa');
	$tabla = $('#dt-tickets').DataTable({
		"columnDefs": [
            {
                "targets": [5,6,7,8],
                "visible": false
			}
		]
	});
	
	//filtros
	$('#estado').on( 'change', function (e) {
		e.preventDefault();		
		$tabla.column(5).search(
		        $(this).val(),
		        false,
		        true
		    ).draw();
	} );
		
	$('#nivel').on( 'change', function (e) {
		e.preventDefault();
		$tabla.column(6).search(
		        $(this).val(),
		        false,
		        true
		    ).draw();
	} );

	$('#empleado').on( 'change', function (e) {
		e.preventDefault();
		$tabla.column(7).search(
		        $(this).val(),
		        false,
		        true
		    ).draw();
	} );

	$('#prioridad').on( 'change', function (e) {
		e.preventDefault();
		$tabla.column(8).search(
		        $(this).val(),
		        false,
		        true
		    ).draw();
	} );
	
	//modal
	$("#md-ticket").on('shown.bs.modal', function(event){
		var button = $(event.relatedTarget);
		var ticketId = button.data('ticket-id');
		var accion = button.data('accion');
		var modal = $(this);
		$.ajax( {
			method: "GET",
			url: "vistas/formulario.php",
			data: {
				id: ticketId
				, accion: accion
			},
			success: function(resp){
				modal.find('.modal-content').html(resp);
				$rut = modal.find('#rut_empresa');
				$botonBuscar = modal.find('.buscar');
				$botonContar = modal.find('.contador');
			}
		});
	});

	$("#md-ticket").on('hidden.bs.modal', function(event){
		$(this).find('.modal-content').html($cargando);
	})
});